
#define  COL_W         1
#define  COL_S       129

#define  AB_ZUGL     512    /*  Laenge der Zugliste pro Zug              */
#define  AB_ZUG_S    256    /*  Beginn der Schlagzuege in Zugliste       */
#define  WAZ       COL_W    /*  Weiss am Zug                             */
#define  SAZ       COL_S    /*  Schwarz am Zug                           */
#define  KAZ           0    /*  Keiner am Zug                            */


#define  OL            9     /********************************************/
#define  OM           10     /*                                          */
#define  OR           11     /*            OL |  OM  | OR                */
#define  LI           -1     /*           ----+------+----               */
#define  RE            1     /*            LI | FELD | RE                */
#define  UL          -11     /*           ----+------+----               */
#define  UM          -10     /*            UL |  UM  | UR                */
#define  UR           -9     /********************************************/

/*************************************************************************/
/*                         Figuren                                       */
/*************************************************************************/
/*                                                                       */
/*      weiss   32 + x      x = 1  Bauer                                 */
/*      schwarz 64 + x          2  Springer                              */
/*      leer    0               3  Laeufer                               */
/*      illegal 16              4  Turm                                  */
/*                              5  Dame                                  */
/*                              6  Koenig                                */
/*                                                                       */
/*************************************************************************/

#define WB      33          /*  weisser Bauer                            */
#define WS      34
#define WL      35
#define WT      36
#define WD      37
#define WK      38
#define SB      65
#define SS      66
#define SL      67
#define ST      68
#define SD      69
#define SK      70          /*  schwarzer Koenig                         */
#define LEER     0          /*  leer                                     */
#define RAND    16          /*  Rand (illegal )                          */

#define WFIGUR(c) ( (c) & 32 )
#define SFIGUR(c) ( (c) & 64 )
#define ch_amzug() {if(stp->amzug==WAZ)stp->amzug=SAZ;else stp->amzug=WAZ;}

/****************************************************************/
/*                      Felder                                  */
/****************************************************************/

#define A1 21
#define B1 22
#define C1 23
#define D1 24
#define E1 25
#define F1 26
#define G1 27
#define H1 28
#define A2 31
#define B2 32
#define C2 33
#define D2 34
#define E2 35
#define F2 36
#define G2 37
#define H2 38
#define A3 41
#define B3 42
#define C3 43
#define D3 44
#define E3 45
#define F3 46
#define G3 47
#define H3 48
#define A4 51
#define B4 52
#define C4 53
#define D4 54
#define E4 55
#define F4 56
#define G4 57
#define H4 58
#define A5 61
#define B5 62
#define C5 63
#define D5 64
#define E5 65
#define F5 66
#define G5 67
#define H5 68
#define A6 71
#define B6 72
#define C6 73
#define D6 74
#define E6 75
#define F6 76
#define G6 77
#define H6 78
#define A7 81
#define B7 82
#define C7 83
#define D7 84
#define E7 85
#define F7 86
#define G7 87
#define H7 88
#define A8 91
#define B8 92
#define C8 93
#define D8 94
#define E8 95
#define F8 96
#define G8 97
#define H8 98

