/* is king in check? */
#include <glib.h>
#include "portab.h"
#include "pro.h"
#include "var.h"
#include "makros.h"
#include "ckis.h"

#define CHECK(king_place,direction,piece1,piece2)\
{  int 	i= king_place; \
   do { i += direction; } \
   while(!feld[i]); \
   if (feld[i] == piece1) return piece1; \
   if (feld[i] == piece2) return piece2; \
}

static int long4(int ort,int r1,int r2,int r3,int r4,int f1,int f2)
{

  CHECK(ort,r1,f1,f2);
  CHECK(ort,r2,f1,f2);
  CHECK(ort,r3,f1,f2);
  CHECK(ort,r4,f1,f2);
  return FALSE;
}   

#define KURZ_TEST(r)   if (feld[ort+r] == f1) return f1

static int short8(int ort,int r1,int r2,int r3,int r4,int r5,int r6,int r7,int r8,int f1)
{
  KURZ_TEST(r1);
  KURZ_TEST(r2);
  KURZ_TEST(r3);
  KURZ_TEST(r4);
  KURZ_TEST(r5);
  KURZ_TEST(r6);
  KURZ_TEST(r7);
  KURZ_TEST(r8);

  return FALSE;
}	
      


int king_is_attacked_white()
{
   int ret;
   int k= stp->wki;

   ret = long4(k,9,11,-9,-11,SD,SL);
   if (ret) return ret;
   
   ret = long4(k,1,10,-10,-1,SD,ST);
   if (ret) return ret;
   
   if( short8(k,8,12,19,21,-8,-12,-19,-21,SS)) return SS;
   if( short8(k,9,11,-9,-11,1,10,-10,-1,SK)) return SK;
   
   if (feld[k+OL] == SB)
   	return SB;
   if (feld[k+OR] == SB)
   	return SB;


   return FALSE;
}

int king_is_attacked_black(void)
{
   int ret;
   int k = stp->ski;
	
   ret = long4(k,9,11,-9,-11,WD,WL);
   if (ret) return ret;
   
   ret = long4(k,1,10,-10,-1,WD,WT);
   if (ret) return ret;
   
   if( short8(k,8,12,19,21,-8,-12,-19,-21,WS)) return WS;
   if( short8(k,9,11,-9,-11,1,10,-10,-1,WK)) return WK;
   
   if (feld[k+UL] == WB)
   	return WB;
   if (feld[k+UR] == WB)
   	return WB;

   return FALSE;
}
