/* math-window.c generated by valac 0.20.1, the Vala compiler
 * generated from math-window.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
typedef struct _MathWindowPrivate MathWindowPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUTTON_MODE (button_mode_get_type ())

struct _MathWindow {
	GtkApplicationWindow parent_instance;
	MathWindowPrivate * priv;
};

struct _MathWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MathWindowPrivate {
	MathEquation* _equation;
	MathDisplay* _display;
	MathButtons* _buttons;
	gboolean right_aligned;
};

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;


static gpointer math_window_parent_class = NULL;

GType math_window_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_display_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
#define MATH_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_WINDOW, MathWindowPrivate))
enum  {
	MATH_WINDOW_DUMMY_PROPERTY,
	MATH_WINDOW_EQUATION,
	MATH_WINDOW_DISPLAY,
	MATH_WINDOW_BUTTONS
};
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self);
static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
MathDisplay* math_window_get_display (MathWindow* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
MathButtons* math_window_get_buttons (MathWindow* self);
void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents);
static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
GType button_mode_get_type (void) G_GNUC_CONST;
ButtonMode math_buttons_get_mode (MathButtons* self);
MathEquation* math_window_get_equation (MathWindow* self);
void math_equation_set_number_base (MathEquation* self, gint value);
static void math_window_finalize (GObject* obj);
static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self) {
	math_window_scroll_changed_cb (self, _sender);
}


static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	math_window_scroll_value_changed_cb (self, _sender);
}


MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation) {
	MathWindow * self = NULL;
	GtkApplication* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkBox* main_vbox;
	GtkBox* _tmp5_;
	GtkBox* vbox;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* scrolled_window;
	GtkAdjustment* _tmp7_ = NULL;
	GtkAdjustment* _tmp8_ = NULL;
	MathEquation* _tmp9_;
	MathDisplay* _tmp10_;
	MathDisplay* _tmp11_;
	MathDisplay* _tmp12_;
	MathDisplay* _tmp13_;
	MathDisplay* _tmp14_;
	MathEquation* _tmp15_;
	MathButtons* _tmp16_;
	MathButtons* _tmp17_;
	MathButtons* _tmp18_;
	MathButtons* _tmp19_;
	MathButtons* _tmp20_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = app;
	self = (MathWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_tmp1_ = equation;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp2_;
	_tmp3_ = _ ("Calculator");
	gtk_window_set_title ((GtkWindow*) self, _tmp3_);
	gtk_window_set_role ((GtkWindow*) self, "gnome-calculator");
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp4_);
	main_vbox = _tmp4_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vbox);
	gtk_widget_show ((GtkWidget*) main_vbox);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp5_);
	vbox = _tmp5_;
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 6);
	gtk_box_pack_start (main_vbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp6_);
	scrolled_window = _tmp6_;
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_box_pack_start (vbox, (GtkWidget*) scrolled_window, FALSE, FALSE, (guint) 0);
	_tmp7_ = gtk_scrolled_window_get_hadjustment (scrolled_window);
	g_signal_connect_object (_tmp7_, "changed", (GCallback) _math_window_scroll_changed_cb_gtk_adjustment_changed, self, 0);
	_tmp8_ = gtk_scrolled_window_get_hadjustment (scrolled_window);
	g_signal_connect_object (_tmp8_, "value-changed", (GCallback) _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed, self, 0);
	self->priv->right_aligned = TRUE;
	gtk_widget_show ((GtkWidget*) scrolled_window);
	_tmp9_ = equation;
	_tmp10_ = math_display_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp10_;
	_tmp11_ = math_window_get_display (self);
	_tmp12_ = _tmp11_;
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp12_);
	_tmp13_ = math_window_get_display (self);
	_tmp14_ = _tmp13_;
	gtk_widget_show ((GtkWidget*) _tmp14_);
	_tmp15_ = equation;
	_tmp16_ = math_buttons_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_buttons);
	self->priv->_buttons = _tmp16_;
	_tmp17_ = math_window_get_buttons (self);
	_tmp18_ = _tmp17_;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = math_window_get_buttons (self);
	_tmp20_ = _tmp19_;
	gtk_widget_show ((GtkWidget*) _tmp20_);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (vbox);
	_g_object_unref0 (main_vbox);
	return self;
}


MathWindow* math_window_new (GtkApplication* app, MathEquation* equation) {
	return math_window_construct (TYPE_MATH_WINDOW, app, equation);
}


void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents) {
	const gchar* _tmp0_;
	GtkMessageDialog* _tmp1_;
	GtkMessageDialog* dialog;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = title;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = contents;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp2_);
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_QUIT, GTK_RESPONSE_ACCEPT, NULL);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) self);
	_g_object_unref0 (dialog);
}


static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathWindow * self;
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _result_;
	gboolean _tmp2_ = FALSE;
	MathButtons* _tmp3_;
	MathButtons* _tmp4_;
	ButtonMode _tmp5_;
	ButtonMode _tmp6_;
	gboolean _tmp9_;
	self = (MathWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = GTK_WIDGET_CLASS (math_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION_WINDOW, GtkApplicationWindow), &_tmp0_);
	_result_ = _tmp1_;
	_tmp3_ = math_window_get_buttons (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = math_buttons_get_mode (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == BUTTON_MODE_PROGRAMMING) {
		GdkEventKey _tmp7_;
		GdkModifierType _tmp8_;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.state;
		_tmp2_ = (_tmp8_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		GdkEventKey _tmp10_;
		guint _tmp11_;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.keyval;
		switch (_tmp11_) {
			case GDK_KEY_b:
			{
				MathEquation* _tmp12_;
				MathEquation* _tmp13_;
				_tmp12_ = math_window_get_equation (self);
				_tmp13_ = _tmp12_;
				math_equation_set_number_base (_tmp13_, 2);
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				MathEquation* _tmp14_;
				MathEquation* _tmp15_;
				_tmp14_ = math_window_get_equation (self);
				_tmp15_ = _tmp14_;
				math_equation_set_number_base (_tmp15_, 8);
				result = TRUE;
				return result;
			}
			case GDK_KEY_d:
			{
				MathEquation* _tmp16_;
				MathEquation* _tmp17_;
				_tmp16_ = math_window_get_equation (self);
				_tmp17_ = _tmp16_;
				math_equation_set_number_base (_tmp17_, 10);
				result = TRUE;
				return result;
			}
			case GDK_KEY_h:
			{
				MathEquation* _tmp18_;
				MathEquation* _tmp19_;
				_tmp18_ = math_window_get_equation (self);
				_tmp19_ = _tmp18_;
				math_equation_set_number_base (_tmp19_, 16);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	result = _result_;
	return result;
}


static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->right_aligned;
	if (_tmp0_) {
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		gdouble _tmp3_ = 0.0;
		GtkAdjustment* _tmp4_;
		gdouble _tmp5_ = 0.0;
		_tmp1_ = adjustment;
		_tmp2_ = adjustment;
		_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
		_tmp4_ = adjustment;
		_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
		gtk_adjustment_set_value (_tmp1_, _tmp3_ - _tmp5_);
	}
}


static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
	GtkAdjustment* _tmp2_;
	gdouble _tmp3_ = 0.0;
	GtkAdjustment* _tmp4_;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = adjustment;
	_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
	_tmp4_ = adjustment;
	_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
	if (_tmp1_ == (_tmp3_ - _tmp5_)) {
		self->priv->right_aligned = TRUE;
	} else {
		self->priv->right_aligned = FALSE;
	}
}


MathEquation* math_window_get_equation (MathWindow* self) {
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


MathDisplay* math_window_get_display (MathWindow* self) {
	MathDisplay* result;
	MathDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


MathButtons* math_window_get_buttons (MathWindow* self) {
	MathButtons* result;
	MathButtons* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buttons;
	result = _tmp0_;
	return result;
}


static void math_window_class_init (MathWindowClass * klass) {
	math_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathWindowPrivate));
	GTK_WIDGET_CLASS (klass)->key_press_event = math_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_window_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_DISPLAY, g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_BUTTONS, g_param_spec_object ("buttons", "buttons", "buttons", TYPE_MATH_BUTTONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_window_instance_init (MathWindow * self) {
	self->priv = MATH_WINDOW_GET_PRIVATE (self);
}


static void math_window_finalize (GObject* obj) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_buttons);
	G_OBJECT_CLASS (math_window_parent_class)->finalize (obj);
}


GType math_window_get_type (void) {
	static volatile gsize math_window_type_id__volatile = 0;
	if (g_once_init_enter (&math_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathWindow), 0, (GInstanceInitFunc) math_window_instance_init, NULL };
		GType math_window_type_id;
		math_window_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "MathWindow", &g_define_type_info, 0);
		g_once_init_leave (&math_window_type_id__volatile, math_window_type_id);
	}
	return math_window_type_id__volatile;
}


static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
	switch (property_id) {
		case MATH_WINDOW_EQUATION:
		g_value_set_object (value, math_window_get_equation (self));
		break;
		case MATH_WINDOW_DISPLAY:
		g_value_set_object (value, math_window_get_display (self));
		break;
		case MATH_WINDOW_BUTTONS:
		g_value_set_object (value, math_window_get_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



