/* equation-lexer.c generated by valac 0.18.1, the Vala compiler
 * generated from equation-lexer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Enum for tokens generated by pre-lexer and lexer. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_LEXER_TOKEN_TYPE (lexer_token_type_get_type ())

#define TYPE_PRE_LEXER (pre_lexer_get_type ())
#define PRE_LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRE_LEXER, PreLexer))
#define PRE_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRE_LEXER, PreLexerClass))
#define IS_PRE_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRE_LEXER))
#define IS_PRE_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRE_LEXER))
#define PRE_LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRE_LEXER, PreLexerClass))

typedef struct _PreLexer PreLexer;
typedef struct _PreLexerClass PreLexerClass;
typedef struct _PreLexerPrivate PreLexerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPreLexer ParamSpecPreLexer;

#define TYPE_LEXER_TOKEN (lexer_token_get_type ())
#define LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER_TOKEN, LexerToken))
#define LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER_TOKEN, LexerTokenClass))
#define IS_LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER_TOKEN))
#define IS_LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER_TOKEN))
#define LEXER_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER_TOKEN, LexerTokenClass))

typedef struct _LexerToken LexerToken;
typedef struct _LexerTokenClass LexerTokenClass;
typedef struct _LexerTokenPrivate LexerTokenPrivate;
typedef struct _ParamSpecLexerToken ParamSpecLexerToken;

#define TYPE_LEXER (lexer_get_type ())
#define LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER, Lexer))
#define LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER, LexerClass))
#define IS_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER))
#define IS_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER))
#define LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER, LexerClass))

typedef struct _Lexer Lexer;
typedef struct _LexerClass LexerClass;
typedef struct _LexerPrivate LexerPrivate;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _pre_lexer_unref0(var) ((var == NULL) ? NULL : (var = (pre_lexer_unref (var), NULL)))
#define __g_list_free__lexer_token_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__lexer_token_unref0_ (var), NULL)))
#define _lexer_token_unref0(var) ((var == NULL) ? NULL : (var = (lexer_token_unref (var), NULL)))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))

#define TYPE_ERROR_CODE (error_code_get_type ())
typedef struct _ParamSpecLexer ParamSpecLexer;

typedef enum  {
	LEXER_TOKEN_TYPE_UNKNOWN,
	LEXER_TOKEN_TYPE_PL_DECIMAL,
	LEXER_TOKEN_TYPE_PL_DIGIT,
	LEXER_TOKEN_TYPE_PL_HEX,
	LEXER_TOKEN_TYPE_PL_SUPER_DIGIT,
	LEXER_TOKEN_TYPE_PL_SUPER_MINUS,
	LEXER_TOKEN_TYPE_PL_SUB_DIGIT,
	LEXER_TOKEN_TYPE_PL_FRACTION,
	LEXER_TOKEN_TYPE_PL_DEGREE,
	LEXER_TOKEN_TYPE_PL_MINUTE,
	LEXER_TOKEN_TYPE_PL_SECOND,
	LEXER_TOKEN_TYPE_PL_LETTER,
	LEXER_TOKEN_TYPE_PL_EOS,
	LEXER_TOKEN_TYPE_PL_SKIP,
	LEXER_TOKEN_TYPE_ADD,
	LEXER_TOKEN_TYPE_SUBTRACT,
	LEXER_TOKEN_TYPE_MULTIPLY,
	LEXER_TOKEN_TYPE_DIVIDE,
	LEXER_TOKEN_TYPE_MOD,
	LEXER_TOKEN_TYPE_L_FLOOR,
	LEXER_TOKEN_TYPE_R_FLOOR,
	LEXER_TOKEN_TYPE_L_CEILING,
	LEXER_TOKEN_TYPE_R_CEILING,
	LEXER_TOKEN_TYPE_ROOT,
	LEXER_TOKEN_TYPE_ROOT_3,
	LEXER_TOKEN_TYPE_ROOT_4,
	LEXER_TOKEN_TYPE_NOT,
	LEXER_TOKEN_TYPE_AND,
	LEXER_TOKEN_TYPE_OR,
	LEXER_TOKEN_TYPE_XOR,
	LEXER_TOKEN_TYPE_IN,
	LEXER_TOKEN_TYPE_NUMBER,
	LEXER_TOKEN_TYPE_SUP_NUMBER,
	LEXER_TOKEN_TYPE_NSUP_NUMBER,
	LEXER_TOKEN_TYPE_SUB_NUMBER,
	LEXER_TOKEN_TYPE_FUNCTION,
	LEXER_TOKEN_TYPE_VARIABLE,
	LEXER_TOKEN_TYPE_ASSIGN,
	LEXER_TOKEN_TYPE_L_R_BRACKET,
	LEXER_TOKEN_TYPE_R_R_BRACKET,
	LEXER_TOKEN_TYPE_L_S_BRACKET,
	LEXER_TOKEN_TYPE_R_S_BRACKET,
	LEXER_TOKEN_TYPE_L_C_BRACKET,
	LEXER_TOKEN_TYPE_R_C_BRACKET,
	LEXER_TOKEN_TYPE_ABS,
	LEXER_TOKEN_TYPE_POWER,
	LEXER_TOKEN_TYPE_FACTORIAL,
	LEXER_TOKEN_TYPE_PERCENTAGE
} LexerTokenType;

struct _PreLexer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PreLexerPrivate * priv;
	gchar* stream;
	gint index;
	gint mark_index;
};

struct _PreLexerClass {
	GTypeClass parent_class;
	void (*finalize) (PreLexer *self);
};

struct _PreLexerPrivate {
	gboolean eos;
};

struct _ParamSpecPreLexer {
	GParamSpec parent_instance;
};

struct _LexerToken {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LexerTokenPrivate * priv;
	gchar* text;
	guint start_index;
	guint end_index;
	LexerTokenType type;
};

struct _LexerTokenClass {
	GTypeClass parent_class;
	void (*finalize) (LexerToken *self);
};

struct _ParamSpecLexerToken {
	GParamSpec parent_instance;
};

struct _Lexer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LexerPrivate * priv;
	GList* tokens;
};

struct _LexerClass {
	GTypeClass parent_class;
	void (*finalize) (Lexer *self);
};

struct _LexerPrivate {
	Parser* parser;
	PreLexer* prelexer;
	guint next_token;
	gint number_base;
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _ParamSpecLexer {
	GParamSpec parent_instance;
};


static gpointer pre_lexer_parent_class = NULL;
static gpointer lexer_token_parent_class = NULL;
static gpointer lexer_parent_class = NULL;

GType lexer_token_type_get_type (void) G_GNUC_CONST;
gpointer pre_lexer_ref (gpointer instance);
void pre_lexer_unref (gpointer instance);
GParamSpec* param_spec_pre_lexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pre_lexer (GValue* value, gpointer v_object);
void value_take_pre_lexer (GValue* value, gpointer v_object);
gpointer value_get_pre_lexer (const GValue* value);
GType pre_lexer_get_type (void) G_GNUC_CONST;
#define PRE_LEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRE_LEXER, PreLexerPrivate))
enum  {
	PRE_LEXER_DUMMY_PROPERTY
};
PreLexer* pre_lexer_new (const gchar* input);
PreLexer* pre_lexer_construct (GType object_type, const gchar* input);
void pre_lexer_roll_back (PreLexer* self);
void pre_lexer_set_marker (PreLexer* self);
gchar* pre_lexer_get_marked_substring (PreLexer* self);
LexerTokenType pre_lexer_get_next_token (PreLexer* self);
static void pre_lexer_finalize (PreLexer* obj);
gpointer lexer_token_ref (gpointer instance);
void lexer_token_unref (gpointer instance);
GParamSpec* param_spec_lexer_token (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lexer_token (GValue* value, gpointer v_object);
void value_take_lexer_token (GValue* value, gpointer v_object);
gpointer value_get_lexer_token (const GValue* value);
GType lexer_token_get_type (void) G_GNUC_CONST;
enum  {
	LEXER_TOKEN_DUMMY_PROPERTY
};
LexerToken* lexer_token_new (void);
LexerToken* lexer_token_construct (GType object_type);
static void lexer_token_finalize (LexerToken* obj);
gpointer lexer_ref (gpointer instance);
void lexer_unref (gpointer instance);
GParamSpec* param_spec_lexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lexer (GValue* value, gpointer v_object);
void value_take_lexer (GValue* value, gpointer v_object);
gpointer value_get_lexer (const GValue* value);
GType lexer_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
#define LEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LEXER, LexerPrivate))
enum  {
	LEXER_DUMMY_PROPERTY
};
static void _lexer_token_unref0_ (gpointer var);
static void _g_list_free__lexer_token_unref0_ (GList* self);
Lexer* lexer_new (const gchar* input, Parser* parser, gint number_base);
Lexer* lexer_construct (GType object_type, const gchar* input, Parser* parser, gint number_base);
void lexer_scan (Lexer* self);
static LexerToken* lexer_insert_next_token (Lexer* self);
LexerToken* lexer_get_next_token (Lexer* self);
void lexer_roll_back (Lexer* self);
static gboolean lexer_check_if_function (Lexer* self);
gboolean parser_function_is_defined (Parser* self, const gchar* name);
static gboolean lexer_check_if_number (Lexer* self);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* mp_set_from_string (const gchar* str, gint default_base);
static LexerToken* lexer_insert_token (Lexer* self, LexerTokenType type);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
static LexerToken* lexer_insert_digit (Lexer* self);
static LexerToken* lexer_insert_decimal (Lexer* self);
static LexerToken* lexer_insert_hex (Lexer* self);
static LexerToken* lexer_insert_letter (Lexer* self);
static LexerToken* lexer_insert_angle_num_dm (Lexer* self);
static LexerToken* lexer_insert_angle_num_dms (Lexer* self);
static LexerToken* lexer_insert_hex_dec (Lexer* self);
static LexerToken* lexer_insert_decimal_hex (Lexer* self);
static void lexer_finalize (Lexer* obj);


GType lexer_token_type_get_type (void) {
	static volatile gsize lexer_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{LEXER_TOKEN_TYPE_UNKNOWN, "LEXER_TOKEN_TYPE_UNKNOWN", "unknown"}, {LEXER_TOKEN_TYPE_PL_DECIMAL, "LEXER_TOKEN_TYPE_PL_DECIMAL", "pl-decimal"}, {LEXER_TOKEN_TYPE_PL_DIGIT, "LEXER_TOKEN_TYPE_PL_DIGIT", "pl-digit"}, {LEXER_TOKEN_TYPE_PL_HEX, "LEXER_TOKEN_TYPE_PL_HEX", "pl-hex"}, {LEXER_TOKEN_TYPE_PL_SUPER_DIGIT, "LEXER_TOKEN_TYPE_PL_SUPER_DIGIT", "pl-super-digit"}, {LEXER_TOKEN_TYPE_PL_SUPER_MINUS, "LEXER_TOKEN_TYPE_PL_SUPER_MINUS", "pl-super-minus"}, {LEXER_TOKEN_TYPE_PL_SUB_DIGIT, "LEXER_TOKEN_TYPE_PL_SUB_DIGIT", "pl-sub-digit"}, {LEXER_TOKEN_TYPE_PL_FRACTION, "LEXER_TOKEN_TYPE_PL_FRACTION", "pl-fraction"}, {LEXER_TOKEN_TYPE_PL_DEGREE, "LEXER_TOKEN_TYPE_PL_DEGREE", "pl-degree"}, {LEXER_TOKEN_TYPE_PL_MINUTE, "LEXER_TOKEN_TYPE_PL_MINUTE", "pl-minute"}, {LEXER_TOKEN_TYPE_PL_SECOND, "LEXER_TOKEN_TYPE_PL_SECOND", "pl-second"}, {LEXER_TOKEN_TYPE_PL_LETTER, "LEXER_TOKEN_TYPE_PL_LETTER", "pl-letter"}, {LEXER_TOKEN_TYPE_PL_EOS, "LEXER_TOKEN_TYPE_PL_EOS", "pl-eos"}, {LEXER_TOKEN_TYPE_PL_SKIP, "LEXER_TOKEN_TYPE_PL_SKIP", "pl-skip"}, {LEXER_TOKEN_TYPE_ADD, "LEXER_TOKEN_TYPE_ADD", "add"}, {LEXER_TOKEN_TYPE_SUBTRACT, "LEXER_TOKEN_TYPE_SUBTRACT", "subtract"}, {LEXER_TOKEN_TYPE_MULTIPLY, "LEXER_TOKEN_TYPE_MULTIPLY", "multiply"}, {LEXER_TOKEN_TYPE_DIVIDE, "LEXER_TOKEN_TYPE_DIVIDE", "divide"}, {LEXER_TOKEN_TYPE_MOD, "LEXER_TOKEN_TYPE_MOD", "mod"}, {LEXER_TOKEN_TYPE_L_FLOOR, "LEXER_TOKEN_TYPE_L_FLOOR", "l-floor"}, {LEXER_TOKEN_TYPE_R_FLOOR, "LEXER_TOKEN_TYPE_R_FLOOR", "r-floor"}, {LEXER_TOKEN_TYPE_L_CEILING, "LEXER_TOKEN_TYPE_L_CEILING", "l-ceiling"}, {LEXER_TOKEN_TYPE_R_CEILING, "LEXER_TOKEN_TYPE_R_CEILING", "r-ceiling"}, {LEXER_TOKEN_TYPE_ROOT, "LEXER_TOKEN_TYPE_ROOT", "root"}, {LEXER_TOKEN_TYPE_ROOT_3, "LEXER_TOKEN_TYPE_ROOT_3", "root-3"}, {LEXER_TOKEN_TYPE_ROOT_4, "LEXER_TOKEN_TYPE_ROOT_4", "root-4"}, {LEXER_TOKEN_TYPE_NOT, "LEXER_TOKEN_TYPE_NOT", "not"}, {LEXER_TOKEN_TYPE_AND, "LEXER_TOKEN_TYPE_AND", "and"}, {LEXER_TOKEN_TYPE_OR, "LEXER_TOKEN_TYPE_OR", "or"}, {LEXER_TOKEN_TYPE_XOR, "LEXER_TOKEN_TYPE_XOR", "xor"}, {LEXER_TOKEN_TYPE_IN, "LEXER_TOKEN_TYPE_IN", "in"}, {LEXER_TOKEN_TYPE_NUMBER, "LEXER_TOKEN_TYPE_NUMBER", "number"}, {LEXER_TOKEN_TYPE_SUP_NUMBER, "LEXER_TOKEN_TYPE_SUP_NUMBER", "sup-number"}, {LEXER_TOKEN_TYPE_NSUP_NUMBER, "LEXER_TOKEN_TYPE_NSUP_NUMBER", "nsup-number"}, {LEXER_TOKEN_TYPE_SUB_NUMBER, "LEXER_TOKEN_TYPE_SUB_NUMBER", "sub-number"}, {LEXER_TOKEN_TYPE_FUNCTION, "LEXER_TOKEN_TYPE_FUNCTION", "function"}, {LEXER_TOKEN_TYPE_VARIABLE, "LEXER_TOKEN_TYPE_VARIABLE", "variable"}, {LEXER_TOKEN_TYPE_ASSIGN, "LEXER_TOKEN_TYPE_ASSIGN", "assign"}, {LEXER_TOKEN_TYPE_L_R_BRACKET, "LEXER_TOKEN_TYPE_L_R_BRACKET", "l-r-bracket"}, {LEXER_TOKEN_TYPE_R_R_BRACKET, "LEXER_TOKEN_TYPE_R_R_BRACKET", "r-r-bracket"}, {LEXER_TOKEN_TYPE_L_S_BRACKET, "LEXER_TOKEN_TYPE_L_S_BRACKET", "l-s-bracket"}, {LEXER_TOKEN_TYPE_R_S_BRACKET, "LEXER_TOKEN_TYPE_R_S_BRACKET", "r-s-bracket"}, {LEXER_TOKEN_TYPE_L_C_BRACKET, "LEXER_TOKEN_TYPE_L_C_BRACKET", "l-c-bracket"}, {LEXER_TOKEN_TYPE_R_C_BRACKET, "LEXER_TOKEN_TYPE_R_C_BRACKET", "r-c-bracket"}, {LEXER_TOKEN_TYPE_ABS, "LEXER_TOKEN_TYPE_ABS", "abs"}, {LEXER_TOKEN_TYPE_POWER, "LEXER_TOKEN_TYPE_POWER", "power"}, {LEXER_TOKEN_TYPE_FACTORIAL, "LEXER_TOKEN_TYPE_FACTORIAL", "factorial"}, {LEXER_TOKEN_TYPE_PERCENTAGE, "LEXER_TOKEN_TYPE_PERCENTAGE", "percentage"}, {0, NULL, NULL}};
		GType lexer_token_type_type_id;
		lexer_token_type_type_id = g_enum_register_static ("LexerTokenType", values);
		g_once_init_leave (&lexer_token_type_type_id__volatile, lexer_token_type_type_id);
	}
	return lexer_token_type_type_id__volatile;
}


PreLexer* pre_lexer_construct (GType object_type, const gchar* input) {
	PreLexer* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	self = (PreLexer*) g_type_create_instance (object_type);
	_tmp0_ = input;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->stream);
	self->stream = _tmp1_;
	self->index = 0;
	self->mark_index = 0;
	return self;
}


PreLexer* pre_lexer_new (const gchar* input) {
	return pre_lexer_construct (TYPE_PRE_LEXER, input);
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void pre_lexer_roll_back (PreLexer* self) {
	gboolean _tmp0_;
	gunichar c = 0U;
	const gchar* _tmp1_;
	gunichar _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->eos;
	if (_tmp0_) {
		self->priv->eos = FALSE;
		return;
	}
	_tmp1_ = self->stream;
	string_get_prev_char (_tmp1_, &self->index, &_tmp2_);
	c = _tmp2_;
}


void pre_lexer_set_marker (PreLexer* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	self->mark_index = _tmp0_;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* pre_lexer_get_marked_substring (PreLexer* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->stream;
	_tmp1_ = self->mark_index;
	_tmp2_ = self->index;
	_tmp3_ = self->mark_index;
	_tmp4_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (_tmp2_ - _tmp3_));
	result = _tmp4_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


LexerTokenType pre_lexer_get_next_token (PreLexer* self) {
	LexerTokenType result = 0;
	gunichar c = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gunichar _tmp4_;
	gboolean _tmp6_;
	gunichar _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gunichar _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gunichar _tmp28_;
	gboolean _tmp30_;
	gboolean _tmp32_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp40_;
	gboolean _tmp42_;
	gboolean _tmp44_;
	gboolean _tmp46_;
	gunichar _tmp47_;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gunichar _tmp57_;
	gboolean _tmp59_;
	gboolean _tmp61_;
	gboolean _tmp63_;
	gboolean _tmp65_;
	gboolean _tmp67_;
	gboolean _tmp69_;
	gboolean _tmp71_;
	gboolean _tmp73_;
	gboolean _tmp75_;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	gboolean _tmp89_ = FALSE;
	gunichar _tmp90_;
	gboolean _tmp92_;
	gboolean _tmp94_;
	gboolean _tmp96_;
	gboolean _tmp98_;
	gboolean _tmp100_;
	gboolean _tmp102_;
	gboolean _tmp104_;
	gboolean _tmp106_;
	gboolean _tmp108_;
	gboolean _tmp110_;
	gboolean _tmp112_;
	gboolean _tmp114_;
	gboolean _tmp116_;
	gboolean _tmp118_;
	gunichar _tmp119_;
	gunichar _tmp120_;
	gunichar _tmp121_;
	gboolean _tmp122_ = FALSE;
	gunichar _tmp123_;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp126_;
	gunichar _tmp127_;
	gunichar _tmp128_;
	gboolean _tmp129_ = FALSE;
	gunichar _tmp130_;
	gboolean _tmp132_;
	gboolean _tmp133_ = FALSE;
	gunichar _tmp134_;
	gboolean _tmp136_;
	gunichar _tmp137_;
	gboolean _tmp138_ = FALSE;
	gboolean _tmp139_ = FALSE;
	gunichar _tmp140_;
	gboolean _tmp142_;
	gboolean _tmp144_;
	gboolean _tmp145_ = FALSE;
	gunichar _tmp146_;
	gboolean _tmp148_;
	gboolean _tmp149_ = FALSE;
	gboolean _tmp150_ = FALSE;
	gunichar _tmp151_;
	gboolean _tmp153_;
	gboolean _tmp155_;
	gunichar _tmp156_;
	gunichar _tmp157_;
	gunichar _tmp158_;
	gunichar _tmp159_;
	gunichar _tmp160_;
	gunichar _tmp161_;
	gunichar _tmp162_;
	gunichar _tmp163_;
	gunichar _tmp164_;
	gunichar _tmp165_;
	gunichar _tmp166_;
	gunichar _tmp167_;
	gunichar _tmp168_;
	gunichar _tmp169_;
	gunichar _tmp170_;
	gunichar _tmp171_;
	gunichar _tmp172_;
	gunichar _tmp173_;
	gboolean _tmp174_ = FALSE;
	gboolean _tmp175_ = FALSE;
	gboolean _tmp176_ = FALSE;
	gunichar _tmp177_;
	gboolean _tmp179_;
	gboolean _tmp181_;
	gboolean _tmp183_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->stream;
	_tmp2_ = string_get_next_char (_tmp0_, &self->index, &_tmp1_);
	c = _tmp1_;
	if (!_tmp2_) {
		self->priv->eos = TRUE;
		result = LEXER_TOKEN_TYPE_PL_EOS;
		return result;
	}
	self->priv->eos = FALSE;
	_tmp4_ = c;
	if (_tmp4_ == ((gunichar) ',')) {
		_tmp3_ = TRUE;
	} else {
		gunichar _tmp5_;
		_tmp5_ = c;
		_tmp3_ = _tmp5_ == ((gunichar) '.');
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		result = LEXER_TOKEN_TYPE_PL_DECIMAL;
		return result;
	}
	_tmp7_ = c;
	_tmp8_ = g_unichar_isdigit (_tmp7_);
	if (_tmp8_) {
		result = LEXER_TOKEN_TYPE_PL_DIGIT;
		return result;
	}
	_tmp11_ = c;
	if (_tmp11_ >= ((gunichar) 'a')) {
		gunichar _tmp12_;
		_tmp12_ = c;
		_tmp10_ = _tmp12_ <= ((gunichar) 'f');
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = _tmp10_;
	if (_tmp13_) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		gunichar _tmp15_;
		gboolean _tmp17_;
		_tmp15_ = c;
		if (_tmp15_ >= ((gunichar) 'A')) {
			gunichar _tmp16_;
			_tmp16_ = c;
			_tmp14_ = _tmp16_ <= ((gunichar) 'F');
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		_tmp9_ = _tmp17_;
	}
	_tmp18_ = _tmp9_;
	if (_tmp18_) {
		result = LEXER_TOKEN_TYPE_PL_HEX;
		return result;
	}
	_tmp28_ = c;
	if (_tmp28_ == 8304U) {
		_tmp27_ = TRUE;
	} else {
		gunichar _tmp29_;
		_tmp29_ = c;
		_tmp27_ = _tmp29_ == 185U;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		_tmp26_ = TRUE;
	} else {
		gunichar _tmp31_;
		_tmp31_ = c;
		_tmp26_ = _tmp31_ == 178U;
	}
	_tmp32_ = _tmp26_;
	if (_tmp32_) {
		_tmp25_ = TRUE;
	} else {
		gunichar _tmp33_;
		_tmp33_ = c;
		_tmp25_ = _tmp33_ == 179U;
	}
	_tmp34_ = _tmp25_;
	if (_tmp34_) {
		_tmp24_ = TRUE;
	} else {
		gunichar _tmp35_;
		_tmp35_ = c;
		_tmp24_ = _tmp35_ == 8308U;
	}
	_tmp36_ = _tmp24_;
	if (_tmp36_) {
		_tmp23_ = TRUE;
	} else {
		gunichar _tmp37_;
		_tmp37_ = c;
		_tmp23_ = _tmp37_ == 8309U;
	}
	_tmp38_ = _tmp23_;
	if (_tmp38_) {
		_tmp22_ = TRUE;
	} else {
		gunichar _tmp39_;
		_tmp39_ = c;
		_tmp22_ = _tmp39_ == 8310U;
	}
	_tmp40_ = _tmp22_;
	if (_tmp40_) {
		_tmp21_ = TRUE;
	} else {
		gunichar _tmp41_;
		_tmp41_ = c;
		_tmp21_ = _tmp41_ == 8311U;
	}
	_tmp42_ = _tmp21_;
	if (_tmp42_) {
		_tmp20_ = TRUE;
	} else {
		gunichar _tmp43_;
		_tmp43_ = c;
		_tmp20_ = _tmp43_ == 8312U;
	}
	_tmp44_ = _tmp20_;
	if (_tmp44_) {
		_tmp19_ = TRUE;
	} else {
		gunichar _tmp45_;
		_tmp45_ = c;
		_tmp19_ = _tmp45_ == 8313U;
	}
	_tmp46_ = _tmp19_;
	if (_tmp46_) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_DIGIT;
		return result;
	}
	_tmp47_ = c;
	if (_tmp47_ == 8315U) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_MINUS;
		return result;
	}
	_tmp57_ = c;
	if (_tmp57_ == 8320U) {
		_tmp56_ = TRUE;
	} else {
		gunichar _tmp58_;
		_tmp58_ = c;
		_tmp56_ = _tmp58_ == 8321U;
	}
	_tmp59_ = _tmp56_;
	if (_tmp59_) {
		_tmp55_ = TRUE;
	} else {
		gunichar _tmp60_;
		_tmp60_ = c;
		_tmp55_ = _tmp60_ == 8322U;
	}
	_tmp61_ = _tmp55_;
	if (_tmp61_) {
		_tmp54_ = TRUE;
	} else {
		gunichar _tmp62_;
		_tmp62_ = c;
		_tmp54_ = _tmp62_ == 8323U;
	}
	_tmp63_ = _tmp54_;
	if (_tmp63_) {
		_tmp53_ = TRUE;
	} else {
		gunichar _tmp64_;
		_tmp64_ = c;
		_tmp53_ = _tmp64_ == 8324U;
	}
	_tmp65_ = _tmp53_;
	if (_tmp65_) {
		_tmp52_ = TRUE;
	} else {
		gunichar _tmp66_;
		_tmp66_ = c;
		_tmp52_ = _tmp66_ == 8325U;
	}
	_tmp67_ = _tmp52_;
	if (_tmp67_) {
		_tmp51_ = TRUE;
	} else {
		gunichar _tmp68_;
		_tmp68_ = c;
		_tmp51_ = _tmp68_ == 8326U;
	}
	_tmp69_ = _tmp51_;
	if (_tmp69_) {
		_tmp50_ = TRUE;
	} else {
		gunichar _tmp70_;
		_tmp70_ = c;
		_tmp50_ = _tmp70_ == 8327U;
	}
	_tmp71_ = _tmp50_;
	if (_tmp71_) {
		_tmp49_ = TRUE;
	} else {
		gunichar _tmp72_;
		_tmp72_ = c;
		_tmp49_ = _tmp72_ == 8328U;
	}
	_tmp73_ = _tmp49_;
	if (_tmp73_) {
		_tmp48_ = TRUE;
	} else {
		gunichar _tmp74_;
		_tmp74_ = c;
		_tmp48_ = _tmp74_ == 8329U;
	}
	_tmp75_ = _tmp48_;
	if (_tmp75_) {
		result = LEXER_TOKEN_TYPE_PL_SUB_DIGIT;
		return result;
	}
	_tmp90_ = c;
	if (_tmp90_ == 189U) {
		_tmp89_ = TRUE;
	} else {
		gunichar _tmp91_;
		_tmp91_ = c;
		_tmp89_ = _tmp91_ == 8531U;
	}
	_tmp92_ = _tmp89_;
	if (_tmp92_) {
		_tmp88_ = TRUE;
	} else {
		gunichar _tmp93_;
		_tmp93_ = c;
		_tmp88_ = _tmp93_ == 8532U;
	}
	_tmp94_ = _tmp88_;
	if (_tmp94_) {
		_tmp87_ = TRUE;
	} else {
		gunichar _tmp95_;
		_tmp95_ = c;
		_tmp87_ = _tmp95_ == 188U;
	}
	_tmp96_ = _tmp87_;
	if (_tmp96_) {
		_tmp86_ = TRUE;
	} else {
		gunichar _tmp97_;
		_tmp97_ = c;
		_tmp86_ = _tmp97_ == 190U;
	}
	_tmp98_ = _tmp86_;
	if (_tmp98_) {
		_tmp85_ = TRUE;
	} else {
		gunichar _tmp99_;
		_tmp99_ = c;
		_tmp85_ = _tmp99_ == 8533U;
	}
	_tmp100_ = _tmp85_;
	if (_tmp100_) {
		_tmp84_ = TRUE;
	} else {
		gunichar _tmp101_;
		_tmp101_ = c;
		_tmp84_ = _tmp101_ == 8534U;
	}
	_tmp102_ = _tmp84_;
	if (_tmp102_) {
		_tmp83_ = TRUE;
	} else {
		gunichar _tmp103_;
		_tmp103_ = c;
		_tmp83_ = _tmp103_ == 8535U;
	}
	_tmp104_ = _tmp83_;
	if (_tmp104_) {
		_tmp82_ = TRUE;
	} else {
		gunichar _tmp105_;
		_tmp105_ = c;
		_tmp82_ = _tmp105_ == 8536U;
	}
	_tmp106_ = _tmp82_;
	if (_tmp106_) {
		_tmp81_ = TRUE;
	} else {
		gunichar _tmp107_;
		_tmp107_ = c;
		_tmp81_ = _tmp107_ == 8537U;
	}
	_tmp108_ = _tmp81_;
	if (_tmp108_) {
		_tmp80_ = TRUE;
	} else {
		gunichar _tmp109_;
		_tmp109_ = c;
		_tmp80_ = _tmp109_ == 8538U;
	}
	_tmp110_ = _tmp80_;
	if (_tmp110_) {
		_tmp79_ = TRUE;
	} else {
		gunichar _tmp111_;
		_tmp111_ = c;
		_tmp79_ = _tmp111_ == 8539U;
	}
	_tmp112_ = _tmp79_;
	if (_tmp112_) {
		_tmp78_ = TRUE;
	} else {
		gunichar _tmp113_;
		_tmp113_ = c;
		_tmp78_ = _tmp113_ == 8540U;
	}
	_tmp114_ = _tmp78_;
	if (_tmp114_) {
		_tmp77_ = TRUE;
	} else {
		gunichar _tmp115_;
		_tmp115_ = c;
		_tmp77_ = _tmp115_ == 8541U;
	}
	_tmp116_ = _tmp77_;
	if (_tmp116_) {
		_tmp76_ = TRUE;
	} else {
		gunichar _tmp117_;
		_tmp117_ = c;
		_tmp76_ = _tmp117_ == 8542U;
	}
	_tmp118_ = _tmp76_;
	if (_tmp118_) {
		result = LEXER_TOKEN_TYPE_PL_FRACTION;
		return result;
	}
	_tmp119_ = c;
	if (_tmp119_ == 176U) {
		result = LEXER_TOKEN_TYPE_PL_DEGREE;
		return result;
	}
	_tmp120_ = c;
	if (_tmp120_ == ((gunichar) '\'')) {
		result = LEXER_TOKEN_TYPE_PL_MINUTE;
		return result;
	}
	_tmp121_ = c;
	if (_tmp121_ == ((gunichar) '"')) {
		result = LEXER_TOKEN_TYPE_PL_SECOND;
		return result;
	}
	_tmp123_ = c;
	_tmp124_ = g_unichar_isalpha (_tmp123_);
	if (_tmp124_) {
		_tmp122_ = TRUE;
	} else {
		gunichar _tmp125_;
		_tmp125_ = c;
		_tmp122_ = _tmp125_ == ((gunichar) '_');
	}
	_tmp126_ = _tmp122_;
	if (_tmp126_) {
		result = LEXER_TOKEN_TYPE_PL_LETTER;
		return result;
	}
	_tmp127_ = c;
	if (_tmp127_ == 8743U) {
		result = LEXER_TOKEN_TYPE_AND;
		return result;
	}
	_tmp128_ = c;
	if (_tmp128_ == 8744U) {
		result = LEXER_TOKEN_TYPE_OR;
		return result;
	}
	_tmp130_ = c;
	if (_tmp130_ == 8891U) {
		_tmp129_ = TRUE;
	} else {
		gunichar _tmp131_;
		_tmp131_ = c;
		_tmp129_ = _tmp131_ == 8853U;
	}
	_tmp132_ = _tmp129_;
	if (_tmp132_) {
		result = LEXER_TOKEN_TYPE_XOR;
		return result;
	}
	_tmp134_ = c;
	if (_tmp134_ == 172U) {
		_tmp133_ = TRUE;
	} else {
		gunichar _tmp135_;
		_tmp135_ = c;
		_tmp133_ = _tmp135_ == ((gunichar) '~');
	}
	_tmp136_ = _tmp133_;
	if (_tmp136_) {
		result = LEXER_TOKEN_TYPE_NOT;
		return result;
	}
	_tmp137_ = c;
	if (_tmp137_ == ((gunichar) '+')) {
		result = LEXER_TOKEN_TYPE_ADD;
		return result;
	}
	_tmp140_ = c;
	if (_tmp140_ == ((gunichar) '-')) {
		_tmp139_ = TRUE;
	} else {
		gunichar _tmp141_;
		_tmp141_ = c;
		_tmp139_ = _tmp141_ == 8722U;
	}
	_tmp142_ = _tmp139_;
	if (_tmp142_) {
		_tmp138_ = TRUE;
	} else {
		gunichar _tmp143_;
		_tmp143_ = c;
		_tmp138_ = _tmp143_ == 8211U;
	}
	_tmp144_ = _tmp138_;
	if (_tmp144_) {
		result = LEXER_TOKEN_TYPE_SUBTRACT;
		return result;
	}
	_tmp146_ = c;
	if (_tmp146_ == ((gunichar) '*')) {
		_tmp145_ = TRUE;
	} else {
		gunichar _tmp147_;
		_tmp147_ = c;
		_tmp145_ = _tmp147_ == 215U;
	}
	_tmp148_ = _tmp145_;
	if (_tmp148_) {
		result = LEXER_TOKEN_TYPE_MULTIPLY;
		return result;
	}
	_tmp151_ = c;
	if (_tmp151_ == ((gunichar) '/')) {
		_tmp150_ = TRUE;
	} else {
		gunichar _tmp152_;
		_tmp152_ = c;
		_tmp150_ = _tmp152_ == 8725U;
	}
	_tmp153_ = _tmp150_;
	if (_tmp153_) {
		_tmp149_ = TRUE;
	} else {
		gunichar _tmp154_;
		_tmp154_ = c;
		_tmp149_ = _tmp154_ == 247U;
	}
	_tmp155_ = _tmp149_;
	if (_tmp155_) {
		result = LEXER_TOKEN_TYPE_DIVIDE;
		return result;
	}
	_tmp156_ = c;
	if (_tmp156_ == 8970U) {
		result = LEXER_TOKEN_TYPE_L_FLOOR;
		return result;
	}
	_tmp157_ = c;
	if (_tmp157_ == 8971U) {
		result = LEXER_TOKEN_TYPE_R_FLOOR;
		return result;
	}
	_tmp158_ = c;
	if (_tmp158_ == 8968U) {
		result = LEXER_TOKEN_TYPE_L_CEILING;
		return result;
	}
	_tmp159_ = c;
	if (_tmp159_ == 8969U) {
		result = LEXER_TOKEN_TYPE_R_CEILING;
		return result;
	}
	_tmp160_ = c;
	if (_tmp160_ == 8730U) {
		result = LEXER_TOKEN_TYPE_ROOT;
		return result;
	}
	_tmp161_ = c;
	if (_tmp161_ == 8731U) {
		result = LEXER_TOKEN_TYPE_ROOT_3;
		return result;
	}
	_tmp162_ = c;
	if (_tmp162_ == 8732U) {
		result = LEXER_TOKEN_TYPE_ROOT_4;
		return result;
	}
	_tmp163_ = c;
	if (_tmp163_ == ((gunichar) '=')) {
		result = LEXER_TOKEN_TYPE_ASSIGN;
		return result;
	}
	_tmp164_ = c;
	if (_tmp164_ == ((gunichar) '(')) {
		result = LEXER_TOKEN_TYPE_L_R_BRACKET;
		return result;
	}
	_tmp165_ = c;
	if (_tmp165_ == ((gunichar) ')')) {
		result = LEXER_TOKEN_TYPE_R_R_BRACKET;
		return result;
	}
	_tmp166_ = c;
	if (_tmp166_ == ((gunichar) '[')) {
		result = LEXER_TOKEN_TYPE_L_S_BRACKET;
		return result;
	}
	_tmp167_ = c;
	if (_tmp167_ == ((gunichar) ']')) {
		result = LEXER_TOKEN_TYPE_R_S_BRACKET;
		return result;
	}
	_tmp168_ = c;
	if (_tmp168_ == ((gunichar) '{')) {
		result = LEXER_TOKEN_TYPE_L_C_BRACKET;
		return result;
	}
	_tmp169_ = c;
	if (_tmp169_ == ((gunichar) '}')) {
		result = LEXER_TOKEN_TYPE_R_C_BRACKET;
		return result;
	}
	_tmp170_ = c;
	if (_tmp170_ == ((gunichar) '|')) {
		result = LEXER_TOKEN_TYPE_ABS;
		return result;
	}
	_tmp171_ = c;
	if (_tmp171_ == ((gunichar) '^')) {
		result = LEXER_TOKEN_TYPE_POWER;
		return result;
	}
	_tmp172_ = c;
	if (_tmp172_ == ((gunichar) '!')) {
		result = LEXER_TOKEN_TYPE_FACTORIAL;
		return result;
	}
	_tmp173_ = c;
	if (_tmp173_ == ((gunichar) '%')) {
		result = LEXER_TOKEN_TYPE_PERCENTAGE;
		return result;
	}
	_tmp177_ = c;
	if (_tmp177_ == ((gunichar) ' ')) {
		_tmp176_ = TRUE;
	} else {
		gunichar _tmp178_;
		_tmp178_ = c;
		_tmp176_ = _tmp178_ == ((gunichar) '\r');
	}
	_tmp179_ = _tmp176_;
	if (_tmp179_) {
		_tmp175_ = TRUE;
	} else {
		gunichar _tmp180_;
		_tmp180_ = c;
		_tmp175_ = _tmp180_ == ((gunichar) '\t');
	}
	_tmp181_ = _tmp175_;
	if (_tmp181_) {
		_tmp174_ = TRUE;
	} else {
		gunichar _tmp182_;
		_tmp182_ = c;
		_tmp174_ = _tmp182_ == ((gunichar) '\n');
	}
	_tmp183_ = _tmp174_;
	if (_tmp183_) {
		result = LEXER_TOKEN_TYPE_PL_SKIP;
		return result;
	}
	result = LEXER_TOKEN_TYPE_UNKNOWN;
	return result;
}


static void value_pre_lexer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pre_lexer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pre_lexer_unref (value->data[0].v_pointer);
	}
}


static void value_pre_lexer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pre_lexer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pre_lexer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pre_lexer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PreLexer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pre_lexer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pre_lexer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PreLexer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pre_lexer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pre_lexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPreLexer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRE_LEXER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pre_lexer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRE_LEXER), NULL);
	return value->data[0].v_pointer;
}


void value_set_pre_lexer (GValue* value, gpointer v_object) {
	PreLexer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRE_LEXER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRE_LEXER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pre_lexer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pre_lexer_unref (old);
	}
}


void value_take_pre_lexer (GValue* value, gpointer v_object) {
	PreLexer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRE_LEXER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRE_LEXER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pre_lexer_unref (old);
	}
}


static void pre_lexer_class_init (PreLexerClass * klass) {
	pre_lexer_parent_class = g_type_class_peek_parent (klass);
	PRE_LEXER_CLASS (klass)->finalize = pre_lexer_finalize;
	g_type_class_add_private (klass, sizeof (PreLexerPrivate));
}


static void pre_lexer_instance_init (PreLexer * self) {
	self->priv = PRE_LEXER_GET_PRIVATE (self);
	self->priv->eos = FALSE;
	self->ref_count = 1;
}


static void pre_lexer_finalize (PreLexer* obj) {
	PreLexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRE_LEXER, PreLexer);
	_g_free0 (self->stream);
}


GType pre_lexer_get_type (void) {
	static volatile gsize pre_lexer_type_id__volatile = 0;
	if (g_once_init_enter (&pre_lexer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pre_lexer_init, value_pre_lexer_free_value, value_pre_lexer_copy_value, value_pre_lexer_peek_pointer, "p", value_pre_lexer_collect_value, "p", value_pre_lexer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PreLexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pre_lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreLexer), 0, (GInstanceInitFunc) pre_lexer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pre_lexer_type_id;
		pre_lexer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreLexer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pre_lexer_type_id__volatile, pre_lexer_type_id);
	}
	return pre_lexer_type_id__volatile;
}


gpointer pre_lexer_ref (gpointer instance) {
	PreLexer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pre_lexer_unref (gpointer instance) {
	PreLexer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PRE_LEXER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


LexerToken* lexer_token_construct (GType object_type) {
	LexerToken* self = NULL;
	self = (LexerToken*) g_type_create_instance (object_type);
	return self;
}


LexerToken* lexer_token_new (void) {
	return lexer_token_construct (TYPE_LEXER_TOKEN);
}


static void value_lexer_token_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_lexer_token_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		lexer_token_unref (value->data[0].v_pointer);
	}
}


static void value_lexer_token_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = lexer_token_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_lexer_token_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_lexer_token_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		LexerToken* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = lexer_token_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_lexer_token_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	LexerToken** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = lexer_token_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_lexer_token (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLexerToken* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LEXER_TOKEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_lexer_token (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXER_TOKEN), NULL);
	return value->data[0].v_pointer;
}


void value_set_lexer_token (GValue* value, gpointer v_object) {
	LexerToken* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXER_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXER_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		lexer_token_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lexer_token_unref (old);
	}
}


void value_take_lexer_token (GValue* value, gpointer v_object) {
	LexerToken* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXER_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXER_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lexer_token_unref (old);
	}
}


static void lexer_token_class_init (LexerTokenClass * klass) {
	lexer_token_parent_class = g_type_class_peek_parent (klass);
	LEXER_TOKEN_CLASS (klass)->finalize = lexer_token_finalize;
}


static void lexer_token_instance_init (LexerToken * self) {
	self->ref_count = 1;
}


static void lexer_token_finalize (LexerToken* obj) {
	LexerToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER_TOKEN, LexerToken);
	_g_free0 (self->text);
}


GType lexer_token_get_type (void) {
	static volatile gsize lexer_token_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_token_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_lexer_token_init, value_lexer_token_free_value, value_lexer_token_copy_value, value_lexer_token_peek_pointer, "p", value_lexer_token_collect_value, "p", value_lexer_token_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LexerTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LexerToken), 0, (GInstanceInitFunc) lexer_token_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType lexer_token_type_id;
		lexer_token_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LexerToken", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&lexer_token_type_id__volatile, lexer_token_type_id);
	}
	return lexer_token_type_id__volatile;
}


gpointer lexer_token_ref (gpointer instance) {
	LexerToken* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void lexer_token_unref (gpointer instance) {
	LexerToken* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LEXER_TOKEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _lexer_token_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (lexer_token_unref (var), NULL));
}


static void _g_list_free__lexer_token_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _lexer_token_unref0_, NULL);
	g_list_free (self);
}


static gpointer _parser_ref0 (gpointer self) {
	return self ? parser_ref (self) : NULL;
}


Lexer* lexer_construct (GType object_type, const gchar* input, Parser* parser, gint number_base) {
	Lexer* self = NULL;
	const gchar* _tmp0_;
	PreLexer* _tmp1_;
	Parser* _tmp2_;
	Parser* _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	self = (Lexer*) g_type_create_instance (object_type);
	_tmp0_ = input;
	_tmp1_ = pre_lexer_new (_tmp0_);
	_pre_lexer_unref0 (self->priv->prelexer);
	self->priv->prelexer = _tmp1_;
	__g_list_free__lexer_token_unref0_0 (self->tokens);
	self->tokens = NULL;
	self->priv->next_token = (guint) 0;
	_tmp2_ = parser;
	_tmp3_ = _parser_ref0 (_tmp2_);
	_parser_unref0 (self->priv->parser);
	self->priv->parser = _tmp3_;
	_tmp4_ = number_base;
	self->priv->number_base = _tmp4_;
	return self;
}


Lexer* lexer_new (const gchar* input, Parser* parser, gint number_base) {
	return lexer_construct (TYPE_LEXER, input, parser, number_base);
}


static gpointer _lexer_token_ref0 (gpointer self) {
	return self ? lexer_token_ref (self) : NULL;
}


void lexer_scan (Lexer* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		LexerToken* _tmp0_ = NULL;
		LexerToken* token;
		LexerToken* _tmp1_;
		LexerToken* _tmp2_;
		LexerToken* _tmp3_;
		LexerTokenType _tmp4_;
		_tmp0_ = lexer_insert_next_token (self);
		token = _tmp0_;
		_tmp1_ = token;
		_tmp2_ = _lexer_token_ref0 (_tmp1_);
		self->tokens = g_list_append (self->tokens, _tmp2_);
		_tmp3_ = token;
		_tmp4_ = _tmp3_->type;
		if (_tmp4_ == LEXER_TOKEN_TYPE_PL_EOS) {
			_lexer_token_unref0 (token);
			break;
		}
		_lexer_token_unref0 (token);
	}
}


LexerToken* lexer_get_next_token (Lexer* self) {
	LexerToken* result = NULL;
	GList* _tmp0_;
	guint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	LexerToken* _tmp3_;
	LexerToken* token;
	guint _tmp4_;
	guint _tmp5_;
	GList* _tmp6_;
	guint _tmp7_ = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tokens;
	_tmp1_ = self->priv->next_token;
	_tmp2_ = g_list_nth_data (_tmp0_, _tmp1_);
	_tmp3_ = _lexer_token_ref0 ((LexerToken*) _tmp2_);
	token = _tmp3_;
	_tmp4_ = self->priv->next_token;
	self->priv->next_token = _tmp4_ + 1;
	_tmp5_ = self->priv->next_token;
	_tmp6_ = self->tokens;
	_tmp7_ = g_list_length (_tmp6_);
	if (_tmp5_ >= _tmp7_) {
		GList* _tmp8_;
		guint _tmp9_ = 0U;
		_tmp8_ = self->tokens;
		_tmp9_ = g_list_length (_tmp8_);
		self->priv->next_token = _tmp9_;
	}
	result = token;
	return result;
}


void lexer_roll_back (Lexer* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->next_token;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->next_token;
		self->priv->next_token = _tmp1_ - 1;
	}
}


static gboolean lexer_check_if_function (Lexer* self) {
	gboolean result = FALSE;
	PreLexer* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* name;
	Parser* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->parser;
	_tmp3_ = name;
	_tmp4_ = parser_function_is_defined (_tmp2_, _tmp3_);
	if (_tmp4_) {
		result = TRUE;
		_g_free0 (name);
		return result;
	} else {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


static gboolean lexer_check_if_number (Lexer* self) {
	gboolean result = FALSE;
	gint count;
	PreLexer* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	const gchar* _tmp2_;
	gint _tmp3_;
	Number* _tmp4_ = NULL;
	Number* tmp;
	Number* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = self->priv->number_base;
	_tmp4_ = mp_set_from_string (_tmp2_, _tmp3_);
	tmp = _tmp4_;
	_tmp5_ = tmp;
	if (_tmp5_ != NULL) {
		result = TRUE;
		_number_unref0 (tmp);
		_g_free0 (text);
		return result;
	} else {
		while (TRUE) {
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			Number* _tmp9_ = NULL;
			Number* _tmp10_;
			gint _tmp11_;
			PreLexer* _tmp12_;
			PreLexer* _tmp13_;
			gchar* _tmp14_ = NULL;
			_tmp6_ = text;
			if (!(g_strcmp0 (_tmp6_, "") != 0)) {
				break;
			}
			_tmp7_ = text;
			_tmp8_ = self->priv->number_base;
			_tmp9_ = mp_set_from_string (_tmp7_, _tmp8_);
			_number_unref0 (tmp);
			tmp = _tmp9_;
			_tmp10_ = tmp;
			if (_tmp10_ != NULL) {
				result = TRUE;
				_number_unref0 (tmp);
				_g_free0 (text);
				return result;
			}
			_tmp11_ = count;
			count = _tmp11_ + 1;
			_tmp12_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp12_);
			_tmp13_ = self->priv->prelexer;
			_tmp14_ = pre_lexer_get_marked_substring (_tmp13_);
			_g_free0 (text);
			text = _tmp14_;
		}
		while (TRUE) {
			gint _tmp15_;
			PreLexer* _tmp16_;
			_tmp15_ = count;
			count = _tmp15_ - 1;
			if (!(_tmp15_ > 0)) {
				break;
			}
			_tmp16_ = self->priv->prelexer;
			pre_lexer_get_next_token (_tmp16_);
		}
		result = FALSE;
		_number_unref0 (tmp);
		_g_free0 (text);
		return result;
	}
	_number_unref0 (tmp);
	_g_free0 (text);
}


static LexerToken* lexer_insert_token (Lexer* self, LexerTokenType type) {
	LexerToken* result = NULL;
	LexerToken* _tmp0_;
	LexerToken* token;
	PreLexer* _tmp1_;
	gchar* _tmp2_ = NULL;
	PreLexer* _tmp3_;
	gint _tmp4_;
	PreLexer* _tmp5_;
	gint _tmp6_;
	LexerTokenType _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = lexer_token_new ();
	token = _tmp0_;
	_tmp1_ = self->priv->prelexer;
	_tmp2_ = pre_lexer_get_marked_substring (_tmp1_);
	_g_free0 (token->text);
	token->text = _tmp2_;
	_tmp3_ = self->priv->prelexer;
	_tmp4_ = _tmp3_->mark_index;
	token->start_index = (guint) _tmp4_;
	_tmp5_ = self->priv->prelexer;
	_tmp6_ = _tmp5_->index;
	token->end_index = (guint) _tmp6_;
	_tmp7_ = type;
	token->type = _tmp7_;
	result = token;
	return result;
}


static LexerToken* lexer_insert_next_token (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	PreLexer* _tmp1_;
	LexerTokenType _tmp2_ = 0;
	LexerTokenType type;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	LexerTokenType _tmp32_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp40_;
	gboolean _tmp42_;
	gboolean _tmp44_;
	gboolean _tmp46_;
	gboolean _tmp48_;
	gboolean _tmp50_;
	gboolean _tmp52_;
	gboolean _tmp54_;
	gboolean _tmp56_;
	gboolean _tmp58_;
	gboolean _tmp60_;
	gboolean _tmp62_;
	gboolean _tmp64_;
	gboolean _tmp66_;
	gboolean _tmp68_;
	gboolean _tmp70_;
	gboolean _tmp72_;
	gboolean _tmp74_;
	gboolean _tmp76_;
	gboolean _tmp78_;
	gboolean _tmp80_;
	gboolean _tmp82_;
	LexerTokenType _tmp85_;
	LexerTokenType _tmp102_;
	LexerTokenType _tmp107_;
	LexerTokenType _tmp112_;
	LexerTokenType _tmp114_;
	LexerTokenType _tmp116_;
	LexerTokenType _tmp118_;
	LexerTokenType _tmp120_;
	LexerTokenType _tmp122_;
	Parser* _tmp124_;
	PreLexer* _tmp125_;
	gchar* _tmp126_ = NULL;
	gchar* _tmp127_;
	PreLexer* _tmp128_;
	gint _tmp129_;
	PreLexer* _tmp130_;
	gint _tmp131_;
	LexerToken* _tmp132_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	pre_lexer_set_marker (_tmp0_);
	_tmp1_ = self->priv->prelexer;
	_tmp2_ = pre_lexer_get_next_token (_tmp1_);
	type = _tmp2_;
	while (TRUE) {
		LexerTokenType _tmp3_;
		PreLexer* _tmp4_;
		PreLexer* _tmp5_;
		LexerTokenType _tmp6_ = 0;
		_tmp3_ = type;
		if (!(_tmp3_ == LEXER_TOKEN_TYPE_PL_SKIP)) {
			break;
		}
		_tmp4_ = self->priv->prelexer;
		pre_lexer_set_marker (_tmp4_);
		_tmp5_ = self->priv->prelexer;
		_tmp6_ = pre_lexer_get_next_token (_tmp5_);
		type = _tmp6_;
	}
	_tmp32_ = type;
	if (_tmp32_ == LEXER_TOKEN_TYPE_AND) {
		_tmp31_ = TRUE;
	} else {
		LexerTokenType _tmp33_;
		_tmp33_ = type;
		_tmp31_ = _tmp33_ == LEXER_TOKEN_TYPE_OR;
	}
	_tmp34_ = _tmp31_;
	if (_tmp34_) {
		_tmp30_ = TRUE;
	} else {
		LexerTokenType _tmp35_;
		_tmp35_ = type;
		_tmp30_ = _tmp35_ == LEXER_TOKEN_TYPE_XOR;
	}
	_tmp36_ = _tmp30_;
	if (_tmp36_) {
		_tmp29_ = TRUE;
	} else {
		LexerTokenType _tmp37_;
		_tmp37_ = type;
		_tmp29_ = _tmp37_ == LEXER_TOKEN_TYPE_NOT;
	}
	_tmp38_ = _tmp29_;
	if (_tmp38_) {
		_tmp28_ = TRUE;
	} else {
		LexerTokenType _tmp39_;
		_tmp39_ = type;
		_tmp28_ = _tmp39_ == LEXER_TOKEN_TYPE_ADD;
	}
	_tmp40_ = _tmp28_;
	if (_tmp40_) {
		_tmp27_ = TRUE;
	} else {
		LexerTokenType _tmp41_;
		_tmp41_ = type;
		_tmp27_ = _tmp41_ == LEXER_TOKEN_TYPE_SUBTRACT;
	}
	_tmp42_ = _tmp27_;
	if (_tmp42_) {
		_tmp26_ = TRUE;
	} else {
		LexerTokenType _tmp43_;
		_tmp43_ = type;
		_tmp26_ = _tmp43_ == LEXER_TOKEN_TYPE_MULTIPLY;
	}
	_tmp44_ = _tmp26_;
	if (_tmp44_) {
		_tmp25_ = TRUE;
	} else {
		LexerTokenType _tmp45_;
		_tmp45_ = type;
		_tmp25_ = _tmp45_ == LEXER_TOKEN_TYPE_DIVIDE;
	}
	_tmp46_ = _tmp25_;
	if (_tmp46_) {
		_tmp24_ = TRUE;
	} else {
		LexerTokenType _tmp47_;
		_tmp47_ = type;
		_tmp24_ = _tmp47_ == LEXER_TOKEN_TYPE_L_FLOOR;
	}
	_tmp48_ = _tmp24_;
	if (_tmp48_) {
		_tmp23_ = TRUE;
	} else {
		LexerTokenType _tmp49_;
		_tmp49_ = type;
		_tmp23_ = _tmp49_ == LEXER_TOKEN_TYPE_R_FLOOR;
	}
	_tmp50_ = _tmp23_;
	if (_tmp50_) {
		_tmp22_ = TRUE;
	} else {
		LexerTokenType _tmp51_;
		_tmp51_ = type;
		_tmp22_ = _tmp51_ == LEXER_TOKEN_TYPE_L_CEILING;
	}
	_tmp52_ = _tmp22_;
	if (_tmp52_) {
		_tmp21_ = TRUE;
	} else {
		LexerTokenType _tmp53_;
		_tmp53_ = type;
		_tmp21_ = _tmp53_ == LEXER_TOKEN_TYPE_R_CEILING;
	}
	_tmp54_ = _tmp21_;
	if (_tmp54_) {
		_tmp20_ = TRUE;
	} else {
		LexerTokenType _tmp55_;
		_tmp55_ = type;
		_tmp20_ = _tmp55_ == LEXER_TOKEN_TYPE_ROOT;
	}
	_tmp56_ = _tmp20_;
	if (_tmp56_) {
		_tmp19_ = TRUE;
	} else {
		LexerTokenType _tmp57_;
		_tmp57_ = type;
		_tmp19_ = _tmp57_ == LEXER_TOKEN_TYPE_ROOT_3;
	}
	_tmp58_ = _tmp19_;
	if (_tmp58_) {
		_tmp18_ = TRUE;
	} else {
		LexerTokenType _tmp59_;
		_tmp59_ = type;
		_tmp18_ = _tmp59_ == LEXER_TOKEN_TYPE_ROOT_4;
	}
	_tmp60_ = _tmp18_;
	if (_tmp60_) {
		_tmp17_ = TRUE;
	} else {
		LexerTokenType _tmp61_;
		_tmp61_ = type;
		_tmp17_ = _tmp61_ == LEXER_TOKEN_TYPE_ASSIGN;
	}
	_tmp62_ = _tmp17_;
	if (_tmp62_) {
		_tmp16_ = TRUE;
	} else {
		LexerTokenType _tmp63_;
		_tmp63_ = type;
		_tmp16_ = _tmp63_ == LEXER_TOKEN_TYPE_L_R_BRACKET;
	}
	_tmp64_ = _tmp16_;
	if (_tmp64_) {
		_tmp15_ = TRUE;
	} else {
		LexerTokenType _tmp65_;
		_tmp65_ = type;
		_tmp15_ = _tmp65_ == LEXER_TOKEN_TYPE_R_R_BRACKET;
	}
	_tmp66_ = _tmp15_;
	if (_tmp66_) {
		_tmp14_ = TRUE;
	} else {
		LexerTokenType _tmp67_;
		_tmp67_ = type;
		_tmp14_ = _tmp67_ == LEXER_TOKEN_TYPE_L_S_BRACKET;
	}
	_tmp68_ = _tmp14_;
	if (_tmp68_) {
		_tmp13_ = TRUE;
	} else {
		LexerTokenType _tmp69_;
		_tmp69_ = type;
		_tmp13_ = _tmp69_ == LEXER_TOKEN_TYPE_R_S_BRACKET;
	}
	_tmp70_ = _tmp13_;
	if (_tmp70_) {
		_tmp12_ = TRUE;
	} else {
		LexerTokenType _tmp71_;
		_tmp71_ = type;
		_tmp12_ = _tmp71_ == LEXER_TOKEN_TYPE_L_C_BRACKET;
	}
	_tmp72_ = _tmp12_;
	if (_tmp72_) {
		_tmp11_ = TRUE;
	} else {
		LexerTokenType _tmp73_;
		_tmp73_ = type;
		_tmp11_ = _tmp73_ == LEXER_TOKEN_TYPE_R_C_BRACKET;
	}
	_tmp74_ = _tmp11_;
	if (_tmp74_) {
		_tmp10_ = TRUE;
	} else {
		LexerTokenType _tmp75_;
		_tmp75_ = type;
		_tmp10_ = _tmp75_ == LEXER_TOKEN_TYPE_ABS;
	}
	_tmp76_ = _tmp10_;
	if (_tmp76_) {
		_tmp9_ = TRUE;
	} else {
		LexerTokenType _tmp77_;
		_tmp77_ = type;
		_tmp9_ = _tmp77_ == LEXER_TOKEN_TYPE_POWER;
	}
	_tmp78_ = _tmp9_;
	if (_tmp78_) {
		_tmp8_ = TRUE;
	} else {
		LexerTokenType _tmp79_;
		_tmp79_ = type;
		_tmp8_ = _tmp79_ == LEXER_TOKEN_TYPE_FACTORIAL;
	}
	_tmp80_ = _tmp8_;
	if (_tmp80_) {
		_tmp7_ = TRUE;
	} else {
		LexerTokenType _tmp81_;
		_tmp81_ = type;
		_tmp7_ = _tmp81_ == LEXER_TOKEN_TYPE_PERCENTAGE;
	}
	_tmp82_ = _tmp7_;
	if (_tmp82_) {
		LexerTokenType _tmp83_;
		LexerToken* _tmp84_ = NULL;
		_tmp83_ = type;
		_tmp84_ = lexer_insert_token (self, _tmp83_);
		result = _tmp84_;
		return result;
	}
	_tmp85_ = type;
	if (_tmp85_ == LEXER_TOKEN_TYPE_PL_SUPER_MINUS) {
		PreLexer* _tmp86_;
		LexerTokenType _tmp87_ = 0;
		LexerTokenType _tmp88_;
		PreLexer* _tmp100_;
		LexerToken* _tmp101_ = NULL;
		_tmp86_ = self->priv->prelexer;
		_tmp87_ = pre_lexer_get_next_token (_tmp86_);
		type = _tmp87_;
		_tmp88_ = type;
		if (_tmp88_ != LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
			Parser* _tmp89_;
			PreLexer* _tmp90_;
			gchar* _tmp91_ = NULL;
			gchar* _tmp92_;
			PreLexer* _tmp93_;
			gint _tmp94_;
			PreLexer* _tmp95_;
			gint _tmp96_;
			LexerToken* _tmp97_ = NULL;
			_tmp89_ = self->priv->parser;
			_tmp90_ = self->priv->prelexer;
			_tmp91_ = pre_lexer_get_marked_substring (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = self->priv->prelexer;
			_tmp94_ = _tmp93_->mark_index;
			_tmp95_ = self->priv->prelexer;
			_tmp96_ = _tmp95_->index;
			parser_set_error (_tmp89_, ERROR_CODE_MP, _tmp92_, (guint) _tmp94_, (guint) _tmp96_);
			_g_free0 (_tmp92_);
			_tmp97_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp97_;
			return result;
		}
		while (TRUE) {
			PreLexer* _tmp98_;
			LexerTokenType _tmp99_ = 0;
			_tmp98_ = self->priv->prelexer;
			_tmp99_ = pre_lexer_get_next_token (_tmp98_);
			if (!(_tmp99_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp100_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp100_);
		_tmp101_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NSUP_NUMBER);
		result = _tmp101_;
		return result;
	}
	_tmp102_ = type;
	if (_tmp102_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
		PreLexer* _tmp105_;
		LexerToken* _tmp106_ = NULL;
		while (TRUE) {
			PreLexer* _tmp103_;
			LexerTokenType _tmp104_ = 0;
			_tmp103_ = self->priv->prelexer;
			_tmp104_ = pre_lexer_get_next_token (_tmp103_);
			if (!(_tmp104_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp105_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp105_);
		_tmp106_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUP_NUMBER);
		result = _tmp106_;
		return result;
	}
	_tmp107_ = type;
	if (_tmp107_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
		PreLexer* _tmp110_;
		LexerToken* _tmp111_ = NULL;
		while (TRUE) {
			PreLexer* _tmp108_;
			LexerTokenType _tmp109_ = 0;
			_tmp108_ = self->priv->prelexer;
			_tmp109_ = pre_lexer_get_next_token (_tmp108_);
			if (!(_tmp109_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
				break;
			}
		}
		_tmp110_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp110_);
		_tmp111_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUB_NUMBER);
		result = _tmp111_;
		return result;
	}
	_tmp112_ = type;
	if (_tmp112_ == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp113_ = NULL;
		_tmp113_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp113_;
		return result;
	}
	_tmp114_ = type;
	if (_tmp114_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp115_ = NULL;
		_tmp115_ = lexer_insert_digit (self);
		result = _tmp115_;
		return result;
	}
	_tmp116_ = type;
	if (_tmp116_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp117_ = NULL;
		_tmp117_ = lexer_insert_decimal (self);
		result = _tmp117_;
		return result;
	}
	_tmp118_ = type;
	if (_tmp118_ == LEXER_TOKEN_TYPE_PL_HEX) {
		LexerToken* _tmp119_ = NULL;
		_tmp119_ = lexer_insert_hex (self);
		result = _tmp119_;
		return result;
	}
	_tmp120_ = type;
	if (_tmp120_ == LEXER_TOKEN_TYPE_PL_LETTER) {
		LexerToken* _tmp121_ = NULL;
		_tmp121_ = lexer_insert_letter (self);
		result = _tmp121_;
		return result;
	}
	_tmp122_ = type;
	if (_tmp122_ == LEXER_TOKEN_TYPE_PL_EOS) {
		LexerToken* _tmp123_ = NULL;
		_tmp123_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_PL_EOS);
		result = _tmp123_;
		return result;
	}
	_tmp124_ = self->priv->parser;
	_tmp125_ = self->priv->prelexer;
	_tmp126_ = pre_lexer_get_marked_substring (_tmp125_);
	_tmp127_ = _tmp126_;
	_tmp128_ = self->priv->prelexer;
	_tmp129_ = _tmp128_->mark_index;
	_tmp130_ = self->priv->prelexer;
	_tmp131_ = _tmp130_->index;
	parser_set_error (_tmp124_, ERROR_CODE_INVALID, _tmp127_, (guint) _tmp129_, (guint) _tmp131_);
	_g_free0 (_tmp127_);
	_tmp132_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
	result = _tmp132_;
	return result;
}


static LexerToken* lexer_insert_digit (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	LexerTokenType _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		LexerTokenType _tmp2_;
		PreLexer* _tmp3_;
		LexerTokenType _tmp4_ = 0;
		_tmp2_ = type;
		if (!(_tmp2_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = pre_lexer_get_next_token (_tmp3_);
		type = _tmp4_;
	}
	_tmp5_ = type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp6_ = NULL;
		_tmp6_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp6_;
		return result;
	} else {
		LexerTokenType _tmp7_;
		_tmp7_ = type;
		if (_tmp7_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp10_;
			LexerToken* _tmp11_ = NULL;
			while (TRUE) {
				PreLexer* _tmp8_;
				LexerTokenType _tmp9_ = 0;
				_tmp8_ = self->priv->prelexer;
				_tmp9_ = pre_lexer_get_next_token (_tmp8_);
				if (!(_tmp9_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp10_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp10_);
			_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp11_;
			return result;
		} else {
			LexerTokenType _tmp12_;
			_tmp12_ = type;
			if (_tmp12_ == LEXER_TOKEN_TYPE_PL_DEGREE) {
				PreLexer* _tmp13_;
				LexerTokenType _tmp14_ = 0;
				LexerTokenType _tmp15_;
				_tmp13_ = self->priv->prelexer;
				_tmp14_ = pre_lexer_get_next_token (_tmp13_);
				type = _tmp14_;
				_tmp15_ = type;
				if (_tmp15_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
					LexerTokenType _tmp19_;
					while (TRUE) {
						PreLexer* _tmp16_;
						LexerTokenType _tmp17_ = 0;
						LexerTokenType _tmp18_;
						_tmp16_ = self->priv->prelexer;
						_tmp17_ = pre_lexer_get_next_token (_tmp16_);
						type = _tmp17_;
						_tmp18_ = type;
						if (!(_tmp18_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
							break;
						}
					}
					_tmp19_ = type;
					if (_tmp19_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp20_ = NULL;
						_tmp20_ = lexer_insert_angle_num_dm (self);
						result = _tmp20_;
						return result;
					} else {
						LexerTokenType _tmp21_;
						_tmp21_ = type;
						if (_tmp21_ == LEXER_TOKEN_TYPE_PL_MINUTE) {
							PreLexer* _tmp22_;
							LexerTokenType _tmp23_ = 0;
							LexerTokenType _tmp24_;
							_tmp22_ = self->priv->prelexer;
							_tmp23_ = pre_lexer_get_next_token (_tmp22_);
							type = _tmp23_;
							_tmp24_ = type;
							if (_tmp24_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
								LexerTokenType _tmp28_;
								while (TRUE) {
									PreLexer* _tmp25_;
									LexerTokenType _tmp26_ = 0;
									LexerTokenType _tmp27_;
									_tmp25_ = self->priv->prelexer;
									_tmp26_ = pre_lexer_get_next_token (_tmp25_);
									type = _tmp26_;
									_tmp27_ = type;
									if (!(_tmp27_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
										break;
									}
								}
								_tmp28_ = type;
								if (_tmp28_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp29_ = NULL;
									_tmp29_ = lexer_insert_angle_num_dms (self);
									result = _tmp29_;
									return result;
								} else {
									LexerTokenType _tmp30_;
									_tmp30_ = type;
									if (_tmp30_ == LEXER_TOKEN_TYPE_PL_SECOND) {
										LexerToken* _tmp31_ = NULL;
										_tmp31_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
										result = _tmp31_;
										return result;
									} else {
										Parser* _tmp32_;
										PreLexer* _tmp33_;
										gchar* _tmp34_ = NULL;
										gchar* _tmp35_;
										PreLexer* _tmp36_;
										gint _tmp37_;
										PreLexer* _tmp38_;
										gint _tmp39_;
										LexerToken* _tmp40_ = NULL;
										_tmp32_ = self->priv->parser;
										_tmp33_ = self->priv->prelexer;
										_tmp34_ = pre_lexer_get_marked_substring (_tmp33_);
										_tmp35_ = _tmp34_;
										_tmp36_ = self->priv->prelexer;
										_tmp37_ = _tmp36_->mark_index;
										_tmp38_ = self->priv->prelexer;
										_tmp39_ = _tmp38_->index;
										parser_set_error (_tmp32_, ERROR_CODE_MP, _tmp35_, (guint) _tmp37_, (guint) _tmp39_);
										_g_free0 (_tmp35_);
										_tmp40_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
										result = _tmp40_;
										return result;
									}
								}
							} else {
								LexerTokenType _tmp41_;
								_tmp41_ = type;
								if (_tmp41_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp42_ = NULL;
									_tmp42_ = lexer_insert_angle_num_dms (self);
									result = _tmp42_;
									return result;
								} else {
									PreLexer* _tmp43_;
									LexerToken* _tmp44_ = NULL;
									_tmp43_ = self->priv->prelexer;
									pre_lexer_roll_back (_tmp43_);
									_tmp44_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
									result = _tmp44_;
									return result;
								}
							}
						} else {
							Parser* _tmp45_;
							PreLexer* _tmp46_;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							PreLexer* _tmp49_;
							gint _tmp50_;
							PreLexer* _tmp51_;
							gint _tmp52_;
							LexerToken* _tmp53_ = NULL;
							_tmp45_ = self->priv->parser;
							_tmp46_ = self->priv->prelexer;
							_tmp47_ = pre_lexer_get_marked_substring (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = self->priv->prelexer;
							_tmp50_ = _tmp49_->mark_index;
							_tmp51_ = self->priv->prelexer;
							_tmp52_ = _tmp51_->index;
							parser_set_error (_tmp45_, ERROR_CODE_MP, _tmp48_, (guint) _tmp50_, (guint) _tmp52_);
							_g_free0 (_tmp48_);
							_tmp53_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
							result = _tmp53_;
							return result;
						}
					}
				} else {
					LexerTokenType _tmp54_;
					_tmp54_ = type;
					if (_tmp54_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp55_ = NULL;
						_tmp55_ = lexer_insert_angle_num_dm (self);
						result = _tmp55_;
						return result;
					} else {
						LexerToken* _tmp56_ = NULL;
						_tmp56_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp56_;
						return result;
					}
				}
			} else {
				LexerTokenType _tmp57_;
				_tmp57_ = type;
				if (_tmp57_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
					LexerToken* _tmp58_ = NULL;
					_tmp58_ = lexer_insert_decimal (self);
					result = _tmp58_;
					return result;
				} else {
					LexerTokenType _tmp59_;
					_tmp59_ = type;
					if (_tmp59_ == LEXER_TOKEN_TYPE_PL_HEX) {
						LexerToken* _tmp60_ = NULL;
						_tmp60_ = lexer_insert_hex_dec (self);
						result = _tmp60_;
						return result;
					} else {
						PreLexer* _tmp61_;
						LexerToken* _tmp62_ = NULL;
						_tmp61_ = self->priv->prelexer;
						pre_lexer_roll_back (_tmp61_);
						_tmp62_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp62_;
						return result;
					}
				}
			}
		}
	}
}


static LexerToken* lexer_insert_angle_num_dm (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	LexerTokenType _tmp2_;
	PreLexer* _tmp13_;
	LexerTokenType _tmp14_ = 0;
	LexerTokenType _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ != LEXER_TOKEN_TYPE_PL_DIGIT) {
		Parser* _tmp3_;
		PreLexer* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		PreLexer* _tmp7_;
		gint _tmp8_;
		PreLexer* _tmp9_;
		gint _tmp10_;
		LexerToken* _tmp11_ = NULL;
		_tmp3_ = self->priv->parser;
		_tmp4_ = self->priv->prelexer;
		_tmp5_ = pre_lexer_get_marked_substring (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->prelexer;
		_tmp8_ = _tmp7_->mark_index;
		_tmp9_ = self->priv->prelexer;
		_tmp10_ = _tmp9_->index;
		parser_set_error (_tmp3_, ERROR_CODE_MP, _tmp6_, (guint) _tmp8_, (guint) _tmp10_);
		_g_free0 (_tmp6_);
		_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp11_;
		return result;
	}
	while (TRUE) {
		LexerTokenType _tmp12_;
		_tmp12_ = type;
		if (!(_tmp12_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	_tmp13_ = self->priv->prelexer;
	_tmp14_ = pre_lexer_get_next_token (_tmp13_);
	type = _tmp14_;
	_tmp15_ = type;
	if (_tmp15_ == LEXER_TOKEN_TYPE_PL_MINUTE) {
		LexerToken* _tmp16_ = NULL;
		_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp16_;
		return result;
	} else {
		Parser* _tmp17_;
		PreLexer* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		PreLexer* _tmp21_;
		gint _tmp22_;
		PreLexer* _tmp23_;
		gint _tmp24_;
		LexerToken* _tmp25_ = NULL;
		_tmp17_ = self->priv->parser;
		_tmp18_ = self->priv->prelexer;
		_tmp19_ = pre_lexer_get_marked_substring (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->prelexer;
		_tmp22_ = _tmp21_->mark_index;
		_tmp23_ = self->priv->prelexer;
		_tmp24_ = _tmp23_->index;
		parser_set_error (_tmp17_, ERROR_CODE_MP, _tmp20_, (guint) _tmp22_, (guint) _tmp24_);
		_g_free0 (_tmp20_);
		_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp25_;
		return result;
	}
}


static LexerToken* lexer_insert_angle_num_dms (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	LexerTokenType _tmp2_;
	LexerTokenType _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ != LEXER_TOKEN_TYPE_PL_DIGIT) {
		Parser* _tmp3_;
		PreLexer* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		PreLexer* _tmp7_;
		gint _tmp8_;
		PreLexer* _tmp9_;
		gint _tmp10_;
		LexerToken* _tmp11_ = NULL;
		_tmp3_ = self->priv->parser;
		_tmp4_ = self->priv->prelexer;
		_tmp5_ = pre_lexer_get_marked_substring (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->prelexer;
		_tmp8_ = _tmp7_->mark_index;
		_tmp9_ = self->priv->prelexer;
		_tmp10_ = _tmp9_->index;
		parser_set_error (_tmp3_, ERROR_CODE_MP, _tmp6_, (guint) _tmp8_, (guint) _tmp10_);
		_g_free0 (_tmp6_);
		_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp11_;
		return result;
	}
	while (TRUE) {
		PreLexer* _tmp12_;
		LexerTokenType _tmp13_ = 0;
		LexerTokenType _tmp14_;
		_tmp12_ = self->priv->prelexer;
		_tmp13_ = pre_lexer_get_next_token (_tmp12_);
		type = _tmp13_;
		_tmp14_ = type;
		if (!(_tmp14_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	_tmp15_ = type;
	if (_tmp15_ == LEXER_TOKEN_TYPE_PL_SECOND) {
		LexerToken* _tmp16_ = NULL;
		_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp16_;
		return result;
	} else {
		Parser* _tmp17_;
		PreLexer* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		PreLexer* _tmp21_;
		gint _tmp22_;
		PreLexer* _tmp23_;
		gint _tmp24_;
		LexerToken* _tmp25_ = NULL;
		_tmp17_ = self->priv->parser;
		_tmp18_ = self->priv->prelexer;
		_tmp19_ = pre_lexer_get_marked_substring (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->prelexer;
		_tmp22_ = _tmp21_->mark_index;
		_tmp23_ = self->priv->prelexer;
		_tmp24_ = _tmp23_->index;
		parser_set_error (_tmp17_, ERROR_CODE_MP, _tmp20_, (guint) _tmp22_, (guint) _tmp24_);
		_g_free0 (_tmp20_);
		_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp25_;
		return result;
	}
}


static LexerToken* lexer_insert_decimal (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	LexerTokenType _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerTokenType _tmp6_;
		while (TRUE) {
			PreLexer* _tmp3_;
			LexerTokenType _tmp4_ = 0;
			LexerTokenType _tmp5_;
			_tmp3_ = self->priv->prelexer;
			_tmp4_ = pre_lexer_get_next_token (_tmp3_);
			type = _tmp4_;
			_tmp5_ = type;
			if (!(_tmp5_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
				break;
			}
		}
		_tmp6_ = type;
		if (_tmp6_ == LEXER_TOKEN_TYPE_PL_DEGREE) {
			LexerToken* _tmp7_ = NULL;
			_tmp7_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp7_;
			return result;
		} else {
			LexerTokenType _tmp8_;
			_tmp8_ = type;
			if (_tmp8_ == LEXER_TOKEN_TYPE_PL_HEX) {
				LexerToken* _tmp9_ = NULL;
				_tmp9_ = lexer_insert_decimal_hex (self);
				result = _tmp9_;
				return result;
			} else {
				LexerTokenType _tmp10_;
				_tmp10_ = type;
				if (_tmp10_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
					PreLexer* _tmp13_;
					LexerToken* _tmp14_ = NULL;
					while (TRUE) {
						PreLexer* _tmp11_;
						LexerTokenType _tmp12_ = 0;
						_tmp11_ = self->priv->prelexer;
						_tmp12_ = pre_lexer_get_next_token (_tmp11_);
						if (!(_tmp12_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
							break;
						}
					}
					_tmp13_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp13_);
					_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp14_;
					return result;
				} else {
					PreLexer* _tmp15_;
					LexerToken* _tmp16_ = NULL;
					_tmp15_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp15_);
					_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp16_;
					return result;
				}
			}
		}
	} else {
		LexerTokenType _tmp17_;
		_tmp17_ = type;
		if (_tmp17_ == LEXER_TOKEN_TYPE_PL_HEX) {
			LexerToken* _tmp18_ = NULL;
			_tmp18_ = lexer_insert_decimal_hex (self);
			result = _tmp18_;
			return result;
		} else {
			Parser* _tmp19_;
			PreLexer* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			PreLexer* _tmp23_;
			gint _tmp24_;
			PreLexer* _tmp25_;
			gint _tmp26_;
			LexerToken* _tmp27_ = NULL;
			_tmp19_ = self->priv->parser;
			_tmp20_ = self->priv->prelexer;
			_tmp21_ = pre_lexer_get_marked_substring (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->prelexer;
			_tmp24_ = _tmp23_->mark_index;
			_tmp25_ = self->priv->prelexer;
			_tmp26_ = _tmp25_->index;
			parser_set_error (_tmp19_, ERROR_CODE_MP, _tmp22_, (guint) _tmp24_, (guint) _tmp26_);
			_g_free0 (_tmp22_);
			_tmp27_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp27_;
			return result;
		}
	}
}


static LexerToken* lexer_insert_hex (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	LexerTokenType _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		LexerTokenType _tmp2_;
		PreLexer* _tmp3_;
		LexerTokenType _tmp4_ = 0;
		_tmp2_ = type;
		if (!(_tmp2_ == LEXER_TOKEN_TYPE_PL_HEX)) {
			break;
		}
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = pre_lexer_get_next_token (_tmp3_);
		type = _tmp4_;
	}
	_tmp5_ = type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp6_ = NULL;
		_tmp6_ = lexer_insert_hex_dec (self);
		result = _tmp6_;
		return result;
	} else {
		LexerTokenType _tmp7_;
		_tmp7_ = type;
		if (_tmp7_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
			LexerToken* _tmp8_ = NULL;
			_tmp8_ = lexer_insert_decimal_hex (self);
			result = _tmp8_;
			return result;
		} else {
			LexerTokenType _tmp9_;
			_tmp9_ = type;
			if (_tmp9_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
				PreLexer* _tmp12_;
				gboolean _tmp13_ = FALSE;
				while (TRUE) {
					PreLexer* _tmp10_;
					LexerTokenType _tmp11_ = 0;
					_tmp10_ = self->priv->prelexer;
					_tmp11_ = pre_lexer_get_next_token (_tmp10_);
					if (!(_tmp11_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
						break;
					}
				}
				_tmp12_ = self->priv->prelexer;
				pre_lexer_roll_back (_tmp12_);
				_tmp13_ = lexer_check_if_number (self);
				if (_tmp13_) {
					LexerToken* _tmp14_ = NULL;
					_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp14_;
					return result;
				} else {
					gboolean _tmp15_ = FALSE;
					_tmp15_ = lexer_check_if_function (self);
					if (_tmp15_) {
						LexerToken* _tmp16_ = NULL;
						_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
						result = _tmp16_;
						return result;
					} else {
						LexerToken* _tmp17_ = NULL;
						_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
						result = _tmp17_;
						return result;
					}
				}
			} else {
				LexerTokenType _tmp18_;
				_tmp18_ = type;
				if (_tmp18_ == LEXER_TOKEN_TYPE_PL_LETTER) {
					LexerToken* _tmp19_ = NULL;
					_tmp19_ = lexer_insert_letter (self);
					result = _tmp19_;
					return result;
				} else {
					PreLexer* _tmp20_;
					gboolean _tmp21_ = FALSE;
					_tmp20_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp20_);
					_tmp21_ = lexer_check_if_number (self);
					if (_tmp21_) {
						LexerToken* _tmp22_ = NULL;
						_tmp22_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp22_;
						return result;
					} else {
						gboolean _tmp23_ = FALSE;
						_tmp23_ = lexer_check_if_function (self);
						if (_tmp23_) {
							LexerToken* _tmp24_ = NULL;
							_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
							result = _tmp24_;
							return result;
						} else {
							LexerToken* _tmp25_ = NULL;
							_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
							result = _tmp25_;
							return result;
						}
					}
				}
			}
		}
	}
}


static LexerToken* lexer_insert_hex_dec (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	LexerTokenType _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		LexerTokenType _tmp3_;
		gboolean _tmp5_;
		PreLexer* _tmp6_;
		LexerTokenType _tmp7_ = 0;
		_tmp3_ = type;
		if (_tmp3_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp2_ = TRUE;
		} else {
			LexerTokenType _tmp4_;
			_tmp4_ = type;
			_tmp2_ = _tmp4_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		_tmp5_ = _tmp2_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->prelexer;
		_tmp7_ = pre_lexer_get_next_token (_tmp6_);
		type = _tmp7_;
	}
	_tmp8_ = type;
	if (_tmp8_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp9_ = NULL;
		_tmp9_ = lexer_insert_decimal_hex (self);
		result = _tmp9_;
		return result;
	} else {
		LexerTokenType _tmp10_;
		_tmp10_ = type;
		if (_tmp10_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp13_;
			LexerToken* _tmp14_ = NULL;
			while (TRUE) {
				PreLexer* _tmp11_;
				LexerTokenType _tmp12_ = 0;
				_tmp11_ = self->priv->prelexer;
				_tmp12_ = pre_lexer_get_next_token (_tmp11_);
				if (!(_tmp12_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp13_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp13_);
			_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp14_;
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			Parser* _tmp17_;
			PreLexer* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			PreLexer* _tmp21_;
			gint _tmp22_;
			PreLexer* _tmp23_;
			gint _tmp24_;
			LexerToken* _tmp25_ = NULL;
			_tmp15_ = lexer_check_if_number (self);
			if (_tmp15_) {
				LexerToken* _tmp16_ = NULL;
				_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
				result = _tmp16_;
				return result;
			}
			_tmp17_ = self->priv->parser;
			_tmp18_ = self->priv->prelexer;
			_tmp19_ = pre_lexer_get_marked_substring (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->prelexer;
			_tmp22_ = _tmp21_->mark_index;
			_tmp23_ = self->priv->prelexer;
			_tmp24_ = _tmp23_->index;
			parser_set_error (_tmp17_, ERROR_CODE_MP, _tmp20_, (guint) _tmp22_, (guint) _tmp24_);
			_g_free0 (_tmp20_);
			_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp25_;
			return result;
		}
	}
}


static LexerToken* lexer_insert_decimal_hex (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	PreLexer* _tmp11_;
	LexerToken* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		LexerTokenType _tmp3_;
		gboolean _tmp5_;
		PreLexer* _tmp6_;
		LexerTokenType _tmp7_ = 0;
		_tmp3_ = type;
		if (_tmp3_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp2_ = TRUE;
		} else {
			LexerTokenType _tmp4_;
			_tmp4_ = type;
			_tmp2_ = _tmp4_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		_tmp5_ = _tmp2_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->prelexer;
		_tmp7_ = pre_lexer_get_next_token (_tmp6_);
		type = _tmp7_;
	}
	while (TRUE) {
		LexerTokenType _tmp8_;
		PreLexer* _tmp9_;
		LexerTokenType _tmp10_ = 0;
		_tmp8_ = type;
		if (!(_tmp8_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp9_ = self->priv->prelexer;
		_tmp10_ = pre_lexer_get_next_token (_tmp9_);
		type = _tmp10_;
	}
	_tmp11_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp11_);
	_tmp12_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
	result = _tmp12_;
	return result;
}


static LexerToken* lexer_insert_letter (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType type;
	PreLexer* _tmp11_;
	PreLexer* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* name;
	const gchar* _tmp17_;
	const gchar* _tmp19_;
	const gchar* _tmp21_;
	const gchar* _tmp23_;
	const gchar* _tmp25_;
	const gchar* _tmp27_;
	gboolean _tmp29_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		LexerTokenType _tmp3_;
		gboolean _tmp5_;
		PreLexer* _tmp6_;
		LexerTokenType _tmp7_ = 0;
		_tmp3_ = type;
		if (_tmp3_ == LEXER_TOKEN_TYPE_PL_LETTER) {
			_tmp2_ = TRUE;
		} else {
			LexerTokenType _tmp4_;
			_tmp4_ = type;
			_tmp2_ = _tmp4_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		_tmp5_ = _tmp2_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->prelexer;
		_tmp7_ = pre_lexer_get_next_token (_tmp6_);
		type = _tmp7_;
	}
	while (TRUE) {
		LexerTokenType _tmp8_;
		PreLexer* _tmp9_;
		LexerTokenType _tmp10_ = 0;
		_tmp8_ = type;
		if (!(_tmp8_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp9_ = self->priv->prelexer;
		_tmp10_ = pre_lexer_get_next_token (_tmp9_);
		type = _tmp10_;
	}
	_tmp11_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp11_);
	_tmp12_ = self->priv->prelexer;
	_tmp13_ = pre_lexer_get_marked_substring (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) (-1));
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	name = _tmp16_;
	_tmp17_ = name;
	if (g_strcmp0 (_tmp17_, "mod") == 0) {
		LexerToken* _tmp18_ = NULL;
		_tmp18_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_MOD);
		result = _tmp18_;
		_g_free0 (name);
		return result;
	}
	_tmp19_ = name;
	if (g_strcmp0 (_tmp19_, "and") == 0) {
		LexerToken* _tmp20_ = NULL;
		_tmp20_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_AND);
		result = _tmp20_;
		_g_free0 (name);
		return result;
	}
	_tmp21_ = name;
	if (g_strcmp0 (_tmp21_, "or") == 0) {
		LexerToken* _tmp22_ = NULL;
		_tmp22_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_OR);
		result = _tmp22_;
		_g_free0 (name);
		return result;
	}
	_tmp23_ = name;
	if (g_strcmp0 (_tmp23_, "xor") == 0) {
		LexerToken* _tmp24_ = NULL;
		_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_XOR);
		result = _tmp24_;
		_g_free0 (name);
		return result;
	}
	_tmp25_ = name;
	if (g_strcmp0 (_tmp25_, "not") == 0) {
		LexerToken* _tmp26_ = NULL;
		_tmp26_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NOT);
		result = _tmp26_;
		_g_free0 (name);
		return result;
	}
	_tmp27_ = name;
	if (g_strcmp0 (_tmp27_, "in") == 0) {
		LexerToken* _tmp28_ = NULL;
		_tmp28_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_IN);
		result = _tmp28_;
		_g_free0 (name);
		return result;
	}
	_tmp29_ = lexer_check_if_function (self);
	if (_tmp29_) {
		LexerToken* _tmp30_ = NULL;
		_tmp30_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
		result = _tmp30_;
		_g_free0 (name);
		return result;
	} else {
		LexerToken* _tmp31_ = NULL;
		_tmp31_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
		result = _tmp31_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


static void value_lexer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_lexer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		lexer_unref (value->data[0].v_pointer);
	}
}


static void value_lexer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = lexer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_lexer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_lexer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Lexer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = lexer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_lexer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Lexer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = lexer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_lexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLexer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LEXER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_lexer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXER), NULL);
	return value->data[0].v_pointer;
}


void value_set_lexer (GValue* value, gpointer v_object) {
	Lexer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		lexer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lexer_unref (old);
	}
}


void value_take_lexer (GValue* value, gpointer v_object) {
	Lexer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LEXER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LEXER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lexer_unref (old);
	}
}


static void lexer_class_init (LexerClass * klass) {
	lexer_parent_class = g_type_class_peek_parent (klass);
	LEXER_CLASS (klass)->finalize = lexer_finalize;
	g_type_class_add_private (klass, sizeof (LexerPrivate));
}


static void lexer_instance_init (Lexer * self) {
	self->priv = LEXER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void lexer_finalize (Lexer* obj) {
	Lexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER, Lexer);
	_parser_unref0 (self->priv->parser);
	_pre_lexer_unref0 (self->priv->prelexer);
	__g_list_free__lexer_token_unref0_0 (self->tokens);
}


GType lexer_get_type (void) {
	static volatile gsize lexer_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_lexer_init, value_lexer_free_value, value_lexer_copy_value, value_lexer_peek_pointer, "p", value_lexer_collect_value, "p", value_lexer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Lexer), 0, (GInstanceInitFunc) lexer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType lexer_type_id;
		lexer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Lexer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&lexer_type_id__volatile, lexer_type_id);
	}
	return lexer_type_id__volatile;
}


gpointer lexer_ref (gpointer instance) {
	Lexer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void lexer_unref (gpointer instance) {
	Lexer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LEXER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



