/* math-buttons.c generated by valac 0.18.1, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <atk/atk.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_FINANCIAL_DIALOG (financial_dialog_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT, UnitClass))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT))
#define UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT, UnitClass))

typedef struct _Unit Unit;
typedef struct _UnitClass UnitClass;

#define TYPE_MATH_VARIABLE_POPUP (math_variable_popup_get_type ())
#define MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopup))
#define MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))
#define IS_MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPUP))
#define IS_MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPUP))
#define MATH_VARIABLE_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))

typedef struct _MathVariablePopup MathVariablePopup;
typedef struct _MathVariablePopupClass MathVariablePopupClass;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkMenu* shift_left_menu;
	GtkMenu* shift_right_menu;
	GtkMenu* function_menu;
	GList* superscript_toggles;
	GList* subscript_toggles;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* bit_labels;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
};

typedef enum  {
	FINANCIAL_DIALOG_CTRM_DIALOG,
	FINANCIAL_DIALOG_DDB_DIALOG,
	FINANCIAL_DIALOG_FV_DIALOG,
	FINANCIAL_DIALOG_GPM_DIALOG,
	FINANCIAL_DIALOG_PMT_DIALOG,
	FINANCIAL_DIALOG_PV_DIALOG,
	FINANCIAL_DIALOG_RATE_DIALOG,
	FINANCIAL_DIALOG_SLN_DIALOG,
	FINANCIAL_DIALOG_SYD_DIALOG,
	FINANCIAL_DIALOG_TERM_DIALOG
} FinancialDialog;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
enum  {
	MATH_BUTTONS_DUMMY_PROPERTY,
	MATH_BUTTONS_MODE,
	MATH_BUTTONS_PROGRAMMING_BASE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __lambda27_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda28_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda29_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda30_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
GType financial_dialog_get_type (void) G_GNUC_CONST;
static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* math_equation_get_number (MathEquation* self);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_fractional_part (Number* self);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
gboolean number_is_zero (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gint math_equation_get_number_base (MathEquation* self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self, gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode);
static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
static void ______lambda14_ (MathButtons* self, GtkButton* widget);
void math_equation_insert_digit (MathEquation* self, guint digit);
static void _______lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda15_ (MathButtons* self);
void math_equation_insert_subtract (MathEquation* self);
static void ____lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda16_ (MathButtons* self);
void math_equation_undo (MathEquation* self);
static void ____lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda17_ (MathButtons* self);
void math_equation_solve (MathEquation* self);
static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda18_ (MathButtons* self);
void math_equation_clear (MathEquation* self);
static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_function_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda21_ (MathButtons* self);
void math_equation_factorize (MathEquation* self);
static void ____lambda21__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda22_ (MathButtons* self);
void math_equation_insert_exponent (MathEquation* self);
static void ____lambda22__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* math_equation_get_serializer (MathEquation* self);
gunichar serializer_get_radix (Serializer* self);
static void ___lambda25_ (MathButtons* self);
void math_equation_insert_numeric_point (MathEquation* self);
static void ____lambda25__gtk_button_clicked (GtkButton* _sender, gpointer self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event);
static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ___lambda26_ (MathButtons* self, GParamSpec* pspec);
static void ____lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda13_ (MathButtons* self, GtkButton* widget);
void math_equation_insert (MathEquation* self, const gchar* text);
static void ____lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
GType unit_get_type (void) G_GNUC_CONST;
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
gchar* unit_get_name (Unit* self);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self);
static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu);
static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
MathVariablePopup* math_variable_popup_new (MathEquation* equation);
MathVariablePopup* math_variable_popup_construct (GType object_type, MathEquation* equation);
GType math_variable_popup_get_type (void) G_GNUC_CONST;
static void ______lambda23_ (MathButtons* self, GtkMenuItem* widget);
void math_equation_shift (MathEquation* self, gint count);
static void _______lambda23__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ______lambda24_ (MathButtons* self, GtkMenuItem* widget);
static void _______lambda24__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void math_buttons_add_function_menu_item (MathButtons* self, GtkMenu* menu, const gchar* label, const gchar* function);
static void __lambda20_ (MathButtons* self, GtkMenuItem* widget);
static void ___lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* mp_set_from_string (const gchar* str, gint default_base);
void do_finc_expression (MathEquation* equation, FinancialDialog function, Number* arg1, Number* arg2, Number* arg3, Number* arg4);
Number* number_add (Number* self, Number* y);
Number* number_shift (Number* self, gint count);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_toggle_bit (MathEquation* self, guint bit);
static void math_buttons_remove_trailing_spaces (MathButtons* self);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
void math_equation_set_number_base (MathEquation* self, gint value);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
static void math_buttons_finalize (GObject* obj);
static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[3] = {"syd_cost", "syd_salvage", "syd_life"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};

GType button_mode_get_type (void) {
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	math_buttons_load_buttons (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda27_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda27_ (self, pspec);
}


static void __lambda28_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}


static void ___lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda28_ (self, pspec);
}


static void __lambda29_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda29_ (self, pspec);
}


static void __lambda30_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda30_ (self, pspec);
}


MathButtons* math_buttons_construct (GType object_type, MathEquation* equation) {
	MathButtons * self = NULL;
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	MathEquation* _tmp3_;
	MathEquation* _tmp4_;
	MathEquation* _tmp5_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp1_;
	_tmp2_ = equation;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::display", (GCallback) ___lambda27__g_object_notify, self, 0);
	_tmp3_ = equation;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::number-mode", (GCallback) ___lambda28__g_object_notify, self, 0);
	_tmp4_ = equation;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::angle-units", (GCallback) ___lambda29__g_object_notify, self, 0);
	_tmp5_ = equation;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::number-format", (GCallback) ___lambda30__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}


MathButtons* math_buttons_new (MathEquation* equation) {
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
}


static void math_buttons_load_finc_dialogs (MathButtons* self) {
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}


static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_finc_response_cb (self, _sender, response_id);
}


static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_finc_activate_cb (self, _sender);
}


static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function) {
	GtkBuilder* _tmp0_;
	const gchar* _tmp1_;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_;
	GtkDialog* dialog;
	GtkDialog* _tmp4_;
	FinancialDialog _tmp5_;
	GtkDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = name;
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp2_) : NULL);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = function;
	g_object_set_data_full ((GObject*) _tmp4_, "finc-function", (gpointer) ((gintptr) ((gint) _tmp5_)), NULL);
	_tmp6_ = dialog;
	g_signal_connect_object (_tmp6_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				GtkBuilder* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				const gchar* _tmp15_;
				GObject* _tmp16_ = NULL;
				GtkEntry* _tmp17_;
				GtkEntry* entry;
				gint _tmp18_;
				GtkEntry* _tmp26_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = entry_names;
				_tmp11__length1 = entry_names_length1;
				if (!(_tmp10_ < _tmp11__length1)) {
					break;
				}
				_tmp12_ = self->priv->financial_ui;
				_tmp13_ = entry_names;
				_tmp13__length1 = entry_names_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = gtk_builder_get_object (_tmp12_, _tmp15_);
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp16_) : NULL);
				entry = _tmp17_;
				_tmp18_ = i;
				if (_tmp18_ != (G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries) - 1)) {
					GtkEntry* _tmp19_;
					GtkBuilder* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					gint _tmp22_;
					const gchar* _tmp23_;
					GObject* _tmp24_ = NULL;
					GtkEntry* _tmp25_;
					_tmp19_ = entry;
					_tmp20_ = self->priv->financial_ui;
					_tmp21_ = entry_names;
					_tmp21__length1 = entry_names_length1;
					_tmp22_ = i;
					_tmp23_ = _tmp21_[_tmp22_ + 1];
					_tmp24_ = gtk_builder_get_object (_tmp20_, _tmp23_);
					_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp24_) : NULL);
					g_object_set_data_full ((GObject*) _tmp19_, "next-entry", _tmp25_, g_object_unref);
				}
				_tmp26_ = entry;
				g_signal_connect_object (_tmp26_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}


static void math_buttons_update_bit_panel (MathButtons* self) {
	GtkWidget* _tmp0_;
	MathEquation* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* x;
	guint64 bits;
	Number* _tmp4_;
	gboolean enabled;
	gboolean _tmp5_;
	GtkWidget* _tmp23_;
	gboolean _tmp24_;
	GtkLabel* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gint i;
	GList* _tmp28_;
	MathEquation* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint number_base;
	gchar* _tmp40_;
	gchar* label;
	gint _tmp41_;
	gint _tmp47_;
	gint _tmp56_;
	GtkLabel* _tmp65_;
	const gchar* _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	_tmp5_ = enabled;
	if (_tmp5_) {
		guint64 _tmp6_;
		Number* _tmp7_;
		Number* max;
		Number* _tmp8_;
		Number* _tmp9_ = NULL;
		Number* fraction;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		Number* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp17_;
		gboolean _tmp20_;
		_tmp6_ = G_MAXUINT64;
		_tmp7_ = number_new_unsigned_integer (_tmp6_);
		max = _tmp7_;
		_tmp8_ = x;
		_tmp9_ = number_fractional_part (_tmp8_);
		fraction = _tmp9_;
		_tmp12_ = x;
		_tmp13_ = number_is_negative (_tmp12_);
		if (_tmp13_) {
			_tmp11_ = TRUE;
		} else {
			Number* _tmp14_;
			Number* _tmp15_;
			gint _tmp16_ = 0;
			_tmp14_ = x;
			_tmp15_ = max;
			_tmp16_ = number_compare (_tmp14_, _tmp15_);
			_tmp11_ = _tmp16_ > 0;
		}
		_tmp17_ = _tmp11_;
		if (_tmp17_) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp18_;
			gboolean _tmp19_ = FALSE;
			_tmp18_ = fraction;
			_tmp19_ = number_is_zero (_tmp18_);
			_tmp10_ = !_tmp19_;
		}
		_tmp20_ = _tmp10_;
		if (_tmp20_) {
			enabled = FALSE;
		} else {
			Number* _tmp21_;
			guint64 _tmp22_ = 0ULL;
			_tmp21_ = x;
			_tmp22_ = number_to_unsigned_integer (_tmp21_);
			bits = _tmp22_;
		}
		_number_unref0 (fraction);
		_number_unref0 (max);
	}
	_tmp23_ = self->priv->bit_panel;
	_tmp24_ = enabled;
	gtk_widget_set_sensitive (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->base_label;
	_tmp26_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, _tmp26_);
	_tmp27_ = enabled;
	if (!_tmp27_) {
		_number_unref0 (x);
		return;
	}
	i = 0;
	_tmp28_ = self->priv->bit_labels;
	{
		GList* label_collection = NULL;
		GList* label_it = NULL;
		label_collection = _tmp28_;
		for (label_it = label_collection; label_it != NULL; label_it = label_it->next) {
			GtkLabel* _tmp29_;
			GtkLabel* label = NULL;
			_tmp29_ = _g_object_ref0 ((GtkLabel*) label_it->data);
			label = _tmp29_;
			{
				gchar* _tmp30_;
				gchar* text;
				guint64 _tmp31_;
				gint _tmp32_;
				GtkLabel* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				_tmp30_ = g_strdup (" 0");
				text = _tmp30_;
				_tmp31_ = bits;
				_tmp32_ = i;
				if ((_tmp31_ & (1LL << _tmp32_)) != ((guint64) 0)) {
					gchar* _tmp33_;
					_tmp33_ = g_strdup (" 1");
					_g_free0 (text);
					text = _tmp33_;
				}
				_tmp34_ = label;
				_tmp35_ = text;
				gtk_label_set_text (_tmp34_, _tmp35_);
				_tmp36_ = i;
				i = _tmp36_ + 1;
				_g_free0 (text);
				_g_object_unref0 (label);
			}
		}
	}
	_tmp37_ = self->priv->equation;
	_tmp38_ = math_equation_get_number_base (_tmp37_);
	_tmp39_ = _tmp38_;
	number_base = _tmp39_;
	_tmp40_ = g_strdup ("");
	label = _tmp40_;
	_tmp41_ = number_base;
	if (_tmp41_ != 8) {
		const gchar* _tmp42_;
		guint64 _tmp43_;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp42_ = label;
		_tmp43_ = bits;
		_tmp44_ = g_strdup_printf ("%llo₈", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp42_, _tmp45_, NULL);
		_g_free0 (label);
		label = _tmp46_;
		_g_free0 (_tmp45_);
	}
	_tmp47_ = number_base;
	if (_tmp47_ != 10) {
		const gchar* _tmp48_;
		const gchar* _tmp51_;
		guint64 _tmp52_;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp48_ = label;
		if (g_strcmp0 (_tmp48_, "") != 0) {
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp49_ = label;
			_tmp50_ = g_strconcat (_tmp49_, " = ", NULL);
			_g_free0 (label);
			label = _tmp50_;
		}
		_tmp51_ = label;
		_tmp52_ = bits;
		_tmp53_ = g_strdup_printf ("%llu₁₀", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp51_, _tmp54_, NULL);
		_g_free0 (label);
		label = _tmp55_;
		_g_free0 (_tmp54_);
	}
	_tmp56_ = number_base;
	if (_tmp56_ != 16) {
		const gchar* _tmp57_;
		const gchar* _tmp60_;
		guint64 _tmp61_;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp57_ = label;
		if (g_strcmp0 (_tmp57_, "") != 0) {
			const gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp58_ = label;
			_tmp59_ = g_strconcat (_tmp58_, " = ", NULL);
			_g_free0 (label);
			label = _tmp59_;
		}
		_tmp60_ = label;
		_tmp61_ = bits;
		_tmp62_ = g_strdup_printf ("%llX₁₆", _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (_tmp60_, _tmp63_, NULL);
		_g_free0 (label);
		label = _tmp64_;
		_g_free0 (_tmp63_);
	}
	_tmp65_ = self->priv->base_label;
	_tmp66_ = label;
	gtk_label_set_text (_tmp65_, _tmp66_);
	_g_free0 (label);
	_number_unref0 (x);
}


static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo) {
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gint value = 0;
	GtkTreeIter _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = combo;
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, 1, &value, -1, -1);
	math_buttons_set_programming_base (self, value);
	_g_object_unref0 (model);
}


static void math_buttons_base_changed_cb (MathButtons* self) {
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	MathEquation* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean valid;
	gboolean _tmp19_;
	GtkComboBox* _tmp23_;
	GtkTreeIter _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	model = _tmp7_;
	_tmp8_ = model;
	_tmp10_ = gtk_tree_model_get_iter_first (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	valid = _tmp10_;
	while (TRUE) {
		gboolean _tmp11_;
		gint v = 0;
		GtkTreeModel* _tmp12_;
		GtkTreeIter _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GtkTreeModel* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp11_ = valid;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = model;
		_tmp13_ = iter;
		gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &v, -1, -1);
		_tmp14_ = v;
		_tmp15_ = math_buttons_get_programming_base (self);
		_tmp16_ = _tmp15_;
		if (_tmp14_ == _tmp16_) {
			break;
		}
		_tmp17_ = model;
		_tmp18_ = gtk_tree_model_iter_next (_tmp17_, &iter);
		valid = _tmp18_;
	}
	_tmp19_ = valid;
	if (!_tmp19_) {
		GtkTreeModel* _tmp20_;
		GtkTreeIter _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
		_tmp20_ = model;
		_tmp22_ = gtk_tree_model_get_iter_first (_tmp20_, &_tmp21_);
		iter = _tmp21_;
		valid = _tmp22_;
	}
	_tmp23_ = self->priv->base_combo;
	_tmp24_ = iter;
	gtk_combo_box_set_active_iter (_tmp23_, &_tmp24_);
	_g_object_unref0 (model);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void ______lambda14_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_;
	GtkButton* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_digit");
	math_equation_insert_digit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
}


static void _______lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda14_ (self, _sender);
}


static void ___lambda15_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}


static void ____lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda15_ (self);
}


static void ___lambda16_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_undo (_tmp0_);
}


static void ____lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda16_ (self);
}


static void ___lambda17_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}


static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda17_ (self);
}


static void ___lambda18_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}


static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda18_ (self);
}


static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_memory_cb (self, _sender);
}


static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_function_cb (self, _sender);
}


static void ___lambda21_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}


static void ____lambda21__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda21_ (self);
}


static void ___lambda22_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}


static void ____lambda22__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda22_ (self);
}


static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_left_cb (self, _sender);
}


static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_right_cb (self, _sender);
}


static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_insert_character_code_cb (self, _sender);
}


static void ___lambda25_ (MathButtons* self) {
	MathEquation* _tmp0_;
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}


static void ____lambda25__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda25_ (self);
}


static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_superscript_cb (self, _sender);
}


static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_subscript_cb (self, _sender);
}


static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_character_code_dialog_response_cb (self, _sender, response_id);
}


static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb (self, _sender, event);
	return result;
}


static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_character_code_dialog_activate_cb (self, _sender);
}


static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = math_buttons_bit_toggle_cb (self, _sender, event);
	return result;
}


static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_buttons_base_combobox_changed_cb (self, _sender);
}


static void ___lambda26_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}


static void ____lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda26_ (self, pspec);
}


static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_finc_cb (self, _sender);
}


static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode) {
	GtkWidget* result = NULL;
	static const gchar* objects[] = {"button_panel", "character_code_dialog", "currency_dialog", "ctrm_dialog", "ddb_dialog", "fv_dialog", "gpm_dialog", "pmt_dialog", "pv_dialog", "rate_dialog", "sln_dialog", "syd_dialog", "term_dialog", "adjustment1", "adjustment2", NULL};
	GtkBuilder* builder = NULL;
	gchar* builder_filename = NULL;
	ButtonMode _tmp0_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_;
	GtkWidget* panel;
	GtkWidget* _tmp36_;
	ButtonMode _tmp37_;
	GtkBuilder* _tmp46_;
	const gchar* _tmp47_ = NULL;
	GtkBuilder* _tmp48_;
	const gchar* _tmp49_ = NULL;
	GtkBuilder* _tmp50_;
	GtkBuilder* _tmp51_;
	GtkBuilder* _tmp52_;
	const gchar* _tmp53_ = NULL;
	GtkBuilder* _tmp54_;
	const gchar* _tmp55_ = NULL;
	GtkBuilder* _tmp56_;
	const gchar* _tmp57_ = NULL;
	GtkBuilder* _tmp58_;
	const gchar* _tmp59_ = NULL;
	GtkBuilder* _tmp60_;
	const gchar* _tmp61_ = NULL;
	GtkBuilder* _tmp62_;
	const gchar* _tmp63_ = NULL;
	GtkBuilder* _tmp64_;
	const gchar* _tmp65_ = NULL;
	GtkBuilder* _tmp66_;
	const gchar* _tmp67_ = NULL;
	GtkBuilder* _tmp68_;
	const gchar* _tmp69_ = NULL;
	GtkBuilder* _tmp70_;
	const gchar* _tmp71_ = NULL;
	GtkBuilder* _tmp72_;
	const gchar* _tmp73_ = NULL;
	GtkBuilder* _tmp74_;
	const gchar* _tmp75_ = NULL;
	GtkBuilder* _tmp76_;
	const gchar* _tmp77_ = NULL;
	GtkBuilder* _tmp78_;
	const gchar* _tmp79_ = NULL;
	GtkBuilder* _tmp80_;
	const gchar* _tmp81_ = NULL;
	GtkBuilder* _tmp82_;
	const gchar* _tmp83_ = NULL;
	GtkBuilder* _tmp84_;
	const gchar* _tmp85_ = NULL;
	GtkBuilder* _tmp86_;
	const gchar* _tmp87_ = NULL;
	GtkBuilder* _tmp88_;
	const gchar* _tmp89_ = NULL;
	GtkBuilder* _tmp90_;
	const gchar* _tmp91_ = NULL;
	GtkBuilder* _tmp92_;
	const gchar* _tmp93_ = NULL;
	GtkBuilder* _tmp94_;
	const gchar* _tmp95_ = NULL;
	GtkBuilder* _tmp96_;
	const gchar* _tmp97_ = NULL;
	GtkBuilder* _tmp98_;
	const gchar* _tmp99_ = NULL;
	GtkBuilder* _tmp100_;
	const gchar* _tmp101_ = NULL;
	GtkBuilder* _tmp102_;
	const gchar* _tmp103_ = NULL;
	GtkBuilder* _tmp104_;
	const gchar* _tmp105_ = NULL;
	GtkBuilder* _tmp106_;
	const gchar* _tmp107_ = NULL;
	GtkBuilder* _tmp108_;
	const gchar* _tmp109_ = NULL;
	GtkBuilder* _tmp110_;
	const gchar* _tmp111_ = NULL;
	GtkBuilder* _tmp112_;
	const gchar* _tmp113_ = NULL;
	GtkBuilder* _tmp114_;
	const gchar* _tmp115_ = NULL;
	GtkBuilder* _tmp116_;
	const gchar* _tmp117_ = NULL;
	GtkBuilder* _tmp118_;
	const gchar* _tmp119_ = NULL;
	GtkBuilder* _tmp120_;
	const gchar* _tmp121_ = NULL;
	GtkBuilder* _tmp122_;
	const gchar* _tmp123_ = NULL;
	GtkBuilder* _tmp124_;
	const gchar* _tmp125_ = NULL;
	GtkBuilder* _tmp126_;
	const gchar* _tmp127_ = NULL;
	GtkBuilder* _tmp128_;
	const gchar* _tmp129_ = NULL;
	GtkBuilder* _tmp130_;
	const gchar* _tmp131_ = NULL;
	GtkBuilder* _tmp132_;
	const gchar* _tmp133_ = NULL;
	GtkBuilder* _tmp134_;
	const gchar* _tmp135_ = NULL;
	GtkBuilder* _tmp136_;
	const gchar* _tmp137_ = NULL;
	GtkBuilder* _tmp138_;
	const gchar* _tmp139_ = NULL;
	GtkBuilder* _tmp140_;
	const gchar* _tmp141_ = NULL;
	GtkBuilder* _tmp142_;
	const gchar* _tmp143_ = NULL;
	GtkBuilder* _tmp144_;
	const gchar* _tmp145_ = NULL;
	GtkBuilder* _tmp146_;
	const gchar* _tmp147_ = NULL;
	GtkBuilder* _tmp148_;
	const gchar* _tmp149_ = NULL;
	GtkBuilder* _tmp150_;
	const gchar* _tmp151_ = NULL;
	GtkBuilder* _tmp152_;
	const gchar* _tmp153_ = NULL;
	GtkBuilder* _tmp154_;
	const gchar* _tmp155_ = NULL;
	GtkBuilder* _tmp156_;
	const gchar* _tmp157_ = NULL;
	GtkBuilder* _tmp158_;
	const gchar* _tmp159_ = NULL;
	GtkBuilder* _tmp160_;
	const gchar* _tmp161_ = NULL;
	GtkBuilder* _tmp162_;
	const gchar* _tmp163_ = NULL;
	GtkBuilder* _tmp164_;
	const gchar* _tmp165_ = NULL;
	GtkBuilder* _tmp166_;
	const gchar* _tmp167_ = NULL;
	GtkBuilder* _tmp188_;
	GObject* _tmp189_ = NULL;
	GtkButton* _tmp190_;
	GtkButton* button;
	GtkButton* _tmp191_;
	GtkBuilder* _tmp193_;
	GObject* _tmp194_ = NULL;
	GtkButton* _tmp195_;
	GtkButton* _tmp196_;
	GtkBuilder* _tmp198_;
	GObject* _tmp199_ = NULL;
	GtkButton* _tmp200_;
	GtkButton* _tmp201_;
	GtkBuilder* _tmp203_;
	GObject* _tmp204_ = NULL;
	GtkButton* _tmp205_;
	GtkButton* _tmp206_;
	GtkBuilder* _tmp208_;
	GObject* _tmp209_ = NULL;
	GtkButton* _tmp210_;
	GtkButton* _tmp211_;
	GtkBuilder* _tmp213_;
	GObject* _tmp214_ = NULL;
	GtkButton* _tmp215_;
	GtkButton* _tmp216_;
	GtkBuilder* _tmp218_;
	GObject* _tmp219_ = NULL;
	GtkButton* _tmp220_;
	GtkButton* _tmp221_;
	GtkBuilder* _tmp223_;
	GObject* _tmp224_ = NULL;
	GtkButton* _tmp225_;
	GtkButton* _tmp226_;
	GtkBuilder* _tmp228_;
	GObject* _tmp229_ = NULL;
	GtkButton* _tmp230_;
	GtkButton* _tmp231_;
	GtkBuilder* _tmp233_;
	GObject* _tmp234_ = NULL;
	GtkButton* _tmp235_;
	GtkButton* _tmp236_;
	GtkBuilder* _tmp238_;
	GObject* _tmp239_ = NULL;
	GtkButton* _tmp240_;
	GtkButton* _tmp241_;
	GtkBuilder* _tmp243_;
	GObject* _tmp244_ = NULL;
	GtkButton* _tmp245_;
	GtkButton* _tmp246_;
	GtkBuilder* _tmp255_;
	GObject* _tmp256_ = NULL;
	GtkToggleButton* _tmp257_;
	GtkToggleButton* toggle_button;
	GtkToggleButton* _tmp258_;
	GtkBuilder* _tmp266_;
	GObject* _tmp267_ = NULL;
	GtkToggleButton* _tmp268_;
	GtkToggleButton* _tmp269_;
	ButtonMode _tmp277_;
	ButtonMode _tmp345_;
	GtkBuilder* _tmp416_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp1_;
			GtkBuilder* _tmp4_;
			GtkBuilder* _tmp5_;
			GtkBuilder* _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp1_ = self->priv->bas_panel;
			if (_tmp1_ != NULL) {
				GtkWidget* _tmp2_;
				GtkWidget* _tmp3_;
				_tmp2_ = self->priv->bas_panel;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				result = _tmp3_;
				_g_free0 (builder_filename);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp4_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp4_;
			_tmp5_ = self->priv->basic_ui;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (builder);
			builder = _tmp6_;
			_tmp7_ = g_build_filename (UI_DIR, "buttons-basic.ui", NULL);
			_g_free0 (builder_filename);
			builder_filename = _tmp7_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp8_;
			GtkBuilder* _tmp11_;
			GtkBuilder* _tmp12_;
			GtkBuilder* _tmp13_;
			gchar* _tmp14_ = NULL;
			_tmp8_ = self->priv->adv_panel;
			if (_tmp8_ != NULL) {
				GtkWidget* _tmp9_;
				GtkWidget* _tmp10_;
				_tmp9_ = self->priv->adv_panel;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				_g_free0 (builder_filename);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp11_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp11_;
			_tmp12_ = self->priv->advanced_ui;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (builder);
			builder = _tmp13_;
			_tmp14_ = g_build_filename (UI_DIR, "buttons-advanced.ui", NULL);
			_g_free0 (builder_filename);
			builder_filename = _tmp14_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp15_;
			GtkBuilder* _tmp18_;
			GtkBuilder* _tmp19_;
			GtkBuilder* _tmp20_;
			gchar* _tmp21_ = NULL;
			_tmp15_ = self->priv->fin_panel;
			if (_tmp15_ != NULL) {
				GtkWidget* _tmp16_;
				GtkWidget* _tmp17_;
				_tmp16_ = self->priv->fin_panel;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				result = _tmp17_;
				_g_free0 (builder_filename);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp18_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp18_;
			_tmp19_ = self->priv->financial_ui;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (builder);
			builder = _tmp20_;
			_tmp21_ = g_build_filename (UI_DIR, "buttons-financial.ui", NULL);
			_g_free0 (builder_filename);
			builder_filename = _tmp21_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp22_;
			GtkBuilder* _tmp25_;
			GtkBuilder* _tmp26_;
			GtkBuilder* _tmp27_;
			gchar* _tmp28_ = NULL;
			_tmp22_ = self->priv->prog_panel;
			if (_tmp22_ != NULL) {
				GtkWidget* _tmp23_;
				GtkWidget* _tmp24_;
				_tmp23_ = self->priv->prog_panel;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				result = _tmp24_;
				_g_free0 (builder_filename);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp25_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp25_;
			_tmp26_ = self->priv->programming_ui;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (builder);
			builder = _tmp27_;
			_tmp28_ = g_build_filename (UI_DIR, "buttons-programming.ui", NULL);
			_g_free0 (builder_filename);
			builder_filename = _tmp28_;
			break;
		}
	}
	{
		GtkBuilder* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = builder;
		_tmp30_ = builder_filename;
		gtk_builder_add_objects_from_file (_tmp29_, _tmp30_, objects, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("math-buttons.vala:274: Error loading button UI: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (builder_filename);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp33_ = builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "button_panel");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp34_) : NULL);
	panel = _tmp35_;
	_tmp36_ = panel;
	gtk_box_pack_end ((GtkBox*) self, _tmp36_, TRUE, TRUE, (guint) 0);
	_tmp37_ = mode;
	switch (_tmp37_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp38_;
			GtkWidget* _tmp39_;
			_tmp38_ = panel;
			_tmp39_ = _g_object_ref0 (_tmp38_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp39_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp40_;
			GtkWidget* _tmp41_;
			_tmp40_ = panel;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp41_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp42_;
			GtkWidget* _tmp43_;
			_tmp42_ = panel;
			_tmp43_ = _g_object_ref0 (_tmp42_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp43_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp44_;
			GtkWidget* _tmp45_;
			_tmp44_ = panel;
			_tmp45_ = _g_object_ref0 (_tmp44_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp45_;
			break;
		}
	}
	_tmp46_ = builder;
	_tmp47_ = _ ("Pi [Ctrl+P]");
	math_buttons_setup_button (self, _tmp46_, "pi", "π", _tmp47_);
	_tmp48_ = builder;
	_tmp49_ = _ ("Euler’s Number");
	math_buttons_setup_button (self, _tmp48_, "eulers_number", "e", _tmp49_);
	_tmp50_ = builder;
	math_buttons_setup_button (self, _tmp50_, "imaginary", "i", NULL);
	_tmp51_ = builder;
	math_buttons_setup_button (self, _tmp51_, "numeric_point", NULL, NULL);
	_tmp52_ = builder;
	_tmp53_ = _ ("Subscript mode [Alt]");
	math_buttons_setup_button (self, _tmp52_, "subscript", NULL, _tmp53_);
	_tmp54_ = builder;
	_tmp55_ = _ ("Superscript mode [Ctrl]");
	math_buttons_setup_button (self, _tmp54_, "superscript", NULL, _tmp55_);
	_tmp56_ = builder;
	_tmp57_ = _ ("Scientific exponent [Ctrl+E]");
	math_buttons_setup_button (self, _tmp56_, "exponential", NULL, _tmp57_);
	_tmp58_ = builder;
	_tmp59_ = _ ("Add [+]");
	math_buttons_setup_button (self, _tmp58_, "add", "+", _tmp59_);
	_tmp60_ = builder;
	_tmp61_ = _ ("Subtract [-]");
	math_buttons_setup_button (self, _tmp60_, "subtract", "−", _tmp61_);
	_tmp62_ = builder;
	_tmp63_ = _ ("Multiply [*]");
	math_buttons_setup_button (self, _tmp62_, "multiply", "×", _tmp63_);
	_tmp64_ = builder;
	_tmp65_ = _ ("Divide [/]");
	math_buttons_setup_button (self, _tmp64_, "divide", "÷", _tmp65_);
	_tmp66_ = builder;
	_tmp67_ = _ ("Modulus divide");
	math_buttons_setup_button (self, _tmp66_, "modulus_divide", " mod ", _tmp67_);
	_tmp68_ = builder;
	_tmp69_ = _ ("Additional Functions");
	math_buttons_setup_button (self, _tmp68_, "function", NULL, _tmp69_);
	_tmp70_ = builder;
	_tmp71_ = _ ("Exponent [^ or **]");
	math_buttons_setup_button (self, _tmp70_, "x_pow_y", "^", _tmp71_);
	_tmp72_ = builder;
	_tmp73_ = _ ("Square [Ctrl+2]");
	math_buttons_setup_button (self, _tmp72_, "x_squared", "²", _tmp73_);
	_tmp74_ = builder;
	_tmp75_ = _ ("Percentage [%]");
	math_buttons_setup_button (self, _tmp74_, "percentage", "%", _tmp75_);
	_tmp76_ = builder;
	_tmp77_ = _ ("Factorial [!]");
	math_buttons_setup_button (self, _tmp76_, "factorial", "!", _tmp77_);
	_tmp78_ = builder;
	_tmp79_ = _ ("Absolute value [|]");
	math_buttons_setup_button (self, _tmp78_, "abs", "|", _tmp79_);
	_tmp80_ = builder;
	_tmp81_ = _ ("Complex argument");
	math_buttons_setup_button (self, _tmp80_, "arg", "Arg ", _tmp81_);
	_tmp82_ = builder;
	_tmp83_ = _ ("Complex conjugate");
	math_buttons_setup_button (self, _tmp82_, "conjugate", "conj ", _tmp83_);
	_tmp84_ = builder;
	_tmp85_ = _ ("Root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp84_, "root", "√", _tmp85_);
	_tmp86_ = builder;
	_tmp87_ = _ ("Square root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp86_, "square_root", "√", _tmp87_);
	_tmp88_ = builder;
	_tmp89_ = _ ("Logarithm");
	math_buttons_setup_button (self, _tmp88_, "logarithm", "log ", _tmp89_);
	_tmp90_ = builder;
	_tmp91_ = _ ("Natural Logarithm");
	math_buttons_setup_button (self, _tmp90_, "natural_logarithm", "ln ", _tmp91_);
	_tmp92_ = builder;
	_tmp93_ = _ ("Sine");
	math_buttons_setup_button (self, _tmp92_, "sine", "sin ", _tmp93_);
	_tmp94_ = builder;
	_tmp95_ = _ ("Cosine");
	math_buttons_setup_button (self, _tmp94_, "cosine", "cos ", _tmp95_);
	_tmp96_ = builder;
	_tmp97_ = _ ("Tangent");
	math_buttons_setup_button (self, _tmp96_, "tangent", "tan ", _tmp97_);
	_tmp98_ = builder;
	_tmp99_ = _ ("Hyperbolic Sine");
	math_buttons_setup_button (self, _tmp98_, "hyperbolic_sine", "sinh ", _tmp99_);
	_tmp100_ = builder;
	_tmp101_ = _ ("Hyperbolic Cosine");
	math_buttons_setup_button (self, _tmp100_, "hyperbolic_cosine", "cosh ", _tmp101_);
	_tmp102_ = builder;
	_tmp103_ = _ ("Hyperbolic Tangent");
	math_buttons_setup_button (self, _tmp102_, "hyperbolic_tangent", "tanh ", _tmp103_);
	_tmp104_ = builder;
	_tmp105_ = _ ("Inverse [Ctrl+I]");
	math_buttons_setup_button (self, _tmp104_, "inverse", "⁻¹", _tmp105_);
	_tmp106_ = builder;
	_tmp107_ = _ ("Boolean AND");
	math_buttons_setup_button (self, _tmp106_, "and", "∧", _tmp107_);
	_tmp108_ = builder;
	_tmp109_ = _ ("Boolean OR");
	math_buttons_setup_button (self, _tmp108_, "or", "∨", _tmp109_);
	_tmp110_ = builder;
	_tmp111_ = _ ("Boolean Exclusive OR");
	math_buttons_setup_button (self, _tmp110_, "xor", "⊻", _tmp111_);
	_tmp112_ = builder;
	_tmp113_ = _ ("Boolean NOT");
	math_buttons_setup_button (self, _tmp112_, "not", "¬", _tmp113_);
	_tmp114_ = builder;
	_tmp115_ = _ ("Integer Component");
	math_buttons_setup_button (self, _tmp114_, "integer_portion", "int ", _tmp115_);
	_tmp116_ = builder;
	_tmp117_ = _ ("Fractional Component");
	math_buttons_setup_button (self, _tmp116_, "fractional_portion", "frac ", _tmp117_);
	_tmp118_ = builder;
	_tmp119_ = _ ("Real Component");
	math_buttons_setup_button (self, _tmp118_, "real_portion", "Re ", _tmp119_);
	_tmp120_ = builder;
	_tmp121_ = _ ("Imaginary Component");
	math_buttons_setup_button (self, _tmp120_, "imaginary_portion", "Im ", _tmp121_);
	_tmp122_ = builder;
	_tmp123_ = _ ("Ones' Complement");
	math_buttons_setup_button (self, _tmp122_, "ones_complement", "ones ", _tmp123_);
	_tmp124_ = builder;
	_tmp125_ = _ ("Two's Complement");
	math_buttons_setup_button (self, _tmp124_, "twos_complement", "twos ", _tmp125_);
	_tmp126_ = builder;
	_tmp127_ = _ ("Truncate");
	math_buttons_setup_button (self, _tmp126_, "trunc", "trunc ", _tmp127_);
	_tmp128_ = builder;
	_tmp129_ = _ ("Start Group [(]");
	math_buttons_setup_button (self, _tmp128_, "start_group", "(", _tmp129_);
	_tmp130_ = builder;
	_tmp131_ = _ ("End Group [)]");
	math_buttons_setup_button (self, _tmp130_, "end_group", ")", _tmp131_);
	_tmp132_ = builder;
	_tmp133_ = _ ("Memory");
	math_buttons_setup_button (self, _tmp132_, "memory", NULL, _tmp133_);
	_tmp134_ = builder;
	_tmp135_ = _ ("Insert Character Code");
	math_buttons_setup_button (self, _tmp134_, "character", NULL, _tmp135_);
	_tmp136_ = builder;
	_tmp137_ = _ ("Calculate Result");
	math_buttons_setup_button (self, _tmp136_, "result", NULL, _tmp137_);
	_tmp138_ = builder;
	_tmp139_ = _ ("Factorize [Ctrl+F]");
	math_buttons_setup_button (self, _tmp138_, "factor", NULL, _tmp139_);
	_tmp140_ = builder;
	_tmp141_ = _ ("Clear Display [Escape]");
	math_buttons_setup_button (self, _tmp140_, "clear", NULL, _tmp141_);
	_tmp142_ = builder;
	_tmp143_ = _ ("Undo [Ctrl+Z]");
	math_buttons_setup_button (self, _tmp142_, "undo", NULL, _tmp143_);
	_tmp144_ = builder;
	_tmp145_ = _ ("Shift Left");
	math_buttons_setup_button (self, _tmp144_, "shift_left", NULL, _tmp145_);
	_tmp146_ = builder;
	_tmp147_ = _ ("Shift Right");
	math_buttons_setup_button (self, _tmp146_, "shift_right", NULL, _tmp147_);
	_tmp148_ = builder;
	_tmp149_ = _ ("Compounding Term");
	math_buttons_setup_button (self, _tmp148_, "finc_compounding_term", NULL, _tmp149_);
	_tmp150_ = builder;
	_tmp151_ = _ ("Double Declining Depreciation");
	math_buttons_setup_button (self, _tmp150_, "finc_double_declining_depreciation", NULL, _tmp151_);
	_tmp152_ = builder;
	_tmp153_ = _ ("Future Value");
	math_buttons_setup_button (self, _tmp152_, "finc_future_value", NULL, _tmp153_);
	_tmp154_ = builder;
	_tmp155_ = _ ("Financial Term");
	math_buttons_setup_button (self, _tmp154_, "finc_term", NULL, _tmp155_);
	_tmp156_ = builder;
	_tmp157_ = _ ("Sum of the Years Digits Depreciation");
	math_buttons_setup_button (self, _tmp156_, "finc_sum_of_the_years_digits_depreciation", NULL, _tmp157_);
	_tmp158_ = builder;
	_tmp159_ = _ ("Straight Line Depreciation");
	math_buttons_setup_button (self, _tmp158_, "finc_straight_line_depreciation", NULL, _tmp159_);
	_tmp160_ = builder;
	_tmp161_ = _ ("Periodic Interest Rate");
	math_buttons_setup_button (self, _tmp160_, "finc_periodic_interest_rate", NULL, _tmp161_);
	_tmp162_ = builder;
	_tmp163_ = _ ("Present Value");
	math_buttons_setup_button (self, _tmp162_, "finc_present_value", NULL, _tmp163_);
	_tmp164_ = builder;
	_tmp165_ = _ ("Periodic Payment");
	math_buttons_setup_button (self, _tmp164_, "finc_periodic_payment", NULL, _tmp165_);
	_tmp166_ = builder;
	_tmp167_ = _ ("Gross Profit Margin");
	math_buttons_setup_button (self, _tmp166_, "finc_gross_profit_margin", NULL, _tmp167_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp168_;
			_tmp168_ = TRUE;
			while (TRUE) {
				gboolean _tmp169_;
				gint _tmp171_;
				gint _tmp172_;
				gchar* _tmp173_ = NULL;
				gchar* name;
				GtkBuilder* _tmp174_;
				const gchar* _tmp175_;
				GObject* _tmp176_ = NULL;
				GtkButton* _tmp177_;
				GtkButton* button;
				GtkButton* _tmp178_;
				_tmp169_ = _tmp168_;
				if (!_tmp169_) {
					gint _tmp170_;
					_tmp170_ = i;
					i = _tmp170_ + 1;
				}
				_tmp168_ = FALSE;
				_tmp171_ = i;
				if (!(_tmp171_ < 16)) {
					break;
				}
				_tmp172_ = i;
				_tmp173_ = g_strdup_printf ("calc_%d_button", _tmp172_);
				name = _tmp173_;
				_tmp174_ = builder;
				_tmp175_ = name;
				_tmp176_ = gtk_builder_get_object (_tmp174_, _tmp175_);
				_tmp177_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp176_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp176_) : NULL);
				button = _tmp177_;
				_tmp178_ = button;
				if (_tmp178_ != NULL) {
					GtkButton* _tmp179_;
					gint _tmp180_;
					GtkButton* _tmp181_;
					MathEquation* _tmp182_;
					gint _tmp183_;
					gunichar _tmp184_ = 0U;
					gchar* _tmp185_ = NULL;
					gchar* _tmp186_;
					GtkButton* _tmp187_;
					_tmp179_ = button;
					_tmp180_ = i;
					g_object_set_data_full ((GObject*) _tmp179_, "calc_digit", (gpointer) ((gintptr) _tmp180_), NULL);
					_tmp181_ = button;
					_tmp182_ = self->priv->equation;
					_tmp183_ = i;
					_tmp184_ = math_equation_get_digit_text (_tmp182_, (guint) _tmp183_);
					_tmp185_ = g_unichar_to_string (_tmp184_);
					_tmp186_ = _tmp185_;
					gtk_button_set_label (_tmp181_, _tmp186_);
					_g_free0 (_tmp186_);
					_tmp187_ = button;
					g_signal_connect_object (_tmp187_, "clicked", (GCallback) _______lambda14__gtk_button_clicked, self, 0);
				}
				_g_object_unref0 (button);
				_g_free0 (name);
			}
		}
	}
	_tmp188_ = builder;
	_tmp189_ = gtk_builder_get_object (_tmp188_, "calc_subtract_button");
	_tmp190_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp189_) : NULL);
	button = _tmp190_;
	_tmp191_ = button;
	if (_tmp191_ != NULL) {
		GtkButton* _tmp192_;
		_tmp192_ = button;
		g_signal_connect_object (_tmp192_, "clicked", (GCallback) ____lambda15__gtk_button_clicked, self, 0);
	}
	_tmp193_ = builder;
	_tmp194_ = gtk_builder_get_object (_tmp193_, "calc_undo_button");
	_tmp195_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp194_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp194_) : NULL);
	_g_object_unref0 (button);
	button = _tmp195_;
	_tmp196_ = button;
	if (_tmp196_ != NULL) {
		GtkButton* _tmp197_;
		_tmp197_ = button;
		g_signal_connect_object (_tmp197_, "clicked", (GCallback) ____lambda16__gtk_button_clicked, self, 0);
	}
	_tmp198_ = builder;
	_tmp199_ = gtk_builder_get_object (_tmp198_, "calc_result_button");
	_tmp200_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp199_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp199_) : NULL);
	_g_object_unref0 (button);
	button = _tmp200_;
	_tmp201_ = button;
	if (_tmp201_ != NULL) {
		GtkButton* _tmp202_;
		_tmp202_ = button;
		g_signal_connect_object (_tmp202_, "clicked", (GCallback) ____lambda17__gtk_button_clicked, self, 0);
	}
	_tmp203_ = builder;
	_tmp204_ = gtk_builder_get_object (_tmp203_, "calc_clear_button");
	_tmp205_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp204_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp204_) : NULL);
	_g_object_unref0 (button);
	button = _tmp205_;
	_tmp206_ = button;
	if (_tmp206_ != NULL) {
		GtkButton* _tmp207_;
		_tmp207_ = button;
		g_signal_connect_object (_tmp207_, "clicked", (GCallback) ____lambda18__gtk_button_clicked, self, 0);
	}
	_tmp208_ = builder;
	_tmp209_ = gtk_builder_get_object (_tmp208_, "calc_memory_button");
	_tmp210_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp209_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp209_) : NULL);
	_g_object_unref0 (button);
	button = _tmp210_;
	_tmp211_ = button;
	if (_tmp211_ != NULL) {
		GtkButton* _tmp212_;
		_tmp212_ = button;
		g_signal_connect_object (_tmp212_, "clicked", (GCallback) _math_buttons_memory_cb_gtk_button_clicked, self, 0);
	}
	_tmp213_ = builder;
	_tmp214_ = gtk_builder_get_object (_tmp213_, "calc_function_button");
	_tmp215_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp214_) : NULL);
	_g_object_unref0 (button);
	button = _tmp215_;
	_tmp216_ = button;
	if (_tmp216_ != NULL) {
		GtkButton* _tmp217_;
		_tmp217_ = button;
		g_signal_connect_object (_tmp217_, "clicked", (GCallback) _math_buttons_function_cb_gtk_button_clicked, self, 0);
	}
	_tmp218_ = builder;
	_tmp219_ = gtk_builder_get_object (_tmp218_, "calc_factor_button");
	_tmp220_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp219_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp219_) : NULL);
	_g_object_unref0 (button);
	button = _tmp220_;
	_tmp221_ = button;
	if (_tmp221_ != NULL) {
		GtkButton* _tmp222_;
		_tmp222_ = button;
		g_signal_connect_object (_tmp222_, "clicked", (GCallback) ____lambda21__gtk_button_clicked, self, 0);
	}
	_tmp223_ = builder;
	_tmp224_ = gtk_builder_get_object (_tmp223_, "calc_exponential_button");
	_tmp225_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp224_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp224_) : NULL);
	_g_object_unref0 (button);
	button = _tmp225_;
	_tmp226_ = button;
	if (_tmp226_ != NULL) {
		GtkButton* _tmp227_;
		_tmp227_ = button;
		g_signal_connect_object (_tmp227_, "clicked", (GCallback) ____lambda22__gtk_button_clicked, self, 0);
	}
	_tmp228_ = builder;
	_tmp229_ = gtk_builder_get_object (_tmp228_, "calc_shift_left_button");
	_tmp230_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp229_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp229_) : NULL);
	_g_object_unref0 (button);
	button = _tmp230_;
	_tmp231_ = button;
	if (_tmp231_ != NULL) {
		GtkButton* _tmp232_;
		_tmp232_ = button;
		g_signal_connect_object (_tmp232_, "clicked", (GCallback) _math_buttons_shift_left_cb_gtk_button_clicked, self, 0);
	}
	_tmp233_ = builder;
	_tmp234_ = gtk_builder_get_object (_tmp233_, "calc_shift_right_button");
	_tmp235_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp234_) : NULL);
	_g_object_unref0 (button);
	button = _tmp235_;
	_tmp236_ = button;
	if (_tmp236_ != NULL) {
		GtkButton* _tmp237_;
		_tmp237_ = button;
		g_signal_connect_object (_tmp237_, "clicked", (GCallback) _math_buttons_shift_right_cb_gtk_button_clicked, self, 0);
	}
	_tmp238_ = builder;
	_tmp239_ = gtk_builder_get_object (_tmp238_, "calc_character_button");
	_tmp240_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp239_) : NULL);
	_g_object_unref0 (button);
	button = _tmp240_;
	_tmp241_ = button;
	if (_tmp241_ != NULL) {
		GtkButton* _tmp242_;
		_tmp242_ = button;
		g_signal_connect_object (_tmp242_, "clicked", (GCallback) _math_buttons_insert_character_code_cb_gtk_button_clicked, self, 0);
	}
	_tmp243_ = builder;
	_tmp244_ = gtk_builder_get_object (_tmp243_, "calc_numeric_point_button");
	_tmp245_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp244_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp244_) : NULL);
	_g_object_unref0 (button);
	button = _tmp245_;
	_tmp246_ = button;
	if (_tmp246_ != NULL) {
		GtkButton* _tmp247_;
		MathEquation* _tmp248_;
		Serializer* _tmp249_;
		Serializer* _tmp250_;
		gunichar _tmp251_ = 0U;
		gchar* _tmp252_ = NULL;
		gchar* _tmp253_;
		GtkButton* _tmp254_;
		_tmp247_ = button;
		_tmp248_ = self->priv->equation;
		_tmp249_ = math_equation_get_serializer (_tmp248_);
		_tmp250_ = _tmp249_;
		_tmp251_ = serializer_get_radix (_tmp250_);
		_tmp252_ = g_unichar_to_string (_tmp251_);
		_tmp253_ = _tmp252_;
		gtk_button_set_label (_tmp247_, _tmp253_);
		_g_free0 (_tmp253_);
		_tmp254_ = button;
		g_signal_connect_object (_tmp254_, "clicked", (GCallback) ____lambda25__gtk_button_clicked, self, 0);
	}
	_tmp255_ = builder;
	_tmp256_ = gtk_builder_get_object (_tmp255_, "calc_superscript_button");
	_tmp257_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp256_) : NULL);
	toggle_button = _tmp257_;
	_tmp258_ = toggle_button;
	if (_tmp258_ != NULL) {
		GtkToggleButton* _tmp259_;
		GtkToggleButton* _tmp260_;
		MathEquation* _tmp261_;
		NumberMode _tmp262_;
		NumberMode _tmp263_;
		GtkToggleButton* _tmp265_;
		_tmp259_ = toggle_button;
		_tmp260_ = _g_object_ref0 (_tmp259_);
		self->priv->superscript_toggles = g_list_append (self->priv->superscript_toggles, _tmp260_);
		_tmp261_ = self->priv->equation;
		_tmp262_ = math_equation_get_number_mode (_tmp261_);
		_tmp263_ = _tmp262_;
		if (_tmp263_ == NUMBER_MODE_SUPERSCRIPT) {
			GtkToggleButton* _tmp264_;
			_tmp264_ = toggle_button;
			gtk_toggle_button_set_active (_tmp264_, TRUE);
		}
		_tmp265_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp265_, "clicked", (GCallback) _math_buttons_set_superscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp266_ = builder;
	_tmp267_ = gtk_builder_get_object (_tmp266_, "calc_subscript_button");
	_tmp268_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp267_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp267_) : NULL);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp268_;
	_tmp269_ = toggle_button;
	if (_tmp269_ != NULL) {
		GtkToggleButton* _tmp270_;
		GtkToggleButton* _tmp271_;
		MathEquation* _tmp272_;
		NumberMode _tmp273_;
		NumberMode _tmp274_;
		GtkToggleButton* _tmp276_;
		_tmp270_ = toggle_button;
		_tmp271_ = _g_object_ref0 (_tmp270_);
		self->priv->subscript_toggles = g_list_append (self->priv->subscript_toggles, _tmp271_);
		_tmp272_ = self->priv->equation;
		_tmp273_ = math_equation_get_number_mode (_tmp272_);
		_tmp274_ = _tmp273_;
		if (_tmp274_ == NUMBER_MODE_SUBSCRIPT) {
			GtkToggleButton* _tmp275_;
			_tmp275_ = toggle_button;
			gtk_toggle_button_set_active (_tmp275_, TRUE);
		}
		_tmp276_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp276_, "clicked", (GCallback) _math_buttons_set_subscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp277_ = mode;
	if (_tmp277_ == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp278_;
		GObject* _tmp279_ = NULL;
		GtkLabel* _tmp280_;
		GtkBuilder* _tmp281_;
		GObject* _tmp282_ = NULL;
		GtkDialog* _tmp283_;
		GtkDialog* _tmp284_;
		GtkDialog* _tmp285_;
		GtkBuilder* _tmp286_;
		GObject* _tmp287_ = NULL;
		GtkEntry* _tmp288_;
		GtkEntry* _tmp289_;
		GtkBuilder* _tmp290_;
		GObject* _tmp291_ = NULL;
		GtkWidget* _tmp292_;
		gint i;
		GtkBuilder* _tmp312_;
		GObject* _tmp313_ = NULL;
		GtkComboBox* _tmp314_;
		GtkListStore* _tmp315_;
		GtkListStore* model;
		GtkComboBox* _tmp316_;
		GtkListStore* _tmp317_;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp318_;
		GtkTreeIter _tmp319_ = {0};
		GtkListStore* _tmp320_;
		GtkTreeIter _tmp321_;
		const gchar* _tmp322_ = NULL;
		GtkListStore* _tmp323_;
		GtkTreeIter _tmp324_ = {0};
		GtkListStore* _tmp325_;
		GtkTreeIter _tmp326_;
		const gchar* _tmp327_ = NULL;
		GtkListStore* _tmp328_;
		GtkTreeIter _tmp329_ = {0};
		GtkListStore* _tmp330_;
		GtkTreeIter _tmp331_;
		const gchar* _tmp332_ = NULL;
		GtkListStore* _tmp333_;
		GtkTreeIter _tmp334_ = {0};
		GtkListStore* _tmp335_;
		GtkTreeIter _tmp336_;
		const gchar* _tmp337_ = NULL;
		GtkCellRendererText* _tmp338_;
		GtkCellRendererText* renderer;
		GtkComboBox* _tmp339_;
		GtkCellRendererText* _tmp340_;
		GtkComboBox* _tmp341_;
		GtkCellRendererText* _tmp342_;
		GtkComboBox* _tmp343_;
		MathEquation* _tmp344_;
		_tmp278_ = builder;
		_tmp279_ = gtk_builder_get_object (_tmp278_, "base_label");
		_tmp280_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp279_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp279_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp280_;
		_tmp281_ = builder;
		_tmp282_ = gtk_builder_get_object (_tmp281_, "character_code_dialog");
		_tmp283_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp282_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp282_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp283_;
		_tmp284_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp284_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp285_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp285_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
		_tmp286_ = builder;
		_tmp287_ = gtk_builder_get_object (_tmp286_, "character_code_entry");
		_tmp288_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp287_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp287_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp288_;
		_tmp289_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp289_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp290_ = builder;
		_tmp291_ = gtk_builder_get_object (_tmp290_, "bit_table");
		_tmp292_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp291_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp291_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp292_;
		__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
		self->priv->bit_labels = NULL;
		i = 0;
		while (TRUE) {
			gint _tmp293_;
			gchar* _tmp294_ = NULL;
			gchar* name;
			GtkBuilder* _tmp295_;
			const gchar* _tmp296_;
			GObject* _tmp297_ = NULL;
			GtkLabel* _tmp298_;
			GtkLabel* label;
			GtkLabel* _tmp299_;
			GtkLabel* _tmp300_;
			GtkLabel* _tmp301_;
			gint _tmp302_;
			gchar* _tmp303_ = NULL;
			GtkBuilder* _tmp304_;
			const gchar* _tmp305_;
			GObject* _tmp306_ = NULL;
			GtkEventBox* _tmp307_;
			GtkEventBox* box;
			GtkEventBox* _tmp308_;
			gint _tmp309_;
			GtkEventBox* _tmp310_;
			gint _tmp311_;
			_tmp293_ = i;
			_tmp294_ = g_strdup_printf ("bit_label_%d", _tmp293_);
			name = _tmp294_;
			_tmp295_ = builder;
			_tmp296_ = name;
			_tmp297_ = gtk_builder_get_object (_tmp295_, _tmp296_);
			_tmp298_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp297_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp297_) : NULL);
			label = _tmp298_;
			_tmp299_ = label;
			if (_tmp299_ == NULL) {
				_g_object_unref0 (label);
				_g_free0 (name);
				break;
			}
			_tmp300_ = label;
			_tmp301_ = _g_object_ref0 (_tmp300_);
			self->priv->bit_labels = g_list_append (self->priv->bit_labels, _tmp301_);
			_tmp302_ = i;
			_tmp303_ = g_strdup_printf ("bit_eventbox_%d", _tmp302_);
			_g_free0 (name);
			name = _tmp303_;
			_tmp304_ = builder;
			_tmp305_ = name;
			_tmp306_ = gtk_builder_get_object (_tmp304_, _tmp305_);
			_tmp307_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp306_, GTK_TYPE_EVENT_BOX) ? ((GtkEventBox*) _tmp306_) : NULL);
			box = _tmp307_;
			_tmp308_ = box;
			_tmp309_ = i;
			g_object_set_data_full ((GObject*) _tmp308_, "bit_index", (gpointer) ((gintptr) _tmp309_), NULL);
			_tmp310_ = box;
			g_signal_connect_object ((GtkWidget*) _tmp310_, "button-press-event", (GCallback) _math_buttons_bit_toggle_cb_gtk_widget_button_press_event, self, 0);
			_tmp311_ = i;
			i = _tmp311_ + 1;
			_g_object_unref0 (box);
			_g_object_unref0 (label);
			_g_free0 (name);
		}
		self->priv->bit_labels = g_list_reverse (self->priv->bit_labels);
		_tmp312_ = builder;
		_tmp313_ = gtk_builder_get_object (_tmp312_, "base_combo");
		_tmp314_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp313_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp313_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp314_;
		_tmp315_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
		model = _tmp315_;
		_tmp316_ = self->priv->base_combo;
		_tmp317_ = model;
		gtk_combo_box_set_model (_tmp316_, (GtkTreeModel*) _tmp317_);
		_tmp318_ = model;
		gtk_list_store_append (_tmp318_, &_tmp319_);
		iter = _tmp319_;
		_tmp320_ = model;
		_tmp321_ = iter;
		_tmp322_ = _ ("Binary");
		gtk_list_store_set (_tmp320_, &_tmp321_, 0, _tmp322_, 1, 2, -1, -1);
		_tmp323_ = model;
		gtk_list_store_append (_tmp323_, &_tmp324_);
		iter = _tmp324_;
		_tmp325_ = model;
		_tmp326_ = iter;
		_tmp327_ = _ ("Octal");
		gtk_list_store_set (_tmp325_, &_tmp326_, 0, _tmp327_, 1, 8, -1, -1);
		_tmp328_ = model;
		gtk_list_store_append (_tmp328_, &_tmp329_);
		iter = _tmp329_;
		_tmp330_ = model;
		_tmp331_ = iter;
		_tmp332_ = _ ("Decimal");
		gtk_list_store_set (_tmp330_, &_tmp331_, 0, _tmp332_, 1, 10, -1, -1);
		_tmp333_ = model;
		gtk_list_store_append (_tmp333_, &_tmp334_);
		iter = _tmp334_;
		_tmp335_ = model;
		_tmp336_ = iter;
		_tmp337_ = _ ("Hexadecimal");
		gtk_list_store_set (_tmp335_, &_tmp336_, 0, _tmp337_, 1, 16, -1, -1);
		_tmp338_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp338_);
		renderer = _tmp338_;
		_tmp339_ = self->priv->base_combo;
		_tmp340_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp339_, (GtkCellRenderer*) _tmp340_, TRUE);
		_tmp341_ = self->priv->base_combo;
		_tmp342_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp341_, (GtkCellRenderer*) _tmp342_, "text", 0);
		_tmp343_ = self->priv->base_combo;
		g_signal_connect_object (_tmp343_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp344_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp344_, "notify::number-base", (GCallback) ____lambda26__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
		_g_object_unref0 (renderer);
		_g_object_unref0 (model);
	}
	_tmp345_ = mode;
	if (_tmp345_ == BUTTON_MODE_FINANCIAL) {
		GtkBuilder* _tmp346_;
		GObject* _tmp347_ = NULL;
		GtkButton* _tmp348_;
		GtkButton* _tmp349_;
		GtkBuilder* _tmp353_;
		GObject* _tmp354_ = NULL;
		GtkButton* _tmp355_;
		GtkButton* _tmp356_;
		GtkBuilder* _tmp360_;
		GObject* _tmp361_ = NULL;
		GtkButton* _tmp362_;
		GtkButton* _tmp363_;
		GtkBuilder* _tmp367_;
		GObject* _tmp368_ = NULL;
		GtkButton* _tmp369_;
		GtkButton* _tmp370_;
		GtkBuilder* _tmp374_;
		GObject* _tmp375_ = NULL;
		GtkButton* _tmp376_;
		GtkButton* _tmp377_;
		GtkBuilder* _tmp381_;
		GObject* _tmp382_ = NULL;
		GtkButton* _tmp383_;
		GtkButton* _tmp384_;
		GtkBuilder* _tmp388_;
		GObject* _tmp389_ = NULL;
		GtkButton* _tmp390_;
		GtkButton* _tmp391_;
		GtkBuilder* _tmp395_;
		GObject* _tmp396_ = NULL;
		GtkButton* _tmp397_;
		GtkButton* _tmp398_;
		GtkBuilder* _tmp402_;
		GObject* _tmp403_ = NULL;
		GtkButton* _tmp404_;
		GtkButton* _tmp405_;
		GtkBuilder* _tmp409_;
		GObject* _tmp410_ = NULL;
		GtkButton* _tmp411_;
		GtkButton* _tmp412_;
		math_buttons_load_finc_dialogs (self);
		_tmp346_ = builder;
		_tmp347_ = gtk_builder_get_object (_tmp346_, "calc_finc_compounding_term_button");
		_tmp348_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp347_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp347_) : NULL);
		_g_object_unref0 (button);
		button = _tmp348_;
		_tmp349_ = button;
		if (_tmp349_ != NULL) {
			GtkButton* _tmp350_;
			gchar* _tmp351_;
			GtkButton* _tmp352_;
			_tmp350_ = button;
			_tmp351_ = g_strdup ("ctrm_dialog");
			g_object_set_data_full ((GObject*) _tmp350_, "finc-dialog-name", _tmp351_, g_free);
			_tmp352_ = button;
			g_signal_connect_object (_tmp352_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp353_ = builder;
		_tmp354_ = gtk_builder_get_object (_tmp353_, "calc_finc_double_declining_depreciation_button");
		_tmp355_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp354_) : NULL);
		_g_object_unref0 (button);
		button = _tmp355_;
		_tmp356_ = button;
		if (_tmp356_ != NULL) {
			GtkButton* _tmp357_;
			gchar* _tmp358_;
			GtkButton* _tmp359_;
			_tmp357_ = button;
			_tmp358_ = g_strdup ("ddb_dialog");
			g_object_set_data_full ((GObject*) _tmp357_, "finc-dialog-name", _tmp358_, g_free);
			_tmp359_ = button;
			g_signal_connect_object (_tmp359_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp360_ = builder;
		_tmp361_ = gtk_builder_get_object (_tmp360_, "calc_finc_future_value_button");
		_tmp362_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp361_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp361_) : NULL);
		_g_object_unref0 (button);
		button = _tmp362_;
		_tmp363_ = button;
		if (_tmp363_ != NULL) {
			GtkButton* _tmp364_;
			gchar* _tmp365_;
			GtkButton* _tmp366_;
			_tmp364_ = button;
			_tmp365_ = g_strdup ("fv_dialog");
			g_object_set_data_full ((GObject*) _tmp364_, "finc-dialog-name", _tmp365_, g_free);
			_tmp366_ = button;
			g_signal_connect_object (_tmp366_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp367_ = builder;
		_tmp368_ = gtk_builder_get_object (_tmp367_, "calc_finc_gross_profit_margin_button");
		_tmp369_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp368_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp368_) : NULL);
		_g_object_unref0 (button);
		button = _tmp369_;
		_tmp370_ = button;
		if (_tmp370_ != NULL) {
			GtkButton* _tmp371_;
			gchar* _tmp372_;
			GtkButton* _tmp373_;
			_tmp371_ = button;
			_tmp372_ = g_strdup ("gpm_dialog");
			g_object_set_data_full ((GObject*) _tmp371_, "finc-dialog-name", _tmp372_, g_free);
			_tmp373_ = button;
			g_signal_connect_object (_tmp373_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp374_ = builder;
		_tmp375_ = gtk_builder_get_object (_tmp374_, "calc_finc_periodic_payment_button");
		_tmp376_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp375_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp375_) : NULL);
		_g_object_unref0 (button);
		button = _tmp376_;
		_tmp377_ = button;
		if (_tmp377_ != NULL) {
			GtkButton* _tmp378_;
			gchar* _tmp379_;
			GtkButton* _tmp380_;
			_tmp378_ = button;
			_tmp379_ = g_strdup ("pmt_dialog");
			g_object_set_data_full ((GObject*) _tmp378_, "finc-dialog-name", _tmp379_, g_free);
			_tmp380_ = button;
			g_signal_connect_object (_tmp380_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp381_ = builder;
		_tmp382_ = gtk_builder_get_object (_tmp381_, "calc_finc_present_value_button");
		_tmp383_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp382_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp382_) : NULL);
		_g_object_unref0 (button);
		button = _tmp383_;
		_tmp384_ = button;
		if (_tmp384_ != NULL) {
			GtkButton* _tmp385_;
			gchar* _tmp386_;
			GtkButton* _tmp387_;
			_tmp385_ = button;
			_tmp386_ = g_strdup ("pv_dialog");
			g_object_set_data_full ((GObject*) _tmp385_, "finc-dialog-name", _tmp386_, g_free);
			_tmp387_ = button;
			g_signal_connect_object (_tmp387_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp388_ = builder;
		_tmp389_ = gtk_builder_get_object (_tmp388_, "calc_finc_periodic_interest_rate_button");
		_tmp390_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp389_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp389_) : NULL);
		_g_object_unref0 (button);
		button = _tmp390_;
		_tmp391_ = button;
		if (_tmp391_ != NULL) {
			GtkButton* _tmp392_;
			gchar* _tmp393_;
			GtkButton* _tmp394_;
			_tmp392_ = button;
			_tmp393_ = g_strdup ("rate_dialog");
			g_object_set_data_full ((GObject*) _tmp392_, "finc-dialog-name", _tmp393_, g_free);
			_tmp394_ = button;
			g_signal_connect_object (_tmp394_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp395_ = builder;
		_tmp396_ = gtk_builder_get_object (_tmp395_, "calc_finc_straight_line_depreciation_button");
		_tmp397_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp396_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp396_) : NULL);
		_g_object_unref0 (button);
		button = _tmp397_;
		_tmp398_ = button;
		if (_tmp398_ != NULL) {
			GtkButton* _tmp399_;
			gchar* _tmp400_;
			GtkButton* _tmp401_;
			_tmp399_ = button;
			_tmp400_ = g_strdup ("sln_dialog");
			g_object_set_data_full ((GObject*) _tmp399_, "finc-dialog-name", _tmp400_, g_free);
			_tmp401_ = button;
			g_signal_connect_object (_tmp401_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp402_ = builder;
		_tmp403_ = gtk_builder_get_object (_tmp402_, "calc_finc_sum_of_the_years_digits_depreciation_button");
		_tmp404_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp403_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp403_) : NULL);
		_g_object_unref0 (button);
		button = _tmp404_;
		_tmp405_ = button;
		if (_tmp405_ != NULL) {
			GtkButton* _tmp406_;
			gchar* _tmp407_;
			GtkButton* _tmp408_;
			_tmp406_ = button;
			_tmp407_ = g_strdup ("syd_dialog");
			g_object_set_data_full ((GObject*) _tmp406_, "finc-dialog-name", _tmp407_, g_free);
			_tmp408_ = button;
			g_signal_connect_object (_tmp408_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp409_ = builder;
		_tmp410_ = gtk_builder_get_object (_tmp409_, "calc_finc_term_button");
		_tmp411_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp410_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp410_) : NULL);
		_g_object_unref0 (button);
		button = _tmp411_;
		_tmp412_ = button;
		if (_tmp412_ != NULL) {
			GtkButton* _tmp413_;
			gchar* _tmp414_;
			GtkButton* _tmp415_;
			_tmp413_ = button;
			_tmp414_ = g_strdup ("term_dialog");
			g_object_set_data_full ((GObject*) _tmp413_, "finc-dialog-name", _tmp414_, g_free);
			_tmp415_ = button;
			g_signal_connect_object (_tmp415_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
	}
	_tmp416_ = builder;
	gtk_builder_connect_signals (_tmp416_, self);
	math_buttons_update_bit_panel (self);
	result = panel;
	_g_object_unref0 (toggle_button);
	_g_object_unref0 (button);
	_g_free0 (builder_filename);
	_g_object_unref0 (builder);
	return result;
}


static void ___lambda13_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_;
	GtkButton* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_text");
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
}


static void ____lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda13_ (self, _sender);
}


static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* widget_name;
	GtkBuilder* _tmp2_;
	const gchar* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkButton* button;
	GtkButton* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp12_;
	GtkButton* _tmp15_;
	AtkObject* _tmp16_ = NULL;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup_printf ("calc_%s_button", _tmp0_);
	widget_name = _tmp1_;
	_tmp2_ = builder;
	_tmp3_ = widget_name;
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp4_) : NULL);
	button = _tmp5_;
	_tmp6_ = button;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (button);
		_g_free0 (widget_name);
		return;
	}
	_tmp7_ = data;
	if (_tmp7_ != NULL) {
		GtkButton* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GtkButton* _tmp11_;
		_tmp8_ = button;
		_tmp9_ = data;
		_tmp10_ = g_strdup (_tmp9_);
		g_object_set_data_full ((GObject*) _tmp8_, "calc_text", _tmp10_, g_free);
		_tmp11_ = button;
		g_signal_connect_object (_tmp11_, "clicked", (GCallback) ____lambda13__gtk_button_clicked, self, 0);
	}
	_tmp12_ = tooltip;
	if (_tmp12_ != NULL) {
		GtkButton* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = button;
		_tmp14_ = tooltip;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp14_);
	}
	_tmp15_ = button;
	_tmp16_ = gtk_widget_get_accessible ((GtkWidget*) _tmp15_);
	_tmp17_ = name;
	atk_object_set_name (_tmp16_, _tmp17_);
	_g_object_unref0 (button);
	_g_free0 (widget_name);
}


static void math_buttons_converter_changed_cb (MathButtons* self) {
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_;
	ButtonMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_;
		Unit* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		MathEquation* _tmp10_;
		Unit* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_;
		Unit* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		MathEquation* _tmp20_;
		Unit* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}


static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self) {
	math_buttons_converter_changed_cb (self);
}


static void math_buttons_load_buttons (MathButtons* self) {
	gboolean _tmp0_ = FALSE;
	MathConverter* _tmp1_;
	ButtonMode _tmp6_;
	ButtonMode _tmp7_;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* panel;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->converter;
	if (_tmp1_ == NULL) {
		MathEquation* _tmp2_;
		MathConverter* _tmp3_;
		MathConverter* _tmp4_;
		MathConverter* _tmp5_;
		_tmp2_ = self->priv->equation;
		_tmp3_ = math_converter_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp3_;
		_tmp4_ = self->priv->converter;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp5_ = self->priv->converter;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
	}
	_tmp6_ = math_buttons_get_mode (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
	panel = _tmp8_;
	_tmp9_ = self->priv->active_panel;
	_tmp10_ = panel;
	if (_tmp9_ == _tmp10_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp11_ = self->priv->active_panel;
	if (_tmp11_ != NULL) {
		GtkWidget* _tmp12_;
		_tmp12_ = self->priv->active_panel;
		gtk_widget_hide (_tmp12_);
	}
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp14_;
	_tmp15_ = panel;
	if (_tmp15_ != NULL) {
		GtkWidget* _tmp16_;
		_tmp16_ = panel;
		gtk_widget_show (_tmp16_);
	}
	_g_object_unref0 (panel);
}


static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	math_buttons_button_menu_position_func (self, menu, x, y, push_in);
}


static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu) {
	GtkMenu* _tmp0_;
	GtkButton* _tmp1_;
	GtkWidget* _tmp2_;
	GtkMenu* _tmp3_;
	guint32 _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = button;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	g_object_set_data_full ((GObject*) _tmp0_, "button", _tmp2_, g_object_unref);
	_tmp3_ = menu;
	_tmp4_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp3_, NULL, NULL, _math_buttons_button_menu_position_func_gtk_menu_position_func, self, (guint) 1, _tmp4_);
}


static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkMenu* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkButton* button;
	gint origin_x = 0;
	gint origin_y = 0;
	GdkWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint _tmp6_ = 0U;
	guint border;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_;
	gint _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "button");
	_tmp2_ = _g_object_ref0 ((GtkButton*) _tmp1_);
	button = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) button);
	gdk_window_get_origin (_tmp3_, &_tmp4_, &_tmp5_);
	origin_x = _tmp4_;
	origin_y = _tmp5_;
	_tmp6_ = gtk_container_get_border_width ((GtkContainer*) button);
	border = _tmp6_;
	gtk_widget_get_allocation ((GtkWidget*) button, &_tmp7_);
	allocation = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_vala_x = (gint) ((origin_x + _tmp9_) + border);
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	_vala_y = (gint) ((origin_y + _tmp11_) + border);
	_g_object_unref0 (button);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget) {
	MathEquation* _tmp0_;
	MathVariablePopup* _tmp1_;
	MathVariablePopup* popup;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_variable_popup_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	popup = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = widget;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	x = _tmp12_;
	y = _tmp13_;
	gtk_window_move ((GtkWindow*) popup, x, y);
	gtk_widget_show ((GtkWidget*) popup);
	_g_object_unref0 (popup);
}


static void ______lambda23_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_;
	GtkMenuItem* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda23__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda23_ (self, _sender);
}


static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_;
	GtkButton* _tmp29_;
	GtkMenu* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_left_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenu* _tmp2_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_left_menu);
		self->priv->shift_left_menu = _tmp1_;
		_tmp2_ = self->priv->shift_left_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					gint _tmp6_;
					gchar* format = NULL;
					gint _tmp7_;
					const gchar* _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* text;
					const gchar* _tmp17_;
					GtkLabel* _tmp18_;
					GtkLabel* label;
					GtkMenuItem* _tmp19_;
					GtkMenuItem* item;
					GtkMenuItem* _tmp20_;
					gint _tmp21_;
					GtkMenuItem* _tmp22_;
					GtkLabel* _tmp23_;
					GtkMenu* _tmp24_;
					GtkMenuItem* _tmp25_;
					GtkMenuItem* _tmp26_;
					GtkLabel* _tmp27_;
					GtkMenuItem* _tmp28_;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ < 16)) {
						break;
					}
					_tmp7_ = i;
					if (_tmp7_ < 10) {
						gint _tmp8_;
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp8_ = i;
						_tmp9_ = ngettext ("_%d place", "_%d places", (gulong) _tmp8_);
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (format);
						format = _tmp10_;
					} else {
						gint _tmp11_;
						const gchar* _tmp12_ = NULL;
						gchar* _tmp13_;
						_tmp11_ = i;
						_tmp12_ = ngettext ("%d place", "%d places", (gulong) _tmp11_);
						_tmp13_ = g_strdup (_tmp12_);
						_g_free0 (format);
						format = _tmp13_;
					}
					_tmp14_ = format;
					_tmp15_ = i;
					_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
					text = _tmp16_;
					_tmp17_ = text;
					_tmp18_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp17_);
					g_object_ref_sink (_tmp18_);
					label = _tmp18_;
					_tmp19_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp19_);
					item = _tmp19_;
					_tmp20_ = item;
					_tmp21_ = i;
					g_object_set_data_full ((GObject*) _tmp20_, "shiftcount", (gpointer) ((gintptr) _tmp21_), NULL);
					_tmp22_ = item;
					_tmp23_ = label;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
					_tmp24_ = self->priv->shift_left_menu;
					_tmp25_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp24_, (GtkWidget*) _tmp25_);
					_tmp26_ = item;
					g_signal_connect_object (_tmp26_, "activate", (GCallback) _______lambda23__gtk_menu_item_activate, self, 0);
					_tmp27_ = label;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_tmp28_ = item;
					gtk_widget_show ((GtkWidget*) _tmp28_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp29_ = button;
	_tmp30_ = self->priv->shift_left_menu;
	math_buttons_popup_button_menu (self, _tmp29_, _tmp30_);
}


static void ______lambda24_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_;
	GtkMenuItem* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda24__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda24_ (self, _sender);
}


static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_;
	GtkButton* _tmp29_;
	GtkMenu* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_right_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenu* _tmp2_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_right_menu);
		self->priv->shift_right_menu = _tmp1_;
		_tmp2_ = self->priv->shift_right_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					gint _tmp6_;
					gchar* format = NULL;
					gint _tmp7_;
					const gchar* _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* text;
					const gchar* _tmp17_;
					GtkLabel* _tmp18_;
					GtkLabel* label;
					GtkMenuItem* _tmp19_;
					GtkMenuItem* item;
					GtkMenuItem* _tmp20_;
					gint _tmp21_;
					GtkMenuItem* _tmp22_;
					GtkLabel* _tmp23_;
					GtkMenu* _tmp24_;
					GtkMenuItem* _tmp25_;
					GtkMenuItem* _tmp26_;
					GtkLabel* _tmp27_;
					GtkMenuItem* _tmp28_;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ < 16)) {
						break;
					}
					_tmp7_ = i;
					if (_tmp7_ < 10) {
						gint _tmp8_;
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp8_ = i;
						_tmp9_ = ngettext ("_%d place", "_%d places", (gulong) _tmp8_);
						_tmp10_ = g_strdup (_tmp9_);
						_g_free0 (format);
						format = _tmp10_;
					} else {
						gint _tmp11_;
						const gchar* _tmp12_ = NULL;
						gchar* _tmp13_;
						_tmp11_ = i;
						_tmp12_ = ngettext ("%d place", "%d places", (gulong) _tmp11_);
						_tmp13_ = g_strdup (_tmp12_);
						_g_free0 (format);
						format = _tmp13_;
					}
					_tmp14_ = format;
					_tmp15_ = i;
					_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
					text = _tmp16_;
					_tmp17_ = text;
					_tmp18_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp17_);
					g_object_ref_sink (_tmp18_);
					label = _tmp18_;
					_tmp19_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp19_);
					item = _tmp19_;
					_tmp20_ = item;
					_tmp21_ = i;
					g_object_set_data_full ((GObject*) _tmp20_, "shiftcount", (gpointer) ((gintptr) (-_tmp21_)), NULL);
					_tmp22_ = item;
					_tmp23_ = label;
					gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
					_tmp24_ = self->priv->shift_right_menu;
					_tmp25_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp24_, (GtkWidget*) _tmp25_);
					_tmp26_ = item;
					g_signal_connect_object (_tmp26_, "activate", (GCallback) _______lambda24__gtk_menu_item_activate, self, 0);
					_tmp27_ = label;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_tmp28_ = item;
					gtk_widget_show ((GtkWidget*) _tmp28_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp29_ = button;
	_tmp30_ = self->priv->shift_right_menu;
	math_buttons_popup_button_menu (self, _tmp29_, _tmp30_);
}


static void math_buttons_function_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_;
	GtkButton* _tmp15_;
	GtkMenu* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->function_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenu* _tmp2_;
		GtkMenu* _tmp3_;
		const gchar* _tmp4_ = NULL;
		GtkMenu* _tmp5_;
		const gchar* _tmp6_ = NULL;
		GtkMenu* _tmp7_;
		const gchar* _tmp8_ = NULL;
		GtkMenu* _tmp9_;
		const gchar* _tmp10_ = NULL;
		GtkMenu* _tmp11_;
		const gchar* _tmp12_ = NULL;
		GtkMenu* _tmp13_;
		const gchar* _tmp14_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->function_menu);
		self->priv->function_menu = _tmp1_;
		_tmp2_ = self->priv->function_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		_tmp3_ = self->priv->function_menu;
		_tmp4_ = _ ("Integer Component");
		math_buttons_add_function_menu_item (self, _tmp3_, _tmp4_, "int ");
		_tmp5_ = self->priv->function_menu;
		_tmp6_ = _ ("Fractional Component");
		math_buttons_add_function_menu_item (self, _tmp5_, _tmp6_, "frac ");
		_tmp7_ = self->priv->function_menu;
		_tmp8_ = _ ("Round");
		math_buttons_add_function_menu_item (self, _tmp7_, _tmp8_, "round ");
		_tmp9_ = self->priv->function_menu;
		_tmp10_ = _ ("Floor");
		math_buttons_add_function_menu_item (self, _tmp9_, _tmp10_, "floor ");
		_tmp11_ = self->priv->function_menu;
		_tmp12_ = _ ("Ceiling");
		math_buttons_add_function_menu_item (self, _tmp11_, _tmp12_, "ceil ");
		_tmp13_ = self->priv->function_menu;
		_tmp14_ = _ ("Sign");
		math_buttons_add_function_menu_item (self, _tmp13_, _tmp14_, "sgn ");
	}
	_tmp15_ = button;
	_tmp16_ = self->priv->function_menu;
	math_buttons_popup_button_menu (self, _tmp15_, _tmp16_);
}


static void __lambda20_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_;
	GtkMenuItem* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "function");
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
}


static void ___lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda20_ (self, _sender);
}


static void math_buttons_add_function_menu_item (MathButtons* self, GtkMenu* menu, const gchar* label, const gchar* function) {
	const gchar* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* item;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkMenu* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (function != NULL);
	_tmp0_ = label;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
	g_object_ref_sink (_tmp1_);
	item = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = g_strdup (_tmp2_);
	g_object_set_data_full ((GObject*) item, "function", _tmp3_, g_free);
	_tmp4_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) item);
	g_signal_connect_object (item, "activate", (GCallback) ___lambda20__gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) item);
	_g_object_unref0 (item);
}


static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_;
	GtkDialog* dialog;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "finc-dialog-name");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->financial_ui;
	_tmp4_ = gtk_builder_get_object (_tmp3_, name);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp4_) : NULL);
	dialog = _tmp5_;
	gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}


static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	GtkEntry* _tmp2_;
	GtkEntry* next_entry;
	GtkEntry* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "next-entry");
	_tmp2_ = _g_object_ref0 ((GtkEntry*) _tmp1_);
	next_entry = _tmp2_;
	_tmp3_ = next_entry;
	if (_tmp3_ == NULL) {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_ = NULL;
		GtkDialog* _tmp6_;
		GtkDialog* dialog;
		GtkDialog* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = widget;
		_tmp5_ = gtk_widget_get_toplevel (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp5_) : NULL);
		dialog = _tmp6_;
		_tmp7_ = dialog;
		_tmp8_ = gtk_widget_is_toplevel ((GtkWidget*) _tmp7_);
		if (_tmp8_) {
			GtkDialog* _tmp9_;
			_tmp9_ = dialog;
			gtk_dialog_response (_tmp9_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp10_;
		_tmp10_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (next_entry);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id) {
	gint _tmp0_;
	GtkWidget* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	FinancialDialog function;
	gchar** _tmp3_ = NULL;
	gchar** entries;
	gint entries_length1;
	gint _entries_size_;
	FinancialDialog _tmp4_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* _tmp19_[4] = {0};
	Number* arg[4];
	GtkBuilder* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	const gchar* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkEntry* _tmp41_;
	GtkEntry* first_entry;
	GtkEntry* _tmp42_;
	MathEquation* _tmp43_;
	FinancialDialog _tmp44_;
	Number* _tmp45_;
	Number* _tmp46_;
	Number* _tmp47_;
	Number* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp2_));
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp3_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_tmp4_ = function;
	switch (_tmp4_) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp5_;
			gint _tmp5__length1;
			_tmp5_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp7_;
			gint _tmp7__length1;
			_tmp7_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp8_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp9_;
			gint _tmp9__length1;
			_tmp9_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp10_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp12_;
			gint _tmp12__length1;
			_tmp12_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp12_;
			entries_length1 = _tmp12__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp13_;
			gint _tmp13__length1;
			_tmp13_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
			_tmp13__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp13_;
			entries_length1 = _tmp13__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp14_;
			gint _tmp14__length1;
			_tmp14_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
			_tmp14__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp14_;
			entries_length1 = _tmp14__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp15_ = number_new_integer ((gint64) 0);
	_tmp16_ = number_new_integer ((gint64) 0);
	_tmp17_ = number_new_integer ((gint64) 0);
	_tmp18_ = number_new_integer ((gint64) 0);
	_tmp19_[0] = _tmp15_;
	_tmp19_[1] = _tmp16_;
	_tmp19_[2] = _tmp17_;
	_tmp19_[3] = _tmp18_;
	memcpy (arg, _tmp19_, 4 * sizeof (Number*));
	{
		gint i;
		i = 0;
		{
			gboolean _tmp20_;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_;
				gint _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				GtkBuilder* _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				const gchar* _tmp28_;
				GObject* _tmp29_ = NULL;
				GtkEntry* _tmp30_;
				GtkEntry* entry;
				gint _tmp31_;
				GtkEntry* _tmp32_;
				const gchar* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				Number* _tmp35_;
				GtkEntry* _tmp36_;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = entries;
				_tmp24__length1 = entries_length1;
				if (!(_tmp23_ < _tmp24__length1)) {
					break;
				}
				_tmp25_ = self->priv->financial_ui;
				_tmp26_ = entries;
				_tmp26__length1 = entries_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = gtk_builder_get_object (_tmp25_, _tmp28_);
				_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp29_) : NULL);
				entry = _tmp30_;
				_tmp31_ = i;
				_tmp32_ = entry;
				_tmp33_ = gtk_entry_get_text (_tmp32_);
				_tmp34_ = mp_set_from_string (_tmp33_, 10);
				_number_unref0 (arg[_tmp31_]);
				arg[_tmp31_] = _tmp34_;
				_tmp35_ = arg[_tmp31_];
				_tmp36_ = entry;
				gtk_entry_set_text (_tmp36_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp37_ = self->priv->financial_ui;
	_tmp38_ = entries;
	_tmp38__length1 = entries_length1;
	_tmp39_ = _tmp38_[0];
	_tmp40_ = gtk_builder_get_object (_tmp37_, _tmp39_);
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp40_) : NULL);
	first_entry = _tmp41_;
	_tmp42_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->equation;
	_tmp44_ = function;
	_tmp45_ = arg[0];
	_tmp46_ = arg[1];
	_tmp47_ = arg[2];
	_tmp48_ = arg[3];
	do_finc_expression (_tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, _tmp48_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) number_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* text;
	gint _tmp3_;
	GtkWidget* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
		Number* _tmp4_;
		Number* x;
		MathEquation* _tmp20_;
		Number* _tmp21_;
		_tmp4_ = number_new_integer ((gint64) 0);
		x = _tmp4_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_;
					const gchar* _tmp8_;
					gint _tmp9_;
					gchar _tmp10_ = '\0';
					Number* _tmp11_;
					const gchar* _tmp12_;
					gint _tmp13_;
					gchar _tmp14_ = '\0';
					Number* _tmp15_;
					Number* _tmp16_;
					Number* _tmp17_ = NULL;
					Number* _tmp18_;
					Number* _tmp19_ = NULL;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = text;
					_tmp9_ = i;
					_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
					if (!(_tmp10_ != '\0')) {
						break;
					}
					_tmp11_ = x;
					_tmp12_ = text;
					_tmp13_ = i;
					_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
					_tmp15_ = number_new_integer ((gint64) _tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = number_add (_tmp11_, _tmp16_);
					_number_unref0 (x);
					x = _tmp17_;
					_number_unref0 (_tmp16_);
					_tmp18_ = x;
					_tmp19_ = number_shift (_tmp18_, 8);
					_number_unref0 (x);
					x = _tmp19_;
				}
			}
		}
		_tmp20_ = self->priv->equation;
		_tmp21_ = x;
		math_equation_insert_number (_tmp20_, _tmp21_);
		_number_unref0 (x);
	}
	_tmp22_ = dialog;
	gtk_widget_hide (_tmp22_);
	_g_free0 (text);
}


static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}


static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = dialog;
	math_buttons_character_code_dialog_response_cb (self, _tmp0_, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}


static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event) {
	gboolean result = FALSE;
	MathEquation* _tmp0_;
	GtkWidget* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_box != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->equation;
	_tmp1_ = event_box;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "bit_index");
	math_equation_toggle_bit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
	result = TRUE;
	return result;
}


static void math_buttons_remove_trailing_spaces (MathButtons* self) {
	MathEquation* _tmp0_;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_;
	GtkTextMark* insert_mark;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	insert_mark = _tmp2_;
	_tmp3_ = self->priv->equation;
	_tmp4_ = insert_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = end;
	start = _tmp6_;
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		MathEquation* _tmp10_;
		_tmp7_ = gtk_text_iter_backward_char (&start);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = gtk_text_iter_get_char (&start);
		_tmp9_ = g_unichar_isspace (_tmp8_);
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = self->priv->equation;
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp10_, &start, &end);
	}
	_g_object_unref0 (insert_mark);
}


static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget) {
	GtkButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* button;
	GtkToggleButton* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_;
		MathEquation* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUPERSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_;
		NumberMode _tmp9_;
		NumberMode _tmp10_;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
			MathEquation* _tmp11_;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget) {
	GtkButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* button;
	GtkToggleButton* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_;
		MathEquation* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUBSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_;
		NumberMode _tmp9_;
		NumberMode _tmp10_;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUBSCRIPT) {
			MathEquation* _tmp11_;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_number_mode_changed_cb (MathButtons* self) {
	MathEquation* _tmp0_;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	NumberMode mode;
	GList* _tmp3_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	mode = _tmp2_;
	_tmp3_ = self->priv->superscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp3_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp4_;
			GtkToggleButton* toggle = NULL;
			_tmp4_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp4_;
			{
				GtkToggleButton* _tmp5_;
				NumberMode _tmp6_;
				_tmp5_ = toggle;
				_tmp6_ = mode;
				gtk_toggle_button_set_active (_tmp5_, _tmp6_ == NUMBER_MODE_SUPERSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
	_tmp7_ = self->priv->subscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp7_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp8_;
			GtkToggleButton* toggle = NULL;
			_tmp8_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp8_;
			{
				GtkToggleButton* _tmp9_;
				NumberMode _tmp10_;
				_tmp9_ = toggle;
				_tmp10_ = mode;
				gtk_toggle_button_set_active (_tmp9_, _tmp10_ == NUMBER_MODE_SUBSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
}


ButtonMode math_buttons_get_mode (MathButtons* self) {
	ButtonMode result;
	ButtonMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void math_buttons_set_mode (MathButtons* self, ButtonMode value) {
	ButtonMode _tmp0_;
	ButtonMode _tmp1_;
	ButtonMode _tmp2_;
	ButtonMode _tmp3_;
	ButtonMode _tmp4_;
	gboolean _tmp8_ = FALSE;
	ButtonMode _tmp9_;
	ButtonMode _tmp10_;
	MathConverter* _tmp13_;
	gboolean _tmp14_;
	ButtonMode _tmp15_;
	ButtonMode _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_mode = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = self->priv->_programming_base;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	} else {
		MathEquation* _tmp7_;
		_tmp7_ = self->priv->equation;
		math_equation_set_number_base (_tmp7_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp9_ = math_buttons_get_mode (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == BUTTON_MODE_ADVANCED) {
		_tmp8_ = TRUE;
	} else {
		ButtonMode _tmp11_;
		ButtonMode _tmp12_;
		_tmp11_ = math_buttons_get_mode (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp13_ = self->priv->converter;
	_tmp14_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp14_);
	_tmp15_ = math_buttons_get_mode (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp17_;
		MathConverter* _tmp18_;
		MathEquation* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		MathEquation* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp17_ = self->priv->converter;
		math_converter_set_category (_tmp17_, NULL);
		_tmp18_ = self->priv->converter;
		_tmp19_ = self->priv->equation;
		_tmp20_ = math_equation_get_source_units (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->equation;
		_tmp24_ = math_equation_get_target_units (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		math_converter_set_conversion (_tmp18_, _tmp22_, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp22_);
	} else {
		ButtonMode _tmp27_;
		ButtonMode _tmp28_;
		_tmp27_ = math_buttons_get_mode (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp29_;
			MathConverter* _tmp30_;
			MathEquation* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			MathEquation* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp29_ = self->priv->converter;
			math_converter_set_category (_tmp29_, "currency");
			_tmp30_ = self->priv->converter;
			_tmp31_ = self->priv->equation;
			_tmp32_ = math_equation_get_source_currency (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->equation;
			_tmp36_ = math_equation_get_target_currency (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = _tmp37_;
			math_converter_set_conversion (_tmp30_, _tmp34_, _tmp38_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp34_);
		}
	}
	g_object_notify ((GObject *) self, "mode");
}


gint math_buttons_get_programming_base (MathButtons* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_programming_base;
	result = _tmp0_;
	return result;
}


void math_buttons_set_programming_base (MathButtons* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ButtonMode _tmp3_;
	ButtonMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_programming_base;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_programming_base = _tmp2_;
	g_object_notify ((GObject*) self, "programming-base");
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->equation;
		_tmp6_ = value;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	}
	g_object_notify ((GObject *) self, "programming-base");
}


static void math_buttons_class_init (MathButtonsClass * klass) {
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE, g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE, g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void math_buttons_instance_init (MathButtons * self) {
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
}


static void math_buttons_finalize (GObject* obj) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->shift_left_menu);
	_g_object_unref0 (self->priv->shift_right_menu);
	_g_object_unref0 (self->priv->function_menu);
	__g_list_free__g_object_unref0_0 (self->priv->superscript_toggles);
	__g_list_free__g_object_unref0_0 (self->priv->subscript_toggles);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->bit_panel);
	__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}


GType math_buttons_get_type (void) {
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (GTK_TYPE_BOX, "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



