/* equation-lexer.c generated by valac 0.34.3, the Vala compiler
 * generated from equation-lexer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Enum for tokens generated by pre-lexer and lexer. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_LEXER_TOKEN_TYPE (lexer_token_type_get_type ())

#define TYPE_PRE_LEXER (pre_lexer_get_type ())
#define PRE_LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRE_LEXER, PreLexer))
#define PRE_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRE_LEXER, PreLexerClass))
#define IS_PRE_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRE_LEXER))
#define IS_PRE_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRE_LEXER))
#define PRE_LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRE_LEXER, PreLexerClass))

typedef struct _PreLexer PreLexer;
typedef struct _PreLexerClass PreLexerClass;
typedef struct _PreLexerPrivate PreLexerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_LEXER_TOKEN (lexer_token_get_type ())
#define LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER_TOKEN, LexerToken))
#define LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER_TOKEN, LexerTokenClass))
#define IS_LEXER_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER_TOKEN))
#define IS_LEXER_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER_TOKEN))
#define LEXER_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER_TOKEN, LexerTokenClass))

typedef struct _LexerToken LexerToken;
typedef struct _LexerTokenClass LexerTokenClass;
typedef struct _LexerTokenPrivate LexerTokenPrivate;

#define TYPE_LEXER (lexer_get_type ())
#define LEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEXER, Lexer))
#define LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEXER, LexerClass))
#define IS_LEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEXER))
#define IS_LEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEXER))
#define LEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEXER, LexerClass))

typedef struct _Lexer Lexer;
typedef struct _LexerClass LexerClass;
typedef struct _LexerPrivate LexerPrivate;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_ERROR_CODE (error_code_get_type ())

typedef enum  {
	LEXER_TOKEN_TYPE_UNKNOWN,
	LEXER_TOKEN_TYPE_PL_DECIMAL,
	LEXER_TOKEN_TYPE_PL_DIGIT,
	LEXER_TOKEN_TYPE_PL_HEX,
	LEXER_TOKEN_TYPE_PL_SUPER_DIGIT,
	LEXER_TOKEN_TYPE_PL_SUPER_MINUS,
	LEXER_TOKEN_TYPE_PL_SUB_DIGIT,
	LEXER_TOKEN_TYPE_PL_FRACTION,
	LEXER_TOKEN_TYPE_PL_DEGREE,
	LEXER_TOKEN_TYPE_PL_MINUTE,
	LEXER_TOKEN_TYPE_PL_SECOND,
	LEXER_TOKEN_TYPE_PL_LETTER,
	LEXER_TOKEN_TYPE_PL_EOS,
	LEXER_TOKEN_TYPE_PL_SKIP,
	LEXER_TOKEN_TYPE_ADD,
	LEXER_TOKEN_TYPE_SUBTRACT,
	LEXER_TOKEN_TYPE_MULTIPLY,
	LEXER_TOKEN_TYPE_DIVIDE,
	LEXER_TOKEN_TYPE_MOD,
	LEXER_TOKEN_TYPE_L_FLOOR,
	LEXER_TOKEN_TYPE_R_FLOOR,
	LEXER_TOKEN_TYPE_L_CEILING,
	LEXER_TOKEN_TYPE_R_CEILING,
	LEXER_TOKEN_TYPE_ROOT,
	LEXER_TOKEN_TYPE_ROOT_3,
	LEXER_TOKEN_TYPE_ROOT_4,
	LEXER_TOKEN_TYPE_NOT,
	LEXER_TOKEN_TYPE_AND,
	LEXER_TOKEN_TYPE_OR,
	LEXER_TOKEN_TYPE_XOR,
	LEXER_TOKEN_TYPE_IN,
	LEXER_TOKEN_TYPE_NUMBER,
	LEXER_TOKEN_TYPE_SUP_NUMBER,
	LEXER_TOKEN_TYPE_NSUP_NUMBER,
	LEXER_TOKEN_TYPE_SUB_NUMBER,
	LEXER_TOKEN_TYPE_FUNCTION,
	LEXER_TOKEN_TYPE_VARIABLE,
	LEXER_TOKEN_TYPE_ASSIGN,
	LEXER_TOKEN_TYPE_L_R_BRACKET,
	LEXER_TOKEN_TYPE_R_R_BRACKET,
	LEXER_TOKEN_TYPE_L_S_BRACKET,
	LEXER_TOKEN_TYPE_R_S_BRACKET,
	LEXER_TOKEN_TYPE_L_C_BRACKET,
	LEXER_TOKEN_TYPE_R_C_BRACKET,
	LEXER_TOKEN_TYPE_ABS,
	LEXER_TOKEN_TYPE_POWER,
	LEXER_TOKEN_TYPE_FACTORIAL,
	LEXER_TOKEN_TYPE_PERCENTAGE,
	LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR
} LexerTokenType;

struct _PreLexer {
	GObject parent_instance;
	PreLexerPrivate * priv;
	gchar* stream;
	gint index;
	gint mark_index;
};

struct _PreLexerClass {
	GObjectClass parent_class;
};

struct _PreLexerPrivate {
	gboolean eos;
};

struct _LexerToken {
	GObject parent_instance;
	LexerTokenPrivate * priv;
	gchar* text;
	guint start_index;
	guint end_index;
	LexerTokenType type;
};

struct _LexerTokenClass {
	GObjectClass parent_class;
};

struct _Lexer {
	GObject parent_instance;
	LexerPrivate * priv;
	GList* tokens;
};

struct _LexerClass {
	GObjectClass parent_class;
};

struct _LexerPrivate {
	Parser* parser;
	PreLexer* prelexer;
	guint next_token;
	gint number_base;
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;


static gpointer pre_lexer_parent_class = NULL;
static gpointer lexer_token_parent_class = NULL;
static gpointer lexer_parent_class = NULL;

GType lexer_token_type_get_type (void) G_GNUC_CONST;
GType pre_lexer_get_type (void) G_GNUC_CONST;
#define PRE_LEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRE_LEXER, PreLexerPrivate))
enum  {
	PRE_LEXER_DUMMY_PROPERTY
};
PreLexer* pre_lexer_new (const gchar* input);
PreLexer* pre_lexer_construct (GType object_type, const gchar* input);
void pre_lexer_roll_back (PreLexer* self);
void pre_lexer_set_marker (PreLexer* self);
gchar* pre_lexer_get_marked_substring (PreLexer* self);
LexerTokenType pre_lexer_get_next_token (PreLexer* self);
static void pre_lexer_finalize (GObject* obj);
GType lexer_token_get_type (void) G_GNUC_CONST;
enum  {
	LEXER_TOKEN_DUMMY_PROPERTY
};
LexerToken* lexer_token_new (void);
LexerToken* lexer_token_construct (GType object_type);
static void lexer_token_finalize (GObject* obj);
GType lexer_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
#define LEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LEXER, LexerPrivate))
enum  {
	LEXER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Lexer* lexer_new (const gchar* input, Parser* parser, gint number_base);
Lexer* lexer_construct (GType object_type, const gchar* input, Parser* parser, gint number_base);
void lexer_scan (Lexer* self);
static LexerToken* lexer_insert_next_token (Lexer* self);
LexerToken* lexer_get_next_token (Lexer* self);
void lexer_roll_back (Lexer* self);
static gboolean lexer_check_if_function (Lexer* self);
gboolean parser_function_is_defined (Parser* self, const gchar* name);
static gboolean lexer_check_if_number (Lexer* self);
GType number_get_type (void) G_GNUC_CONST;
Number* mp_set_from_string (const gchar* str, gint default_base);
static LexerToken* lexer_insert_token (Lexer* self, LexerTokenType type);
GType error_code_get_type (void) G_GNUC_CONST;
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
static LexerToken* lexer_insert_digit (Lexer* self);
static LexerToken* lexer_insert_decimal (Lexer* self);
static LexerToken* lexer_insert_hex (Lexer* self);
static LexerToken* lexer_insert_letter (Lexer* self);
static LexerToken* lexer_insert_angle_num_dm (Lexer* self);
static LexerToken* lexer_insert_angle_num_dms (Lexer* self);
static LexerToken* lexer_insert_hex_dec (Lexer* self);
static LexerToken* lexer_insert_decimal_hex (Lexer* self);
static void lexer_finalize (GObject* obj);


GType lexer_token_type_get_type (void) {
	static volatile gsize lexer_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{LEXER_TOKEN_TYPE_UNKNOWN, "LEXER_TOKEN_TYPE_UNKNOWN", "unknown"}, {LEXER_TOKEN_TYPE_PL_DECIMAL, "LEXER_TOKEN_TYPE_PL_DECIMAL", "pl-decimal"}, {LEXER_TOKEN_TYPE_PL_DIGIT, "LEXER_TOKEN_TYPE_PL_DIGIT", "pl-digit"}, {LEXER_TOKEN_TYPE_PL_HEX, "LEXER_TOKEN_TYPE_PL_HEX", "pl-hex"}, {LEXER_TOKEN_TYPE_PL_SUPER_DIGIT, "LEXER_TOKEN_TYPE_PL_SUPER_DIGIT", "pl-super-digit"}, {LEXER_TOKEN_TYPE_PL_SUPER_MINUS, "LEXER_TOKEN_TYPE_PL_SUPER_MINUS", "pl-super-minus"}, {LEXER_TOKEN_TYPE_PL_SUB_DIGIT, "LEXER_TOKEN_TYPE_PL_SUB_DIGIT", "pl-sub-digit"}, {LEXER_TOKEN_TYPE_PL_FRACTION, "LEXER_TOKEN_TYPE_PL_FRACTION", "pl-fraction"}, {LEXER_TOKEN_TYPE_PL_DEGREE, "LEXER_TOKEN_TYPE_PL_DEGREE", "pl-degree"}, {LEXER_TOKEN_TYPE_PL_MINUTE, "LEXER_TOKEN_TYPE_PL_MINUTE", "pl-minute"}, {LEXER_TOKEN_TYPE_PL_SECOND, "LEXER_TOKEN_TYPE_PL_SECOND", "pl-second"}, {LEXER_TOKEN_TYPE_PL_LETTER, "LEXER_TOKEN_TYPE_PL_LETTER", "pl-letter"}, {LEXER_TOKEN_TYPE_PL_EOS, "LEXER_TOKEN_TYPE_PL_EOS", "pl-eos"}, {LEXER_TOKEN_TYPE_PL_SKIP, "LEXER_TOKEN_TYPE_PL_SKIP", "pl-skip"}, {LEXER_TOKEN_TYPE_ADD, "LEXER_TOKEN_TYPE_ADD", "add"}, {LEXER_TOKEN_TYPE_SUBTRACT, "LEXER_TOKEN_TYPE_SUBTRACT", "subtract"}, {LEXER_TOKEN_TYPE_MULTIPLY, "LEXER_TOKEN_TYPE_MULTIPLY", "multiply"}, {LEXER_TOKEN_TYPE_DIVIDE, "LEXER_TOKEN_TYPE_DIVIDE", "divide"}, {LEXER_TOKEN_TYPE_MOD, "LEXER_TOKEN_TYPE_MOD", "mod"}, {LEXER_TOKEN_TYPE_L_FLOOR, "LEXER_TOKEN_TYPE_L_FLOOR", "l-floor"}, {LEXER_TOKEN_TYPE_R_FLOOR, "LEXER_TOKEN_TYPE_R_FLOOR", "r-floor"}, {LEXER_TOKEN_TYPE_L_CEILING, "LEXER_TOKEN_TYPE_L_CEILING", "l-ceiling"}, {LEXER_TOKEN_TYPE_R_CEILING, "LEXER_TOKEN_TYPE_R_CEILING", "r-ceiling"}, {LEXER_TOKEN_TYPE_ROOT, "LEXER_TOKEN_TYPE_ROOT", "root"}, {LEXER_TOKEN_TYPE_ROOT_3, "LEXER_TOKEN_TYPE_ROOT_3", "root-3"}, {LEXER_TOKEN_TYPE_ROOT_4, "LEXER_TOKEN_TYPE_ROOT_4", "root-4"}, {LEXER_TOKEN_TYPE_NOT, "LEXER_TOKEN_TYPE_NOT", "not"}, {LEXER_TOKEN_TYPE_AND, "LEXER_TOKEN_TYPE_AND", "and"}, {LEXER_TOKEN_TYPE_OR, "LEXER_TOKEN_TYPE_OR", "or"}, {LEXER_TOKEN_TYPE_XOR, "LEXER_TOKEN_TYPE_XOR", "xor"}, {LEXER_TOKEN_TYPE_IN, "LEXER_TOKEN_TYPE_IN", "in"}, {LEXER_TOKEN_TYPE_NUMBER, "LEXER_TOKEN_TYPE_NUMBER", "number"}, {LEXER_TOKEN_TYPE_SUP_NUMBER, "LEXER_TOKEN_TYPE_SUP_NUMBER", "sup-number"}, {LEXER_TOKEN_TYPE_NSUP_NUMBER, "LEXER_TOKEN_TYPE_NSUP_NUMBER", "nsup-number"}, {LEXER_TOKEN_TYPE_SUB_NUMBER, "LEXER_TOKEN_TYPE_SUB_NUMBER", "sub-number"}, {LEXER_TOKEN_TYPE_FUNCTION, "LEXER_TOKEN_TYPE_FUNCTION", "function"}, {LEXER_TOKEN_TYPE_VARIABLE, "LEXER_TOKEN_TYPE_VARIABLE", "variable"}, {LEXER_TOKEN_TYPE_ASSIGN, "LEXER_TOKEN_TYPE_ASSIGN", "assign"}, {LEXER_TOKEN_TYPE_L_R_BRACKET, "LEXER_TOKEN_TYPE_L_R_BRACKET", "l-r-bracket"}, {LEXER_TOKEN_TYPE_R_R_BRACKET, "LEXER_TOKEN_TYPE_R_R_BRACKET", "r-r-bracket"}, {LEXER_TOKEN_TYPE_L_S_BRACKET, "LEXER_TOKEN_TYPE_L_S_BRACKET", "l-s-bracket"}, {LEXER_TOKEN_TYPE_R_S_BRACKET, "LEXER_TOKEN_TYPE_R_S_BRACKET", "r-s-bracket"}, {LEXER_TOKEN_TYPE_L_C_BRACKET, "LEXER_TOKEN_TYPE_L_C_BRACKET", "l-c-bracket"}, {LEXER_TOKEN_TYPE_R_C_BRACKET, "LEXER_TOKEN_TYPE_R_C_BRACKET", "r-c-bracket"}, {LEXER_TOKEN_TYPE_ABS, "LEXER_TOKEN_TYPE_ABS", "abs"}, {LEXER_TOKEN_TYPE_POWER, "LEXER_TOKEN_TYPE_POWER", "power"}, {LEXER_TOKEN_TYPE_FACTORIAL, "LEXER_TOKEN_TYPE_FACTORIAL", "factorial"}, {LEXER_TOKEN_TYPE_PERCENTAGE, "LEXER_TOKEN_TYPE_PERCENTAGE", "percentage"}, {LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR, "LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR", "argument-separator"}, {0, NULL, NULL}};
		GType lexer_token_type_type_id;
		lexer_token_type_type_id = g_enum_register_static ("LexerTokenType", values);
		g_once_init_leave (&lexer_token_type_type_id__volatile, lexer_token_type_type_id);
	}
	return lexer_token_type_type_id__volatile;
}


PreLexer* pre_lexer_construct (GType object_type, const gchar* input) {
	PreLexer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	self = (PreLexer*) g_object_new (object_type, NULL);
	_tmp0_ = input;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->stream);
	self->stream = _tmp1_;
	self->index = 0;
	self->mark_index = 0;
	return self;
}


PreLexer* pre_lexer_new (const gchar* input) {
	return pre_lexer_construct (TYPE_PRE_LEXER, input);
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void pre_lexer_roll_back (PreLexer* self) {
	gboolean _tmp0_ = FALSE;
	gunichar c = 0U;
	const gchar* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->eos;
	if (_tmp0_) {
		self->priv->eos = FALSE;
		return;
	}
	_tmp1_ = self->stream;
	string_get_prev_char (_tmp1_, &self->index, &_tmp2_);
	c = _tmp2_;
}


void pre_lexer_set_marker (PreLexer* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	self->mark_index = _tmp0_;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* pre_lexer_get_marked_substring (PreLexer* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->stream;
	_tmp1_ = self->mark_index;
	_tmp2_ = self->index;
	_tmp3_ = self->mark_index;
	_tmp4_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (_tmp2_ - _tmp3_));
	result = _tmp4_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


LexerTokenType pre_lexer_get_next_token (PreLexer* self) {
	LexerTokenType result = 0;
	gunichar c = 0U;
	const gchar* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gunichar _tmp4_ = 0U;
	gunichar _tmp6_ = 0U;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gunichar _tmp10_ = 0U;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gunichar _tmp24_ = 0U;
	gunichar _tmp34_ = 0U;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gunichar _tmp44_ = 0U;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gunichar _tmp68_ = 0U;
	gunichar _tmp83_ = 0U;
	gunichar _tmp84_ = 0U;
	gunichar _tmp85_ = 0U;
	gboolean _tmp86_ = FALSE;
	gunichar _tmp87_ = 0U;
	gboolean _tmp88_ = FALSE;
	gunichar _tmp90_ = 0U;
	gunichar _tmp91_ = 0U;
	gboolean _tmp92_ = FALSE;
	gunichar _tmp93_ = 0U;
	gboolean _tmp95_ = FALSE;
	gunichar _tmp96_ = 0U;
	gunichar _tmp98_ = 0U;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	gunichar _tmp101_ = 0U;
	gboolean _tmp104_ = FALSE;
	gunichar _tmp105_ = 0U;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	gunichar _tmp109_ = 0U;
	gunichar _tmp112_ = 0U;
	gunichar _tmp113_ = 0U;
	gunichar _tmp114_ = 0U;
	gunichar _tmp115_ = 0U;
	gunichar _tmp116_ = 0U;
	gunichar _tmp117_ = 0U;
	gunichar _tmp118_ = 0U;
	gunichar _tmp119_ = 0U;
	gunichar _tmp120_ = 0U;
	gunichar _tmp121_ = 0U;
	gunichar _tmp122_ = 0U;
	gunichar _tmp123_ = 0U;
	gunichar _tmp124_ = 0U;
	gunichar _tmp125_ = 0U;
	gunichar _tmp126_ = 0U;
	gunichar _tmp127_ = 0U;
	gunichar _tmp128_ = 0U;
	gunichar _tmp129_ = 0U;
	gunichar _tmp130_ = 0U;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp132_ = FALSE;
	gboolean _tmp133_ = FALSE;
	gunichar _tmp134_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->stream;
	_tmp2_ = string_get_next_char (_tmp0_, &self->index, &_tmp1_);
	c = _tmp1_;
	if (!_tmp2_) {
		self->priv->eos = TRUE;
		result = LEXER_TOKEN_TYPE_PL_EOS;
		return result;
	}
	self->priv->eos = FALSE;
	_tmp4_ = c;
	if (_tmp4_ == ((gunichar) ',')) {
		_tmp3_ = TRUE;
	} else {
		gunichar _tmp5_ = 0U;
		_tmp5_ = c;
		_tmp3_ = _tmp5_ == ((gunichar) '.');
	}
	if (_tmp3_) {
		result = LEXER_TOKEN_TYPE_PL_DECIMAL;
		return result;
	}
	_tmp6_ = c;
	_tmp7_ = g_unichar_isdigit (_tmp6_);
	if (_tmp7_) {
		result = LEXER_TOKEN_TYPE_PL_DIGIT;
		return result;
	}
	_tmp10_ = c;
	if (_tmp10_ >= ((gunichar) 'a')) {
		gunichar _tmp11_ = 0U;
		_tmp11_ = c;
		_tmp9_ = _tmp11_ <= ((gunichar) 'f');
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		gunichar _tmp13_ = 0U;
		_tmp13_ = c;
		if (_tmp13_ >= ((gunichar) 'A')) {
			gunichar _tmp14_ = 0U;
			_tmp14_ = c;
			_tmp12_ = _tmp14_ <= ((gunichar) 'F');
		} else {
			_tmp12_ = FALSE;
		}
		_tmp8_ = _tmp12_;
	}
	if (_tmp8_) {
		result = LEXER_TOKEN_TYPE_PL_HEX;
		return result;
	}
	_tmp24_ = c;
	if (_tmp24_ == 8304U) {
		_tmp23_ = TRUE;
	} else {
		gunichar _tmp25_ = 0U;
		_tmp25_ = c;
		_tmp23_ = _tmp25_ == 185U;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		gunichar _tmp26_ = 0U;
		_tmp26_ = c;
		_tmp22_ = _tmp26_ == 178U;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		gunichar _tmp27_ = 0U;
		_tmp27_ = c;
		_tmp21_ = _tmp27_ == 179U;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gunichar _tmp28_ = 0U;
		_tmp28_ = c;
		_tmp20_ = _tmp28_ == 8308U;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		gunichar _tmp29_ = 0U;
		_tmp29_ = c;
		_tmp19_ = _tmp29_ == 8309U;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gunichar _tmp30_ = 0U;
		_tmp30_ = c;
		_tmp18_ = _tmp30_ == 8310U;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gunichar _tmp31_ = 0U;
		_tmp31_ = c;
		_tmp17_ = _tmp31_ == 8311U;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		gunichar _tmp32_ = 0U;
		_tmp32_ = c;
		_tmp16_ = _tmp32_ == 8312U;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gunichar _tmp33_ = 0U;
		_tmp33_ = c;
		_tmp15_ = _tmp33_ == 8313U;
	}
	if (_tmp15_) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_DIGIT;
		return result;
	}
	_tmp34_ = c;
	if (_tmp34_ == 8315U) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_MINUS;
		return result;
	}
	_tmp44_ = c;
	if (_tmp44_ == 8320U) {
		_tmp43_ = TRUE;
	} else {
		gunichar _tmp45_ = 0U;
		_tmp45_ = c;
		_tmp43_ = _tmp45_ == 8321U;
	}
	if (_tmp43_) {
		_tmp42_ = TRUE;
	} else {
		gunichar _tmp46_ = 0U;
		_tmp46_ = c;
		_tmp42_ = _tmp46_ == 8322U;
	}
	if (_tmp42_) {
		_tmp41_ = TRUE;
	} else {
		gunichar _tmp47_ = 0U;
		_tmp47_ = c;
		_tmp41_ = _tmp47_ == 8323U;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		gunichar _tmp48_ = 0U;
		_tmp48_ = c;
		_tmp40_ = _tmp48_ == 8324U;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		gunichar _tmp49_ = 0U;
		_tmp49_ = c;
		_tmp39_ = _tmp49_ == 8325U;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		gunichar _tmp50_ = 0U;
		_tmp50_ = c;
		_tmp38_ = _tmp50_ == 8326U;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		gunichar _tmp51_ = 0U;
		_tmp51_ = c;
		_tmp37_ = _tmp51_ == 8327U;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		gunichar _tmp52_ = 0U;
		_tmp52_ = c;
		_tmp36_ = _tmp52_ == 8328U;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		gunichar _tmp53_ = 0U;
		_tmp53_ = c;
		_tmp35_ = _tmp53_ == 8329U;
	}
	if (_tmp35_) {
		result = LEXER_TOKEN_TYPE_PL_SUB_DIGIT;
		return result;
	}
	_tmp68_ = c;
	if (_tmp68_ == 189U) {
		_tmp67_ = TRUE;
	} else {
		gunichar _tmp69_ = 0U;
		_tmp69_ = c;
		_tmp67_ = _tmp69_ == 8531U;
	}
	if (_tmp67_) {
		_tmp66_ = TRUE;
	} else {
		gunichar _tmp70_ = 0U;
		_tmp70_ = c;
		_tmp66_ = _tmp70_ == 8532U;
	}
	if (_tmp66_) {
		_tmp65_ = TRUE;
	} else {
		gunichar _tmp71_ = 0U;
		_tmp71_ = c;
		_tmp65_ = _tmp71_ == 188U;
	}
	if (_tmp65_) {
		_tmp64_ = TRUE;
	} else {
		gunichar _tmp72_ = 0U;
		_tmp72_ = c;
		_tmp64_ = _tmp72_ == 190U;
	}
	if (_tmp64_) {
		_tmp63_ = TRUE;
	} else {
		gunichar _tmp73_ = 0U;
		_tmp73_ = c;
		_tmp63_ = _tmp73_ == 8533U;
	}
	if (_tmp63_) {
		_tmp62_ = TRUE;
	} else {
		gunichar _tmp74_ = 0U;
		_tmp74_ = c;
		_tmp62_ = _tmp74_ == 8534U;
	}
	if (_tmp62_) {
		_tmp61_ = TRUE;
	} else {
		gunichar _tmp75_ = 0U;
		_tmp75_ = c;
		_tmp61_ = _tmp75_ == 8535U;
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		gunichar _tmp76_ = 0U;
		_tmp76_ = c;
		_tmp60_ = _tmp76_ == 8536U;
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gunichar _tmp77_ = 0U;
		_tmp77_ = c;
		_tmp59_ = _tmp77_ == 8537U;
	}
	if (_tmp59_) {
		_tmp58_ = TRUE;
	} else {
		gunichar _tmp78_ = 0U;
		_tmp78_ = c;
		_tmp58_ = _tmp78_ == 8538U;
	}
	if (_tmp58_) {
		_tmp57_ = TRUE;
	} else {
		gunichar _tmp79_ = 0U;
		_tmp79_ = c;
		_tmp57_ = _tmp79_ == 8539U;
	}
	if (_tmp57_) {
		_tmp56_ = TRUE;
	} else {
		gunichar _tmp80_ = 0U;
		_tmp80_ = c;
		_tmp56_ = _tmp80_ == 8540U;
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		gunichar _tmp81_ = 0U;
		_tmp81_ = c;
		_tmp55_ = _tmp81_ == 8541U;
	}
	if (_tmp55_) {
		_tmp54_ = TRUE;
	} else {
		gunichar _tmp82_ = 0U;
		_tmp82_ = c;
		_tmp54_ = _tmp82_ == 8542U;
	}
	if (_tmp54_) {
		result = LEXER_TOKEN_TYPE_PL_FRACTION;
		return result;
	}
	_tmp83_ = c;
	if (_tmp83_ == 176U) {
		result = LEXER_TOKEN_TYPE_PL_DEGREE;
		return result;
	}
	_tmp84_ = c;
	if (_tmp84_ == ((gunichar) '\'')) {
		result = LEXER_TOKEN_TYPE_PL_MINUTE;
		return result;
	}
	_tmp85_ = c;
	if (_tmp85_ == ((gunichar) '"')) {
		result = LEXER_TOKEN_TYPE_PL_SECOND;
		return result;
	}
	_tmp87_ = c;
	_tmp88_ = g_unichar_isalpha (_tmp87_);
	if (_tmp88_) {
		_tmp86_ = TRUE;
	} else {
		gunichar _tmp89_ = 0U;
		_tmp89_ = c;
		_tmp86_ = _tmp89_ == ((gunichar) '_');
	}
	if (_tmp86_) {
		result = LEXER_TOKEN_TYPE_PL_LETTER;
		return result;
	}
	_tmp90_ = c;
	if (_tmp90_ == 8743U) {
		result = LEXER_TOKEN_TYPE_AND;
		return result;
	}
	_tmp91_ = c;
	if (_tmp91_ == 8744U) {
		result = LEXER_TOKEN_TYPE_OR;
		return result;
	}
	_tmp93_ = c;
	if (_tmp93_ == 8891U) {
		_tmp92_ = TRUE;
	} else {
		gunichar _tmp94_ = 0U;
		_tmp94_ = c;
		_tmp92_ = _tmp94_ == 8853U;
	}
	if (_tmp92_) {
		result = LEXER_TOKEN_TYPE_XOR;
		return result;
	}
	_tmp96_ = c;
	if (_tmp96_ == 172U) {
		_tmp95_ = TRUE;
	} else {
		gunichar _tmp97_ = 0U;
		_tmp97_ = c;
		_tmp95_ = _tmp97_ == ((gunichar) '~');
	}
	if (_tmp95_) {
		result = LEXER_TOKEN_TYPE_NOT;
		return result;
	}
	_tmp98_ = c;
	if (_tmp98_ == ((gunichar) '+')) {
		result = LEXER_TOKEN_TYPE_ADD;
		return result;
	}
	_tmp101_ = c;
	if (_tmp101_ == ((gunichar) '-')) {
		_tmp100_ = TRUE;
	} else {
		gunichar _tmp102_ = 0U;
		_tmp102_ = c;
		_tmp100_ = _tmp102_ == 8722U;
	}
	if (_tmp100_) {
		_tmp99_ = TRUE;
	} else {
		gunichar _tmp103_ = 0U;
		_tmp103_ = c;
		_tmp99_ = _tmp103_ == 8211U;
	}
	if (_tmp99_) {
		result = LEXER_TOKEN_TYPE_SUBTRACT;
		return result;
	}
	_tmp105_ = c;
	if (_tmp105_ == ((gunichar) '*')) {
		_tmp104_ = TRUE;
	} else {
		gunichar _tmp106_ = 0U;
		_tmp106_ = c;
		_tmp104_ = _tmp106_ == 215U;
	}
	if (_tmp104_) {
		result = LEXER_TOKEN_TYPE_MULTIPLY;
		return result;
	}
	_tmp109_ = c;
	if (_tmp109_ == ((gunichar) '/')) {
		_tmp108_ = TRUE;
	} else {
		gunichar _tmp110_ = 0U;
		_tmp110_ = c;
		_tmp108_ = _tmp110_ == 8725U;
	}
	if (_tmp108_) {
		_tmp107_ = TRUE;
	} else {
		gunichar _tmp111_ = 0U;
		_tmp111_ = c;
		_tmp107_ = _tmp111_ == 247U;
	}
	if (_tmp107_) {
		result = LEXER_TOKEN_TYPE_DIVIDE;
		return result;
	}
	_tmp112_ = c;
	if (_tmp112_ == 8970U) {
		result = LEXER_TOKEN_TYPE_L_FLOOR;
		return result;
	}
	_tmp113_ = c;
	if (_tmp113_ == 8971U) {
		result = LEXER_TOKEN_TYPE_R_FLOOR;
		return result;
	}
	_tmp114_ = c;
	if (_tmp114_ == 8968U) {
		result = LEXER_TOKEN_TYPE_L_CEILING;
		return result;
	}
	_tmp115_ = c;
	if (_tmp115_ == 8969U) {
		result = LEXER_TOKEN_TYPE_R_CEILING;
		return result;
	}
	_tmp116_ = c;
	if (_tmp116_ == 8730U) {
		result = LEXER_TOKEN_TYPE_ROOT;
		return result;
	}
	_tmp117_ = c;
	if (_tmp117_ == 8731U) {
		result = LEXER_TOKEN_TYPE_ROOT_3;
		return result;
	}
	_tmp118_ = c;
	if (_tmp118_ == 8732U) {
		result = LEXER_TOKEN_TYPE_ROOT_4;
		return result;
	}
	_tmp119_ = c;
	if (_tmp119_ == ((gunichar) '=')) {
		result = LEXER_TOKEN_TYPE_ASSIGN;
		return result;
	}
	_tmp120_ = c;
	if (_tmp120_ == ((gunichar) '(')) {
		result = LEXER_TOKEN_TYPE_L_R_BRACKET;
		return result;
	}
	_tmp121_ = c;
	if (_tmp121_ == ((gunichar) ')')) {
		result = LEXER_TOKEN_TYPE_R_R_BRACKET;
		return result;
	}
	_tmp122_ = c;
	if (_tmp122_ == ((gunichar) '[')) {
		result = LEXER_TOKEN_TYPE_L_S_BRACKET;
		return result;
	}
	_tmp123_ = c;
	if (_tmp123_ == ((gunichar) ']')) {
		result = LEXER_TOKEN_TYPE_R_S_BRACKET;
		return result;
	}
	_tmp124_ = c;
	if (_tmp124_ == ((gunichar) '{')) {
		result = LEXER_TOKEN_TYPE_L_C_BRACKET;
		return result;
	}
	_tmp125_ = c;
	if (_tmp125_ == ((gunichar) '}')) {
		result = LEXER_TOKEN_TYPE_R_C_BRACKET;
		return result;
	}
	_tmp126_ = c;
	if (_tmp126_ == ((gunichar) '|')) {
		result = LEXER_TOKEN_TYPE_ABS;
		return result;
	}
	_tmp127_ = c;
	if (_tmp127_ == ((gunichar) '^')) {
		result = LEXER_TOKEN_TYPE_POWER;
		return result;
	}
	_tmp128_ = c;
	if (_tmp128_ == ((gunichar) '!')) {
		result = LEXER_TOKEN_TYPE_FACTORIAL;
		return result;
	}
	_tmp129_ = c;
	if (_tmp129_ == ((gunichar) '%')) {
		result = LEXER_TOKEN_TYPE_PERCENTAGE;
		return result;
	}
	_tmp130_ = c;
	if (_tmp130_ == ((gunichar) ';')) {
		result = LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR;
		return result;
	}
	_tmp134_ = c;
	if (_tmp134_ == ((gunichar) ' ')) {
		_tmp133_ = TRUE;
	} else {
		gunichar _tmp135_ = 0U;
		_tmp135_ = c;
		_tmp133_ = _tmp135_ == ((gunichar) '\r');
	}
	if (_tmp133_) {
		_tmp132_ = TRUE;
	} else {
		gunichar _tmp136_ = 0U;
		_tmp136_ = c;
		_tmp132_ = _tmp136_ == ((gunichar) '\t');
	}
	if (_tmp132_) {
		_tmp131_ = TRUE;
	} else {
		gunichar _tmp137_ = 0U;
		_tmp137_ = c;
		_tmp131_ = _tmp137_ == ((gunichar) '\n');
	}
	if (_tmp131_) {
		result = LEXER_TOKEN_TYPE_PL_SKIP;
		return result;
	}
	result = LEXER_TOKEN_TYPE_UNKNOWN;
	return result;
}


static void pre_lexer_class_init (PreLexerClass * klass) {
	pre_lexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreLexerPrivate));
	G_OBJECT_CLASS (klass)->finalize = pre_lexer_finalize;
}


static void pre_lexer_instance_init (PreLexer * self) {
	self->priv = PRE_LEXER_GET_PRIVATE (self);
	self->priv->eos = FALSE;
}


static void pre_lexer_finalize (GObject* obj) {
	PreLexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRE_LEXER, PreLexer);
	_g_free0 (self->stream);
	G_OBJECT_CLASS (pre_lexer_parent_class)->finalize (obj);
}


GType pre_lexer_get_type (void) {
	static volatile gsize pre_lexer_type_id__volatile = 0;
	if (g_once_init_enter (&pre_lexer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreLexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pre_lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreLexer), 0, (GInstanceInitFunc) pre_lexer_instance_init, NULL };
		GType pre_lexer_type_id;
		pre_lexer_type_id = g_type_register_static (G_TYPE_OBJECT, "PreLexer", &g_define_type_info, 0);
		g_once_init_leave (&pre_lexer_type_id__volatile, pre_lexer_type_id);
	}
	return pre_lexer_type_id__volatile;
}


LexerToken* lexer_token_construct (GType object_type) {
	LexerToken * self = NULL;
	self = (LexerToken*) g_object_new (object_type, NULL);
	return self;
}


LexerToken* lexer_token_new (void) {
	return lexer_token_construct (TYPE_LEXER_TOKEN);
}


static void lexer_token_class_init (LexerTokenClass * klass) {
	lexer_token_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = lexer_token_finalize;
}


static void lexer_token_instance_init (LexerToken * self) {
}


static void lexer_token_finalize (GObject* obj) {
	LexerToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER_TOKEN, LexerToken);
	_g_free0 (self->text);
	G_OBJECT_CLASS (lexer_token_parent_class)->finalize (obj);
}


GType lexer_token_get_type (void) {
	static volatile gsize lexer_token_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_token_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LexerTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LexerToken), 0, (GInstanceInitFunc) lexer_token_instance_init, NULL };
		GType lexer_token_type_id;
		lexer_token_type_id = g_type_register_static (G_TYPE_OBJECT, "LexerToken", &g_define_type_info, 0);
		g_once_init_leave (&lexer_token_type_id__volatile, lexer_token_type_id);
	}
	return lexer_token_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _parser_ref0 (gpointer self) {
	return self ? parser_ref (self) : NULL;
}


Lexer* lexer_construct (GType object_type, const gchar* input, Parser* parser, gint number_base) {
	Lexer * self = NULL;
	const gchar* _tmp0_ = NULL;
	PreLexer* _tmp1_ = NULL;
	Parser* _tmp2_ = NULL;
	Parser* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	self = (Lexer*) g_object_new (object_type, NULL);
	_tmp0_ = input;
	_tmp1_ = pre_lexer_new (_tmp0_);
	_g_object_unref0 (self->priv->prelexer);
	self->priv->prelexer = _tmp1_;
	__g_list_free__g_object_unref0_0 (self->tokens);
	self->tokens = NULL;
	self->priv->next_token = (guint) 0;
	_tmp2_ = parser;
	_tmp3_ = _parser_ref0 (_tmp2_);
	_parser_unref0 (self->priv->parser);
	self->priv->parser = _tmp3_;
	_tmp4_ = number_base;
	self->priv->number_base = _tmp4_;
	return self;
}


Lexer* lexer_new (const gchar* input, Parser* parser, gint number_base) {
	return lexer_construct (TYPE_LEXER, input, parser, number_base);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void lexer_scan (Lexer* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		LexerToken* token = NULL;
		LexerToken* _tmp0_ = NULL;
		LexerToken* _tmp1_ = NULL;
		LexerToken* _tmp2_ = NULL;
		LexerToken* _tmp3_ = NULL;
		LexerTokenType _tmp4_ = 0;
		_tmp0_ = lexer_insert_next_token (self);
		token = _tmp0_;
		_tmp1_ = token;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		self->tokens = g_list_append (self->tokens, _tmp2_);
		_tmp3_ = token;
		_tmp4_ = _tmp3_->type;
		if (_tmp4_ == LEXER_TOKEN_TYPE_PL_EOS) {
			_g_object_unref0 (token);
			break;
		}
		_g_object_unref0 (token);
	}
}


LexerToken* lexer_get_next_token (Lexer* self) {
	LexerToken* result = NULL;
	guint _tmp0_ = 0U;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GList* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gconstpointer _tmp10_ = NULL;
	LexerToken* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->next_token;
	_tmp1_ = self->tokens;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp0_ >= _tmp2_) {
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		gconstpointer _tmp6_ = NULL;
		LexerToken* _tmp7_ = NULL;
		_tmp3_ = self->tokens;
		_tmp4_ = self->tokens;
		_tmp5_ = g_list_length (_tmp4_);
		_tmp6_ = g_list_nth_data (_tmp3_, _tmp5_ - 1);
		_tmp7_ = _g_object_ref0 ((LexerToken*) _tmp6_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = self->tokens;
	_tmp9_ = self->priv->next_token;
	self->priv->next_token = _tmp9_ + 1;
	_tmp10_ = g_list_nth_data (_tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 ((LexerToken*) _tmp10_);
	result = _tmp11_;
	return result;
}


void lexer_roll_back (Lexer* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->next_token;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->next_token;
		self->priv->next_token = _tmp1_ - 1;
	}
}


static gboolean lexer_check_if_function (Lexer* self) {
	gboolean result = FALSE;
	gchar* name = NULL;
	PreLexer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Parser* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->parser;
	_tmp3_ = name;
	_tmp4_ = parser_function_is_defined (_tmp2_, _tmp3_);
	if (_tmp4_) {
		result = TRUE;
		_g_free0 (name);
		return result;
	} else {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


static gboolean lexer_check_if_number (Lexer* self) {
	gboolean result = FALSE;
	gint count = 0;
	gchar* text = NULL;
	PreLexer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Number* tmp = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = self->priv->number_base;
	_tmp4_ = mp_set_from_string (_tmp2_, _tmp3_);
	tmp = _tmp4_;
	_tmp5_ = tmp;
	if (_tmp5_ != NULL) {
		result = TRUE;
		_g_object_unref0 (tmp);
		_g_free0 (text);
		return result;
	} else {
		while (TRUE) {
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			PreLexer* _tmp12_ = NULL;
			PreLexer* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp6_ = text;
			if (!(g_strcmp0 (_tmp6_, "") != 0)) {
				break;
			}
			_tmp7_ = text;
			_tmp8_ = self->priv->number_base;
			_tmp9_ = mp_set_from_string (_tmp7_, _tmp8_);
			_g_object_unref0 (tmp);
			tmp = _tmp9_;
			_tmp10_ = tmp;
			if (_tmp10_ != NULL) {
				result = TRUE;
				_g_object_unref0 (tmp);
				_g_free0 (text);
				return result;
			}
			_tmp11_ = count;
			count = _tmp11_ + 1;
			_tmp12_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp12_);
			_tmp13_ = self->priv->prelexer;
			_tmp14_ = pre_lexer_get_marked_substring (_tmp13_);
			_g_free0 (text);
			text = _tmp14_;
		}
		while (TRUE) {
			gint _tmp15_ = 0;
			PreLexer* _tmp16_ = NULL;
			_tmp15_ = count;
			count = _tmp15_ - 1;
			if (!(_tmp15_ > 0)) {
				break;
			}
			_tmp16_ = self->priv->prelexer;
			pre_lexer_get_next_token (_tmp16_);
		}
		result = FALSE;
		_g_object_unref0 (tmp);
		_g_free0 (text);
		return result;
	}
	_g_object_unref0 (tmp);
	_g_free0 (text);
}


static LexerToken* lexer_insert_token (Lexer* self, LexerTokenType type) {
	LexerToken* result = NULL;
	LexerToken* token = NULL;
	LexerToken* _tmp0_ = NULL;
	PreLexer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PreLexer* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	PreLexer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	LexerTokenType _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = lexer_token_new ();
	token = _tmp0_;
	_tmp1_ = self->priv->prelexer;
	_tmp2_ = pre_lexer_get_marked_substring (_tmp1_);
	_g_free0 (token->text);
	token->text = _tmp2_;
	_tmp3_ = self->priv->prelexer;
	_tmp4_ = _tmp3_->mark_index;
	token->start_index = (guint) _tmp4_;
	_tmp5_ = self->priv->prelexer;
	_tmp6_ = _tmp5_->index;
	token->end_index = (guint) _tmp6_;
	_tmp7_ = type;
	token->type = _tmp7_;
	result = token;
	return result;
}


static LexerToken* lexer_insert_next_token (Lexer* self) {
	LexerToken* result = NULL;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp1_ = NULL;
	LexerTokenType _tmp2_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	LexerTokenType _tmp33_ = 0;
	LexerTokenType _tmp62_ = 0;
	LexerTokenType _tmp79_ = 0;
	LexerTokenType _tmp84_ = 0;
	LexerTokenType _tmp89_ = 0;
	LexerTokenType _tmp91_ = 0;
	LexerTokenType _tmp93_ = 0;
	LexerTokenType _tmp95_ = 0;
	LexerTokenType _tmp97_ = 0;
	LexerTokenType _tmp99_ = 0;
	Parser* _tmp101_ = NULL;
	PreLexer* _tmp102_ = NULL;
	gchar* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	PreLexer* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	PreLexer* _tmp107_ = NULL;
	gint _tmp108_ = 0;
	LexerToken* _tmp109_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	pre_lexer_set_marker (_tmp0_);
	_tmp1_ = self->priv->prelexer;
	_tmp2_ = pre_lexer_get_next_token (_tmp1_);
	type = _tmp2_;
	while (TRUE) {
		LexerTokenType _tmp3_ = 0;
		PreLexer* _tmp4_ = NULL;
		PreLexer* _tmp5_ = NULL;
		LexerTokenType _tmp6_ = 0;
		_tmp3_ = type;
		if (!(_tmp3_ == LEXER_TOKEN_TYPE_PL_SKIP)) {
			break;
		}
		_tmp4_ = self->priv->prelexer;
		pre_lexer_set_marker (_tmp4_);
		_tmp5_ = self->priv->prelexer;
		_tmp6_ = pre_lexer_get_next_token (_tmp5_);
		type = _tmp6_;
	}
	_tmp33_ = type;
	if (_tmp33_ == LEXER_TOKEN_TYPE_AND) {
		_tmp32_ = TRUE;
	} else {
		LexerTokenType _tmp34_ = 0;
		_tmp34_ = type;
		_tmp32_ = _tmp34_ == LEXER_TOKEN_TYPE_OR;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		LexerTokenType _tmp35_ = 0;
		_tmp35_ = type;
		_tmp31_ = _tmp35_ == LEXER_TOKEN_TYPE_XOR;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		LexerTokenType _tmp36_ = 0;
		_tmp36_ = type;
		_tmp30_ = _tmp36_ == LEXER_TOKEN_TYPE_NOT;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		LexerTokenType _tmp37_ = 0;
		_tmp37_ = type;
		_tmp29_ = _tmp37_ == LEXER_TOKEN_TYPE_ADD;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		LexerTokenType _tmp38_ = 0;
		_tmp38_ = type;
		_tmp28_ = _tmp38_ == LEXER_TOKEN_TYPE_SUBTRACT;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		LexerTokenType _tmp39_ = 0;
		_tmp39_ = type;
		_tmp27_ = _tmp39_ == LEXER_TOKEN_TYPE_MULTIPLY;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		LexerTokenType _tmp40_ = 0;
		_tmp40_ = type;
		_tmp26_ = _tmp40_ == LEXER_TOKEN_TYPE_DIVIDE;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		LexerTokenType _tmp41_ = 0;
		_tmp41_ = type;
		_tmp25_ = _tmp41_ == LEXER_TOKEN_TYPE_L_FLOOR;
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		LexerTokenType _tmp42_ = 0;
		_tmp42_ = type;
		_tmp24_ = _tmp42_ == LEXER_TOKEN_TYPE_R_FLOOR;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		LexerTokenType _tmp43_ = 0;
		_tmp43_ = type;
		_tmp23_ = _tmp43_ == LEXER_TOKEN_TYPE_L_CEILING;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		LexerTokenType _tmp44_ = 0;
		_tmp44_ = type;
		_tmp22_ = _tmp44_ == LEXER_TOKEN_TYPE_R_CEILING;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		LexerTokenType _tmp45_ = 0;
		_tmp45_ = type;
		_tmp21_ = _tmp45_ == LEXER_TOKEN_TYPE_ROOT;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		LexerTokenType _tmp46_ = 0;
		_tmp46_ = type;
		_tmp20_ = _tmp46_ == LEXER_TOKEN_TYPE_ROOT_3;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		LexerTokenType _tmp47_ = 0;
		_tmp47_ = type;
		_tmp19_ = _tmp47_ == LEXER_TOKEN_TYPE_ROOT_4;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		LexerTokenType _tmp48_ = 0;
		_tmp48_ = type;
		_tmp18_ = _tmp48_ == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		LexerTokenType _tmp49_ = 0;
		_tmp49_ = type;
		_tmp17_ = _tmp49_ == LEXER_TOKEN_TYPE_L_R_BRACKET;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		LexerTokenType _tmp50_ = 0;
		_tmp50_ = type;
		_tmp16_ = _tmp50_ == LEXER_TOKEN_TYPE_R_R_BRACKET;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		LexerTokenType _tmp51_ = 0;
		_tmp51_ = type;
		_tmp15_ = _tmp51_ == LEXER_TOKEN_TYPE_L_S_BRACKET;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		LexerTokenType _tmp52_ = 0;
		_tmp52_ = type;
		_tmp14_ = _tmp52_ == LEXER_TOKEN_TYPE_R_S_BRACKET;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		LexerTokenType _tmp53_ = 0;
		_tmp53_ = type;
		_tmp13_ = _tmp53_ == LEXER_TOKEN_TYPE_L_C_BRACKET;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		LexerTokenType _tmp54_ = 0;
		_tmp54_ = type;
		_tmp12_ = _tmp54_ == LEXER_TOKEN_TYPE_R_C_BRACKET;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		LexerTokenType _tmp55_ = 0;
		_tmp55_ = type;
		_tmp11_ = _tmp55_ == LEXER_TOKEN_TYPE_ABS;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		LexerTokenType _tmp56_ = 0;
		_tmp56_ = type;
		_tmp10_ = _tmp56_ == LEXER_TOKEN_TYPE_POWER;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		LexerTokenType _tmp57_ = 0;
		_tmp57_ = type;
		_tmp9_ = _tmp57_ == LEXER_TOKEN_TYPE_FACTORIAL;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		LexerTokenType _tmp58_ = 0;
		_tmp58_ = type;
		_tmp8_ = _tmp58_ == LEXER_TOKEN_TYPE_PERCENTAGE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		LexerTokenType _tmp59_ = 0;
		_tmp59_ = type;
		_tmp7_ = _tmp59_ == LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR;
	}
	if (_tmp7_) {
		LexerTokenType _tmp60_ = 0;
		LexerToken* _tmp61_ = NULL;
		_tmp60_ = type;
		_tmp61_ = lexer_insert_token (self, _tmp60_);
		result = _tmp61_;
		return result;
	}
	_tmp62_ = type;
	if (_tmp62_ == LEXER_TOKEN_TYPE_PL_SUPER_MINUS) {
		PreLexer* _tmp63_ = NULL;
		LexerTokenType _tmp64_ = 0;
		LexerTokenType _tmp65_ = 0;
		PreLexer* _tmp77_ = NULL;
		LexerToken* _tmp78_ = NULL;
		_tmp63_ = self->priv->prelexer;
		_tmp64_ = pre_lexer_get_next_token (_tmp63_);
		type = _tmp64_;
		_tmp65_ = type;
		if (_tmp65_ != LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
			Parser* _tmp66_ = NULL;
			PreLexer* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			PreLexer* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			PreLexer* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			LexerToken* _tmp74_ = NULL;
			_tmp66_ = self->priv->parser;
			_tmp67_ = self->priv->prelexer;
			_tmp68_ = pre_lexer_get_marked_substring (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = self->priv->prelexer;
			_tmp71_ = _tmp70_->mark_index;
			_tmp72_ = self->priv->prelexer;
			_tmp73_ = _tmp72_->index;
			parser_set_error (_tmp66_, ERROR_CODE_MP, _tmp69_, (guint) _tmp71_, (guint) _tmp73_);
			_g_free0 (_tmp69_);
			_tmp74_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp74_;
			return result;
		}
		while (TRUE) {
			PreLexer* _tmp75_ = NULL;
			LexerTokenType _tmp76_ = 0;
			_tmp75_ = self->priv->prelexer;
			_tmp76_ = pre_lexer_get_next_token (_tmp75_);
			if (!(_tmp76_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp77_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp77_);
		_tmp78_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NSUP_NUMBER);
		result = _tmp78_;
		return result;
	}
	_tmp79_ = type;
	if (_tmp79_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
		PreLexer* _tmp82_ = NULL;
		LexerToken* _tmp83_ = NULL;
		while (TRUE) {
			PreLexer* _tmp80_ = NULL;
			LexerTokenType _tmp81_ = 0;
			_tmp80_ = self->priv->prelexer;
			_tmp81_ = pre_lexer_get_next_token (_tmp80_);
			if (!(_tmp81_ == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp82_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp82_);
		_tmp83_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUP_NUMBER);
		result = _tmp83_;
		return result;
	}
	_tmp84_ = type;
	if (_tmp84_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
		PreLexer* _tmp87_ = NULL;
		LexerToken* _tmp88_ = NULL;
		while (TRUE) {
			PreLexer* _tmp85_ = NULL;
			LexerTokenType _tmp86_ = 0;
			_tmp85_ = self->priv->prelexer;
			_tmp86_ = pre_lexer_get_next_token (_tmp85_);
			if (!(_tmp86_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
				break;
			}
		}
		_tmp87_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp87_);
		_tmp88_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUB_NUMBER);
		result = _tmp88_;
		return result;
	}
	_tmp89_ = type;
	if (_tmp89_ == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp90_ = NULL;
		_tmp90_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp90_;
		return result;
	}
	_tmp91_ = type;
	if (_tmp91_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp92_ = NULL;
		_tmp92_ = lexer_insert_digit (self);
		result = _tmp92_;
		return result;
	}
	_tmp93_ = type;
	if (_tmp93_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp94_ = NULL;
		_tmp94_ = lexer_insert_decimal (self);
		result = _tmp94_;
		return result;
	}
	_tmp95_ = type;
	if (_tmp95_ == LEXER_TOKEN_TYPE_PL_HEX) {
		LexerToken* _tmp96_ = NULL;
		_tmp96_ = lexer_insert_hex (self);
		result = _tmp96_;
		return result;
	}
	_tmp97_ = type;
	if (_tmp97_ == LEXER_TOKEN_TYPE_PL_LETTER) {
		LexerToken* _tmp98_ = NULL;
		_tmp98_ = lexer_insert_letter (self);
		result = _tmp98_;
		return result;
	}
	_tmp99_ = type;
	if (_tmp99_ == LEXER_TOKEN_TYPE_PL_EOS) {
		LexerToken* _tmp100_ = NULL;
		_tmp100_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_PL_EOS);
		result = _tmp100_;
		return result;
	}
	_tmp101_ = self->priv->parser;
	_tmp102_ = self->priv->prelexer;
	_tmp103_ = pre_lexer_get_marked_substring (_tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = self->priv->prelexer;
	_tmp106_ = _tmp105_->mark_index;
	_tmp107_ = self->priv->prelexer;
	_tmp108_ = _tmp107_->index;
	parser_set_error (_tmp101_, ERROR_CODE_INVALID, _tmp104_, (guint) _tmp106_, (guint) _tmp108_);
	_g_free0 (_tmp104_);
	_tmp109_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
	result = _tmp109_;
	return result;
}


static LexerToken* lexer_insert_digit (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		LexerTokenType _tmp2_ = 0;
		PreLexer* _tmp3_ = NULL;
		LexerTokenType _tmp4_ = 0;
		_tmp2_ = type;
		if (!(_tmp2_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = pre_lexer_get_next_token (_tmp3_);
		type = _tmp4_;
	}
	_tmp5_ = type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp6_ = NULL;
		_tmp6_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp6_;
		return result;
	} else {
		LexerTokenType _tmp7_ = 0;
		_tmp7_ = type;
		if (_tmp7_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp10_ = NULL;
			LexerToken* _tmp11_ = NULL;
			while (TRUE) {
				PreLexer* _tmp8_ = NULL;
				LexerTokenType _tmp9_ = 0;
				_tmp8_ = self->priv->prelexer;
				_tmp9_ = pre_lexer_get_next_token (_tmp8_);
				if (!(_tmp9_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp10_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp10_);
			_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp11_;
			return result;
		} else {
			LexerTokenType _tmp12_ = 0;
			_tmp12_ = type;
			if (_tmp12_ == LEXER_TOKEN_TYPE_PL_DEGREE) {
				PreLexer* _tmp13_ = NULL;
				LexerTokenType _tmp14_ = 0;
				LexerTokenType _tmp15_ = 0;
				_tmp13_ = self->priv->prelexer;
				_tmp14_ = pre_lexer_get_next_token (_tmp13_);
				type = _tmp14_;
				_tmp15_ = type;
				if (_tmp15_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
					LexerTokenType _tmp19_ = 0;
					while (TRUE) {
						PreLexer* _tmp16_ = NULL;
						LexerTokenType _tmp17_ = 0;
						LexerTokenType _tmp18_ = 0;
						_tmp16_ = self->priv->prelexer;
						_tmp17_ = pre_lexer_get_next_token (_tmp16_);
						type = _tmp17_;
						_tmp18_ = type;
						if (!(_tmp18_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
							break;
						}
					}
					_tmp19_ = type;
					if (_tmp19_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp20_ = NULL;
						_tmp20_ = lexer_insert_angle_num_dm (self);
						result = _tmp20_;
						return result;
					} else {
						LexerTokenType _tmp21_ = 0;
						_tmp21_ = type;
						if (_tmp21_ == LEXER_TOKEN_TYPE_PL_MINUTE) {
							PreLexer* _tmp22_ = NULL;
							LexerTokenType _tmp23_ = 0;
							LexerTokenType _tmp24_ = 0;
							_tmp22_ = self->priv->prelexer;
							_tmp23_ = pre_lexer_get_next_token (_tmp22_);
							type = _tmp23_;
							_tmp24_ = type;
							if (_tmp24_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
								LexerTokenType _tmp28_ = 0;
								while (TRUE) {
									PreLexer* _tmp25_ = NULL;
									LexerTokenType _tmp26_ = 0;
									LexerTokenType _tmp27_ = 0;
									_tmp25_ = self->priv->prelexer;
									_tmp26_ = pre_lexer_get_next_token (_tmp25_);
									type = _tmp26_;
									_tmp27_ = type;
									if (!(_tmp27_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
										break;
									}
								}
								_tmp28_ = type;
								if (_tmp28_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp29_ = NULL;
									_tmp29_ = lexer_insert_angle_num_dms (self);
									result = _tmp29_;
									return result;
								} else {
									LexerTokenType _tmp30_ = 0;
									_tmp30_ = type;
									if (_tmp30_ == LEXER_TOKEN_TYPE_PL_SECOND) {
										LexerToken* _tmp31_ = NULL;
										_tmp31_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
										result = _tmp31_;
										return result;
									} else {
										Parser* _tmp32_ = NULL;
										PreLexer* _tmp33_ = NULL;
										gchar* _tmp34_ = NULL;
										gchar* _tmp35_ = NULL;
										PreLexer* _tmp36_ = NULL;
										gint _tmp37_ = 0;
										PreLexer* _tmp38_ = NULL;
										gint _tmp39_ = 0;
										LexerToken* _tmp40_ = NULL;
										_tmp32_ = self->priv->parser;
										_tmp33_ = self->priv->prelexer;
										_tmp34_ = pre_lexer_get_marked_substring (_tmp33_);
										_tmp35_ = _tmp34_;
										_tmp36_ = self->priv->prelexer;
										_tmp37_ = _tmp36_->mark_index;
										_tmp38_ = self->priv->prelexer;
										_tmp39_ = _tmp38_->index;
										parser_set_error (_tmp32_, ERROR_CODE_MP, _tmp35_, (guint) _tmp37_, (guint) _tmp39_);
										_g_free0 (_tmp35_);
										_tmp40_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
										result = _tmp40_;
										return result;
									}
								}
							} else {
								LexerTokenType _tmp41_ = 0;
								_tmp41_ = type;
								if (_tmp41_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp42_ = NULL;
									_tmp42_ = lexer_insert_angle_num_dms (self);
									result = _tmp42_;
									return result;
								} else {
									PreLexer* _tmp43_ = NULL;
									LexerToken* _tmp44_ = NULL;
									_tmp43_ = self->priv->prelexer;
									pre_lexer_roll_back (_tmp43_);
									_tmp44_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
									result = _tmp44_;
									return result;
								}
							}
						} else {
							Parser* _tmp45_ = NULL;
							PreLexer* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_ = NULL;
							PreLexer* _tmp49_ = NULL;
							gint _tmp50_ = 0;
							PreLexer* _tmp51_ = NULL;
							gint _tmp52_ = 0;
							LexerToken* _tmp53_ = NULL;
							_tmp45_ = self->priv->parser;
							_tmp46_ = self->priv->prelexer;
							_tmp47_ = pre_lexer_get_marked_substring (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = self->priv->prelexer;
							_tmp50_ = _tmp49_->mark_index;
							_tmp51_ = self->priv->prelexer;
							_tmp52_ = _tmp51_->index;
							parser_set_error (_tmp45_, ERROR_CODE_MP, _tmp48_, (guint) _tmp50_, (guint) _tmp52_);
							_g_free0 (_tmp48_);
							_tmp53_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
							result = _tmp53_;
							return result;
						}
					}
				} else {
					LexerTokenType _tmp54_ = 0;
					_tmp54_ = type;
					if (_tmp54_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp55_ = NULL;
						_tmp55_ = lexer_insert_angle_num_dm (self);
						result = _tmp55_;
						return result;
					} else {
						LexerToken* _tmp56_ = NULL;
						_tmp56_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp56_;
						return result;
					}
				}
			} else {
				LexerTokenType _tmp57_ = 0;
				_tmp57_ = type;
				if (_tmp57_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
					LexerToken* _tmp58_ = NULL;
					_tmp58_ = lexer_insert_decimal (self);
					result = _tmp58_;
					return result;
				} else {
					LexerTokenType _tmp59_ = 0;
					_tmp59_ = type;
					if (_tmp59_ == LEXER_TOKEN_TYPE_PL_HEX) {
						LexerToken* _tmp60_ = NULL;
						_tmp60_ = lexer_insert_hex_dec (self);
						result = _tmp60_;
						return result;
					} else {
						PreLexer* _tmp61_ = NULL;
						LexerToken* _tmp62_ = NULL;
						_tmp61_ = self->priv->prelexer;
						pre_lexer_roll_back (_tmp61_);
						_tmp62_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp62_;
						return result;
					}
				}
			}
		}
	}
}


static LexerToken* lexer_insert_angle_num_dm (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp2_ = 0;
	PreLexer* _tmp13_ = NULL;
	LexerTokenType _tmp14_ = 0;
	LexerTokenType _tmp15_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ != LEXER_TOKEN_TYPE_PL_DIGIT) {
		Parser* _tmp3_ = NULL;
		PreLexer* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		PreLexer* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		PreLexer* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		LexerToken* _tmp11_ = NULL;
		_tmp3_ = self->priv->parser;
		_tmp4_ = self->priv->prelexer;
		_tmp5_ = pre_lexer_get_marked_substring (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->prelexer;
		_tmp8_ = _tmp7_->mark_index;
		_tmp9_ = self->priv->prelexer;
		_tmp10_ = _tmp9_->index;
		parser_set_error (_tmp3_, ERROR_CODE_MP, _tmp6_, (guint) _tmp8_, (guint) _tmp10_);
		_g_free0 (_tmp6_);
		_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp11_;
		return result;
	}
	while (TRUE) {
		LexerTokenType _tmp12_ = 0;
		_tmp12_ = type;
		if (!(_tmp12_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	_tmp13_ = self->priv->prelexer;
	_tmp14_ = pre_lexer_get_next_token (_tmp13_);
	type = _tmp14_;
	_tmp15_ = type;
	if (_tmp15_ == LEXER_TOKEN_TYPE_PL_MINUTE) {
		LexerToken* _tmp16_ = NULL;
		_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp16_;
		return result;
	} else {
		Parser* _tmp17_ = NULL;
		PreLexer* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PreLexer* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		PreLexer* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		LexerToken* _tmp25_ = NULL;
		_tmp17_ = self->priv->parser;
		_tmp18_ = self->priv->prelexer;
		_tmp19_ = pre_lexer_get_marked_substring (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->prelexer;
		_tmp22_ = _tmp21_->mark_index;
		_tmp23_ = self->priv->prelexer;
		_tmp24_ = _tmp23_->index;
		parser_set_error (_tmp17_, ERROR_CODE_MP, _tmp20_, (guint) _tmp22_, (guint) _tmp24_);
		_g_free0 (_tmp20_);
		_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp25_;
		return result;
	}
}


static LexerToken* lexer_insert_angle_num_dms (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp2_ = 0;
	LexerTokenType _tmp15_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ != LEXER_TOKEN_TYPE_PL_DIGIT) {
		Parser* _tmp3_ = NULL;
		PreLexer* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		PreLexer* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		PreLexer* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		LexerToken* _tmp11_ = NULL;
		_tmp3_ = self->priv->parser;
		_tmp4_ = self->priv->prelexer;
		_tmp5_ = pre_lexer_get_marked_substring (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->prelexer;
		_tmp8_ = _tmp7_->mark_index;
		_tmp9_ = self->priv->prelexer;
		_tmp10_ = _tmp9_->index;
		parser_set_error (_tmp3_, ERROR_CODE_MP, _tmp6_, (guint) _tmp8_, (guint) _tmp10_);
		_g_free0 (_tmp6_);
		_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp11_;
		return result;
	}
	while (TRUE) {
		PreLexer* _tmp12_ = NULL;
		LexerTokenType _tmp13_ = 0;
		LexerTokenType _tmp14_ = 0;
		_tmp12_ = self->priv->prelexer;
		_tmp13_ = pre_lexer_get_next_token (_tmp12_);
		type = _tmp13_;
		_tmp14_ = type;
		if (!(_tmp14_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	_tmp15_ = type;
	if (_tmp15_ == LEXER_TOKEN_TYPE_PL_SECOND) {
		LexerToken* _tmp16_ = NULL;
		_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp16_;
		return result;
	} else {
		Parser* _tmp17_ = NULL;
		PreLexer* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PreLexer* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		PreLexer* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		LexerToken* _tmp25_ = NULL;
		_tmp17_ = self->priv->parser;
		_tmp18_ = self->priv->prelexer;
		_tmp19_ = pre_lexer_get_marked_substring (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->prelexer;
		_tmp22_ = _tmp21_->mark_index;
		_tmp23_ = self->priv->prelexer;
		_tmp24_ = _tmp23_->index;
		parser_set_error (_tmp17_, ERROR_CODE_MP, _tmp20_, (guint) _tmp22_, (guint) _tmp24_);
		_g_free0 (_tmp20_);
		_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp25_;
		return result;
	}
}


static LexerToken* lexer_insert_decimal (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerTokenType _tmp6_ = 0;
		while (TRUE) {
			PreLexer* _tmp3_ = NULL;
			LexerTokenType _tmp4_ = 0;
			LexerTokenType _tmp5_ = 0;
			_tmp3_ = self->priv->prelexer;
			_tmp4_ = pre_lexer_get_next_token (_tmp3_);
			type = _tmp4_;
			_tmp5_ = type;
			if (!(_tmp5_ == LEXER_TOKEN_TYPE_PL_DIGIT)) {
				break;
			}
		}
		_tmp6_ = type;
		if (_tmp6_ == LEXER_TOKEN_TYPE_PL_DEGREE) {
			LexerToken* _tmp7_ = NULL;
			_tmp7_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp7_;
			return result;
		} else {
			LexerTokenType _tmp8_ = 0;
			_tmp8_ = type;
			if (_tmp8_ == LEXER_TOKEN_TYPE_PL_HEX) {
				LexerToken* _tmp9_ = NULL;
				_tmp9_ = lexer_insert_decimal_hex (self);
				result = _tmp9_;
				return result;
			} else {
				LexerTokenType _tmp10_ = 0;
				_tmp10_ = type;
				if (_tmp10_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
					PreLexer* _tmp13_ = NULL;
					LexerToken* _tmp14_ = NULL;
					while (TRUE) {
						PreLexer* _tmp11_ = NULL;
						LexerTokenType _tmp12_ = 0;
						_tmp11_ = self->priv->prelexer;
						_tmp12_ = pre_lexer_get_next_token (_tmp11_);
						if (!(_tmp12_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
							break;
						}
					}
					_tmp13_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp13_);
					_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp14_;
					return result;
				} else {
					PreLexer* _tmp15_ = NULL;
					LexerToken* _tmp16_ = NULL;
					_tmp15_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp15_);
					_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp16_;
					return result;
				}
			}
		}
	} else {
		LexerTokenType _tmp17_ = 0;
		_tmp17_ = type;
		if (_tmp17_ == LEXER_TOKEN_TYPE_PL_HEX) {
			LexerToken* _tmp18_ = NULL;
			_tmp18_ = lexer_insert_decimal_hex (self);
			result = _tmp18_;
			return result;
		} else {
			Parser* _tmp19_ = NULL;
			PreLexer* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			PreLexer* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			PreLexer* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			LexerToken* _tmp27_ = NULL;
			_tmp19_ = self->priv->parser;
			_tmp20_ = self->priv->prelexer;
			_tmp21_ = pre_lexer_get_marked_substring (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->prelexer;
			_tmp24_ = _tmp23_->mark_index;
			_tmp25_ = self->priv->prelexer;
			_tmp26_ = _tmp25_->index;
			parser_set_error (_tmp19_, ERROR_CODE_MP, _tmp22_, (guint) _tmp24_, (guint) _tmp26_);
			_g_free0 (_tmp22_);
			_tmp27_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp27_;
			return result;
		}
	}
}


static LexerToken* lexer_insert_hex (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		LexerTokenType _tmp2_ = 0;
		PreLexer* _tmp3_ = NULL;
		LexerTokenType _tmp4_ = 0;
		_tmp2_ = type;
		if (!(_tmp2_ == LEXER_TOKEN_TYPE_PL_HEX)) {
			break;
		}
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = pre_lexer_get_next_token (_tmp3_);
		type = _tmp4_;
	}
	_tmp5_ = type;
	if (_tmp5_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp6_ = NULL;
		_tmp6_ = lexer_insert_hex_dec (self);
		result = _tmp6_;
		return result;
	} else {
		LexerTokenType _tmp7_ = 0;
		_tmp7_ = type;
		if (_tmp7_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
			LexerToken* _tmp8_ = NULL;
			_tmp8_ = lexer_insert_decimal_hex (self);
			result = _tmp8_;
			return result;
		} else {
			LexerTokenType _tmp9_ = 0;
			_tmp9_ = type;
			if (_tmp9_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
				PreLexer* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				while (TRUE) {
					PreLexer* _tmp10_ = NULL;
					LexerTokenType _tmp11_ = 0;
					_tmp10_ = self->priv->prelexer;
					_tmp11_ = pre_lexer_get_next_token (_tmp10_);
					if (!(_tmp11_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
						break;
					}
				}
				_tmp12_ = self->priv->prelexer;
				pre_lexer_roll_back (_tmp12_);
				_tmp13_ = lexer_check_if_number (self);
				if (_tmp13_) {
					LexerToken* _tmp14_ = NULL;
					_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp14_;
					return result;
				} else {
					gboolean _tmp15_ = FALSE;
					_tmp15_ = lexer_check_if_function (self);
					if (_tmp15_) {
						LexerToken* _tmp16_ = NULL;
						_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
						result = _tmp16_;
						return result;
					} else {
						LexerToken* _tmp17_ = NULL;
						_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
						result = _tmp17_;
						return result;
					}
				}
			} else {
				LexerTokenType _tmp18_ = 0;
				_tmp18_ = type;
				if (_tmp18_ == LEXER_TOKEN_TYPE_PL_LETTER) {
					LexerToken* _tmp19_ = NULL;
					_tmp19_ = lexer_insert_letter (self);
					result = _tmp19_;
					return result;
				} else {
					PreLexer* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					_tmp20_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp20_);
					_tmp21_ = lexer_check_if_number (self);
					if (_tmp21_) {
						LexerToken* _tmp22_ = NULL;
						_tmp22_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp22_;
						return result;
					} else {
						gboolean _tmp23_ = FALSE;
						_tmp23_ = lexer_check_if_function (self);
						if (_tmp23_) {
							LexerToken* _tmp24_ = NULL;
							_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
							result = _tmp24_;
							return result;
						} else {
							LexerToken* _tmp25_ = NULL;
							_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
							result = _tmp25_;
							return result;
						}
					}
				}
			}
		}
	}
}


static LexerToken* lexer_insert_hex_dec (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	LexerTokenType _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		LexerTokenType _tmp3_ = 0;
		PreLexer* _tmp5_ = NULL;
		LexerTokenType _tmp6_ = 0;
		_tmp3_ = type;
		if (_tmp3_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp2_ = TRUE;
		} else {
			LexerTokenType _tmp4_ = 0;
			_tmp4_ = type;
			_tmp2_ = _tmp4_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp5_ = self->priv->prelexer;
		_tmp6_ = pre_lexer_get_next_token (_tmp5_);
		type = _tmp6_;
	}
	_tmp7_ = type;
	if (_tmp7_ == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp8_ = NULL;
		_tmp8_ = lexer_insert_decimal_hex (self);
		result = _tmp8_;
		return result;
	} else {
		LexerTokenType _tmp9_ = 0;
		_tmp9_ = type;
		if (_tmp9_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp12_ = NULL;
			LexerToken* _tmp13_ = NULL;
			while (TRUE) {
				PreLexer* _tmp10_ = NULL;
				LexerTokenType _tmp11_ = 0;
				_tmp10_ = self->priv->prelexer;
				_tmp11_ = pre_lexer_get_next_token (_tmp10_);
				if (!(_tmp11_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp12_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp12_);
			_tmp13_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp13_;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			Parser* _tmp16_ = NULL;
			PreLexer* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			PreLexer* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			PreLexer* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			LexerToken* _tmp24_ = NULL;
			_tmp14_ = lexer_check_if_number (self);
			if (_tmp14_) {
				LexerToken* _tmp15_ = NULL;
				_tmp15_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
				result = _tmp15_;
				return result;
			}
			_tmp16_ = self->priv->parser;
			_tmp17_ = self->priv->prelexer;
			_tmp18_ = pre_lexer_get_marked_substring (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->prelexer;
			_tmp21_ = _tmp20_->mark_index;
			_tmp22_ = self->priv->prelexer;
			_tmp23_ = _tmp22_->index;
			parser_set_error (_tmp16_, ERROR_CODE_MP, _tmp19_, (guint) _tmp21_, (guint) _tmp23_);
			_g_free0 (_tmp19_);
			_tmp24_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp24_;
			return result;
		}
	}
}


static LexerToken* lexer_insert_decimal_hex (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	PreLexer* _tmp10_ = NULL;
	LexerToken* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		LexerTokenType _tmp3_ = 0;
		PreLexer* _tmp5_ = NULL;
		LexerTokenType _tmp6_ = 0;
		_tmp3_ = type;
		if (_tmp3_ == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp2_ = TRUE;
		} else {
			LexerTokenType _tmp4_ = 0;
			_tmp4_ = type;
			_tmp2_ = _tmp4_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp5_ = self->priv->prelexer;
		_tmp6_ = pre_lexer_get_next_token (_tmp5_);
		type = _tmp6_;
	}
	while (TRUE) {
		LexerTokenType _tmp7_ = 0;
		PreLexer* _tmp8_ = NULL;
		LexerTokenType _tmp9_ = 0;
		_tmp7_ = type;
		if (!(_tmp7_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp8_ = self->priv->prelexer;
		_tmp9_ = pre_lexer_get_next_token (_tmp8_);
		type = _tmp9_;
	}
	_tmp10_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp10_);
	_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
	result = _tmp11_;
	return result;
}


static LexerToken* lexer_insert_letter (Lexer* self) {
	LexerToken* result = NULL;
	LexerTokenType type = 0;
	PreLexer* _tmp0_ = NULL;
	LexerTokenType _tmp1_ = 0;
	PreLexer* _tmp10_ = NULL;
	gchar* name = NULL;
	PreLexer* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp26_ = NULL;
	gboolean _tmp28_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_next_token (_tmp0_);
	type = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		LexerTokenType _tmp3_ = 0;
		PreLexer* _tmp5_ = NULL;
		LexerTokenType _tmp6_ = 0;
		_tmp3_ = type;
		if (_tmp3_ == LEXER_TOKEN_TYPE_PL_LETTER) {
			_tmp2_ = TRUE;
		} else {
			LexerTokenType _tmp4_ = 0;
			_tmp4_ = type;
			_tmp2_ = _tmp4_ == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp5_ = self->priv->prelexer;
		_tmp6_ = pre_lexer_get_next_token (_tmp5_);
		type = _tmp6_;
	}
	while (TRUE) {
		LexerTokenType _tmp7_ = 0;
		PreLexer* _tmp8_ = NULL;
		LexerTokenType _tmp9_ = 0;
		_tmp7_ = type;
		if (!(_tmp7_ == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp8_ = self->priv->prelexer;
		_tmp9_ = pre_lexer_get_next_token (_tmp8_);
		type = _tmp9_;
	}
	_tmp10_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp10_);
	_tmp11_ = self->priv->prelexer;
	_tmp12_ = pre_lexer_get_marked_substring (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	name = _tmp15_;
	_tmp16_ = name;
	if (g_strcmp0 (_tmp16_, "mod") == 0) {
		LexerToken* _tmp17_ = NULL;
		_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_MOD);
		result = _tmp17_;
		_g_free0 (name);
		return result;
	}
	_tmp18_ = name;
	if (g_strcmp0 (_tmp18_, "and") == 0) {
		LexerToken* _tmp19_ = NULL;
		_tmp19_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_AND);
		result = _tmp19_;
		_g_free0 (name);
		return result;
	}
	_tmp20_ = name;
	if (g_strcmp0 (_tmp20_, "or") == 0) {
		LexerToken* _tmp21_ = NULL;
		_tmp21_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_OR);
		result = _tmp21_;
		_g_free0 (name);
		return result;
	}
	_tmp22_ = name;
	if (g_strcmp0 (_tmp22_, "xor") == 0) {
		LexerToken* _tmp23_ = NULL;
		_tmp23_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_XOR);
		result = _tmp23_;
		_g_free0 (name);
		return result;
	}
	_tmp24_ = name;
	if (g_strcmp0 (_tmp24_, "not") == 0) {
		LexerToken* _tmp25_ = NULL;
		_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NOT);
		result = _tmp25_;
		_g_free0 (name);
		return result;
	}
	_tmp26_ = name;
	if (g_strcmp0 (_tmp26_, "in") == 0) {
		LexerToken* _tmp27_ = NULL;
		_tmp27_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_IN);
		result = _tmp27_;
		_g_free0 (name);
		return result;
	}
	_tmp28_ = lexer_check_if_function (self);
	if (_tmp28_) {
		LexerToken* _tmp29_ = NULL;
		_tmp29_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
		result = _tmp29_;
		_g_free0 (name);
		return result;
	} else {
		LexerToken* _tmp30_ = NULL;
		_tmp30_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
		result = _tmp30_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}


static void lexer_class_init (LexerClass * klass) {
	lexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LexerPrivate));
	G_OBJECT_CLASS (klass)->finalize = lexer_finalize;
}


static void lexer_instance_init (Lexer * self) {
	self->priv = LEXER_GET_PRIVATE (self);
}


static void lexer_finalize (GObject* obj) {
	Lexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER, Lexer);
	_parser_unref0 (self->priv->parser);
	_g_object_unref0 (self->priv->prelexer);
	__g_list_free__g_object_unref0_0 (self->tokens);
	G_OBJECT_CLASS (lexer_parent_class)->finalize (obj);
}


GType lexer_get_type (void) {
	static volatile gsize lexer_type_id__volatile = 0;
	if (g_once_init_enter (&lexer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Lexer), 0, (GInstanceInitFunc) lexer_instance_init, NULL };
		GType lexer_type_id;
		lexer_type_id = g_type_register_static (G_TYPE_OBJECT, "Lexer", &g_define_type_info, 0);
		g_once_init_leave (&lexer_type_id__volatile, lexer_type_id);
	}
	return lexer_type_id__volatile;
}



