/* number.c generated by valac 0.34.1, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */

#include <glib.h>
#include <glib-object.h>
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
};

struct _NumberClass {
	GObjectClass parent_class;
};

struct _NumberPrivate {
	__mpfr_struct _re_num;
	__mpfr_struct _im_num;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
static gulong number__precision;
static gulong number__precision = (gulong) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
#define NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NUMBER, NumberPrivate))
enum  {
	NUMBER_DUMMY_PROPERTY
};
static void number_get_re_num (Number* self, __mpfr_struct* result);
static void number_get_im_num (Number* self, __mpfr_struct* result);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
gulong number_get_precision (void);
static void number_set_re_num (Number* self, __mpfr_struct* value);
static void number_set_im_num (Number* self, __mpfr_struct* value);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
Number* number_new_mpfloat (__mpfr_struct* value);
Number* number_construct_mpfloat (GType object_type, __mpfr_struct* value);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_multiply (Number* self, Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_zero (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
void number_check_flags (void);
const gchar* number_get_error (void);
void number_set_error (const gchar* value);
gboolean number_equals (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
Number* number_abs (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_add (Number* self, Number* y);
Number* number_sqrt (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_divide (Number* self, Number* y);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_subtract (Number* self, Number* y);
static Number* number_from_radians (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
static Number* number_copy (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
static Number* number_reciprocal_real (Number* self);
Number* number_epowy (Number* self);
static Number* number_epowy_real (Number* self);
Number* number_xpowy (Number* self, Number* y);
static Number* number_pwr (Number* self, Number* y);
Number* number_root (Number* self, gint64 n);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_ln (Number* self);
static Number* number_root_real (Number* self, gint64 n);
static Number* number_ln_real (Number* self);
Number* number_logarithm (Number* self, gint64 n);
Number* number_factorial (Number* self);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_add_real (Number* self, Number* y);
Number* number_multiply_real (Number* self, Number* y);
Number* number_modulus_divide (Number* self, Number* y);
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* number_sin_real (Number* self, AngleUnit unit);
Number* number_cosh (Number* self);
static Number* number_cos_real (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_tan (Number* self, AngleUnit unit);
static Number* number_to_radians (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self, Number* y);
static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen);
static gint __lambda4_ (Number* self, gint v1, gint v2);
static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_or (Number* self, Number* y);
static gint __lambda5_ (Number* self, gint v1, gint v2);
static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_xor (Number* self, Number* y);
static gint __lambda6_ (Number* self, gint v1, gint v2);
static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_not (Number* self, gint wordlen);
static gint __lambda7_ (Number* self, gint v1, gint v2);
static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_mask (Number* self, Number* x, gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_shift (Number* self, gint count);
Number* number_ones_complement (Number* self, gint wordlen);
static gint __lambda8_ (Number* self, gint v1, gint v2);
static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_twos_complement (Number* self, gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self, guint64 n);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Number* number_new (void);
Number* number_construct (GType object_type);
static gint number_hex_to_int (Number* self, gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gchar* serializer_to_string (Serializer* self, Number* x);
void number_set_precision (gulong value);
static void number_finalize (GObject* obj);
static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c, gint number_base);
gboolean mp_is_overflow (Number* x, gint wordlen);


GType angle_unit_get_type (void) {
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number* number_construct_integer (GType object_type, gint64 value) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	gint64 _tmp2_ = 0LL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = value;
	mpfr_set_si (&tmp, (glong) _tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	number_set_re_num (self, &_tmp3_);
	_tmp4_ = number_get_precision ();
	_tmp5_ = _tmp4_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
	_tmp6_ = tmp2;
	number_set_im_num (self, &_tmp6_);
	return self;
}


Number* number_new_integer (gint64 value) {
	return number_construct_integer (TYPE_NUMBER, value);
}


Number* number_construct_unsigned_integer (GType object_type, guint64 x) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	guint64 _tmp2_ = 0ULL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = x;
	mpfr_set_ui (&tmp, (gulong) _tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	number_set_re_num (self, &_tmp3_);
	_tmp4_ = number_get_precision ();
	_tmp5_ = _tmp4_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
	_tmp6_ = tmp2;
	number_set_im_num (self, &_tmp6_);
	return self;
}


Number* number_new_unsigned_integer (guint64 x) {
	return number_construct_unsigned_integer (TYPE_NUMBER, x);
}


Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	_tmp0_ = denominator;
	if (_tmp0_ < ((gint64) 0)) {
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
		_tmp1_ = numerator;
		numerator = -_tmp1_;
		_tmp2_ = denominator;
		denominator = -_tmp2_;
	}
	_tmp3_ = numerator;
	self = (Number*) number_construct_integer (object_type, _tmp3_);
	_tmp4_ = denominator;
	if (_tmp4_ != ((gint64) 1)) {
		__mpfr_struct tmp = {0};
		__mpfr_struct _tmp5_ = {0};
		__mpfr_struct _tmp6_ = {0};
		gint64 _tmp7_ = 0LL;
		__mpfr_struct _tmp8_ = {0};
		_tmp5_ = self->priv->_re_num;
		tmp = _tmp5_;
		_tmp6_ = self->priv->_re_num;
		_tmp7_ = denominator;
		mpfr_div_si (&tmp, &_tmp6_, (glong) _tmp7_, MPFR_RNDN);
		_tmp8_ = tmp;
		number_set_re_num (self, &_tmp8_);
	}
	return self;
}


Number* number_new_fraction (gint64 numerator, gint64 denominator) {
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
}


Number* number_construct_mpfloat (GType object_type, __mpfr_struct* value) {
	Number * self = NULL;
	__mpfr_struct _tmp0_ = {0};
	__mpfr_struct tmp = {0};
	gulong _tmp1_ = 0UL;
	gulong _tmp2_ = 0UL;
	__mpfr_struct _tmp3_ = {0};
	g_return_val_if_fail (value != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = *value;
	number_set_re_num (self, &_tmp0_);
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp2_);
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
	_tmp3_ = tmp;
	number_set_im_num (self, &_tmp3_);
	return self;
}


Number* number_new_mpfloat (__mpfr_struct* value) {
	return number_construct_mpfloat (TYPE_NUMBER, value);
}


Number* number_construct_double (GType object_type, gdouble value) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	gdouble _tmp2_ = 0.0;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = value;
	mpfr_set_d (&tmp, _tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	number_set_re_num (self, &_tmp3_);
	_tmp4_ = number_get_precision ();
	_tmp5_ = _tmp4_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
	_tmp6_ = tmp2;
	number_set_im_num (self, &_tmp6_);
	return self;
}


Number* number_new_double (gdouble value) {
	return number_construct_double (TYPE_NUMBER, value);
}


Number* number_construct_complex (GType object_type, Number* x, Number* y) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	Number* _tmp2_ = NULL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp5_ = 0UL;
	gulong _tmp6_ = 0UL;
	Number* _tmp7_ = NULL;
	__mpfr_struct _tmp8_ = {0};
	__mpfr_struct _tmp9_ = {0};
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = x;
	_tmp3_ = _tmp2_->priv->_re_num;
	mpfr_set (&tmp, &_tmp3_, MPFR_RNDN);
	_tmp4_ = tmp;
	number_set_re_num (self, &_tmp4_);
	_tmp5_ = number_get_precision ();
	_tmp6_ = _tmp5_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp6_);
	_tmp7_ = y;
	_tmp8_ = _tmp7_->priv->_re_num;
	mpfr_set (&tmp2, &_tmp8_, MPFR_RNDN);
	_tmp9_ = tmp2;
	number_set_im_num (self, &_tmp9_);
	return self;
}


Number* number_new_complex (Number* x, Number* y) {
	return number_construct_complex (TYPE_NUMBER, x, y);
}


Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit) {
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	AngleUnit _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Number* y = NULL;
	Number* _tmp3_ = NULL;
	AngleUnit _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (theta != NULL, NULL);
	_tmp0_ = theta;
	_tmp1_ = unit;
	_tmp2_ = number_cos (_tmp0_, _tmp1_);
	x = _tmp2_;
	_tmp3_ = theta;
	_tmp4_ = unit;
	_tmp5_ = number_sin (_tmp3_, _tmp4_);
	y = _tmp5_;
	_tmp6_ = r;
	_tmp7_ = number_multiply (x, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = r;
	_tmp10_ = number_multiply (y, _tmp9_);
	_tmp11_ = _tmp10_;
	self = (Number*) number_construct_complex (object_type, _tmp8_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}


Number* number_new_polar (Number* r, Number* theta, AngleUnit unit) {
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
}


Number* number_construct_eulers (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct tmp3 = {0};
	gulong _tmp6_ = 0UL;
	gulong _tmp7_ = 0UL;
	__mpfr_struct _tmp8_ = {0};
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp3_);
	mpfr_set_ui (&tmp2, (gulong) 1, MPFR_RNDN);
	_tmp4_ = tmp2;
	mpfr_exp (&tmp, &_tmp4_, MPFR_RNDN);
	_tmp5_ = tmp;
	number_set_re_num (self, &_tmp5_);
	_tmp6_ = number_get_precision ();
	_tmp7_ = _tmp6_;
	mpfr_init2 (&tmp3, (mpfr_prec_t) _tmp7_);
	mpfr_set_ui (&tmp3, (gulong) 0, MPFR_RNDN);
	_tmp8_ = tmp3;
	number_set_im_num (self, &_tmp8_);
	return self;
}


Number* number_new_eulers (void) {
	return number_construct_eulers (TYPE_NUMBER);
}


Number* number_construct_i (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp3_);
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
	mpfr_set_ui (&tmp2, (gulong) 1, MPFR_RNDN);
	_tmp4_ = tmp;
	number_set_re_num (self, &_tmp4_);
	_tmp5_ = tmp2;
	number_set_im_num (self, &_tmp5_);
	return self;
}


Number* number_new_i (void) {
	return number_construct_i (TYPE_NUMBER);
}


Number* number_construct_pi (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	mpfr_const_pi (&tmp, MPFR_RNDN);
	_tmp2_ = tmp;
	number_set_re_num (self, &_tmp2_);
	_tmp3_ = number_get_precision ();
	_tmp4_ = _tmp3_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp4_);
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
	_tmp5_ = tmp2;
	number_set_im_num (self, &_tmp5_);
	return self;
}


Number* number_new_pi (void) {
	return number_construct_pi (TYPE_NUMBER);
}


Number* number_construct_random (GType object_type) {
	Number * self = NULL;
	gdouble _tmp0_ = 0.0;
	_tmp0_ = g_random_double ();
	self = (Number*) number_construct_double (object_type, _tmp0_);
	return self;
}


Number* number_new_random (void) {
	return number_construct_random (TYPE_NUMBER);
}


gint64 number_to_integer (Number* self) {
	gint64 result = 0LL;
	__mpfr_struct _tmp0_ = {0};
	glong _tmp1_ = 0L;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = mpfr_get_si (&_tmp0_, MPFR_RNDN);
	result = (gint64) _tmp1_;
	return result;
}


guint64 number_to_unsigned_integer (Number* self) {
	guint64 result = 0ULL;
	__mpfr_struct _tmp0_ = {0};
	gulong _tmp1_ = 0UL;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = mpfr_get_ui (&_tmp0_, MPFR_RNDN);
	result = (guint64) _tmp1_;
	return result;
}


gfloat number_to_float (Number* self) {
	gfloat result = 0.0F;
	__mpfr_struct _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = mpfr_get_flt (&_tmp0_, MPFR_RNDN);
	result = _tmp1_;
	return result;
}


gdouble number_to_double (Number* self) {
	gdouble result = 0.0;
	__mpfr_struct _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = mpfr_get_d (&_tmp0_, MPFR_RNDN);
	result = _tmp1_;
	return result;
}


gboolean number_is_zero (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_re_num;
	_tmp2_ = mpfr_zero_p (&_tmp1_);
	if (_tmp2_) {
		__mpfr_struct _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->_im_num;
		_tmp4_ = mpfr_zero_p (&_tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean number_is_negative (Number* self) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = mpfr_sgn (&_tmp0_);
	result = _tmp1_ < 0;
	return result;
}


gboolean number_is_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct _tmp1_ = {0};
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_re_num;
	_tmp2_ = mpfr_integer_p (&_tmp1_);
	result = _tmp2_ != 0;
	return result;
}


gboolean number_is_positive_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		__mpfr_struct _tmp2_ = {0};
		gint _tmp3_ = 0;
		_tmp2_ = self->priv->_re_num;
		_tmp3_ = mpfr_sgn (&_tmp2_);
		if (_tmp3_ >= 0) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = number_is_integer (self);
			_tmp1_ = _tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean number_is_natural (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		__mpfr_struct _tmp2_ = {0};
		gint _tmp3_ = 0;
		_tmp2_ = self->priv->_re_num;
		_tmp3_ = mpfr_sgn (&_tmp2_);
		if (_tmp3_ > 0) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = number_is_integer (self);
			_tmp1_ = _tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean number_is_complex (Number* self) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_im_num;
	_tmp1_ = mpfr_zero_p (&_tmp0_);
	result = !_tmp1_;
	return result;
}


void number_check_flags (void) {
	gint _tmp0_ = 0;
	_tmp0_ = mpfr_underflow_p ();
	if (_tmp0_ != 0) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Underflow error");
		number_set_error (_tmp3_);
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = mpfr_overflow_p ();
		if (_tmp4_ != 0) {
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp5_ = number_get_error ();
			_tmp6_ = _tmp5_;
			_tmp7_ = _ ("Overflow error");
			number_set_error (_tmp7_);
		}
	}
}


gboolean number_equals (Number* self, Number* y) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	Number* _tmp1_ = NULL;
	__mpfr_struct _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = y;
	_tmp2_ = _tmp1_->priv->_re_num;
	_tmp3_ = mpfr_equal_p (&_tmp0_, &_tmp2_);
	result = _tmp3_;
	return result;
}


gint number_compare (Number* self, Number* y) {
	gint result = 0;
	__mpfr_struct _tmp0_ = {0};
	Number* _tmp1_ = NULL;
	__mpfr_struct _tmp2_ = {0};
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = y;
	_tmp2_ = _tmp1_->priv->_re_num;
	_tmp3_ = mpfr_cmp (&_tmp0_, &_tmp2_);
	result = _tmp3_;
	return result;
}


Number* number_sgn (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	__mpfr_struct _tmp0_ = {0};
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_re_num;
	_tmp1_ = mpfr_sgn (&_tmp0_);
	_tmp2_ = number_new_integer ((gint64) _tmp1_);
	z = _tmp2_;
	result = z;
	return result;
}


Number* number_invert_sign (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	__mpfr_struct tmp_im = {0};
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct _tmp6_ = {0};
	__mpfr_struct _tmp7_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_neg (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	_tmp5_ = z->priv->_im_num;
	tmp_im = _tmp5_;
	_tmp6_ = self->priv->_im_num;
	mpfr_neg (&tmp_im, &_tmp6_, MPFR_RNDN);
	_tmp7_ = tmp_im;
	number_set_im_num (z, &_tmp7_);
	result = z;
	return result;
}


Number* number_abs (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* z = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp1_ = number_real_component (self);
		x_real = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		x_im = _tmp2_;
		_tmp3_ = x_real;
		_tmp4_ = x_real;
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
		_g_object_unref0 (x_real);
		x_real = _tmp5_;
		_tmp6_ = x_im;
		_tmp7_ = x_im;
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
		_g_object_unref0 (x_im);
		x_im = _tmp8_;
		_tmp9_ = x_real;
		_tmp10_ = x_im;
		_tmp11_ = number_add (_tmp9_, _tmp10_);
		z = _tmp11_;
		_tmp12_ = z;
		_tmp13_ = number_sqrt (_tmp12_);
		result = _tmp13_;
		_g_object_unref0 (z);
		_g_object_unref0 (x_im);
		_g_object_unref0 (x_real);
		return result;
	} else {
		__mpfr_struct tmp = {0};
		gulong _tmp14_ = 0UL;
		gulong _tmp15_ = 0UL;
		__mpfr_struct _tmp16_ = {0};
		Number* z = NULL;
		__mpfr_struct _tmp17_ = {0};
		Number* _tmp18_ = NULL;
		_tmp14_ = number_get_precision ();
		_tmp15_ = _tmp14_;
		mpfr_init2 (&tmp, (mpfr_prec_t) _tmp15_);
		_tmp16_ = self->priv->_re_num;
		mpfr_abs (&tmp, &_tmp16_, MPFR_RNDN);
		_tmp17_ = tmp;
		_tmp18_ = number_new_mpfloat (&_tmp17_);
		z = _tmp18_;
		result = z;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Number* number_arg (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_real = NULL;
	Number* _tmp5_ = NULL;
	Number* x_im = NULL;
	Number* _tmp6_ = NULL;
	Number* pi = NULL;
	Number* _tmp7_ = NULL;
	Number* z = NULL;
	Number* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	Number* _tmp43_ = NULL;
	AngleUnit _tmp44_ = 0;
	Number* _tmp45_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Argument not defined for zero");
		number_set_error (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = number_real_component (self);
	x_real = _tmp5_;
	_tmp6_ = number_imaginary_component (self);
	x_im = _tmp6_;
	_tmp7_ = number_new_pi ();
	pi = _tmp7_;
	_tmp8_ = x_im;
	_tmp9_ = number_is_zero (_tmp8_);
	if (_tmp9_) {
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = x_real;
		_tmp11_ = number_is_negative (_tmp10_);
		if (_tmp11_) {
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
			_tmp12_ = pi;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (z);
			z = _tmp13_;
		} else {
			Number* _tmp14_ = NULL;
			_tmp14_ = number_new_integer ((gint64) 0);
			result = _tmp14_;
			_g_object_unref0 (z);
			_g_object_unref0 (pi);
			_g_object_unref0 (x_im);
			_g_object_unref0 (x_real);
			return result;
		}
	} else {
		Number* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp15_ = x_real;
		_tmp16_ = number_is_zero (_tmp15_);
		if (_tmp16_) {
			Number* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp17_ = x_im;
			_tmp18_ = number_is_negative (_tmp17_);
			if (_tmp18_) {
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				_tmp19_ = pi;
				_tmp20_ = number_divide_integer (_tmp19_, (gint64) -2);
				_g_object_unref0 (z);
				z = _tmp20_;
			} else {
				Number* _tmp21_ = NULL;
				Number* _tmp22_ = NULL;
				_tmp21_ = pi;
				_tmp22_ = number_divide_integer (_tmp21_, (gint64) 2);
				_g_object_unref0 (z);
				z = _tmp22_;
			}
		} else {
			Number* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = x_real;
			_tmp24_ = number_is_negative (_tmp23_);
			if (_tmp24_) {
				Number* _tmp25_ = NULL;
				Number* _tmp26_ = NULL;
				Number* _tmp27_ = NULL;
				Number* _tmp28_ = NULL;
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				_tmp25_ = x_im;
				_tmp26_ = x_real;
				_tmp27_ = number_divide (_tmp25_, _tmp26_);
				_g_object_unref0 (z);
				z = _tmp27_;
				_tmp28_ = z;
				_tmp29_ = number_atan (_tmp28_, ANGLE_UNIT_RADIANS);
				_g_object_unref0 (z);
				z = _tmp29_;
				_tmp30_ = x_im;
				_tmp31_ = number_is_negative (_tmp30_);
				if (_tmp31_) {
					Number* _tmp32_ = NULL;
					Number* _tmp33_ = NULL;
					Number* _tmp34_ = NULL;
					_tmp32_ = z;
					_tmp33_ = pi;
					_tmp34_ = number_subtract (_tmp32_, _tmp33_);
					_g_object_unref0 (z);
					z = _tmp34_;
				} else {
					Number* _tmp35_ = NULL;
					Number* _tmp36_ = NULL;
					Number* _tmp37_ = NULL;
					_tmp35_ = z;
					_tmp36_ = pi;
					_tmp37_ = number_add (_tmp35_, _tmp36_);
					_g_object_unref0 (z);
					z = _tmp37_;
				}
			} else {
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				_tmp38_ = x_im;
				_tmp39_ = x_real;
				_tmp40_ = number_divide (_tmp38_, _tmp39_);
				_g_object_unref0 (z);
				z = _tmp40_;
				_tmp41_ = z;
				_tmp42_ = number_atan (_tmp41_, ANGLE_UNIT_RADIANS);
				_g_object_unref0 (z);
				z = _tmp42_;
			}
		}
	}
	_tmp43_ = z;
	_tmp44_ = unit;
	_tmp45_ = number_from_radians (_tmp43_, _tmp44_);
	result = _tmp45_;
	_g_object_unref0 (z);
	_g_object_unref0 (pi);
	_g_object_unref0 (x_im);
	_g_object_unref0 (x_real);
	return result;
}


Number* number_conjugate (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	Number* _tmp3_ = NULL;
	__mpfr_struct tmp2 = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_im_num;
	mpfr_neg (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = number_copy (self);
	z = _tmp3_;
	_tmp4_ = z->priv->_im_num;
	tmp2 = _tmp4_;
	mpfr_clear (&tmp2);
	_tmp5_ = tmp;
	number_set_im_num (z, &_tmp5_);
	result = z;
	return result;
}


Number* number_real_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z->priv->_im_num;
	tmp = _tmp1_;
	mpfr_clear (&tmp);
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp3_);
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
	_tmp4_ = tmp;
	number_set_im_num (z, &_tmp4_);
	result = z;
	return result;
}


Number* number_imaginary_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z->priv->_re_num;
	tmp = _tmp1_;
	mpfr_clear (&tmp);
	_tmp2_ = z->priv->_im_num;
	number_set_re_num (z, &_tmp2_);
	_tmp3_ = number_get_precision ();
	_tmp4_ = _tmp3_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp4_);
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
	_tmp5_ = tmp;
	number_set_im_num (z, &_tmp5_);
	result = z;
	return result;
}


Number* number_integer_component (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_trunc (&tmp, &_tmp2_);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_fractional_component (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_frac (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_fractional_part (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_subtract (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


Number* number_floor (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_floor (&tmp, &_tmp2_);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_ceiling (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_ceil (&tmp, &_tmp2_);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_round (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_round (&tmp, &_tmp2_);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_reciprocal (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* real_x = NULL;
		Number* _tmp1_ = NULL;
		Number* im_x = NULL;
		Number* _tmp2_ = NULL;
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* t2 = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* z = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		_tmp1_ = number_real_component (self);
		real_x = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		im_x = _tmp2_;
		_tmp3_ = real_x;
		_tmp4_ = real_x;
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
		t1 = _tmp5_;
		_tmp6_ = im_x;
		_tmp7_ = im_x;
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
		t2 = _tmp8_;
		_tmp9_ = t1;
		_tmp10_ = t2;
		_tmp11_ = number_add (_tmp9_, _tmp10_);
		_g_object_unref0 (t1);
		t1 = _tmp11_;
		_tmp12_ = t1;
		_tmp13_ = number_reciprocal_real (_tmp12_);
		z = _tmp13_;
		_tmp14_ = number_conjugate (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = z;
		_tmp17_ = number_multiply (_tmp15_, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp15_);
		result = _tmp18_;
		_g_object_unref0 (z);
		_g_object_unref0 (t2);
		_g_object_unref0 (t1);
		_g_object_unref0 (im_x);
		_g_object_unref0 (real_x);
		return result;
	} else {
		Number* _tmp19_ = NULL;
		_tmp19_ = number_reciprocal_real (self);
		result = _tmp19_;
		return result;
	}
}


Number* number_epowy (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_is_complex (self);
	if (_tmp2_) {
		Number* x_real = NULL;
		Number* _tmp3_ = NULL;
		Number* theta = NULL;
		Number* _tmp4_ = NULL;
		Number* r = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		_tmp3_ = number_real_component (self);
		x_real = _tmp3_;
		_tmp4_ = number_imaginary_component (self);
		theta = _tmp4_;
		_tmp5_ = x_real;
		_tmp6_ = number_epowy_real (_tmp5_);
		r = _tmp6_;
		_tmp7_ = r;
		_tmp8_ = theta;
		_tmp9_ = number_new_polar (_tmp7_, _tmp8_, ANGLE_UNIT_RADIANS);
		result = _tmp9_;
		_g_object_unref0 (r);
		_g_object_unref0 (theta);
		_g_object_unref0 (x_real);
		return result;
	} else {
		Number* _tmp10_ = NULL;
		_tmp10_ = number_epowy_real (self);
		result = _tmp10_;
		return result;
	}
}


Number* number_xpowy (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Number* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	Number* t = NULL;
	Number* t2 = NULL;
	Number* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp44_ = 0UL;
	gulong _tmp45_ = 0UL;
	Number* _tmp46_ = NULL;
	__mpfr_struct _tmp47_ = {0};
	Number* _tmp48_ = NULL;
	__mpfr_struct _tmp49_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp50_ = {0};
	Number* _tmp51_ = NULL;
	__mpfr_struct tmp2 = {0};
	Number* _tmp52_ = NULL;
	__mpfr_struct _tmp53_ = {0};
	gulong _tmp54_ = 0UL;
	gulong _tmp55_ = 0UL;
	Number* _tmp56_ = NULL;
	__mpfr_struct _tmp57_ = {0};
	Number* _tmp58_ = NULL;
	__mpfr_struct _tmp59_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_negative (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("The power of zero is undefined for a negative exponent");
		number_set_error (_tmp6_);
		_tmp7_ = number_new_integer ((gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp9_ = number_is_zero (self);
	if (_tmp9_) {
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = y;
		_tmp11_ = number_is_zero (_tmp10_);
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		_tmp12_ = number_get_error ();
		_tmp13_ = _tmp12_;
		_tmp14_ = _ ("Zero raised to zero is undefined");
		number_set_error (_tmp14_);
		_tmp15_ = number_new_integer ((gint64) 0);
		result = _tmp15_;
		return result;
	}
	_tmp17_ = number_is_complex (self);
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		Number* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp18_ = y;
		_tmp19_ = number_is_complex (_tmp18_);
		_tmp16_ = _tmp19_;
	}
	if (_tmp16_) {
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		_tmp20_ = y;
		_tmp21_ = number_pwr (self, _tmp20_);
		result = _tmp21_;
		return result;
	}
	_tmp22_ = y;
	_tmp23_ = number_is_integer (_tmp22_);
	if (!_tmp23_) {
		Number* reciprocal = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		Number* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = y;
		_tmp25_ = number_reciprocal (_tmp24_);
		reciprocal = _tmp25_;
		_tmp27_ = reciprocal;
		_tmp28_ = number_is_integer (_tmp27_);
		if (_tmp28_) {
			Number* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			_tmp29_ = reciprocal;
			_tmp30_ = number_is_negative (_tmp29_);
			_tmp26_ = !_tmp30_;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			Number* _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			Number* _tmp33_ = NULL;
			_tmp31_ = reciprocal;
			_tmp32_ = number_to_integer (_tmp31_);
			_tmp33_ = number_root (self, _tmp32_);
			result = _tmp33_;
			_g_object_unref0 (reciprocal);
			return result;
		} else {
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
			_tmp34_ = y;
			_tmp35_ = number_pwr (self, _tmp34_);
			result = _tmp35_;
			_g_object_unref0 (reciprocal);
			return result;
		}
		_g_object_unref0 (reciprocal);
	}
	_tmp36_ = y;
	_tmp37_ = number_is_negative (_tmp36_);
	if (_tmp37_) {
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		_tmp38_ = number_reciprocal (self);
		_g_object_unref0 (t);
		t = _tmp38_;
		_tmp39_ = y;
		_tmp40_ = number_invert_sign (_tmp39_);
		_g_object_unref0 (t2);
		t2 = _tmp40_;
	} else {
		Number* _tmp41_ = NULL;
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
		_tmp41_ = _g_object_ref0 (self);
		_g_object_unref0 (t);
		t = _tmp41_;
		_tmp42_ = y;
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (t2);
		t2 = _tmp43_;
	}
	_tmp44_ = number_get_precision ();
	_tmp45_ = _tmp44_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp45_);
	_tmp46_ = t;
	_tmp47_ = _tmp46_->priv->_re_num;
	_tmp48_ = t2;
	_tmp49_ = _tmp48_->priv->_re_num;
	mpfr_pow (&tmp, &_tmp47_, &_tmp49_, MPFR_RNDN);
	_tmp50_ = tmp;
	_tmp51_ = number_new_mpfloat (&_tmp50_);
	z = _tmp51_;
	_tmp52_ = z;
	_tmp53_ = _tmp52_->priv->_im_num;
	tmp2 = _tmp53_;
	mpfr_clear (&tmp2);
	_tmp54_ = number_get_precision ();
	_tmp55_ = _tmp54_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp55_);
	_tmp56_ = t;
	_tmp57_ = _tmp56_->priv->_im_num;
	mpfr_set (&tmp, &_tmp57_, MPFR_RNDN);
	_tmp58_ = z;
	_tmp59_ = tmp;
	number_set_im_num (_tmp58_, &_tmp59_);
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t);
	return result;
}


Number* number_xpowy_integer (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	Number* t = NULL;
	gint64 _tmp14_ = 0LL;
	__mpfr_struct tmp = {0};
	gulong _tmp18_ = 0UL;
	gulong _tmp19_ = 0UL;
	Number* _tmp20_ = NULL;
	__mpfr_struct _tmp21_ = {0};
	gint64 _tmp22_ = 0LL;
	Number* z = NULL;
	__mpfr_struct _tmp23_ = {0};
	Number* _tmp24_ = NULL;
	__mpfr_struct tmp2 = {0};
	Number* _tmp25_ = NULL;
	__mpfr_struct _tmp26_ = {0};
	gulong _tmp27_ = 0UL;
	gulong _tmp28_ = 0UL;
	Number* _tmp29_ = NULL;
	__mpfr_struct _tmp30_ = {0};
	Number* _tmp31_ = NULL;
	__mpfr_struct _tmp32_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		gint64 _tmp2_ = 0LL;
		_tmp2_ = n;
		_tmp0_ = _tmp2_ < ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		_tmp3_ = number_get_error ();
		_tmp4_ = _tmp3_;
		_tmp5_ = _ ("The power of zero is undefined for a negative exponent");
		number_set_error (_tmp5_);
		_tmp6_ = number_new_integer ((gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp8_ = number_is_zero (self);
	if (_tmp8_) {
		gint64 _tmp9_ = 0LL;
		_tmp9_ = n;
		_tmp7_ = _tmp9_ == ((gint64) 0);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp10_ = number_get_error ();
		_tmp11_ = _tmp10_;
		_tmp12_ = _ ("Zero raised to zero is undefined");
		number_set_error (_tmp12_);
		_tmp13_ = number_new_integer ((gint64) 0);
		result = _tmp13_;
		return result;
	}
	_tmp14_ = n;
	if (_tmp14_ < ((gint64) 0)) {
		Number* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
		_tmp15_ = number_reciprocal (self);
		_g_object_unref0 (t);
		t = _tmp15_;
		_tmp16_ = n;
		n = -_tmp16_;
	} else {
		Number* _tmp17_ = NULL;
		_tmp17_ = _g_object_ref0 (self);
		_g_object_unref0 (t);
		t = _tmp17_;
	}
	_tmp18_ = number_get_precision ();
	_tmp19_ = _tmp18_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp19_);
	_tmp20_ = t;
	_tmp21_ = _tmp20_->priv->_re_num;
	_tmp22_ = n;
	mpfr_pow_si (&tmp, &_tmp21_, (glong) _tmp22_, MPFR_RNDN);
	_tmp23_ = tmp;
	_tmp24_ = number_new_mpfloat (&_tmp23_);
	z = _tmp24_;
	_tmp25_ = z;
	_tmp26_ = _tmp25_->priv->_im_num;
	tmp2 = _tmp26_;
	mpfr_clear (&tmp2);
	_tmp27_ = number_get_precision ();
	_tmp28_ = _tmp27_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp28_);
	_tmp29_ = t;
	_tmp30_ = _tmp29_->priv->_im_num;
	mpfr_set (&tmp, &_tmp30_, MPFR_RNDN);
	_tmp31_ = z;
	_tmp32_ = tmp;
	number_set_im_num (_tmp31_, &_tmp32_);
	result = z;
	_g_object_unref0 (t);
	return result;
}


static Number* number_pwr (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		Number* _tmp6_ = NULL;
		_tmp1_ = y;
		_tmp2_ = number_is_negative (_tmp1_);
		if (_tmp2_) {
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp3_ = number_get_error ();
			_tmp4_ = _tmp3_;
			_tmp5_ = _ ("The power of zero is undefined for a negative exponent");
			number_set_error (_tmp5_);
		}
		_tmp6_ = number_new_integer ((gint64) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = y;
	_tmp8_ = number_is_zero (_tmp7_);
	if (_tmp8_) {
		Number* _tmp9_ = NULL;
		_tmp9_ = number_new_integer ((gint64) 1);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = y;
	_tmp11_ = number_ln (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = number_multiply (_tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = number_epowy (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	result = _tmp16_;
	return result;
}


Number* number_root (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = number_is_complex (self);
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = number_is_negative (self);
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint64 _tmp4_ = 0LL;
		_tmp4_ = n;
		_tmp0_ = (_tmp4_ % 2) == ((gint64) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* z = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		_tmp5_ = number_abs (self);
		z = _tmp5_;
		_tmp6_ = z;
		_tmp7_ = n;
		_tmp8_ = number_root_real (_tmp6_, _tmp7_);
		_g_object_unref0 (z);
		z = _tmp8_;
		_tmp9_ = z;
		_tmp10_ = number_invert_sign (_tmp9_);
		_g_object_unref0 (z);
		z = _tmp10_;
		result = z;
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp12_ = number_is_complex (self);
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp13_ = FALSE;
			_tmp13_ = number_is_negative (self);
			_tmp11_ = _tmp13_;
		}
		if (_tmp11_) {
			Number* r = NULL;
			Number* _tmp14_ = NULL;
			Number* theta = NULL;
			Number* _tmp15_ = NULL;
			Number* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			_tmp14_ = number_abs (self);
			r = _tmp14_;
			_tmp15_ = number_arg (self, ANGLE_UNIT_RADIANS);
			theta = _tmp15_;
			_tmp16_ = r;
			_tmp17_ = n;
			_tmp18_ = number_root_real (_tmp16_, _tmp17_);
			_g_object_unref0 (r);
			r = _tmp18_;
			_tmp19_ = theta;
			_tmp20_ = n;
			_tmp21_ = number_divide_integer (_tmp19_, _tmp20_);
			_g_object_unref0 (theta);
			theta = _tmp21_;
			_tmp22_ = r;
			_tmp23_ = theta;
			_tmp24_ = number_new_polar (_tmp22_, _tmp23_, ANGLE_UNIT_RADIANS);
			result = _tmp24_;
			_g_object_unref0 (theta);
			_g_object_unref0 (r);
			return result;
		} else {
			gint64 _tmp25_ = 0LL;
			Number* _tmp26_ = NULL;
			_tmp25_ = n;
			_tmp26_ = number_root_real (self, _tmp25_);
			result = _tmp26_;
			return result;
		}
	}
}


Number* number_sqrt (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_root (self, (gint64) 2);
	result = _tmp0_;
	return result;
}


Number* number_ln (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Logarithm of zero is undefined");
		number_set_error (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp6_ = number_is_complex (self);
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = number_is_negative (self);
		_tmp5_ = _tmp7_;
	}
	if (_tmp5_) {
		Number* r = NULL;
		Number* _tmp8_ = NULL;
		Number* theta = NULL;
		Number* _tmp9_ = NULL;
		Number* z_real = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		_tmp8_ = number_abs (self);
		r = _tmp8_;
		_tmp9_ = number_arg (self, ANGLE_UNIT_RADIANS);
		theta = _tmp9_;
		_tmp10_ = r;
		_tmp11_ = number_ln_real (_tmp10_);
		z_real = _tmp11_;
		_tmp12_ = z_real;
		_tmp13_ = theta;
		_tmp14_ = number_new_complex (_tmp12_, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (z_real);
		_g_object_unref0 (theta);
		_g_object_unref0 (r);
		return result;
	} else {
		Number* _tmp15_ = NULL;
		_tmp15_ = number_ln_real (self);
		result = _tmp15_;
		return result;
	}
}


Number* number_logarithm (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	gint64 _tmp5_ = 0LL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Logarithm of zero is undefined");
		number_set_error (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = n;
	_tmp6_ = number_new_integer (_tmp5_);
	t1 = _tmp6_;
	_tmp7_ = number_ln (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = t1;
	_tmp10_ = number_ln (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = number_divide (_tmp8_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp8_);
	result = _tmp13_;
	_g_object_unref0 (t1);
	return result;
}


Number* number_factorial (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint64 value = 0LL;
	gint64 _tmp20_ = 0LL;
	Number* z = NULL;
	Number* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_is_natural (self);
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		Number* tmp = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		__mpfr_struct tmp2 = {0};
		gulong _tmp14_ = 0UL;
		gulong _tmp15_ = 0UL;
		Number* _tmp16_ = NULL;
		__mpfr_struct _tmp17_ = {0};
		__mpfr_struct _tmp18_ = {0};
		Number* _tmp19_ = NULL;
		_tmp4_ = number_is_negative (self);
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = number_is_complex (self);
			_tmp3_ = _tmp5_;
		}
		if (_tmp3_) {
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			_tmp6_ = number_get_error ();
			_tmp7_ = _tmp6_;
			_tmp8_ = _ ("Factorial is only defined for non-negative real numbers");
			number_set_error (_tmp8_);
			_tmp9_ = number_new_integer ((gint64) 0);
			result = _tmp9_;
			return result;
		}
		_tmp10_ = number_new_integer ((gint64) 1);
		_tmp11_ = _tmp10_;
		_tmp12_ = number_add (self, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		tmp = _tmp13_;
		_tmp14_ = number_get_precision ();
		_tmp15_ = _tmp14_;
		mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp15_);
		_tmp16_ = tmp;
		_tmp17_ = _tmp16_->priv->_re_num;
		mpfr_gamma (&tmp2, &_tmp17_, MPFR_RNDN);
		_tmp18_ = tmp2;
		_tmp19_ = number_new_mpfloat (&_tmp18_);
		result = _tmp19_;
		_g_object_unref0 (tmp);
		return result;
	}
	_tmp20_ = number_to_integer (self);
	value = _tmp20_;
	_tmp21_ = _g_object_ref0 (self);
	z = _tmp21_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				gint64 _tmp25_ = 0LL;
				Number* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				Number* _tmp28_ = NULL;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = value;
				if (!(((gint64) _tmp24_) < _tmp25_)) {
					break;
				}
				_tmp26_ = z;
				_tmp27_ = i;
				_tmp28_ = number_multiply_integer (_tmp26_, (gint64) _tmp27_);
				_g_object_unref0 (z);
				z = _tmp28_;
			}
		}
	}
	result = z;
	return result;
}


Number* number_add (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_complex (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_complex (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		_tmp4_ = number_real_component (self);
		real_x = _tmp4_;
		_tmp5_ = number_imaginary_component (self);
		im_x = _tmp5_;
		_tmp6_ = y;
		_tmp7_ = number_real_component (_tmp6_);
		real_y = _tmp7_;
		_tmp8_ = y;
		_tmp9_ = number_imaginary_component (_tmp8_);
		im_y = _tmp9_;
		_tmp10_ = real_x;
		_tmp11_ = real_y;
		_tmp12_ = number_add_real (_tmp10_, _tmp11_);
		_g_object_unref0 (real_z);
		real_z = _tmp12_;
		_tmp13_ = im_x;
		_tmp14_ = im_y;
		_tmp15_ = number_add_real (_tmp13_, _tmp14_);
		_g_object_unref0 (im_z);
		im_z = _tmp15_;
		_tmp16_ = real_z;
		_tmp17_ = im_z;
		_tmp18_ = number_new_complex (_tmp16_, _tmp17_);
		result = _tmp18_;
		_g_object_unref0 (im_y);
		_g_object_unref0 (real_y);
		_g_object_unref0 (im_x);
		_g_object_unref0 (real_x);
		_g_object_unref0 (im_z);
		_g_object_unref0 (real_z);
		return result;
	} else {
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		_tmp19_ = y;
		_tmp20_ = number_add_real (self, _tmp19_);
		result = _tmp20_;
		return result;
	}
}


Number* number_add_real (Number* self, Number* y) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* _tmp3_ = NULL;
	__mpfr_struct _tmp4_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp5_ = {0};
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	_tmp3_ = y;
	_tmp4_ = _tmp3_->priv->_re_num;
	mpfr_add (&tmp, &_tmp2_, &_tmp4_, MPFR_RNDN);
	_tmp5_ = tmp;
	_tmp6_ = number_new_mpfloat (&_tmp5_);
	z = _tmp6_;
	result = z;
	return result;
}


Number* number_subtract (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_invert_sign (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_add (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


Number* number_multiply (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_complex (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_complex (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		Number* t1 = NULL;
		Number* t2 = NULL;
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		_tmp4_ = number_real_component (self);
		real_x = _tmp4_;
		_tmp5_ = number_imaginary_component (self);
		im_x = _tmp5_;
		_tmp6_ = y;
		_tmp7_ = number_real_component (_tmp6_);
		real_y = _tmp7_;
		_tmp8_ = y;
		_tmp9_ = number_imaginary_component (_tmp8_);
		im_y = _tmp9_;
		_tmp10_ = real_x;
		_tmp11_ = real_y;
		_tmp12_ = number_multiply_real (_tmp10_, _tmp11_);
		_g_object_unref0 (t1);
		t1 = _tmp12_;
		_tmp13_ = im_x;
		_tmp14_ = im_y;
		_tmp15_ = number_multiply_real (_tmp13_, _tmp14_);
		_g_object_unref0 (t2);
		t2 = _tmp15_;
		_tmp16_ = t1;
		_tmp17_ = t2;
		_tmp18_ = number_subtract (_tmp16_, _tmp17_);
		_g_object_unref0 (real_z);
		real_z = _tmp18_;
		_tmp19_ = real_x;
		_tmp20_ = im_y;
		_tmp21_ = number_multiply_real (_tmp19_, _tmp20_);
		_g_object_unref0 (t1);
		t1 = _tmp21_;
		_tmp22_ = im_x;
		_tmp23_ = real_y;
		_tmp24_ = number_multiply_real (_tmp22_, _tmp23_);
		_g_object_unref0 (t2);
		t2 = _tmp24_;
		_tmp25_ = t1;
		_tmp26_ = t2;
		_tmp27_ = number_add (_tmp25_, _tmp26_);
		_g_object_unref0 (im_z);
		im_z = _tmp27_;
		_tmp28_ = real_z;
		_tmp29_ = im_z;
		_tmp30_ = number_new_complex (_tmp28_, _tmp29_);
		result = _tmp30_;
		_g_object_unref0 (im_y);
		_g_object_unref0 (real_y);
		_g_object_unref0 (im_x);
		_g_object_unref0 (real_x);
		_g_object_unref0 (im_z);
		_g_object_unref0 (real_z);
		_g_object_unref0 (t2);
		_g_object_unref0 (t1);
		return result;
	} else {
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		_tmp31_ = y;
		_tmp32_ = number_multiply_real (self, _tmp31_);
		result = _tmp32_;
		return result;
	}
}


Number* number_multiply_real (Number* self, Number* y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	Number* _tmp3_ = NULL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0);
	z = _tmp0_;
	_tmp1_ = z->priv->_re_num;
	tmp = _tmp1_;
	_tmp2_ = self->priv->_re_num;
	_tmp3_ = y;
	_tmp4_ = _tmp3_->priv->_re_num;
	mpfr_mul (&tmp, &_tmp2_, &_tmp4_, MPFR_RNDN);
	_tmp5_ = tmp;
	number_set_re_num (z, &_tmp5_);
	result = z;
	return result;
}


Number* number_multiply_integer (Number* self, gint64 y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	__mpfr_struct _tmp4_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0);
	z = _tmp0_;
	_tmp1_ = z->priv->_re_num;
	tmp = _tmp1_;
	_tmp2_ = self->priv->_re_num;
	_tmp3_ = y;
	mpfr_mul_si (&tmp, &_tmp2_, (glong) _tmp3_, MPFR_RNDN);
	_tmp4_ = tmp;
	number_set_re_num (z, &_tmp4_);
	result = z;
	return result;
}


Number* number_divide (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp52_ = 0UL;
	gulong _tmp53_ = 0UL;
	__mpfr_struct _tmp54_ = {0};
	Number* _tmp55_ = NULL;
	__mpfr_struct _tmp56_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp57_ = {0};
	Number* _tmp58_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_is_zero (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		_tmp2_ = number_get_error ();
		_tmp3_ = _tmp2_;
		_tmp4_ = _ ("Division by zero is undefined");
		number_set_error (_tmp4_);
		_tmp5_ = number_new_integer ((gint64) 0);
		result = _tmp5_;
		return result;
	}
	_tmp7_ = number_is_complex (self);
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = y;
		_tmp9_ = number_is_complex (_tmp8_);
		_tmp6_ = _tmp9_;
	}
	if (_tmp6_) {
		Number* a = NULL;
		Number* _tmp10_ = NULL;
		Number* b = NULL;
		Number* _tmp11_ = NULL;
		Number* c = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* d = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* tmp = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* tmp_2 = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* z_1 = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* z_2 = NULL;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* z = NULL;
		Number* _tmp49_ = NULL;
		Number* _tmp50_ = NULL;
		Number* _tmp51_ = NULL;
		_tmp10_ = number_real_component (self);
		a = _tmp10_;
		_tmp11_ = number_imaginary_component (self);
		b = _tmp11_;
		_tmp12_ = y;
		_tmp13_ = number_real_component (_tmp12_);
		c = _tmp13_;
		_tmp14_ = y;
		_tmp15_ = number_imaginary_component (_tmp14_);
		d = _tmp15_;
		_tmp16_ = a;
		_tmp17_ = c;
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = b;
		_tmp21_ = d;
		_tmp22_ = number_multiply (_tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = number_add (_tmp19_, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_g_object_unref0 (_tmp19_);
		tmp = _tmp25_;
		_tmp26_ = c;
		_tmp27_ = number_xpowy_integer (_tmp26_, (gint64) 2);
		_tmp28_ = _tmp27_;
		_tmp29_ = d;
		_tmp30_ = number_xpowy_integer (_tmp29_, (gint64) 2);
		_tmp31_ = _tmp30_;
		_tmp32_ = number_add (_tmp28_, _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_g_object_unref0 (_tmp28_);
		tmp_2 = _tmp33_;
		_tmp34_ = tmp;
		_tmp35_ = tmp_2;
		_tmp36_ = number_divide (_tmp34_, _tmp35_);
		z_1 = _tmp36_;
		_tmp37_ = b;
		_tmp38_ = c;
		_tmp39_ = number_multiply (_tmp37_, _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = a;
		_tmp42_ = d;
		_tmp43_ = number_multiply (_tmp41_, _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = number_subtract (_tmp40_, _tmp44_);
		_g_object_unref0 (tmp);
		tmp = _tmp45_;
		_g_object_unref0 (_tmp44_);
		_g_object_unref0 (_tmp40_);
		_tmp46_ = tmp;
		_tmp47_ = tmp_2;
		_tmp48_ = number_divide (_tmp46_, _tmp47_);
		z_2 = _tmp48_;
		_tmp49_ = z_1;
		_tmp50_ = z_2;
		_tmp51_ = number_new_complex (_tmp49_, _tmp50_);
		z = _tmp51_;
		result = z;
		_g_object_unref0 (z_2);
		_g_object_unref0 (z_1);
		_g_object_unref0 (tmp_2);
		_g_object_unref0 (tmp);
		_g_object_unref0 (d);
		_g_object_unref0 (c);
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	}
	_tmp52_ = number_get_precision ();
	_tmp53_ = _tmp52_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp53_);
	_tmp54_ = self->priv->_re_num;
	_tmp55_ = y;
	_tmp56_ = _tmp55_->priv->_re_num;
	mpfr_div (&tmp, &_tmp54_, &_tmp56_, MPFR_RNDN);
	_tmp57_ = tmp;
	_tmp58_ = number_new_mpfloat (&_tmp57_);
	z = _tmp58_;
	result = z;
	return result;
}


Number* number_divide_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_new_integer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_divide (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


Number* number_modulus_divide (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* t2 = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* z = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("Modulus division is only defined for integers");
		number_set_error (_tmp6_);
		_tmp7_ = number_new_integer ((gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = y;
	_tmp9_ = number_divide (self, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_floor (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	t1 = _tmp12_;
	_tmp13_ = t1;
	_tmp14_ = y;
	_tmp15_ = number_multiply (_tmp13_, _tmp14_);
	t2 = _tmp15_;
	_tmp16_ = t2;
	_tmp17_ = number_subtract (self, _tmp16_);
	z = _tmp17_;
	_tmp18_ = number_new_integer ((gint64) 0);
	_g_object_unref0 (t1);
	t1 = _tmp18_;
	_tmp21_ = y;
	_tmp22_ = t1;
	_tmp23_ = number_compare (_tmp21_, _tmp22_);
	if (_tmp23_ < 0) {
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		_tmp24_ = z;
		_tmp25_ = t1;
		_tmp26_ = number_compare (_tmp24_, _tmp25_);
		_tmp20_ = _tmp26_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		_tmp28_ = y;
		_tmp29_ = t1;
		_tmp30_ = number_compare (_tmp28_, _tmp29_);
		if (_tmp30_ > 0) {
			Number* _tmp31_ = NULL;
			Number* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			_tmp31_ = z;
			_tmp32_ = t1;
			_tmp33_ = number_compare (_tmp31_, _tmp32_);
			_tmp27_ = _tmp33_ < 0;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp19_ = _tmp27_;
	}
	if (_tmp19_) {
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		_tmp34_ = z;
		_tmp35_ = y;
		_tmp36_ = number_add (_tmp34_, _tmp35_);
		_g_object_unref0 (z);
		z = _tmp36_;
	}
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}


Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod) {
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* exp_value = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* ans = NULL;
	Number* _tmp7_ = NULL;
	Number* two = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	Number* _tmp36_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (mod != NULL, NULL);
	_tmp0_ = number_copy (self);
	base_value = _tmp0_;
	_tmp1_ = exp;
	_tmp2_ = number_is_negative (_tmp1_);
	if (_tmp2_) {
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = base_value;
		_tmp4_ = number_reciprocal (_tmp3_);
		_g_object_unref0 (base_value);
		base_value = _tmp4_;
	}
	_tmp5_ = exp;
	_tmp6_ = number_abs (_tmp5_);
	exp_value = _tmp6_;
	_tmp7_ = number_new_integer ((gint64) 1);
	ans = _tmp7_;
	_tmp8_ = number_new_integer ((gint64) 2);
	two = _tmp8_;
	while (TRUE) {
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean is_even = FALSE;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		_tmp9_ = exp_value;
		_tmp10_ = number_is_zero (_tmp9_);
		if (!(!_tmp10_)) {
			break;
		}
		_tmp11_ = exp_value;
		_tmp12_ = two;
		_tmp13_ = number_modulus_divide (_tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = number_is_zero (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		is_even = _tmp16_;
		_tmp17_ = is_even;
		if (!_tmp17_) {
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			Number* _tmp20_ = NULL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			_tmp18_ = ans;
			_tmp19_ = base_value;
			_tmp20_ = number_multiply (_tmp18_, _tmp19_);
			_g_object_unref0 (ans);
			ans = _tmp20_;
			_tmp21_ = ans;
			_tmp22_ = mod;
			_tmp23_ = number_modulus_divide (_tmp21_, _tmp22_);
			_g_object_unref0 (ans);
			ans = _tmp23_;
		}
		_tmp24_ = base_value;
		_tmp25_ = base_value;
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
		_g_object_unref0 (base_value);
		base_value = _tmp26_;
		_tmp27_ = base_value;
		_tmp28_ = mod;
		_tmp29_ = number_modulus_divide (_tmp27_, _tmp28_);
		_g_object_unref0 (base_value);
		base_value = _tmp29_;
		_tmp30_ = exp_value;
		_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
		_tmp32_ = _tmp31_;
		_tmp33_ = number_floor (_tmp32_);
		_g_object_unref0 (exp_value);
		exp_value = _tmp33_;
		_g_object_unref0 (_tmp32_);
	}
	_tmp34_ = ans;
	_tmp35_ = mod;
	_tmp36_ = number_modulus_divide (_tmp34_, _tmp35_);
	result = _tmp36_;
	_g_object_unref0 (two);
	_g_object_unref0 (ans);
	_g_object_unref0 (exp_value);
	_g_object_unref0 (base_value);
	return result;
}


Number* number_sin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		_tmp1_ = number_real_component (self);
		x_real = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		x_im = _tmp2_;
		_tmp3_ = x_real;
		_tmp4_ = unit;
		_tmp5_ = number_sin_real (_tmp3_, _tmp4_);
		z_real = _tmp5_;
		_tmp6_ = x_im;
		_tmp7_ = number_cosh (_tmp6_);
		t = _tmp7_;
		_tmp8_ = z_real;
		_tmp9_ = t;
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
		_g_object_unref0 (z_real);
		z_real = _tmp10_;
		_tmp11_ = x_real;
		_tmp12_ = unit;
		_tmp13_ = number_cos_real (_tmp11_, _tmp12_);
		z_im = _tmp13_;
		_tmp14_ = x_im;
		_tmp15_ = number_sinh (_tmp14_);
		_g_object_unref0 (t);
		t = _tmp15_;
		_tmp16_ = z_im;
		_tmp17_ = t;
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
		_g_object_unref0 (z_im);
		z_im = _tmp18_;
		_tmp19_ = z_real;
		_tmp20_ = z_im;
		_tmp21_ = number_new_complex (_tmp19_, _tmp20_);
		result = _tmp21_;
		_g_object_unref0 (z_im);
		_g_object_unref0 (t);
		_g_object_unref0 (z_real);
		_g_object_unref0 (x_im);
		_g_object_unref0 (x_real);
		return result;
	} else {
		AngleUnit _tmp22_ = 0;
		Number* _tmp23_ = NULL;
		_tmp22_ = unit;
		_tmp23_ = number_sin_real (self, _tmp22_);
		result = _tmp23_;
		return result;
	}
}


Number* number_cos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		_tmp1_ = number_real_component (self);
		x_real = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		x_im = _tmp2_;
		_tmp3_ = x_real;
		_tmp4_ = unit;
		_tmp5_ = number_cos_real (_tmp3_, _tmp4_);
		z_real = _tmp5_;
		_tmp6_ = x_im;
		_tmp7_ = number_cosh (_tmp6_);
		t = _tmp7_;
		_tmp8_ = z_real;
		_tmp9_ = t;
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
		_g_object_unref0 (z_real);
		z_real = _tmp10_;
		_tmp11_ = x_real;
		_tmp12_ = unit;
		_tmp13_ = number_sin_real (_tmp11_, _tmp12_);
		z_im = _tmp13_;
		_tmp14_ = x_im;
		_tmp15_ = number_sinh (_tmp14_);
		_g_object_unref0 (t);
		t = _tmp15_;
		_tmp16_ = z_im;
		_tmp17_ = t;
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
		_g_object_unref0 (z_im);
		z_im = _tmp18_;
		_tmp19_ = z_im;
		_tmp20_ = number_invert_sign (_tmp19_);
		_g_object_unref0 (z_im);
		z_im = _tmp20_;
		_tmp21_ = z_real;
		_tmp22_ = z_im;
		_tmp23_ = number_new_complex (_tmp21_, _tmp22_);
		result = _tmp23_;
		_g_object_unref0 (z_im);
		_g_object_unref0 (t);
		_g_object_unref0 (z_real);
		_g_object_unref0 (x_im);
		_g_object_unref0 (x_real);
		return result;
	} else {
		AngleUnit _tmp24_ = 0;
		Number* _tmp25_ = NULL;
		_tmp24_ = unit;
		_tmp25_ = number_cos_real (self, _tmp24_);
		result = _tmp25_;
		return result;
	}
}


Number* number_tan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* check = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp19_ = 0UL;
	gulong _tmp20_ = 0UL;
	Number* _tmp21_ = NULL;
	__mpfr_struct _tmp22_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp23_ = {0};
	Number* _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	_tmp1_ = number_to_radians (self, _tmp0_);
	x_radians = _tmp1_;
	_tmp2_ = x_radians;
	_tmp3_ = number_new_pi ();
	_tmp4_ = _tmp3_;
	_tmp5_ = number_divide_integer (_tmp4_, (gint64) 2);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_subtract (_tmp2_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = number_new_pi ();
	_tmp10_ = _tmp9_;
	_tmp11_ = number_divide (_tmp8_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	check = _tmp12_;
	_tmp13_ = check;
	_tmp14_ = number_is_integer (_tmp13_);
	if (_tmp14_) {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		_tmp15_ = number_get_error ();
		_tmp16_ = _tmp15_;
		_tmp17_ = _ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)");
		number_set_error (_tmp17_);
		_tmp18_ = number_new_integer ((gint64) 0);
		result = _tmp18_;
		_g_object_unref0 (check);
		_g_object_unref0 (x_radians);
		return result;
	}
	_tmp19_ = number_get_precision ();
	_tmp20_ = _tmp19_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp20_);
	_tmp21_ = x_radians;
	_tmp22_ = _tmp21_->priv->_re_num;
	mpfr_tan (&tmp, &_tmp22_, MPFR_RNDN);
	_tmp23_ = tmp;
	_tmp24_ = number_new_mpfloat (&_tmp23_);
	z = _tmp24_;
	result = z;
	_g_object_unref0 (check);
	_g_object_unref0 (x_radians);
	return result;
}


Number* number_asin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	AngleUnit _tmp18_ = 0;
	Number* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp5_ = number_new_integer ((gint64) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ < 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		_tmp8_ = number_get_error ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _ ("Inverse sine is undefined for values outside [-1, 1]");
		number_set_error (_tmp10_);
		_tmp11_ = number_new_integer ((gint64) 0);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = number_get_precision ();
	_tmp13_ = _tmp12_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
	_tmp14_ = self->priv->_re_num;
	mpfr_asin (&tmp, &_tmp14_, MPFR_RNDN);
	_tmp15_ = tmp;
	_tmp16_ = number_new_mpfloat (&_tmp15_);
	z = _tmp16_;
	_tmp17_ = z;
	_tmp18_ = unit;
	_tmp19_ = number_from_radians (_tmp17_, _tmp18_);
	result = _tmp19_;
	_g_object_unref0 (z);
	return result;
}


Number* number_acos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	AngleUnit _tmp18_ = 0;
	Number* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp5_ = number_new_integer ((gint64) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ < 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		_tmp8_ = number_get_error ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _ ("Inverse cosine is undefined for values outside [-1, 1]");
		number_set_error (_tmp10_);
		_tmp11_ = number_new_integer ((gint64) 0);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = number_get_precision ();
	_tmp13_ = _tmp12_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
	_tmp14_ = self->priv->_re_num;
	mpfr_acos (&tmp, &_tmp14_, MPFR_RNDN);
	_tmp15_ = tmp;
	_tmp16_ = number_new_mpfloat (&_tmp15_);
	z = _tmp16_;
	_tmp17_ = z;
	_tmp18_ = unit;
	_tmp19_ = number_from_radians (_tmp17_, _tmp18_);
	result = _tmp19_;
	_g_object_unref0 (z);
	return result;
}


Number* number_atan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	AngleUnit _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_atan (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	_tmp5_ = unit;
	_tmp6_ = number_from_radians (z, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (z);
	return result;
}


Number* number_sinh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_sinh (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_cosh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_cosh (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_tanh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_tanh (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_asinh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_asinh (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


Number* number_acosh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	__mpfr_struct tmp = {0};
	gulong _tmp7_ = 0UL;
	gulong _tmp8_ = 0UL;
	__mpfr_struct _tmp9_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp10_ = {0};
	Number* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = number_compare (self, _tmp1_);
	if (_tmp2_ < 0) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		_tmp3_ = number_get_error ();
		_tmp4_ = _tmp3_;
		_tmp5_ = _ ("Inverse hyperbolic cosine is undefined for values less than one");
		number_set_error (_tmp5_);
		_tmp6_ = number_new_integer ((gint64) 0);
		result = _tmp6_;
		_g_object_unref0 (t);
		return result;
	}
	_tmp7_ = number_get_precision ();
	_tmp8_ = _tmp7_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp8_);
	_tmp9_ = self->priv->_re_num;
	mpfr_acosh (&tmp, &_tmp9_, MPFR_RNDN);
	_tmp10_ = tmp;
	_tmp11_ = number_new_mpfloat (&_tmp10_);
	z = _tmp11_;
	result = z;
	_g_object_unref0 (t);
	return result;
}


Number* number_atanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ >= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp5_ = number_new_integer ((gint64) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ <= 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		_tmp8_ = number_get_error ();
		_tmp9_ = _tmp8_;
		_tmp10_ = _ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]");
		number_set_error (_tmp10_);
		_tmp11_ = number_new_integer ((gint64) 0);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = number_get_precision ();
	_tmp13_ = _tmp12_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
	_tmp14_ = self->priv->_re_num;
	mpfr_atanh (&tmp, &_tmp14_, MPFR_RNDN);
	_tmp15_ = tmp;
	_tmp16_ = number_new_mpfloat (&_tmp15_);
	z = _tmp16_;
	result = z;
	return result;
}


static gint __lambda4_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ & _tmp1_;
	return result;
}


static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
	return result;
}


Number* number_and (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("Boolean AND is only defined for positive integers");
		number_set_error (_tmp6_);
	}
	_tmp7_ = y;
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda4__bitwise_func, self, 0);
	result = _tmp8_;
	return result;
}


static gint __lambda5_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ | _tmp1_;
	return result;
}


static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
	return result;
}


Number* number_or (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("Boolean OR is only defined for positive integers");
		number_set_error (_tmp6_);
	}
	_tmp7_ = y;
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda5__bitwise_func, self, 0);
	result = _tmp8_;
	return result;
}


static gint __lambda6_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ ^ _tmp1_;
	return result;
}


static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
	return result;
}


Number* number_xor (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = number_get_error ();
		_tmp5_ = _tmp4_;
		_tmp6_ = _ ("Boolean XOR is only defined for positive integers");
		number_set_error (_tmp6_);
	}
	_tmp7_ = y;
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda6__bitwise_func, self, 0);
	result = _tmp8_;
	return result;
}


static gint __lambda7_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = v1;
	result = _tmp0_ ^ 0xF;
	return result;
}


static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
	return result;
}


Number* number_not (Number* self, gint wordlen) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_positive_integer (self);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Boolean NOT is only defined for positive integers");
		number_set_error (_tmp3_);
	}
	_tmp4_ = number_new_integer ((gint64) 0);
	_tmp5_ = _tmp4_;
	_tmp6_ = wordlen;
	_tmp7_ = number_bitwise (self, _tmp5_, ___lambda7__bitwise_func, self, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	result = _tmp8_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


Number* number_mask (Number* self, Number* x, gint wordlen) {
	Number* result = NULL;
	gchar* text = NULL;
	Number* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint offset = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = x;
	_tmp1_ = number_to_hex_string (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = wordlen;
	offset = _tmp5_ / 4;
	_tmp7_ = len;
	_tmp8_ = offset;
	if (_tmp7_ > _tmp8_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = len;
		_tmp10_ = offset;
		_tmp6_ = ((gint) _tmp9_) - _tmp10_;
	} else {
		_tmp6_ = 0;
	}
	offset = _tmp6_;
	_tmp11_ = text;
	_tmp12_ = offset;
	_tmp13_ = string_substring (_tmp11_, (glong) _tmp12_, (glong) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = mp_set_from_string (_tmp14_, 16);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	result = _tmp16_;
	_g_free0 (text);
	return result;
}


Number* number_shift (Number* self, gint count) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_integer (self);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Shift is only possible on integer values");
		number_set_error (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = count;
	if (_tmp5_ >= 0) {
		gint multiplier = 0;
		gint _tmp11_ = 0;
		Number* _tmp12_ = NULL;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = count;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = multiplier;
					multiplier = _tmp10_ * 2;
				}
			}
		}
		_tmp11_ = multiplier;
		_tmp12_ = number_multiply_integer (self, (gint64) _tmp11_);
		result = _tmp12_;
		return result;
	} else {
		gint multiplier = 0;
		gint _tmp18_ = 0;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					if (!_tmp13_) {
						gint _tmp14_ = 0;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = count;
					if (!(_tmp15_ < (-_tmp16_))) {
						break;
					}
					_tmp17_ = multiplier;
					multiplier = _tmp17_ * 2;
				}
			}
		}
		_tmp18_ = multiplier;
		_tmp19_ = number_divide_integer (self, (gint64) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = number_floor (_tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		result = _tmp22_;
		return result;
	}
}


static gint __lambda8_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ ^ _tmp1_;
	return result;
}


static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
	return result;
}


Number* number_ones_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = wordlen;
	_tmp3_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = wordlen;
	_tmp6_ = number_not (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


Number* number_twos_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = wordlen;
	_tmp1_ = number_ones_complement (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_new_integer ((gint64) 1);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_add (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* number_factorize (Number* self) {
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	guint64 num = 0ULL;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	guint64 _tmp13_ = 0ULL;
	Number* int_max = NULL;
	guint64 _tmp14_ = 0ULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* divisor = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp37_ = NULL;
	Number* root = NULL;
	Number* _tmp38_ = NULL;
	Number* _tmp39_ = NULL;
	Number* _tmp60_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp67_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	_tmp0_ = number_abs (self);
	value = _tmp0_;
	_tmp1_ = value;
	_tmp2_ = number_is_zero (_tmp1_);
	if (_tmp2_) {
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = value;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		factors = g_list_append (factors, _tmp4_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp5_ = value;
	_tmp6_ = number_new_integer ((gint64) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_equals (_tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	if (_tmp9_) {
		Number* _tmp10_ = NULL;
		_tmp10_ = _g_object_ref0 (self);
		factors = g_list_append (factors, _tmp10_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	num = (guint64) 1;
	_tmp11_ = num;
	num = _tmp11_ << 63;
	_tmp12_ = num;
	_tmp13_ = num;
	num = _tmp12_ + (_tmp13_ - 1);
	_tmp14_ = num;
	_tmp15_ = number_new_unsigned_integer (_tmp14_);
	int_max = _tmp15_;
	_tmp16_ = value;
	_tmp17_ = int_max;
	_tmp18_ = number_compare (_tmp16_, _tmp17_);
	if (_tmp18_ <= 0) {
		GList* factors_int64 = NULL;
		Number* _tmp19_ = NULL;
		guint64 _tmp20_ = 0ULL;
		GList* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp19_ = value;
		_tmp20_ = number_to_unsigned_integer (_tmp19_);
		_tmp21_ = number_factorize_uint64 (self, _tmp20_);
		factors_int64 = _tmp21_;
		_tmp22_ = number_is_negative (self);
		if (_tmp22_) {
			GList* _tmp23_ = NULL;
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			Number* _tmp26_ = NULL;
			_tmp23_ = factors_int64;
			_tmp24_ = factors_int64;
			_tmp25_ = _tmp24_->data;
			_tmp26_ = number_invert_sign ((Number*) _tmp25_);
			_g_object_unref0 (_tmp23_->data);
			_tmp23_->data = _tmp26_;
		}
		result = factors_int64;
		_g_object_unref0 (int_max);
		_g_object_unref0 (value);
		__g_list_free__g_object_unref0_0 (factors);
		return result;
	}
	_tmp27_ = number_new_integer ((gint64) 2);
	divisor = _tmp27_;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		_tmp28_ = value;
		_tmp29_ = divisor;
		_tmp30_ = number_divide (_tmp28_, _tmp29_);
		tmp = _tmp30_;
		_tmp31_ = tmp;
		_tmp32_ = number_is_integer (_tmp31_);
		if (_tmp32_) {
			Number* _tmp33_ = NULL;
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
			_tmp33_ = tmp;
			_tmp34_ = _g_object_ref0 (_tmp33_);
			_g_object_unref0 (value);
			value = _tmp34_;
			_tmp35_ = divisor;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			factors = g_list_append (factors, _tmp36_);
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp37_ = number_new_integer ((gint64) 3);
	_g_object_unref0 (divisor);
	divisor = _tmp37_;
	_tmp38_ = value;
	_tmp39_ = number_sqrt (_tmp38_);
	root = _tmp39_;
	while (TRUE) {
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		Number* tmp = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
		_tmp40_ = divisor;
		_tmp41_ = root;
		_tmp42_ = number_compare (_tmp40_, _tmp41_);
		if (!(_tmp42_ <= 0)) {
			break;
		}
		_tmp43_ = value;
		_tmp44_ = divisor;
		_tmp45_ = number_divide (_tmp43_, _tmp44_);
		tmp = _tmp45_;
		_tmp46_ = tmp;
		_tmp47_ = number_is_integer (_tmp46_);
		if (_tmp47_) {
			Number* _tmp48_ = NULL;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
			_tmp48_ = tmp;
			_tmp49_ = _g_object_ref0 (_tmp48_);
			_g_object_unref0 (value);
			value = _tmp49_;
			_tmp50_ = value;
			_tmp51_ = number_sqrt (_tmp50_);
			_g_object_unref0 (root);
			root = _tmp51_;
			_tmp52_ = divisor;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			factors = g_list_append (factors, _tmp53_);
		} else {
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
			_tmp54_ = divisor;
			_tmp55_ = number_new_integer ((gint64) 2);
			_tmp56_ = _tmp55_;
			_tmp57_ = number_add (_tmp54_, _tmp56_);
			_g_object_unref0 (tmp);
			tmp = _tmp57_;
			_g_object_unref0 (_tmp56_);
			_tmp58_ = tmp;
			_tmp59_ = _g_object_ref0 (_tmp58_);
			_g_object_unref0 (divisor);
			divisor = _tmp59_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp60_ = value;
	_tmp61_ = number_new_integer ((gint64) 1);
	_tmp62_ = _tmp61_;
	_tmp63_ = number_compare (_tmp60_, _tmp62_);
	_tmp64_ = _tmp63_ > 0;
	_g_object_unref0 (_tmp62_);
	if (_tmp64_) {
		Number* _tmp65_ = NULL;
		Number* _tmp66_ = NULL;
		_tmp65_ = value;
		_tmp66_ = _g_object_ref0 (_tmp65_);
		factors = g_list_append (factors, _tmp66_);
	}
	_tmp67_ = number_is_negative (self);
	if (_tmp67_) {
		GList* _tmp68_ = NULL;
		GList* _tmp69_ = NULL;
		gconstpointer _tmp70_ = NULL;
		Number* _tmp71_ = NULL;
		_tmp68_ = factors;
		_tmp69_ = factors;
		_tmp70_ = _tmp69_->data;
		_tmp71_ = number_invert_sign ((Number*) _tmp70_);
		_g_object_unref0 (_tmp68_->data);
		_tmp68_->data = _tmp71_;
	}
	result = factors;
	_g_object_unref0 (root);
	_g_object_unref0 (divisor);
	_g_object_unref0 (int_max);
	_g_object_unref0 (value);
	return result;
}


GList* number_factorize_uint64 (Number* self, guint64 n) {
	GList* result = NULL;
	GList* factors = NULL;
	guint64 _tmp14_ = 0ULL;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	while (TRUE) {
		guint64 _tmp0_ = 0ULL;
		guint64 _tmp1_ = 0ULL;
		Number* _tmp2_ = NULL;
		_tmp0_ = n;
		if (!((_tmp0_ % 2) == ((guint64) 0))) {
			break;
		}
		_tmp1_ = n;
		n = _tmp1_ / 2;
		_tmp2_ = number_new_unsigned_integer ((guint64) 2);
		factors = g_list_append (factors, _tmp2_);
	}
	{
		guint64 divisor = 0ULL;
		divisor = (guint64) 3;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint64 _tmp5_ = 0ULL;
				guint64 _tmp6_ = 0ULL;
				guint64 _tmp7_ = 0ULL;
				if (!_tmp3_) {
					guint64 _tmp4_ = 0ULL;
					_tmp4_ = divisor;
					divisor = _tmp4_ + 2;
				}
				_tmp3_ = FALSE;
				_tmp5_ = divisor;
				_tmp6_ = n;
				_tmp7_ = divisor;
				if (!(_tmp5_ <= (_tmp6_ / _tmp7_))) {
					break;
				}
				while (TRUE) {
					guint64 _tmp8_ = 0ULL;
					guint64 _tmp9_ = 0ULL;
					guint64 _tmp10_ = 0ULL;
					guint64 _tmp11_ = 0ULL;
					guint64 _tmp12_ = 0ULL;
					Number* _tmp13_ = NULL;
					_tmp8_ = n;
					_tmp9_ = divisor;
					if (!((_tmp8_ % _tmp9_) == ((guint64) 0))) {
						break;
					}
					_tmp10_ = n;
					_tmp11_ = divisor;
					n = _tmp10_ / _tmp11_;
					_tmp12_ = divisor;
					_tmp13_ = number_new_unsigned_integer (_tmp12_);
					factors = g_list_append (factors, _tmp13_);
				}
			}
		}
	}
	_tmp14_ = n;
	if (_tmp14_ > ((guint64) 1)) {
		guint64 _tmp15_ = 0ULL;
		Number* _tmp16_ = NULL;
		_tmp15_ = n;
		_tmp16_ = number_new_unsigned_integer (_tmp15_);
		factors = g_list_append (factors, _tmp16_);
	}
	result = factors;
	return result;
}


static Number* number_copy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp1_ = 0UL;
	gulong _tmp2_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct _tmp6_ = {0};
	__mpfr_struct _tmp7_ = {0};
	__mpfr_struct _tmp8_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp2_);
	_tmp3_ = number_get_precision ();
	_tmp4_ = _tmp3_;
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp4_);
	_tmp5_ = self->priv->_re_num;
	mpfr_set (&tmp, &_tmp5_, MPFR_RNDN);
	_tmp6_ = self->priv->_im_num;
	mpfr_set (&tmp2, &_tmp6_, MPFR_RNDN);
	_tmp7_ = tmp;
	number_set_re_num (z, &_tmp7_);
	_tmp8_ = tmp2;
	number_set_im_num (z, &_tmp8_);
	result = z;
	return result;
}


static Number* number_epowy_real (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	__mpfr_struct _tmp3_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z->priv->_re_num;
	tmp = _tmp1_;
	_tmp2_ = self->priv->_re_num;
	mpfr_exp (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	number_set_re_num (z, &_tmp3_);
	result = z;
	return result;
}


static Number* number_root_real (Number* self, gint64 n) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	__mpfr_struct _tmp4_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z->priv->_re_num;
	tmp = _tmp1_;
	_tmp2_ = self->priv->_re_num;
	_tmp3_ = n;
	mpfr_root (&tmp, &_tmp2_, (gulong) _tmp3_, MPFR_RNDN);
	_tmp4_ = tmp;
	number_set_re_num (z, &_tmp4_);
	result = z;
	return result;
}


static Number* number_ln_real (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
	_tmp2_ = self->priv->_re_num;
	mpfr_log (&tmp, &_tmp2_, MPFR_RNDN);
	_tmp3_ = tmp;
	_tmp4_ = number_new_mpfloat (&_tmp3_);
	z = _tmp4_;
	result = z;
	return result;
}


static Number* number_reciprocal_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp5_ = 0UL;
	gulong _tmp6_ = 0UL;
	__mpfr_struct _tmp7_ = {0};
	__mpfr_struct _tmp8_ = {0};
	Number* z = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	__mpfr_struct _tmp11_ = {0};
	Number* _tmp12_ = NULL;
	__mpfr_struct _tmp13_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Reciprocal of zero is undefined");
		number_set_error (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = number_get_precision ();
	_tmp6_ = _tmp5_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp6_);
	mpfr_set_ui (&tmp, (gulong) 1, MPFR_RNDN);
	_tmp7_ = tmp;
	_tmp8_ = self->priv->_re_num;
	mpfr_div (&tmp, &_tmp7_, &_tmp8_, MPFR_RNDN);
	_tmp9_ = number_copy (self);
	z = _tmp9_;
	_tmp10_ = z;
	_tmp11_ = _tmp10_->priv->_re_num;
	mpfr_clear (&_tmp11_);
	_tmp12_ = z;
	_tmp13_ = tmp;
	number_set_re_num (_tmp12_, &_tmp13_);
	result = z;
	return result;
}


static Number* number_from_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	switch (_tmp0_) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			Number* _tmp1_ = NULL;
			_tmp1_ = _g_object_ref0 (self);
			result = _tmp1_;
			return result;
		}
		case ANGLE_UNIT_DEGREES:
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			_tmp2_ = number_multiply_integer (self, (gint64) 180);
			_tmp3_ = _tmp2_;
			_tmp4_ = number_new_pi ();
			_tmp5_ = _tmp4_;
			_tmp6_ = number_divide (_tmp3_, _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp3_);
			result = _tmp7_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
			_tmp8_ = number_multiply_integer (self, (gint64) 200);
			_tmp9_ = _tmp8_;
			_tmp10_ = number_new_pi ();
			_tmp11_ = _tmp10_;
			_tmp12_ = number_divide (_tmp9_, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
			result = _tmp13_;
			return result;
		}
	}
}


static Number* number_to_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	switch (_tmp0_) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			Number* _tmp1_ = NULL;
			_tmp1_ = _g_object_ref0 (self);
			result = _tmp1_;
			return result;
		}
		case ANGLE_UNIT_DEGREES:
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			_tmp2_ = number_new_pi ();
			_tmp3_ = _tmp2_;
			_tmp4_ = number_multiply (self, _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = number_divide_integer (_tmp5_, (gint64) 180);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp3_);
			result = _tmp7_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
			_tmp8_ = number_new_pi ();
			_tmp9_ = _tmp8_;
			_tmp10_ = number_multiply (self, _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 200);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
			result = _tmp13_;
			return result;
		}
	}
}


static Number* number_sin_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* z = NULL;
	Number* _tmp2_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	_tmp1_ = number_to_radians (self, _tmp0_);
	x_radians = _tmp1_;
	_tmp2_ = number_new_integer ((gint64) 0);
	z = _tmp2_;
	_tmp3_ = z->priv->_re_num;
	tmp = _tmp3_;
	_tmp4_ = x_radians->priv->_re_num;
	mpfr_sin (&tmp, &_tmp4_, MPFR_RNDN);
	_tmp5_ = tmp;
	number_set_re_num (z, &_tmp5_);
	result = z;
	_g_object_unref0 (x_radians);
	return result;
}


static Number* number_cos_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp5_ = {0};
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	_tmp1_ = number_to_radians (self, _tmp0_);
	x_radians = _tmp1_;
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp3_);
	_tmp4_ = x_radians->priv->_re_num;
	mpfr_cos (&tmp, &_tmp4_, MPFR_RNDN);
	_tmp5_ = tmp;
	_tmp6_ = number_new_mpfloat (&_tmp5_);
	z = _tmp6_;
	result = z;
	_g_object_unref0 (x_radians);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen) {
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_ = NULL;
	gchar* text2 = NULL;
	Number* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint offset1 = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint offset2 = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint offset_out = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gchar* text_out = NULL;
	gint _tmp26_ = 0;
	gchar* _tmp27_ = NULL;
	gint text_out_length1 = 0;
	gint _text_out_size_ = 0;
	gchar* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	Number* _tmp55_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_to_hex_string (self);
	text1 = _tmp0_;
	_tmp1_ = y;
	_tmp2_ = number_to_hex_string (_tmp1_);
	text2 = _tmp2_;
	_tmp3_ = text1;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	offset1 = _tmp5_ - 1;
	_tmp6_ = text2;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	offset2 = _tmp8_ - 1;
	_tmp9_ = wordlen;
	offset_out = (_tmp9_ / 4) - 1;
	_tmp10_ = offset_out;
	if (_tmp10_ <= 0) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp12_ = offset1;
		_tmp13_ = offset2;
		if (_tmp12_ > _tmp13_) {
			gint _tmp14_ = 0;
			_tmp14_ = offset1;
			_tmp11_ = _tmp14_;
		} else {
			gint _tmp15_ = 0;
			_tmp15_ = offset2;
			_tmp11_ = _tmp15_;
		}
		offset_out = _tmp11_;
	}
	_tmp17_ = offset_out;
	if (_tmp17_ > 0) {
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp19_ = offset_out;
		_tmp20_ = offset1;
		if (_tmp19_ < _tmp20_) {
			_tmp18_ = TRUE;
		} else {
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			_tmp21_ = offset_out;
			_tmp22_ = offset2;
			_tmp18_ = _tmp21_ < _tmp22_;
		}
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		_tmp23_ = number_get_error ();
		_tmp24_ = _tmp23_;
		number_set_error ("Overflow. Try a bigger word size");
		_tmp25_ = number_new_integer ((gint64) 0);
		result = _tmp25_;
		_g_free0 (text2);
		_g_free0 (text1);
		return result;
	}
	_tmp26_ = offset_out;
	_tmp27_ = g_new0 (gchar, _tmp26_ + 2);
	text_out = _tmp27_;
	text_out_length1 = _tmp26_ + 2;
	_text_out_size_ = text_out_length1;
	{
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gchar _tmp30_ = '\0';
		gboolean _tmp31_ = FALSE;
		_tmp28_ = text_out;
		_tmp28__length1 = text_out_length1;
		_tmp29_ = offset_out;
		_tmp28_[_tmp29_ + 1] = '\0';
		_tmp30_ = _tmp28_[_tmp29_ + 1];
		_tmp31_ = TRUE;
		while (TRUE) {
			gint _tmp33_ = 0;
			gint v1 = 0;
			gint v2 = 0;
			static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			gint _tmp34_ = 0;
			gint _tmp40_ = 0;
			gchar* _tmp46_ = NULL;
			gint _tmp46__length1 = 0;
			gint _tmp47_ = 0;
			BitwiseFunc _tmp48_ = NULL;
			void* _tmp48__target = NULL;
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gchar _tmp52_ = '\0';
			gchar _tmp53_ = '\0';
			if (!_tmp31_) {
				gint _tmp32_ = 0;
				_tmp32_ = offset_out;
				offset_out = _tmp32_ - 1;
			}
			_tmp31_ = FALSE;
			_tmp33_ = offset_out;
			if (!(_tmp33_ >= 0)) {
				break;
			}
			v1 = 0;
			v2 = 0;
			_tmp34_ = offset1;
			if (_tmp34_ >= 0) {
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				_tmp35_ = text1;
				_tmp36_ = offset1;
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
				_tmp38_ = number_hex_to_int (self, _tmp37_);
				v1 = _tmp38_;
				_tmp39_ = offset1;
				offset1 = _tmp39_ - 1;
			}
			_tmp40_ = offset2;
			if (_tmp40_ >= 0) {
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gchar _tmp43_ = '\0';
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				_tmp41_ = text2;
				_tmp42_ = offset2;
				_tmp43_ = string_get (_tmp41_, (glong) _tmp42_);
				_tmp44_ = number_hex_to_int (self, _tmp43_);
				v2 = _tmp44_;
				_tmp45_ = offset2;
				offset2 = _tmp45_ - 1;
			}
			_tmp46_ = text_out;
			_tmp46__length1 = text_out_length1;
			_tmp47_ = offset_out;
			_tmp48_ = bitwise_operator;
			_tmp48__target = bitwise_operator_target;
			_tmp49_ = v1;
			_tmp50_ = v2;
			_tmp51_ = _tmp48_ (_tmp49_, _tmp50_, _tmp48__target);
			_tmp52_ = digits[_tmp51_];
			_tmp46_[_tmp47_] = _tmp52_;
			_tmp53_ = _tmp46_[_tmp47_];
		}
	}
	_tmp54_ = text_out;
	_tmp54__length1 = text_out_length1;
	_tmp55_ = mp_set_from_string ((const gchar*) _tmp54_, 16);
	result = _tmp55_;
	text_out = (g_free (text_out), NULL);
	_g_free0 (text2);
	_g_free0 (text1);
	return result;
}


static gint number_hex_to_int (Number* self, gchar digit) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp4_ = FALSE;
	gchar _tmp5_ = '\0';
	gboolean _tmp8_ = FALSE;
	gchar _tmp9_ = '\0';
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = digit;
	if (_tmp1_ >= '0') {
		gchar _tmp2_ = '\0';
		_tmp2_ = digit;
		_tmp0_ = _tmp2_ <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar _tmp3_ = '\0';
		_tmp3_ = digit;
		result = (gint) (_tmp3_ - '0');
		return result;
	}
	_tmp5_ = digit;
	if (_tmp5_ >= 'A') {
		gchar _tmp6_ = '\0';
		_tmp6_ = digit;
		_tmp4_ = _tmp6_ <= 'F';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar _tmp7_ = '\0';
		_tmp7_ = digit;
		result = (_tmp7_ - 'A') + 10;
		return result;
	}
	_tmp9_ = digit;
	if (_tmp9_ >= 'a') {
		gchar _tmp10_ = '\0';
		_tmp10_ = digit;
		_tmp8_ = _tmp10_ <= 'f';
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar _tmp11_ = '\0';
		_tmp11_ = digit;
		result = (_tmp11_ - 'a') + 10;
		return result;
	}
	result = 0;
	return result;
}


static gchar* number_to_hex_string (Number* self) {
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
	serializer = _tmp0_;
	_tmp1_ = serializer_to_string (serializer, self);
	result = _tmp1_;
	_g_object_unref0 (serializer);
	return result;
}


Number* number_construct (GType object_type) {
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	return self;
}


Number* number_new (void) {
	return number_construct (TYPE_NUMBER);
}


static void number_get_re_num (Number* self, __mpfr_struct* result) {
	__mpfr_struct _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_re_num;
	*result = _tmp0_;
	return;
}


static void number_set_re_num (Number* self, __mpfr_struct* value) {
	__mpfr_struct _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_re_num = _tmp0_;
}


static void number_get_im_num (Number* self, __mpfr_struct* result) {
	__mpfr_struct _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_im_num;
	*result = _tmp0_;
	return;
}


static void number_set_im_num (Number* self, __mpfr_struct* value) {
	__mpfr_struct _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_im_num = _tmp0_;
}


gulong number_get_precision (void) {
	gulong result;
	gulong _tmp0_ = 0UL;
	_tmp0_ = number__precision;
	result = _tmp0_;
	return result;
}


void number_set_precision (gulong value) {
	gulong _tmp0_ = 0UL;
	_tmp0_ = value;
	number__precision = _tmp0_;
}


const gchar* number_get_error (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = number__error;
	result = _tmp0_;
	return result;
}


void number_set_error (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (number__error);
	number__error = _tmp1_;
}


static void number_class_init (NumberClass * klass) {
	number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NumberPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
}


static void number_instance_init (Number * self) {
	self->priv = NUMBER_GET_PRIVATE (self);
}


static void number_finalize (GObject* obj) {
	Number * self;
	__mpfr_struct _tmp0_ = {0};
	__mpfr_struct _tmp1_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
	_tmp0_ = self->priv->_re_num;
	mpfr_clear (&_tmp0_);
	_tmp1_ = self->priv->_im_num;
	mpfr_clear (&_tmp1_);
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
}


GType number_get_type (void) {
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


Number* mp_set_from_string (const gchar* str, gint default_base) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	static const gunichar base_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp7_ = 0;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp24_ = 0;
	gboolean negate = FALSE;
	const gchar* _tmp26_ = NULL;
	gunichar _tmp27_ = 0U;
	gunichar _tmp28_ = 0U;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
	static const gunichar fractions[] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
	static const gint numerators[] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
	static const gint denominators[] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
	gboolean has_fraction = FALSE;
	const gchar* _tmp54_ = NULL;
	gunichar _tmp55_ = 0U;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gboolean _tmp108_ = FALSE;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
	if (_tmp1_ >= 0) {
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		_tmp2_ = str;
		_tmp3_ = set_from_sexagesimal (_tmp2_);
		result = _tmp3_;
		return result;
	}
	index = 0;
	while (TRUE) {
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = str;
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (!_tmp6_) {
			break;
		}
	}
	_tmp7_ = index;
	end = _tmp7_;
	number_base = 0;
	base_multiplier = 1;
	while (TRUE) {
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gint value = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp8_ = str;
		_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
		c = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		value = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_ = 0;
					gunichar _tmp14_ = 0U;
					gint _tmp15_ = 0;
					gunichar _tmp16_ = 0U;
					if (!_tmp11_) {
						gint _tmp12_ = 0;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					if (!(_tmp13_ < G_N_ELEMENTS (base_digits))) {
						break;
					}
					_tmp14_ = c;
					_tmp15_ = i;
					_tmp16_ = base_digits[_tmp15_];
					if (_tmp14_ == _tmp16_) {
						gint _tmp17_ = 0;
						_tmp17_ = i;
						value = _tmp17_;
						break;
					}
				}
			}
		}
		_tmp18_ = value;
		if (_tmp18_ < 0) {
			break;
		}
		_tmp19_ = index;
		end = _tmp19_;
		_tmp20_ = number_base;
		_tmp21_ = value;
		_tmp22_ = base_multiplier;
		number_base = _tmp20_ + (_tmp21_ * _tmp22_);
		_tmp23_ = base_multiplier;
		base_multiplier = _tmp23_ * 10;
	}
	_tmp24_ = base_multiplier;
	if (_tmp24_ == 1) {
		gint _tmp25_ = 0;
		_tmp25_ = default_base;
		number_base = _tmp25_;
	}
	negate = FALSE;
	index = 0;
	_tmp26_ = str;
	string_get_next_char (_tmp26_, &index, &_tmp27_);
	c = _tmp27_;
	_tmp28_ = c;
	if (_tmp28_ == ((gunichar) '+')) {
		negate = FALSE;
	} else {
		gboolean _tmp29_ = FALSE;
		gunichar _tmp30_ = 0U;
		_tmp30_ = c;
		if (_tmp30_ == ((gunichar) '-')) {
			_tmp29_ = TRUE;
		} else {
			gunichar _tmp31_ = 0U;
			_tmp31_ = c;
			_tmp29_ = _tmp31_ == 8722U;
		}
		if (_tmp29_) {
			negate = TRUE;
		} else {
			const gchar* _tmp32_ = NULL;
			gunichar _tmp33_ = 0U;
			_tmp32_ = str;
			string_get_prev_char (_tmp32_, &index, &_tmp33_);
			c = _tmp33_;
		}
	}
	_tmp34_ = number_new_integer ((gint64) 0);
	z = _tmp34_;
	while (TRUE) {
		const gchar* _tmp35_ = NULL;
		gunichar _tmp36_ = 0U;
		gboolean _tmp37_ = FALSE;
		gint i = 0;
		gunichar _tmp38_ = 0U;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
		_tmp35_ = str;
		_tmp37_ = string_get_next_char (_tmp35_, &index, &_tmp36_);
		c = _tmp36_;
		if (!_tmp37_) {
			break;
		}
		_tmp38_ = c;
		_tmp39_ = number_base;
		_tmp40_ = char_val (_tmp38_, _tmp39_);
		i = _tmp40_;
		_tmp41_ = i;
		_tmp42_ = number_base;
		if (_tmp41_ > _tmp42_) {
			result = NULL;
			_g_object_unref0 (z);
			return result;
		}
		_tmp43_ = i;
		if (_tmp43_ < 0) {
			const gchar* _tmp44_ = NULL;
			gunichar _tmp45_ = 0U;
			_tmp44_ = str;
			string_get_prev_char (_tmp44_, &index, &_tmp45_);
			c = _tmp45_;
			break;
		}
		_tmp46_ = z;
		_tmp47_ = number_base;
		_tmp48_ = number_multiply_integer (_tmp46_, (gint64) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = i;
		_tmp51_ = number_new_integer ((gint64) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = number_add (_tmp49_, _tmp52_);
		_g_object_unref0 (z);
		z = _tmp53_;
		_g_object_unref0 (_tmp52_);
		_g_object_unref0 (_tmp49_);
	}
	has_fraction = FALSE;
	_tmp54_ = str;
	_tmp56_ = string_get_next_char (_tmp54_, &index, &_tmp55_);
	c = _tmp55_;
	if (_tmp56_) {
		gunichar _tmp74_ = 0U;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp57_ = FALSE;
				_tmp57_ = TRUE;
				while (TRUE) {
					gint _tmp59_ = 0;
					gunichar _tmp60_ = 0U;
					gint _tmp61_ = 0;
					gunichar _tmp62_ = 0U;
					if (!_tmp57_) {
						gint _tmp58_ = 0;
						_tmp58_ = i;
						i = _tmp58_ + 1;
					}
					_tmp57_ = FALSE;
					_tmp59_ = i;
					if (!(_tmp59_ < G_N_ELEMENTS (fractions))) {
						break;
					}
					_tmp60_ = c;
					_tmp61_ = i;
					_tmp62_ = fractions[_tmp61_];
					if (_tmp60_ == _tmp62_) {
						Number* fraction = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
						Number* _tmp67_ = NULL;
						Number* _tmp68_ = NULL;
						Number* _tmp69_ = NULL;
						Number* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gunichar _tmp72_ = 0U;
						gboolean _tmp73_ = FALSE;
						_tmp63_ = i;
						_tmp64_ = numerators[_tmp63_];
						_tmp65_ = i;
						_tmp66_ = denominators[_tmp65_];
						_tmp67_ = number_new_fraction ((gint64) _tmp64_, (gint64) _tmp66_);
						fraction = _tmp67_;
						_tmp68_ = z;
						_tmp69_ = fraction;
						_tmp70_ = number_add (_tmp68_, _tmp69_);
						_g_object_unref0 (z);
						z = _tmp70_;
						_tmp71_ = str;
						_tmp73_ = string_get_next_char (_tmp71_, &index, &_tmp72_);
						c = _tmp72_;
						if (!_tmp73_) {
							result = z;
							_g_object_unref0 (fraction);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (fraction);
							_g_object_unref0 (z);
							return result;
						}
						_g_object_unref0 (fraction);
					}
				}
			}
		}
		_tmp74_ = c;
		if (_tmp74_ == ((gunichar) '.')) {
			has_fraction = TRUE;
		} else {
			const gchar* _tmp75_ = NULL;
			gunichar _tmp76_ = 0U;
			_tmp75_ = str;
			string_get_prev_char (_tmp75_, &index, &_tmp76_);
			c = _tmp76_;
		}
	}
	_tmp77_ = has_fraction;
	if (_tmp77_) {
		Number* numerator = NULL;
		Number* _tmp78_ = NULL;
		Number* denominator = NULL;
		Number* _tmp79_ = NULL;
		Number* _tmp100_ = NULL;
		Number* _tmp101_ = NULL;
		Number* _tmp102_ = NULL;
		Number* _tmp103_ = NULL;
		Number* _tmp104_ = NULL;
		Number* _tmp105_ = NULL;
		_tmp78_ = number_new_integer ((gint64) 0);
		numerator = _tmp78_;
		_tmp79_ = number_new_integer ((gint64) 1);
		denominator = _tmp79_;
		while (TRUE) {
			const gchar* _tmp80_ = NULL;
			gunichar _tmp81_ = 0U;
			gboolean _tmp82_ = FALSE;
			gint i = 0;
			gunichar _tmp83_ = 0U;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			Number* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			Number* _tmp91_ = NULL;
			Number* _tmp92_ = NULL;
			gint _tmp93_ = 0;
			Number* _tmp94_ = NULL;
			Number* _tmp95_ = NULL;
			gint _tmp96_ = 0;
			Number* _tmp97_ = NULL;
			Number* _tmp98_ = NULL;
			Number* _tmp99_ = NULL;
			_tmp80_ = str;
			_tmp82_ = string_get_next_char (_tmp80_, &index, &_tmp81_);
			c = _tmp81_;
			if (!_tmp82_) {
				break;
			}
			_tmp83_ = c;
			_tmp84_ = number_base;
			_tmp85_ = char_val (_tmp83_, _tmp84_);
			i = _tmp85_;
			_tmp86_ = i;
			if (_tmp86_ < 0) {
				const gchar* _tmp87_ = NULL;
				gunichar _tmp88_ = 0U;
				_tmp87_ = str;
				string_get_prev_char (_tmp87_, &index, &_tmp88_);
				c = _tmp88_;
				break;
			}
			_tmp89_ = denominator;
			_tmp90_ = number_base;
			_tmp91_ = number_multiply_integer (_tmp89_, (gint64) _tmp90_);
			_g_object_unref0 (denominator);
			denominator = _tmp91_;
			_tmp92_ = numerator;
			_tmp93_ = number_base;
			_tmp94_ = number_multiply_integer (_tmp92_, (gint64) _tmp93_);
			_g_object_unref0 (numerator);
			numerator = _tmp94_;
			_tmp95_ = numerator;
			_tmp96_ = i;
			_tmp97_ = number_new_integer ((gint64) _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = number_add (_tmp95_, _tmp98_);
			_g_object_unref0 (numerator);
			numerator = _tmp99_;
			_g_object_unref0 (_tmp98_);
		}
		_tmp100_ = numerator;
		_tmp101_ = denominator;
		_tmp102_ = number_divide (_tmp100_, _tmp101_);
		_g_object_unref0 (numerator);
		numerator = _tmp102_;
		_tmp103_ = z;
		_tmp104_ = numerator;
		_tmp105_ = number_add (_tmp103_, _tmp104_);
		_g_object_unref0 (z);
		z = _tmp105_;
		_g_object_unref0 (denominator);
		_g_object_unref0 (numerator);
	}
	_tmp106_ = index;
	_tmp107_ = end;
	if (_tmp106_ != _tmp107_) {
		result = NULL;
		_g_object_unref0 (z);
		return result;
	}
	_tmp108_ = negate;
	if (_tmp108_) {
		Number* _tmp109_ = NULL;
		Number* _tmp110_ = NULL;
		_tmp109_ = z;
		_tmp110_ = number_invert_sign (_tmp109_);
		_g_object_unref0 (z);
		z = _tmp110_;
	}
	result = z;
	return result;
}


gint char_val (gunichar c, gint number_base) {
	gint result = 0;
	gunichar _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gint value = 0;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	_tmp0_ = c;
	_tmp1_ = g_unichar_isxdigit (_tmp0_);
	if (!_tmp1_) {
		result = -1;
		return result;
	}
	_tmp2_ = c;
	_tmp3_ = g_unichar_xdigit_value (_tmp2_);
	value = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = number_base;
	if (_tmp4_ >= _tmp5_) {
		result = -1;
		return result;
	}
	result = value;
	return result;
}


Number* set_from_sexagesimal (const gchar* str) {
	Number* result = NULL;
	gint degree_index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Number* degrees = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint minute_start = 0;
	gint _tmp10_ = 0;
	gunichar c = 0U;
	const gchar* _tmp11_ = NULL;
	gunichar _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	gint minute_index = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Number* minutes = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	Number* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	gint second_start = 0;
	gint _tmp34_ = 0;
	const gchar* _tmp35_ = NULL;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar _tmp39_ = '\0';
	gint second_index = 0;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	Number* seconds = NULL;
	const gchar* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	Number* _tmp50_ = NULL;
	Number* _tmp51_ = NULL;
	Number* _tmp52_ = NULL;
	Number* _tmp53_ = NULL;
	Number* _tmp54_ = NULL;
	Number* _tmp55_ = NULL;
	Number* _tmp56_ = NULL;
	Number* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	gunichar _tmp59_ = 0U;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gchar _tmp62_ = '\0';
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
	degree_index = _tmp1_;
	_tmp2_ = degree_index;
	if (_tmp2_ < 0) {
		result = NULL;
		return result;
	}
	_tmp3_ = str;
	_tmp4_ = degree_index;
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = mp_set_from_string (_tmp6_, 10);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	degrees = _tmp8_;
	_tmp9_ = degrees;
	if (_tmp9_ == NULL) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp10_ = degree_index;
	minute_start = _tmp10_;
	_tmp11_ = str;
	string_get_next_char (_tmp11_, &minute_start, &_tmp12_);
	c = _tmp12_;
	_tmp13_ = str;
	_tmp14_ = minute_start;
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
	if (_tmp15_ == '\0') {
		result = degrees;
		return result;
	}
	_tmp16_ = str;
	_tmp17_ = minute_start;
	_tmp18_ = string_index_of_char (_tmp16_, (gunichar) '\'', _tmp17_);
	minute_index = _tmp18_;
	_tmp19_ = minute_index;
	if (_tmp19_ < 0) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp20_ = str;
	_tmp21_ = minute_start;
	_tmp22_ = minute_index;
	_tmp23_ = minute_start;
	_tmp24_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
	_tmp25_ = _tmp24_;
	_tmp26_ = mp_set_from_string (_tmp25_, 10);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	minutes = _tmp27_;
	_tmp28_ = minutes;
	if (_tmp28_ == NULL) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp29_ = degrees;
	_tmp30_ = minutes;
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 60);
	_tmp32_ = _tmp31_;
	_tmp33_ = number_add (_tmp29_, _tmp32_);
	_g_object_unref0 (degrees);
	degrees = _tmp33_;
	_g_object_unref0 (_tmp32_);
	_tmp34_ = minute_index;
	second_start = _tmp34_;
	_tmp35_ = str;
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
	c = _tmp36_;
	_tmp37_ = str;
	_tmp38_ = second_start;
	_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
	if (_tmp39_ == '\0') {
		result = degrees;
		_g_object_unref0 (minutes);
		return result;
	}
	_tmp40_ = str;
	_tmp41_ = second_start;
	_tmp42_ = string_index_of_char (_tmp40_, (gunichar) '"', _tmp41_);
	second_index = _tmp42_;
	_tmp43_ = second_index;
	if (_tmp43_ < 0) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp44_ = str;
	_tmp45_ = second_start;
	_tmp46_ = second_index;
	_tmp47_ = second_start;
	_tmp48_ = string_substring (_tmp44_, (glong) _tmp45_, (glong) (_tmp46_ - _tmp47_));
	_tmp49_ = _tmp48_;
	_tmp50_ = mp_set_from_string (_tmp49_, 10);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	seconds = _tmp51_;
	_tmp52_ = seconds;
	if (_tmp52_ == NULL) {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp53_ = degrees;
	_tmp54_ = seconds;
	_tmp55_ = number_divide_integer (_tmp54_, (gint64) 3600);
	_tmp56_ = _tmp55_;
	_tmp57_ = number_add (_tmp53_, _tmp56_);
	_g_object_unref0 (degrees);
	degrees = _tmp57_;
	_g_object_unref0 (_tmp56_);
	_tmp58_ = str;
	string_get_next_char (_tmp58_, &second_index, &_tmp59_);
	c = _tmp59_;
	_tmp60_ = str;
	_tmp61_ = second_index;
	_tmp62_ = string_get (_tmp60_, (glong) _tmp61_);
	if (_tmp62_ == '\0') {
		result = degrees;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_g_object_unref0 (seconds);
	_g_object_unref0 (minutes);
	_g_object_unref0 (degrees);
}


gboolean mp_is_overflow (Number* x, gint wordlen) {
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = number_new_integer ((gint64) 2);
	_tmp1_ = _tmp0_;
	_tmp2_ = wordlen;
	_tmp3_ = number_xpowy_integer (_tmp1_, (gint64) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	t2 = _tmp4_;
	_tmp5_ = x;
	_tmp6_ = number_compare (t2, _tmp5_);
	result = _tmp6_ > 0;
	_g_object_unref0 (t2);
	return result;
}



