/* currency.c generated by valac 0.34.1, the Vala compiler
 * generated from currency.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include <time.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define TYPE_CURRENCY_MANAGER (currency_manager_get_type ())
#define CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_MANAGER, CurrencyManager))
#define CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))
#define IS_CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_MANAGER))
#define IS_CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_MANAGER))
#define CURRENCY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))

typedef struct _CurrencyManager CurrencyManager;
typedef struct _CurrencyManagerClass CurrencyManagerClass;
typedef struct _CurrencyManagerPrivate CurrencyManagerPrivate;

#define TYPE_CURRENCY (currency_get_type ())
#define CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY, Currency))
#define CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY, CurrencyClass))
#define IS_CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY))
#define IS_CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY))
#define CURRENCY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY, CurrencyClass))

typedef struct _Currency Currency;
typedef struct _CurrencyClass CurrencyClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
typedef struct _CurrencyManagerDownloadFileData CurrencyManagerDownloadFileData;
typedef struct _CurrencyPrivate CurrencyPrivate;

struct _CurrencyManager {
	GObject parent_instance;
	CurrencyManagerPrivate * priv;
};

struct _CurrencyManagerClass {
	GObjectClass parent_class;
};

struct _CurrencyManagerPrivate {
	GList* currencies;
};

struct _CurrencyManagerDownloadFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	CurrencyManager* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* dest;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	SoupSession* session;
	SoupSession* _tmp5_;
	SoupMessage* message;
	const gchar* _tmp6_;
	SoupMessage* _tmp7_;
	GInputStream* bodyinput;
	SoupSession* _tmp8_;
	SoupMessage* _tmp9_;
	GInputStream* _tmp10_;
	GFileOutputStream* output;
	GFile* _tmp11_;
	GFileOutputStream* _tmp12_;
	GFileOutputStream* _tmp13_;
	GInputStream* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _Currency {
	GObject parent_instance;
	CurrencyPrivate * priv;
};

struct _CurrencyClass {
	GObjectClass parent_class;
};

struct _CurrencyPrivate {
	Number* value;
	gchar* _name;
	gchar* _display_name;
	gchar* _symbol;
};


extern gboolean downloading_imf_rates;
gboolean downloading_imf_rates = FALSE;
extern gboolean downloading_ecb_rates;
gboolean downloading_ecb_rates = FALSE;
extern gboolean loaded_rates;
gboolean loaded_rates = FALSE;
extern CurrencyManager* default_currency_manager;
CurrencyManager* default_currency_manager = NULL;
static gpointer currency_manager_parent_class = NULL;
static gpointer currency_parent_class = NULL;

GType currency_manager_get_type (void) G_GNUC_CONST;
GType currency_get_type (void) G_GNUC_CONST;
#define CURRENCY_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CURRENCY_MANAGER, CurrencyManagerPrivate))
enum  {
	CURRENCY_MANAGER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
CurrencyManager* currency_manager_get_default (void);
CurrencyManager* currency_manager_new (void);
CurrencyManager* currency_manager_construct (GType object_type);
Currency* currency_new (const gchar* name, const gchar* display_name, const gchar* symbol);
Currency* currency_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* symbol);
static void currency_manager_download_rates (CurrencyManager* self);
GList* currency_manager_get_currencies (CurrencyManager* self);
Currency* currency_manager_get_currency (CurrencyManager* self, const gchar* name);
gchar* currency_get_name (Currency* self);
GType number_get_type (void) G_GNUC_CONST;
Number* currency_get_value (Currency* self);
gboolean number_is_negative (Number* self);
gboolean number_is_zero (Number* self);
static gchar* currency_manager_get_imf_rate_filepath (CurrencyManager* self);
static gchar* currency_manager_get_ecb_rate_filepath (CurrencyManager* self);
static Currency* currency_manager_add_currency (CurrencyManager* self, const gchar* short_name);
static gboolean currency_manager_file_needs_update (CurrencyManager* self, const gchar* filename, gdouble max_age);
static void currency_manager_load_imf_rates (CurrencyManager* self);
static void _g_free0_ (gpointer var);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_reciprocal (Number* self);
void currency_set_value (Currency* self, Number* value);
static void currency_manager_set_ecb_rate (CurrencyManager* self, xmlNode* node, Currency* eur_rate);
Number* number_multiply (Number* self, Number* y);
static void currency_manager_set_ecb_fixed_rate (CurrencyManager* self, const gchar* name, const gchar* value, Currency* eur_rate);
Number* number_divide (Number* self, Number* y);
static void currency_manager_load_ecb_rates (CurrencyManager* self);
static void currency_manager_download_file (CurrencyManager* self, const gchar* uri, const gchar* filename, const gchar* source, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void currency_manager_download_file_finish (CurrencyManager* self, GAsyncResult* _res_);
static gboolean currency_manager_load_rates (CurrencyManager* self);
Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency);
static void currency_manager_download_file_data_free (gpointer _data);
static gboolean currency_manager_download_file_co (CurrencyManagerDownloadFileData* _data_);
static void currency_manager_download_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void currency_manager_finalize (GObject* obj);
#define CURRENCY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CURRENCY, CurrencyPrivate))
enum  {
	CURRENCY_DUMMY_PROPERTY,
	CURRENCY_NAME,
	CURRENCY_DISPLAY_NAME,
	CURRENCY_SYMBOL
};
gchar* currency_get_display_name (Currency* self);
gchar* currency_get_symbol (Currency* self);
static void currency_finalize (GObject* obj);
static void _vala_currency_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CurrencyManager* currency_manager_get_default (void) {
	CurrencyManager* result = NULL;
	CurrencyManager* _tmp0_ = NULL;
	CurrencyManager* _tmp3_ = NULL;
	CurrencyManager* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	Currency* _tmp6_ = NULL;
	CurrencyManager* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	Currency* _tmp9_ = NULL;
	CurrencyManager* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	Currency* _tmp12_ = NULL;
	CurrencyManager* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	Currency* _tmp15_ = NULL;
	CurrencyManager* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	Currency* _tmp18_ = NULL;
	CurrencyManager* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	Currency* _tmp21_ = NULL;
	CurrencyManager* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	Currency* _tmp24_ = NULL;
	CurrencyManager* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	Currency* _tmp27_ = NULL;
	CurrencyManager* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	Currency* _tmp30_ = NULL;
	CurrencyManager* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	Currency* _tmp33_ = NULL;
	CurrencyManager* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	Currency* _tmp36_ = NULL;
	CurrencyManager* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	Currency* _tmp39_ = NULL;
	CurrencyManager* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	Currency* _tmp42_ = NULL;
	CurrencyManager* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	Currency* _tmp45_ = NULL;
	CurrencyManager* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	Currency* _tmp48_ = NULL;
	CurrencyManager* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	Currency* _tmp51_ = NULL;
	CurrencyManager* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	Currency* _tmp54_ = NULL;
	CurrencyManager* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	Currency* _tmp57_ = NULL;
	CurrencyManager* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	Currency* _tmp60_ = NULL;
	CurrencyManager* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	Currency* _tmp63_ = NULL;
	CurrencyManager* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	Currency* _tmp66_ = NULL;
	CurrencyManager* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	Currency* _tmp69_ = NULL;
	CurrencyManager* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	Currency* _tmp72_ = NULL;
	CurrencyManager* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	Currency* _tmp75_ = NULL;
	CurrencyManager* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	Currency* _tmp78_ = NULL;
	CurrencyManager* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	Currency* _tmp81_ = NULL;
	CurrencyManager* _tmp82_ = NULL;
	const gchar* _tmp83_ = NULL;
	Currency* _tmp84_ = NULL;
	CurrencyManager* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	Currency* _tmp87_ = NULL;
	CurrencyManager* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	Currency* _tmp90_ = NULL;
	CurrencyManager* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	Currency* _tmp93_ = NULL;
	CurrencyManager* _tmp94_ = NULL;
	const gchar* _tmp95_ = NULL;
	Currency* _tmp96_ = NULL;
	CurrencyManager* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	Currency* _tmp99_ = NULL;
	CurrencyManager* _tmp100_ = NULL;
	const gchar* _tmp101_ = NULL;
	Currency* _tmp102_ = NULL;
	CurrencyManager* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	Currency* _tmp105_ = NULL;
	CurrencyManager* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	Currency* _tmp108_ = NULL;
	CurrencyManager* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	Currency* _tmp111_ = NULL;
	CurrencyManager* _tmp112_ = NULL;
	const gchar* _tmp113_ = NULL;
	Currency* _tmp114_ = NULL;
	CurrencyManager* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	Currency* _tmp117_ = NULL;
	CurrencyManager* _tmp118_ = NULL;
	const gchar* _tmp119_ = NULL;
	Currency* _tmp120_ = NULL;
	CurrencyManager* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	Currency* _tmp123_ = NULL;
	CurrencyManager* _tmp124_ = NULL;
	const gchar* _tmp125_ = NULL;
	Currency* _tmp126_ = NULL;
	CurrencyManager* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	Currency* _tmp129_ = NULL;
	CurrencyManager* _tmp130_ = NULL;
	const gchar* _tmp131_ = NULL;
	Currency* _tmp132_ = NULL;
	CurrencyManager* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	Currency* _tmp135_ = NULL;
	CurrencyManager* _tmp136_ = NULL;
	const gchar* _tmp137_ = NULL;
	Currency* _tmp138_ = NULL;
	CurrencyManager* _tmp139_ = NULL;
	const gchar* _tmp140_ = NULL;
	Currency* _tmp141_ = NULL;
	CurrencyManager* _tmp142_ = NULL;
	const gchar* _tmp143_ = NULL;
	Currency* _tmp144_ = NULL;
	CurrencyManager* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	Currency* _tmp147_ = NULL;
	CurrencyManager* _tmp148_ = NULL;
	const gchar* _tmp149_ = NULL;
	Currency* _tmp150_ = NULL;
	CurrencyManager* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	Currency* _tmp153_ = NULL;
	CurrencyManager* _tmp154_ = NULL;
	const gchar* _tmp155_ = NULL;
	Currency* _tmp156_ = NULL;
	CurrencyManager* _tmp157_ = NULL;
	const gchar* _tmp158_ = NULL;
	Currency* _tmp159_ = NULL;
	CurrencyManager* _tmp160_ = NULL;
	const gchar* _tmp161_ = NULL;
	Currency* _tmp162_ = NULL;
	CurrencyManager* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	Currency* _tmp165_ = NULL;
	CurrencyManager* _tmp166_ = NULL;
	const gchar* _tmp167_ = NULL;
	Currency* _tmp168_ = NULL;
	CurrencyManager* _tmp169_ = NULL;
	const gchar* _tmp170_ = NULL;
	Currency* _tmp171_ = NULL;
	CurrencyManager* _tmp172_ = NULL;
	const gchar* _tmp173_ = NULL;
	Currency* _tmp174_ = NULL;
	CurrencyManager* _tmp175_ = NULL;
	const gchar* _tmp176_ = NULL;
	Currency* _tmp177_ = NULL;
	CurrencyManager* _tmp178_ = NULL;
	CurrencyManager* _tmp179_ = NULL;
	CurrencyManager* _tmp180_ = NULL;
	_tmp0_ = default_currency_manager;
	if (_tmp0_ != NULL) {
		CurrencyManager* _tmp1_ = NULL;
		CurrencyManager* _tmp2_ = NULL;
		_tmp1_ = default_currency_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = currency_manager_new ();
	_g_object_unref0 (default_currency_manager);
	default_currency_manager = _tmp3_;
	_tmp4_ = default_currency_manager;
	_tmp5_ = _ ("UAE Dirham");
	_tmp6_ = currency_new ("AED", _tmp5_, "إ.د");
	_tmp4_->priv->currencies = g_list_append (_tmp4_->priv->currencies, _tmp6_);
	_tmp7_ = default_currency_manager;
	_tmp8_ = _ ("Australian Dollar");
	_tmp9_ = currency_new ("AUD", _tmp8_, "$");
	_tmp7_->priv->currencies = g_list_append (_tmp7_->priv->currencies, _tmp9_);
	_tmp10_ = default_currency_manager;
	_tmp11_ = _ ("Bulgarian Lev");
	_tmp12_ = currency_new ("BGN", _tmp11_, "лв");
	_tmp10_->priv->currencies = g_list_append (_tmp10_->priv->currencies, _tmp12_);
	_tmp13_ = default_currency_manager;
	_tmp14_ = _ ("Bahraini Dinar");
	_tmp15_ = currency_new ("BHD", _tmp14_, ".ب.د");
	_tmp13_->priv->currencies = g_list_append (_tmp13_->priv->currencies, _tmp15_);
	_tmp16_ = default_currency_manager;
	_tmp17_ = _ ("Brunei Dollar");
	_tmp18_ = currency_new ("BND", _tmp17_, "$");
	_tmp16_->priv->currencies = g_list_append (_tmp16_->priv->currencies, _tmp18_);
	_tmp19_ = default_currency_manager;
	_tmp20_ = _ ("Brazilian Real");
	_tmp21_ = currency_new ("BRL", _tmp20_, "R$");
	_tmp19_->priv->currencies = g_list_append (_tmp19_->priv->currencies, _tmp21_);
	_tmp22_ = default_currency_manager;
	_tmp23_ = _ ("Botswana Pula");
	_tmp24_ = currency_new ("BWP", _tmp23_, "P");
	_tmp22_->priv->currencies = g_list_append (_tmp22_->priv->currencies, _tmp24_);
	_tmp25_ = default_currency_manager;
	_tmp26_ = _ ("Canadian Dollar");
	_tmp27_ = currency_new ("CAD", _tmp26_, "$");
	_tmp25_->priv->currencies = g_list_append (_tmp25_->priv->currencies, _tmp27_);
	_tmp28_ = default_currency_manager;
	_tmp29_ = _ ("CFA Franc");
	_tmp30_ = currency_new ("CFA", _tmp29_, "Fr");
	_tmp28_->priv->currencies = g_list_append (_tmp28_->priv->currencies, _tmp30_);
	_tmp31_ = default_currency_manager;
	_tmp32_ = _ ("Swiss Franc");
	_tmp33_ = currency_new ("CHF", _tmp32_, "Fr");
	_tmp31_->priv->currencies = g_list_append (_tmp31_->priv->currencies, _tmp33_);
	_tmp34_ = default_currency_manager;
	_tmp35_ = _ ("Chilean Peso");
	_tmp36_ = currency_new ("CLP", _tmp35_, "$");
	_tmp34_->priv->currencies = g_list_append (_tmp34_->priv->currencies, _tmp36_);
	_tmp37_ = default_currency_manager;
	_tmp38_ = _ ("Chinese Yuan");
	_tmp39_ = currency_new ("CNY", _tmp38_, "¥");
	_tmp37_->priv->currencies = g_list_append (_tmp37_->priv->currencies, _tmp39_);
	_tmp40_ = default_currency_manager;
	_tmp41_ = _ ("Colombian Peso");
	_tmp42_ = currency_new ("COP", _tmp41_, "$");
	_tmp40_->priv->currencies = g_list_append (_tmp40_->priv->currencies, _tmp42_);
	_tmp43_ = default_currency_manager;
	_tmp44_ = _ ("Czech Koruna");
	_tmp45_ = currency_new ("CZK", _tmp44_, "Kč");
	_tmp43_->priv->currencies = g_list_append (_tmp43_->priv->currencies, _tmp45_);
	_tmp46_ = default_currency_manager;
	_tmp47_ = _ ("Danish Krone");
	_tmp48_ = currency_new ("DKK", _tmp47_, "kr");
	_tmp46_->priv->currencies = g_list_append (_tmp46_->priv->currencies, _tmp48_);
	_tmp49_ = default_currency_manager;
	_tmp50_ = _ ("Algerian Dinar");
	_tmp51_ = currency_new ("DZD", _tmp50_, "ج.د");
	_tmp49_->priv->currencies = g_list_append (_tmp49_->priv->currencies, _tmp51_);
	_tmp52_ = default_currency_manager;
	_tmp53_ = _ ("Estonian Kroon");
	_tmp54_ = currency_new ("EEK", _tmp53_, "KR");
	_tmp52_->priv->currencies = g_list_append (_tmp52_->priv->currencies, _tmp54_);
	_tmp55_ = default_currency_manager;
	_tmp56_ = _ ("Euro");
	_tmp57_ = currency_new ("EUR", _tmp56_, "€");
	_tmp55_->priv->currencies = g_list_append (_tmp55_->priv->currencies, _tmp57_);
	_tmp58_ = default_currency_manager;
	_tmp59_ = _ ("Pound Sterling");
	_tmp60_ = currency_new ("GBP", _tmp59_, "£");
	_tmp58_->priv->currencies = g_list_append (_tmp58_->priv->currencies, _tmp60_);
	_tmp61_ = default_currency_manager;
	_tmp62_ = _ ("Hong Kong Dollar");
	_tmp63_ = currency_new ("HKD", _tmp62_, "$");
	_tmp61_->priv->currencies = g_list_append (_tmp61_->priv->currencies, _tmp63_);
	_tmp64_ = default_currency_manager;
	_tmp65_ = _ ("Croatian Kuna");
	_tmp66_ = currency_new ("HRK", _tmp65_, "kn");
	_tmp64_->priv->currencies = g_list_append (_tmp64_->priv->currencies, _tmp66_);
	_tmp67_ = default_currency_manager;
	_tmp68_ = _ ("Hungarian Forint");
	_tmp69_ = currency_new ("HUF", _tmp68_, "Ft");
	_tmp67_->priv->currencies = g_list_append (_tmp67_->priv->currencies, _tmp69_);
	_tmp70_ = default_currency_manager;
	_tmp71_ = _ ("Indonesian Rupiah");
	_tmp72_ = currency_new ("IDR", _tmp71_, "Rp");
	_tmp70_->priv->currencies = g_list_append (_tmp70_->priv->currencies, _tmp72_);
	_tmp73_ = default_currency_manager;
	_tmp74_ = _ ("Israeli New Shekel");
	_tmp75_ = currency_new ("ILS", _tmp74_, "₪");
	_tmp73_->priv->currencies = g_list_append (_tmp73_->priv->currencies, _tmp75_);
	_tmp76_ = default_currency_manager;
	_tmp77_ = _ ("Indian Rupee");
	_tmp78_ = currency_new ("INR", _tmp77_, "₹");
	_tmp76_->priv->currencies = g_list_append (_tmp76_->priv->currencies, _tmp78_);
	_tmp79_ = default_currency_manager;
	_tmp80_ = _ ("Iranian Rial");
	_tmp81_ = currency_new ("IRR", _tmp80_, "﷼");
	_tmp79_->priv->currencies = g_list_append (_tmp79_->priv->currencies, _tmp81_);
	_tmp82_ = default_currency_manager;
	_tmp83_ = _ ("Icelandic Krona");
	_tmp84_ = currency_new ("ISK", _tmp83_, "kr");
	_tmp82_->priv->currencies = g_list_append (_tmp82_->priv->currencies, _tmp84_);
	_tmp85_ = default_currency_manager;
	_tmp86_ = _ ("Japanese Yen");
	_tmp87_ = currency_new ("JPY", _tmp86_, "¥");
	_tmp85_->priv->currencies = g_list_append (_tmp85_->priv->currencies, _tmp87_);
	_tmp88_ = default_currency_manager;
	_tmp89_ = _ ("South Korean Won");
	_tmp90_ = currency_new ("KRW", _tmp89_, "₩");
	_tmp88_->priv->currencies = g_list_append (_tmp88_->priv->currencies, _tmp90_);
	_tmp91_ = default_currency_manager;
	_tmp92_ = _ ("Kuwaiti Dinar");
	_tmp93_ = currency_new ("KWD", _tmp92_, "ك.د");
	_tmp91_->priv->currencies = g_list_append (_tmp91_->priv->currencies, _tmp93_);
	_tmp94_ = default_currency_manager;
	_tmp95_ = _ ("Kazakhstani Tenge");
	_tmp96_ = currency_new ("KZT", _tmp95_, "₸");
	_tmp94_->priv->currencies = g_list_append (_tmp94_->priv->currencies, _tmp96_);
	_tmp97_ = default_currency_manager;
	_tmp98_ = _ ("Sri Lankan Rupee");
	_tmp99_ = currency_new ("LKR", _tmp98_, "Rs");
	_tmp97_->priv->currencies = g_list_append (_tmp97_->priv->currencies, _tmp99_);
	_tmp100_ = default_currency_manager;
	_tmp101_ = _ ("Libyan Dinar");
	_tmp102_ = currency_new ("LYD", _tmp101_, "د.ل");
	_tmp100_->priv->currencies = g_list_append (_tmp100_->priv->currencies, _tmp102_);
	_tmp103_ = default_currency_manager;
	_tmp104_ = _ ("Mauritian Rupee");
	_tmp105_ = currency_new ("MUR", _tmp104_, "Rs");
	_tmp103_->priv->currencies = g_list_append (_tmp103_->priv->currencies, _tmp105_);
	_tmp106_ = default_currency_manager;
	_tmp107_ = _ ("Mexican Peso");
	_tmp108_ = currency_new ("MXN", _tmp107_, "$");
	_tmp106_->priv->currencies = g_list_append (_tmp106_->priv->currencies, _tmp108_);
	_tmp109_ = default_currency_manager;
	_tmp110_ = _ ("Malaysian Ringgit");
	_tmp111_ = currency_new ("MYR", _tmp110_, "RM");
	_tmp109_->priv->currencies = g_list_append (_tmp109_->priv->currencies, _tmp111_);
	_tmp112_ = default_currency_manager;
	_tmp113_ = _ ("Norwegian Krone");
	_tmp114_ = currency_new ("NOK", _tmp113_, "kr");
	_tmp112_->priv->currencies = g_list_append (_tmp112_->priv->currencies, _tmp114_);
	_tmp115_ = default_currency_manager;
	_tmp116_ = _ ("Nepalese Rupee");
	_tmp117_ = currency_new ("NPR", _tmp116_, "Rs");
	_tmp115_->priv->currencies = g_list_append (_tmp115_->priv->currencies, _tmp117_);
	_tmp118_ = default_currency_manager;
	_tmp119_ = _ ("New Zealand Dollar");
	_tmp120_ = currency_new ("NZD", _tmp119_, "$");
	_tmp118_->priv->currencies = g_list_append (_tmp118_->priv->currencies, _tmp120_);
	_tmp121_ = default_currency_manager;
	_tmp122_ = _ ("Omani Rial");
	_tmp123_ = currency_new ("OMR", _tmp122_, "ع.ر.");
	_tmp121_->priv->currencies = g_list_append (_tmp121_->priv->currencies, _tmp123_);
	_tmp124_ = default_currency_manager;
	_tmp125_ = _ ("Peruvian Nuevo Sol");
	_tmp126_ = currency_new ("PEN", _tmp125_, "S/.");
	_tmp124_->priv->currencies = g_list_append (_tmp124_->priv->currencies, _tmp126_);
	_tmp127_ = default_currency_manager;
	_tmp128_ = _ ("Philippine Peso");
	_tmp129_ = currency_new ("PHP", _tmp128_, "₱");
	_tmp127_->priv->currencies = g_list_append (_tmp127_->priv->currencies, _tmp129_);
	_tmp130_ = default_currency_manager;
	_tmp131_ = _ ("Pakistani Rupee");
	_tmp132_ = currency_new ("PKR", _tmp131_, "Rs");
	_tmp130_->priv->currencies = g_list_append (_tmp130_->priv->currencies, _tmp132_);
	_tmp133_ = default_currency_manager;
	_tmp134_ = _ ("Polish Zloty");
	_tmp135_ = currency_new ("PLN", _tmp134_, "zł");
	_tmp133_->priv->currencies = g_list_append (_tmp133_->priv->currencies, _tmp135_);
	_tmp136_ = default_currency_manager;
	_tmp137_ = _ ("Qatari Riyal");
	_tmp138_ = currency_new ("QAR", _tmp137_, "ق.ر");
	_tmp136_->priv->currencies = g_list_append (_tmp136_->priv->currencies, _tmp138_);
	_tmp139_ = default_currency_manager;
	_tmp140_ = _ ("New Romanian Leu");
	_tmp141_ = currency_new ("RON", _tmp140_, "L");
	_tmp139_->priv->currencies = g_list_append (_tmp139_->priv->currencies, _tmp141_);
	_tmp142_ = default_currency_manager;
	_tmp143_ = _ ("Russian Rouble");
	_tmp144_ = currency_new ("RUB", _tmp143_, "руб.");
	_tmp142_->priv->currencies = g_list_append (_tmp142_->priv->currencies, _tmp144_);
	_tmp145_ = default_currency_manager;
	_tmp146_ = _ ("Saudi Riyal");
	_tmp147_ = currency_new ("SAR", _tmp146_, "س.ر");
	_tmp145_->priv->currencies = g_list_append (_tmp145_->priv->currencies, _tmp147_);
	_tmp148_ = default_currency_manager;
	_tmp149_ = _ ("Swedish Krona");
	_tmp150_ = currency_new ("SEK", _tmp149_, "kr");
	_tmp148_->priv->currencies = g_list_append (_tmp148_->priv->currencies, _tmp150_);
	_tmp151_ = default_currency_manager;
	_tmp152_ = _ ("Singapore Dollar");
	_tmp153_ = currency_new ("SGD", _tmp152_, "$");
	_tmp151_->priv->currencies = g_list_append (_tmp151_->priv->currencies, _tmp153_);
	_tmp154_ = default_currency_manager;
	_tmp155_ = _ ("Thai Baht");
	_tmp156_ = currency_new ("THB", _tmp155_, "฿");
	_tmp154_->priv->currencies = g_list_append (_tmp154_->priv->currencies, _tmp156_);
	_tmp157_ = default_currency_manager;
	_tmp158_ = _ ("Tunisian Dinar");
	_tmp159_ = currency_new ("TND", _tmp158_, "ت.د");
	_tmp157_->priv->currencies = g_list_append (_tmp157_->priv->currencies, _tmp159_);
	_tmp160_ = default_currency_manager;
	_tmp161_ = _ ("New Turkish Lira");
	_tmp162_ = currency_new ("TRY", _tmp161_, "TL");
	_tmp160_->priv->currencies = g_list_append (_tmp160_->priv->currencies, _tmp162_);
	_tmp163_ = default_currency_manager;
	_tmp164_ = _ ("T&T Dollar (TTD)");
	_tmp165_ = currency_new ("TTD", _tmp164_, "$");
	_tmp163_->priv->currencies = g_list_append (_tmp163_->priv->currencies, _tmp165_);
	_tmp166_ = default_currency_manager;
	_tmp167_ = _ ("US Dollar");
	_tmp168_ = currency_new ("USD", _tmp167_, "$");
	_tmp166_->priv->currencies = g_list_append (_tmp166_->priv->currencies, _tmp168_);
	_tmp169_ = default_currency_manager;
	_tmp170_ = _ ("Uruguayan Peso");
	_tmp171_ = currency_new ("UYU", _tmp170_, "$");
	_tmp169_->priv->currencies = g_list_append (_tmp169_->priv->currencies, _tmp171_);
	_tmp172_ = default_currency_manager;
	_tmp173_ = _ ("Venezuelan Bolívar");
	_tmp174_ = currency_new ("VEF", _tmp173_, "Bs F");
	_tmp172_->priv->currencies = g_list_append (_tmp172_->priv->currencies, _tmp174_);
	_tmp175_ = default_currency_manager;
	_tmp176_ = _ ("South African Rand");
	_tmp177_ = currency_new ("ZAR", _tmp176_, "R");
	_tmp175_->priv->currencies = g_list_append (_tmp175_->priv->currencies, _tmp177_);
	_tmp178_ = default_currency_manager;
	currency_manager_download_rates (_tmp178_);
	_tmp179_ = default_currency_manager;
	_tmp180_ = _g_object_ref0 (_tmp179_);
	result = _tmp180_;
	return result;
}


GList* currency_manager_get_currencies (CurrencyManager* self) {
	GList* result = NULL;
	GList* r = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_ = NULL;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_ = NULL;
				Currency* _tmp3_ = NULL;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}


Currency* currency_manager_get_currency (CurrencyManager* self, const gchar* name) {
	Currency* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_ = NULL;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				Currency* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = name;
				_tmp3_ = c;
				_tmp4_ = currency_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp2_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					Number* value = NULL;
					Currency* _tmp8_ = NULL;
					Number* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					Number* _tmp12_ = NULL;
					_tmp8_ = c;
					_tmp9_ = currency_get_value (_tmp8_);
					value = _tmp9_;
					_tmp12_ = value;
					if (_tmp12_ == NULL) {
						_tmp11_ = TRUE;
					} else {
						Number* _tmp13_ = NULL;
						gboolean _tmp14_ = FALSE;
						_tmp13_ = value;
						_tmp14_ = number_is_negative (_tmp13_);
						_tmp11_ = _tmp14_;
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						Number* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						_tmp15_ = value;
						_tmp16_ = number_is_zero (_tmp15_);
						_tmp10_ = _tmp16_;
					}
					if (_tmp10_) {
						result = NULL;
						_g_object_unref0 (value);
						_g_object_unref0 (c);
						return result;
					} else {
						result = c;
						_g_object_unref0 (value);
						return result;
					}
					_g_object_unref0 (value);
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* currency_manager_get_imf_rate_filepath (CurrencyManager* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "rms_five.xls", NULL);
	result = _tmp1_;
	return result;
}


static gchar* currency_manager_get_ecb_rate_filepath (CurrencyManager* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "eurofxref-daily.xml", NULL);
	result = _tmp1_;
	return result;
}


static Currency* currency_manager_add_currency (CurrencyManager* self, const gchar* short_name) {
	Currency* result = NULL;
	GList* _tmp0_ = NULL;
	const gchar* _tmp8_ = NULL;
	Currency* c = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	Currency* _tmp12_ = NULL;
	Currency* _tmp13_ = NULL;
	Currency* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (short_name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_ = NULL;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp2_ = c;
				_tmp3_ = currency_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = short_name;
				_tmp7_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp7_) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	_tmp8_ = short_name;
	g_warning ("currency.vala:134: Currency %s is not in the currency table", _tmp8_);
	_tmp9_ = short_name;
	_tmp10_ = short_name;
	_tmp11_ = short_name;
	_tmp12_ = currency_new (_tmp9_, _tmp10_, _tmp11_);
	c = _tmp12_;
	_tmp13_ = c;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	self->priv->currencies = g_list_append (self->priv->currencies, _tmp14_);
	result = c;
	return result;
}


static gboolean currency_manager_file_needs_update (CurrencyManager* self, const gchar* filename, gdouble max_age) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	struct stat buf = {0};
	const gchar* _tmp2_ = NULL;
	struct stat _tmp3_ = {0};
	gint _tmp4_ = 0;
	time_t modify_time = 0;
	struct stat _tmp5_ = {0};
	time_t _tmp6_ = 0;
	time_t now = 0;
	time_t _tmp7_ = 0;
	time_t _tmp8_ = 0;
	time_t _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_IS_REGULAR);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	memset (&buf, 0, sizeof (struct stat));
	_tmp2_ = filename;
	_tmp4_ = stat (_tmp2_, &_tmp3_);
	buf = _tmp3_;
	if (_tmp4_ == -1) {
		result = TRUE;
		return result;
	}
	_tmp5_ = buf;
	_tmp6_ = _tmp5_.st_mtime;
	modify_time = _tmp6_;
	_tmp7_ = time (NULL);
	now = _tmp7_;
	_tmp8_ = now;
	_tmp9_ = modify_time;
	_tmp10_ = max_age;
	if (((gdouble) (_tmp8_ - _tmp9_)) > _tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchug (_tmp1_);
	result = _result_;
	return result;
}


static void currency_manager_load_imf_rates (CurrencyManager* self) {
	GHashTable* name_map = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GHashTable* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GHashTable* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GHashTable* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GHashTable* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GHashTable* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GHashTable* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GHashTable* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GHashTable* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GHashTable* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GHashTable* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	GHashTable* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	GHashTable* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	GHashTable* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	GHashTable* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	GHashTable* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	GHashTable* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	GHashTable* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	GHashTable* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	GHashTable* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	GHashTable* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	GHashTable* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	GHashTable* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_ = NULL;
	GHashTable* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	GHashTable* _tmp81_ = NULL;
	gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	GHashTable* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	gchar* _tmp86_ = NULL;
	GHashTable* _tmp87_ = NULL;
	gchar* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	GHashTable* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	gchar* _tmp92_ = NULL;
	GHashTable* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	GHashTable* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_ = NULL;
	GHashTable* _tmp99_ = NULL;
	gchar* _tmp100_ = NULL;
	gchar* _tmp101_ = NULL;
	GHashTable* _tmp102_ = NULL;
	gchar* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	GHashTable* _tmp105_ = NULL;
	gchar* _tmp106_ = NULL;
	gchar* _tmp107_ = NULL;
	GHashTable* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	gchar* _tmp110_ = NULL;
	GHashTable* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	gchar* _tmp113_ = NULL;
	GHashTable* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	GHashTable* _tmp117_ = NULL;
	gchar* _tmp118_ = NULL;
	gchar* _tmp119_ = NULL;
	GHashTable* _tmp120_ = NULL;
	gchar* _tmp121_ = NULL;
	gchar* _tmp122_ = NULL;
	GHashTable* _tmp123_ = NULL;
	gchar* _tmp124_ = NULL;
	gchar* _tmp125_ = NULL;
	GHashTable* _tmp126_ = NULL;
	gchar* _tmp127_ = NULL;
	gchar* _tmp128_ = NULL;
	GHashTable* _tmp129_ = NULL;
	gchar* _tmp130_ = NULL;
	gchar* _tmp131_ = NULL;
	GHashTable* _tmp132_ = NULL;
	gchar* _tmp133_ = NULL;
	gchar* _tmp134_ = NULL;
	GHashTable* _tmp135_ = NULL;
	gchar* _tmp136_ = NULL;
	gchar* _tmp137_ = NULL;
	GHashTable* _tmp138_ = NULL;
	gchar* _tmp139_ = NULL;
	gchar* _tmp140_ = NULL;
	GHashTable* _tmp141_ = NULL;
	gchar* _tmp142_ = NULL;
	gchar* _tmp143_ = NULL;
	GHashTable* _tmp144_ = NULL;
	gchar* _tmp145_ = NULL;
	gchar* _tmp146_ = NULL;
	GHashTable* _tmp147_ = NULL;
	gchar* _tmp148_ = NULL;
	gchar* _tmp149_ = NULL;
	GHashTable* _tmp150_ = NULL;
	gchar* _tmp151_ = NULL;
	gchar* _tmp152_ = NULL;
	GHashTable* _tmp153_ = NULL;
	gchar* _tmp154_ = NULL;
	gchar* _tmp155_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp156_ = NULL;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp161_ = NULL;
	gchar** _tmp162_ = NULL;
	gchar** _tmp163_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gboolean in_data = FALSE;
	gchar** _tmp164_ = NULL;
	gint _tmp164__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = name_map;
	_tmp4_ = g_strdup ("Euro");
	_tmp5_ = g_strdup ("EUR");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = name_map;
	_tmp7_ = g_strdup ("Japanese Yen");
	_tmp8_ = g_strdup ("JPY");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = name_map;
	_tmp10_ = g_strdup ("U.K. Pound Sterling");
	_tmp11_ = g_strdup ("GBP");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = name_map;
	_tmp13_ = g_strdup ("U.S. Dollar");
	_tmp14_ = g_strdup ("USD");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = name_map;
	_tmp16_ = g_strdup ("Algerian Dinar");
	_tmp17_ = g_strdup ("DZD");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = name_map;
	_tmp19_ = g_strdup ("Australian Dollar");
	_tmp20_ = g_strdup ("AUD");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = name_map;
	_tmp22_ = g_strdup ("Bahrain Dinar");
	_tmp23_ = g_strdup ("BHD");
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = name_map;
	_tmp25_ = g_strdup ("Botswana Pula");
	_tmp26_ = g_strdup ("BWP");
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = name_map;
	_tmp28_ = g_strdup ("Brazilian Real");
	_tmp29_ = g_strdup ("BRL");
	g_hash_table_insert (_tmp27_, _tmp28_, _tmp29_);
	_tmp30_ = name_map;
	_tmp31_ = g_strdup ("Brunei Dollar");
	_tmp32_ = g_strdup ("BND");
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
	_tmp33_ = name_map;
	_tmp34_ = g_strdup ("Canadian Dollar");
	_tmp35_ = g_strdup ("CAD");
	g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = name_map;
	_tmp37_ = g_strdup ("Chilean Peso");
	_tmp38_ = g_strdup ("CLP");
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = name_map;
	_tmp40_ = g_strdup ("Chinese Yuan");
	_tmp41_ = g_strdup ("CNY");
	g_hash_table_insert (_tmp39_, _tmp40_, _tmp41_);
	_tmp42_ = name_map;
	_tmp43_ = g_strdup ("Colombian Peso");
	_tmp44_ = g_strdup ("COP");
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp44_);
	_tmp45_ = name_map;
	_tmp46_ = g_strdup ("Czech Koruna");
	_tmp47_ = g_strdup ("CZK");
	g_hash_table_insert (_tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = name_map;
	_tmp49_ = g_strdup ("Danish Krone");
	_tmp50_ = g_strdup ("DKK");
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp50_);
	_tmp51_ = name_map;
	_tmp52_ = g_strdup ("Hungarian Forint");
	_tmp53_ = g_strdup ("HUF");
	g_hash_table_insert (_tmp51_, _tmp52_, _tmp53_);
	_tmp54_ = name_map;
	_tmp55_ = g_strdup ("Icelandic Krona");
	_tmp56_ = g_strdup ("ISK");
	g_hash_table_insert (_tmp54_, _tmp55_, _tmp56_);
	_tmp57_ = name_map;
	_tmp58_ = g_strdup ("Indian Rupee");
	_tmp59_ = g_strdup ("INR");
	g_hash_table_insert (_tmp57_, _tmp58_, _tmp59_);
	_tmp60_ = name_map;
	_tmp61_ = g_strdup ("Indonesian Rupiah");
	_tmp62_ = g_strdup ("IDR");
	g_hash_table_insert (_tmp60_, _tmp61_, _tmp62_);
	_tmp63_ = name_map;
	_tmp64_ = g_strdup ("Iranian Rial");
	_tmp65_ = g_strdup ("IRR");
	g_hash_table_insert (_tmp63_, _tmp64_, _tmp65_);
	_tmp66_ = name_map;
	_tmp67_ = g_strdup ("Israeli New Sheqel");
	_tmp68_ = g_strdup ("ILS");
	g_hash_table_insert (_tmp66_, _tmp67_, _tmp68_);
	_tmp69_ = name_map;
	_tmp70_ = g_strdup ("Kazakhstani Tenge");
	_tmp71_ = g_strdup ("KZT");
	g_hash_table_insert (_tmp69_, _tmp70_, _tmp71_);
	_tmp72_ = name_map;
	_tmp73_ = g_strdup ("Korean Won");
	_tmp74_ = g_strdup ("KRW");
	g_hash_table_insert (_tmp72_, _tmp73_, _tmp74_);
	_tmp75_ = name_map;
	_tmp76_ = g_strdup ("Kuwaiti Dinar");
	_tmp77_ = g_strdup ("KWD");
	g_hash_table_insert (_tmp75_, _tmp76_, _tmp77_);
	_tmp78_ = name_map;
	_tmp79_ = g_strdup ("Libyan Dinar");
	_tmp80_ = g_strdup ("LYD");
	g_hash_table_insert (_tmp78_, _tmp79_, _tmp80_);
	_tmp81_ = name_map;
	_tmp82_ = g_strdup ("Malaysian Ringgit");
	_tmp83_ = g_strdup ("MYR");
	g_hash_table_insert (_tmp81_, _tmp82_, _tmp83_);
	_tmp84_ = name_map;
	_tmp85_ = g_strdup ("Mauritian Rupee");
	_tmp86_ = g_strdup ("MUR");
	g_hash_table_insert (_tmp84_, _tmp85_, _tmp86_);
	_tmp87_ = name_map;
	_tmp88_ = g_strdup ("Mexican Peso");
	_tmp89_ = g_strdup ("MXN");
	g_hash_table_insert (_tmp87_, _tmp88_, _tmp89_);
	_tmp90_ = name_map;
	_tmp91_ = g_strdup ("Nepalese Rupee");
	_tmp92_ = g_strdup ("NPR");
	g_hash_table_insert (_tmp90_, _tmp91_, _tmp92_);
	_tmp93_ = name_map;
	_tmp94_ = g_strdup ("New Zealand Dollar");
	_tmp95_ = g_strdup ("NZD");
	g_hash_table_insert (_tmp93_, _tmp94_, _tmp95_);
	_tmp96_ = name_map;
	_tmp97_ = g_strdup ("Norwegian Krone");
	_tmp98_ = g_strdup ("NOK");
	g_hash_table_insert (_tmp96_, _tmp97_, _tmp98_);
	_tmp99_ = name_map;
	_tmp100_ = g_strdup ("Rial Omani");
	_tmp101_ = g_strdup ("OMR");
	g_hash_table_insert (_tmp99_, _tmp100_, _tmp101_);
	_tmp102_ = name_map;
	_tmp103_ = g_strdup ("Pakistani Rupee");
	_tmp104_ = g_strdup ("PKR");
	g_hash_table_insert (_tmp102_, _tmp103_, _tmp104_);
	_tmp105_ = name_map;
	_tmp106_ = g_strdup ("Nuevo Sol");
	_tmp107_ = g_strdup ("PEN");
	g_hash_table_insert (_tmp105_, _tmp106_, _tmp107_);
	_tmp108_ = name_map;
	_tmp109_ = g_strdup ("Philippine Peso");
	_tmp110_ = g_strdup ("PHP");
	g_hash_table_insert (_tmp108_, _tmp109_, _tmp110_);
	_tmp111_ = name_map;
	_tmp112_ = g_strdup ("Polish Zloty");
	_tmp113_ = g_strdup ("PLN");
	g_hash_table_insert (_tmp111_, _tmp112_, _tmp113_);
	_tmp114_ = name_map;
	_tmp115_ = g_strdup ("Qatar Riyal");
	_tmp116_ = g_strdup ("QAR");
	g_hash_table_insert (_tmp114_, _tmp115_, _tmp116_);
	_tmp117_ = name_map;
	_tmp118_ = g_strdup ("Russian Ruble");
	_tmp119_ = g_strdup ("RUB");
	g_hash_table_insert (_tmp117_, _tmp118_, _tmp119_);
	_tmp120_ = name_map;
	_tmp121_ = g_strdup ("Saudi Arabian Riyal");
	_tmp122_ = g_strdup ("SAR");
	g_hash_table_insert (_tmp120_, _tmp121_, _tmp122_);
	_tmp123_ = name_map;
	_tmp124_ = g_strdup ("Singapore Dollar");
	_tmp125_ = g_strdup ("SGD");
	g_hash_table_insert (_tmp123_, _tmp124_, _tmp125_);
	_tmp126_ = name_map;
	_tmp127_ = g_strdup ("South African Rand");
	_tmp128_ = g_strdup ("ZAR");
	g_hash_table_insert (_tmp126_, _tmp127_, _tmp128_);
	_tmp129_ = name_map;
	_tmp130_ = g_strdup ("Sri Lanka Rupee");
	_tmp131_ = g_strdup ("LKR");
	g_hash_table_insert (_tmp129_, _tmp130_, _tmp131_);
	_tmp132_ = name_map;
	_tmp133_ = g_strdup ("Swedish Krona");
	_tmp134_ = g_strdup ("SEK");
	g_hash_table_insert (_tmp132_, _tmp133_, _tmp134_);
	_tmp135_ = name_map;
	_tmp136_ = g_strdup ("Swiss Franc");
	_tmp137_ = g_strdup ("CHF");
	g_hash_table_insert (_tmp135_, _tmp136_, _tmp137_);
	_tmp138_ = name_map;
	_tmp139_ = g_strdup ("Thai Baht");
	_tmp140_ = g_strdup ("THB");
	g_hash_table_insert (_tmp138_, _tmp139_, _tmp140_);
	_tmp141_ = name_map;
	_tmp142_ = g_strdup ("Trinidad And Tobago Dollar");
	_tmp143_ = g_strdup ("TTD");
	g_hash_table_insert (_tmp141_, _tmp142_, _tmp143_);
	_tmp144_ = name_map;
	_tmp145_ = g_strdup ("Tunisian Dinar");
	_tmp146_ = g_strdup ("TND");
	g_hash_table_insert (_tmp144_, _tmp145_, _tmp146_);
	_tmp147_ = name_map;
	_tmp148_ = g_strdup ("U.A.E. Dirham");
	_tmp149_ = g_strdup ("AED");
	g_hash_table_insert (_tmp147_, _tmp148_, _tmp149_);
	_tmp150_ = name_map;
	_tmp151_ = g_strdup ("Peso Uruguayo");
	_tmp152_ = g_strdup ("UYU");
	g_hash_table_insert (_tmp150_, _tmp151_, _tmp152_);
	_tmp153_ = name_map;
	_tmp154_ = g_strdup ("Bolivar Fuerte");
	_tmp155_ = g_strdup ("VEF");
	g_hash_table_insert (_tmp153_, _tmp154_, _tmp155_);
	_tmp156_ = currency_manager_get_imf_rate_filepath (self);
	filename = _tmp156_;
	{
		const gchar* _tmp157_ = NULL;
		gchar* _tmp158_ = NULL;
		_tmp157_ = filename;
		g_file_get_contents (_tmp157_, &_tmp158_, NULL, &_inner_error_);
		_g_free0 (data);
		data = _tmp158_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp159_ = NULL;
		const gchar* _tmp160_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp159_ = e;
		_tmp160_ = _tmp159_->message;
		g_warning ("currency.vala:224: Failed to read exchange rates: %s", _tmp160_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (filename);
		_g_hash_table_unref0 (name_map);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_free0 (filename);
		_g_hash_table_unref0 (name_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp161_ = data;
	_tmp163_ = _tmp162_ = g_strsplit (_tmp161_, "\n", 0);
	lines = _tmp163_;
	lines_length1 = _vala_array_length (_tmp162_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp164_ = lines;
	_tmp164__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp164_;
		line_collection_length1 = _tmp164__length1;
		for (line_it = 0; line_it < _tmp164__length1; line_it = line_it + 1) {
			gchar* _tmp165_ = NULL;
			gchar* line = NULL;
			_tmp165_ = g_strdup (line_collection[line_it]);
			line = _tmp165_;
			{
				const gchar* _tmp166_ = NULL;
				gchar* _tmp167_ = NULL;
				const gchar* _tmp168_ = NULL;
				gboolean _tmp170_ = FALSE;
				gchar** tokens = NULL;
				const gchar* _tmp171_ = NULL;
				gchar** _tmp172_ = NULL;
				gchar** _tmp173_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar** _tmp174_ = NULL;
				gint _tmp174__length1 = 0;
				const gchar* _tmp175_ = NULL;
				_tmp166_ = line;
				_tmp167_ = string_chug (_tmp166_);
				_g_free0 (line);
				line = _tmp167_;
				_tmp168_ = line;
				if (g_strcmp0 (_tmp168_, "") == 0) {
					gboolean _tmp169_ = FALSE;
					_tmp169_ = in_data;
					if (!_tmp169_) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				_tmp170_ = in_data;
				if (!_tmp170_) {
					_g_free0 (line);
					continue;
				}
				_tmp171_ = line;
				_tmp173_ = _tmp172_ = g_strsplit (_tmp171_, "\t", 0);
				tokens = _tmp173_;
				tokens_length1 = _vala_array_length (_tmp172_);
				_tokens_size_ = tokens_length1;
				_tmp174_ = tokens;
				_tmp174__length1 = tokens_length1;
				_tmp175_ = _tmp174_[0];
				if (g_strcmp0 (_tmp175_, "Currency") != 0) {
					gint value_index = 0;
					gint _tmp185_ = 0;
					gchar** _tmp186_ = NULL;
					gint _tmp186__length1 = 0;
					{
						gboolean _tmp176_ = FALSE;
						value_index = 1;
						_tmp176_ = TRUE;
						while (TRUE) {
							gint _tmp178_ = 0;
							gchar** _tmp179_ = NULL;
							gint _tmp179__length1 = 0;
							gchar* value = NULL;
							gchar** _tmp180_ = NULL;
							gint _tmp180__length1 = 0;
							gint _tmp181_ = 0;
							const gchar* _tmp182_ = NULL;
							gchar* _tmp183_ = NULL;
							const gchar* _tmp184_ = NULL;
							if (!_tmp176_) {
								gint _tmp177_ = 0;
								_tmp177_ = value_index;
								value_index = _tmp177_ + 1;
							}
							_tmp176_ = FALSE;
							_tmp178_ = value_index;
							_tmp179_ = tokens;
							_tmp179__length1 = tokens_length1;
							if (!(_tmp178_ < _tmp179__length1)) {
								break;
							}
							_tmp180_ = tokens;
							_tmp180__length1 = tokens_length1;
							_tmp181_ = value_index;
							_tmp182_ = _tmp180_[_tmp181_];
							_tmp183_ = string_chug (_tmp182_);
							value = _tmp183_;
							_tmp184_ = value;
							if (g_strcmp0 (_tmp184_, "") != 0) {
								_g_free0 (value);
								break;
							}
							_g_free0 (value);
						}
					}
					_tmp185_ = value_index;
					_tmp186_ = tokens;
					_tmp186__length1 = tokens_length1;
					if (_tmp185_ < _tmp186__length1) {
						gchar* symbol = NULL;
						GHashTable* _tmp187_ = NULL;
						gchar** _tmp188_ = NULL;
						gint _tmp188__length1 = 0;
						const gchar* _tmp189_ = NULL;
						gconstpointer _tmp190_ = NULL;
						gchar* _tmp191_ = NULL;
						const gchar* _tmp192_ = NULL;
						_tmp187_ = name_map;
						_tmp188_ = tokens;
						_tmp188__length1 = tokens_length1;
						_tmp189_ = _tmp188_[0];
						_tmp190_ = g_hash_table_lookup (_tmp187_, _tmp189_);
						_tmp191_ = g_strdup ((const gchar*) _tmp190_);
						symbol = _tmp191_;
						_tmp192_ = symbol;
						if (_tmp192_ != NULL) {
							Currency* c = NULL;
							const gchar* _tmp193_ = NULL;
							Currency* _tmp194_ = NULL;
							Currency* _tmp195_ = NULL;
							Number* value = NULL;
							gchar** _tmp202_ = NULL;
							gint _tmp202__length1 = 0;
							gint _tmp203_ = 0;
							const gchar* _tmp204_ = NULL;
							Number* _tmp205_ = NULL;
							Number* _tmp206_ = NULL;
							Number* _tmp207_ = NULL;
							Currency* _tmp208_ = NULL;
							Number* _tmp209_ = NULL;
							_tmp193_ = symbol;
							_tmp194_ = currency_manager_get_currency (self, _tmp193_);
							c = _tmp194_;
							_tmp195_ = c;
							if (_tmp195_ == NULL) {
								gchar** _tmp196_ = NULL;
								gint _tmp196__length1 = 0;
								gint _tmp197_ = 0;
								const gchar* _tmp198_ = NULL;
								const gchar* _tmp199_ = NULL;
								const gchar* _tmp200_ = NULL;
								Currency* _tmp201_ = NULL;
								_tmp196_ = tokens;
								_tmp196__length1 = tokens_length1;
								_tmp197_ = value_index;
								_tmp198_ = _tmp196_[_tmp197_];
								_tmp199_ = symbol;
								g_debug ("currency.vala:268: Using IMF rate of %s for %s", _tmp198_, _tmp199_);
								_tmp200_ = symbol;
								_tmp201_ = currency_manager_add_currency (self, _tmp200_);
								_g_object_unref0 (c);
								c = _tmp201_;
							}
							_tmp202_ = tokens;
							_tmp202__length1 = tokens_length1;
							_tmp203_ = value_index;
							_tmp204_ = _tmp202_[_tmp203_];
							_tmp205_ = mp_set_from_string (_tmp204_, 10);
							value = _tmp205_;
							_tmp206_ = value;
							_tmp207_ = number_reciprocal (_tmp206_);
							_g_object_unref0 (value);
							value = _tmp207_;
							_tmp208_ = c;
							_tmp209_ = value;
							currency_set_value (_tmp208_, _tmp209_);
							_g_object_unref0 (value);
							_g_object_unref0 (c);
						} else {
							gchar** _tmp210_ = NULL;
							gint _tmp210__length1 = 0;
							const gchar* _tmp211_ = NULL;
							_tmp210_ = tokens;
							_tmp210__length1 = tokens_length1;
							_tmp211_ = _tmp210_[0];
							g_warning ("currency.vala:276: Unknown currency '%s'", _tmp211_);
						}
						_g_free0 (symbol);
					}
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_free0 (filename);
	_g_hash_table_unref0 (name_map);
}


static void currency_manager_set_ecb_rate (CurrencyManager* self, xmlNode* node, Currency* eur_rate) {
	gchar* name = NULL;
	gchar* value = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (eur_rate != NULL);
	name = NULL;
	value = NULL;
	{
		xmlAttr* attribute = NULL;
		xmlNode* _tmp0_ = NULL;
		xmlAttr* _tmp1_ = NULL;
		_tmp0_ = node;
		_tmp1_ = _tmp0_->properties;
		attribute = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_ = NULL;
				xmlNode* n = NULL;
				xmlAttr* _tmp6_ = NULL;
				xmlAttr* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				if (!_tmp2_) {
					xmlAttr* _tmp3_ = NULL;
					xmlAttr* _tmp4_ = NULL;
					_tmp3_ = attribute;
					_tmp4_ = _tmp3_->next;
					attribute = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = attribute;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = attribute;
				n = (xmlNode*) _tmp6_;
				_tmp7_ = attribute;
				_tmp8_ = _tmp7_->name;
				if (g_strcmp0 (_tmp8_, "currency") == 0) {
					xmlNode* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					_tmp9_ = n;
					_tmp10_ = (gchar*) xmlNodeGetContent (_tmp9_);
					_g_free0 (name);
					name = _tmp10_;
				} else {
					xmlAttr* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					_tmp11_ = attribute;
					_tmp12_ = _tmp11_->name;
					if (g_strcmp0 (_tmp12_, "rate") == 0) {
						xmlNode* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						_tmp13_ = n;
						_tmp14_ = (gchar*) xmlNodeGetContent (_tmp13_);
						_g_free0 (value);
						value = _tmp14_;
					}
				}
			}
		}
	}
	_tmp17_ = name;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = value;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_ = NULL;
		Currency* _tmp20_ = NULL;
		Currency* _tmp21_ = NULL;
		_tmp19_ = name;
		_tmp20_ = currency_manager_get_currency (self, _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_ == NULL;
		_g_object_unref0 (_tmp21_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		Currency* c = NULL;
		const gchar* _tmp24_ = NULL;
		Currency* _tmp25_ = NULL;
		Number* r = NULL;
		const gchar* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* v = NULL;
		Currency* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Currency* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		_tmp22_ = value;
		_tmp23_ = name;
		g_debug ("currency.vala:298: Using ECB rate of %s for %s", _tmp22_, _tmp23_);
		_tmp24_ = name;
		_tmp25_ = currency_manager_add_currency (self, _tmp24_);
		c = _tmp25_;
		_tmp26_ = value;
		_tmp27_ = mp_set_from_string (_tmp26_, 10);
		r = _tmp27_;
		_tmp28_ = eur_rate;
		_tmp29_ = currency_get_value (_tmp28_);
		v = _tmp29_;
		_tmp30_ = v;
		_tmp31_ = r;
		_tmp32_ = number_multiply (_tmp30_, _tmp31_);
		_g_object_unref0 (v);
		v = _tmp32_;
		_tmp33_ = c;
		_tmp34_ = v;
		currency_set_value (_tmp33_, _tmp34_);
		_g_object_unref0 (v);
		_g_object_unref0 (r);
		_g_object_unref0 (c);
	}
	_g_free0 (value);
	_g_free0 (name);
}


static void currency_manager_set_ecb_fixed_rate (CurrencyManager* self, const gchar* name, const gchar* value, Currency* eur_rate) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Currency* c = NULL;
	const gchar* _tmp2_ = NULL;
	Currency* _tmp3_ = NULL;
	Number* r = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* v = NULL;
	Currency* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (eur_rate != NULL);
	_tmp0_ = value;
	_tmp1_ = name;
	g_debug ("currency.vala:309: Using ECB fixed rate of %s for %s", _tmp0_, _tmp1_);
	_tmp2_ = name;
	_tmp3_ = currency_manager_add_currency (self, _tmp2_);
	c = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = mp_set_from_string (_tmp4_, 10);
	r = _tmp5_;
	_tmp6_ = eur_rate;
	_tmp7_ = currency_get_value (_tmp6_);
	v = _tmp7_;
	_tmp8_ = v;
	_tmp9_ = number_divide (_tmp8_, r);
	_g_object_unref0 (v);
	v = _tmp9_;
	_tmp10_ = v;
	currency_set_value (c, _tmp10_);
	_g_object_unref0 (v);
	_g_object_unref0 (r);
	_g_object_unref0 (c);
}


static void currency_manager_load_ecb_rates (CurrencyManager* self) {
	Currency* eur_rate = NULL;
	Currency* _tmp0_ = NULL;
	Currency* _tmp1_ = NULL;
	Currency* _tmp2_ = NULL;
	Currency* _tmp3_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp4_ = NULL;
	xmlDoc* document = NULL;
	const gchar* _tmp5_ = NULL;
	xmlDoc* _tmp6_ = NULL;
	xmlDoc* _tmp7_ = NULL;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp9_ = NULL;
	xmlXPathContext* _tmp10_ = NULL;
	xmlXPathContext* _tmp11_ = NULL;
	xmlXPathContext* _tmp12_ = NULL;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp13_ = NULL;
	xmlXPathObject* _tmp14_ = NULL;
	xmlXPathObject* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	xmlXPathObject* _tmp17_ = NULL;
	xmlNodeSet* _tmp18_ = NULL;
	gint len = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = currency_manager_get_currency (self, "EUR");
	eur_rate = _tmp0_;
	_tmp1_ = eur_rate;
	if (_tmp1_ == NULL) {
		g_warning ("currency.vala:323: Cannot use ECB rates as don't have EUR rate");
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp2_ = eur_rate;
	currency_manager_set_ecb_fixed_rate (self, "EEK", "0.06391", _tmp2_);
	_tmp3_ = eur_rate;
	currency_manager_set_ecb_fixed_rate (self, "CFA", "0.152449", _tmp3_);
	xmlInitParser ();
	_tmp4_ = currency_manager_get_ecb_rate_filepath (self);
	filename = _tmp4_;
	_tmp5_ = filename;
	_tmp6_ = xmlReadFile (_tmp5_, NULL, 0);
	document = _tmp6_;
	_tmp7_ = document;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = filename;
		g_warning ("currency.vala:336: Couldn't parse ECB rate file %s", _tmp8_);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp9_ = document;
	_tmp10_ = xmlXPathNewContext (_tmp9_);
	xpath_ctx = _tmp10_;
	_tmp11_ = xpath_ctx;
	if (_tmp11_ == NULL) {
		g_warning ("currency.vala:343: Couldn't create XPath context");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp12_ = xpath_ctx;
	xmlXPathRegisterNs (_tmp12_, (xmlChar*) "xref", (xmlChar*) "http://www.ecb.int/vocabulary/2002-08-01/eurofxref");
	_tmp13_ = xpath_ctx;
	_tmp14_ = xmlXPathEvalExpression ((xmlChar*) "//xref:Cube[@currency][@rate]", _tmp13_);
	xpath_obj = _tmp14_;
	_tmp15_ = xpath_obj;
	if (_tmp15_ == NULL) {
		g_warning ("currency.vala:351: Couldn't create XPath object");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp17_ = xpath_obj;
	_tmp18_ = _tmp17_->nodesetval;
	if (_tmp18_ != NULL) {
		xmlXPathObject* _tmp19_ = NULL;
		xmlNodeSet* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		_tmp19_ = xpath_obj;
		_tmp20_ = _tmp19_->nodesetval;
		_tmp21_ = xmlXPathNodeSetGetLength (_tmp20_);
		_tmp16_ = _tmp21_;
	} else {
		_tmp16_ = 0;
	}
	len = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp26_ = NULL;
				xmlNodeSet* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				xmlNode* _tmp29_ = NULL;
				xmlNode* _tmp30_ = NULL;
				xmlElementType _tmp31_ = 0;
				xmlNode* _tmp34_ = NULL;
				xmlElementType _tmp35_ = 0;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = len;
				if (!(_tmp24_ < _tmp25_)) {
					break;
				}
				_tmp26_ = xpath_obj;
				_tmp27_ = _tmp26_->nodesetval;
				_tmp28_ = i;
				_tmp29_ = xmlXPathNodeSetItem (_tmp27_, _tmp28_);
				node = _tmp29_;
				_tmp30_ = node;
				_tmp31_ = _tmp30_->type;
				if (_tmp31_ == XML_ELEMENT_NODE) {
					xmlNode* _tmp32_ = NULL;
					Currency* _tmp33_ = NULL;
					_tmp32_ = node;
					_tmp33_ = eur_rate;
					currency_manager_set_ecb_rate (self, _tmp32_, _tmp33_);
				}
				_tmp34_ = node;
				_tmp35_ = _tmp34_->type;
				if (_tmp35_ != XML_NAMESPACE_DECL) {
					node = NULL;
				}
			}
		}
	}
	xmlCleanupParser ();
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_free0 (filename);
	_g_object_unref0 (eur_rate);
}


static void currency_manager_download_rates (CurrencyManager* self) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = currency_manager_get_imf_rate_filepath (self);
	path = _tmp0_;
	_tmp2_ = downloading_imf_rates;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = path;
		_tmp4_ = currency_manager_file_needs_update (self, _tmp3_, (gdouble) (((60 * 60) * 24) * 7));
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp5_ = NULL;
		downloading_imf_rates = TRUE;
		g_debug ("currency.vala:377: Downloading rates from the IMF...");
		_tmp5_ = path;
		currency_manager_download_file (self, "https://www.imf.org/external/np/fin/data/rms_five.aspx?tsvflag=Y", _tmp5_, "IMF", NULL, NULL);
	}
	_tmp6_ = currency_manager_get_ecb_rate_filepath (self);
	_g_free0 (path);
	path = _tmp6_;
	_tmp8_ = downloading_ecb_rates;
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = path;
		_tmp10_ = currency_manager_file_needs_update (self, _tmp9_, (gdouble) (((60 * 60) * 24) * 7));
		_tmp7_ = _tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp11_ = NULL;
		downloading_ecb_rates = TRUE;
		g_debug ("currency.vala:384: Downloading rates from the ECB...");
		_tmp11_ = path;
		currency_manager_download_file (self, "https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml", _tmp11_, "ECB", NULL, NULL);
	}
	_g_free0 (path);
}


static gboolean currency_manager_load_rates (CurrencyManager* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GList* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = loaded_rates;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = downloading_imf_rates;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = downloading_ecb_rates;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	currency_manager_load_imf_rates (self);
	currency_manager_load_ecb_rates (self);
	_tmp4_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp4_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp5_ = NULL;
			Currency* c = NULL;
			_tmp5_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				Currency* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp7_ = c;
				_tmp8_ = currency_get_value (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_ == NULL;
				_g_object_unref0 (_tmp9_);
				if (_tmp10_) {
					_tmp6_ = TRUE;
				} else {
					Currency* _tmp11_ = NULL;
					Number* _tmp12_ = NULL;
					Number* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					_tmp11_ = c;
					_tmp12_ = currency_get_value (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = number_is_zero (_tmp13_);
					_tmp6_ = _tmp14_;
					_g_object_unref0 (_tmp13_);
				}
				if (_tmp6_) {
					Currency* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp15_ = c;
					_tmp16_ = currency_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = _tmp17_;
					g_warning ("currency.vala:406: Currency %s is not provided by IMF or ECB", _tmp18_);
					_g_free0 (_tmp18_);
				}
				_g_object_unref0 (c);
			}
		}
	}
	g_debug ("currency.vala:408: Rates loaded");
	loaded_rates = TRUE;
	g_signal_emit_by_name (self, "updated");
	result = TRUE;
	return result;
}


Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Currency* c = NULL;
	const gchar* _tmp1_ = NULL;
	Currency* _tmp2_ = NULL;
	Currency* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (currency != NULL, NULL);
	currency_manager_download_rates (self);
	_tmp0_ = currency_manager_load_rates (self);
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = currency;
	_tmp2_ = currency_manager_get_currency (self, _tmp1_);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		Currency* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		_tmp4_ = c;
		_tmp5_ = currency_get_value (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (c);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (c);
		return result;
	}
	_g_object_unref0 (c);
}


static void currency_manager_download_file_data_free (gpointer _data) {
	CurrencyManagerDownloadFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (CurrencyManagerDownloadFileData, _data_);
}


static void currency_manager_download_file (CurrencyManager* self, const gchar* uri, const gchar* filename, const gchar* source, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CurrencyManagerDownloadFileData* _data_;
	CurrencyManager* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_data_ = g_slice_new0 (CurrencyManagerDownloadFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, currency_manager_download_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, currency_manager_download_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp2_;
	_tmp3_ = filename;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp4_;
	_tmp5_ = source;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->source);
	_data_->source = _tmp6_;
	currency_manager_download_file_co (_data_);
}


static void currency_manager_download_file_finish (CurrencyManager* self, GAsyncResult* _res_) {
	CurrencyManagerDownloadFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void currency_manager_download_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	CurrencyManagerDownloadFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	currency_manager_download_file_co (_data_);
}


static gboolean currency_manager_download_file_co (CurrencyManagerDownloadFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->filename;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_path_get_dirname (_data_->_tmp0_);
	_data_->directory = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp2_, 0755);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->filename;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
	_data_->dest = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = soup_session_new ();
	_data_->session = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->uri;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = soup_message_new ("GET", _data_->_tmp6_);
	_data_->message = _data_->_tmp7_;
	{
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->session;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->message;
		_data_->_state_ = 1;
		soup_session_send_async (_data_->_tmp8_, _data_->_tmp9_, NULL, currency_manager_download_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = soup_session_send_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
		_data_->bodyinput = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->dest;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp11_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, currency_manager_download_file_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_file_replace_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		_data_->output = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->bodyinput);
			goto __catch1_g_error;
		}
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->output;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->bodyinput;
		_data_->_state_ = 3;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp13_, _data_->_tmp14_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, NULL, currency_manager_download_file_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->bodyinput);
			goto __catch1_g_error;
		}
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->source;
		if (g_strcmp0 (_data_->_tmp15_, "IMF") == 0) {
			downloading_imf_rates = FALSE;
		} else {
			downloading_ecb_rates = FALSE;
		}
		currency_manager_load_rates (_data_->self);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->source;
		g_debug ("currency.vala:453: %s rates updated", _data_->_tmp16_);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->bodyinput);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->source;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("currency.vala:457: Couldn't download %s currency rate file: %s", _data_->_tmp17_, _data_->_tmp19_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->dest);
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->session);
	_g_object_unref0 (_data_->dest);
	_g_free0 (_data_->directory);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


CurrencyManager* currency_manager_construct (GType object_type) {
	CurrencyManager * self = NULL;
	self = (CurrencyManager*) g_object_new (object_type, NULL);
	return self;
}


CurrencyManager* currency_manager_new (void) {
	return currency_manager_construct (TYPE_CURRENCY_MANAGER);
}


static void currency_manager_class_init (CurrencyManagerClass * klass) {
	currency_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CurrencyManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = currency_manager_finalize;
	g_signal_new ("updated", TYPE_CURRENCY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void currency_manager_instance_init (CurrencyManager * self) {
	self->priv = CURRENCY_MANAGER_GET_PRIVATE (self);
}


static void currency_manager_finalize (GObject* obj) {
	CurrencyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY_MANAGER, CurrencyManager);
	__g_list_free__g_object_unref0_0 (self->priv->currencies);
	G_OBJECT_CLASS (currency_manager_parent_class)->finalize (obj);
}


GType currency_manager_get_type (void) {
	static volatile gsize currency_manager_type_id__volatile = 0;
	if (g_once_init_enter (&currency_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CurrencyManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CurrencyManager), 0, (GInstanceInitFunc) currency_manager_instance_init, NULL };
		GType currency_manager_type_id;
		currency_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CurrencyManager", &g_define_type_info, 0);
		g_once_init_leave (&currency_manager_type_id__volatile, currency_manager_type_id);
	}
	return currency_manager_type_id__volatile;
}


Currency* currency_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* symbol) {
	Currency * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (Currency*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp3_;
	_tmp4_ = symbol;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_symbol);
	self->priv->_symbol = _tmp5_;
	return self;
}


Currency* currency_new (const gchar* name, const gchar* display_name, const gchar* symbol) {
	return currency_construct (TYPE_CURRENCY, name, display_name, symbol);
}


void currency_set_value (Currency* self, Number* value) {
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->value);
	self->priv->value = _tmp1_;
}


Number* currency_get_value (Currency* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_name (Currency* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_display_name (Currency* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_symbol (Currency* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void currency_class_init (CurrencyClass * klass) {
	currency_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CurrencyPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_currency_get_property;
	G_OBJECT_CLASS (klass)->finalize = currency_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_SYMBOL, g_param_spec_string ("symbol", "symbol", "symbol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void currency_instance_init (Currency * self) {
	self->priv = CURRENCY_GET_PRIVATE (self);
}


static void currency_finalize (GObject* obj) {
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY, Currency);
	_g_object_unref0 (self->priv->value);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_symbol);
	G_OBJECT_CLASS (currency_parent_class)->finalize (obj);
}


GType currency_get_type (void) {
	static volatile gsize currency_type_id__volatile = 0;
	if (g_once_init_enter (&currency_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CurrencyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Currency), 0, (GInstanceInitFunc) currency_instance_init, NULL };
		GType currency_type_id;
		currency_type_id = g_type_register_static (G_TYPE_OBJECT, "Currency", &g_define_type_info, 0);
		g_once_init_leave (&currency_type_id__volatile, currency_type_id);
	}
	return currency_type_id__volatile;
}


static void _vala_currency_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY, Currency);
	switch (property_id) {
		case CURRENCY_NAME:
		g_value_take_string (value, currency_get_name (self));
		break;
		case CURRENCY_DISPLAY_NAME:
		g_value_take_string (value, currency_get_display_name (self));
		break;
		case CURRENCY_SYMBOL:
		g_value_take_string (value, currency_get_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



