/* math-window.c generated by valac 0.30.0.14-c43a, the Vala compiler
 * generated from math-window.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksource.h>


#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;
typedef struct _MathWindowPrivate MathWindowPrivate;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUTTON_MODE (button_mode_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MathWindow {
	GtkApplicationWindow parent_instance;
	MathWindowPrivate * priv;
};

struct _MathWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MathWindowPrivate {
	MathEquation* _equation;
	MathDisplay* _display;
	MathButtons* _buttons;
	gboolean right_aligned;
	gboolean remove_buttons;
	GtkMenuButton* menu_button;
	GtkLabel* mode_label;
	GtkScrolledWindow* scrolled_window;
	GtkGrid* grid;
	MathConverter* converter;
};

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;


static gpointer math_window_parent_class = NULL;

GType math_window_get_type (void) G_GNUC_CONST;
GType math_display_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_WINDOW, MathWindowPrivate))
enum  {
	MATH_WINDOW_DUMMY_PROPERTY,
	MATH_WINDOW_EQUATION,
	MATH_WINDOW_DISPLAY,
	MATH_WINDOW_BUTTONS
};
static void math_window_copy_cb (MathWindow* self);
static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_paste_cb (MathWindow* self);
static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_undo_cb (MathWindow* self);
static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_redo_cb (MathWindow* self);
static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void math_window_mode_cb (MathWindow* self, GSimpleAction* action, GVariant* parameter);
static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
void math_converter_set_equation (MathConverter* self, MathEquation* equation);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
void math_display_grabfocus (MathDisplay* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
GType button_mode_get_type (void) G_GNUC_CONST;
ButtonMode math_buttons_get_mode (MathButtons* self);
static void math_window_mode_changed_cb (MathWindow* self);
static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
MathButtons* math_window_get_buttons (MathWindow* self);
void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents);
static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
MathEquation* math_window_get_equation (MathWindow* self);
static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self);
static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment);
static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
MathDisplay* math_window_get_display (MathWindow* self);
void math_display_grab_focus (MathDisplay* self);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void math_window_finalize (GObject* obj);
static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);

static const GActionEntry MATH_WINDOW_window_entries[5] = {{"copy", _math_window_copy_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"paste", _math_window_paste_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"undo", _math_window_undo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"redo", _math_window_redo_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"mode", _math_window_mode_cb_gsimple_action_activate_callback, "s", "\"basic\"", NULL}};

static void _math_window_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_copy_cb ((MathWindow*) self);
}


static void _math_window_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_paste_cb ((MathWindow*) self);
}


static void _math_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_undo_cb ((MathWindow*) self);
}


static void _math_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_redo_cb ((MathWindow*) self);
}


static void _math_window_mode_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	math_window_mode_cb ((MathWindow*) self, action, parameter);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _math_window_mode_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	math_window_mode_changed_cb ((MathWindow*) self);
}


MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation) {
	MathWindow * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathConverter* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathConverter* _tmp5_ = NULL;
	MathConverter* _tmp6_ = NULL;
	MathEquation* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	MathEquation* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	MathEquation* _tmp15_ = NULL;
	MathDisplay* _tmp16_ = NULL;
	GtkScrolledWindow* _tmp17_ = NULL;
	MathDisplay* _tmp18_ = NULL;
	MathDisplay* _tmp19_ = NULL;
	MathDisplay* _tmp20_ = NULL;
	MathEquation* _tmp21_ = NULL;
	MathButtons* _tmp22_ = NULL;
	GtkGrid* _tmp23_ = NULL;
	MathButtons* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	MathButtons* _tmp26_ = NULL;
	ButtonMode _tmp27_ = 0;
	ButtonMode _tmp28_ = 0;
	MathButtons* _tmp29_ = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp30_ = NULL;
	GdkScreen* _tmp31_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = app;
	self = (MathWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_tmp1_ = equation;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp2_;
	self->priv->right_aligned = TRUE;
	g_action_map_add_action_entries ((GActionMap*) self, MATH_WINDOW_window_entries, G_N_ELEMENTS (MATH_WINDOW_window_entries), self);
	_tmp3_ = self->priv->converter;
	_tmp4_ = self->priv->_equation;
	math_converter_set_equation (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->converter;
	math_converter_set_category (_tmp5_, NULL);
	_tmp6_ = self->priv->converter;
	_tmp7_ = equation;
	_tmp8_ = math_equation_get_source_units (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = equation;
	_tmp12_ = math_equation_get_target_units (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	math_converter_set_conversion (_tmp6_, _tmp10_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp10_);
	_tmp15_ = equation;
	_tmp16_ = math_display_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp16_;
	_tmp17_ = self->priv->scrolled_window;
	_tmp18_ = self->priv->_display;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->_display;
	gtk_widget_show ((GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->_display;
	math_display_grabfocus (_tmp20_);
	_tmp21_ = equation;
	_tmp22_ = math_buttons_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->_buttons);
	self->priv->_buttons = _tmp22_;
	_tmp23_ = self->priv->grid;
	_tmp24_ = self->priv->_buttons;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp26_ = self->priv->_buttons;
	_tmp27_ = math_buttons_get_mode (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != BUTTON_MODE_KEYBOARD) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = FALSE;
	}
	self->priv->remove_buttons = _tmp25_;
	_tmp29_ = self->priv->_buttons;
	g_signal_connect_object ((GObject*) _tmp29_, "notify::mode", (GCallback) _math_window_mode_changed_cb_g_object_notify, self, 0);
	math_window_mode_changed_cb (self);
	_tmp30_ = gtk_css_provider_new ();
	provider = _tmp30_;
	gtk_css_provider_load_from_resource (provider, "/org/gnome/calculator/calculator.css");
	_tmp31_ = gtk_window_get_screen ((GtkWindow*) self);
	gtk_style_context_add_provider_for_screen (_tmp31_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
	return self;
}


MathWindow* math_window_new (GtkApplication* app, MathEquation* equation) {
	return math_window_construct (TYPE_MATH_WINDOW, app, equation);
}


static void math_window_mode_changed_cb (MathWindow* self) {
	GSimpleAction* action = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	MathButtons* _tmp2_ = NULL;
	MathButtons* _tmp3_ = NULL;
	ButtonMode _tmp4_ = 0;
	ButtonMode _tmp5_ = 0;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	action = _tmp1_;
	_tmp2_ = math_window_get_buttons (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_buttons_get_mode (_tmp3_);
	_tmp5_ = _tmp4_;
	switch (_tmp5_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GSimpleAction* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
			_tmp6_ = self->priv->mode_label;
			_tmp7_ = _ ("Basic Mode");
			gtk_label_set_label (_tmp6_, _tmp7_);
			_tmp8_ = action;
			_tmp9_ = g_variant_new_string ("basic");
			g_variant_ref_sink (_tmp9_);
			_tmp10_ = _tmp9_;
			g_simple_action_set_state (_tmp8_, _tmp10_);
			_g_variant_unref0 (_tmp10_);
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GSimpleAction* _tmp13_ = NULL;
			GVariant* _tmp14_ = NULL;
			GVariant* _tmp15_ = NULL;
			_tmp11_ = self->priv->mode_label;
			_tmp12_ = _ ("Advanced Mode");
			gtk_label_set_label (_tmp11_, _tmp12_);
			_tmp13_ = action;
			_tmp14_ = g_variant_new_string ("advanced");
			g_variant_ref_sink (_tmp14_);
			_tmp15_ = _tmp14_;
			g_simple_action_set_state (_tmp13_, _tmp15_);
			_g_variant_unref0 (_tmp15_);
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkLabel* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GSimpleAction* _tmp18_ = NULL;
			GVariant* _tmp19_ = NULL;
			GVariant* _tmp20_ = NULL;
			_tmp16_ = self->priv->mode_label;
			_tmp17_ = _ ("Financial Mode");
			gtk_label_set_label (_tmp16_, _tmp17_);
			_tmp18_ = action;
			_tmp19_ = g_variant_new_string ("financial");
			g_variant_ref_sink (_tmp19_);
			_tmp20_ = _tmp19_;
			g_simple_action_set_state (_tmp18_, _tmp20_);
			_g_variant_unref0 (_tmp20_);
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkLabel* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GSimpleAction* _tmp23_ = NULL;
			GVariant* _tmp24_ = NULL;
			GVariant* _tmp25_ = NULL;
			_tmp21_ = self->priv->mode_label;
			_tmp22_ = _ ("Programming Mode");
			gtk_label_set_label (_tmp21_, _tmp22_);
			_tmp23_ = action;
			_tmp24_ = g_variant_new_string ("programming");
			g_variant_ref_sink (_tmp24_);
			_tmp25_ = _tmp24_;
			g_simple_action_set_state (_tmp23_, _tmp25_);
			_g_variant_unref0 (_tmp25_);
			break;
		}
		case BUTTON_MODE_KEYBOARD:
		{
			GtkLabel* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			GSimpleAction* _tmp28_ = NULL;
			GVariant* _tmp29_ = NULL;
			GVariant* _tmp30_ = NULL;
			_tmp26_ = self->priv->mode_label;
			_tmp27_ = _ ("Keyboard Mode");
			gtk_label_set_label (_tmp26_, _tmp27_);
			_tmp28_ = action;
			_tmp29_ = g_variant_new_string ("keyboard");
			g_variant_ref_sink (_tmp29_);
			_tmp30_ = _tmp29_;
			g_simple_action_set_state (_tmp28_, _tmp30_);
			_g_variant_unref0 (_tmp30_);
			break;
		}
	}
	_tmp32_ = self->priv->remove_buttons;
	if (_tmp32_ == TRUE) {
		MathButtons* _tmp33_ = NULL;
		ButtonMode _tmp34_ = 0;
		ButtonMode _tmp35_ = 0;
		_tmp33_ = self->priv->_buttons;
		_tmp34_ = math_buttons_get_mode (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_ != BUTTON_MODE_KEYBOARD;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		MathButtons* _tmp36_ = NULL;
		MathConverter* _tmp37_ = NULL;
		_tmp36_ = self->priv->_buttons;
		gtk_widget_show ((GtkWidget*) _tmp36_);
		self->priv->remove_buttons = FALSE;
		_tmp37_ = self->priv->converter;
		gtk_widget_hide ((GtkWidget*) _tmp37_);
		gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	} else {
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		_tmp39_ = self->priv->remove_buttons;
		if (_tmp39_ == FALSE) {
			MathButtons* _tmp40_ = NULL;
			ButtonMode _tmp41_ = 0;
			ButtonMode _tmp42_ = 0;
			_tmp40_ = self->priv->_buttons;
			_tmp41_ = math_buttons_get_mode (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp38_ = _tmp42_ == BUTTON_MODE_KEYBOARD;
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			MathButtons* _tmp43_ = NULL;
			MathConverter* _tmp44_ = NULL;
			_tmp43_ = self->priv->_buttons;
			gtk_widget_hide ((GtkWidget*) _tmp43_);
			self->priv->remove_buttons = TRUE;
			_tmp44_ = self->priv->converter;
			gtk_widget_show ((GtkWidget*) _tmp44_);
			gtk_window_set_resizable ((GtkWindow*) self, TRUE);
		}
	}
	_g_object_unref0 (action);
}


void math_window_critical_error (MathWindow* self, const gchar* title, const gchar* contents) {
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = title;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = contents;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp2_);
	_tmp3_ = _ ("_Quit");
	gtk_dialog_add_buttons ((GtkDialog*) dialog, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) self);
	_g_object_unref0 (dialog);
}


static gboolean math_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathWindow * self;
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MathButtons* _tmp3_ = NULL;
	MathButtons* _tmp4_ = NULL;
	ButtonMode _tmp5_ = 0;
	ButtonMode _tmp6_ = 0;
	self = (MathWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = GTK_WIDGET_CLASS (math_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), _tmp0_);
	_result_ = _tmp1_;
	_tmp3_ = math_window_get_buttons (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = math_buttons_get_mode (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == BUTTON_MODE_PROGRAMMING) {
		GdkEventKey* _tmp7_ = NULL;
		GdkModifierType _tmp8_ = 0;
		_tmp7_ = event;
		_tmp8_ = _tmp7_->state;
		_tmp2_ = (_tmp8_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkEventKey* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp9_ = event;
		_tmp10_ = _tmp9_->keyval;
		switch (_tmp10_) {
			case GDK_KEY_b:
			{
				MathEquation* _tmp11_ = NULL;
				MathEquation* _tmp12_ = NULL;
				_tmp11_ = math_window_get_equation (self);
				_tmp12_ = _tmp11_;
				math_equation_set_number_base (_tmp12_, 2);
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				MathEquation* _tmp13_ = NULL;
				MathEquation* _tmp14_ = NULL;
				_tmp13_ = math_window_get_equation (self);
				_tmp14_ = _tmp13_;
				math_equation_set_number_base (_tmp14_, 8);
				result = TRUE;
				return result;
			}
			case GDK_KEY_d:
			{
				MathEquation* _tmp15_ = NULL;
				MathEquation* _tmp16_ = NULL;
				_tmp15_ = math_window_get_equation (self);
				_tmp16_ = _tmp15_;
				math_equation_set_number_base (_tmp16_, 10);
				result = TRUE;
				return result;
			}
			case GDK_KEY_h:
			{
				MathEquation* _tmp17_ = NULL;
				MathEquation* _tmp18_ = NULL;
				_tmp17_ = math_window_get_equation (self);
				_tmp18_ = _tmp17_;
				math_equation_set_number_base (_tmp18_, 16);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	result = _result_;
	return result;
}


static void math_window_scroll_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->right_aligned;
	if (_tmp0_) {
		GtkAdjustment* _tmp1_ = NULL;
		GtkAdjustment* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		GtkAdjustment* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		_tmp1_ = adjustment;
		_tmp2_ = adjustment;
		_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
		_tmp4_ = adjustment;
		_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
		gtk_adjustment_set_value (_tmp1_, _tmp3_ - _tmp5_);
	}
}


static void _math_window_scroll_changed_cb_gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self) {
	math_window_scroll_changed_cb ((MathWindow*) self, _sender);
}


static void math_window_scroll_value_changed_cb (MathWindow* self, GtkAdjustment* adjustment) {
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GtkAdjustment* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	_tmp2_ = adjustment;
	_tmp3_ = gtk_adjustment_get_upper (_tmp2_);
	_tmp4_ = adjustment;
	_tmp5_ = gtk_adjustment_get_page_size (_tmp4_);
	if (_tmp1_ == (_tmp3_ - _tmp5_)) {
		self->priv->right_aligned = TRUE;
	} else {
		self->priv->right_aligned = FALSE;
	}
}


static void _math_window_scroll_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	math_window_scroll_value_changed_cb ((MathWindow*) self, _sender);
}


static void math_window_copy_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_copy (_tmp1_);
}


static void math_window_paste_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	math_equation_paste (_tmp1_);
}


static void math_window_undo_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp1_);
}


static void math_window_redo_cb (MathWindow* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_window_get_equation (self);
	_tmp1_ = _tmp0_;
	gtk_source_buffer_redo ((GtkSourceBuffer*) _tmp1_);
}


static void math_window_mode_cb (MathWindow* self, GSimpleAction* action, GVariant* parameter) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const GVariantType* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkPopover* popover = NULL;
	GtkMenuButton* _tmp4_ = NULL;
	GtkPopover* _tmp5_ = NULL;
	GtkPopover* _tmp6_ = NULL;
	GtkPopover* _tmp7_ = NULL;
	GtkMenuButton* _tmp8_ = NULL;
	MathDisplay* _tmp9_ = NULL;
	MathDisplay* _tmp10_ = NULL;
	ButtonMode mode = 0;
	gchar* mode_str = NULL;
	GVariant* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	MathButtons* _tmp19_ = NULL;
	MathButtons* _tmp20_ = NULL;
	ButtonMode _tmp21_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = parameter;
	_vala_return_if_fail (_tmp0_ != NULL, "parameter != null");
	_tmp1_ = parameter;
	_tmp2_ = G_VARIANT_TYPE_STRING;
	_tmp3_ = g_variant_is_of_type (_tmp1_, _tmp2_);
	_vala_return_if_fail (_tmp3_, "parameter.is_of_type (VariantType.STRING)");
	_tmp4_ = self->priv->menu_button;
	_tmp5_ = gtk_menu_button_get_popover (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	popover = _tmp6_;
	_tmp7_ = popover;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->menu_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, FALSE);
	_tmp9_ = math_window_get_display (self);
	_tmp10_ = _tmp9_;
	math_display_grab_focus (_tmp10_);
	mode = BUTTON_MODE_BASIC;
	_tmp11_ = parameter;
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
	_tmp13_ = g_strdup (_tmp12_);
	mode_str = _tmp13_;
	_tmp14_ = mode_str;
	if (g_strcmp0 (_tmp14_, "basic") == 0) {
		mode = BUTTON_MODE_BASIC;
	} else {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = mode_str;
		if (g_strcmp0 (_tmp15_, "advanced") == 0) {
			mode = BUTTON_MODE_ADVANCED;
		} else {
			const gchar* _tmp16_ = NULL;
			_tmp16_ = mode_str;
			if (g_strcmp0 (_tmp16_, "financial") == 0) {
				mode = BUTTON_MODE_FINANCIAL;
			} else {
				const gchar* _tmp17_ = NULL;
				_tmp17_ = mode_str;
				if (g_strcmp0 (_tmp17_, "programming") == 0) {
					mode = BUTTON_MODE_PROGRAMMING;
				} else {
					const gchar* _tmp18_ = NULL;
					_tmp18_ = mode_str;
					if (g_strcmp0 (_tmp18_, "keyboard") == 0) {
						mode = BUTTON_MODE_KEYBOARD;
					} else {
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp19_ = math_window_get_buttons (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = mode;
	math_buttons_set_mode (_tmp20_, _tmp21_);
	_g_free0 (mode_str);
	_g_object_unref0 (popover);
}


MathEquation* math_window_get_equation (MathWindow* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


MathDisplay* math_window_get_display (MathWindow* self) {
	MathDisplay* result;
	MathDisplay* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


MathButtons* math_window_get_buttons (MathWindow* self) {
	MathButtons* result;
	MathButtons* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buttons;
	result = _tmp0_;
	return result;
}


static void math_window_class_init (MathWindowClass * klass) {
	gint MathWindow_private_offset;
	math_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathWindowPrivate));
	((GtkWidgetClass *) klass)->key_press_event = math_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_window_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_DISPLAY, g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_WINDOW_BUTTONS, g_param_spec_object ("buttons", "buttons", "buttons", TYPE_MATH_BUTTONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	MathWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_label", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, mode_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolled_window", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, scrolled_window));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "converter", FALSE, MathWindow_private_offset + G_STRUCT_OFFSET (MathWindowPrivate, converter));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_changed_cb", G_CALLBACK(_math_window_scroll_changed_cb_gtk_adjustment_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_value_changed_cb", G_CALLBACK(_math_window_scroll_value_changed_cb_gtk_adjustment_value_changed));
}


static void math_window_instance_init (MathWindow * self) {
	self->priv = MATH_WINDOW_GET_PRIVATE (self);
	g_type_ensure (TYPE_MATH_CONVERTER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void math_window_finalize (GObject* obj) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_WINDOW, MathWindow);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_buttons);
	_g_object_unref0 (self->priv->menu_button);
	_g_object_unref0 (self->priv->mode_label);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (math_window_parent_class)->finalize (obj);
}


GType math_window_get_type (void) {
	static volatile gsize math_window_type_id__volatile = 0;
	if (g_once_init_enter (&math_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathWindow), 0, (GInstanceInitFunc) math_window_instance_init, NULL };
		GType math_window_type_id;
		math_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MathWindow", &g_define_type_info, 0);
		g_once_init_leave (&math_window_type_id__volatile, math_window_type_id);
	}
	return math_window_type_id__volatile;
}


static void _vala_math_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_WINDOW, MathWindow);
	switch (property_id) {
		case MATH_WINDOW_EQUATION:
		g_value_set_object (value, math_window_get_equation (self));
		break;
		case MATH_WINDOW_DISPLAY:
		g_value_set_object (value, math_window_get_display (self));
		break;
		case MATH_WINDOW_BUTTONS:
		g_value_set_object (value, math_window_get_buttons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



