/* math-history.c generated by valac 0.34.4, the Vala compiler
 * generated from math-history.vala, do not modify */

/*
 * Copyright (C) 2014 ELITA ASTRID ANGELINA LOBO
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "libcalculator.h"
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>


#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
typedef struct _HistoryViewPrivate HistoryViewPrivate;

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HISTORY_ENTRY_VIEW (history_entry_view_get_type ())
#define HISTORY_ENTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY_VIEW, HistoryEntryView))
#define HISTORY_ENTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY_VIEW, HistoryEntryViewClass))
#define IS_HISTORY_ENTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY_VIEW))
#define IS_HISTORY_ENTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY_VIEW))
#define HISTORY_ENTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY_VIEW, HistoryEntryViewClass))

typedef struct _HistoryEntryView HistoryEntryView;
typedef struct _HistoryEntryViewClass HistoryEntryViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _HistoryEntryViewPrivate HistoryEntryViewPrivate;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _HistoryView {
	GtkBox parent_instance;
	HistoryViewPrivate * priv;
};

struct _HistoryViewClass {
	GtkBoxClass parent_class;
};

struct _HistoryViewPrivate {
	gint no_ofitems;
	GtkScrolledWindow* scroll_window;
	GtkListBox* listbox;
	GtkBox* main_box;
	MathDisplay* _display;
};

struct _HistoryEntryView {
	GtkListBoxRow parent_instance;
	HistoryEntryViewPrivate * priv;
};

struct _HistoryEntryViewClass {
	GtkListBoxRowClass parent_class;
};

struct _HistoryEntryViewPrivate {
	MathDisplay* _display;
	Number* answer;
	gchar* prev_equation;
	gchar* prev_answer;
	GtkLabel* equation_label;
	GtkLabel* answer_label;
	GtkEventBox* eq_eventbox;
	GtkEventBox* ans_eventbox;
};


static gpointer history_view_parent_class = NULL;
static gpointer history_entry_view_parent_class = NULL;

GType history_view_get_type (void) G_GNUC_CONST;
GType math_display_get_type (void) G_GNUC_CONST;
#define HISTORY_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY_VIEW, HistoryViewPrivate))
enum  {
	HISTORY_VIEW_DUMMY_PROPERTY,
	HISTORY_VIEW_DISPLAY
};
HistoryView* history_view_new (MathDisplay* display, GtkBox* box);
HistoryView* history_view_construct (GType object_type, MathDisplay* display, GtkBox* box);
void history_view_scroll_bottom (HistoryView* self);
static void _history_view_scroll_bottom_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
void history_view_insert_entry (HistoryView* self, const gchar* equation, Number* answer, gint number_base, guint representation_base);
gboolean history_view_check_history (HistoryView* self, const gchar* equation, const gchar* answer);
GType history_entry_view_get_type (void) G_GNUC_CONST;
HistoryEntryView* history_entry_view_new (const gchar* equation, Number* number, MathDisplay* display, gint number_base, guint representation_base);
HistoryEntryView* history_entry_view_construct (GType object_type, const gchar* equation, Number* number, MathDisplay* display, gint number_base, guint representation_base);
MathDisplay* history_view_get_display (HistoryView* self);
static void history_view_finalize (GObject* obj);
static void _vala_history_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define HISTORY_ENTRY_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY_ENTRY_VIEW, HistoryEntryViewPrivate))
enum  {
	HISTORY_ENTRY_VIEW_DUMMY_PROPERTY,
	HISTORY_ENTRY_VIEW_DISPLAY
};
static gboolean history_entry_view_onclick_equation (HistoryEntryView* self, GtkWidget* widget, GdkEventButton* eventbutton);
static gboolean _history_entry_view_onclick_equation_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
gboolean history_entry_view_onclick_answer (HistoryEntryView* self, GtkWidget* widget, GdkEventButton* eventbutton);
static gboolean _history_entry_view_onclick_answer_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
void math_display_insert_text (MathDisplay* self, const gchar* answer);
void math_display_display_text (MathDisplay* self, const gchar* prev_eq);
MathDisplay* history_entry_view_get_display (HistoryEntryView* self);
static void history_entry_view_finalize (GObject* obj);
static void _vala_history_entry_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _history_view_scroll_bottom_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	history_view_scroll_bottom ((HistoryView*) self);
}


HistoryView* history_view_construct (GType object_type, MathDisplay* display, GtkBox* box) {
	HistoryView * self = NULL;
	MathDisplay* _tmp0_ = NULL;
	MathDisplay* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GtkScrolledWindow* _tmp7_ = NULL;
	GtkScrolledWindow* _tmp8_ = NULL;
	GtkScrolledWindow* _tmp9_ = NULL;
	GtkScrolledWindow* _tmp10_ = NULL;
	GtkScrolledWindow* _tmp11_ = NULL;
	GtkListBox* _tmp12_ = NULL;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkListBox* _tmp14_ = NULL;
	GtkScrolledWindow* _tmp15_ = NULL;
	GtkScrolledWindow* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkScrolledWindow* _tmp18_ = NULL;
	GtkBox* _tmp19_ = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (box != NULL, NULL);
	self = (HistoryView*) g_object_new (object_type, NULL);
	_tmp0_ = display;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp1_;
	_tmp2_ = box;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = _tmp3_;
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp4_;
	_tmp5_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp5_, GTK_SELECTION_NONE);
	_tmp6_ = self->priv->listbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp6_, (guint) 5);
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->scroll_window);
	self->priv->scroll_window = _tmp7_;
	_tmp8_ = self->priv->scroll_window;
	gtk_scrolled_window_set_shadow_type (_tmp8_, GTK_SHADOW_ETCHED_OUT);
	_tmp9_ = self->priv->scroll_window;
	gtk_scrolled_window_set_policy (_tmp9_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp10_ = self->priv->scroll_window;
	gtk_scrolled_window_set_placement (_tmp10_, GTK_CORNER_TOP_LEFT);
	_tmp11_ = self->priv->scroll_window;
	_tmp12_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->scroll_window;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = self->priv->listbox;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = self->priv->scroll_window;
	gtk_widget_set_size_request ((GtkWidget*) _tmp15_, 100, 100);
	_tmp16_ = self->priv->scroll_window;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "size-allocate", (GCallback) _history_view_scroll_bottom_gtk_widget_size_allocate, self, 0);
	_tmp17_ = self->priv->main_box;
	_tmp18_ = self->priv->scroll_window;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->main_box;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	return self;
}


HistoryView* history_view_new (MathDisplay* display, GtkBox* box) {
	return history_view_construct (TYPE_HISTORY_VIEW, display, box);
}


void history_view_scroll_bottom (HistoryView* self) {
	GtkAdjustment* adjustment = NULL;
	GtkScrolledWindow* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scroll_window;
	_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	adjustment = _tmp2_;
	_tmp3_ = gtk_adjustment_get_upper (adjustment);
	_tmp4_ = gtk_adjustment_get_page_size (adjustment);
	gtk_adjustment_set_value (adjustment, _tmp3_ - _tmp4_);
	_g_object_unref0 (adjustment);
}


void history_view_insert_entry (HistoryView* self, const gchar* equation, Number* answer, gint number_base, guint representation_base) {
	gchar* prev_eq = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Serializer* _serializer = NULL;
	gint _tmp2_ = 0;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gchar* ans = NULL;
	Serializer* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean check = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = equation;
	_tmp1_ = g_strdup (_tmp0_);
	prev_eq = _tmp1_;
	_tmp2_ = number_base;
	_tmp3_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, _tmp2_, 9);
	_serializer = _tmp3_;
	_tmp4_ = _serializer;
	_tmp5_ = representation_base;
	serializer_set_representation_base (_tmp4_, _tmp5_);
	_tmp6_ = _serializer;
	_tmp7_ = answer;
	_tmp8_ = serializer_to_string (_tmp6_, _tmp7_);
	ans = _tmp8_;
	_tmp9_ = prev_eq;
	_tmp10_ = ans;
	_tmp11_ = history_view_check_history (self, _tmp9_, _tmp10_);
	check = _tmp11_;
	_tmp12_ = check;
	if (_tmp12_ == FALSE) {
		HistoryEntryView* entry = NULL;
		const gchar* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		MathDisplay* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		guint _tmp17_ = 0U;
		HistoryEntryView* _tmp18_ = NULL;
		HistoryEntryView* _tmp19_ = NULL;
		_tmp13_ = prev_eq;
		_tmp14_ = answer;
		_tmp15_ = self->priv->_display;
		_tmp16_ = number_base;
		_tmp17_ = representation_base;
		_tmp18_ = history_entry_view_new (_tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp17_);
		g_object_ref_sink (_tmp18_);
		entry = _tmp18_;
		_tmp19_ = entry;
		if (_tmp19_ != NULL) {
			GtkListBox* _tmp20_ = NULL;
			HistoryEntryView* _tmp21_ = NULL;
			HistoryEntryView* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			_tmp20_ = self->priv->listbox;
			_tmp21_ = entry;
			gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
			_tmp22_ = entry;
			gtk_widget_show ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->no_ofitems;
			self->priv->no_ofitems = _tmp23_ + 1;
		}
		_g_object_unref0 (entry);
	}
	_g_free0 (ans);
	_g_object_unref0 (_serializer);
	_g_free0 (prev_eq);
}


gboolean history_view_check_history (HistoryView* self, const gchar* equation, const gchar* answer) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gchar* current_equation = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* ans = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GtkListBoxRow* _tmp7_ = NULL;
	GtkListBoxRow* _tmp8_ = NULL;
	GtkGrid* grid = NULL;
	GtkListBoxRow* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (equation != NULL, FALSE);
	g_return_val_if_fail (answer != NULL, FALSE);
	_tmp0_ = self->priv->no_ofitems;
	if (_tmp0_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp1_ = equation;
	_tmp2_ = g_strdup (_tmp1_);
	current_equation = _tmp2_;
	_tmp3_ = answer;
	_tmp4_ = g_strdup (_tmp3_);
	ans = _tmp4_;
	_tmp5_ = self->priv->listbox;
	_tmp6_ = self->priv->no_ofitems;
	_tmp7_ = gtk_list_box_get_row_at_index (_tmp5_, _tmp6_ - 1);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp7_) : NULL);
	row = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = gtk_bin_get_child ((GtkBin*) _tmp9_);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp10_) : NULL);
	grid = _tmp11_;
	_tmp12_ = grid;
	if (_tmp12_ != NULL) {
		GtkEventBox* ans_eventbox = NULL;
		GtkGrid* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		GtkWidget* _tmp17_ = NULL;
		GtkEventBox* _tmp18_ = NULL;
		GtkEventBox* _tmp19_ = NULL;
		gchar* prev_ans = NULL;
		GtkEventBox* _tmp20_ = NULL;
		GtkWidget* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		GtkEventBox* eq_eventbox = NULL;
		GtkGrid* _tmp23_ = NULL;
		GList* _tmp24_ = NULL;
		GList* _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		GtkWidget* _tmp27_ = NULL;
		GtkEventBox* _tmp28_ = NULL;
		GtkEventBox* _tmp29_ = NULL;
		gchar* prev_equation = NULL;
		GtkEventBox* _tmp30_ = NULL;
		GtkWidget* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gint _tmp35_ = 0;
		_tmp13_ = grid;
		_tmp14_ = gtk_container_get_children ((GtkContainer*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_list_nth_data (_tmp15_, (guint) 0);
		_tmp17_ = (GtkWidget*) _tmp16_;
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_event_box_get_type ()) ? ((GtkEventBox*) _tmp17_) : NULL);
		_tmp19_ = _tmp18_;
		_g_list_free0 (_tmp15_);
		ans_eventbox = _tmp19_;
		_tmp20_ = ans_eventbox;
		_tmp21_ = gtk_bin_get_child ((GtkBin*) _tmp20_);
		_tmp22_ = gtk_widget_get_tooltip_text ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp21_) : NULL));
		prev_ans = _tmp22_;
		_tmp23_ = grid;
		_tmp24_ = gtk_container_get_children ((GtkContainer*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_list_nth_data (_tmp25_, (guint) 1);
		_tmp27_ = (GtkWidget*) _tmp26_;
		_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_event_box_get_type ()) ? ((GtkEventBox*) _tmp27_) : NULL);
		_tmp29_ = _tmp28_;
		_g_list_free0 (_tmp25_);
		eq_eventbox = _tmp29_;
		_tmp30_ = eq_eventbox;
		_tmp31_ = gtk_bin_get_child ((GtkBin*) _tmp30_);
		_tmp32_ = gtk_widget_get_tooltip_text ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp31_) : NULL));
		prev_equation = _tmp32_;
		_tmp35_ = self->priv->no_ofitems;
		if (_tmp35_ >= 1) {
			const gchar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			_tmp36_ = prev_ans;
			_tmp37_ = ans;
			_tmp34_ = g_strcmp0 (_tmp36_, _tmp37_) == 0;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			_tmp38_ = current_equation;
			_tmp39_ = prev_equation;
			_tmp33_ = g_strcmp0 (_tmp38_, _tmp39_) == 0;
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			result = TRUE;
			_g_free0 (prev_equation);
			_g_object_unref0 (eq_eventbox);
			_g_free0 (prev_ans);
			_g_object_unref0 (ans_eventbox);
			_g_object_unref0 (grid);
			_g_object_unref0 (row);
			_g_free0 (ans);
			_g_free0 (current_equation);
			return result;
		}
		_g_free0 (prev_equation);
		_g_object_unref0 (eq_eventbox);
		_g_free0 (prev_ans);
		_g_object_unref0 (ans_eventbox);
	}
	result = FALSE;
	_g_object_unref0 (grid);
	_g_object_unref0 (row);
	_g_free0 (ans);
	_g_free0 (current_equation);
	return result;
}


MathDisplay* history_view_get_display (HistoryView* self) {
	MathDisplay* result;
	MathDisplay* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


static void history_view_class_init (HistoryViewClass * klass) {
	history_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (HistoryViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_history_view_get_property;
	G_OBJECT_CLASS (klass)->finalize = history_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_VIEW_DISPLAY, g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void history_view_instance_init (HistoryView * self) {
	self->priv = HISTORY_VIEW_GET_PRIVATE (self);
	self->priv->no_ofitems = 0;
}


static void history_view_finalize (GObject* obj) {
	HistoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_VIEW, HistoryView);
	_g_object_unref0 (self->priv->scroll_window);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->_display);
	G_OBJECT_CLASS (history_view_parent_class)->finalize (obj);
}


GType history_view_get_type (void) {
	static volatile gsize history_view_type_id__volatile = 0;
	if (g_once_init_enter (&history_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HistoryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryView), 0, (GInstanceInitFunc) history_view_instance_init, NULL };
		GType history_view_type_id;
		history_view_type_id = g_type_register_static (gtk_box_get_type (), "HistoryView", &g_define_type_info, 0);
		g_once_init_leave (&history_view_type_id__volatile, history_view_type_id);
	}
	return history_view_type_id__volatile;
}


static void _vala_history_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	HistoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_VIEW, HistoryView);
	switch (property_id) {
		case HISTORY_VIEW_DISPLAY:
		g_value_set_object (value, history_view_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean _history_entry_view_onclick_equation_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = history_entry_view_onclick_equation ((HistoryEntryView*) self, _sender, event);
	return result;
}


static gboolean _history_entry_view_onclick_answer_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = history_entry_view_onclick_answer ((HistoryEntryView*) self, _sender, event);
	return result;
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


HistoryEntryView* history_entry_view_construct (GType object_type, const gchar* equation, Number* number, MathDisplay* display, gint number_base, guint representation_base) {
	HistoryEntryView * self = NULL;
	MathDisplay* _tmp0_ = NULL;
	MathDisplay* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Serializer* _serializer = NULL;
	gint _tmp6_ = 0;
	Serializer* _tmp7_ = NULL;
	Serializer* ans_serializer = NULL;
	gint _tmp8_ = 0;
	Serializer* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	Number* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* answer_text = NULL;
	Number* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkEventBox* _tmp19_ = NULL;
	GtkEventBox* _tmp20_ = NULL;
	GtkEventBox* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkEventBox* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkEventBox* _tmp25_ = NULL;
	GtkEventBox* _tmp26_ = NULL;
	GtkEventBox* _tmp27_ = NULL;
	GtkEventBox* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	GtkEventBox* _tmp33_ = NULL;
	GtkEventBox* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* final_answer = NULL;
	gchar* _tmp43_ = NULL;
	GtkLabel* _tmp44_ = NULL;
	GtkEventBox* _tmp45_ = NULL;
	GtkEventBox* _tmp46_ = NULL;
	GtkLabel* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	PangoAttrList* list = NULL;
	PangoAttrList* _tmp49_ = NULL;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp50_ = NULL;
	PangoAttribute* weight = NULL;
	PangoAttribute* _tmp51_ = NULL;
	PangoAttribute* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (number != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	self = (HistoryEntryView*) g_object_new (object_type, NULL);
	_tmp0_ = display;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_display);
	self->priv->_display = _tmp1_;
	_tmp2_ = number;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->answer);
	self->priv->answer = _tmp3_;
	_tmp4_ = equation;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->prev_equation);
	self->priv->prev_equation = _tmp5_;
	_tmp6_ = number_base;
	_tmp7_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, _tmp6_, 9);
	_serializer = _tmp7_;
	_tmp8_ = number_base;
	_tmp9_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, _tmp8_, 4);
	ans_serializer = _tmp9_;
	_tmp10_ = representation_base;
	serializer_set_representation_base (ans_serializer, _tmp10_);
	_tmp11_ = representation_base;
	serializer_set_representation_base (_serializer, _tmp11_);
	_tmp12_ = self->priv->answer;
	_tmp13_ = serializer_to_string (_serializer, _tmp12_);
	_g_free0 (self->priv->prev_answer);
	self->priv->prev_answer = _tmp13_;
	_tmp14_ = self->priv->answer;
	_tmp15_ = serializer_to_string (ans_serializer, _tmp14_);
	answer_text = _tmp15_;
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	grid = _tmp16_;
	gtk_grid_insert_column (grid, 0);
	gtk_grid_insert_column (grid, 1);
	gtk_grid_insert_column (grid, 2);
	gtk_grid_insert_column (grid, 3);
	gtk_grid_insert_row (grid, 0);
	gtk_grid_set_column_homogeneous (grid, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->equation_label);
	self->priv->equation_label = _tmp17_;
	_tmp18_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->answer_label);
	self->priv->answer_label = _tmp18_;
	_tmp19_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->eq_eventbox);
	self->priv->eq_eventbox = _tmp19_;
	_tmp20_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->ans_eventbox);
	self->priv->ans_eventbox = _tmp20_;
	_tmp21_ = self->priv->eq_eventbox;
	_tmp22_ = self->priv->equation_label;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->ans_eventbox;
	_tmp24_ = self->priv->answer_label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->eq_eventbox;
	gtk_widget_set_events ((GtkWidget*) _tmp25_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp26_ = self->priv->ans_eventbox;
	gtk_widget_set_events ((GtkWidget*) _tmp26_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp27_ = self->priv->eq_eventbox;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "button-press-event", (GCallback) _history_entry_view_onclick_equation_gtk_widget_button_press_event, self, 0);
	_tmp28_ = self->priv->ans_eventbox;
	g_signal_connect_object ((GtkWidget*) _tmp28_, "button-press-event", (GCallback) _history_entry_view_onclick_answer_gtk_widget_button_press_event, self, 0);
	_tmp29_ = self->priv->equation_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp29_, 10, 10);
	_tmp30_ = self->priv->answer_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp30_, 10, 10);
	_tmp31_ = self->priv->equation_label;
	gtk_label_set_selectable (_tmp31_, TRUE);
	_tmp32_ = self->priv->answer_label;
	gtk_label_set_selectable (_tmp32_, TRUE);
	_tmp33_ = self->priv->eq_eventbox;
	gtk_event_box_set_above_child (_tmp33_, TRUE);
	_tmp34_ = self->priv->ans_eventbox;
	gtk_event_box_set_above_child (_tmp34_, TRUE);
	_tmp35_ = self->priv->equation_label;
	_tmp36_ = self->priv->prev_equation;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp36_);
	_tmp37_ = self->priv->answer_label;
	_tmp38_ = self->priv->prev_answer;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp37_, _tmp38_);
	_tmp39_ = self->priv->equation_label;
	gtk_label_set_ellipsize (_tmp39_, PANGO_ELLIPSIZE_END);
	_tmp40_ = self->priv->answer_label;
	gtk_label_set_ellipsize (_tmp40_, PANGO_ELLIPSIZE_END);
	_tmp41_ = self->priv->equation_label;
	_tmp42_ = self->priv->prev_equation;
	gtk_label_set_text (_tmp41_, _tmp42_);
	_tmp43_ = g_strconcat ("= ", answer_text, NULL);
	final_answer = _tmp43_;
	_tmp44_ = self->priv->answer_label;
	gtk_label_set_text (_tmp44_, final_answer);
	_tmp45_ = self->priv->eq_eventbox;
	gtk_grid_attach (grid, (GtkWidget*) _tmp45_, 0, 0, 3, 1);
	_tmp46_ = self->priv->ans_eventbox;
	gtk_grid_attach (grid, (GtkWidget*) _tmp46_, 3, 0, 1, 1);
	_tmp47_ = self->priv->equation_label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp47_, (gfloat) 0, (gfloat) 0);
	_tmp48_ = self->priv->answer_label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp48_, (gfloat) 0, (gfloat) 0);
	_tmp49_ = pango_attr_list_new ();
	list = _tmp49_;
	_tmp50_ = pango_font_description_new ();
	font = _tmp50_;
	pango_font_description_set_weight (font, PANGO_WEIGHT_BOLD);
	_tmp51_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	weight = _tmp51_;
	_tmp52_ = weight;
	weight = NULL;
	pango_attr_list_insert (list, _tmp52_);
	_tmp53_ = self->priv->answer_label;
	gtk_label_set_attributes (_tmp53_, list);
	gtk_widget_show_all ((GtkWidget*) grid);
	_pango_attribute_destroy0 (weight);
	__vala_PangoFontDescription_free0 (font);
	_pango_attr_list_unref0 (list);
	_g_free0 (final_answer);
	_g_object_unref0 (grid);
	_g_free0 (answer_text);
	_g_object_unref0 (ans_serializer);
	_g_object_unref0 (_serializer);
	return self;
}


HistoryEntryView* history_entry_view_new (const gchar* equation, Number* number, MathDisplay* display, gint number_base, guint representation_base) {
	return history_entry_view_construct (TYPE_HISTORY_ENTRY_VIEW, equation, number, display, number_base, representation_base);
}


gboolean history_entry_view_onclick_answer (HistoryEntryView* self, GtkWidget* widget, GdkEventButton* eventbutton) {
	gboolean result = FALSE;
	GtkEventBox* event = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GtkEventBox* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_event_box_get_type (), GtkEventBox));
	event = _tmp1_;
	_tmp2_ = event;
	if (_tmp2_ != NULL) {
		GtkLabel* ans_label = NULL;
		GtkEventBox* _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		gchar* prev_ans = NULL;
		GtkLabel* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp3_ = event;
		_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
		ans_label = _tmp5_;
		_tmp6_ = ans_label;
		_tmp7_ = gtk_widget_get_tooltip_text ((GtkWidget*) _tmp6_);
		prev_ans = _tmp7_;
		_tmp8_ = prev_ans;
		if (_tmp8_ != NULL) {
			MathDisplay* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = self->priv->_display;
			_tmp10_ = prev_ans;
			math_display_insert_text (_tmp9_, _tmp10_);
		}
		_g_free0 (prev_ans);
		_g_object_unref0 (ans_label);
	}
	result = TRUE;
	_g_object_unref0 (event);
	return result;
}


static gboolean history_entry_view_onclick_equation (HistoryEntryView* self, GtkWidget* widget, GdkEventButton* eventbutton) {
	gboolean result = FALSE;
	GtkEventBox* event = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GtkEventBox* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (eventbutton != NULL, FALSE);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_event_box_get_type (), GtkEventBox));
	event = _tmp1_;
	_tmp2_ = event;
	if (_tmp2_ != NULL) {
		GtkLabel* equation_label = NULL;
		GtkEventBox* _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		gchar* prev_equation = NULL;
		GtkLabel* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp3_ = event;
		_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp4_) : NULL);
		equation_label = _tmp5_;
		_tmp6_ = equation_label;
		_tmp7_ = gtk_label_get_text (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		prev_equation = _tmp8_;
		_tmp9_ = prev_equation;
		if (_tmp9_ != NULL) {
			MathDisplay* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = self->priv->_display;
			_tmp11_ = prev_equation;
			math_display_display_text (_tmp10_, _tmp11_);
		}
		_g_free0 (prev_equation);
		_g_object_unref0 (equation_label);
	}
	result = TRUE;
	_g_object_unref0 (event);
	return result;
}


MathDisplay* history_entry_view_get_display (HistoryEntryView* self) {
	MathDisplay* result;
	MathDisplay* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


static void history_entry_view_class_init (HistoryEntryViewClass * klass) {
	history_entry_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (HistoryEntryViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_history_entry_view_get_property;
	G_OBJECT_CLASS (klass)->finalize = history_entry_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_ENTRY_VIEW_DISPLAY, g_param_spec_object ("display", "display", "display", TYPE_MATH_DISPLAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void history_entry_view_instance_init (HistoryEntryView * self) {
	self->priv = HISTORY_ENTRY_VIEW_GET_PRIVATE (self);
}


static void history_entry_view_finalize (GObject* obj) {
	HistoryEntryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY_VIEW, HistoryEntryView);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->answer);
	_g_free0 (self->priv->prev_equation);
	_g_free0 (self->priv->prev_answer);
	_g_object_unref0 (self->priv->equation_label);
	_g_object_unref0 (self->priv->answer_label);
	_g_object_unref0 (self->priv->eq_eventbox);
	_g_object_unref0 (self->priv->ans_eventbox);
	G_OBJECT_CLASS (history_entry_view_parent_class)->finalize (obj);
}


GType history_entry_view_get_type (void) {
	static volatile gsize history_entry_view_type_id__volatile = 0;
	if (g_once_init_enter (&history_entry_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntryView), 0, (GInstanceInitFunc) history_entry_view_instance_init, NULL };
		GType history_entry_view_type_id;
		history_entry_view_type_id = g_type_register_static (gtk_list_box_row_get_type (), "HistoryEntryView", &g_define_type_info, 0);
		g_once_init_leave (&history_entry_view_type_id__volatile, history_entry_view_type_id);
	}
	return history_entry_view_type_id__volatile;
}


static void _vala_history_entry_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	HistoryEntryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_ENTRY_VIEW, HistoryEntryView);
	switch (property_id) {
		case HISTORY_ENTRY_VIEW_DISPLAY:
		g_value_set_object (value, history_entry_view_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



