/* serializer.c generated by valac 0.26.0.50-d9a75, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>


#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
typedef struct _SerializerPrivate SerializerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

struct _Serializer {
	GObject parent_instance;
	SerializerPrivate * priv;
};

struct _SerializerClass {
	GObjectClass parent_class;
};

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
};


static gpointer serializer_parent_class = NULL;

GType display_format_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERIALIZER, SerializerPrivate))
enum  {
	SERIALIZER_DUMMY_PROPERTY
};
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self, Number* x);
static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits);
gint serializer_get_base (Serializer* self);
static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits);
Number* serializer_from_string (Serializer* self, const gchar* str);
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_radix (Serializer* self, gunichar radix);
gunichar serializer_get_radix (Serializer* self);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
gunichar serializer_get_thousands_separator (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
void serializer_set_thousands_separator_count (Serializer* self, gint count);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean serializer_get_show_thousands_separators (Serializer* self);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
gint serializer_get_leading_digits (Serializer* self);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
gint serializer_get_trailing_digits (Serializer* self);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
DisplayFormat serializer_get_number_format (Serializer* self);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
Number* number_real_component (Number* self);
static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string);
gboolean number_is_complex (Number* self);
Number* number_imaginary_component (Number* self);
gboolean number_is_negative (Number* self);
Number* number_abs (Number* self);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_add (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_is_zero (Number* self);
Number* number_subtract (Number* self, Number* y);
gint64 number_to_integer (Number* self);
Number* number_fractional_component (Number* self);
static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits);
Number* number_divide (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
static void serializer_append_exponent (Serializer* self, GString* string, gint exponent);
static void serializer_finalize (GObject* obj);


GType display_format_get_type (void) {
	static volatile gsize display_format_type_id__volatile = 0;
	if (g_once_init_enter (&display_format_type_id__volatile)) {
		static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
		GType display_format_type_id;
		display_format_type_id = g_enum_register_static ("DisplayFormat", values);
		g_once_init_leave (&display_format_type_id__volatile, display_format_type_id);
	}
	return display_format_type_id__volatile;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1026 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 166 "serializer.c"
}


Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits) {
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* tsep_string = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	DisplayFormat _tmp21_ = 0;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self = (Serializer*) g_object_new (object_type, NULL);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = nl_langinfo (RADIXCHAR);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	radix_string = _tmp1_;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = radix_string;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp3_ != NULL) {
#line 198 "serializer.c"
		const gchar* _tmp4_ = NULL;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp4_ = radix_string;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
#line 204 "serializer.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = FALSE;
#line 208 "serializer.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp2_) {
#line 212 "serializer.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp5_ = radix_string;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) (-1), NULL, NULL, NULL);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp7_ = _tmp6_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->radix = _tmp8_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_free0 (_tmp7_);
#line 229 "serializer.c"
	} else {
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->radix = (gunichar) '.';
#line 233 "serializer.c"
	}
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = nl_langinfo (THOUSEP);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	tsep_string = _tmp10_;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp12_ = tsep_string;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp12_ != NULL) {
#line 245 "serializer.c"
		const gchar* _tmp13_ = NULL;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp13_ = tsep_string;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
#line 251 "serializer.c"
	} else {
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = FALSE;
#line 255 "serializer.c"
	}
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp11_) {
#line 259 "serializer.c"
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp14_ = tsep_string;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp15_ = g_locale_to_utf8 (_tmp14_, (gssize) (-1), NULL, NULL, NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp16_ = _tmp15_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->tsep = _tmp17_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_free0 (_tmp16_);
#line 276 "serializer.c"
	} else {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->tsep = (gunichar) ' ';
#line 280 "serializer.c"
	}
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->tsep_count = 3;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp18_ = number_base;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->number_base = _tmp18_;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp19_ = number_base;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->representation_base = (guint) _tmp19_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->leading_digits = 12;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp20_ = trailing_digits;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->trailing_digits = _tmp20_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_zeroes = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_tsep = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp21_ = format;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->format = _tmp21_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (tsep_string);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (radix_string);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return self;
#line 312 "serializer.c"
}


Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits) {
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
#line 319 "serializer.c"
}


gchar* serializer_to_string (Serializer* self, Number* x) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	DisplayFormat _tmp4_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->representation_base;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = self->priv->number_base;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp0_ != ((guint) _tmp1_)) {
#line 338 "serializer.c"
		gint n_digits = 0;
		Number* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		n_digits = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = x;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp3_ = serializer_cast_to_string (self, _tmp2_, &n_digits);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		result = _tmp3_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		return result;
#line 352 "serializer.c"
	}
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = self->priv->format;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	switch (_tmp4_) {
#line 358 "serializer.c"
		default:
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_AUTOMATIC:
#line 362 "serializer.c"
		{
			gint n_digits = 0;
			gchar* s0 = NULL;
			Number* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gint _tmp7_ = 0;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			n_digits = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp5_ = x;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp6_ = serializer_cast_to_string (self, _tmp5_, &n_digits);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			s0 = _tmp6_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp7_ = serializer_get_base (self);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			switch (_tmp7_) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 2:
#line 383 "serializer.c"
				{
					gint _tmp8_ = 0;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp8_ = n_digits;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp8_ <= 64) {
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 394 "serializer.c"
					} else {
						Number* _tmp9_ = NULL;
						gchar* _tmp10_ = NULL;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp9_ = x;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp10_ = serializer_cast_to_exponential_string (self, _tmp9_, FALSE, &n_digits);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp10_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 408 "serializer.c"
					}
				}
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 8:
#line 413 "serializer.c"
				{
					gint _tmp11_ = 0;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp11_ = n_digits;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp11_ <= 22) {
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 424 "serializer.c"
					} else {
						Number* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp12_ = x;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp13_ = serializer_cast_to_exponential_string (self, _tmp12_, FALSE, &n_digits);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp13_;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 438 "serializer.c"
					}
				}
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 16:
#line 443 "serializer.c"
				{
					gint _tmp14_ = 0;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp14_ = n_digits;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp14_ <= 16) {
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 454 "serializer.c"
					} else {
						Number* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp15_ = x;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp16_ = serializer_cast_to_exponential_string (self, _tmp15_, FALSE, &n_digits);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp16_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 468 "serializer.c"
					}
				}
				default:
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 10:
#line 474 "serializer.c"
				{
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp17_ = n_digits;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp18_ = self->priv->leading_digits;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp17_ <= _tmp18_) {
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 488 "serializer.c"
					} else {
						Number* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp19_ = x;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp20_ = serializer_cast_to_exponential_string (self, _tmp19_, FALSE, &n_digits);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp20_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 502 "serializer.c"
					}
				}
			}
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_free0 (s0);
#line 508 "serializer.c"
		}
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_FIXED:
#line 512 "serializer.c"
		{
			gint n_digits = 0;
			Number* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			n_digits = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = x;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = serializer_cast_to_string (self, _tmp21_, &n_digits);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			result = _tmp22_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			return result;
#line 527 "serializer.c"
		}
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_SCIENTIFIC:
#line 531 "serializer.c"
		{
			guint _tmp23_ = 0U;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp23_ = self->priv->representation_base;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp23_ == ((guint) 10)) {
#line 538 "serializer.c"
				gint n_digits = 0;
				Number* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp24_ = x;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp25_ = serializer_cast_to_exponential_string (self, _tmp24_, FALSE, &n_digits);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp25_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 552 "serializer.c"
			} else {
				gint n_digits = 0;
				Number* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp26_ = x;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = serializer_cast_to_string (self, _tmp26_, &n_digits);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp27_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 567 "serializer.c"
			}
		}
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_ENGINEERING:
#line 572 "serializer.c"
		{
			guint _tmp28_ = 0U;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = self->priv->representation_base;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp28_ == ((guint) 10)) {
#line 579 "serializer.c"
				gint n_digits = 0;
				Number* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp29_ = x;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp30_ = serializer_cast_to_exponential_string (self, _tmp29_, TRUE, &n_digits);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp30_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 593 "serializer.c"
			} else {
				gint n_digits = 0;
				Number* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = x;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp32_ = serializer_cast_to_string (self, _tmp31_, &n_digits);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp32_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 608 "serializer.c"
			}
		}
	}
}


Number* serializer_from_string (Serializer* self, const gchar* str) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = str;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = self->priv->number_base;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp2_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 634 "serializer.c"
}


void serializer_set_base (Serializer* self, gint number_base) {
	gint _tmp0_ = 0;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = number_base;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->number_base = _tmp0_;
#line 646 "serializer.c"
}


gint serializer_get_base (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->number_base;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 661 "serializer.c"
}


void serializer_set_representation_base (Serializer* self, guint representation_base) {
	guint _tmp0_ = 0U;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = representation_base;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->representation_base = _tmp0_;
#line 673 "serializer.c"
}


guint serializer_get_representation_base (Serializer* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->representation_base;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 688 "serializer.c"
}


void serializer_set_radix (Serializer* self, gunichar radix) {
	gunichar _tmp0_ = 0U;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = radix;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->radix = _tmp0_;
#line 700 "serializer.c"
}


gunichar serializer_get_radix (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->radix;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 715 "serializer.c"
}


void serializer_set_thousands_separator (Serializer* self, gunichar separator) {
	gunichar _tmp0_ = 0U;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = separator;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->tsep = _tmp0_;
#line 727 "serializer.c"
}


gunichar serializer_get_thousands_separator (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->tsep;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 742 "serializer.c"
}


gint serializer_get_thousands_separator_count (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->tsep_count;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 757 "serializer.c"
}


void serializer_set_thousands_separator_count (Serializer* self, gint count) {
	gint _tmp0_ = 0;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = count;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->tsep_count = _tmp0_;
#line 769 "serializer.c"
}


void serializer_set_show_thousands_separators (Serializer* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = visible;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_tsep = _tmp0_;
#line 781 "serializer.c"
}


gboolean serializer_get_show_thousands_separators (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->show_tsep;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 796 "serializer.c"
}


void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = visible;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_zeroes = _tmp0_;
#line 808 "serializer.c"
}


gboolean serializer_get_show_trailing_zeroes (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->show_zeroes;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 823 "serializer.c"
}


gint serializer_get_leading_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->leading_digits;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 838 "serializer.c"
}


void serializer_set_leading_digits (Serializer* self, gint leading_digits) {
	gint _tmp0_ = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = leading_digits;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->leading_digits = _tmp0_;
#line 850 "serializer.c"
}


gint serializer_get_trailing_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->trailing_digits;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 865 "serializer.c"
}


void serializer_set_trailing_digits (Serializer* self, gint trailing_digits) {
	gint _tmp0_ = 0;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = trailing_digits;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->trailing_digits = _tmp0_;
#line 877 "serializer.c"
}


DisplayFormat serializer_get_number_format (Serializer* self) {
	DisplayFormat result = 0;
	DisplayFormat _tmp0_ = 0;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->format;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 892 "serializer.c"
}


void serializer_set_number_format (Serializer* self, DisplayFormat format) {
	DisplayFormat _tmp0_ = 0;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = format;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->format = _tmp0_;
#line 904 "serializer.c"
}


static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_ = NULL;
	Number* x_real = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GString* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GString* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = g_string_sized_new ((gsize) 1024);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	string = _tmp0_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = x;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = number_real_component (_tmp1_);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	x_real = _tmp2_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = x_real;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = self->priv->representation_base;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = string;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	serializer_cast_to_string_real (self, _tmp3_, (gint) _tmp4_, FALSE, n_digits, _tmp5_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = x;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = number_is_complex (_tmp6_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp7_) {
#line 951 "serializer.c"
		Number* x_im = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gboolean force_sign = FALSE;
		GString* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GString* s = NULL;
		GString* _tmp13_ = NULL;
		gint n_complex_digits = 0;
		Number* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		gboolean _tmp16_ = FALSE;
		GString* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		GString* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp8_ = x;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		x_im = _tmp9_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		force_sign = TRUE;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp10_ = string;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = _tmp10_->str;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp11_, "0") == 0) {
#line 985 "serializer.c"
			GString* _tmp12_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp12_ = string;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_assign (_tmp12_, "");
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			force_sign = FALSE;
#line 993 "serializer.c"
		}
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp13_ = g_string_sized_new ((gsize) 1024);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		s = _tmp13_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		n_complex_digits = 0;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp14_ = x_im;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp15_ = self->priv->representation_base;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp16_ = force_sign;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp17_ = s;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		serializer_cast_to_string_real (self, _tmp14_, (gint) _tmp15_, _tmp16_, &n_complex_digits, _tmp17_);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp18_ = n_complex_digits;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp19_ = *n_digits;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp18_ > _tmp19_) {
#line 1017 "serializer.c"
			gint _tmp20_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp20_ = n_complex_digits;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			*n_digits = _tmp20_;
#line 1023 "serializer.c"
		}
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp23_ = s;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp24_ = _tmp23_->str;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp24_, "0") == 0) {
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = TRUE;
#line 1033 "serializer.c"
		} else {
			GString* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = s;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp26_ = _tmp25_->str;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = g_strcmp0 (_tmp26_, "+0") == 0;
#line 1043 "serializer.c"
		}
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp22_) {
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = TRUE;
#line 1049 "serializer.c"
		} else {
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp27_ = s;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = _tmp27_->str;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = g_strcmp0 (_tmp28_, "−0") == 0;
#line 1059 "serializer.c"
		}
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp21_) {
#line 1063 "serializer.c"
		} else {
			GString* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp29_ = s;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp30_ = _tmp29_->str;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (g_strcmp0 (_tmp30_, "1") == 0) {
#line 1073 "serializer.c"
				GString* _tmp31_ = NULL;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = string;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_append (_tmp31_, "i");
#line 1079 "serializer.c"
			} else {
				GString* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp32_ = s;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp33_ = _tmp32_->str;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (g_strcmp0 (_tmp33_, "+1") == 0) {
#line 1089 "serializer.c"
					GString* _tmp34_ = NULL;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp34_ = string;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					g_string_append (_tmp34_, "+i");
#line 1095 "serializer.c"
				} else {
					GString* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp35_ = s;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp36_ = _tmp35_->str;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (g_strcmp0 (_tmp36_, "−1") == 0) {
#line 1105 "serializer.c"
						GString* _tmp37_ = NULL;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp37_ = string;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp37_, "−i");
#line 1111 "serializer.c"
					} else {
						GString* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						GString* _tmp46_ = NULL;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp38_ = s;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp39_ = _tmp38_->str;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						if (g_strcmp0 (_tmp39_, "+0") == 0) {
#line 1122 "serializer.c"
							GString* _tmp40_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp40_ = string;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							g_string_append (_tmp40_, "+");
#line 1128 "serializer.c"
						} else {
							GString* _tmp41_ = NULL;
							const gchar* _tmp42_ = NULL;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp41_ = s;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp42_ = _tmp41_->str;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							if (g_strcmp0 (_tmp42_, "0") != 0) {
#line 1138 "serializer.c"
								GString* _tmp43_ = NULL;
								GString* _tmp44_ = NULL;
								const gchar* _tmp45_ = NULL;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp43_ = string;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp44_ = s;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp45_ = _tmp44_->str;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								g_string_append (_tmp43_, _tmp45_);
#line 1150 "serializer.c"
							}
						}
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp46_ = string;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp46_, "i");
#line 1157 "serializer.c"
					}
				}
			}
		}
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_string_free0 (s);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (x_im);
#line 1166 "serializer.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp47_ = string;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp48_ = _tmp47_->str;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp49_ = g_strdup (_tmp48_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp49_;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (x_real);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_string_free0 (string);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 1182 "serializer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return self ? g_object_ref (self) : NULL;
#line 1189 "serializer.c"
}


static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
#line 1196 "serializer.c"
	Number* number = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Number* temp = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* rounded_number = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	gint i = 0;
	gssize last_non_zero = 0L;
	GString* _tmp54_ = NULL;
	gssize _tmp55_ = 0L;
	GString* _tmp56_ = NULL;
	gunichar _tmp57_ = 0U;
	Number* _tmp58_ = NULL;
	Number* _tmp59_ = NULL;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp87_ = FALSE;
	GString* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (x != NULL);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (string != NULL);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = x;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	number = _tmp1_;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = number;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = number_is_negative (_tmp2_);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp3_) {
#line 1252 "serializer.c"
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp4_ = number;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp5_ = number_abs (_tmp4_);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (number);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		number = _tmp5_;
#line 1263 "serializer.c"
	}
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = number_base;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp7_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp8_ = temp;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = self->priv->trailing_digits;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) (-(_tmp9_ + 1)));
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp10_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp11_ = temp;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp12_ = number_base;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp13_ = number_multiply_integer (_tmp11_, (gint64) _tmp12_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp13_;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp14_ = temp;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp15_ = number_divide_integer (_tmp14_, (gint64) 2);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp15_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp16_ = number;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp17_ = temp;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp18_ = number_add (_tmp16_, _tmp17_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	rounded_number = _tmp18_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp19_ = rounded_number;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp20_ = number_floor (_tmp19_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp20_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	i = 0;
#line 1317 "serializer.c"
	{
		gboolean _tmp21_ = FALSE;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp21_ = TRUE;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1324 "serializer.c"
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gint _tmp26_ = 0;
			gint _tmp32_ = 0;
			Number* t = NULL;
			Number* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
			Number* _tmp37_ = NULL;
			Number* t2 = NULL;
			Number* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			Number* _tmp40_ = NULL;
			Number* t3 = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
			Number* _tmp43_ = NULL;
			gint64 d = 0LL;
			Number* _tmp44_ = NULL;
			gint64 _tmp45_ = 0LL;
			gchar _tmp46_ = '\0';
			gint64 _tmp47_ = 0LL;
			GString* _tmp50_ = NULL;
			gint _tmp51_ = 0;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp21_) {
#line 1354 "serializer.c"
				Number* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp22_ = temp;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp23_ = number_is_zero (_tmp22_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (!(!_tmp23_)) {
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					break;
#line 1365 "serializer.c"
				}
			}
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = FALSE;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp26_ = number_base;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp26_ == 10) {
#line 1374 "serializer.c"
				gboolean _tmp27_ = FALSE;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = self->priv->show_tsep;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp25_ = _tmp27_;
#line 1380 "serializer.c"
			} else {
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp25_ = FALSE;
#line 1384 "serializer.c"
			}
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp25_) {
#line 1388 "serializer.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp28_ = i;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp29_ = self->priv->tsep_count;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp24_ = _tmp28_ == _tmp29_;
#line 1397 "serializer.c"
			} else {
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp24_ = FALSE;
#line 1401 "serializer.c"
			}
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp24_) {
#line 1405 "serializer.c"
				GString* _tmp30_ = NULL;
				gunichar _tmp31_ = 0U;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp30_ = string;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = self->priv->tsep;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_prepend_unichar (_tmp30_, _tmp31_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				i = 0;
#line 1416 "serializer.c"
			}
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp32_ = i;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			i = _tmp32_ + 1;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp33_ = temp;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp34_ = number_base;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp35_ = number_divide_integer (_tmp33_, (gint64) _tmp34_);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t = _tmp35_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp36_ = t;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp37_ = number_floor (_tmp36_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t = _tmp37_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp38_ = t;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp39_ = number_base;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp40_ = number_multiply_integer (_tmp38_, (gint64) _tmp39_);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t2 = _tmp40_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp41_ = temp;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp42_ = t2;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp43_ = number_subtract (_tmp41_, _tmp42_);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t3 = _tmp43_;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp44_ = t3;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp45_ = number_to_integer (_tmp44_);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			d = _tmp45_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp47_ = d;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp47_ < ((gint64) 16)) {
#line 1464 "serializer.c"
				gint64 _tmp48_ = 0LL;
				gchar _tmp49_ = '\0';
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp48_ = d;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp49_ = digits[_tmp48_];
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp46_ = _tmp49_;
#line 1473 "serializer.c"
			} else {
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp46_ = '?';
#line 1477 "serializer.c"
			}
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp50_ = string;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_prepend_c (_tmp50_, _tmp46_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp51_ = *n_digits;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			*n_digits = _tmp51_ + 1;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp52_ = t;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp53_ = _g_object_ref0 (_tmp52_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (temp);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			temp = _tmp53_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t3);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t2);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t);
#line 1501 "serializer.c"
		}
	}
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp54_ = string;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp55_ = _tmp54_->len;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	last_non_zero = _tmp55_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp56_ = string;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp57_ = self->priv->radix;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_string_append_unichar (_tmp56_, _tmp57_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp58_ = rounded_number;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp59_ = number_fractional_component (_tmp58_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp59_;
#line 1524 "serializer.c"
	{
		gboolean _tmp60_ = FALSE;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		i = 0;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp60_ = TRUE;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1533 "serializer.c"
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			Number* _tmp64_ = NULL;
			gboolean _tmp65_ = FALSE;
			Number* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			Number* _tmp68_ = NULL;
			Number* digit = NULL;
			Number* _tmp69_ = NULL;
			Number* _tmp70_ = NULL;
			gint64 d = 0LL;
			Number* _tmp71_ = NULL;
			gint64 _tmp72_ = 0LL;
			GString* _tmp73_ = NULL;
			gint64 _tmp74_ = 0LL;
			gchar _tmp75_ = '\0';
			gint64 _tmp76_ = 0LL;
			Number* _tmp79_ = NULL;
			Number* _tmp80_ = NULL;
			Number* _tmp81_ = NULL;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp60_) {
#line 1556 "serializer.c"
				gint _tmp61_ = 0;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp61_ = i;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				i = _tmp61_ + 1;
#line 1562 "serializer.c"
			}
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp60_ = FALSE;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp62_ = i;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp63_ = self->priv->trailing_digits;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!(_tmp62_ < _tmp63_)) {
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1574 "serializer.c"
			}
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp64_ = temp;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp65_ = number_is_zero (_tmp64_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp65_) {
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1584 "serializer.c"
			}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp66_ = temp;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp67_ = number_base;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp68_ = number_multiply_integer (_tmp66_, (gint64) _tmp67_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (temp);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			temp = _tmp68_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp69_ = temp;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp70_ = number_floor (_tmp69_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			digit = _tmp70_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp71_ = digit;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp72_ = number_to_integer (_tmp71_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			d = _tmp72_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp73_ = string;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp74_ = d;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp75_ = digits[_tmp74_];
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_append_c (_tmp73_, _tmp75_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp76_ = d;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp76_ != ((gint64) 0)) {
#line 1620 "serializer.c"
				GString* _tmp77_ = NULL;
				gssize _tmp78_ = 0L;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp77_ = string;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp78_ = _tmp77_->len;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				last_non_zero = _tmp78_;
#line 1629 "serializer.c"
			}
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp79_ = temp;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp80_ = digit;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp81_ = number_subtract (_tmp79_, _tmp80_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (temp);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			temp = _tmp81_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (digit);
#line 1643 "serializer.c"
		}
	}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp83_ = self->priv->show_zeroes;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (!_tmp83_) {
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp82_ = TRUE;
#line 1652 "serializer.c"
	} else {
		gint _tmp84_ = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp84_ = self->priv->trailing_digits;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp82_ = _tmp84_ == 0;
#line 1659 "serializer.c"
	}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp82_) {
#line 1663 "serializer.c"
		GString* _tmp85_ = NULL;
		gssize _tmp86_ = 0L;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp85_ = string;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp86_ = last_non_zero;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_string_truncate (_tmp85_, (gsize) _tmp86_);
#line 1672 "serializer.c"
	}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp88_ = string;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp89_ = _tmp88_->str;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (g_strcmp0 (_tmp89_, "0") != 0) {
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp87_ = TRUE;
#line 1682 "serializer.c"
	} else {
		gboolean _tmp90_ = FALSE;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp90_ = force_sign;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp87_ = _tmp90_;
#line 1689 "serializer.c"
	}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp87_) {
#line 1693 "serializer.c"
		Number* _tmp91_ = NULL;
		gboolean _tmp92_ = FALSE;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp91_ = x;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp92_ = number_is_negative (_tmp91_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp92_) {
#line 1702 "serializer.c"
			GString* _tmp93_ = NULL;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp93_ = string;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_prepend (_tmp93_, "−");
#line 1708 "serializer.c"
		} else {
			gboolean _tmp94_ = FALSE;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp94_ = force_sign;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp94_) {
#line 1715 "serializer.c"
				GString* _tmp95_ = NULL;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp95_ = string;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_prepend (_tmp95_, "+");
#line 1721 "serializer.c"
			}
		}
	}
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp96_ = number_base;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp97_ = self->priv->number_base;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp96_ != _tmp97_) {
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		static const gchar* sub_digits[] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
#line 1733 "serializer.c"
		gint multiplier = 0;
		gint b = 0;
		gint _tmp98_ = 0;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		multiplier = 1;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp98_ = number_base;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		b = _tmp98_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1745 "serializer.c"
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp99_ = number_base;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp100_ = multiplier;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!((_tmp99_ / _tmp100_) != 0)) {
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1757 "serializer.c"
			}
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp101_ = multiplier;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			multiplier = _tmp101_ * 10;
#line 1763 "serializer.c"
		}
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1767 "serializer.c"
			gint _tmp102_ = 0;
			gint d = 0;
			gint _tmp103_ = 0;
			gint _tmp104_ = 0;
			gint _tmp105_ = 0;
			GString* _tmp106_ = NULL;
			gint _tmp107_ = 0;
			const gchar* _tmp108_ = NULL;
			gint _tmp109_ = 0;
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp102_ = multiplier;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!(_tmp102_ != 1)) {
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1785 "serializer.c"
			}
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp103_ = multiplier;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			multiplier = _tmp103_ / 10;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp104_ = b;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp105_ = multiplier;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			d = _tmp104_ / _tmp105_;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp106_ = string;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp107_ = d;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp108_ = sub_digits[_tmp107_];
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_append (_tmp106_, _tmp108_);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp109_ = b;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp110_ = d;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp111_ = multiplier;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			b = _tmp109_ - (_tmp110_ * _tmp111_);
#line 1813 "serializer.c"
		}
	}
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (rounded_number);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (number);
#line 1822 "serializer.c"
}


static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits) {
	gint result = 0;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Number* mantissa = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* base_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* base3 = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* base10 = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* t = NULL;
	Number* _tmp11_ = NULL;
	Number* base10inv = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	gint exponent = 0;
	Number* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GString* _tmp64_ = NULL;
	Number* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, 0);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (string != NULL, 0);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = x;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = number_is_negative (_tmp0_);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp1_) {
#line 1867 "serializer.c"
		GString* _tmp2_ = NULL;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = string;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_string_append (_tmp2_, "−");
#line 1873 "serializer.c"
	}
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = x;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = number_abs (_tmp3_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	mantissa = _tmp4_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = self->priv->number_base;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = number_new_integer ((gint64) _tmp5_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base_ = _tmp6_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = base_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp8_ = number_xpowy_integer (_tmp7_, (gint64) 3);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base3 = _tmp8_;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = base_;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = number_xpowy_integer (_tmp9_, (gint64) 10);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base10 = _tmp10_;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp11_ = number_new_integer ((gint64) 1);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	t = _tmp11_;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp12_ = t;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp13_ = base10;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp14_ = number_divide (_tmp12_, _tmp13_);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base10inv = _tmp14_;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	exponent = 0;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp15_ = mantissa;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp16_ = number_is_zero (_tmp15_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (!_tmp16_) {
#line 1919 "serializer.c"
		Number* _tmp52_ = NULL;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1923 "serializer.c"
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gint _tmp22_ = 0;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			Number* _tmp25_ = NULL;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp18_ = eng_format;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp18_) {
#line 1934 "serializer.c"
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp19_ = mantissa;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp20_ = base10;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp21_ = number_compare (_tmp19_, _tmp20_);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp17_ = _tmp21_ >= 0;
#line 1946 "serializer.c"
			} else {
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp17_ = FALSE;
#line 1950 "serializer.c"
			}
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp17_) {
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1956 "serializer.c"
			}
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = exponent;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp22_ + 10;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp23_ = mantissa;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp24_ = base10inv;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = number_multiply (_tmp23_, _tmp24_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp25_;
#line 1972 "serializer.c"
		}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1976 "serializer.c"
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gint _tmp39_ = 0;
			Number* _tmp40_ = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = eng_format;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp28_) {
#line 1988 "serializer.c"
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gint _tmp31_ = 0;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp29_ = mantissa;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp30_ = base_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = number_compare (_tmp29_, _tmp30_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = _tmp31_ >= 0;
#line 2000 "serializer.c"
			} else {
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = FALSE;
#line 2004 "serializer.c"
			}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp27_) {
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp26_ = TRUE;
#line 2010 "serializer.c"
			} else {
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp33_ = eng_format;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (_tmp33_) {
#line 2018 "serializer.c"
					gboolean _tmp34_ = FALSE;
					Number* _tmp35_ = NULL;
					Number* _tmp36_ = NULL;
					gint _tmp37_ = 0;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp35_ = mantissa;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp36_ = base3;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp37_ = number_compare (_tmp35_, _tmp36_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp37_ >= 0) {
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp34_ = TRUE;
#line 2033 "serializer.c"
					} else {
						gint _tmp38_ = 0;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp38_ = exponent;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp34_ = (_tmp38_ % 3) != 0;
#line 2040 "serializer.c"
					}
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp32_ = _tmp34_;
#line 2044 "serializer.c"
				} else {
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp32_ = FALSE;
#line 2048 "serializer.c"
				}
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp26_ = _tmp32_;
#line 2052 "serializer.c"
			}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp26_) {
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 2058 "serializer.c"
			}
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp39_ = exponent;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp39_ + 1;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp40_ = mantissa;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp41_ = base_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp42_ = number_divide (_tmp40_, _tmp41_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp42_;
#line 2074 "serializer.c"
		}
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 2078 "serializer.c"
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			gint _tmp48_ = 0;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp44_ = eng_format;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp44_) {
#line 2089 "serializer.c"
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
				gint _tmp47_ = 0;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp45_ = mantissa;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp46_ = base10inv;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp47_ = number_compare (_tmp45_, _tmp46_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp43_ = _tmp47_ < 0;
#line 2101 "serializer.c"
			} else {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp43_ = FALSE;
#line 2105 "serializer.c"
			}
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp43_) {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 2111 "serializer.c"
			}
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp48_ = exponent;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp48_ - 10;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp49_ = mantissa;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp50_ = base10;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp51_ = number_multiply (_tmp49_, _tmp50_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp51_;
#line 2127 "serializer.c"
		}
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp52_ = number_new_integer ((gint64) 1);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (t);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		t = _tmp52_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 2137 "serializer.c"
			gboolean _tmp53_ = FALSE;
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			gint _tmp56_ = 0;
			gint _tmp60_ = 0;
			Number* _tmp61_ = NULL;
			Number* _tmp62_ = NULL;
			Number* _tmp63_ = NULL;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp54_ = mantissa;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp55_ = t;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp56_ = number_compare (_tmp54_, _tmp55_);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp56_ < 0) {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp53_ = TRUE;
#line 2156 "serializer.c"
			} else {
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp58_ = eng_format;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (_tmp58_) {
#line 2164 "serializer.c"
					gint _tmp59_ = 0;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp59_ = exponent;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp57_ = (_tmp59_ % 3) != 0;
#line 2170 "serializer.c"
				} else {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp57_ = FALSE;
#line 2174 "serializer.c"
				}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp53_ = _tmp57_;
#line 2178 "serializer.c"
			}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp53_) {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 2184 "serializer.c"
			}
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp60_ = exponent;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp60_ - 1;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp61_ = mantissa;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp62_ = base_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp63_ = number_multiply (_tmp61_, _tmp62_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp63_;
#line 2200 "serializer.c"
		}
	}
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp64_ = string;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp65_ = mantissa;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp66_ = serializer_cast_to_string (self, _tmp65_, n_digits);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp67_ = _tmp66_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_string_append (_tmp64_, _tmp67_);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (_tmp67_);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = exponent;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base10inv);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (t);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base10);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base3);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base_);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (mantissa);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 2231 "serializer.c"
}


static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_ = NULL;
	Number* x_real = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint exponent = 0;
	Number* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	GString* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Number* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GString* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = g_string_sized_new ((gsize) 1024);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	string = _tmp0_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = x;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = number_real_component (_tmp1_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	x_real = _tmp2_;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = x_real;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = string;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = eng_format;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = serializer_cast_to_exponential_string_real (self, _tmp3_, _tmp4_, _tmp5_, n_digits);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	exponent = _tmp6_;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = string;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp8_ = exponent;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	serializer_append_exponent (self, _tmp7_, _tmp8_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = x;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = number_is_complex (_tmp9_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp10_) {
#line 2290 "serializer.c"
		Number* x_im = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		GString* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GString* s = NULL;
		GString* _tmp16_ = NULL;
		gint n_complex_digits = 0;
		Number* _tmp17_ = NULL;
		GString* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		GString* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GString* _tmp50_ = NULL;
		gint _tmp51_ = 0;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = x;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp12_ = number_imaginary_component (_tmp11_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		x_im = _tmp12_;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp13_ = string;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp14_ = _tmp13_->str;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp14_, "0") == 0) {
#line 2323 "serializer.c"
			GString* _tmp15_ = NULL;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp15_ = string;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_assign (_tmp15_, "");
#line 2329 "serializer.c"
		}
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp16_ = g_string_sized_new ((gsize) 1024);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		s = _tmp16_;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		n_complex_digits = 0;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp17_ = x_im;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp18_ = s;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp19_ = eng_format;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp20_ = serializer_cast_to_exponential_string_real (self, _tmp17_, _tmp18_, _tmp19_, &n_complex_digits);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		exponent = _tmp20_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp21_ = n_complex_digits;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp22_ = *n_digits;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp21_ > _tmp22_) {
#line 2353 "serializer.c"
			gint _tmp23_ = 0;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp23_ = n_complex_digits;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			*n_digits = _tmp23_;
#line 2359 "serializer.c"
		}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp26_ = s;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp27_ = _tmp26_->str;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp27_, "0") == 0) {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = TRUE;
#line 2369 "serializer.c"
		} else {
			GString* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = s;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp29_ = _tmp28_->str;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = g_strcmp0 (_tmp29_, "+0") == 0;
#line 2379 "serializer.c"
		}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp25_) {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp24_ = TRUE;
#line 2385 "serializer.c"
		} else {
			GString* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp30_ = s;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp31_ = _tmp30_->str;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp24_ = g_strcmp0 (_tmp31_, "−0") == 0;
#line 2395 "serializer.c"
		}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp24_) {
#line 2399 "serializer.c"
		} else {
			GString* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp32_ = s;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp33_ = _tmp32_->str;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (g_strcmp0 (_tmp33_, "1") == 0) {
#line 2409 "serializer.c"
				GString* _tmp34_ = NULL;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp34_ = string;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_append (_tmp34_, "i");
#line 2415 "serializer.c"
			} else {
				GString* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp35_ = s;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp36_ = _tmp35_->str;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (g_strcmp0 (_tmp36_, "+1") == 0) {
#line 2425 "serializer.c"
					GString* _tmp37_ = NULL;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp37_ = string;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					g_string_append (_tmp37_, "+i");
#line 2431 "serializer.c"
				} else {
					GString* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp38_ = s;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp39_ = _tmp38_->str;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (g_strcmp0 (_tmp39_, "−1") == 0) {
#line 2441 "serializer.c"
						GString* _tmp40_ = NULL;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp40_ = string;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp40_, "−i");
#line 2447 "serializer.c"
					} else {
						GString* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						GString* _tmp49_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp41_ = s;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp42_ = _tmp41_->str;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						if (g_strcmp0 (_tmp42_, "+0") == 0) {
#line 2458 "serializer.c"
							GString* _tmp43_ = NULL;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp43_ = string;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							g_string_append (_tmp43_, "+");
#line 2464 "serializer.c"
						} else {
							GString* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp44_ = s;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp45_ = _tmp44_->str;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							if (g_strcmp0 (_tmp45_, "0") != 0) {
#line 2474 "serializer.c"
								GString* _tmp46_ = NULL;
								GString* _tmp47_ = NULL;
								const gchar* _tmp48_ = NULL;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp46_ = string;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp47_ = s;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp48_ = _tmp47_->str;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								g_string_append (_tmp46_, _tmp48_);
#line 2486 "serializer.c"
							}
						}
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp49_ = string;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp49_, "i");
#line 2493 "serializer.c"
					}
				}
			}
		}
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp50_ = string;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp51_ = exponent;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		serializer_append_exponent (self, _tmp50_, _tmp51_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_string_free0 (s);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (x_im);
#line 2508 "serializer.c"
	}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp52_ = string;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp53_ = _tmp52_->str;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp54_ = g_strdup (_tmp53_);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp54_;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (x_real);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_string_free0 (string);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 2524 "serializer.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2542 "serializer.c"
}


static void serializer_append_exponent (Serializer* self, GString* string, gint exponent) {
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	static const gunichar super_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
#line 2549 "serializer.c"
	gint _tmp0_ = 0;
	GString* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* super_value = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (string != NULL);
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = exponent;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp0_ == 0) {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		return;
#line 2566 "serializer.c"
	}
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = string;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_string_append (_tmp1_, "×10");
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = exponent;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp2_ < 0) {
#line 2576 "serializer.c"
		gint _tmp3_ = 0;
		GString* _tmp4_ = NULL;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp3_ = exponent;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		exponent = -_tmp3_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp4_ = string;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_string_append_unichar (_tmp4_, 8315U);
#line 2587 "serializer.c"
	}
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = exponent;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = g_strdup_printf ("%d", _tmp5_);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	super_value = _tmp6_;
#line 2595 "serializer.c"
	{
		gint i = 0;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		i = 0;
#line 2600 "serializer.c"
		{
			gboolean _tmp7_ = FALSE;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp7_ = TRUE;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			while (TRUE) {
#line 2607 "serializer.c"
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				GString* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gchar _tmp16_ = '\0';
				gunichar _tmp17_ = 0U;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (!_tmp7_) {
#line 2619 "serializer.c"
					gint _tmp8_ = 0;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp8_ = i;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					i = _tmp8_ + 1;
#line 2625 "serializer.c"
				}
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp7_ = FALSE;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp9_ = i;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp10_ = super_value;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp11_ = strlen (_tmp10_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp12_ = _tmp11_;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (!(_tmp9_ < _tmp12_)) {
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					break;
#line 2641 "serializer.c"
				}
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp13_ = string;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp14_ = super_value;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp15_ = i;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp17_ = super_digits[_tmp16_ - '0'];
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_append_unichar (_tmp13_, _tmp17_);
#line 2655 "serializer.c"
			}
		}
	}
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (super_value);
#line 2661 "serializer.c"
}


static void serializer_class_init (SerializerClass * klass) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	serializer_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_type_class_add_private (klass, sizeof (SerializerPrivate));
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
#line 2672 "serializer.c"
}


static void serializer_instance_init (Serializer * self) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv = SERIALIZER_GET_PRIVATE (self);
#line 2679 "serializer.c"
}


static void serializer_finalize (GObject* obj) {
	Serializer * self;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
#line 2689 "serializer.c"
}


GType serializer_get_type (void) {
	static volatile gsize serializer_type_id__volatile = 0;
	if (g_once_init_enter (&serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
		GType serializer_type_id;
		serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
		g_once_init_leave (&serializer_type_id__volatile, serializer_type_id);
	}
	return serializer_type_id__volatile;
}



