/* number.c generated by valac 0.26.0.50-d9a75, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */
/* Size of the multiple precision values */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
	gint re_sign;
	gint im_sign;
	gint re_exponent;
	gint im_exponent;
	gint re_fraction[1000];
	gint im_fraction[1000];
};

struct _NumberClass {
	GObjectClass parent_class;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
extern gchar* mp_error;
gchar* mp_error = NULL;

#define SIZE 1000
#define BASE 10000
#define T 100
GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
enum  {
	NUMBER_DUMMY_PROPERTY
};
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
void mp_gcd (gint64* k, gint64* l);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_new_float (gfloat value);
Number* number_construct_float (GType object_type, gfloat value);
void mp_normalize (Number** x);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_multiply (Number* self, Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_epowy (Number* self);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gboolean number_is_zero (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
Number* number_divide (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_equals (Number* self, Number* y);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
gint number_compare (Number* self, Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
static Number* number_copy (Number* self);
Number* number_abs (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_add (Number* self, Number* y);
Number* number_root (Number* self, gint64 n);
Number* number_arg (Number* self, AngleUnit unit);
void mperr (const gchar* text);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_subtract (Number* self, Number* y);
static Number* number_from_radians (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_new (void);
Number* number_construct (GType object_type);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
static Number* number_reciprocal_real (Number* self);
static Number* number_epowy_real (Number* self);
Number* number_xpowy (Number* self, Number* y);
Number* number_xpowy_integer (Number* self, gint64 n);
static Number* number_pwr (Number* self, Number* y);
static Number* number_root_real (Number* self, gint64 n);
Number* number_sqrt (Number* self);
static Number* number_ext (Number* self, gint i, gint j);
Number* number_ln (Number* self);
static Number* number_ln_real (Number* self);
Number* number_logarithm (Number* self, gint64 n);
Number* number_factorial (Number* self);
static Number* number_add_with_sign (Number* self, gint y_sign, Number* y);
static Number* number_multiply_real (Number* self, Number* y);
static Number* number_multiply_integer_real (Number* self, gint64 y);
static Number* number_divide_integer_real (Number* self, gint64 y);
Number* number_modulus_divide (Number* self, Number* y);
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* number_sin_real (Number* self, AngleUnit unit);
Number* number_cosh (Number* self);
static Number* number_cos_real (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_tan (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self, Number* y);
static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen);
static gint __lambda4_ (Number* self, gint v1, gint v2);
static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_or (Number* self, Number* y);
static gint __lambda5_ (Number* self, gint v1, gint v2);
static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_xor (Number* self, Number* y);
static gint __lambda6_ (Number* self, gint v1, gint v2);
static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_not (Number* self, gint wordlen);
static gint __lambda7_ (Number* self, gint v1, gint v2);
static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_mask (Number* self, Number* x, gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_shift (Number* self, gint count);
Number* number_ones_complement (Number* self, gint wordlen);
static gint __lambda8_ (Number* self, gint v1, gint v2);
static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_twos_complement (Number* self, gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self, guint64 n);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static Number* number_add_real (Number* self, gint y_sign, Number* y);
static Number* number_exp (Number* self);
static Number* number_lns (Number* self);
static gint* _vala_array_dup12 (gint* self, int length);
static gint* _vala_array_dup13 (gint* self, int length);
static gint* _vala_array_dup14 (gint* self, int length);
static gint* _vala_array_dup15 (gint* self, int length);
static Number* number_to_radians (Number* self, AngleUnit unit);
static Number* number_sin1 (Number* self, gboolean do_sin);
static gint number_hex_to_int (Number* self, gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gchar* serializer_to_string (Serializer* self, Number* x);
static void number_finalize (GObject* obj);
gchar* mp_get_error (void);
void mp_clear_error (void);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c, gint number_base);
gboolean mp_is_overflow (Number* x, gint wordlen);


GType angle_unit_get_type (void) {
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number* number_construct_integer (GType object_type, gint64 value) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = value;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ < ((gint64) 0)) {
#line 277 "number.c"
		gint64 _tmp1_ = 0LL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = value;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		value = -_tmp1_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_sign = -1;
#line 285 "number.c"
	} else {
		gint64 _tmp2_ = 0LL;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = value;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_ > ((gint64) 0)) {
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			self->re_sign = 1;
#line 294 "number.c"
		} else {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			self->re_sign = 0;
#line 298 "number.c"
		}
	}
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 303 "number.c"
		gint64 _tmp3_ = 0LL;
		gint _tmp4_ = 0;
		gint64 _tmp5_ = 0LL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint64 _tmp8_ = 0LL;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = value;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp3_ != ((gint64) 0))) {
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 316 "number.c"
		}
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = self->re_exponent;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = value;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_fraction[_tmp4_] = (gint) (_tmp5_ % BASE);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = self->re_fraction[_tmp4_];
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = self->re_exponent;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_exponent = _tmp7_ + 1;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = value;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		value = _tmp8_ / BASE;
#line 334 "number.c"
	}
	{
		gint i = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 340 "number.c"
		{
			gboolean _tmp9_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = TRUE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 347 "number.c"
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint t = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp9_) {
#line 364 "number.c"
					gint _tmp10_ = 0;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = i;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp10_ + 1;
#line 370 "number.c"
				}
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = i;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = self->re_exponent;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp11_ < (_tmp12_ / 2))) {
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 382 "number.c"
				}
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = i;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = self->re_fraction[_tmp13_];
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = _tmp14_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = i;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = self->re_exponent;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = self->re_fraction[(_tmp16_ - _tmp17_) - 1];
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[_tmp15_] = _tmp18_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = self->re_fraction[_tmp15_];
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = self->re_exponent;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = i;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = t;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[(_tmp20_ - _tmp21_) - 1] = _tmp22_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = self->re_fraction[(_tmp20_ - _tmp21_) - 1];
#line 412 "number.c"
			}
		}
	}
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 418 "number.c"
}


Number* number_new_integer (gint64 value) {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_integer (TYPE_NUMBER, value);
#line 425 "number.c"
}


Number* number_construct_unsigned_integer (GType object_type, guint64 x) {
	Number * self = NULL;
	guint64 _tmp0_ = 0ULL;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = x;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ == ((guint64) 0)) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_sign = 0;
#line 440 "number.c"
	} else {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_sign = 1;
#line 444 "number.c"
	}
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 448 "number.c"
		guint64 _tmp1_ = 0ULL;
		gint _tmp2_ = 0;
		guint64 _tmp3_ = 0ULL;
		gint _tmp4_ = 0;
		guint64 _tmp5_ = 0ULL;
		gint _tmp6_ = 0;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = x;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp1_ != ((guint64) 0))) {
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 461 "number.c"
		}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->re_exponent;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_fraction[_tmp2_] = (gint) (_tmp3_ % BASE);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = self->re_fraction[_tmp2_];
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = x;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x = _tmp5_ / BASE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = self->re_exponent;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_exponent = _tmp6_ + 1;
#line 479 "number.c"
	}
	{
		gint i = 0;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 485 "number.c"
		{
			gboolean _tmp7_ = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = TRUE;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 492 "number.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint t = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp7_) {
#line 509 "number.c"
					gint _tmp8_ = 0;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = i;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp8_ + 1;
#line 515 "number.c"
				}
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = i;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = self->re_exponent;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp9_ < (_tmp10_ / 2))) {
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 527 "number.c"
				}
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = i;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = self->re_fraction[_tmp11_];
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = _tmp12_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = i;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = self->re_exponent;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = i;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = self->re_fraction[(_tmp14_ - _tmp15_) - 1];
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[_tmp13_] = _tmp16_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = self->re_fraction[_tmp13_];
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = self->re_exponent;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = i;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = t;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[(_tmp18_ - _tmp19_) - 1] = _tmp20_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = self->re_fraction[(_tmp18_ - _tmp19_) - 1];
#line 557 "number.c"
			}
		}
	}
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 563 "number.c"
}


Number* number_new_unsigned_integer (guint64 x) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_unsigned_integer (TYPE_NUMBER, x);
#line 570 "number.c"
}


Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_gcd (&numerator, &denominator);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = denominator;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ < ((gint64) 0)) {
#line 585 "number.c"
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = numerator;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		numerator = -_tmp1_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = denominator;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		denominator = -_tmp2_;
#line 596 "number.c"
	}
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = numerator;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_integer (object_type, _tmp3_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = denominator;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ != ((gint64) 1)) {
#line 606 "number.c"
		Number* z = NULL;
		gint64 _tmp5_ = 0LL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		Number* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = denominator;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_divide_integer (self, _tmp5_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp6_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = z;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _tmp7_->re_sign;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_sign = _tmp8_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = z;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _tmp9_->im_sign;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->im_sign = _tmp10_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = z;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = _tmp11_->re_exponent;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->re_exponent = _tmp12_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = z;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = _tmp13_->im_exponent;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		self->im_exponent = _tmp14_;
#line 648 "number.c"
		{
			gint i = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 653 "number.c"
			{
				gboolean _tmp15_ = FALSE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = TRUE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 660 "number.c"
					gint _tmp17_ = 0;
					Number* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					Number* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					Number* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp15_) {
#line 675 "number.c"
						gint _tmp16_ = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp16_ = i;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp16_ + 1;
#line 681 "number.c"
					}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = FALSE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp17_ = i;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp18_ = z;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp17_ < 1000)) {
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 693 "number.c"
					}
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_ = i;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = z;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = i;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp22_ = _tmp20_->re_fraction[_tmp21_];
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					self->re_fraction[_tmp19_] = _tmp22_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = self->re_fraction[_tmp19_];
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = i;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = z;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp26_ = i;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = _tmp25_->im_fraction[_tmp26_];
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					self->im_fraction[_tmp24_] = _tmp27_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = self->im_fraction[_tmp24_];
#line 719 "number.c"
				}
			}
		}
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 725 "number.c"
	}
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 729 "number.c"
}


Number* number_new_fraction (gint64 numerator, gint64 denominator) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
#line 736 "number.c"
}


Number* number_construct_float (GType object_type, gfloat value) {
	Number * self = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gfloat _tmp1_ = 0.0F;
	Number* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	Number* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	Number* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	Number* _tmp67_ = NULL;
	gint _tmp68_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = value;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ != ((gfloat) 0)) {
#line 763 "number.c"
		gfloat rj = 0.0F;
		gfloat _tmp2_ = 0.0F;
		gint ie = 0;
		Number* _tmp14_ = NULL;
		gint ib = 0;
		gint _tmp27_ = 0;
		gint tp = 0;
		gint _tmp28_ = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		rj = 0.f;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = value;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_ < 0.0f) {
#line 778 "number.c"
			Number* _tmp3_ = NULL;
			gfloat _tmp4_ = 0.0F;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = z;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_->re_sign = -1;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = value;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			rj = -_tmp4_;
#line 789 "number.c"
		} else {
			gfloat _tmp5_ = 0.0F;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = value;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp5_ > 0.0f) {
#line 796 "number.c"
				Number* _tmp6_ = NULL;
				gfloat _tmp7_ = 0.0F;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = z;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_->re_sign = 1;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = value;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				rj = _tmp7_;
#line 807 "number.c"
			}
		}
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ie = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 814 "number.c"
			gfloat _tmp8_ = 0.0F;
			gint _tmp9_ = 0;
			gfloat _tmp10_ = 0.0F;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = rj;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!(_tmp8_ >= 1.0f)) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 824 "number.c"
			}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = ie;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ie = _tmp9_ + 1;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = rj;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			rj = _tmp10_ * 0.0625f;
#line 834 "number.c"
		}
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 838 "number.c"
			gfloat _tmp11_ = 0.0F;
			gint _tmp12_ = 0;
			gfloat _tmp13_ = 0.0F;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = rj;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!(_tmp11_ < 0.0625f)) {
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 848 "number.c"
			}
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = ie;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ie = _tmp12_ - 1;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = rj;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			rj = _tmp13_ * 16.0f;
#line 858 "number.c"
		}
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = z;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_->re_exponent = 0;
#line 864 "number.c"
		{
			gint i = 0;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 869 "number.c"
			{
				gboolean _tmp15_ = FALSE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = TRUE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 876 "number.c"
					gint _tmp17_ = 0;
					gfloat _tmp18_ = 0.0F;
					Number* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gfloat _tmp21_ = 0.0F;
					gint _tmp22_ = 0;
					gfloat _tmp23_ = 0.0F;
					Number* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp15_) {
#line 889 "number.c"
						gint _tmp16_ = 0;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp16_ = i;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp16_ + 1;
#line 895 "number.c"
					}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = FALSE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp17_ = i;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp17_ < (T + 4))) {
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 905 "number.c"
					}
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp18_ = rj;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					rj = _tmp18_ * BASE;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_ = z;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = i;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = rj;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_->re_fraction[_tmp20_] = (gint) _tmp21_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp22_ = _tmp19_->re_fraction[_tmp20_];
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = rj;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = z;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = i;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp26_ = _tmp24_->re_fraction[_tmp25_];
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					rj = _tmp23_ - _tmp26_;
#line 931 "number.c"
				}
			}
		}
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mp_normalize (&z);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = MAX ((BASE * 7) * BASE, 32767);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ib = _tmp27_ / 16;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tp = 1;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = ie;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp28_ < 0) {
#line 947 "number.c"
			gint k = 0;
			gint _tmp29_ = 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = ie;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			k = -_tmp29_;
#line 954 "number.c"
			{
				gint i = 0;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				i = 1;
#line 959 "number.c"
				{
					gboolean _tmp30_ = FALSE;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp30_ = TRUE;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					while (TRUE) {
#line 966 "number.c"
						gint _tmp32_ = 0;
						gint _tmp33_ = 0;
						gint _tmp34_ = 0;
						gboolean _tmp35_ = FALSE;
						gboolean _tmp36_ = FALSE;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						Number* _tmp42_ = NULL;
						gint _tmp43_ = 0;
						Number* _tmp44_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp30_) {
#line 979 "number.c"
							gint _tmp31_ = 0;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp31_ = i;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							i = _tmp31_ + 1;
#line 985 "number.c"
						}
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp30_ = FALSE;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp32_ = i;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp33_ = k;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!(_tmp32_ <= _tmp33_)) {
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							break;
#line 997 "number.c"
						}
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp34_ = tp;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						tp = _tmp34_ << 4;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp37_ = tp;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp38_ = ib;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp37_ <= _tmp38_) {
#line 1009 "number.c"
							gint _tmp39_ = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp39_ = tp;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp36_ = _tmp39_ != BASE;
#line 1015 "number.c"
						} else {
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp36_ = FALSE;
#line 1019 "number.c"
						}
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp36_) {
#line 1023 "number.c"
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp40_ = i;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp41_ = k;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp35_ = _tmp40_ < _tmp41_;
#line 1032 "number.c"
						} else {
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp35_ = FALSE;
#line 1036 "number.c"
						}
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp35_) {
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							continue;
#line 1042 "number.c"
						}
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp42_ = z;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp43_ = tp;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp44_ = number_divide_integer (_tmp42_, (gint64) _tmp43_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						z = _tmp44_;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						tp = 1;
#line 1056 "number.c"
					}
				}
			}
		} else {
			gint _tmp45_ = 0;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp45_ = ie;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp45_ > 0) {
#line 1066 "number.c"
				{
					gint i = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = 1;
#line 1071 "number.c"
					{
						gboolean _tmp46_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp46_ = TRUE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						while (TRUE) {
#line 1078 "number.c"
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gboolean _tmp51_ = FALSE;
							gboolean _tmp52_ = FALSE;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							Number* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							Number* _tmp60_ = NULL;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!_tmp46_) {
#line 1091 "number.c"
								gint _tmp47_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp47_ = i;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								i = _tmp47_ + 1;
#line 1097 "number.c"
							}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp46_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp48_ = i;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp49_ = ie;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!(_tmp48_ <= _tmp49_)) {
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								break;
#line 1109 "number.c"
							}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp50_ = tp;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							tp = _tmp50_ << 4;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp53_ = tp;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp54_ = ib;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp53_ <= _tmp54_) {
#line 1121 "number.c"
								gint _tmp55_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp55_ = tp;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp52_ = _tmp55_ != BASE;
#line 1127 "number.c"
							} else {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp52_ = FALSE;
#line 1131 "number.c"
							}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp52_) {
#line 1135 "number.c"
								gint _tmp56_ = 0;
								gint _tmp57_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp56_ = i;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp57_ = ie;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp51_ = _tmp56_ < _tmp57_;
#line 1144 "number.c"
							} else {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp51_ = FALSE;
#line 1148 "number.c"
							}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp51_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								continue;
#line 1154 "number.c"
							}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp58_ = z;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp59_ = tp;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp60_ = number_multiply_integer (_tmp58_, (gint64) _tmp59_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (z);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							z = _tmp60_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							tp = 1;
#line 1168 "number.c"
						}
					}
				}
			}
		}
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp61_ = z;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp62_ = _tmp61_->re_sign;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_sign = _tmp62_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp63_ = z;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp64_ = _tmp63_->im_sign;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_sign = _tmp64_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp65_ = z;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp66_ = _tmp65_->re_exponent;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_exponent = _tmp66_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp67_ = z;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp68_ = _tmp67_->im_exponent;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_exponent = _tmp68_;
#line 1199 "number.c"
	{
		gint i = 0;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 1204 "number.c"
		{
			gboolean _tmp69_ = FALSE;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp69_ = TRUE;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 1211 "number.c"
				gint _tmp71_ = 0;
				Number* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				Number* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				Number* _tmp79_ = NULL;
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp69_) {
#line 1226 "number.c"
					gint _tmp70_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp70_ = i;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp70_ + 1;
#line 1232 "number.c"
				}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp69_ = FALSE;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp71_ = i;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp72_ = z;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp71_ < 1000)) {
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 1244 "number.c"
				}
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp73_ = i;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp74_ = z;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp75_ = i;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp76_ = _tmp74_->re_fraction[_tmp75_];
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[_tmp73_] = _tmp76_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp77_ = self->re_fraction[_tmp73_];
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp78_ = i;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp79_ = z;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp80_ = i;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp81_ = _tmp79_->im_fraction[_tmp80_];
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->im_fraction[_tmp78_] = _tmp81_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp82_ = self->im_fraction[_tmp78_];
#line 1270 "number.c"
			}
		}
	}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 1278 "number.c"
}


Number* number_new_float (gfloat value) {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_float (TYPE_NUMBER, value);
#line 1285 "number.c"
}


Number* number_construct_double (GType object_type, gdouble value) {
	Number * self = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	Number* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	Number* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	Number* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	Number* _tmp69_ = NULL;
	gint _tmp70_ = 0;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = value;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ != ((gdouble) 0)) {
#line 1312 "number.c"
		gdouble dj = 0.0;
		gdouble _tmp2_ = 0.0;
		gint ie = 0;
		Number* _tmp16_ = NULL;
		gint ib = 0;
		gint _tmp29_ = 0;
		gint tp = 0;
		gint _tmp30_ = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		dj = 0.0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = value;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_ < 0.0) {
#line 1327 "number.c"
			Number* _tmp3_ = NULL;
			gdouble _tmp4_ = 0.0;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = z;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_->re_sign = -1;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = value;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			dj = -_tmp4_;
#line 1338 "number.c"
		} else {
			gdouble _tmp5_ = 0.0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = value;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp5_ > 0.0) {
#line 1345 "number.c"
				Number* _tmp6_ = NULL;
				gdouble _tmp7_ = 0.0;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = z;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_->re_sign = 1;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = value;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				dj = _tmp7_;
#line 1356 "number.c"
			}
		}
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ie = 0;
#line 1361 "number.c"
		{
			gboolean _tmp8_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ie = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = TRUE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 1370 "number.c"
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp8_) {
#line 1375 "number.c"
					gint _tmp9_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp9_ = ie;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ie = _tmp9_ + 1;
#line 1381 "number.c"
				}
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = dj;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp10_ >= 1.0)) {
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 1391 "number.c"
				}
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = dj;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				dj = _tmp11_ * (1.0 / 16.0);
#line 1397 "number.c"
			}
		}
		{
			gboolean _tmp12_ = FALSE;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = TRUE;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 1406 "number.c"
				gdouble _tmp14_ = 0.0;
				gdouble _tmp15_ = 0.0;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp12_) {
#line 1411 "number.c"
					gint _tmp13_ = 0;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = ie;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ie = _tmp13_ - 1;
#line 1417 "number.c"
				}
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = FALSE;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = dj;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp14_ < (1.0 / 16.0))) {
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 1427 "number.c"
				}
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = dj;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				dj = _tmp15_ * 16.0;
#line 1433 "number.c"
			}
		}
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_->re_exponent = 0;
#line 1440 "number.c"
		{
			gint i = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 1445 "number.c"
			{
				gboolean _tmp17_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = TRUE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 1452 "number.c"
					gint _tmp19_ = 0;
					gdouble _tmp20_ = 0.0;
					Number* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gdouble _tmp23_ = 0.0;
					gint _tmp24_ = 0;
					gdouble _tmp25_ = 0.0;
					Number* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp17_) {
#line 1465 "number.c"
						gint _tmp18_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp18_ = i;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp18_ + 1;
#line 1471 "number.c"
					}
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp17_ = FALSE;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_ = i;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp19_ < (T + 4))) {
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 1481 "number.c"
					}
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = dj;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					dj = _tmp20_ * ((gdouble) BASE);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = z;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp22_ = i;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = dj;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_->re_fraction[_tmp22_] = (gint) _tmp23_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = _tmp21_->re_fraction[_tmp22_];
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = dj;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp26_ = z;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = i;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = _tmp26_->re_fraction[_tmp27_];
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					dj = _tmp25_ - ((gdouble) _tmp28_);
#line 1507 "number.c"
				}
			}
		}
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mp_normalize (&z);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = MAX ((BASE * 7) * BASE, 32767);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ib = _tmp29_ / 16;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tp = 1;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = ie;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp30_ < 0) {
#line 1523 "number.c"
			gint k = 0;
			gint _tmp31_ = 0;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = ie;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			k = -_tmp31_;
#line 1530 "number.c"
			{
				gint i = 0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				i = 1;
#line 1535 "number.c"
				{
					gboolean _tmp32_ = FALSE;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp32_ = TRUE;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					while (TRUE) {
#line 1542 "number.c"
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						gint _tmp36_ = 0;
						gboolean _tmp37_ = FALSE;
						gboolean _tmp38_ = FALSE;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
						Number* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						Number* _tmp46_ = NULL;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp32_) {
#line 1555 "number.c"
							gint _tmp33_ = 0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp33_ = i;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							i = _tmp33_ + 1;
#line 1561 "number.c"
						}
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp32_ = FALSE;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp34_ = i;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp35_ = k;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!(_tmp34_ <= _tmp35_)) {
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							break;
#line 1573 "number.c"
						}
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp36_ = tp;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						tp = _tmp36_ << 4;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp39_ = tp;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp40_ = ib;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp39_ <= _tmp40_) {
#line 1585 "number.c"
							gint _tmp41_ = 0;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp41_ = tp;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp38_ = _tmp41_ != BASE;
#line 1591 "number.c"
						} else {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp38_ = FALSE;
#line 1595 "number.c"
						}
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp38_) {
#line 1599 "number.c"
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp42_ = i;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp43_ = k;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp37_ = _tmp42_ < _tmp43_;
#line 1608 "number.c"
						} else {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp37_ = FALSE;
#line 1612 "number.c"
						}
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp37_) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							continue;
#line 1618 "number.c"
						}
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp44_ = z;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp45_ = tp;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp46_ = number_divide_integer (_tmp44_, (gint64) _tmp45_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						z = _tmp46_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						tp = 1;
#line 1632 "number.c"
					}
				}
			}
		} else {
			gint _tmp47_ = 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp47_ = ie;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp47_ > 0) {
#line 1642 "number.c"
				{
					gint i = 0;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = 1;
#line 1647 "number.c"
					{
						gboolean _tmp48_ = FALSE;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp48_ = TRUE;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						while (TRUE) {
#line 1654 "number.c"
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gboolean _tmp53_ = FALSE;
							gboolean _tmp54_ = FALSE;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							Number* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							Number* _tmp62_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!_tmp48_) {
#line 1667 "number.c"
								gint _tmp49_ = 0;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp49_ = i;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								i = _tmp49_ + 1;
#line 1673 "number.c"
							}
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp48_ = FALSE;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp50_ = i;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp51_ = ie;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!(_tmp50_ <= _tmp51_)) {
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								break;
#line 1685 "number.c"
							}
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp52_ = tp;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							tp = _tmp52_ << 4;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp55_ = tp;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp56_ = ib;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp55_ <= _tmp56_) {
#line 1697 "number.c"
								gint _tmp57_ = 0;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp57_ = tp;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp54_ = _tmp57_ != BASE;
#line 1703 "number.c"
							} else {
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp54_ = FALSE;
#line 1707 "number.c"
							}
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp54_) {
#line 1711 "number.c"
								gint _tmp58_ = 0;
								gint _tmp59_ = 0;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp58_ = i;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp59_ = ie;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp53_ = _tmp58_ < _tmp59_;
#line 1720 "number.c"
							} else {
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp53_ = FALSE;
#line 1724 "number.c"
							}
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp53_) {
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								continue;
#line 1730 "number.c"
							}
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp60_ = z;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp61_ = tp;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp62_ = number_multiply_integer (_tmp60_, (gint64) _tmp61_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (z);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							z = _tmp62_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							tp = 1;
#line 1744 "number.c"
						}
					}
				}
			}
		}
	}
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp63_ = z;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp64_ = _tmp63_->re_sign;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_sign = _tmp64_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp65_ = z;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp66_ = _tmp65_->im_sign;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_sign = _tmp66_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp67_ = z;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp68_ = _tmp67_->re_exponent;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_exponent = _tmp68_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp69_ = z;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp70_ = _tmp69_->im_exponent;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_exponent = _tmp70_;
#line 1775 "number.c"
	{
		gint i = 0;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 1780 "number.c"
		{
			gboolean _tmp71_ = FALSE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp71_ = TRUE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 1787 "number.c"
				gint _tmp73_ = 0;
				Number* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				Number* _tmp76_ = NULL;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				Number* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp71_) {
#line 1802 "number.c"
					gint _tmp72_ = 0;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp72_ = i;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp72_ + 1;
#line 1808 "number.c"
				}
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp71_ = FALSE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp73_ = i;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp74_ = z;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp73_ < 1000)) {
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 1820 "number.c"
				}
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp75_ = i;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp76_ = z;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp77_ = i;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp78_ = _tmp76_->re_fraction[_tmp77_];
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[_tmp75_] = _tmp78_;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp79_ = self->re_fraction[_tmp75_];
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp80_ = i;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp81_ = z;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp82_ = i;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp83_ = _tmp81_->im_fraction[_tmp82_];
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->im_fraction[_tmp80_] = _tmp83_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp84_ = self->im_fraction[_tmp80_];
#line 1846 "number.c"
			}
		}
	}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 1854 "number.c"
}


Number* number_new_double (gdouble value) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_double (TYPE_NUMBER, value);
#line 1861 "number.c"
}


Number* number_construct_complex (GType object_type, Number* x, Number* y) {
	Number * self = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Number* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Number* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = x;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_->re_sign;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_sign = _tmp1_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = x;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_->re_exponent;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_exponent = _tmp3_;
#line 1893 "number.c"
	{
		gint i = 0;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 1898 "number.c"
		{
			gboolean _tmp4_ = FALSE;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = TRUE;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 1905 "number.c"
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Number* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp4_) {
#line 1914 "number.c"
					gint _tmp5_ = 0;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp5_ = i;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp5_ + 1;
#line 1920 "number.c"
				}
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp4_ = FALSE;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = i;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp6_ < 1000)) {
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 1930 "number.c"
				}
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = i;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = x;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = i;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = _tmp8_->re_fraction[_tmp9_];
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[_tmp7_] = _tmp10_;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = self->re_fraction[_tmp7_];
#line 1944 "number.c"
			}
		}
	}
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = y;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_->re_sign;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_sign = _tmp13_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = y;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = _tmp14_->re_exponent;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_exponent = _tmp15_;
#line 1960 "number.c"
	{
		gint i = 0;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 1965 "number.c"
		{
			gboolean _tmp16_ = FALSE;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp16_ = TRUE;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 1972 "number.c"
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp16_) {
#line 1981 "number.c"
					gint _tmp17_ = 0;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp17_ = i;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp17_ + 1;
#line 1987 "number.c"
				}
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = FALSE;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = i;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp18_ < 1000)) {
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 1997 "number.c"
				}
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = i;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = y;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = i;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = _tmp20_->re_fraction[_tmp21_];
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->im_fraction[_tmp19_] = _tmp22_;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = self->im_fraction[_tmp19_];
#line 2011 "number.c"
			}
		}
	}
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 2017 "number.c"
}


Number* number_new_complex (Number* x, Number* y) {
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_complex (TYPE_NUMBER, x, y);
#line 2024 "number.c"
}


Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit) {
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	AngleUnit _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Number* y = NULL;
	Number* _tmp3_ = NULL;
	AngleUnit _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (theta != NULL, NULL);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = theta;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = unit;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_cos (_tmp0_, _tmp1_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x = _tmp2_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = theta;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = unit;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_sin (_tmp3_, _tmp4_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	y = _tmp5_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = r;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_multiply (x, _tmp6_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = r;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_multiply (y, _tmp9_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_complex (object_type, _tmp8_, _tmp11_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp11_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (y);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 2088 "number.c"
}


Number* number_new_polar (Number* r, Number* theta, AngleUnit unit) {
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
#line 2095 "number.c"
}


Number* number_construct_eulers (GType object_type) {
	Number * self = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	gint _tmp11_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 1);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_epowy (_tmp1_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp3_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = z;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_->re_sign;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_sign = _tmp5_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = z;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_->im_sign;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_sign = _tmp7_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = z;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_->re_exponent;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->re_exponent = _tmp9_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = z;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_->im_exponent;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_exponent = _tmp11_;
#line 2152 "number.c"
	{
		gint i = 0;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 2157 "number.c"
		{
			gboolean _tmp12_ = FALSE;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = TRUE;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2164 "number.c"
				gint _tmp14_ = 0;
				Number* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				Number* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				Number* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp12_) {
#line 2179 "number.c"
					gint _tmp13_ = 0;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = i;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp13_ + 1;
#line 2185 "number.c"
				}
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = FALSE;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = i;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = z;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp14_ < 1000)) {
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2197 "number.c"
				}
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = i;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = z;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = i;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = _tmp17_->re_fraction[_tmp18_];
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->re_fraction[_tmp16_] = _tmp19_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = self->re_fraction[_tmp16_];
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = i;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = z;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = i;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = _tmp22_->im_fraction[_tmp23_];
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				self->im_fraction[_tmp21_] = _tmp24_;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = self->im_fraction[_tmp21_];
#line 2223 "number.c"
			}
		}
	}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 2231 "number.c"
}


Number* number_new_eulers (void) {
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_eulers (TYPE_NUMBER);
#line 2238 "number.c"
}


Number* number_construct_i (GType object_type) {
	Number * self = NULL;
	gint _tmp0_ = 0;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_sign = 1;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_exponent = 1;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->im_fraction[0] = 1;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->im_fraction[0];
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 2257 "number.c"
}


Number* number_new_i (void) {
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_i (TYPE_NUMBER);
#line 2264 "number.c"
}


Number* number_construct_pi (GType object_type) {
	Number * self = NULL;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_double (object_type, G_PI);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 2274 "number.c"
}


Number* number_new_pi (void) {
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_pi (TYPE_NUMBER);
#line 2281 "number.c"
}


Number* number_construct_random (GType object_type) {
	Number * self = NULL;
	gdouble _tmp0_ = 0.0;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = g_random_double ();
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_double (object_type, _tmp0_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 2294 "number.c"
}


Number* number_new_random (void) {
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_random (TYPE_NUMBER);
#line 2301 "number.c"
}


gint64 number_to_integer (Number* self) {
	gint64 result = 0LL;
	gint64 z = 0LL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint64 v = 0LL;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp24_ = 0LL;
	gint _tmp25_ = 0;
	gint64 _tmp26_ = 0LL;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = (gint64) 0;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->re_sign;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ == 0) {
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 2325 "number.c"
	} else {
		gint _tmp2_ = 0;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->re_exponent;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ <= 0;
#line 2332 "number.c"
	}
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (gint64) 0;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2340 "number.c"
	}
	{
		gint i = 0;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 2346 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2353 "number.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint64 t = 0LL;
				gint64 _tmp7_ = 0LL;
				gint64 _tmp8_ = 0LL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp3_) {
#line 2365 "number.c"
					gint _tmp4_ = 0;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = i;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp4_ + 1;
#line 2371 "number.c"
				}
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = FALSE;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = i;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = self->re_exponent;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2383 "number.c"
				}
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = z;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = _tmp7_;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = z;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = i;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = self->re_fraction[_tmp9_];
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = (_tmp8_ * BASE) + _tmp10_;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = z;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = t;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp11_ <= _tmp12_) {
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = (gint64) 0;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 2407 "number.c"
				}
			}
		}
	}
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = z;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	v = _tmp13_;
#line 2416 "number.c"
	{
		gint i = 0;
		gint _tmp14_ = 0;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = self->re_exponent;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp14_ - 1;
#line 2424 "number.c"
		{
			gboolean _tmp15_ = FALSE;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = TRUE;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2431 "number.c"
				gint _tmp17_ = 0;
				gint64 digit = 0LL;
				gint64 _tmp18_ = 0LL;
				gint64 _tmp19_ = 0LL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint64 _tmp22_ = 0LL;
				gint64 _tmp23_ = 0LL;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp15_) {
#line 2442 "number.c"
					gint _tmp16_ = 0;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = i;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp16_ - 1;
#line 2448 "number.c"
				}
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = FALSE;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp17_ >= 0)) {
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2458 "number.c"
				}
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = v;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = v;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				digit = _tmp18_ - ((_tmp19_ / BASE) * BASE);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = i;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = self->re_fraction[_tmp20_];
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = digit;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (((gint64) _tmp21_) != _tmp22_) {
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = (gint64) 0;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 2478 "number.c"
				}
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = v;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				v = _tmp23_ / BASE;
#line 2484 "number.c"
			}
		}
	}
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = v;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp24_ != ((gint64) 0)) {
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (gint64) 0;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2496 "number.c"
	}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = self->re_sign;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = z;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp25_ * _tmp26_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2506 "number.c"
}


guint64 number_to_unsigned_integer (Number* self) {
	guint64 result = 0ULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	guint64 z = 0ULL;
	guint64 v = 0ULL;
	guint64 _tmp13_ = 0ULL;
	guint64 _tmp24_ = 0ULL;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0ULL);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->re_sign;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ <= 0) {
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 2526 "number.c"
	} else {
		gint _tmp2_ = 0;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->re_exponent;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ <= 0;
#line 2533 "number.c"
	}
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (guint64) 0;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2541 "number.c"
	}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = (guint64) 0;
#line 2545 "number.c"
	{
		gint i = 0;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 2550 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2557 "number.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				guint64 t = 0ULL;
				guint64 _tmp7_ = 0ULL;
				guint64 _tmp8_ = 0ULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				guint64 _tmp11_ = 0ULL;
				guint64 _tmp12_ = 0ULL;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp3_) {
#line 2569 "number.c"
					gint _tmp4_ = 0;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = i;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp4_ + 1;
#line 2575 "number.c"
				}
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = FALSE;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = i;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = self->re_exponent;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2587 "number.c"
				}
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = z;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = _tmp7_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = z;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = i;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = self->re_fraction[_tmp9_];
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = (_tmp8_ * BASE) + _tmp10_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = z;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = t;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp11_ <= _tmp12_) {
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = (guint64) 0;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 2611 "number.c"
				}
			}
		}
	}
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = z;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	v = _tmp13_;
#line 2620 "number.c"
	{
		gint i = 0;
		gint _tmp14_ = 0;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = self->re_exponent;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp14_ - 1;
#line 2628 "number.c"
		{
			gboolean _tmp15_ = FALSE;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = TRUE;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2635 "number.c"
				gint _tmp17_ = 0;
				guint64 digit = 0ULL;
				guint64 _tmp18_ = 0ULL;
				guint64 _tmp19_ = 0ULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				guint64 _tmp22_ = 0ULL;
				guint64 _tmp23_ = 0ULL;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp15_) {
#line 2646 "number.c"
					gint _tmp16_ = 0;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = i;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp16_ - 1;
#line 2652 "number.c"
				}
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = FALSE;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp17_ >= 0)) {
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2662 "number.c"
				}
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = v;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = v;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				digit = ((guint64) _tmp18_) - ((_tmp19_ / BASE) * BASE);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = i;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = self->re_fraction[_tmp20_];
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = digit;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (((guint64) _tmp21_) != _tmp22_) {
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = (guint64) 0;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 2682 "number.c"
				}
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = v;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				v = _tmp23_ / BASE;
#line 2688 "number.c"
			}
		}
	}
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = v;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp24_ != ((guint64) 0)) {
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (guint64) 0;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2700 "number.c"
	}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2706 "number.c"
}


gfloat number_to_float (Number* self) {
	gfloat result = 0.0F;
	gboolean _tmp0_ = FALSE;
	gfloat z = 0.0F;
	gint _tmp12_ = 0;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = 0.f;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2725 "number.c"
	}
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = 0.f;
#line 2729 "number.c"
	{
		gint i = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 2734 "number.c"
		{
			gboolean _tmp1_ = FALSE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = TRUE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2741 "number.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp1_) {
#line 2747 "number.c"
					gint _tmp2_ = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp2_ = i;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp2_ + 1;
#line 2753 "number.c"
				}
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp1_ = FALSE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = i;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp3_ < T)) {
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2763 "number.c"
				}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp4_ = i;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = self->re_fraction[_tmp4_];
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp5_ != 0) {
#line 2771 "number.c"
					gfloat _tmp6_ = 0.0F;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gfloat _tmp11_ = 0.0F;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp6_ = z;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp7_ = i;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = self->re_fraction[_tmp7_];
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp9_ = self->re_exponent;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = i;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = powf ((gfloat) BASE, (gfloat) ((_tmp9_ - _tmp10_) - 1));
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp6_ + (_tmp8_ * _tmp11_);
#line 2792 "number.c"
				}
			}
		}
	}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = self->re_sign;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp12_ < 0) {
#line 2801 "number.c"
		gfloat _tmp13_ = 0.0F;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = z;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = -_tmp13_;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2809 "number.c"
	} else {
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2815 "number.c"
	}
}


gdouble number_to_double (Number* self) {
	gdouble result = 0.0;
	gboolean _tmp0_ = FALSE;
	gdouble z = 0.0;
	gint _tmp12_ = 0;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = 0.;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2835 "number.c"
	}
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = 0.;
#line 2839 "number.c"
	{
		gint i = 0;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 2844 "number.c"
		{
			gboolean _tmp1_ = FALSE;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = TRUE;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 2851 "number.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp1_) {
#line 2857 "number.c"
					gint _tmp2_ = 0;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp2_ = i;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp2_ + 1;
#line 2863 "number.c"
				}
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp1_ = FALSE;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = i;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp3_ < T)) {
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 2873 "number.c"
				}
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp4_ = i;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = self->re_fraction[_tmp4_];
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp5_ != 0) {
#line 2881 "number.c"
					gdouble _tmp6_ = 0.0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gdouble _tmp11_ = 0.0;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp6_ = z;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp7_ = i;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = self->re_fraction[_tmp7_];
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp9_ = self->re_exponent;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = i;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = pow ((gdouble) BASE, (gdouble) ((_tmp9_ - _tmp10_) - 1));
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp6_ + (_tmp8_ * _tmp11_);
#line 2902 "number.c"
				}
			}
		}
	}
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = self->re_sign;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp12_ < 0) {
#line 2911 "number.c"
		gdouble _tmp13_ = 0.0;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = z;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = -_tmp13_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2919 "number.c"
	} else {
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2925 "number.c"
	}
}


gboolean number_is_zero (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->re_sign;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ == 0) {
#line 2940 "number.c"
		gint _tmp2_ = 0;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->im_sign;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ == 0;
#line 2946 "number.c"
	} else {
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 2950 "number.c"
	}
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2956 "number.c"
}


gboolean number_is_negative (Number* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->re_sign;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ < 0;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2971 "number.c"
}


gboolean number_is_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Number* t3 = NULL;
	Number* _tmp1_ = NULL;
	Number* t1 = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* t2 = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = FALSE;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3002 "number.c"
	}
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer ((gint64) 10000);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t3 = _tmp1_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = t3;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_multiply (self, _tmp2_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp3_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = t1;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = t3;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_divide (_tmp4_, _tmp5_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp6_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = t1;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_floor (_tmp7_);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp8_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = t1;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = t2;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_equals (_tmp9_, _tmp10_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp11_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t3);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3046 "number.c"
}


gboolean number_is_positive_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = FALSE;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3063 "number.c"
	} else {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_ = 0;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->re_sign;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_ >= 0) {
#line 3071 "number.c"
			gboolean _tmp3_ = FALSE;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = number_is_integer (self);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _tmp3_;
#line 3077 "number.c"
		} else {
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = FALSE;
#line 3081 "number.c"
		}
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3087 "number.c"
	}
}


gboolean number_is_natural (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = FALSE;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3105 "number.c"
	} else {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_ = 0;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->re_sign;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_ > 0) {
#line 3113 "number.c"
			gboolean _tmp3_ = FALSE;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = number_is_integer (self);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _tmp3_;
#line 3119 "number.c"
		} else {
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = FALSE;
#line 3123 "number.c"
		}
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3129 "number.c"
	}
}


gboolean number_is_complex (Number* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->im_sign;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ != 0;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3145 "number.c"
}


gboolean number_equals (Number* self, Number* y) {
	gboolean result = FALSE;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, FALSE);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_compare (self, _tmp0_);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_ == 0;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3165 "number.c"
}


gint number_compare (Number* self, Number* y) {
	gint result = 0;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, 0);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->re_sign;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = y;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_->re_sign;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ != _tmp2_) {
#line 3190 "number.c"
		gint _tmp3_ = 0;
		Number* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = self->re_sign;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = y;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_->re_sign;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_ > _tmp5_) {
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = 1;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3206 "number.c"
		} else {
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = -1;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3212 "number.c"
		}
	}
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_is_zero (self);
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_) {
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = 0;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3223 "number.c"
	}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = self->re_exponent;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = y;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_->re_exponent;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_ != _tmp9_) {
#line 3233 "number.c"
		gint _tmp10_ = 0;
		Number* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = self->re_exponent;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = y;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = _tmp11_->re_exponent;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp10_ > _tmp12_) {
#line 3245 "number.c"
			gint _tmp13_ = 0;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = self->re_sign;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp13_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3253 "number.c"
		} else {
			gint _tmp14_ = 0;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = self->re_sign;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = -_tmp14_;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3262 "number.c"
		}
	}
	{
		gint i = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 3269 "number.c"
		{
			gboolean _tmp15_ = FALSE;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = TRUE;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 3276 "number.c"
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				Number* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp15_) {
#line 3290 "number.c"
					gint _tmp16_ = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = i;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp16_ + 1;
#line 3296 "number.c"
				}
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = FALSE;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp17_ < SIZE)) {
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 3306 "number.c"
				}
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = i;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = self->re_fraction[_tmp18_];
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = y;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = i;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = _tmp20_->re_fraction[_tmp21_];
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp19_ == _tmp22_) {
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					continue;
#line 3322 "number.c"
				}
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = i;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = self->re_fraction[_tmp23_];
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = y;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = i;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = _tmp25_->re_fraction[_tmp26_];
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp24_ > _tmp27_) {
#line 3336 "number.c"
					gint _tmp28_ = 0;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = self->re_sign;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp28_;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 3344 "number.c"
				} else {
					gint _tmp29_ = 0;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp29_ = self->re_sign;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = -_tmp29_;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 3353 "number.c"
				}
			}
		}
	}
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = 0;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3362 "number.c"
}


Number* number_sgn (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3375 "number.c"
		Number* _tmp1_ = NULL;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3383 "number.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_is_negative (self);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_) {
#line 3390 "number.c"
			Number* _tmp3_ = NULL;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = number_new_integer ((gint64) (-1));
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp3_;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3398 "number.c"
		} else {
			Number* _tmp4_ = NULL;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_new_integer ((gint64) 1);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp4_;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3407 "number.c"
		}
	}
}


Number* number_invert_sign (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->re_sign;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z->re_sign = -_tmp1_;
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = z->im_sign;
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z->im_sign = -_tmp2_;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3437 "number.c"
}


Number* number_abs (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3450 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* z = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp1_;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp2_;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x_real;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = x_real;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp5_;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = x_im;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = x_im;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp8_;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = x_real;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = x_im;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_add (_tmp9_, _tmp10_);
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp11_;
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = z;
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_root (_tmp12_, (gint64) 2);
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3517 "number.c"
	} else {
		Number* z = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_copy (self);
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp14_;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = z;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp15_->re_sign;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp16_ < 0) {
#line 3533 "number.c"
			Number* _tmp17_ = NULL;
			Number* _tmp18_ = NULL;
			gint _tmp19_ = 0;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp17_ = z;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = z;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp19_ = _tmp18_->re_sign;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp17_->re_sign = -_tmp19_;
#line 3545 "number.c"
		}
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3551 "number.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self ? g_object_ref (self) : NULL;
#line 3559 "number.c"
}


Number* number_arg (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_real = NULL;
	Number* _tmp3_ = NULL;
	Number* x_im = NULL;
	Number* _tmp4_ = NULL;
	Number* pi = NULL;
	Number* _tmp5_ = NULL;
	Number* z = NULL;
	Number* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	Number* _tmp41_ = NULL;
	AngleUnit _tmp42_ = 0;
	Number* _tmp43_ = NULL;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3584 "number.c"
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Argument not defined for zero");
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_integer ((gint64) 0);
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp2_;
#line 653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3597 "number.c"
	}
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_real_component (self);
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_real = _tmp3_;
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_imaginary_component (self);
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_im = _tmp4_;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_new_pi ();
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	pi = _tmp5_;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = x_im;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_is_zero (_tmp6_);
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_) {
#line 3617 "number.c"
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = x_real;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_is_negative (_tmp8_);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp9_) {
#line 3626 "number.c"
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = pi;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _g_object_ref0 (_tmp10_);
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp11_;
#line 3637 "number.c"
		} else {
			Number* _tmp12_ = NULL;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = number_new_integer ((gint64) 0);
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp12_;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (pi);
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_im);
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_real);
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3654 "number.c"
		}
	} else {
		Number* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = x_real;
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_is_zero (_tmp13_);
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp14_) {
#line 3665 "number.c"
			Number* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = x_im;
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp16_ = number_is_negative (_tmp15_);
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp16_) {
#line 3674 "number.c"
				Number* _tmp17_ = NULL;
				Number* _tmp18_ = NULL;
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = pi;
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = number_divide_integer (_tmp17_, (gint64) (-2));
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp18_;
#line 3685 "number.c"
			} else {
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = pi;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = number_divide_integer (_tmp19_, (gint64) 2);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp20_;
#line 3697 "number.c"
			}
		} else {
			Number* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = x_real;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = number_is_negative (_tmp21_);
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp22_) {
#line 3708 "number.c"
				Number* _tmp23_ = NULL;
				Number* _tmp24_ = NULL;
				Number* _tmp25_ = NULL;
				Number* _tmp26_ = NULL;
				Number* _tmp27_ = NULL;
				Number* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = x_im;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = x_real;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = number_divide (_tmp23_, _tmp24_);
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp25_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = z;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = number_atan (_tmp26_, ANGLE_UNIT_RADIANS);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp27_;
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = x_im;
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_ = number_is_negative (_tmp28_);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp29_) {
#line 3740 "number.c"
					Number* _tmp30_ = NULL;
					Number* _tmp31_ = NULL;
					Number* _tmp32_ = NULL;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp30_ = z;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp31_ = pi;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp32_ = number_subtract (_tmp30_, _tmp31_);
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp32_;
#line 3754 "number.c"
				} else {
					Number* _tmp33_ = NULL;
					Number* _tmp34_ = NULL;
					Number* _tmp35_ = NULL;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp33_ = z;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp34_ = pi;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp35_ = number_add (_tmp33_, _tmp34_);
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp35_;
#line 3769 "number.c"
				}
			} else {
				Number* _tmp36_ = NULL;
				Number* _tmp37_ = NULL;
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp36_ = x_im;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = x_real;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp38_ = number_divide (_tmp36_, _tmp37_);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp38_;
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = z;
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = number_atan (_tmp39_, ANGLE_UNIT_RADIANS);
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp40_;
#line 3795 "number.c"
			}
		}
	}
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = z;
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp42_ = unit;
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = number_from_radians (_tmp41_, _tmp42_);
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp43_;
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (pi);
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_im);
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_real);
#line 690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3817 "number.c"
}


Number* number_conjugate (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->im_sign;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z->im_sign = -_tmp1_;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3840 "number.c"
}


Number* number_real_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_->im_sign = 0;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = z;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_->im_exponent = 0;
#line 3864 "number.c"
	{
		gint i = 0;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 3869 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 3876 "number.c"
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp3_) {
#line 3884 "number.c"
					gint _tmp4_ = 0;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = i;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp4_ + 1;
#line 3890 "number.c"
				}
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = FALSE;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = i;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = z;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp5_ < 1000)) {
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 3902 "number.c"
				}
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = z;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = i;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_->im_fraction[_tmp8_] = 0;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = _tmp7_->im_fraction[_tmp8_];
#line 3912 "number.c"
			}
		}
	}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3920 "number.c"
}


Number* number_imaginary_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new ();
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->im_sign;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_->re_sign = _tmp2_;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = z;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = self->im_exponent;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_->re_exponent = _tmp4_;
#line 3952 "number.c"
	{
		gint i = 0;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 3957 "number.c"
		{
			gboolean _tmp5_ = FALSE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = TRUE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 3964 "number.c"
				gint _tmp7_ = 0;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp5_) {
#line 3974 "number.c"
					gint _tmp6_ = 0;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp6_ = i;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp6_ + 1;
#line 3980 "number.c"
				}
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = FALSE;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = i;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = z;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp7_ < 1000)) {
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 3992 "number.c"
				}
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = z;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = i;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = i;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = self->im_fraction[_tmp11_];
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_->re_fraction[_tmp10_] = _tmp12_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = _tmp9_->re_fraction[_tmp10_];
#line 4006 "number.c"
			}
		}
	}
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = z;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_->im_sign = 0;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = z;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_->im_exponent = 0;
#line 4018 "number.c"
	{
		gint i = 0;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 4023 "number.c"
		{
			gboolean _tmp16_ = FALSE;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp16_ = TRUE;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4030 "number.c"
				gint _tmp18_ = 0;
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp16_) {
#line 4038 "number.c"
					gint _tmp17_ = 0;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp17_ = i;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp17_ + 1;
#line 4044 "number.c"
				}
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = FALSE;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = i;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = z;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp18_ < 1000)) {
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4056 "number.c"
				}
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = z;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = i;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_->im_fraction[_tmp21_] = 0;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = _tmp20_->im_fraction[_tmp21_];
#line 4066 "number.c"
			}
		}
	}
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4074 "number.c"
}


Number* number_integer_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
#line 735 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 4090 "number.c"
	{
		gint i = 0;
		Number* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = z;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_->re_exponent;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp2_;
#line 4101 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4108 "number.c"
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp3_) {
#line 4115 "number.c"
					gint _tmp4_ = 0;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = i;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp4_ + 1;
#line 4121 "number.c"
				}
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = FALSE;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = i;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp5_ < SIZE)) {
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4131 "number.c"
				}
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = z;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = i;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_->re_fraction[_tmp7_] = 0;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp8_ = _tmp6_->re_fraction[_tmp7_];
#line 4141 "number.c"
			}
		}
	}
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = z;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_->im_sign = 0;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = z;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_->im_exponent = 0;
#line 4153 "number.c"
	{
		gint i = 0;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 4158 "number.c"
		{
			gboolean _tmp11_ = FALSE;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = TRUE;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4165 "number.c"
				gint _tmp13_ = 0;
				Number* _tmp14_ = NULL;
				Number* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp11_) {
#line 4173 "number.c"
					gint _tmp12_ = 0;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp12_ = i;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp12_ + 1;
#line 4179 "number.c"
				}
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = FALSE;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = i;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = z;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp13_ < 1000)) {
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4191 "number.c"
				}
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = z;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = i;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_->im_fraction[_tmp16_] = 0;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = _tmp15_->im_fraction[_tmp16_];
#line 4201 "number.c"
			}
		}
	}
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4209 "number.c"
}


Number* number_fractional_component (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	gint shift = 0;
	gint _tmp4_ = 0;
	Number* z = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	Number* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	Number* _tmp33_ = NULL;
	gint _tmp34_ = 0;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4234 "number.c"
		Number* _tmp1_ = NULL;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4242 "number.c"
	}
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->re_exponent;
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ <= 0) {
#line 4248 "number.c"
		Number* _tmp3_ = NULL;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _g_object_ref0 (self);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4256 "number.c"
	}
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = self->re_exponent;
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	shift = _tmp4_;
#line 4262 "number.c"
	{
		gint i = 0;
		gint _tmp5_ = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = shift;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp5_;
#line 4270 "number.c"
		{
			gboolean _tmp6_ = FALSE;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = TRUE;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4277 "number.c"
				gboolean _tmp8_ = FALSE;
				gint _tmp9_ = 0;
				gint _tmp12_ = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp6_) {
#line 4283 "number.c"
					gint _tmp7_ = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp7_ = i;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp7_ + 1;
#line 4289 "number.c"
				}
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = FALSE;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = i;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp9_ < SIZE) {
#line 4297 "number.c"
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = i;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = self->re_fraction[_tmp10_];
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = _tmp11_ == 0;
#line 4306 "number.c"
				} else {
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = FALSE;
#line 4310 "number.c"
				}
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp8_) {
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4316 "number.c"
				}
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = shift;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				shift = _tmp12_ + 1;
#line 4322 "number.c"
			}
		}
	}
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_new_integer ((gint64) 0);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp13_;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = z;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = self->re_sign;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_->re_sign = _tmp15_;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = z;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = self->re_exponent;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = shift;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_->re_exponent = _tmp17_ - _tmp18_;
#line 4344 "number.c"
	{
		gint i = 0;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 4349 "number.c"
		{
			gboolean _tmp19_ = FALSE;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp19_ = TRUE;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4356 "number.c"
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp19_) {
#line 4362 "number.c"
					gint _tmp20_ = 0;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = i;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp20_ + 1;
#line 4368 "number.c"
				}
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = FALSE;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = i;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp21_ < SIZE)) {
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4378 "number.c"
				}
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = i;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = shift;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if ((_tmp22_ + _tmp23_) >= SIZE) {
#line 4386 "number.c"
					Number* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = z;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = i;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_->re_fraction[_tmp25_] = 0;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp26_ = _tmp24_->re_fraction[_tmp25_];
#line 4398 "number.c"
				} else {
					Number* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = z;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = i;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp29_ = i;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp30_ = shift;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp31_ = self->re_fraction[_tmp29_ + _tmp30_];
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_->re_fraction[_tmp28_] = _tmp31_;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp32_ = _tmp27_->re_fraction[_tmp28_];
#line 4420 "number.c"
				}
			}
		}
	}
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = z;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = _tmp33_->re_fraction[0];
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp34_ == 0) {
#line 4431 "number.c"
		Number* _tmp35_ = NULL;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = z;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_->re_sign = 0;
#line 4437 "number.c"
	}
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4443 "number.c"
}


Number* number_fractional_part (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_floor (self);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_subtract (self, _tmp1_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp3_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4469 "number.c"
}


Number* number_floor (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	Number* z = NULL;
	Number* _tmp6_ = NULL;
	gboolean have_fraction = FALSE;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4490 "number.c"
		Number* _tmp1_ = NULL;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4498 "number.c"
	}
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->re_exponent;
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ <= 0) {
#line 4504 "number.c"
		gboolean _tmp3_ = FALSE;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_negative (self);
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_) {
#line 4510 "number.c"
			Number* _tmp4_ = NULL;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_new_integer ((gint64) (-1));
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp4_;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 4518 "number.c"
		} else {
			Number* _tmp5_ = NULL;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = number_new_integer ((gint64) 0);
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp5_;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 4527 "number.c"
		}
	}
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_copy (self);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp6_;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	have_fraction = FALSE;
#line 4536 "number.c"
	{
		gint i = 0;
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = z;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _tmp7_->re_exponent;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp8_;
#line 4547 "number.c"
		{
			gboolean _tmp9_ = FALSE;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = TRUE;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4554 "number.c"
				gint _tmp11_ = 0;
				Number* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				Number* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp9_) {
#line 4564 "number.c"
					gint _tmp10_ = 0;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = i;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp10_ + 1;
#line 4570 "number.c"
				}
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = FALSE;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = i;
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp11_ < SIZE)) {
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4580 "number.c"
				}
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = z;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = i;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = _tmp12_->re_fraction[_tmp13_];
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp14_ != 0) {
#line 808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					have_fraction = TRUE;
#line 4592 "number.c"
				}
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = z;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = i;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_->re_fraction[_tmp16_] = 0;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = _tmp15_->re_fraction[_tmp16_];
#line 4602 "number.c"
			}
		}
	}
#line 811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = z;
#line 811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_->im_sign = 0;
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = z;
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_->im_exponent = 0;
#line 4614 "number.c"
	{
		gint i = 0;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 4619 "number.c"
		{
			gboolean _tmp20_ = FALSE;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = TRUE;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 4626 "number.c"
				gint _tmp22_ = 0;
				Number* _tmp23_ = NULL;
				Number* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp20_) {
#line 4634 "number.c"
					gint _tmp21_ = 0;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = i;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp21_ + 1;
#line 4640 "number.c"
				}
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = FALSE;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = i;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = z;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp22_ < 1000)) {
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 4652 "number.c"
				}
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = z;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = i;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_->im_fraction[_tmp25_] = 0;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = _tmp24_->im_fraction[_tmp25_];
#line 4662 "number.c"
			}
		}
	}
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = have_fraction;
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp28_) {
#line 4670 "number.c"
		gboolean _tmp29_ = FALSE;
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_is_negative (self);
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = _tmp29_;
#line 4676 "number.c"
	} else {
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = FALSE;
#line 4680 "number.c"
	}
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp27_) {
#line 4684 "number.c"
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = z;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = number_new_integer ((gint64) (-1));
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = _tmp31_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = number_add (_tmp30_, _tmp32_);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp33_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp32_);
#line 4703 "number.c"
	}
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 819 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4709 "number.c"
}


Number* number_ceiling (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* f = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_floor (self);
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_fractional_component (self);
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	f = _tmp1_;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = f;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_is_zero (_tmp2_);
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_) {
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (f);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4748 "number.c"
	}
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = z;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_new_integer ((gint64) 1);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_add (_tmp4_, _tmp6_);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp6_);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp8_;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (f);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4770 "number.c"
}


Number* number_round (Number* self) {
	Number* result = NULL;
	gboolean do_floor = FALSE;
	gboolean _tmp0_ = FALSE;
	Number* f = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_negative (self);
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	do_floor = !_tmp0_;
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_fractional_component (self);
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	f = _tmp1_;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = f;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_multiply_integer (_tmp2_, (gint64) 2);
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (f);
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	f = _tmp3_;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = f;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_abs (_tmp4_);
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (f);
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	f = _tmp5_;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = f;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_new_integer ((gint64) 1);
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_compare (_tmp6_, _tmp8_);
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_ >= 0;
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_) {
#line 4830 "number.c"
		gboolean _tmp11_ = FALSE;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = do_floor;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		do_floor = !_tmp11_;
#line 4836 "number.c"
	}
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = do_floor;
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp12_) {
#line 4842 "number.c"
		Number* _tmp13_ = NULL;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_floor (self);
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (f);
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4852 "number.c"
	} else {
		Number* _tmp14_ = NULL;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_ceiling (self);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp14_;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (f);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4863 "number.c"
	}
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (f);
#line 4867 "number.c"
}


Number* number_reciprocal (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4880 "number.c"
		Number* real_x = NULL;
		Number* _tmp1_ = NULL;
		Number* im_x = NULL;
		Number* _tmp2_ = NULL;
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* t2 = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* z = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_x = _tmp1_;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_x = _tmp2_;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = real_x;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = real_x;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp5_;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = im_x;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = im_x;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp8_;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t1;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = t2;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_add (_tmp9_, _tmp10_);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp11_;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = t1;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_reciprocal_real (_tmp12_);
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp13_;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_conjugate (self);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _tmp14_;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = number_multiply (_tmp15_, _tmp16_);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = _tmp17_;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp15_);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp18_;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_x);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_x);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4970 "number.c"
	} else {
		Number* _tmp19_ = NULL;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_reciprocal_real (self);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp19_;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4979 "number.c"
	}
}


Number* number_epowy (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4994 "number.c"
		Number* _tmp1_ = NULL;
#line 873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5002 "number.c"
	}
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_complex (self);
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 5008 "number.c"
		Number* x_real = NULL;
		Number* _tmp3_ = NULL;
		Number* theta = NULL;
		Number* _tmp4_ = NULL;
		Number* r = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_real_component (self);
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp3_;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_imaginary_component (self);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		theta = _tmp4_;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = x_real;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_epowy_real (_tmp5_);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		r = _tmp6_;
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = r;
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = theta;
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_polar (_tmp7_, _tmp8_, ANGLE_UNIT_RADIANS);
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp9_;
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (r);
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (theta);
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5049 "number.c"
	} else {
		Number* _tmp10_ = NULL;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_epowy_real (self);
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp10_;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5058 "number.c"
	}
}


Number* number_xpowy (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_integer (_tmp0_);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 5077 "number.c"
		Number* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Number* _tmp4_ = NULL;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_to_integer (_tmp2_);
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_xpowy_integer (self, _tmp3_);
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5091 "number.c"
	} else {
		Number* reciprocal = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = y;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_reciprocal (_tmp5_);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		reciprocal = _tmp6_;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = reciprocal;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_is_integer (_tmp7_);
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp8_) {
#line 5110 "number.c"
			Number* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			Number* _tmp11_ = NULL;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = reciprocal;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = number_to_integer (_tmp9_);
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = number_root (self, _tmp10_);
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp11_;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (reciprocal);
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 5126 "number.c"
		} else {
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = y;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = number_pwr (self, _tmp12_);
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp13_;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (reciprocal);
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 5140 "number.c"
		}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (reciprocal);
#line 5144 "number.c"
	}
}


Number* number_xpowy_integer (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp10_ = 0LL;
	gboolean _tmp12_ = FALSE;
	gint64 _tmp14_ = 0LL;
	Number* t = NULL;
	gint64 _tmp16_ = 0LL;
	Number* z = NULL;
	Number* _tmp20_ = NULL;
#line 903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (self);
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 5168 "number.c"
		gint64 _tmp2_ = 0LL;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = n;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ < ((gint64) 0);
#line 5174 "number.c"
	} else {
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 5178 "number.c"
	}
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5182 "number.c"
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("The power of zero is undefined for a negative exponent");
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp3_);
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5195 "number.c"
	}
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_is_zero (self);
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_) {
#line 5201 "number.c"
		gint64 _tmp7_ = 0LL;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = n;
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp7_ == ((gint64) 0);
#line 5207 "number.c"
	} else {
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = FALSE;
#line 5211 "number.c"
	}
#line 914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_) {
#line 5215 "number.c"
		const gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _ ("Zero raised to zero is undefined");
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp8_);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_integer ((gint64) 0);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp9_;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5228 "number.c"
	}
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = n;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_ == ((gint64) 0)) {
#line 5234 "number.c"
		Number* _tmp11_ = NULL;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_new_integer ((gint64) 1);
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp11_;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5242 "number.c"
	}
#line 926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_is_zero (self);
#line 926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp12_) {
#line 5248 "number.c"
		Number* _tmp13_ = NULL;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_new_integer ((gint64) 0);
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5256 "number.c"
	}
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = n;
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_ == ((gint64) 1)) {
#line 5262 "number.c"
		Number* _tmp15_ = NULL;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _g_object_ref0 (self);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp15_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5270 "number.c"
	}
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = n;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp16_ < ((gint64) 0)) {
#line 5276 "number.c"
		Number* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = number_reciprocal (self);
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp17_;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = n;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		n = -_tmp18_;
#line 5289 "number.c"
	} else {
		Number* _tmp19_ = NULL;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = _g_object_ref0 (self);
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp19_;
#line 5298 "number.c"
	}
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = number_new_integer ((gint64) 1);
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp20_;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 5306 "number.c"
		gint64 _tmp21_ = 0LL;
		gint64 _tmp22_ = 0LL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = n;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp21_ != ((gint64) 0))) {
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 5319 "number.c"
		}
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = n;
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if ((_tmp22_ % 2) == ((gint64) 1)) {
#line 5325 "number.c"
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			Number* _tmp25_ = NULL;
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = z;
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = t;
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = number_multiply (_tmp23_, _tmp24_);
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 946 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp25_;
#line 5339 "number.c"
		}
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = t;
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = t;
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = number_multiply (_tmp26_, _tmp27_);
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp28_;
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = n;
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		n = _tmp29_ / 2;
#line 5355 "number.c"
	}
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5363 "number.c"
}


Number* number_root (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_complex (self);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp2_) {
#line 5378 "number.c"
		gboolean _tmp3_ = FALSE;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_negative (self);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _tmp3_;
#line 5384 "number.c"
	} else {
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = FALSE;
#line 5388 "number.c"
	}
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 5392 "number.c"
		gint64 _tmp4_ = 0LL;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = n;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = (_tmp4_ % 2) == ((gint64) 1);
#line 5398 "number.c"
	} else {
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 5402 "number.c"
	}
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5406 "number.c"
		Number* z = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_abs (self);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp5_;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = z;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = n;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_root_real (_tmp6_, _tmp7_);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp8_;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = z;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_invert_sign (_tmp9_);
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp10_;
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5440 "number.c"
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_is_complex (self);
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp12_) {
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = TRUE;
#line 5450 "number.c"
		} else {
			gboolean _tmp13_ = FALSE;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = number_is_negative (self);
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp13_;
#line 5457 "number.c"
		}
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp11_) {
#line 5461 "number.c"
			Number* r = NULL;
			Number* _tmp14_ = NULL;
			Number* theta = NULL;
			Number* _tmp15_ = NULL;
			Number* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = number_abs (self);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			r = _tmp14_;
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = number_arg (self, ANGLE_UNIT_RADIANS);
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			theta = _tmp15_;
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp16_ = r;
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp17_ = n;
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = number_root_real (_tmp16_, _tmp17_);
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (r);
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			r = _tmp18_;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp19_ = theta;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = n;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = number_divide_integer (_tmp19_, _tmp20_);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (theta);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			theta = _tmp21_;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = r;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = theta;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = number_new_polar (_tmp22_, _tmp23_, ANGLE_UNIT_RADIANS);
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp24_;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (theta);
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (r);
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 5517 "number.c"
		} else {
			gint64 _tmp25_ = 0LL;
			Number* _tmp26_ = NULL;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = n;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = number_root_real (self, _tmp25_);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp26_;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 5529 "number.c"
		}
	}
}


Number* number_sqrt (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5544 "number.c"
		Number* _tmp1_ = NULL;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5552 "number.c"
	} else {
		Number* t = NULL;
		Number* _tmp2_ = NULL;
		Number* z = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		Number* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		Number* _tmp10_ = NULL;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_root (self, (gint64) (-2));
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp2_;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = t;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_multiply (self, _tmp3_);
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp4_;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = z;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = t;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = _tmp6_->re_fraction[0];
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = z;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = _tmp8_->re_fraction[0];
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_ext (_tmp5_, _tmp7_, _tmp9_);
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp10_;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5595 "number.c"
	}
}


Number* number_ln (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5611 "number.c"
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Logarithm of zero is undefined");
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 1004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_integer ((gint64) 0);
#line 1004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp2_;
#line 1004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5624 "number.c"
	}
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_is_complex (self);
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = TRUE;
#line 5632 "number.c"
	} else {
		gboolean _tmp5_ = FALSE;
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_is_negative (self);
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _tmp5_;
#line 5639 "number.c"
	}
#line 1016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_) {
#line 5643 "number.c"
		Number* r = NULL;
		Number* _tmp6_ = NULL;
		Number* theta = NULL;
		Number* _tmp7_ = NULL;
		Number* z_real = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_abs (self);
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		r = _tmp6_;
#line 1020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_arg (self, ANGLE_UNIT_RADIANS);
#line 1020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		theta = _tmp7_;
#line 1021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = r;
#line 1021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_ln_real (_tmp8_);
#line 1021 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp9_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = z_real;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = theta;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_new_complex (_tmp10_, _tmp11_);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp12_;
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (theta);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (r);
#line 1023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5684 "number.c"
	} else {
		Number* _tmp13_ = NULL;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_ln_real (self);
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5693 "number.c"
	}
}


Number* number_logarithm (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	gint64 _tmp3_ = 0LL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5717 "number.c"
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Logarithm of zero is undefined");
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_integer ((gint64) 0);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp2_;
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5730 "number.c"
	}
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = n;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_integer (_tmp3_);
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp4_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_ln (self);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = t1;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_ln (_tmp7_);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_divide (_tmp6_, _tmp9_);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp9_);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp6_);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp11_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5762 "number.c"
}


Number* number_factorial (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint64 value = 0LL;
	gint64 _tmp13_ = 0LL;
	Number* z = NULL;
	Number* _tmp14_ = NULL;
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5780 "number.c"
		Number* _tmp1_ = NULL;
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1050 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5788 "number.c"
	}
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_natural (self);
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp2_) {
#line 5794 "number.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gdouble val = 0.0;
		gdouble _tmp8_ = 0.0;
		gdouble fact = 0.0;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		Number* _tmp12_ = NULL;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_is_negative (self);
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp4_) {
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 5810 "number.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = number_is_complex (self);
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _tmp5_;
#line 5817 "number.c"
		}
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_) {
#line 5821 "number.c"
			const gchar* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = _ ("Factorial is only defined for non-negative real numbers");
#line 1058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr (_tmp6_);
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = number_new_integer ((gint64) 0);
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp7_;
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 5834 "number.c"
		}
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_to_double (self);
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		val = _tmp8_;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = val;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = tgamma (_tmp9_ + 1);
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		fact = _tmp10_;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = fact;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_new_double (_tmp11_);
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp12_;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5854 "number.c"
	}
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_to_integer (self);
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	value = _tmp13_;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = _g_object_ref0 (self);
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp14_;
#line 5864 "number.c"
	{
		gint i = 0;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 2;
#line 5869 "number.c"
		{
			gboolean _tmp15_ = FALSE;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = TRUE;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 5876 "number.c"
				gint _tmp17_ = 0;
				gint64 _tmp18_ = 0LL;
				Number* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				Number* _tmp21_ = NULL;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp15_) {
#line 5884 "number.c"
					gint _tmp16_ = 0;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = i;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp16_ + 1;
#line 5890 "number.c"
				}
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = FALSE;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = value;
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(((gint64) _tmp17_) < _tmp18_)) {
#line 1073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 5902 "number.c"
				}
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = z;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = i;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = number_multiply_integer (_tmp19_, (gint64) _tmp20_);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp21_;
#line 5914 "number.c"
			}
		}
	}
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5922 "number.c"
}


Number* number_add (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_add_with_sign (self, 1, _tmp0_);
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 1082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5942 "number.c"
}


Number* number_subtract (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 1088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_add_with_sign (self, -1, _tmp0_);
#line 1088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 1088 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5962 "number.c"
}


Number* number_multiply (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (self);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 5982 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_zero (_tmp2_);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_;
#line 5992 "number.c"
	}
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5996 "number.c"
		Number* _tmp4_ = NULL;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6004 "number.c"
	}
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_is_complex (self);
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_) {
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = TRUE;
#line 6012 "number.c"
	} else {
		Number* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = y;
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_is_complex (_tmp7_);
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp8_;
#line 6022 "number.c"
	}
#line 1099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_) {
#line 6026 "number.c"
		Number* t1 = NULL;
		Number* t2 = NULL;
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp9_ = NULL;
		Number* im_x = NULL;
		Number* _tmp10_ = NULL;
		Number* real_y = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* im_y = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_real_component (self);
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_x = _tmp9_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_imaginary_component (self);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_x = _tmp10_;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = y;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_real_component (_tmp11_);
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_y = _tmp12_;
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = y;
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_imaginary_component (_tmp13_);
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_y = _tmp14_;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = real_x;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = real_y;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = number_multiply_real (_tmp15_, _tmp16_);
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp17_;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = im_x;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = im_y;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_multiply_real (_tmp18_, _tmp19_);
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp20_;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = t1;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = t2;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_subtract (_tmp21_, _tmp22_);
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_z = _tmp23_;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = real_x;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = im_y;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_multiply_real (_tmp24_, _tmp25_);
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp26_;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = im_x;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = real_y;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_multiply_real (_tmp27_, _tmp28_);
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp29_;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = t1;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = t2;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = number_add (_tmp30_, _tmp31_);
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_z = _tmp32_;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = real_z;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = im_z;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = number_new_complex (_tmp33_, _tmp34_);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp35_;
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_y);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_y);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_x);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_x);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6168 "number.c"
	} else {
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
#line 1119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = y;
#line 1119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = number_multiply_real (self, _tmp36_);
#line 1119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp37_;
#line 1119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6180 "number.c"
	}
}


Number* number_multiply_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 6194 "number.c"
		Number* re_z = NULL;
		Number* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* im_z = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = y;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_multiply_integer_real (_tmp2_, _tmp3_);
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp2_);
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		re_z = _tmp5_;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_imaginary_component (self);
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = _tmp6_;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_multiply_integer_real (_tmp7_, _tmp8_);
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _tmp9_;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp7_);
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_z = _tmp10_;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = re_z;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = im_z;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_new_complex (_tmp11_, _tmp12_);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (re_z);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6252 "number.c"
	} else {
		gint64 _tmp14_ = 0LL;
		Number* _tmp15_ = NULL;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = y;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_multiply_integer_real (self, _tmp14_);
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp15_;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6264 "number.c"
	}
}


Number* number_divide (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Number* t = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gint ie = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	gint i = 0;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	Number* z = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	Number* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (_tmp0_);
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 6306 "number.c"
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _ ("Division by zero is undefined");
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp2_);
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_new_integer ((gint64) 0);
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6319 "number.c"
	}
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_is_zero (self);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 6325 "number.c"
		Number* _tmp5_ = NULL;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _g_object_ref0 (self);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp5_;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6333 "number.c"
	}
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = y;
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_reciprocal (_tmp6_);
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp7_;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = t;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_->re_exponent;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	ie = _tmp9_;
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = t;
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_->re_exponent = 0;
#line 1155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = t;
#line 1155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_->re_fraction[0];
#line 1155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	i = _tmp12_;
#line 1156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = t;
#line 1156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = number_multiply (self, _tmp13_);
#line 1156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp14_;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = z;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = i;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = z;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = _tmp17_->re_fraction[0];
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = number_ext (_tmp15_, _tmp16_, _tmp18_);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp19_;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = z;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = z;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = _tmp21_->re_exponent;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = ie;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_->re_exponent = _tmp22_ + _tmp23_;
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6393 "number.c"
}


Number* number_divide_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 6406 "number.c"
		Number* re_z = NULL;
		Number* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* im_z = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = y;
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_divide_integer_real (_tmp2_, _tmp3_);
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp2_);
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		re_z = _tmp5_;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_imaginary_component (self);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = _tmp6_;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_divide_integer_real (_tmp7_, _tmp8_);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _tmp9_;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp7_);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_z = _tmp10_;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = re_z;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = im_z;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_new_complex (_tmp11_, _tmp12_);
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (re_z);
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6464 "number.c"
	} else {
		gint64 _tmp14_ = 0LL;
		Number* _tmp15_ = NULL;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = y;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_divide_integer_real (self, _tmp14_);
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp15_;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6476 "number.c"
	}
}


Number* number_modulus_divide (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* t2 = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* z = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	gint _tmp21_ = 0;
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_integer (self);
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 6514 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_integer (_tmp2_);
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 6524 "number.c"
	}
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 6528 "number.c"
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _ ("Modulus division is only defined for integers");
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp4_);
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) 0);
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp5_;
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6541 "number.c"
	}
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = y;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_divide (self, _tmp6_);
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_floor (_tmp8_);
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp10_;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = t1;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = y;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_multiply (_tmp11_, _tmp12_);
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp13_;
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = t2;
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_subtract (self, _tmp14_);
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp15_;
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = number_new_integer ((gint64) 0);
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp16_;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = y;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = t1;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = number_compare (_tmp19_, _tmp20_);
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp21_ < 0) {
#line 6585 "number.c"
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		gint _tmp24_ = 0;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = z;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = t1;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_compare (_tmp22_, _tmp23_);
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = _tmp24_ > 0;
#line 6597 "number.c"
	} else {
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = FALSE;
#line 6601 "number.c"
	}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp18_) {
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = TRUE;
#line 6607 "number.c"
	} else {
		gboolean _tmp25_ = FALSE;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		gint _tmp28_ = 0;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = y;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = t1;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = number_compare (_tmp26_, _tmp27_);
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp28_ > 0) {
#line 6621 "number.c"
			Number* _tmp29_ = NULL;
			Number* _tmp30_ = NULL;
			gint _tmp31_ = 0;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = z;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp30_ = t1;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = number_compare (_tmp29_, _tmp30_);
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = _tmp31_ < 0;
#line 6633 "number.c"
		} else {
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = FALSE;
#line 6637 "number.c"
		}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _tmp25_;
#line 6641 "number.c"
	}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp17_) {
#line 6645 "number.c"
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = z;
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = y;
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = number_add (_tmp32_, _tmp33_);
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp34_;
#line 6659 "number.c"
	}
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6669 "number.c"
}


Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod) {
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* exp_value = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* ans = NULL;
	Number* _tmp7_ = NULL;
	Number* two = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	Number* _tmp36_ = NULL;
#line 1198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (exp != NULL, NULL);
#line 1198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (mod != NULL, NULL);
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	base_value = _tmp0_;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = exp;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_negative (_tmp1_);
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 6705 "number.c"
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = base_value;
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_reciprocal (_tmp3_);
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (base_value);
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_value = _tmp4_;
#line 6716 "number.c"
	}
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = exp;
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_abs (_tmp5_);
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	exp_value = _tmp6_;
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_new_integer ((gint64) 1);
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	ans = _tmp7_;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_new_integer ((gint64) 2);
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	two = _tmp8_;
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 6734 "number.c"
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean is_even = FALSE;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = exp_value;
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_is_zero (_tmp9_);
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(!_tmp10_)) {
#line 1206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 6763 "number.c"
		}
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = exp_value;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = two;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_modulus_divide (_tmp11_, _tmp12_);
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = _tmp13_;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_is_zero (_tmp14_);
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp15_;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp14_);
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		is_even = _tmp16_;
#line 1209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = is_even;
#line 1209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp17_) {
#line 6785 "number.c"
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			Number* _tmp20_ = NULL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = ans;
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp19_ = base_value;
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = number_multiply (_tmp18_, _tmp19_);
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (ans);
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ans = _tmp20_;
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = ans;
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = mod;
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = number_modulus_divide (_tmp21_, _tmp22_);
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (ans);
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ans = _tmp23_;
#line 6812 "number.c"
		}
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = base_value;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = base_value;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (base_value);
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_value = _tmp26_;
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = base_value;
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = mod;
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_modulus_divide (_tmp27_, _tmp28_);
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (base_value);
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_value = _tmp29_;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = exp_value;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = _tmp31_;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = number_floor (_tmp32_);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (exp_value);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		exp_value = _tmp33_;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp32_);
#line 6848 "number.c"
	}
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = ans;
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = mod;
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = number_modulus_divide (_tmp34_, _tmp35_);
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp36_;
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (two);
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (ans);
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (exp_value);
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (base_value);
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6868 "number.c"
}


Number* number_sin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 6881 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
#line 1226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 1226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp1_;
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp2_;
#line 1229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x_real;
#line 1229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = unit;
#line 1229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_sin_real (_tmp3_, _tmp4_);
#line 1229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp5_;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = x_im;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_cosh (_tmp6_);
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp7_;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = z_real;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t;
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp10_;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = x_real;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = unit;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_cos_real (_tmp11_, _tmp12_);
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp13_;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = x_im;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_sinh (_tmp14_);
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp15_;
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z_im;
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = t;
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp18_;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = z_real;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = z_im;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_new_complex (_tmp19_, _tmp20_);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp21_;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6986 "number.c"
	} else {
		AngleUnit _tmp22_ = 0;
		Number* _tmp23_ = NULL;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = unit;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_sin_real (self, _tmp22_);
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp23_;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6998 "number.c"
	}
}


Number* number_cos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 7012 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp1_;
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp2_;
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x_real;
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = unit;
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_cos_real (_tmp3_, _tmp4_);
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp5_;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = x_im;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_cosh (_tmp6_);
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp7_;
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = z_real;
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t;
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp10_;
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = x_real;
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = unit;
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_sin_real (_tmp11_, _tmp12_);
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp13_;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = x_im;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_sinh (_tmp14_);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp15_;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z_im;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = t;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp18_;
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = z_im;
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_invert_sign (_tmp19_);
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp20_;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = z_real;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = z_im;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_new_complex (_tmp21_, _tmp22_);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp23_;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7127 "number.c"
	} else {
		AngleUnit _tmp24_ = 0;
		Number* _tmp25_ = NULL;
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = unit;
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = number_cos_real (self, _tmp24_);
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp25_;
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7139 "number.c"
	}
}


Number* number_tan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* cos_x = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	AngleUnit _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 1270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_cos (self, _tmp0_);
#line 1270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	cos_x = _tmp1_;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = cos_x;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_is_zero (_tmp2_);
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_) {
#line 7171 "number.c"
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 1274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)");
#line 1274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp4_);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) 0);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp5_;
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (cos_x);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7186 "number.c"
	}
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = unit;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_sin (self, _tmp6_);
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = cos_x;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_divide (_tmp8_, _tmp9_);
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp11_;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (cos_x);
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7208 "number.c"
}


Number* number_asin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	Number* t2 = NULL;
	gint _tmp20_ = 0;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp33_ = NULL;
	Number* _tmp34_ = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 7229 "number.c"
		Number* _tmp1_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7237 "number.c"
	}
#line 1290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->re_exponent;
#line 1290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ <= 0) {
#line 7243 "number.c"
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* t2 = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* z = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		AngleUnit _tmp18_ = 0;
		Number* _tmp19_ = NULL;
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_new_integer ((gint64) 1);
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp3_;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = t1;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp5_;
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = t1;
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_subtract (_tmp6_, self);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp7_;
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = t2;
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_add (_tmp8_, self);
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp9_;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = t1;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = t2;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_multiply (_tmp10_, _tmp11_);
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp12_;
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = t2;
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_root (_tmp13_, (gint64) (-2));
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp14_;
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = t2;
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_multiply (self, _tmp15_);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp16_;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = z;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = unit;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_atan (_tmp17_, _tmp18_);
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp19_;
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7332 "number.c"
	}
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = self->re_sign;
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = number_new_integer ((gint64) _tmp20_);
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp21_;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = t2;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = number_equals (self, _tmp22_);
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp23_) {
#line 7346 "number.c"
		Number* z = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		AngleUnit _tmp31_ = 0;
		Number* _tmp32_ = NULL;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_new_pi ();
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = _tmp24_;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = t2;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = _tmp26_->re_sign;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = number_divide_integer (_tmp25_, (gint64) (2 * _tmp27_));
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = _tmp28_;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp25_);
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp29_;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = z;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = unit;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = number_from_radians (_tmp30_, _tmp31_);
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp32_;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7387 "number.c"
	}
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = _ ("Inverse sine is undefined for values outside [-1, 1]");
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mperr (_tmp33_);
#line 1313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_new_integer ((gint64) 0);
#line 1313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp34_;
#line 1313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7401 "number.c"
}


Number* number_acos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* pi = NULL;
	Number* _tmp0_ = NULL;
	Number* t1 = NULL;
	Number* _tmp1_ = NULL;
	Number* n1 = NULL;
	Number* _tmp2_ = NULL;
	Number* z = NULL;
	gboolean _tmp3_ = FALSE;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp36_ = NULL;
	AngleUnit _tmp37_ = 0;
	Number* _tmp38_ = NULL;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_pi ();
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	pi = _tmp0_;
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp1_;
#line 1321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_new_integer ((gint64) (-1));
#line 1321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	n1 = _tmp2_;
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = t1;
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_compare (self, _tmp4_);
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_ > 0) {
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = TRUE;
#line 7442 "number.c"
	} else {
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = n1;
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _tmp7_ < 0;
#line 7452 "number.c"
	}
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_) {
#line 7456 "number.c"
		const gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _ ("Inverse cosine is undefined for values outside [-1, 1]");
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp8_);
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_integer ((gint64) 0);
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp9_;
#line 7469 "number.c"
	} else {
		gboolean _tmp10_ = FALSE;
#line 1330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_is_zero (self);
#line 1330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp10_) {
#line 7476 "number.c"
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = pi;
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 2);
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp12_;
#line 7487 "number.c"
		} else {
			Number* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = t1;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = number_equals (self, _tmp13_);
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp14_) {
#line 7497 "number.c"
				Number* _tmp15_ = NULL;
#line 1333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = number_new_integer ((gint64) 0);
#line 1333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 1333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp15_;
#line 7505 "number.c"
			} else {
				Number* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = n1;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = number_equals (self, _tmp16_);
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp17_) {
#line 7515 "number.c"
					Number* _tmp18_ = NULL;
					Number* _tmp19_ = NULL;
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp18_ = pi;
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_ = _g_object_ref0 (_tmp18_);
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp19_;
#line 7526 "number.c"
				} else {
					Number* y = NULL;
					Number* t2 = NULL;
					Number* _tmp20_ = NULL;
					Number* _tmp21_ = NULL;
					Number* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					Number* _tmp25_ = NULL;
					Number* _tmp26_ = NULL;
					Number* _tmp27_ = NULL;
					Number* _tmp28_ = NULL;
					Number* _tmp29_ = NULL;
					gint _tmp30_ = 0;
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = number_multiply (self, self);
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t2 = _tmp20_;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = t1;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp22_ = t2;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = number_subtract (_tmp21_, _tmp22_);
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t2);
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t2 = _tmp23_;
#line 1342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = t2;
#line 1342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = number_sqrt (_tmp24_);
#line 1342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t2);
#line 1342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t2 = _tmp25_;
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp26_ = t2;
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = number_divide (_tmp26_, self);
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t2);
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t2 = _tmp27_;
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = t2;
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp29_ = number_atan (_tmp28_, ANGLE_UNIT_RADIANS);
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (y);
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					y = _tmp29_;
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp30_ = self->re_sign;
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp30_ > 0) {
#line 7583 "number.c"
						Number* _tmp31_ = NULL;
						Number* _tmp32_ = NULL;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp31_ = y;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp32_ = _g_object_ref0 (_tmp31_);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						z = _tmp32_;
#line 7594 "number.c"
					} else {
						Number* _tmp33_ = NULL;
						Number* _tmp34_ = NULL;
						Number* _tmp35_ = NULL;
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp33_ = y;
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp34_ = pi;
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp35_ = number_add (_tmp33_, _tmp34_);
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						z = _tmp35_;
#line 7609 "number.c"
					}
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t2);
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (y);
#line 7615 "number.c"
				}
			}
		}
	}
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = z;
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = unit;
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = number_from_radians (_tmp36_, _tmp37_);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp38_;
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (n1);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (pi);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7638 "number.c"
}


Number* number_atan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t2 = NULL;
	Number* _tmp2_ = NULL;
	gfloat rx = 0.0F;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint q = 0;
	Number* z = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* t1 = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	Number* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	Number* _tmp66_ = NULL;
	AngleUnit _tmp67_ = 0;
	Number* _tmp68_ = NULL;
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 7672 "number.c"
		Number* _tmp1_ = NULL;
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7680 "number.c"
	}
#line 1360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _g_object_ref0 (self);
#line 1360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp2_;
#line 1361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	rx = 0.f;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = self->re_exponent;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = abs (_tmp3_);
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ <= 2) {
#line 7694 "number.c"
		gfloat _tmp5_ = 0.0F;
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_to_float (self);
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		rx = _tmp5_;
#line 7700 "number.c"
	}
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	q = 1;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 7706 "number.c"
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp13_ = 0;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = t2;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = _tmp6_->re_exponent;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp7_ >= 0)) {
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 7737 "number.c"
		}
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t2;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _tmp9_->re_exponent;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp10_ == 0) {
#line 7745 "number.c"
			Number* _tmp11_ = NULL;
			gint _tmp12_ = 0;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = t2;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = _tmp11_->re_fraction[0];
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = (2 * (_tmp12_ + 1)) <= BASE;
#line 7754 "number.c"
		} else {
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = FALSE;
#line 7758 "number.c"
		}
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp8_) {
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 7764 "number.c"
		}
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = q;
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		q = _tmp13_ * 2;
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = t2;
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = t2;
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_multiply (_tmp14_, _tmp15_);
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp16_;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = z;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_new_integer ((gint64) 1);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = _tmp18_;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_add (_tmp17_, _tmp19_);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp20_;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp19_);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = z;
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_sqrt (_tmp21_);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp22_;
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = z;
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_new_integer ((gint64) 1);
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = _tmp24_;
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_add (_tmp23_, _tmp25_);
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp26_;
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp25_);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = t2;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = z;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_divide (_tmp27_, _tmp28_);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp29_;
#line 7826 "number.c"
	}
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = t2;
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp31_;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = t2;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = t2;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_multiply (_tmp32_, _tmp33_);
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp34_;
#line 7844 "number.c"
	{
		gint i = 0;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 1;
#line 7849 "number.c"
		{
			gboolean _tmp35_ = FALSE;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp35_ = TRUE;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 7856 "number.c"
				Number* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				Number* _tmp44_ = NULL;
				Number* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				Number* _tmp47_ = NULL;
				Number* _tmp48_ = NULL;
				Number* _tmp49_ = NULL;
				Number* _tmp50_ = NULL;
				Number* _tmp51_ = NULL;
				gboolean _tmp52_ = FALSE;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp35_) {
#line 7875 "number.c"
					gint _tmp36_ = 0;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp36_ = i;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp36_ + 2;
#line 7881 "number.c"
				}
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = FALSE;
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = t2;
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp38_ = _tmp37_->re_exponent;
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (((T + 2) + _tmp38_) <= 1) {
#line 1391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 7893 "number.c"
				}
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = t2;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = t1;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp41_ = number_multiply (_tmp39_, _tmp40_);
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp42_ = _tmp41_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp43_ = i;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp44_ = number_multiply_integer (_tmp42_, (gint64) (-_tmp43_));
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp45_ = _tmp44_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp46_ = i;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp47_ = number_divide_integer (_tmp45_, (gint64) (_tmp46_ + 2));
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp47_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (_tmp45_);
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (_tmp42_);
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp48_ = z;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp49_ = t2;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp50_ = number_add (_tmp48_, _tmp49_);
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp50_;
#line 1396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp51_ = t2;
#line 1396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp52_ = number_is_zero (_tmp51_);
#line 1396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp52_) {
#line 1397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 7939 "number.c"
				}
			}
		}
	}
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = z;
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = q;
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp55_ = number_multiply_integer (_tmp53_, (gint64) _tmp54_);
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp55_;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = self->re_exponent;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_ = abs (_tmp56_);
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp57_ <= 2) {
#line 7960 "number.c"
		gfloat ry = 0.0F;
		Number* _tmp58_ = NULL;
		gfloat _tmp59_ = 0.0F;
		gfloat _tmp60_ = 0.0F;
		gfloat _tmp61_ = 0.0F;
		gdouble _tmp62_ = 0.0;
		gdouble _tmp63_ = 0.0;
		gfloat _tmp64_ = 0.0F;
		gdouble _tmp65_ = 0.0;
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp58_ = z;
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp59_ = number_to_float (_tmp58_);
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ry = _tmp59_;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp60_ = ry;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp61_ = rx;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp62_ = atan ((gdouble) _tmp61_);
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp63_ = fabs (_tmp60_ - _tmp62_);
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp64_ = ry;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp65_ = fabs ((gdouble) _tmp64_);
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp63_ >= (_tmp65_ * 0.01)) {
#line 1411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr ("*** ERROR OCCURRED IN ATAN, RESULT INCORRECT ***");
#line 7992 "number.c"
		}
	}
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp66_ = z;
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp67_ = unit;
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp68_ = number_from_radians (_tmp66_, _tmp67_);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp68_;
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8011 "number.c"
}


Number* number_sinh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* abs_x = NULL;
	Number* _tmp2_ = NULL;
	Number* z = NULL;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	Number* _tmp34_ = NULL;
#line 1418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 8034 "number.c"
		Number* _tmp1_ = NULL;
#line 1422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 1422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8042 "number.c"
	}
#line 1425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_abs (self);
#line 1425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	abs_x = _tmp2_;
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = abs_x;
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_->re_exponent;
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ <= 0) {
#line 8054 "number.c"
		Number* exp_x = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* a = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* b = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = abs_x;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_epowy (_tmp5_);
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		exp_x = _tmp6_;
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = exp_x;
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_new_integer ((gint64) 1);
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = _tmp8_;
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_add (_tmp7_, _tmp9_);
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = _tmp10_;
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp9_);
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		a = _tmp11_;
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = exp_x;
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_new_integer ((gint64) (-1));
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = _tmp13_;
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_add (_tmp12_, _tmp14_);
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp15_;
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp14_);
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		b = _tmp16_;
#line 1436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = a;
#line 1436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = b;
#line 1436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_multiply (_tmp17_, _tmp18_);
#line 1436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp19_;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = z;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = exp_x;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_divide (_tmp20_, _tmp21_);
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp22_;
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (b);
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (a);
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (exp_x);
#line 8136 "number.c"
	} else {
		Number* exp_x = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = abs_x;
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_epowy (_tmp23_);
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		exp_x = _tmp24_;
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = exp_x;
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_reciprocal (_tmp25_);
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp26_;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = exp_x;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = z;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_subtract (_tmp27_, _tmp28_);
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp29_;
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (exp_x);
#line 8172 "number.c"
	}
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = z;
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp31_;
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = z;
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = self->re_sign;
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_multiply_integer (_tmp32_, (gint64) _tmp33_);
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp34_;
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (abs_x);
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8196 "number.c"
}


Number* number_cosh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* z = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 8221 "number.c"
		Number* _tmp1_ = NULL;
#line 1457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 1457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8229 "number.c"
	}
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_abs (self);
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp2_;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = t;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_epowy (_tmp3_);
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp4_;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = t;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_reciprocal (_tmp5_);
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp6_;
#line 1463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = t;
#line 1463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = z;
#line 1463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_add (_tmp7_, _tmp8_);
#line 1463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp9_;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = z;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_divide_integer (_tmp10_, (gint64) 2);
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp11_;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8271 "number.c"
}


Number* number_tanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t = NULL;
	Number* _tmp2_ = NULL;
	gdouble r__1 = 0.0;
	gdouble _tmp3_ = 0.0;
	Number* z = NULL;
	gdouble _tmp4_ = 0.0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	Number* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	Number* _tmp43_ = NULL;
	gint _tmp44_ = 0;
#line 1468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 8302 "number.c"
		Number* _tmp1_ = NULL;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8310 "number.c"
	}
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_abs (self);
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp2_;
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = log ((gdouble) ((gfloat) BASE));
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	r__1 = (((gfloat) T) * 0.5) * _tmp3_;
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = r__1;
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_new_double (_tmp4_);
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp5_;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = t;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = z;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_compare (_tmp6_, _tmp7_);
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp8_ > 0) {
#line 8334 "number.c"
		gint _tmp9_ = 0;
		Number* _tmp10_ = NULL;
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = self->re_sign;
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_new_integer ((gint64) _tmp9_);
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp10_;
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8349 "number.c"
	}
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = t;
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_multiply_integer (_tmp11_, (gint64) 2);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp12_;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = t;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = _tmp13_->re_exponent;
#line 1485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_ > 0) {
#line 8365 "number.c"
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
#line 1487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = t;
#line 1487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_epowy (_tmp15_);
#line 1487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp16_;
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = t;
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_new_integer ((gint64) (-1));
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = _tmp18_;
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_add (_tmp17_, _tmp19_);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp20_;
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp19_);
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = t;
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_new_integer ((gint64) 1);
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = _tmp22_;
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_add (_tmp21_, _tmp23_);
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp24_;
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp23_);
#line 1490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = z;
#line 1490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = t;
#line 1490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = number_divide (_tmp25_, _tmp26_);
#line 1490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp27_;
#line 8425 "number.c"
	} else {
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = t;
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_epowy (_tmp28_);
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp29_;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = t;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = number_new_integer ((gint64) 1);
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = _tmp31_;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = number_add (_tmp30_, _tmp32_);
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp33_;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp32_);
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = t;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = number_new_integer ((gint64) (-1));
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = _tmp35_;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = number_add (_tmp34_, _tmp36_);
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp37_;
#line 1496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp36_);
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = t;
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = z;
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = number_divide (_tmp38_, _tmp39_);
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp40_;
#line 8486 "number.c"
	}
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = z;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp42_ = self->re_sign;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = z;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp44_ = _tmp43_->re_sign;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_->re_sign = _tmp42_ * _tmp44_;
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8504 "number.c"
}


Number* number_asinh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
#line 1506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_multiply (self, self);
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp0_;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = t;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_new_integer ((gint64) 1);
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_add (_tmp1_, _tmp3_);
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp4_;
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp3_);
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = t;
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_sqrt (_tmp5_);
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp6_;
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = t;
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_add (self, _tmp7_);
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp8_;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = t;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_ln (_tmp9_);
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp10_;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8568 "number.c"
}


Number* number_acosh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
#line 1517 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 1);
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp0_;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = t;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_compare (self, _tmp1_);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ < 0) {
#line 8601 "number.c"
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Inverse hyperbolic cosine is undefined for values less than one");
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp3_);
#line 1525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 1525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8616 "number.c"
	}
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_multiply (self, self);
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp5_;
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = t;
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_new_integer ((gint64) (-1));
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_add (_tmp6_, _tmp8_);
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp9_;
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = t;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_sqrt (_tmp10_);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp11_;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = t;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_add (self, _tmp12_);
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp13_;
#line 1533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = t;
#line 1533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_ln (_tmp14_);
#line 1533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp15_;
#line 1533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8664 "number.c"
}


Number* number_atanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Number* n = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* d = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* z = NULL;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	Number* _tmp23_ = NULL;
	Number* _tmp24_ = NULL;
	Number* _tmp25_ = NULL;
#line 1537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_ >= 0;
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 8710 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) (-1));
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _tmp5_;
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp7_ <= 0;
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp6_);
#line 8725 "number.c"
	}
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 8729 "number.c"
		const gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]");
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp8_);
#line 1544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_integer ((gint64) 0);
#line 1544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp9_;
#line 1544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8742 "number.c"
	}
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_new_integer ((gint64) 1);
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_add (self, _tmp11_);
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_;
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp11_);
#line 1548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	n = _tmp13_;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = number_invert_sign (self);
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	d = _tmp14_;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = d;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = number_new_integer ((gint64) 1);
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = _tmp16_;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = number_add (_tmp15_, _tmp17_);
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (d);
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	d = _tmp18_;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp17_);
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = n;
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = d;
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = number_divide (_tmp19_, _tmp20_);
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp21_;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = z;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = number_ln (_tmp22_);
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp23_;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = z;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = number_divide_integer (_tmp24_, (gint64) 2);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp25_;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (d);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (n);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8804 "number.c"
}


static gint __lambda4_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ & _tmp1_;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8820 "number.c"
}


static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8829 "number.c"
}


Number* number_and (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 8849 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 8859 "number.c"
	}
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 8863 "number.c"
		const gchar* _tmp4_ = NULL;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _ ("Boolean AND is only defined for positive integers");
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp4_);
#line 8869 "number.c"
	}
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = y;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_bitwise (self, _tmp5_, ___lambda4__bitwise_func, self, 0);
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8879 "number.c"
}


static gint __lambda5_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ | _tmp1_;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8895 "number.c"
}


static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8904 "number.c"
}


Number* number_or (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 8924 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 8934 "number.c"
	}
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 8938 "number.c"
		const gchar* _tmp4_ = NULL;
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _ ("Boolean OR is only defined for positive integers");
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp4_);
#line 8944 "number.c"
	}
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = y;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_bitwise (self, _tmp5_, ___lambda5__bitwise_func, self, 0);
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8954 "number.c"
}


static gint __lambda6_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ ^ _tmp1_;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8970 "number.c"
}


static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8979 "number.c"
}


Number* number_xor (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 8999 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 9009 "number.c"
	}
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 9013 "number.c"
		const gchar* _tmp4_ = NULL;
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _ ("Boolean XOR is only defined for positive integers");
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp4_);
#line 9019 "number.c"
	}
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = y;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_bitwise (self, _tmp5_, ___lambda6__bitwise_func, self, 0);
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9029 "number.c"
}


static gint __lambda7_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ ^ 0xF;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9042 "number.c"
}


static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9051 "number.c"
}


Number* number_not (Number* self, gint wordlen) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_positive_integer (self);
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp0_) {
#line 9069 "number.c"
		const gchar* _tmp1_ = NULL;
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Boolean NOT is only defined for positive integers");
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 9075 "number.c"
	}
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_new_integer ((gint64) 0);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = wordlen;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_bitwise (self, _tmp3_, ___lambda7__bitwise_func, self, _tmp4_);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp3_);
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9093 "number.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 9116 "number.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 9124 "number.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 9136 "number.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 9160 "number.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 9166 "number.c"
	} else {
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 9170 "number.c"
	}
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 9174 "number.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 9186 "number.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 9196 "number.c"
	}
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 9202 "number.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 9216 "number.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 9226 "number.c"
	}
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 9232 "number.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 9241 "number.c"
	}
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 9261 "number.c"
}


Number* number_mask (Number* self, Number* x, gint wordlen) {
	Number* result = NULL;
	gchar* text = NULL;
	Number* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint offset = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = x;
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_to_hex_string (_tmp0_);
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text = _tmp1_;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = text;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = strlen (_tmp2_);
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	len = _tmp4_;
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = wordlen;
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset = _tmp5_ / 4;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = len;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = offset;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_ > _tmp8_) {
#line 9313 "number.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = len;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = offset;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = ((gint) _tmp9_) - _tmp10_;
#line 9322 "number.c"
	} else {
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = 0;
#line 9326 "number.c"
	}
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset = _tmp6_;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = text;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = offset;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = string_substring (_tmp11_, (glong) _tmp12_, (glong) (-1));
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = _tmp13_;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = mp_set_from_string (_tmp14_, 16);
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = _tmp15_;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp14_);
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp16_;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (text);
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9350 "number.c"
}


Number* number_shift (Number* self, gint count) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp3_ = 0;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_integer (self);
#line 1618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp0_) {
#line 9364 "number.c"
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
#line 1621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Shift is only possible on integer values");
#line 1621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_integer ((gint64) 0);
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp2_;
#line 1622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9377 "number.c"
	}
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = count;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_ >= 0) {
#line 9383 "number.c"
		gint multiplier = 0;
		gint _tmp9_ = 0;
		Number* _tmp10_ = NULL;
#line 1627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		multiplier = 1;
#line 9389 "number.c"
		{
			gint i = 0;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 9394 "number.c"
			{
				gboolean _tmp4_ = FALSE;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp4_ = TRUE;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 9401 "number.c"
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp4_) {
#line 9407 "number.c"
						gint _tmp5_ = 0;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp5_ = i;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp5_ + 1;
#line 9413 "number.c"
					}
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = FALSE;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp6_ = i;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp7_ = count;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp6_ < _tmp7_)) {
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 9425 "number.c"
					}
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = multiplier;
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					multiplier = _tmp8_ * 2;
#line 9431 "number.c"
				}
			}
		}
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = multiplier;
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_multiply_integer (self, (gint64) _tmp9_);
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp10_;
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9443 "number.c"
	} else {
		gint multiplier = 0;
		gint _tmp16_ = 0;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
#line 1634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		multiplier = 1;
#line 9453 "number.c"
		{
			gint i = 0;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 9458 "number.c"
			{
				gboolean _tmp11_ = FALSE;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = TRUE;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 9465 "number.c"
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp11_) {
#line 9471 "number.c"
						gint _tmp12_ = 0;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp12_ = i;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp12_ + 1;
#line 9477 "number.c"
					}
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = FALSE;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = i;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp14_ = count;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp13_ < (-_tmp14_))) {
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 9489 "number.c"
					}
#line 1636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = multiplier;
#line 1636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					multiplier = _tmp15_ * 2;
#line 9495 "number.c"
				}
			}
		}
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = multiplier;
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = number_divide_integer (self, (gint64) _tmp16_);
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = _tmp17_;
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_floor (_tmp18_);
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = _tmp19_;
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp18_);
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp20_;
#line 1637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9515 "number.c"
	}
}


static gint __lambda8_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ ^ _tmp1_;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9532 "number.c"
}


static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9541 "number.c"
}


Number* number_ones_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
#line 1642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = wordlen;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, _tmp2_);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = wordlen;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_not (_tmp4_, _tmp5_);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp4_);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp7_;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9581 "number.c"
}


Number* number_twos_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = wordlen;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_ones_complement (self, _tmp0_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_new_integer ((gint64) 1);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_add (_tmp2_, _tmp4_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp4_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9618 "number.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 9625 "number.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_list_free (self);
#line 9634 "number.c"
}


GList* number_factorize (Number* self) {
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	guint64 num = 0ULL;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	guint64 _tmp13_ = 0ULL;
	Number* int_max = NULL;
	guint64 _tmp14_ = 0ULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* divisor = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp37_ = NULL;
	Number* root = NULL;
	Number* _tmp38_ = NULL;
	Number* _tmp39_ = NULL;
	Number* _tmp60_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp67_ = FALSE;
#line 1654 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	factors = NULL;
#line 1658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_abs (self);
#line 1658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	value = _tmp0_;
#line 1660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = value;
#line 1660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_zero (_tmp1_);
#line 1660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 9686 "number.c"
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = value;
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp4_);
#line 1663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = factors;
#line 1663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (value);
#line 1663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9701 "number.c"
	}
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = value;
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_integer ((gint64) 1);
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_;
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_equals (_tmp5_, _tmp7_);
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_;
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp7_);
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_) {
#line 9717 "number.c"
		Number* _tmp10_ = NULL;
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _g_object_ref0 (self);
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp10_);
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = factors;
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (value);
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9729 "number.c"
	}
#line 1674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	num = (guint64) 1;
#line 1675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = num;
#line 1675 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	num = _tmp11_ << 63;
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = num;
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = num;
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	num = _tmp12_ + (_tmp13_ - 1);
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = num;
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_new_unsigned_integer (_tmp14_);
#line 1677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	int_max = _tmp15_;
#line 1679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = value;
#line 1679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = int_max;
#line 1679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = number_compare (_tmp16_, _tmp17_);
#line 1679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp18_ <= 0) {
#line 9757 "number.c"
		GList* factors_int64 = NULL;
		Number* _tmp19_ = NULL;
		guint64 _tmp20_ = 0ULL;
		GList* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = value;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_to_unsigned_integer (_tmp19_);
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_factorize_uint64 (self, _tmp20_);
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors_int64 = _tmp21_;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_is_negative (self);
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp22_) {
#line 9775 "number.c"
			GList* _tmp23_ = NULL;
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			Number* _tmp26_ = NULL;
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = factors_int64;
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = factors_int64;
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = _tmp24_->data;
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = number_invert_sign ((Number*) _tmp25_);
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp23_->data);
#line 1683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_->data = _tmp26_;
#line 9792 "number.c"
		}
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = factors_int64;
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (int_max);
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (value);
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		__g_list_free__g_object_unref0_0 (factors);
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9804 "number.c"
	}
#line 1687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = number_new_integer ((gint64) 2);
#line 1687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	divisor = _tmp27_;
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 9812 "number.c"
		Number* tmp = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = value;
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = divisor;
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = number_divide (_tmp28_, _tmp29_);
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp30_;
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = tmp;
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = number_is_integer (_tmp31_);
#line 1691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp32_) {
#line 9833 "number.c"
			Number* _tmp33_ = NULL;
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp33_ = tmp;
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (value);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			value = _tmp34_;
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp35_ = divisor;
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 1694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			factors = g_list_append (factors, _tmp36_);
#line 9852 "number.c"
		} else {
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (tmp);
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 9858 "number.c"
		}
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 9862 "number.c"
	}
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = number_new_integer ((gint64) 3);
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (divisor);
#line 1700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	divisor = _tmp37_;
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = value;
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp39_ = number_sqrt (_tmp38_);
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	root = _tmp39_;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 9878 "number.c"
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		Number* tmp = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = divisor;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = root;
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = number_compare (_tmp40_, _tmp41_);
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp42_ <= 0)) {
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 9898 "number.c"
		}
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = value;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = divisor;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = number_divide (_tmp43_, _tmp44_);
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp45_;
#line 1705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = tmp;
#line 1705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = number_is_integer (_tmp46_);
#line 1705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp47_) {
#line 9914 "number.c"
			Number* _tmp48_ = NULL;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp48_ = tmp;
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp49_ = _g_object_ref0 (_tmp48_);
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (value);
#line 1707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			value = _tmp49_;
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp50_ = value;
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp51_ = number_sqrt (_tmp50_);
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (root);
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			root = _tmp51_;
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp52_ = divisor;
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			factors = g_list_append (factors, _tmp53_);
#line 9943 "number.c"
		} else {
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp54_ = divisor;
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp55_ = number_new_integer ((gint64) 2);
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp56_ = _tmp55_;
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp57_ = number_add (_tmp54_, _tmp56_);
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (tmp);
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			tmp = _tmp57_;
#line 1713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp56_);
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp58_ = tmp;
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (divisor);
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			divisor = _tmp59_;
#line 9973 "number.c"
		}
#line 1702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 9977 "number.c"
	}
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp60_ = value;
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp61_ = number_new_integer ((gint64) 1);
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp62_ = _tmp61_;
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp63_ = number_compare (_tmp60_, _tmp62_);
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp64_ = _tmp63_ > 0;
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp62_);
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp64_) {
#line 9993 "number.c"
		Number* _tmp65_ = NULL;
		Number* _tmp66_ = NULL;
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp65_ = value;
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp66_ = _g_object_ref0 (_tmp65_);
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp66_);
#line 10002 "number.c"
	}
#line 1721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp67_ = number_is_negative (self);
#line 1721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp67_) {
#line 10008 "number.c"
		GList* _tmp68_ = NULL;
		GList* _tmp69_ = NULL;
		gconstpointer _tmp70_ = NULL;
		Number* _tmp71_ = NULL;
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp68_ = factors;
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp69_ = factors;
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp70_ = _tmp69_->data;
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp71_ = number_invert_sign ((Number*) _tmp70_);
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp68_->data);
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp68_->data = _tmp71_;
#line 10025 "number.c"
	}
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = factors;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (root);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (divisor);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (int_max);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (value);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 10039 "number.c"
}


GList* number_factorize_uint64 (Number* self, guint64 n) {
	GList* result = NULL;
	GList* factors = NULL;
	guint64 _tmp14_ = 0ULL;
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	factors = NULL;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 10053 "number.c"
		guint64 _tmp0_ = 0ULL;
		guint64 _tmp1_ = 0ULL;
		Number* _tmp2_ = NULL;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = n;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!((_tmp0_ % 2) == ((guint64) 0))) {
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 10063 "number.c"
		}
#line 1732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = n;
#line 1732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		n = _tmp1_ / 2;
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_unsigned_integer ((guint64) 2);
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp2_);
#line 10073 "number.c"
	}
	{
		guint64 divisor = 0ULL;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		divisor = (guint64) 3;
#line 10079 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 10086 "number.c"
				guint64 _tmp5_ = 0ULL;
				guint64 _tmp6_ = 0ULL;
				guint64 _tmp7_ = 0ULL;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp3_) {
#line 10092 "number.c"
					guint64 _tmp4_ = 0ULL;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = divisor;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					divisor = _tmp4_ + 2;
#line 10098 "number.c"
				}
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = FALSE;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = divisor;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = n;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = divisor;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp5_ <= (_tmp6_ / _tmp7_))) {
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 10112 "number.c"
				}
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 10116 "number.c"
					guint64 _tmp8_ = 0ULL;
					guint64 _tmp9_ = 0ULL;
					guint64 _tmp10_ = 0ULL;
					guint64 _tmp11_ = 0ULL;
					guint64 _tmp12_ = 0ULL;
					Number* _tmp13_ = NULL;
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = n;
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp9_ = divisor;
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!((_tmp8_ % _tmp9_) == ((guint64) 0))) {
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 10131 "number.c"
					}
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = n;
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = divisor;
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					n = _tmp10_ / _tmp11_;
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp12_ = divisor;
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = number_new_unsigned_integer (_tmp12_);
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					factors = g_list_append (factors, _tmp13_);
#line 10145 "number.c"
				}
			}
		}
	}
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = n;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_ > ((guint64) 1)) {
#line 10154 "number.c"
		guint64 _tmp15_ = 0ULL;
		Number* _tmp16_ = NULL;
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = n;
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_new_unsigned_integer (_tmp15_);
#line 1746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp16_);
#line 10163 "number.c"
	}
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = factors;
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 10169 "number.c"
}


static Number* number_copy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new ();
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->re_sign;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_->re_sign = _tmp2_;
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = z;
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = self->im_sign;
#line 1754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_->im_sign = _tmp4_;
#line 1755 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = z;
#line 1755 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = self->re_exponent;
#line 1755 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_->re_exponent = _tmp6_;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = z;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = self->im_exponent;
#line 1756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_->im_exponent = _tmp8_;
#line 10215 "number.c"
	{
		gint i = 0;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 10220 "number.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = TRUE;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 10227 "number.c"
				gint _tmp11_ = 0;
				Number* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				Number* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp9_) {
#line 10241 "number.c"
					gint _tmp10_ = 0;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = i;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp10_ + 1;
#line 10247 "number.c"
				}
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = FALSE;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = i;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp11_ < 1000)) {
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 10257 "number.c"
				}
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = z;
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = i;
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = i;
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = self->re_fraction[_tmp14_];
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_->re_fraction[_tmp13_] = _tmp15_;
#line 1759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = _tmp12_->re_fraction[_tmp13_];
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = z;
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = i;
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = i;
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = self->im_fraction[_tmp19_];
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_->im_fraction[_tmp18_] = _tmp20_;
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = _tmp17_->im_fraction[_tmp18_];
#line 10283 "number.c"
			}
		}
	}
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 10291 "number.c"
}


static Number* number_add_with_sign (Number* self, gint y_sign, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 1766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1766 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_complex (self);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 10309 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_complex (_tmp2_);
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_;
#line 10319 "number.c"
	}
#line 1768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 10323 "number.c"
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		Number* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		Number* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
#line 1772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_real_component (self);
#line 1772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_x = _tmp4_;
#line 1773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_imaginary_component (self);
#line 1773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_x = _tmp5_;
#line 1774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = y;
#line 1774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_real_component (_tmp6_);
#line 1774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_y = _tmp7_;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_y = _tmp9_;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = real_x;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = y_sign;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = y;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = _tmp12_->re_sign;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = real_y;
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_add_real (_tmp10_, _tmp11_ * _tmp13_, _tmp14_);
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 1777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_z = _tmp15_;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = im_x;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = y_sign;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = y;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = _tmp18_->im_sign;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = im_y;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_add_real (_tmp16_, _tmp17_ * _tmp19_, _tmp20_);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_z = _tmp21_;
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = real_z;
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = im_z;
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_new_complex (_tmp22_, _tmp23_);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp24_;
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_y);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_y);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_x);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_x);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 1780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10425 "number.c"
	} else {
		gint _tmp25_ = 0;
		Number* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = y_sign;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = y;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = _tmp26_->re_sign;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = y;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_add_real (self, _tmp25_ * _tmp27_, _tmp28_);
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp29_;
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10446 "number.c"
	}
}


static Number* number_epowy_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	gdouble rx = 0.0;
	gdouble _tmp4_ = 0.0;
	gint xs = 0;
	gint _tmp5_ = 0;
	Number* t2 = NULL;
	Number* _tmp6_ = NULL;
	gint64 ix = 0LL;
	Number* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	Number* z = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	gint tss = 0;
	Number* t1 = NULL;
	gint _tmp17_ = 0;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	gint _tmp36_ = 0;
	Number* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	Number* _tmp43_ = NULL;
	Number* _tmp44_ = NULL;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	gdouble rz = 0.0;
	Number* _tmp49_ = NULL;
	gdouble _tmp50_ = 0.0;
	gdouble r__1 = 0.0;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
#line 1786 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 10503 "number.c"
		Number* _tmp1_ = NULL;
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10511 "number.c"
	}
#line 1793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->re_exponent;
#line 1793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ <= 0) {
#line 10517 "number.c"
		Number* _tmp3_ = NULL;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_exp (self);
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 1794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10525 "number.c"
	}
#line 1797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_to_double (self);
#line 1797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	rx = _tmp4_;
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = self->re_sign;
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	xs = _tmp5_;
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_abs (self);
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp6_;
#line 1804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = t2;
#line 1804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_to_integer (_tmp7_);
#line 1804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	ix = _tmp8_;
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = t2;
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_fractional_component (_tmp9_);
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp10_;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = t2;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = t2;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_->re_sign;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = xs;
#line 1808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_->re_sign = _tmp13_ * _tmp14_;
#line 1809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = t2;
#line 1809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = number_exp (_tmp15_);
#line 1809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp16_;
#line 1814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tss = 0;
#line 1815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (T < 4) {
#line 1816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tss = T + 1;
#line 10575 "number.c"
	} else {
#line 1818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tss = T + 2;
#line 10579 "number.c"
	}
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = xs;
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = number_new_integer ((gint64) _tmp17_);
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp18_;
#line 1824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = t2;
#line 1824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_->re_sign = 0;
#line 10591 "number.c"
	{
		gint i = 0;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 2;
#line 10596 "number.c"
		{
			gboolean _tmp20_ = FALSE;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = TRUE;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 10603 "number.c"
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				Number* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				Number* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				Number* _tmp30_ = NULL;
				Number* _tmp31_ = NULL;
				Number* _tmp32_ = NULL;
				Number* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp20_) {
#line 10620 "number.c"
					gint _tmp21_ = 0;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = i;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp21_ + 1;
#line 10626 "number.c"
				}
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = FALSE;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = tss;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = tss;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = t1;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = _tmp24_->re_exponent;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = MIN (_tmp22_, (_tmp23_ + 2) + _tmp25_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp26_ <= 2) {
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 10644 "number.c"
				}
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = t1;
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = i;
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_ = xs;
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = number_divide_integer (_tmp27_, (gint64) (_tmp28_ * _tmp29_));
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t1);
#line 1830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t1 = _tmp30_;
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = t2;
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = t1;
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp33_ = number_add (_tmp31_, _tmp32_);
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 1831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp33_;
#line 1832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp34_ = t1;
#line 1832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = number_is_zero (_tmp34_);
#line 1832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp35_) {
#line 1833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 10676 "number.c"
				}
			}
		}
	}
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = xs;
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp36_ > 0) {
#line 10685 "number.c"
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = t2;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = number_new_integer ((gint64) 2);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = _tmp38_;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = number_add (_tmp37_, _tmp39_);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp40_;
#line 1838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp39_);
#line 10704 "number.c"
	}
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = t2;
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp42_ = ix;
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = number_xpowy_integer (_tmp41_, _tmp42_);
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp43_;
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp44_ = z;
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp45_ = t2;
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp46_ = number_multiply (_tmp44_, _tmp45_);
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp46_;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp47_ = rx;
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp48_ = fabs (_tmp47_);
#line 1847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp48_ > ((gdouble) 10.0f)) {
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10740 "number.c"
	}
#line 1850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp49_ = z;
#line 1850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp50_ = number_to_double (_tmp49_);
#line 1850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	rz = _tmp50_;
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp51_ = rz;
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52_ = rx;
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = exp (_tmp52_);
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	r__1 = _tmp51_ - _tmp53_;
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = r__1;
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp55_ = fabs (_tmp54_);
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = rz;
#line 1852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp55_ < (_tmp56_ * 0.01f)) {
#line 1853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 1853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 1853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10772 "number.c"
	}
#line 1859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mperr ("*** ERROR OCCURRED IN EPOWY, RESULT INCORRECT ***");
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 10784 "number.c"
}


static Number* number_exp (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	Number* t1 = NULL;
	Number* _tmp4_ = NULL;
	gdouble rlb = 0.0;
	gdouble _tmp5_ = 0.0;
	gint q = 0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gint _tmp10_ = 0;
	Number* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	Number* z = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* t2 = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	Number* _tmp63_ = NULL;
	Number* _tmp64_ = NULL;
	Number* _tmp65_ = NULL;
#line 1870 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1873 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 10821 "number.c"
		Number* _tmp1_ = NULL;
#line 1874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 1874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10829 "number.c"
	}
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->re_exponent;
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ > 0) {
#line 10835 "number.c"
		Number* _tmp3_ = NULL;
#line 1879 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** ABS (X) NOT LESS THAN 1 IN CALL TO MP_EXP ***");
#line 1880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_new_integer ((gint64) 0);
#line 1880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 1880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10845 "number.c"
	}
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _g_object_ref0 (self);
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp4_;
#line 1884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = log ((gdouble) BASE);
#line 1884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	rlb = _tmp5_;
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = rlb;
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = sqrt ((T * 0.48) * _tmp6_);
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = self->re_exponent;
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = rlb;
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	q = (gint) (_tmp7_ + ((_tmp8_ * 1.44) * _tmp9_));
#line 1890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = q;
#line 1890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_ > 0) {
#line 10869 "number.c"
		gint ib = 0;
		gint ic = 0;
#line 1892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ib = BASE << 2;
#line 1893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ic = 1;
#line 10876 "number.c"
		{
			gint i = 0;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 1;
#line 10881 "number.c"
			{
				gboolean _tmp11_ = FALSE;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = TRUE;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 10888 "number.c"
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					Number* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					Number* _tmp25_ = NULL;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp11_) {
#line 10901 "number.c"
						gint _tmp12_ = 0;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp12_ = i;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp12_ + 1;
#line 10907 "number.c"
					}
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = FALSE;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = i;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp14_ = q;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp13_ <= _tmp14_)) {
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 10919 "number.c"
					}
#line 1896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = ic;
#line 1896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ic = _tmp15_ * 2;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp18_ = ic;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_ = ib;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp18_ < _tmp19_) {
#line 10931 "number.c"
						gint _tmp20_ = 0;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp20_ = ic;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp17_ = _tmp20_ != BASE;
#line 10937 "number.c"
					} else {
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp17_ = FALSE;
#line 10941 "number.c"
					}
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp17_) {
#line 10945 "number.c"
						gint _tmp21_ = 0;
						gint _tmp22_ = 0;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp21_ = i;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp22_ = q;
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp16_ = _tmp21_ < _tmp22_;
#line 10954 "number.c"
					} else {
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp16_ = FALSE;
#line 10958 "number.c"
					}
#line 1897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp16_) {
#line 1898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						continue;
#line 10964 "number.c"
					}
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = t1;
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = ic;
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = number_divide_integer (_tmp23_, (gint64) _tmp24_);
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t1);
#line 1899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t1 = _tmp25_;
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ic = 1;
#line 10978 "number.c"
				}
			}
		}
	}
#line 1904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = t1;
#line 1904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = number_is_zero (_tmp26_);
#line 1904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp27_) {
#line 10989 "number.c"
		Number* _tmp28_ = NULL;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = number_new_integer ((gint64) 0);
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp28_;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 10999 "number.c"
	}
#line 1908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp29_ = t1;
#line 1908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = number_copy (_tmp29_);
#line 1908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp30_;
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = t1;
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 1909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp32_;
#line 11013 "number.c"
	{
		gint i = 0;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 2;
#line 11018 "number.c"
		{
			gboolean _tmp33_ = FALSE;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp33_ = TRUE;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 11025 "number.c"
				Number* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				Number* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				Number* _tmp44_ = NULL;
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
				Number* _tmp47_ = NULL;
				Number* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp33_) {
#line 11043 "number.c"
					gint _tmp34_ = 0;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp34_ = i;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp34_ + 1;
#line 11049 "number.c"
				}
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp33_ = FALSE;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = t2;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp36_ = _tmp35_->re_exponent;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = z;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp38_ = _tmp37_->re_exponent;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(((T + _tmp36_) - _tmp38_) > 0)) {
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 11065 "number.c"
				}
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = t1;
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = t2;
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp41_ = number_multiply (_tmp39_, _tmp40_);
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 1912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp41_;
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp42_ = t2;
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp43_ = i;
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp44_ = number_divide_integer (_tmp42_, (gint64) _tmp43_);
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp44_;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp45_ = t2;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp46_ = z;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp47_ = number_add (_tmp45_, _tmp46_);
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp47_;
#line 1915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp48_ = t2;
#line 1915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp49_ = number_is_zero (_tmp48_);
#line 1915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp49_) {
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 11105 "number.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 1;
#line 11114 "number.c"
		{
			gboolean _tmp50_ = FALSE;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp50_ = TRUE;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 11121 "number.c"
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				Number* _tmp54_ = NULL;
				Number* _tmp55_ = NULL;
				Number* _tmp56_ = NULL;
				Number* _tmp57_ = NULL;
				Number* _tmp58_ = NULL;
				Number* _tmp59_ = NULL;
				Number* _tmp60_ = NULL;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp50_) {
#line 11133 "number.c"
					gint _tmp51_ = 0;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp51_ = i;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp51_ + 1;
#line 11139 "number.c"
				}
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp50_ = FALSE;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp52_ = i;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp53_ = q;
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp52_ <= _tmp53_)) {
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 11151 "number.c"
				}
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp54_ = z;
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp55_ = number_new_integer ((gint64) 2);
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp56_ = _tmp55_;
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp57_ = number_add (_tmp54_, _tmp56_);
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t1);
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t1 = _tmp57_;
#line 1922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (_tmp56_);
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp58_ = t1;
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp59_ = z;
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp60_ = number_multiply (_tmp58_, _tmp59_);
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp60_;
#line 11177 "number.c"
			}
		}
	}
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp61_ = z;
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp62_ = number_new_integer ((gint64) 1);
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp63_ = _tmp62_;
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp64_ = number_add (_tmp61_, _tmp63_);
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp65_ = _tmp64_;
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp63_);
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp65_;
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 11203 "number.c"
}


static Number* number_pwr (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
#line 1929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 11227 "number.c"
		Number* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		Number* _tmp4_ = NULL;
#line 1942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = y;
#line 1942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_->re_sign;
#line 1942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_ < 0) {
#line 11237 "number.c"
			const gchar* _tmp3_ = NULL;
#line 1943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _ ("The power of zero is undefined for a negative exponent");
#line 1943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr (_tmp3_);
#line 11243 "number.c"
		}
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11251 "number.c"
	}
#line 1948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = y;
#line 1948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_is_zero (_tmp5_);
#line 1948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_) {
#line 11259 "number.c"
		Number* _tmp7_ = NULL;
#line 1949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_new_integer ((gint64) 1);
#line 1949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp7_;
#line 1949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11267 "number.c"
	}
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = y;
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_ln (self);
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_;
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_multiply (_tmp8_, _tmp10_);
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_;
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_epowy (_tmp12_);
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = _tmp13_;
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp12_);
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp10_);
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp14_;
#line 1951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 11291 "number.c"
}


static Number* number_root_real (Number* self, gint64 n) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 np = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint64 ex = 0LL;
	gint _tmp19_ = 0;
	gint64 _tmp20_ = 0LL;
	Number* t1 = NULL;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gdouble approximation = 0.0;
	gint64 _tmp23_ = 0LL;
	gint64 _tmp24_ = 0LL;
	gint _tmp25_ = 0;
	gdouble _tmp26_ = 0.0;
	Number* _tmp27_ = NULL;
	gfloat _tmp28_ = 0.0F;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gint64 _tmp31_ = 0LL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	Number* _tmp37_ = NULL;
	Number* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint64 _tmp40_ = 0LL;
	gint it0 = 0;
	gint t = 0;
	gint _tmp41_ = 0;
	Number* t2 = NULL;
	gboolean _tmp71_ = FALSE;
	Number* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	gint64 _tmp79_ = 0LL;
#line 1954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = n;
#line 1957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ == ((gint64) 1)) {
#line 11346 "number.c"
		Number* _tmp1_ = NULL;
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11354 "number.c"
	}
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = n;
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ == ((gint64) 0)) {
#line 11360 "number.c"
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Root must be non-zero");
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp3_);
#line 1964 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1964 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 1964 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11373 "number.c"
	}
#line 1967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = n;
#line 1967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = llabs (_tmp5_);
#line 1967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	np = _tmp6_;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = np;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = MAX (BASE, 64);
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_ > ((gint64) _tmp8_)) {
#line 11387 "number.c"
		Number* _tmp9_ = NULL;
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** ABS (N) TOO LARGE IN CALL TO ROOT ***");
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_integer ((gint64) 0);
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp9_;
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11397 "number.c"
	}
#line 1977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_is_zero (self);
#line 1977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_) {
#line 11403 "number.c"
		gint64 _tmp11_ = 0LL;
		Number* _tmp13_ = NULL;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = n;
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp11_ <= ((gint64) 0)) {
#line 11410 "number.c"
			const gchar* _tmp12_ = NULL;
#line 1980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = _ ("Negative root of zero is undefined");
#line 1980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr (_tmp12_);
#line 11416 "number.c"
		}
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_new_integer ((gint64) 0);
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11424 "number.c"
	}
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = self->re_sign;
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp15_ < 0) {
#line 11430 "number.c"
		gint64 _tmp16_ = 0LL;
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = np;
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = (_tmp16_ % 2) == ((gint64) 0);
#line 11436 "number.c"
	} else {
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = FALSE;
#line 11440 "number.c"
	}
#line 1985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_) {
#line 11444 "number.c"
		const gchar* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 1987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _ ("nth root of negative number is undefined for even n");
#line 1987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp17_);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_new_integer ((gint64) 0);
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp18_;
#line 1988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11457 "number.c"
	}
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = self->re_exponent;
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = np;
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	ex = _tmp19_ / _tmp20_;
#line 1995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = number_copy (self);
#line 1995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp21_;
#line 1996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = t1;
#line 1996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_->re_exponent = 0;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = np;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = ex;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = self->re_exponent;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = log ((gdouble) BASE);
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = t1;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = number_to_float (_tmp27_);
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp29_ = fabs ((gdouble) _tmp28_);
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = log (_tmp29_);
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = np;
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = exp (((((_tmp23_ * _tmp24_) - _tmp25_) * _tmp26_) - _tmp30_) / _tmp31_);
#line 1997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	approximation = _tmp32_;
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = approximation;
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_new_double (_tmp33_);
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp34_;
#line 1999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = t1;
#line 1999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = self->re_sign;
#line 1999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_->re_sign = _tmp36_;
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = t1;
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = t1;
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp39_ = _tmp38_->re_exponent;
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp40_ = ex;
#line 2000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_->re_exponent = _tmp39_ - ((gint) _tmp40_);
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	it0 = 3;
#line 2004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = it0;
#line 2004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp41_;
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 11527 "number.c"
		Number* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		Number* _tmp50_ = NULL;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
		Number* _tmp54_ = NULL;
		gint64 _tmp55_ = 0LL;
		Number* _tmp56_ = NULL;
		Number* _tmp57_ = NULL;
		Number* _tmp58_ = NULL;
		Number* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint ts3 = 0;
		gint _tmp61_ = 0;
		gint ts2 = 0;
		gint _tmp62_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
#line 2009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = t1;
#line 2009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = np;
#line 2009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = number_xpowy_integer (_tmp42_, _tmp43_);
#line 2009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp44_;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = t2;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = number_multiply (self, _tmp45_);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp46_;
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = t2;
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp48_ = number_new_integer ((gint64) (-1));
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49_ = _tmp48_;
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = number_add (_tmp47_, _tmp49_);
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp50_;
#line 2011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp49_);
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp51_ = t1;
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp52_ = t2;
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp53_ = number_multiply (_tmp51_, _tmp52_);
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp53_;
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp54_ = t2;
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp55_ = np;
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp56_ = number_divide_integer (_tmp54_, _tmp55_);
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp56_;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp57_ = t1;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp58_ = t2;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp59_ = number_subtract (_tmp57_, _tmp58_);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp59_;
#line 2019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp60_ = t;
#line 2019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp60_ >= T) {
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 11621 "number.c"
		}
#line 2022 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp61_ = t;
#line 2022 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ts3 = _tmp61_;
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp62_ = t;
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ts2 = _tmp62_;
#line 2024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = T;
#line 11633 "number.c"
		{
			gboolean _tmp63_ = FALSE;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp63_ = TRUE;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 11640 "number.c"
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp63_) {
#line 11646 "number.c"
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp64_ = t;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp65_ = ts3;
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp64_ > _tmp65_)) {
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 11657 "number.c"
					}
				}
#line 2025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp63_ = FALSE;
#line 2027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp66_ = t;
#line 2027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				ts2 = _tmp66_;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp67_ = t;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp68_ = it0;
#line 2028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = (_tmp67_ + _tmp68_) / 2;
#line 11672 "number.c"
			}
		}
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp69_ = ts2;
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp70_ = MIN (_tmp69_, T);
#line 2030 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp70_;
#line 11681 "number.c"
	}
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp72_ = t2;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp73_ = _tmp72_->re_sign;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp73_ != 0) {
#line 11689 "number.c"
		Number* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		Number* _tmp76_ = NULL;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp74_ = t1;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp75_ = _tmp74_->re_exponent;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp76_ = t2;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp77_ = _tmp76_->re_exponent;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp78_ = it0;
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp71_ = ((_tmp75_ - _tmp77_) << 1) < (T - _tmp78_);
#line 11707 "number.c"
	} else {
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp71_ = FALSE;
#line 11711 "number.c"
	}
#line 2036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp71_) {
#line 2042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** ERROR OCCURRED IN ROOT, NEWTON ITERATION NOT CONVERGING PROPERLY *" \
"**");
#line 11717 "number.c"
	}
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp79_ = n;
#line 2045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp79_ >= ((gint64) 0)) {
#line 11723 "number.c"
		Number* _tmp80_ = NULL;
		gint64 _tmp81_ = 0LL;
		Number* _tmp82_ = NULL;
		Number* _tmp83_ = NULL;
		Number* _tmp84_ = NULL;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp80_ = t1;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp81_ = n;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp82_ = number_xpowy_integer (_tmp80_, _tmp81_ - 1);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp82_;
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp83_ = t1;
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp84_ = number_multiply (self, _tmp83_);
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp84_;
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11751 "number.c"
	}
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = t1;
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 11759 "number.c"
}


static Number* number_ext (Number* self, gint i, gint j) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint q = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint s = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	Number* z = NULL;
	Number* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Number* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	Number* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	Number* _tmp22_ = NULL;
	Number* _tmp23_ = NULL;
#line 2058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_zero (self);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = TRUE;
#line 11794 "number.c"
	} else {
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = T <= 2;
#line 11798 "number.c"
	}
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 11804 "number.c"
	} else {
		gint _tmp3_ = 0;
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = i;
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_ == 0;
#line 11811 "number.c"
	}
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 11815 "number.c"
		Number* _tmp4_ = NULL;
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _g_object_ref0 (self);
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11823 "number.c"
	}
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = j;
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = i;
#line 2064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	q = ((_tmp5_ + 1) / _tmp6_) + 1;
#line 2065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = self->re_fraction[T - 2];
#line 2065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = self->re_fraction[T - 1];
#line 2065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	s = (BASE * _tmp7_) + _tmp8_;
#line 2068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_copy (self);
#line 2068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp9_;
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = s;
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = q;
#line 2069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_ <= _tmp11_) {
#line 11847 "number.c"
		Number* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Number* _tmp14_ = NULL;
		gint _tmp15_ = 0;
#line 2071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = z;
#line 2071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_->re_fraction[T - 2] = 0;
#line 2071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = _tmp12_->re_fraction[T - 2];
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = z;
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_->re_fraction[T - 1] = 0;
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _tmp14_->re_fraction[T - 1];
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11868 "number.c"
	}
#line 2076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = s;
#line 2076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = q;
#line 2076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if ((_tmp16_ + _tmp17_) < (BASE * BASE)) {
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 2077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11880 "number.c"
	}
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = z;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_->re_fraction[T - 2] = BASE - 1;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = _tmp18_->re_fraction[T - 2];
#line 2081 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = z;
#line 2081 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_->re_fraction[T - 1] = BASE;
#line 2081 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = _tmp20_->re_fraction[T - 1];
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = z;
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = number_multiply_integer (_tmp22_, (gint64) 1);
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp23_;
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 2084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 11904 "number.c"
}


static Number* number_ln_real (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp5_ = NULL;
	Number* z = NULL;
	Number* _tmp6_ = NULL;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_eulers ();
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_equals (self, _tmp1_);
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 2090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_) {
#line 11932 "number.c"
		Number* _tmp4_ = NULL;
#line 2091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 1);
#line 2091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 2091 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 11940 "number.c"
	}
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_copy (self);
#line 2094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp5_;
#line 2095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_integer ((gint64) 0);
#line 2095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp6_;
#line 11950 "number.c"
	{
		gint k = 0;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		k = 0;
#line 11955 "number.c"
		{
			gboolean _tmp7_ = FALSE;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = TRUE;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 11962 "number.c"
				gint _tmp9_ = 0;
				Number* t2 = NULL;
				Number* _tmp10_ = NULL;
				Number* _tmp11_ = NULL;
				Number* _tmp12_ = NULL;
				Number* _tmp13_ = NULL;
				Number* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				Number* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				gint e = 0;
				Number* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				Number* _tmp28_ = NULL;
				gdouble rx = 0.0;
				Number* _tmp29_ = NULL;
				gdouble _tmp30_ = 0.0;
				Number* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gdouble rlx = 0.0;
				gdouble _tmp33_ = 0.0;
				gdouble _tmp34_ = 0.0;
				gint _tmp35_ = 0;
				gdouble _tmp36_ = 0.0;
				gdouble _tmp37_ = 0.0;
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				Number* _tmp43_ = NULL;
				Number* _tmp44_ = NULL;
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp7_) {
#line 11999 "number.c"
					gint _tmp8_ = 0;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = k;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					k = _tmp8_ + 1;
#line 12005 "number.c"
				}
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = FALSE;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp9_ = k;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp9_ < 10)) {
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 12015 "number.c"
				}
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp10_ = t1;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = number_new_integer ((gint64) (-1));
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = _tmp11_;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = number_add (_tmp10_, _tmp12_);
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = _tmp13_;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (_tmp12_);
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp14_;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp16_ = t2;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = number_is_zero (_tmp16_);
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp17_) {
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = TRUE;
#line 12039 "number.c"
				} else {
					Number* _tmp18_ = NULL;
					gint _tmp19_ = 0;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp18_ = t2;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp19_ = _tmp18_->re_exponent;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = (_tmp19_ + 1) <= 0;
#line 12049 "number.c"
				}
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp15_) {
#line 12053 "number.c"
					Number* _tmp20_ = NULL;
					Number* _tmp21_ = NULL;
					Number* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					Number* _tmp25_ = NULL;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = z;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = t2;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp22_ = number_lns (_tmp21_);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = _tmp22_;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = number_add (_tmp20_, _tmp23_);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp25_ = _tmp24_;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (_tmp23_);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp25_;
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t2);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (t1);
#line 2101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 12084 "number.c"
				}
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = t1;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = _tmp26_->re_exponent;
#line 2104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				e = _tmp27_;
#line 2105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = t1;
#line 2105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_->re_exponent = 0;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_ = t1;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = number_to_double (_tmp29_);
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				rx = _tmp30_;
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = t1;
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = e;
#line 2107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_->re_exponent = _tmp32_;
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp33_ = rx;
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp34_ = log (_tmp33_);
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = e;
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp36_ = log ((gdouble) BASE);
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				rlx = _tmp34_ + (_tmp35_ * _tmp36_);
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = rlx;
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp38_ = number_new_double (-_tmp37_);
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp38_;
#line 2112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = z;
#line 2112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = t2;
#line 2112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp41_ = number_subtract (_tmp39_, _tmp40_);
#line 2112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 2112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp41_;
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp42_ = t2;
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp43_ = number_epowy (_tmp42_);
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 2113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t2 = _tmp43_;
#line 2116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp44_ = t1;
#line 2116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp45_ = t2;
#line 2116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp46_ = number_multiply (_tmp44_, _tmp45_);
#line 2116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t1);
#line 2116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t1 = _tmp46_;
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t2);
#line 12156 "number.c"
			}
		}
	}
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mperr ("*** ERROR IN LN, ITERATION NOT CONVERGING ***");
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 12168 "number.c"
}


static Number* number_lns (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t2 = NULL;
	Number* _tmp2_ = NULL;
	Number* t1 = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	Number* z = NULL;
	Number* _tmp20_ = NULL;
	Number* _tmp21_ = NULL;
	gint it0 = 0;
	gint t = 0;
	gint _tmp22_ = 0;
	Number* t3 = NULL;
	gboolean _tmp51_ = FALSE;
	Number* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	Number* _tmp57_ = NULL;
	Number* _tmp58_ = NULL;
	gint _tmp59_ = 0;
#line 2128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 12214 "number.c"
		Number* _tmp1_ = NULL;
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 2132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 12222 "number.c"
	}
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_copy (self);
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp2_;
#line 2136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_divide_integer (self, (gint64) 4);
#line 2136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp3_;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = t1;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_new_fraction ((gint64) (-1), (gint64) 3);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_add (_tmp4_, _tmp6_);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp7_;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp6_);
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = t1;
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_multiply (self, _tmp8_);
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp9_;
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = t1;
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_new_fraction ((gint64) 1, (gint64) 2);
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_;
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_add (_tmp10_, _tmp12_);
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp13_;
#line 2139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp12_);
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = t1;
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_multiply (self, _tmp14_);
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp15_;
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = t1;
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = number_new_integer ((gint64) (-1));
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = _tmp17_;
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = number_add (_tmp16_, _tmp18_);
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp19_;
#line 2141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp18_);
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = t1;
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = number_multiply (self, _tmp20_);
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp21_;
#line 2145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	it0 = 5;
#line 2146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = it0;
#line 2146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp22_;
#line 2148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 12304 "number.c"
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint ts3 = 0;
		gint _tmp42_ = 0;
		gint ts2 = 0;
		gint _tmp43_ = 0;
		gint _tmp50_ = 0;
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = z;
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_epowy (_tmp23_);
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t3);
#line 2152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t3 = _tmp24_;
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = t3;
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_new_integer ((gint64) (-1));
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = _tmp26_;
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = number_add (_tmp25_, _tmp27_);
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t3);
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t3 = _tmp28_;
#line 2153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp27_);
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = t2;
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = t3;
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = number_multiply (_tmp29_, _tmp30_);
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp31_;
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = t3;
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = t1;
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = number_add (_tmp32_, _tmp33_);
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t3);
#line 2155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t3 = _tmp34_;
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = t2;
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = t3;
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = number_add (_tmp35_, _tmp36_);
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t3);
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t3 = _tmp37_;
#line 2157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = z;
#line 2157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = t3;
#line 2157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = number_subtract (_tmp38_, _tmp39_);
#line 2157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp40_;
#line 2158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = t;
#line 2158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp41_ >= T) {
#line 2159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 12397 "number.c"
		}
#line 2165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = t;
#line 2165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ts3 = _tmp42_;
#line 2166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = t;
#line 2166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ts2 = _tmp43_;
#line 2167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = T;
#line 12409 "number.c"
		{
			gboolean _tmp44_ = FALSE;
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp44_ = TRUE;
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 12416 "number.c"
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp44_) {
#line 12422 "number.c"
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
#line 2172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp45_ = t;
#line 2172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp46_ = ts3;
#line 2172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp45_ > _tmp46_)) {
#line 2172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 12433 "number.c"
					}
				}
#line 2168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp44_ = FALSE;
#line 2170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp47_ = t;
#line 2170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				ts2 = _tmp47_;
#line 2171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp48_ = t;
#line 2171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp49_ = it0;
#line 2171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = (_tmp48_ + _tmp49_) / 2;
#line 12448 "number.c"
			}
		}
#line 2173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = ts2;
#line 2173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp50_;
#line 12455 "number.c"
	}
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52_ = t3;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = _tmp52_->re_sign;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp53_ != 0) {
#line 12463 "number.c"
		Number* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp54_ = t3;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp55_ = _tmp54_->re_exponent;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp56_ = it0;
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp51_ = (_tmp55_ << 1) > (_tmp56_ - T);
#line 12475 "number.c"
	} else {
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp51_ = FALSE;
#line 12479 "number.c"
	}
#line 2177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp51_) {
#line 2178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** ERROR OCCURRED IN LNS, NEWTON ITERATION NOT CONVERGING PROPERLY **" \
"*");
#line 12485 "number.c"
	}
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_ = z;
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp58_ = z;
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp59_ = _tmp58_->re_sign;
#line 2180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_->re_sign = -_tmp59_;
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t3);
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 12505 "number.c"
}


static gint* _vala_array_dup12 (gint* self, int length) {
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return g_memdup (self, length * sizeof (gint));
#line 12512 "number.c"
}


static gint* _vala_array_dup13 (gint* self, int length) {
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return g_memdup (self, length * sizeof (gint));
#line 12519 "number.c"
}


static gint* _vala_array_dup14 (gint* self, int length) {
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return g_memdup (self, length * sizeof (gint));
#line 12526 "number.c"
}


static gint* _vala_array_dup15 (gint* self, int length) {
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return g_memdup (self, length * sizeof (gint));
#line 12533 "number.c"
}


static Number* number_add_real (Number* self, gint y_sign, Number* y) {
	Number* result = NULL;
	gint re_sign_prod = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint exp_diff = 0;
	gint _tmp13_ = 0;
	Number* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint med = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean x_largest = FALSE;
	gint _tmp18_ = 0;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
	gint* big_fraction = NULL;
	gint big_fraction_length1 = 0;
	gint _big_fraction_size_ = 0;
	gint* small_fraction = NULL;
	gint small_fraction_length1 = 0;
	gint _small_fraction_size_ = 0;
	gboolean _tmp35_ = FALSE;
	gint _tmp58_ = 0;
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y_sign;
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->re_sign;
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	re_sign_prod = _tmp0_ * _tmp1_;
#line 2190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_zero (self);
#line 2190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 12576 "number.c"
		gint _tmp3_ = 0;
		Number* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = y_sign;
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = y;
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_->re_sign;
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_ != _tmp5_) {
#line 12588 "number.c"
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = y;
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = number_invert_sign (_tmp6_);
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp7_;
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 12599 "number.c"
		} else {
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = y;
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp9_;
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 12611 "number.c"
		}
	} else {
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = y;
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_is_zero (_tmp10_);
#line 2198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp11_) {
#line 12622 "number.c"
			Number* _tmp12_ = NULL;
#line 2199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = _g_object_ref0 (self);
#line 2199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp12_;
#line 2199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 12630 "number.c"
		}
	}
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = self->re_exponent;
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = y;
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = _tmp14_->re_exponent;
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	exp_diff = _tmp13_ - _tmp15_;
#line 2202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = exp_diff;
#line 2202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = abs (_tmp16_);
#line 2202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	med = _tmp17_;
#line 2203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_largest = FALSE;
#line 2204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = exp_diff;
#line 2204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp18_ < 0) {
#line 2205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_largest = FALSE;
#line 12655 "number.c"
	} else {
		gint _tmp19_ = 0;
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = exp_diff;
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp19_ > 0) {
#line 2207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			x_largest = TRUE;
#line 12664 "number.c"
		} else {
			gint _tmp20_ = 0;
#line 2211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = re_sign_prod;
#line 2211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp20_ < 0) {
#line 12671 "number.c"
				gint j = 0;
				gint _tmp32_ = 0;
				{
					gboolean _tmp21_ = FALSE;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					j = 0;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = TRUE;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					while (TRUE) {
#line 12682 "number.c"
						gint _tmp23_ = 0;
						gint i = 0;
						gint _tmp24_ = 0;
						gint _tmp25_ = 0;
						Number* _tmp26_ = NULL;
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						gint _tmp29_ = 0;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp21_) {
#line 12693 "number.c"
							gint _tmp22_ = 0;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp22_ = j;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							j = _tmp22_ + 1;
#line 12699 "number.c"
						}
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp21_ = FALSE;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp23_ = j;
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!(_tmp23_ < T)) {
#line 2215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							break;
#line 12709 "number.c"
						}
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp24_ = j;
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp25_ = self->re_fraction[_tmp24_];
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp26_ = y;
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp27_ = j;
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp28_ = _tmp26_->re_fraction[_tmp27_];
#line 2217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp25_ - _tmp28_;
#line 2218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp29_ = i;
#line 2218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (_tmp29_ != 0) {
#line 12727 "number.c"
							gint _tmp30_ = 0;
#line 2220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp30_ = i;
#line 2220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp30_ < 0) {
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								x_largest = FALSE;
#line 12735 "number.c"
							} else {
								gint _tmp31_ = 0;
#line 2222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp31_ = i;
#line 2222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								if (_tmp31_ > 0) {
#line 2223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
									x_largest = TRUE;
#line 12744 "number.c"
								}
							}
#line 2224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							break;
#line 12749 "number.c"
						}
					}
				}
#line 2229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = j;
#line 2229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp32_ >= T) {
#line 12757 "number.c"
					Number* _tmp33_ = NULL;
#line 2230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp33_ = number_new_integer ((gint64) 0);
#line 2230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp33_;
#line 2230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 12765 "number.c"
				}
			}
		}
	}
#line 2234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_new_integer ((gint64) 0);
#line 2234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp34_;
#line 2237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = x_largest;
#line 2237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp35_) {
#line 12778 "number.c"
		Number* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		Number* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint* _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		Number* _tmp41_ = NULL;
		gint* _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
#line 2239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = z;
#line 2239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = self->re_sign;
#line 2239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_->re_sign = _tmp37_;
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = z;
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = self->re_exponent;
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_->re_exponent = _tmp39_;
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = (self->re_fraction != NULL) ? _vala_array_dup12 (self->re_fraction, 1000) : ((gpointer) self->re_fraction);
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40__length1 = 1000;
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		big_fraction = (g_free (big_fraction), NULL);
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		big_fraction = _tmp40_;
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		big_fraction_length1 = _tmp40__length1;
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_big_fraction_size_ = big_fraction_length1;
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = y;
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = (_tmp41_->re_fraction != NULL) ? _vala_array_dup13 (_tmp41_->re_fraction, 1000) : ((gpointer) _tmp41_->re_fraction);
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42__length1 = 1000;
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		small_fraction = (g_free (small_fraction), NULL);
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		small_fraction = _tmp42_;
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		small_fraction_length1 = _tmp42__length1;
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_small_fraction_size_ = small_fraction_length1;
#line 12826 "number.c"
	} else {
		Number* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		gint* _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		gint* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = z;
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = y_sign;
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_->re_sign = _tmp44_;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = z;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = y;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = _tmp46_->re_exponent;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_->re_exponent = _tmp47_;
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp48_ = y;
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49_ = (_tmp48_->re_fraction != NULL) ? _vala_array_dup14 (_tmp48_->re_fraction, 1000) : ((gpointer) _tmp48_->re_fraction);
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49__length1 = 1000;
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		big_fraction = (g_free (big_fraction), NULL);
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		big_fraction = _tmp49_;
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		big_fraction_length1 = _tmp49__length1;
#line 2248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_big_fraction_size_ = big_fraction_length1;
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = (self->re_fraction != NULL) ? _vala_array_dup15 (self->re_fraction, 1000) : ((gpointer) self->re_fraction);
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50__length1 = 1000;
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		small_fraction = (g_free (small_fraction), NULL);
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		small_fraction = _tmp50_;
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		small_fraction_length1 = _tmp50__length1;
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_small_fraction_size_ = small_fraction_length1;
#line 12878 "number.c"
	}
	{
		gint i = 0;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 3;
#line 12884 "number.c"
		{
			gboolean _tmp51_ = FALSE;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp51_ = TRUE;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 12891 "number.c"
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				Number* _tmp55_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp51_) {
#line 12899 "number.c"
					gint _tmp52_ = 0;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp52_ = i;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp52_ - 1;
#line 12905 "number.c"
				}
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp51_ = FALSE;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp53_ = i;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp54_ = med;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp53_ >= _tmp54_)) {
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 12917 "number.c"
				}
#line 2254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp55_ = z;
#line 2254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp56_ = i;
#line 2254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp55_->re_fraction[T + _tmp56_] = 0;
#line 2254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp57_ = _tmp55_->re_fraction[T + _tmp56_];
#line 12927 "number.c"
			}
		}
	}
#line 2256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp58_ = re_sign_prod;
#line 2256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp58_ >= 0) {
#line 12935 "number.c"
		gint _tmp59_ = 0;
		gint i = 0;
		gint c = 0;
		gint _tmp118_ = 0;
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp59_ = med;
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if ((T + 3) < _tmp59_) {
#line 12944 "number.c"
			const gchar* _tmp60_ = NULL;
			Number* _tmp61_ = NULL;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp60_ = _ ("Overflow: the result couldn't be calculated");
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr (_tmp60_);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp61_ = number_new_integer ((gint64) 0);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp61_;
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			small_fraction = (g_free (small_fraction), NULL);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			big_fraction = (g_free (big_fraction), NULL);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 12963 "number.c"
		}
#line 2266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 12967 "number.c"
		{
			gboolean _tmp62_ = FALSE;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = T + 3;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp62_ = TRUE;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 12976 "number.c"
				gint _tmp64_ = 0;
				Number* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gint* _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp62_) {
#line 12988 "number.c"
					gint _tmp63_ = 0;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp63_ = i;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp63_ - 1;
#line 12994 "number.c"
				}
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp62_ = FALSE;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp64_ = i;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp64_ >= T)) {
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13004 "number.c"
				}
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp65_ = z;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp66_ = i;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp67_ = small_fraction;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp67__length1 = small_fraction_length1;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp68_ = i;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp69_ = med;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp70_ = _tmp67_[_tmp68_ - _tmp69_];
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp65_->re_fraction[_tmp66_] = _tmp70_;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp71_ = _tmp65_->re_fraction[_tmp66_];
#line 13024 "number.c"
			}
		}
#line 2270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = 0;
#line 13029 "number.c"
		{
			gboolean _tmp72_ = FALSE;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp72_ = TRUE;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 13036 "number.c"
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint* _tmp79_ = NULL;
				gint _tmp79__length1 = 0;
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp72_) {
#line 13052 "number.c"
					gint _tmp73_ = 0;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp73_ = i;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp73_ - 1;
#line 13058 "number.c"
				}
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp72_ = FALSE;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp74_ = i;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp75_ = med;
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp74_ >= _tmp75_)) {
#line 2271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13070 "number.c"
				}
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp76_ = big_fraction;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp76__length1 = big_fraction_length1;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp77_ = i;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp78_ = _tmp76_[_tmp77_];
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp79_ = small_fraction;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp79__length1 = small_fraction_length1;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp80_ = i;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp81_ = med;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp82_ = _tmp79_[_tmp80_ - _tmp81_];
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp83_ = c;
#line 2273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = (_tmp78_ + _tmp82_) + _tmp83_;
#line 2275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp84_ = c;
#line 2275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp84_ < BASE) {
#line 13098 "number.c"
					Number* _tmp85_ = NULL;
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					gint _tmp88_ = 0;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp85_ = z;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp86_ = i;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp87_ = c;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp85_->re_fraction[_tmp86_] = _tmp87_;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp88_ = _tmp85_->re_fraction[_tmp86_];
#line 2279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = 0;
#line 13115 "number.c"
				} else {
					Number* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
#line 2284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp89_ = z;
#line 2284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp90_ = i;
#line 2284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp91_ = c;
#line 2284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp89_->re_fraction[_tmp90_] = _tmp91_ - BASE;
#line 2284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp92_ = _tmp89_->re_fraction[_tmp90_];
#line 2285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = 1;
#line 13133 "number.c"
				}
			}
		}
		{
			gboolean _tmp93_ = FALSE;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp93_ = TRUE;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 13143 "number.c"
				gint _tmp95_ = 0;
				gint* _tmp96_ = NULL;
				gint _tmp96__length1 = 0;
				gint _tmp97_ = 0;
				gint _tmp98_ = 0;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				Number* _tmp115_ = NULL;
				gint _tmp116_ = 0;
				gint _tmp117_ = 0;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp93_) {
#line 13156 "number.c"
					gint _tmp94_ = 0;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp94_ = i;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp94_ - 1;
#line 13162 "number.c"
				}
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp93_ = FALSE;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp95_ = i;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp95_ >= 0)) {
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13172 "number.c"
				}
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp96_ = big_fraction;
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp96__length1 = big_fraction_length1;
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp97_ = i;
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp98_ = _tmp96_[_tmp97_];
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp99_ = c;
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = _tmp98_ + _tmp99_;
#line 2292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp100_ = c;
#line 2292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp100_ < BASE) {
#line 13190 "number.c"
					Number* _tmp101_ = NULL;
					gint _tmp102_ = 0;
					gint _tmp103_ = 0;
					gint _tmp104_ = 0;
					gint _tmp105_ = 0;
#line 2294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp101_ = z;
#line 2294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp102_ = i;
#line 2294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp103_ = c;
#line 2294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp101_->re_fraction[_tmp102_] = _tmp103_;
#line 2294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp104_ = _tmp101_->re_fraction[_tmp102_];
#line 2295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp105_ = i;
#line 2295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp105_ - 1;
#line 13210 "number.c"
					{
						gboolean _tmp106_ = FALSE;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp106_ = TRUE;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						while (TRUE) {
#line 13217 "number.c"
							gint _tmp108_ = 0;
							Number* _tmp109_ = NULL;
							gint _tmp110_ = 0;
							gint* _tmp111_ = NULL;
							gint _tmp111__length1 = 0;
							gint _tmp112_ = 0;
							gint _tmp113_ = 0;
							gint _tmp114_ = 0;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!_tmp106_) {
#line 13228 "number.c"
								gint _tmp107_ = 0;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp107_ = i;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								i = _tmp107_ - 1;
#line 13234 "number.c"
							}
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp106_ = FALSE;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp108_ = i;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!(_tmp108_ >= 0)) {
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								break;
#line 13244 "number.c"
							}
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp109_ = z;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp110_ = i;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp111_ = big_fraction;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp111__length1 = big_fraction_length1;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp112_ = i;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp113_ = _tmp111_[_tmp112_];
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp109_->re_fraction[_tmp110_] = _tmp113_;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp114_ = _tmp109_->re_fraction[_tmp110_];
#line 13262 "number.c"
						}
					}
#line 2301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = 0;
#line 2302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13269 "number.c"
				}
#line 2305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp115_ = z;
#line 2305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp116_ = i;
#line 2305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp115_->re_fraction[_tmp116_] = 0;
#line 2305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp117_ = _tmp115_->re_fraction[_tmp116_];
#line 2306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = 1;
#line 13281 "number.c"
			}
		}
#line 2310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp118_ = c;
#line 2310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp118_ != 0) {
#line 13288 "number.c"
			Number* _tmp128_ = NULL;
			gint _tmp129_ = 0;
			Number* _tmp130_ = NULL;
			gint _tmp131_ = 0;
			{
				gint j = 0;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				j = T + 3;
#line 13297 "number.c"
				{
					gboolean _tmp119_ = FALSE;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp119_ = TRUE;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					while (TRUE) {
#line 13304 "number.c"
						gint _tmp121_ = 0;
						Number* _tmp122_ = NULL;
						gint _tmp123_ = 0;
						Number* _tmp124_ = NULL;
						gint _tmp125_ = 0;
						gint _tmp126_ = 0;
						gint _tmp127_ = 0;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp119_) {
#line 13314 "number.c"
							gint _tmp120_ = 0;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp120_ = j;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							j = _tmp120_ - 1;
#line 13320 "number.c"
						}
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp119_ = FALSE;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp121_ = j;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!(_tmp121_ > 0)) {
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							break;
#line 13330 "number.c"
						}
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp122_ = z;
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp123_ = j;
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp124_ = z;
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp125_ = j;
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp126_ = _tmp124_->re_fraction[_tmp125_ - 1];
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp122_->re_fraction[_tmp123_] = _tmp126_;
#line 2313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp127_ = _tmp122_->re_fraction[_tmp123_];
#line 13346 "number.c"
					}
				}
			}
#line 2314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp128_ = z;
#line 2314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp128_->re_fraction[0] = 1;
#line 2314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp129_ = _tmp128_->re_fraction[0];
#line 2315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp130_ = z;
#line 2315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp131_ = _tmp130_->re_exponent;
#line 2315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp130_->re_exponent = _tmp131_ + 1;
#line 13362 "number.c"
		}
	} else {
		gint c = 0;
		gint i = 0;
#line 2320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = 0;
#line 2321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 13371 "number.c"
		{
			gint _tmp132_ = 0;
			gboolean _tmp133_ = FALSE;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp132_ = med;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = (T + _tmp132_) - 1;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp133_ = TRUE;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 13383 "number.c"
				gint _tmp135_ = 0;
				Number* _tmp136_ = NULL;
				gint _tmp137_ = 0;
				gint _tmp138_ = 0;
				gint* _tmp139_ = NULL;
				gint _tmp139__length1 = 0;
				gint _tmp140_ = 0;
				gint _tmp141_ = 0;
				gint _tmp142_ = 0;
				gint _tmp143_ = 0;
				Number* _tmp144_ = NULL;
				gint _tmp145_ = 0;
				gint _tmp146_ = 0;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp133_) {
#line 13399 "number.c"
					gint _tmp134_ = 0;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp134_ = i;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp134_ - 1;
#line 13405 "number.c"
				}
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp133_ = FALSE;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp135_ = i;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp135_ >= T)) {
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13415 "number.c"
				}
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp136_ = z;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp137_ = i;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp138_ = c;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp139_ = small_fraction;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp139__length1 = small_fraction_length1;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp140_ = i;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp141_ = med;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp142_ = _tmp139_[_tmp140_ - _tmp141_];
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp136_->re_fraction[_tmp137_] = _tmp138_ - _tmp142_;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp143_ = _tmp136_->re_fraction[_tmp137_];
#line 2326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = 0;
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp144_ = z;
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp145_ = i;
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp146_ = _tmp144_->re_fraction[_tmp145_];
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp146_ < 0) {
#line 13447 "number.c"
					Number* _tmp147_ = NULL;
					gint _tmp148_ = 0;
					gint _tmp149_ = 0;
#line 2331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = -1;
#line 2332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp147_ = z;
#line 2332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp148_ = i;
#line 2332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp147_->re_fraction[_tmp148_] += BASE;
#line 2332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp149_ = _tmp147_->re_fraction[_tmp148_];
#line 13461 "number.c"
				}
			}
		}
		{
			gboolean _tmp150_ = FALSE;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp150_ = TRUE;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 13471 "number.c"
				gint _tmp152_ = 0;
				gint _tmp153_ = 0;
				gint* _tmp154_ = NULL;
				gint _tmp154__length1 = 0;
				gint _tmp155_ = 0;
				gint _tmp156_ = 0;
				gint _tmp157_ = 0;
				gint* _tmp158_ = NULL;
				gint _tmp158__length1 = 0;
				gint _tmp159_ = 0;
				gint _tmp160_ = 0;
				gint _tmp161_ = 0;
				gint _tmp162_ = 0;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp150_) {
#line 13487 "number.c"
					gint _tmp151_ = 0;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp151_ = i;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp151_ - 1;
#line 13493 "number.c"
				}
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp150_ = FALSE;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp152_ = i;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp153_ = med;
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp152_ >= _tmp153_)) {
#line 2336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13505 "number.c"
				}
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp154_ = big_fraction;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp154__length1 = big_fraction_length1;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp155_ = i;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp156_ = _tmp154_[_tmp155_];
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp157_ = c;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp158_ = small_fraction;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp158__length1 = small_fraction_length1;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp159_ = i;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp160_ = med;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp161_ = _tmp158_[_tmp159_ - _tmp160_];
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = (_tmp156_ + _tmp157_) - _tmp161_;
#line 2339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp162_ = c;
#line 2339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp162_ >= 0) {
#line 13533 "number.c"
					Number* _tmp163_ = NULL;
					gint _tmp164_ = 0;
					gint _tmp165_ = 0;
					gint _tmp166_ = 0;
#line 2342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp163_ = z;
#line 2342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp164_ = i;
#line 2342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp165_ = c;
#line 2342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp163_->re_fraction[_tmp164_] = _tmp165_;
#line 2342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp166_ = _tmp163_->re_fraction[_tmp164_];
#line 2343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = 0;
#line 13550 "number.c"
				} else {
					Number* _tmp167_ = NULL;
					gint _tmp168_ = 0;
					gint _tmp169_ = 0;
					gint _tmp170_ = 0;
#line 2348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp167_ = z;
#line 2348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp168_ = i;
#line 2348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp169_ = c;
#line 2348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp167_->re_fraction[_tmp168_] = _tmp169_ + BASE;
#line 2348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp170_ = _tmp167_->re_fraction[_tmp168_];
#line 2349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = -1;
#line 13568 "number.c"
				}
			}
		}
		{
			gboolean _tmp171_ = FALSE;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp171_ = TRUE;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 13578 "number.c"
				gint _tmp173_ = 0;
				gint* _tmp174_ = NULL;
				gint _tmp174__length1 = 0;
				gint _tmp175_ = 0;
				gint _tmp176_ = 0;
				gint _tmp177_ = 0;
				gint _tmp178_ = 0;
				Number* _tmp193_ = NULL;
				gint _tmp194_ = 0;
				gint _tmp195_ = 0;
				gint _tmp196_ = 0;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp171_) {
#line 13592 "number.c"
					gint _tmp172_ = 0;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp172_ = i;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp172_ - 1;
#line 13598 "number.c"
				}
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp171_ = FALSE;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp173_ = i;
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp173_ >= 0)) {
#line 2353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13608 "number.c"
				}
#line 2355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp174_ = big_fraction;
#line 2355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp174__length1 = big_fraction_length1;
#line 2355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp175_ = i;
#line 2355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp176_ = _tmp174_[_tmp175_];
#line 2355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp177_ = c;
#line 2355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = _tmp176_ + _tmp177_;
#line 2357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp178_ = c;
#line 2357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp178_ >= 0) {
#line 13626 "number.c"
					Number* _tmp179_ = NULL;
					gint _tmp180_ = 0;
					gint _tmp181_ = 0;
					gint _tmp182_ = 0;
					gint _tmp183_ = 0;
#line 2359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp179_ = z;
#line 2359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp180_ = i;
#line 2359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp181_ = c;
#line 2359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp179_->re_fraction[_tmp180_] = _tmp181_;
#line 2359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp182_ = _tmp179_->re_fraction[_tmp180_];
#line 2360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp183_ = i;
#line 2360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp183_ - 1;
#line 13646 "number.c"
					{
						gboolean _tmp184_ = FALSE;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp184_ = TRUE;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						while (TRUE) {
#line 13653 "number.c"
							gint _tmp186_ = 0;
							Number* _tmp187_ = NULL;
							gint _tmp188_ = 0;
							gint* _tmp189_ = NULL;
							gint _tmp189__length1 = 0;
							gint _tmp190_ = 0;
							gint _tmp191_ = 0;
							gint _tmp192_ = 0;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!_tmp184_) {
#line 13664 "number.c"
								gint _tmp185_ = 0;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp185_ = i;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								i = _tmp185_ - 1;
#line 13670 "number.c"
							}
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp184_ = FALSE;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp186_ = i;
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!(_tmp186_ >= 0)) {
#line 2363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								break;
#line 13680 "number.c"
							}
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp187_ = z;
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp188_ = i;
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp189_ = big_fraction;
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp189__length1 = big_fraction_length1;
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp190_ = i;
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp191_ = _tmp189_[_tmp190_];
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp187_->re_fraction[_tmp188_] = _tmp191_;
#line 2364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp192_ = _tmp187_->re_fraction[_tmp188_];
#line 13698 "number.c"
						}
					}
#line 2366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13703 "number.c"
				}
#line 2369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp193_ = z;
#line 2369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp194_ = i;
#line 2369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp195_ = c;
#line 2369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp193_->re_fraction[_tmp194_] = _tmp195_ + BASE;
#line 2369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp196_ = _tmp193_->re_fraction[_tmp194_];
#line 2370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = -1;
#line 13717 "number.c"
			}
		}
	}
#line 2374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_normalize (&z);
#line 2376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	small_fraction = (g_free (small_fraction), NULL);
#line 2376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	big_fraction = (g_free (big_fraction), NULL);
#line 2376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 13731 "number.c"
}


static Number* number_multiply_real (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Number* z = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	Number* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Number* r = NULL;
	Number* _tmp14_ = NULL;
	gint c = 0;
	gint _tmp57_ = 0;
	Number* _tmp75_ = NULL;
	Number* _tmp76_ = NULL;
#line 2379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->re_sign;
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ == 0) {
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 13765 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _tmp2_->re_sign;
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_ == 0;
#line 13775 "number.c"
	}
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 13779 "number.c"
		Number* _tmp4_ = NULL;
#line 2383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 2383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 2383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 13787 "number.c"
	}
#line 2385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_new_integer ((gint64) 0);
#line 2385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp5_;
#line 2386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = z;
#line 2386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = self->re_sign;
#line 2386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = y;
#line 2386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_->re_sign;
#line 2386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_->re_sign = _tmp7_ * _tmp9_;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = z;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = self->re_exponent;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = y;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_->re_exponent;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_->re_exponent = _tmp11_ + _tmp13_;
#line 2389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = number_new_integer ((gint64) 0);
#line 2389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	r = _tmp14_;
#line 2392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = 8;
#line 13819 "number.c"
	{
		gint i = 0;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 13824 "number.c"
		{
			gboolean _tmp15_ = FALSE;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = TRUE;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 13831 "number.c"
				gint _tmp17_ = 0;
				gint xi = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				gint _tmp55_ = 0;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp15_) {
#line 13844 "number.c"
					gint _tmp16_ = 0;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = i;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp16_ + 1;
#line 13850 "number.c"
				}
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = FALSE;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp17_ < T)) {
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 13860 "number.c"
				}
#line 2395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = i;
#line 2395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = self->re_fraction[_tmp18_];
#line 2395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				xi = _tmp19_;
#line 2398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = xi;
#line 2398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp20_ == 0) {
#line 2399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					continue;
#line 13874 "number.c"
				}
				{
					gint j = 0;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					j = 0;
#line 13880 "number.c"
					{
						gboolean _tmp21_ = FALSE;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp21_ = TRUE;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						while (TRUE) {
#line 13887 "number.c"
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Number* _tmp26_ = NULL;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							Number* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!_tmp21_) {
#line 13901 "number.c"
								gint _tmp22_ = 0;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp22_ = j;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								j = _tmp22_ + 1;
#line 13907 "number.c"
							}
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp21_ = FALSE;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp23_ = j;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp24_ = i;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp25_ = MIN (T, (T + 3) - _tmp24_);
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!(_tmp23_ < _tmp25_)) {
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								break;
#line 13921 "number.c"
							}
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp26_ = r;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp27_ = i;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp28_ = j;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp29_ = xi;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp30_ = y;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp31_ = j;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp32_ = _tmp30_->re_fraction[_tmp31_];
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp26_->re_fraction[(_tmp27_ + _tmp28_) + 1] += _tmp29_ * _tmp32_;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp33_ = _tmp26_->re_fraction[(_tmp27_ + _tmp28_) + 1];
#line 13941 "number.c"
						}
					}
				}
#line 2404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp34_ = c;
#line 2404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = _tmp34_ - 1;
#line 2405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = c;
#line 2405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp35_ > 0) {
#line 2406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					continue;
#line 13955 "number.c"
				}
#line 2409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = xi;
#line 2409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp37_ < 0) {
#line 2409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp36_ = TRUE;
#line 13963 "number.c"
				} else {
					gint _tmp38_ = 0;
#line 2409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp38_ = xi;
#line 2409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp36_ = _tmp38_ >= BASE;
#line 13970 "number.c"
				}
#line 2409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp36_) {
#line 13974 "number.c"
					Number* _tmp39_ = NULL;
#line 2411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					mperr ("*** ILLEGAL BASE B DIGIT IN CALL TO MULTIPLY, POSSIBLE OVERWRITING PRO" \
"BLEM ***");
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp39_ = number_new_integer ((gint64) 0);
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp39_;
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (r);
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 13988 "number.c"
				}
				{
					gint j = 0;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					j = T + 3;
#line 13994 "number.c"
					{
						gboolean _tmp40_ = FALSE;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp40_ = TRUE;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						while (TRUE) {
#line 14001 "number.c"
							gint _tmp42_ = 0;
							gint ri = 0;
							Number* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp49_ = 0;
							Number* _tmp50_ = NULL;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!_tmp40_) {
#line 14017 "number.c"
								gint _tmp41_ = 0;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp41_ = j;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								j = _tmp41_ - 1;
#line 14023 "number.c"
							}
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp40_ = FALSE;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp42_ = j;
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (!(_tmp42_ >= 0)) {
#line 2418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								break;
#line 14033 "number.c"
							}
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp43_ = r;
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp44_ = j;
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp45_ = _tmp43_->re_fraction[_tmp44_];
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp46_ = c;
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							ri = _tmp45_ + _tmp46_;
#line 2421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp47_ = ri;
#line 2421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							if (_tmp47_ < 0) {
#line 14049 "number.c"
								Number* _tmp48_ = NULL;
#line 2423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								mperr ("*** INTEGER OVERFLOW IN MULTIPLY, B TOO LARGE ***");
#line 2424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_tmp48_ = number_new_integer ((gint64) 0);
#line 2424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								result = _tmp48_;
#line 2424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_g_object_unref0 (r);
#line 2424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								_g_object_unref0 (z);
#line 2424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
								return result;
#line 14063 "number.c"
							}
#line 2426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp49_ = ri;
#line 2426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							c = _tmp49_ / BASE;
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp50_ = r;
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp51_ = j;
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp52_ = ri;
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp53_ = c;
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp50_->re_fraction[_tmp51_] = _tmp52_ - (BASE * _tmp53_);
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp54_ = _tmp50_->re_fraction[_tmp51_];
#line 14081 "number.c"
						}
					}
				}
#line 2429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp55_ = c;
#line 2429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp55_ != 0) {
#line 14089 "number.c"
					Number* _tmp56_ = NULL;
#line 2431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					mperr ("*** ILLEGAL BASE B DIGIT IN CALL TO MULTIPLY, POSSIBLE OVERWRITING PRO" \
"BLEM ***");
#line 2432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp56_ = number_new_integer ((gint64) 0);
#line 2432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp56_;
#line 2432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (r);
#line 2432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 2432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 14103 "number.c"
				}
#line 2434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = 8;
#line 14107 "number.c"
			}
		}
	}
#line 2437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_ = c;
#line 2437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp57_ != 8) {
#line 14115 "number.c"
		gint _tmp73_ = 0;
#line 2439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = 0;
#line 14119 "number.c"
		{
			gint i = 0;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = T + 3;
#line 14124 "number.c"
			{
				gboolean _tmp58_ = FALSE;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp58_ = TRUE;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 14131 "number.c"
					gint _tmp60_ = 0;
					gint ri = 0;
					Number* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					gint _tmp67_ = 0;
					Number* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp58_) {
#line 14147 "number.c"
						gint _tmp59_ = 0;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp59_ = i;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp59_ - 1;
#line 14153 "number.c"
					}
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp58_ = FALSE;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp60_ = i;
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp60_ >= 0)) {
#line 2440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 14163 "number.c"
					}
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp61_ = r;
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp62_ = i;
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp63_ = _tmp61_->re_fraction[_tmp62_];
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp64_ = c;
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ri = _tmp63_ + _tmp64_;
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp65_ = ri;
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp65_ < 0) {
#line 14179 "number.c"
						Number* _tmp66_ = NULL;
#line 2445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						mperr ("*** INTEGER OVERFLOW IN MULTIPLY, B TOO LARGE ***");
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp66_ = number_new_integer ((gint64) 0);
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						result = _tmp66_;
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (r);
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						return result;
#line 14193 "number.c"
					}
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp67_ = ri;
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = _tmp67_ / BASE;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp68_ = r;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp69_ = i;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp70_ = ri;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp71_ = c;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp68_->re_fraction[_tmp69_] = _tmp70_ - (BASE * _tmp71_);
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp72_ = _tmp68_->re_fraction[_tmp69_];
#line 14211 "number.c"
				}
			}
		}
#line 2452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp73_ = c;
#line 2452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp73_ != 0) {
#line 14219 "number.c"
			Number* _tmp74_ = NULL;
#line 2454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr ("*** ILLEGAL BASE B DIGIT IN CALL TO MULTIPLY, POSSIBLE OVERWRITING PRO" \
"BLEM ***");
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp74_ = number_new_integer ((gint64) 0);
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp74_;
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (r);
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 14233 "number.c"
		}
	}
#line 2460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp75_ = z;
#line 2460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp75_->im_sign = 0;
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp76_ = z;
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp76_->im_exponent = 0;
#line 14244 "number.c"
	{
		gint i = 0;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 14249 "number.c"
		{
			gboolean _tmp77_ = FALSE;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp77_ = TRUE;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 14256 "number.c"
				gint _tmp79_ = 0;
				Number* _tmp80_ = NULL;
				Number* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp77_) {
#line 14264 "number.c"
					gint _tmp78_ = 0;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp78_ = i;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp78_ + 1;
#line 14270 "number.c"
				}
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp77_ = FALSE;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp79_ = i;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp80_ = z;
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp79_ < 1000)) {
#line 2462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 14282 "number.c"
				}
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp81_ = z;
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp82_ = i;
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp81_->im_fraction[_tmp82_] = 0;
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp83_ = _tmp81_->im_fraction[_tmp82_];
#line 14292 "number.c"
			}
		}
	}
	{
		gint i = 0;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 14300 "number.c"
		{
			gboolean _tmp84_ = FALSE;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp84_ = TRUE;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 14307 "number.c"
				gint _tmp86_ = 0;
				Number* _tmp87_ = NULL;
				gint _tmp88_ = 0;
				Number* _tmp89_ = NULL;
				gint _tmp90_ = 0;
				gint _tmp91_ = 0;
				gint _tmp92_ = 0;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp84_) {
#line 14317 "number.c"
					gint _tmp85_ = 0;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp85_ = i;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp85_ + 1;
#line 14323 "number.c"
				}
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp84_ = FALSE;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp86_ = i;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp86_ < SIZE)) {
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 14333 "number.c"
				}
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp87_ = z;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp88_ = i;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp89_ = r;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp90_ = i;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp91_ = _tmp89_->re_fraction[_tmp90_];
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp87_->re_fraction[_tmp88_] = _tmp91_;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp92_ = _tmp87_->re_fraction[_tmp88_];
#line 14349 "number.c"
			}
		}
	}
#line 2469 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_normalize (&z);
#line 2471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (r);
#line 2471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 14361 "number.c"
}


static Number* number_multiply_integer_real (Number* self, gint64 y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* z = NULL;
	Number* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint64 c = 0LL;
	gint64 _tmp13_ = 0LL;
	gint _tmp14_ = 0;
	gint64 _tmp83_ = 0LL;
	Number* _tmp85_ = NULL;
	Number* _tmp86_ = NULL;
#line 2474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (self);
#line 2477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 2477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 14388 "number.c"
	} else {
		gint64 _tmp2_ = 0LL;
#line 2477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 2477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ == ((gint64) 0);
#line 14395 "number.c"
	}
#line 2477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 14399 "number.c"
		Number* _tmp3_ = NULL;
#line 2478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_new_integer ((gint64) 0);
#line 2478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 2478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 14407 "number.c"
	}
#line 2492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_integer ((gint64) 0);
#line 2492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 2494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = y;
#line 2494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_ < ((gint64) 0)) {
#line 14417 "number.c"
		gint64 _tmp6_ = 0LL;
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = y;
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		y = -_tmp6_;
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = z;
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = self->re_sign;
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_->re_sign = -_tmp8_;
#line 14431 "number.c"
	} else {
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 2500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = z;
#line 2500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = self->re_sign;
#line 2500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_->re_sign = _tmp10_;
#line 14441 "number.c"
	}
#line 2501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = z;
#line 2501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = self->re_exponent;
#line 2501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_->re_exponent = _tmp12_ + 4;
#line 2504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = (gint64) 0;
#line 2511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = y;
#line 2511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = MAX (BASE << 3, 32767 / BASE);
#line 2511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp13_ >= ((gint64) _tmp14_)) {
#line 14457 "number.c"
		gint64 j1 = 0LL;
		gint64 _tmp15_ = 0LL;
		gint64 j2 = 0LL;
		gint64 _tmp16_ = 0LL;
		gint64 _tmp17_ = 0LL;
#line 2514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = y;
#line 2514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		j1 = _tmp15_ / BASE;
#line 2515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = y;
#line 2515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = j1;
#line 2515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		j2 = _tmp16_ - (_tmp17_ * BASE);
#line 14473 "number.c"
		{
			gint i = 0;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = T + 3;
#line 14478 "number.c"
			{
				gboolean _tmp18_ = FALSE;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = TRUE;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 14485 "number.c"
					gint _tmp20_ = 0;
					gint64 c1 = 0LL;
					gint64 _tmp21_ = 0LL;
					gint64 c2 = 0LL;
					gint64 _tmp22_ = 0LL;
					gint64 _tmp23_ = 0LL;
					gint ix = 0;
					gint _tmp24_ = 0;
					gint64 t = 0LL;
					gint64 _tmp27_ = 0LL;
					gint _tmp28_ = 0;
					gint64 _tmp29_ = 0LL;
					gint64 is = 0LL;
					gint64 _tmp30_ = 0LL;
					gint64 _tmp31_ = 0LL;
					gint _tmp32_ = 0;
					gint64 _tmp33_ = 0LL;
					gint64 _tmp34_ = 0LL;
					Number* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gint64 _tmp37_ = 0LL;
					gint64 _tmp38_ = 0LL;
					gint _tmp39_ = 0;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp18_) {
#line 14511 "number.c"
						gint _tmp19_ = 0;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp19_ = i;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp19_ - 1;
#line 14517 "number.c"
					}
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp18_ = FALSE;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp20_ = i;
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp20_ >= 0)) {
#line 2518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 14527 "number.c"
					}
#line 2520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp21_ = c;
#line 2520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c1 = _tmp21_ / BASE;
#line 2521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp22_ = c;
#line 2521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = c1;
#line 2521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c2 = _tmp22_ - (BASE * _tmp23_);
#line 2522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ix = 0;
#line 2523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = i;
#line 2523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp24_ > 3) {
#line 14545 "number.c"
						gint _tmp25_ = 0;
						gint _tmp26_ = 0;
#line 2524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp25_ = i;
#line 2524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp26_ = self->re_fraction[_tmp25_ - 4];
#line 2524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						ix = _tmp26_;
#line 14554 "number.c"
					}
#line 2526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = j2;
#line 2526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = ix;
#line 2526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp29_ = c2;
#line 2526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t = (_tmp27_ * _tmp28_) + _tmp29_;
#line 2527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp30_ = t;
#line 2527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					is = _tmp30_ / BASE;
#line 2528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp31_ = j1;
#line 2528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp32_ = ix;
#line 2528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp33_ = c1;
#line 2528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp34_ = is;
#line 2528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = ((_tmp31_ * _tmp32_) + _tmp33_) + _tmp34_;
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp35_ = z;
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp36_ = i;
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp37_ = t;
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp38_ = is;
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp35_->re_fraction[_tmp36_] = (gint) (_tmp37_ - (BASE * _tmp38_));
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp39_ = _tmp35_->re_fraction[_tmp36_];
#line 14590 "number.c"
				}
			}
		}
	} else {
		gint64 ri = 0LL;
		gint64 _tmp53_ = 0LL;
#line 2534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ri = (gint64) 0;
#line 14599 "number.c"
		{
			gint i = 0;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = T + 3;
#line 14604 "number.c"
			{
				gboolean _tmp40_ = FALSE;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = TRUE;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 14611 "number.c"
					gint _tmp42_ = 0;
					gint64 _tmp43_ = 0LL;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gint64 _tmp46_ = 0LL;
					gint64 _tmp47_ = 0LL;
					Number* _tmp48_ = NULL;
					gint _tmp49_ = 0;
					gint64 _tmp50_ = 0LL;
					gint64 _tmp51_ = 0LL;
					gint _tmp52_ = 0;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp40_) {
#line 14625 "number.c"
						gint _tmp41_ = 0;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp41_ = i;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp41_ - 1;
#line 14631 "number.c"
					}
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp40_ = FALSE;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp42_ = i;
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp42_ >= 4)) {
#line 2535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 14641 "number.c"
					}
#line 2537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp43_ = y;
#line 2537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp44_ = i;
#line 2537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp45_ = self->re_fraction[_tmp44_ - 4];
#line 2537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp46_ = c;
#line 2537 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ri = (_tmp43_ * _tmp45_) + _tmp46_;
#line 2538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp47_ = ri;
#line 2538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = _tmp47_ / BASE;
#line 2539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp48_ = z;
#line 2539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp49_ = i;
#line 2539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp50_ = ri;
#line 2539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp51_ = c;
#line 2539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp48_->re_fraction[_tmp49_] = (gint) (_tmp50_ - (BASE * _tmp51_));
#line 2539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp52_ = _tmp48_->re_fraction[_tmp49_];
#line 14669 "number.c"
				}
			}
		}
#line 2543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp53_ = ri;
#line 2543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp53_ < ((gint64) 0)) {
#line 14677 "number.c"
			Number* _tmp54_ = NULL;
#line 2545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr ("*** INTEGER OVERFLOW IN multiply_integer, B TOO LARGE ***");
#line 2546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp54_ = number_new_integer ((gint64) 0);
#line 2546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp54_;
#line 2546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 14689 "number.c"
		}
		{
			gint i = 0;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 3;
#line 14695 "number.c"
			{
				gboolean _tmp55_ = FALSE;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp55_ = TRUE;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 14702 "number.c"
					gint _tmp57_ = 0;
					gint64 t = 0LL;
					gint64 _tmp58_ = 0LL;
					gint64 _tmp59_ = 0LL;
					Number* _tmp60_ = NULL;
					gint _tmp61_ = 0;
					gint64 _tmp62_ = 0LL;
					gint64 _tmp63_ = 0LL;
					gint _tmp64_ = 0;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp55_) {
#line 14714 "number.c"
						gint _tmp56_ = 0;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp56_ = i;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp56_ - 1;
#line 14720 "number.c"
					}
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp55_ = FALSE;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp57_ = i;
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp57_ >= 0)) {
#line 2550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 14730 "number.c"
					}
#line 2552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp58_ = c;
#line 2552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					t = _tmp58_;
#line 2553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp59_ = t;
#line 2553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = _tmp59_ / BASE;
#line 2554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp60_ = z;
#line 2554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp61_ = i;
#line 2554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp62_ = t;
#line 2554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp63_ = c;
#line 2554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp60_->re_fraction[_tmp61_] = (gint) (_tmp62_ - (BASE * _tmp63_));
#line 2554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp64_ = _tmp60_->re_fraction[_tmp61_];
#line 14752 "number.c"
				}
			}
		}
	}
#line 2559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 14759 "number.c"
		gint64 _tmp65_ = 0LL;
		gint64 t = 0LL;
		gint64 _tmp75_ = 0LL;
		gint64 _tmp76_ = 0LL;
		Number* _tmp77_ = NULL;
		gint64 _tmp78_ = 0LL;
		gint64 _tmp79_ = 0LL;
		gint _tmp80_ = 0;
		Number* _tmp81_ = NULL;
		gint _tmp82_ = 0;
#line 2559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp65_ = c;
#line 2559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp65_ != ((gint64) 0))) {
#line 2559 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 14776 "number.c"
		}
		{
			gint i = 0;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = T + 3;
#line 14782 "number.c"
			{
				gboolean _tmp66_ = FALSE;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp66_ = TRUE;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 14789 "number.c"
					gint _tmp68_ = 0;
					Number* _tmp69_ = NULL;
					gint _tmp70_ = 0;
					Number* _tmp71_ = NULL;
					gint _tmp72_ = 0;
					gint _tmp73_ = 0;
					gint _tmp74_ = 0;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp66_) {
#line 14799 "number.c"
						gint _tmp67_ = 0;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp67_ = i;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp67_ - 1;
#line 14805 "number.c"
					}
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp66_ = FALSE;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp68_ = i;
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp68_ >= 1)) {
#line 2561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 14815 "number.c"
					}
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp69_ = z;
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp70_ = i;
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp71_ = z;
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp72_ = i;
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp73_ = _tmp71_->re_fraction[_tmp72_ - 1];
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp69_->re_fraction[_tmp70_] = _tmp73_;
#line 2562 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp74_ = _tmp69_->re_fraction[_tmp70_];
#line 14831 "number.c"
				}
			}
		}
#line 2563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp75_ = c;
#line 2563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp75_;
#line 2564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp76_ = t;
#line 2564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp76_ / BASE;
#line 2565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp77_ = z;
#line 2565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp78_ = t;
#line 2565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp79_ = c;
#line 2565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp77_->re_fraction[0] = (gint) (_tmp78_ - (BASE * _tmp79_));
#line 2565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp80_ = _tmp77_->re_fraction[0];
#line 2566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp81_ = z;
#line 2566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp82_ = _tmp81_->re_exponent;
#line 2566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp81_->re_exponent = _tmp82_ + 1;
#line 14859 "number.c"
	}
#line 2569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp83_ = c;
#line 2569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp83_ < ((gint64) 0)) {
#line 14865 "number.c"
		Number* _tmp84_ = NULL;
#line 2571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** INTEGER OVERFLOW IN multiply_integer, B TOO LARGE ***");
#line 2572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp84_ = number_new_integer ((gint64) 0);
#line 2572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp84_;
#line 2572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 14877 "number.c"
	}
#line 2575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp85_ = z;
#line 2575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp85_->im_sign = 0;
#line 2576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp86_ = z;
#line 2576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp86_->im_exponent = 0;
#line 14887 "number.c"
	{
		gint i = 0;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 14892 "number.c"
		{
			gboolean _tmp87_ = FALSE;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp87_ = TRUE;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 14899 "number.c"
				gint _tmp89_ = 0;
				Number* _tmp90_ = NULL;
				Number* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gint _tmp93_ = 0;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp87_) {
#line 14907 "number.c"
					gint _tmp88_ = 0;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp88_ = i;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp88_ + 1;
#line 14913 "number.c"
				}
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp87_ = FALSE;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp89_ = i;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp90_ = z;
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp89_ < 1000)) {
#line 2577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 14925 "number.c"
				}
#line 2578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp91_ = z;
#line 2578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp92_ = i;
#line 2578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp91_->im_fraction[_tmp92_] = 0;
#line 2578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp93_ = _tmp91_->im_fraction[_tmp92_];
#line 14935 "number.c"
			}
		}
	}
#line 2579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_normalize (&z);
#line 2581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 14945 "number.c"
}


static Number* number_reciprocal_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint t = 0;
	gint it0 = 0;
	gint _tmp12_ = 0;
	Number* t2 = NULL;
	gboolean _tmp35_ = FALSE;
	Number* _tmp36_ = NULL;
	gint _tmp37_ = 0;
#line 2584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 2587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 14975 "number.c"
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
#line 2589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Reciprocal of zero is undefined");
#line 2589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 2590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_integer ((gint64) 0);
#line 2590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp2_;
#line 2590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 14988 "number.c"
	}
#line 2594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_copy (self);
#line 2594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp3_;
#line 2595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = t1;
#line 2595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_->re_exponent = 0;
#line 2596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = t1;
#line 2596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_to_double (_tmp5_);
#line 2596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_new_double (1.0 / _tmp6_);
#line 2596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp7_;
#line 2597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = t1;
#line 2597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = t1;
#line 2597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_->re_exponent;
#line 2597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = self->re_exponent;
#line 2597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_->re_exponent = _tmp10_ - _tmp11_;
#line 2599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = 3;
#line 2600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = t;
#line 2600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	it0 = _tmp12_;
#line 2602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 15026 "number.c"
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint ts3 = 0;
		gint _tmp26_ = 0;
		gint ts2 = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 2605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = t1;
#line 2605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_multiply (self, _tmp13_);
#line 2605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp14_;
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = t2;
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_new_integer ((gint64) (-1));
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _tmp16_;
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_add (_tmp15_, _tmp17_);
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp18_;
#line 2606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp17_);
#line 2607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = t1;
#line 2607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = t2;
#line 2607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_multiply (_tmp19_, _tmp20_);
#line 2607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 2607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp21_;
#line 2608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = t1;
#line 2608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = t2;
#line 2608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_subtract (_tmp22_, _tmp23_);
#line 2608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp24_;
#line 2609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = t;
#line 2609 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp25_ >= T) {
#line 2610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 15093 "number.c"
		}
#line 2615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = t;
#line 2615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ts3 = _tmp26_;
#line 2616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		ts2 = 0;
#line 2617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = T;
#line 15103 "number.c"
		{
			gboolean _tmp27_ = FALSE;
#line 2618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp27_ = TRUE;
#line 2618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 15110 "number.c"
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
#line 2618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp27_) {
#line 15116 "number.c"
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 2622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = t;
#line 2622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp29_ = ts3;
#line 2622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp28_ > _tmp29_)) {
#line 2622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 15127 "number.c"
					}
				}
#line 2618 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = FALSE;
#line 2620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = t;
#line 2620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				ts2 = _tmp30_;
#line 2621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = t;
#line 2621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = it0;
#line 2621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t = (_tmp31_ + _tmp32_) / 2;
#line 15142 "number.c"
			}
		}
#line 2623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = ts2;
#line 2623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = MIN (_tmp33_, T);
#line 2623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp34_;
#line 15151 "number.c"
	}
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = t2;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = _tmp36_->re_sign;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp37_ != 0) {
#line 15159 "number.c"
		Number* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		Number* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = t1;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = _tmp38_->re_exponent;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = t2;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = _tmp40_->re_exponent;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = it0;
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = ((_tmp39_ - _tmp41_) << 1) < (T - _tmp42_);
#line 15177 "number.c"
	} else {
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = FALSE;
#line 15181 "number.c"
	}
#line 2627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp35_) {
#line 2632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** ERROR OCCURRED IN RECIPROCAL, NEWTON ITERATION NOT CONVERGING PROP" \
"ERLY ***");
#line 15187 "number.c"
	}
#line 2635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = t1;
#line 2635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 2635 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 15195 "number.c"
}


static Number* number_divide_integer_real (Number* self, gint64 y) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint64 _tmp6_ = 0LL;
	Number* z = NULL;
	Number* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	Number* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint64 c = 0LL;
	gint64 i = 0LL;
	gint b2 = 0;
	gint _tmp20_ = 0;
	gint64 _tmp21_ = 0LL;
	gint _tmp22_ = 0;
	gint64 j1 = 0LL;
	gint64 _tmp83_ = 0LL;
	gint64 j2 = 0LL;
	gint64 _tmp84_ = 0LL;
	gint64 _tmp85_ = 0LL;
	gint c2 = 0;
	Number* _tmp102_ = NULL;
	Number* _tmp103_ = NULL;
	gint _tmp104_ = 0;
	gint64 _tmp105_ = 0LL;
	gint64 _tmp106_ = 0LL;
	Number* _tmp144_ = NULL;
#line 2638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 2641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ == ((gint64) 0)) {
#line 15234 "number.c"
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
#line 2644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _ ("Division by zero is undefined");
#line 2644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr (_tmp1_);
#line 2645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_integer ((gint64) 0);
#line 2645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp2_;
#line 2645 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 15247 "number.c"
	}
#line 2649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_is_zero (self);
#line 2649 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp3_) {
#line 15253 "number.c"
		Number* _tmp4_ = NULL;
#line 2650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 2650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 2650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 15261 "number.c"
	}
#line 2653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = y;
#line 2653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_ == ((gint64) 1)) {
#line 2653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = TRUE;
#line 15269 "number.c"
	} else {
		gint64 _tmp7_ = 0LL;
#line 2653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = y;
#line 2653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp7_ == ((gint64) (-1));
#line 15276 "number.c"
	}
#line 2653 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_) {
#line 15280 "number.c"
		gint64 _tmp8_ = 0LL;
#line 2655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 2655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp8_ < ((gint64) 0)) {
#line 15286 "number.c"
			Number* _tmp9_ = NULL;
#line 2656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = number_invert_sign (self);
#line 2656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp9_;
#line 2656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 15294 "number.c"
		} else {
			Number* _tmp10_ = NULL;
#line 2658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = _g_object_ref0 (self);
#line 2658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp10_;
#line 2658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 15303 "number.c"
		}
	}
#line 2661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_new_integer ((gint64) 0);
#line 2661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp11_;
#line 2662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = y;
#line 2662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp12_ < ((gint64) 0)) {
#line 15314 "number.c"
		gint64 _tmp13_ = 0LL;
		Number* _tmp14_ = NULL;
		gint _tmp15_ = 0;
#line 2664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = y;
#line 2664 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		y = -_tmp13_;
#line 2665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = z;
#line 2665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = self->re_sign;
#line 2665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_->re_sign = -_tmp15_;
#line 15328 "number.c"
	} else {
		Number* _tmp16_ = NULL;
		gint _tmp17_ = 0;
#line 2668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z;
#line 2668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = self->re_sign;
#line 2668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_->re_sign = _tmp17_;
#line 15338 "number.c"
	}
#line 2669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = z;
#line 2669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = self->re_exponent;
#line 2669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_->re_exponent = _tmp19_;
#line 2671 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = (gint64) 0;
#line 2672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	i = (gint64) 0;
#line 2679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = MAX (BASE << 3, 32767 / BASE);
#line 2679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	b2 = _tmp20_;
#line 2680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = y;
#line 2680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = b2;
#line 2680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp21_ < ((gint64) _tmp22_)) {
#line 15360 "number.c"
		gint64 r1 = 0LL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint64 _tmp38_ = 0LL;
		Number* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		gint _tmp41_ = 0;
		gint64 _tmp42_ = 0LL;
		gint64 _tmp43_ = 0LL;
		gint64 _tmp44_ = 0LL;
		gint64 kh = 0LL;
		gint64 _tmp45_ = 0LL;
		gint64 _tmp81_ = 0LL;
#line 2683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		r1 = (gint64) 0;
#line 15377 "number.c"
		{
			gboolean _tmp23_ = FALSE;
#line 2684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = TRUE;
#line 2684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 15384 "number.c"
				gint64 _tmp25_ = 0LL;
				gint64 _tmp26_ = 0LL;
				gint64 _tmp30_ = 0LL;
				gint64 _tmp31_ = 0LL;
				gint64 _tmp32_ = 0LL;
				gint64 _tmp33_ = 0LL;
#line 2684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp23_) {
#line 15393 "number.c"
					gint64 _tmp24_ = 0LL;
#line 2696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp24_ = r1;
#line 2696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp24_ == ((gint64) 0))) {
#line 2696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 15401 "number.c"
					}
				}
#line 2684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = FALSE;
#line 2686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = c;
#line 2686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = BASE * _tmp25_;
#line 2687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = i;
#line 2687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp26_ < ((gint64) T)) {
#line 15414 "number.c"
					gint64 _tmp27_ = 0LL;
					gint64 _tmp28_ = 0LL;
					gint _tmp29_ = 0;
#line 2688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = c;
#line 2688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp28_ = i;
#line 2688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp29_ = self->re_fraction[_tmp28_];
#line 2688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = _tmp27_ + _tmp29_;
#line 15426 "number.c"
				}
#line 2689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = i;
#line 2689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				i = _tmp30_ + 1;
#line 2690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = c;
#line 2690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = y;
#line 2690 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				r1 = _tmp31_ / _tmp32_;
#line 2691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp33_ = r1;
#line 2691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp33_ < ((gint64) 0)) {
#line 15442 "number.c"
					Number* _tmp34_ = NULL;
#line 2693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
#line 2694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp34_ = number_new_integer ((gint64) 0);
#line 2694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp34_;
#line 2694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 2694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 15454 "number.c"
				}
			}
		}
#line 2699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = z;
#line 2699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = z;
#line 2699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = _tmp36_->re_exponent;
#line 2699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = i;
#line 2699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_->re_exponent = _tmp37_ + ((gint) (1 - _tmp38_));
#line 2700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = z;
#line 2700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = r1;
#line 2700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_->re_fraction[0] = (gint) _tmp40_;
#line 2700 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = _tmp39_->re_fraction[0];
#line 2701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = c;
#line 2701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = y;
#line 2701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = r1;
#line 2701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = BASE * (_tmp42_ - (_tmp43_ * _tmp44_));
#line 2702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		kh = (gint64) 1;
#line 2703 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = i;
#line 2703 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp45_ < ((gint64) T)) {
#line 15490 "number.c"
			gint64 _tmp46_ = 0LL;
			gint64 _tmp65_ = 0LL;
#line 2705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp46_ = i;
#line 2705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			kh = (T + 1) - _tmp46_;
#line 15497 "number.c"
			{
				gint k = 0;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				k = 1;
#line 15502 "number.c"
				{
					gboolean _tmp47_ = FALSE;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp47_ = TRUE;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					while (TRUE) {
#line 15509 "number.c"
						gint _tmp49_ = 0;
						gint64 _tmp50_ = 0LL;
						gint64 _tmp51_ = 0LL;
						gint64 _tmp52_ = 0LL;
						gint _tmp53_ = 0;
						Number* _tmp54_ = NULL;
						gint _tmp55_ = 0;
						gint64 _tmp56_ = 0LL;
						gint64 _tmp57_ = 0LL;
						gint _tmp58_ = 0;
						gint64 _tmp59_ = 0LL;
						gint64 _tmp60_ = 0LL;
						Number* _tmp61_ = NULL;
						gint _tmp62_ = 0;
						gint _tmp63_ = 0;
						gint64 _tmp64_ = 0LL;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp47_) {
#line 15528 "number.c"
							gint _tmp48_ = 0;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_tmp48_ = k;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							k = _tmp48_ + 1;
#line 15534 "number.c"
						}
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp47_ = FALSE;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp49_ = k;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp50_ = kh;
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!(((gint64) _tmp49_) < _tmp50_)) {
#line 2706 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							break;
#line 15546 "number.c"
						}
#line 2708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp51_ = c;
#line 2708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp52_ = i;
#line 2708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp53_ = self->re_fraction[_tmp52_];
#line 2708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						c = _tmp51_ + _tmp53_;
#line 2709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp54_ = z;
#line 2709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp55_ = k;
#line 2709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp56_ = c;
#line 2709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp57_ = y;
#line 2709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp54_->re_fraction[_tmp55_] = (gint) (_tmp56_ / _tmp57_);
#line 2709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp58_ = _tmp54_->re_fraction[_tmp55_];
#line 2710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp59_ = c;
#line 2710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp60_ = y;
#line 2710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp61_ = z;
#line 2710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp62_ = k;
#line 2710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp63_ = _tmp61_->re_fraction[_tmp62_];
#line 2710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						c = BASE * (_tmp59_ - (_tmp60_ * _tmp63_));
#line 2711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp64_ = i;
#line 2711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp64_ + 1;
#line 15584 "number.c"
					}
				}
			}
#line 2713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp65_ = c;
#line 2713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp65_ < ((gint64) 0)) {
#line 15592 "number.c"
				Number* _tmp66_ = NULL;
#line 2715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
#line 2716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp66_ = number_new_integer ((gint64) 0);
#line 2716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				result = _tmp66_;
#line 2716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 2716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				return result;
#line 15604 "number.c"
			}
		}
		{
			gint64 k = 0LL;
			gint64 _tmp67_ = 0LL;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp67_ = kh;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			k = _tmp67_;
#line 15614 "number.c"
			{
				gboolean _tmp68_ = FALSE;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp68_ = TRUE;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 15621 "number.c"
					gint64 _tmp70_ = 0LL;
					Number* _tmp71_ = NULL;
					gint64 _tmp72_ = 0LL;
					gint64 _tmp73_ = 0LL;
					gint64 _tmp74_ = 0LL;
					gint _tmp75_ = 0;
					gint64 _tmp76_ = 0LL;
					gint64 _tmp77_ = 0LL;
					Number* _tmp78_ = NULL;
					gint64 _tmp79_ = 0LL;
					gint _tmp80_ = 0;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp68_) {
#line 15635 "number.c"
						gint64 _tmp69_ = 0LL;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp69_ = k;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						k = _tmp69_ + 1;
#line 15641 "number.c"
					}
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp68_ = FALSE;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp70_ = k;
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp70_ < ((gint64) (T + 4)))) {
#line 2720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 15651 "number.c"
					}
#line 2722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp71_ = z;
#line 2722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp72_ = k;
#line 2722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp73_ = c;
#line 2722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp74_ = y;
#line 2722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp71_->re_fraction[_tmp72_] = (gint) (_tmp73_ / _tmp74_);
#line 2722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp75_ = _tmp71_->re_fraction[_tmp72_];
#line 2723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp76_ = c;
#line 2723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp77_ = y;
#line 2723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp78_ = z;
#line 2723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp79_ = k;
#line 2723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp80_ = _tmp78_->re_fraction[_tmp79_];
#line 2723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					c = BASE * (_tmp76_ - (_tmp77_ * _tmp80_));
#line 15677 "number.c"
				}
			}
		}
#line 2725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp81_ = c;
#line 2725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp81_ < ((gint64) 0)) {
#line 15685 "number.c"
			Number* _tmp82_ = NULL;
#line 2727 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
#line 2728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp82_ = number_new_integer ((gint64) 0);
#line 2728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp82_;
#line 2728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 15697 "number.c"
		}
#line 2731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mp_normalize (&z);
#line 2732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 2732 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 15705 "number.c"
	}
#line 2736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp83_ = y;
#line 2736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	j1 = _tmp83_ / BASE;
#line 2737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp84_ = y;
#line 2737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp85_ = j1;
#line 2737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	j2 = _tmp84_ - (_tmp85_ * BASE);
#line 2740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c2 = 0;
#line 15719 "number.c"
	{
		gboolean _tmp86_ = FALSE;
#line 2741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp86_ = TRUE;
#line 2741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 15726 "number.c"
			gint64 _tmp95_ = 0LL;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
			gint64 _tmp98_ = 0LL;
			gint64 _tmp101_ = 0LL;
#line 2741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp86_) {
#line 15734 "number.c"
				gboolean _tmp87_ = FALSE;
				gint64 _tmp88_ = 0LL;
				gint64 _tmp89_ = 0LL;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp88_ = c;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp89_ = j1;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp88_ < _tmp89_) {
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp87_ = TRUE;
#line 15746 "number.c"
				} else {
					gboolean _tmp90_ = FALSE;
					gint64 _tmp91_ = 0LL;
					gint64 _tmp92_ = 0LL;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp91_ = c;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp92_ = j1;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp91_ == _tmp92_) {
#line 15757 "number.c"
						gint _tmp93_ = 0;
						gint64 _tmp94_ = 0LL;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp93_ = c2;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp94_ = j2;
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp90_ = ((gint64) _tmp93_) < _tmp94_;
#line 15766 "number.c"
					} else {
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp90_ = FALSE;
#line 15770 "number.c"
					}
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp87_ = _tmp90_;
#line 15774 "number.c"
				}
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp87_) {
#line 2746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 15780 "number.c"
				}
			}
#line 2741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp86_ = FALSE;
#line 2743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp95_ = c;
#line 2743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp96_ = c2;
#line 2743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = (BASE * _tmp95_) + _tmp96_;
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp98_ = i;
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp98_ < ((gint64) T)) {
#line 15795 "number.c"
				gint64 _tmp99_ = 0LL;
				gint _tmp100_ = 0;
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp99_ = i;
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp100_ = self->re_fraction[_tmp99_];
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp97_ = _tmp100_;
#line 15804 "number.c"
			} else {
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp97_ = 0;
#line 15808 "number.c"
			}
#line 2744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c2 = _tmp97_;
#line 2745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp101_ = i;
#line 2745 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = _tmp101_ + 1;
#line 15816 "number.c"
		}
	}
#line 2749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp102_ = z;
#line 2749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp103_ = z;
#line 2749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp104_ = _tmp103_->re_exponent;
#line 2749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp105_ = i;
#line 2749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp103_->re_exponent = _tmp104_ + ((gint) (1 - _tmp105_));
#line 2750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp106_ = i;
#line 2750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	i = _tmp106_ - 1;
#line 15833 "number.c"
	{
		gint k = 0;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		k = 1;
#line 15838 "number.c"
		{
			gboolean _tmp107_ = FALSE;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp107_ = TRUE;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 15845 "number.c"
				gint _tmp109_ = 0;
				gint64 ir = 0LL;
				gint64 _tmp110_ = 0LL;
				gint64 _tmp111_ = 0LL;
				gint64 iq = 0LL;
				gint64 _tmp112_ = 0LL;
				gint64 _tmp113_ = 0LL;
				gint64 _tmp114_ = 0LL;
				gint64 _tmp115_ = 0LL;
				gint _tmp116_ = 0;
				gint64 _tmp120_ = 0LL;
				gint64 _tmp121_ = 0LL;
				gint64 _tmp122_ = 0LL;
				gint64 _tmp123_ = 0LL;
				gint64 _tmp127_ = 0LL;
				gint64 _tmp131_ = 0LL;
				gint64 iqj = 0LL;
				gint64 _tmp132_ = 0LL;
				gint64 _tmp133_ = 0LL;
				Number* _tmp134_ = NULL;
				gint _tmp135_ = 0;
				gint64 _tmp136_ = 0LL;
				gint64 _tmp137_ = 0LL;
				gint _tmp138_ = 0;
				gint64 _tmp139_ = 0LL;
				gint64 _tmp140_ = 0LL;
				gint64 _tmp141_ = 0LL;
				gint64 _tmp142_ = 0LL;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp107_) {
#line 15876 "number.c"
					gint _tmp108_ = 0;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp108_ = k;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					k = _tmp108_ + 1;
#line 15882 "number.c"
				}
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp107_ = FALSE;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp109_ = k;
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp109_ <= (T + 4))) {
#line 2753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 15892 "number.c"
				}
#line 2756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp110_ = c;
#line 2756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp111_ = j1;
#line 2756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				ir = _tmp110_ / (_tmp111_ + 1);
#line 2759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp112_ = c;
#line 2759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp113_ = ir;
#line 2759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp114_ = j1;
#line 2759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				iq = _tmp112_ - (_tmp113_ * _tmp114_);
#line 2760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp115_ = iq;
#line 2760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp116_ = b2;
#line 2760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp115_ >= ((gint64) _tmp116_)) {
#line 15914 "number.c"
					gint64 _tmp117_ = 0LL;
					gint64 _tmp118_ = 0LL;
					gint64 _tmp119_ = 0LL;
#line 2763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp117_ = ir;
#line 2763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ir = _tmp117_ + 1;
#line 2764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp118_ = iq;
#line 2764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp119_ = j1;
#line 2764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					iq = _tmp118_ - _tmp119_;
#line 15928 "number.c"
				}
#line 2767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp120_ = iq;
#line 2767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp121_ = ir;
#line 2767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp122_ = j2;
#line 2767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				iq = (_tmp120_ * BASE) - (_tmp121_ * _tmp122_);
#line 2768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp123_ = iq;
#line 2768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp123_ < ((gint64) 0)) {
#line 15942 "number.c"
					gint64 _tmp124_ = 0LL;
					gint64 _tmp125_ = 0LL;
					gint64 _tmp126_ = 0LL;
#line 2771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp124_ = ir;
#line 2771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					ir = _tmp124_ - 1;
#line 2772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp125_ = iq;
#line 2772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp126_ = y;
#line 2772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					iq = _tmp125_ + _tmp126_;
#line 15956 "number.c"
				}
#line 2775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp127_ = i;
#line 2775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp127_ < ((gint64) T)) {
#line 15962 "number.c"
					gint64 _tmp128_ = 0LL;
					gint64 _tmp129_ = 0LL;
					gint _tmp130_ = 0;
#line 2776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp128_ = iq;
#line 2776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp129_ = i;
#line 2776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp130_ = self->re_fraction[_tmp129_];
#line 2776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					iq = _tmp128_ + _tmp130_;
#line 15974 "number.c"
				}
#line 2777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp131_ = i;
#line 2777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				i = _tmp131_ + 1;
#line 2778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp132_ = iq;
#line 2778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp133_ = y;
#line 2778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				iqj = _tmp132_ / _tmp133_;
#line 2781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp134_ = z;
#line 2781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp135_ = k;
#line 2781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp136_ = iqj;
#line 2781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp137_ = ir;
#line 2781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp134_->re_fraction[_tmp135_ - 1] = (gint) (_tmp136_ + _tmp137_);
#line 2781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp138_ = _tmp134_->re_fraction[_tmp135_ - 1];
#line 2782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp139_ = iq;
#line 2782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp140_ = y;
#line 2782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp141_ = iqj;
#line 2782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = _tmp139_ - (_tmp140_ * _tmp141_);
#line 2784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp142_ = c;
#line 2784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp142_ < ((gint64) 0)) {
#line 16010 "number.c"
					Number* _tmp143_ = NULL;
#line 2787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
#line 2788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp143_ = number_new_integer ((gint64) 0);
#line 2788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					result = _tmp143_;
#line 2788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 2788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					return result;
#line 16022 "number.c"
				}
			}
		}
	}
#line 2792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_normalize (&z);
#line 2795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
#line 2796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp144_ = number_new_integer ((gint64) 0);
#line 2796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp144_;
#line 2796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 2796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 16039 "number.c"
}


static Number* number_from_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
#line 2799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 2801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	switch (_tmp0_) {
#line 16052 "number.c"
		default:
#line 2801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_RADIANS:
#line 16056 "number.c"
		{
			Number* _tmp1_ = NULL;
#line 2805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _g_object_ref0 (self);
#line 2805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp1_;
#line 2805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16065 "number.c"
		}
#line 2801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_DEGREES:
#line 16069 "number.c"
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp2_ = number_multiply_integer (self, (gint64) 180);
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _tmp2_;
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_new_pi ();
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = _tmp4_;
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = number_divide (_tmp3_, _tmp5_);
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = _tmp6_;
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp5_);
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp3_);
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp7_;
#line 2808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16097 "number.c"
		}
#line 2801 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_GRADIANS:
#line 16101 "number.c"
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = number_multiply_integer (self, (gint64) 200);
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = _tmp8_;
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = number_new_pi ();
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp10_;
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = number_divide (_tmp9_, _tmp11_);
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = _tmp12_;
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp11_);
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp9_);
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp13_;
#line 2811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16129 "number.c"
		}
	}
}


static Number* number_to_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
#line 2816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 2818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	switch (_tmp0_) {
#line 16144 "number.c"
		default:
#line 2818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_RADIANS:
#line 16148 "number.c"
		{
			Number* _tmp1_ = NULL;
#line 2822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _g_object_ref0 (self);
#line 2822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp1_;
#line 2822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16157 "number.c"
		}
#line 2818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_DEGREES:
#line 16161 "number.c"
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp2_ = number_new_pi ();
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _tmp2_;
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_multiply (self, _tmp3_);
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = _tmp4_;
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = number_divide_integer (_tmp5_, (gint64) 180);
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = _tmp6_;
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp5_);
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp3_);
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp7_;
#line 2825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16189 "number.c"
		}
#line 2818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_GRADIANS:
#line 16193 "number.c"
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = number_new_pi ();
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = _tmp8_;
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = number_multiply (self, _tmp9_);
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp10_;
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 200);
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = _tmp12_;
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp11_);
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp9_);
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp13_;
#line 2828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16221 "number.c"
		}
	}
}


static Number* number_sin1 (Number* self, gboolean do_sin) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t2 = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	Number* t1 = NULL;
	gint i = 0;
	Number* z = NULL;
	gboolean _tmp10_ = FALSE;
	gint b2 = 0;
	gint _tmp16_ = 0;
	gboolean _tmp41_ = FALSE;
#line 2835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 2838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 16250 "number.c"
		gboolean _tmp1_ = FALSE;
#line 2840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = do_sin;
#line 2840 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp1_) {
#line 16256 "number.c"
			Number* _tmp2_ = NULL;
#line 2841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp2_ = number_new_integer ((gint64) 0);
#line 2841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp2_;
#line 2841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16264 "number.c"
		} else {
			Number* _tmp3_ = NULL;
#line 2843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = number_new_integer ((gint64) 1);
#line 2843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp3_;
#line 2843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16273 "number.c"
		}
	}
#line 2846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_multiply (self, self);
#line 2846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp4_;
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = t2;
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_integer ((gint64) 1);
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_;
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_compare (_tmp5_, _tmp7_);
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_ > 0;
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp7_);
#line 2847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_) {
#line 2848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("*** ABS (X) > 1 IN CALL TO SIN1 ***");
#line 16296 "number.c"
	}
#line 2853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = do_sin;
#line 2853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_) {
#line 16302 "number.c"
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 2855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = _g_object_ref0 (self);
#line 2855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp11_;
#line 2856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = t1;
#line 2856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 2856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp13_;
#line 2857 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 2;
#line 16322 "number.c"
	} else {
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
#line 2861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_new_integer ((gint64) 1);
#line 2861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 2861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp14_;
#line 2862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_new_integer ((gint64) 0);
#line 2862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp15_;
#line 2863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 1;
#line 16340 "number.c"
	}
#line 2868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = MAX (BASE, 64);
#line 2868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	b2 = 2 * _tmp16_;
#line 16346 "number.c"
	{
		gboolean _tmp17_ = FALSE;
#line 2869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = TRUE;
#line 2869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 16353 "number.c"
			Number* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			Number* _tmp37_ = NULL;
			Number* _tmp38_ = NULL;
			Number* _tmp39_ = NULL;
			gint _tmp40_ = 0;
#line 2869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp17_) {
#line 16367 "number.c"
				Number* _tmp18_ = NULL;
				gint _tmp19_ = 0;
#line 2888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = t1;
#line 2888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = _tmp18_->re_sign;
#line 2888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp19_ != 0)) {
#line 2888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 16378 "number.c"
				}
			}
#line 2869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp17_ = FALSE;
#line 2871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = t1;
#line 2871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = _tmp20_->re_exponent;
#line 2871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if ((T + _tmp21_) <= 0) {
#line 2872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 16391 "number.c"
			}
#line 2877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = t2;
#line 2877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = t1;
#line 2877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = number_multiply (_tmp22_, _tmp23_);
#line 2877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (t1);
#line 2877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			t1 = _tmp24_;
#line 2878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = i;
#line 2878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = b2;
#line 2878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp25_ > _tmp26_) {
#line 16409 "number.c"
				Number* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				Number* _tmp32_ = NULL;
#line 2880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = t1;
#line 2880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = i;
#line 2880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_ = number_divide_integer (_tmp27_, (gint64) (-_tmp28_));
#line 2880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t1);
#line 2880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t1 = _tmp29_;
#line 2881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = t1;
#line 2881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = i;
#line 2881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = number_divide_integer (_tmp30_, (gint64) (_tmp31_ + 1));
#line 2881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t1);
#line 2881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t1 = _tmp32_;
#line 16436 "number.c"
			} else {
				Number* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				Number* _tmp36_ = NULL;
#line 2884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp33_ = t1;
#line 2884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp34_ = i;
#line 2884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = i;
#line 2884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp36_ = number_divide_integer (_tmp33_, (gint64) ((-_tmp34_) * (_tmp35_ + 1)));
#line 2884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (t1);
#line 2884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				t1 = _tmp36_;
#line 16454 "number.c"
			}
#line 2885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp37_ = t1;
#line 2885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp38_ = z;
#line 2885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp39_ = number_add (_tmp37_, _tmp38_);
#line 2885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp39_;
#line 2887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp40_ = i;
#line 2887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = _tmp40_ + 2;
#line 16470 "number.c"
		}
	}
#line 2890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = do_sin;
#line 2890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp41_) {
#line 16477 "number.c"
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = z;
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = number_new_integer ((gint64) 1);
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = _tmp43_;
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = number_add (_tmp42_, _tmp44_);
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp45_;
#line 2891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp44_);
#line 16496 "number.c"
	}
#line 2893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 2893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 2893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 16506 "number.c"
}


static Number* number_sin_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_radians = NULL;
	AngleUnit _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	gint xs = 0;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* z = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	Number* _tmp65_ = NULL;
	gint _tmp66_ = 0;
#line 2896 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 2899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 16535 "number.c"
		Number* _tmp1_ = NULL;
#line 2900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 0);
#line 2900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 2900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 16543 "number.c"
	}
#line 2902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = unit;
#line 2902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_to_radians (self, _tmp2_);
#line 2902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_radians = _tmp3_;
#line 2904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = x_radians;
#line 2904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_->re_sign;
#line 2904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	xs = _tmp5_;
#line 2905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = x_radians;
#line 2905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_abs (_tmp6_);
#line 2905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_radians);
#line 2905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_radians = _tmp7_;
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = x_radians;
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_new_integer ((gint64) 1);
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_;
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_compare (_tmp8_, _tmp10_);
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_ <= 0;
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp10_);
#line 2909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp12_) {
#line 16579 "number.c"
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
#line 2910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = x_radians;
#line 2910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_sin1 (_tmp13_, TRUE);
#line 2910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp14_;
#line 16590 "number.c"
	} else {
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		Number* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		Number* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
#line 2914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_new_pi ();
#line 2914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp15_;
#line 2914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = number_divide_integer (_tmp16_, (gint64) 4);
#line 2914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp17_;
#line 2914 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp16_);
#line 2915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = x_radians;
#line 2915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = z;
#line 2915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_divide (_tmp18_, _tmp19_);
#line 2915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 2915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_radians = _tmp20_;
#line 2916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = x_radians;
#line 2916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_divide_integer (_tmp21_, (gint64) 8);
#line 2916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 2916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_radians = _tmp22_;
#line 2917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = x_radians;
#line 2917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_fractional_component (_tmp23_);
#line 2917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 2917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_radians = _tmp24_;
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = x_radians;
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_new_fraction ((gint64) (-1), (gint64) 2);
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = _tmp26_;
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = number_add (_tmp25_, _tmp27_);
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_radians = _tmp28_;
#line 2920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp27_);
#line 2921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = xs;
#line 2921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = x_radians;
#line 2921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = _tmp30_->re_sign;
#line 2921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		xs = (-_tmp29_) * _tmp31_;
#line 2922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = xs;
#line 2922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp32_ == 0) {
#line 16686 "number.c"
			Number* _tmp33_ = NULL;
#line 2923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp33_ = number_new_integer ((gint64) 0);
#line 2923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp33_;
#line 2923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_radians);
#line 2923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16698 "number.c"
		}
#line 2925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = x_radians;
#line 2925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_->re_sign = 1;
#line 2926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = x_radians;
#line 2926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = number_multiply_integer (_tmp35_, (gint64) 4);
#line 2926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 2926 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_radians = _tmp36_;
#line 2929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = x_radians;
#line 2929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = _tmp37_->re_exponent;
#line 2929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp38_ > 0) {
#line 16718 "number.c"
			Number* _tmp39_ = NULL;
			Number* _tmp40_ = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp39_ = x_radians;
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp40_ = number_new_integer ((gint64) (-2));
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp41_ = _tmp40_;
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp42_ = number_add (_tmp39_, _tmp41_);
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_radians);
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			x_radians = _tmp42_;
#line 2930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp41_);
#line 16737 "number.c"
		}
#line 2932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = x_radians;
#line 2932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = number_is_zero (_tmp43_);
#line 2932 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp44_) {
#line 16745 "number.c"
			Number* _tmp45_ = NULL;
#line 2933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp45_ = number_new_integer ((gint64) 0);
#line 2933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp45_;
#line 2933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_radians);
#line 2933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 16757 "number.c"
		}
#line 2935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = x_radians;
#line 2935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_->re_sign = 1;
#line 2936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = x_radians;
#line 2936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp48_ = number_multiply_integer (_tmp47_, (gint64) 2);
#line 2936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 2936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_radians = _tmp48_;
#line 2941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49_ = x_radians;
#line 2941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = _tmp49_->re_exponent;
#line 2941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp50_ > 0) {
#line 16777 "number.c"
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp51_ = x_radians;
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp52_ = number_new_integer ((gint64) (-2));
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp53_ = _tmp52_;
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp54_ = number_add (_tmp51_, _tmp53_);
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_radians);
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			x_radians = _tmp54_;
#line 2943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp53_);
#line 2944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp55_ = x_radians;
#line 2944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp56_ = z;
#line 2944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp57_ = number_multiply (_tmp55_, _tmp56_);
#line 2944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_radians);
#line 2944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			x_radians = _tmp57_;
#line 2945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp58_ = x_radians;
#line 2945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp59_ = number_sin1 (_tmp58_, FALSE);
#line 2945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp59_;
#line 16819 "number.c"
		} else {
			Number* _tmp60_ = NULL;
			Number* _tmp61_ = NULL;
			Number* _tmp62_ = NULL;
			Number* _tmp63_ = NULL;
			Number* _tmp64_ = NULL;
#line 2949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp60_ = x_radians;
#line 2949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp61_ = z;
#line 2949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp62_ = number_multiply (_tmp60_, _tmp61_);
#line 2949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_radians);
#line 2949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			x_radians = _tmp62_;
#line 2950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp63_ = x_radians;
#line 2950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp64_ = number_sin1 (_tmp63_, TRUE);
#line 2950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 2950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp64_;
#line 16844 "number.c"
		}
	}
#line 2954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp65_ = z;
#line 2954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp66_ = xs;
#line 2954 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp65_->re_sign = _tmp66_;
#line 2955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 2955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_radians);
#line 2955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 16859 "number.c"
}


static Number* number_cos_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* z = NULL;
	AngleUnit _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
#line 2958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 2961 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 16883 "number.c"
		Number* _tmp1_ = NULL;
#line 2962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 2962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 2962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 16891 "number.c"
	}
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = unit;
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_to_radians (self, _tmp2_);
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_abs (_tmp4_);
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp4_);
#line 2965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp6_;
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = z;
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_new_integer ((gint64) 1);
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_;
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_compare (_tmp7_, _tmp9_);
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_ <= 0;
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp9_);
#line 2966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp11_) {
#line 16921 "number.c"
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 2967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = z;
#line 2967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_sin1 (_tmp12_, FALSE);
#line 2967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 2967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 16934 "number.c"
	} else {
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_new_pi ();
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _tmp14_;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_divide_integer (_tmp15_, (gint64) 2);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _tmp16_;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = z;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_subtract (_tmp17_, _tmp18_);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = _tmp19_;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_sin (_tmp20_, ANGLE_UNIT_RADIANS);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = _tmp21_;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp20_);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp17_);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp15_);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp22_;
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 2970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 16975 "number.c"
	}
#line 2958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 16979 "number.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 16997 "number.c"
}


static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen) {
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_ = NULL;
	gchar* text2 = NULL;
	Number* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint offset1 = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint offset2 = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint offset_out = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gchar* text_out = NULL;
	gint _tmp24_ = 0;
	gchar* _tmp25_ = NULL;
	gint text_out_length1 = 0;
	gint _text_out_size_ = 0;
	gchar* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	Number* _tmp53_ = NULL;
#line 2973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 2975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_to_hex_string (self);
#line 2975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text1 = _tmp0_;
#line 2976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = y;
#line 2976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_to_hex_string (_tmp1_);
#line 2976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text2 = _tmp2_;
#line 2977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = text1;
#line 2977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = strlen (_tmp3_);
#line 2977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_;
#line 2977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset1 = _tmp5_ - 1;
#line 2978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = text2;
#line 2978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = strlen (_tmp6_);
#line 2978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 2978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset2 = _tmp8_ - 1;
#line 2979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = wordlen;
#line 2979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset_out = (_tmp9_ / 4) - 1;
#line 2980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = offset_out;
#line 2980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_ <= 0) {
#line 17067 "number.c"
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = offset1;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = offset2;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp12_ > _tmp13_) {
#line 17077 "number.c"
			gint _tmp14_ = 0;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = offset1;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp14_;
#line 17083 "number.c"
		} else {
			gint _tmp15_ = 0;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = offset2;
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp15_;
#line 17090 "number.c"
		}
#line 2981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		offset_out = _tmp11_;
#line 17094 "number.c"
	}
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = offset_out;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp17_ > 0) {
#line 17100 "number.c"
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = offset_out;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = offset1;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp19_ < _tmp20_) {
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = TRUE;
#line 17112 "number.c"
		} else {
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = offset_out;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = offset2;
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = _tmp21_ < _tmp22_;
#line 17122 "number.c"
		}
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp18_;
#line 17126 "number.c"
	} else {
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = FALSE;
#line 17130 "number.c"
	}
#line 2982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp16_) {
#line 17134 "number.c"
		Number* _tmp23_ = NULL;
#line 2984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mperr ("Overflow. Try a bigger word size");
#line 2985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_new_integer ((gint64) 0);
#line 2985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp23_;
#line 2985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_free0 (text2);
#line 2985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_free0 (text1);
#line 2985 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 17148 "number.c"
	}
#line 2988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = offset_out;
#line 2988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = g_new0 (gchar, _tmp24_ + 1);
#line 2988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text_out = _tmp25_;
#line 2988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text_out_length1 = _tmp24_ + 1;
#line 2988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_text_out_size_ = text_out_length1;
#line 17160 "number.c"
	{
		gchar* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gint _tmp27_ = 0;
		gchar _tmp28_ = '\0';
		gboolean _tmp29_ = FALSE;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = text_out;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26__length1 = text_out_length1;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = offset_out;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_[_tmp27_ + 1] = '\0';
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = _tmp26_[_tmp27_ + 1];
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = TRUE;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 17181 "number.c"
			gint _tmp31_ = 0;
			gint v1 = 0;
			gint v2 = 0;
#line 2994 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
#line 17187 "number.c"
			gint _tmp32_ = 0;
			gint _tmp38_ = 0;
			gchar* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gint _tmp45_ = 0;
			BitwiseFunc _tmp46_ = NULL;
			void* _tmp46__target = NULL;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gchar _tmp50_ = '\0';
			gchar _tmp51_ = '\0';
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp29_) {
#line 17202 "number.c"
				gint _tmp30_ = 0;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = offset_out;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				offset_out = _tmp30_ - 1;
#line 17208 "number.c"
			}
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = FALSE;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = offset_out;
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!(_tmp31_ >= 0)) {
#line 2991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 17218 "number.c"
			}
#line 2993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			v1 = 0;
#line 2993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			v2 = 0;
#line 2996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp32_ = offset1;
#line 2996 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp32_ >= 0) {
#line 17228 "number.c"
				const gchar* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gchar _tmp35_ = '\0';
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
#line 2998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp33_ = text1;
#line 2998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp34_ = offset1;
#line 2998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
#line 2998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp36_ = number_hex_to_int (self, _tmp35_);
#line 2998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				v1 = _tmp36_;
#line 2999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = offset1;
#line 2999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				offset1 = _tmp37_ - 1;
#line 17248 "number.c"
			}
#line 3001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp38_ = offset2;
#line 3001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp38_ >= 0) {
#line 17254 "number.c"
				const gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gchar _tmp41_ = '\0';
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
#line 3003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = text2;
#line 3003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = offset2;
#line 3003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
#line 3003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp42_ = number_hex_to_int (self, _tmp41_);
#line 3003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				v2 = _tmp42_;
#line 3004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp43_ = offset2;
#line 3004 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				offset2 = _tmp43_ - 1;
#line 17274 "number.c"
			}
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp44_ = text_out;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp44__length1 = text_out_length1;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp45_ = offset_out;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp46_ = bitwise_operator;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp46__target = bitwise_operator_target;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp47_ = v1;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp48_ = v2;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp49_ = _tmp46_ (_tmp47_, _tmp48_, _tmp46__target);
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp50_ = digits[_tmp49_];
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp44_[_tmp45_] = _tmp50_;
#line 3006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp51_ = _tmp44_[_tmp45_];
#line 17298 "number.c"
		}
	}
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52_ = text_out;
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52__length1 = text_out_length1;
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = mp_set_from_string ((const gchar*) _tmp52_, 16);
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp53_;
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text_out = (g_free (text_out), NULL);
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (text2);
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (text1);
#line 3009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 17317 "number.c"
}


static gint number_hex_to_int (Number* self, gchar digit) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp4_ = FALSE;
	gchar _tmp5_ = '\0';
	gboolean _tmp8_ = FALSE;
	gchar _tmp9_ = '\0';
#line 3012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 3014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = digit;
#line 3014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ >= '0') {
#line 17335 "number.c"
		gchar _tmp2_ = '\0';
#line 3014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = digit;
#line 3014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ <= '9';
#line 17341 "number.c"
	} else {
#line 3014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 17345 "number.c"
	}
#line 3014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 17349 "number.c"
		gchar _tmp3_ = '\0';
#line 3015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = digit;
#line 3015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (gint) (_tmp3_ - '0');
#line 3015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 17357 "number.c"
	}
#line 3016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = digit;
#line 3016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_ >= 'A') {
#line 17363 "number.c"
		gchar _tmp6_ = '\0';
#line 3016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = digit;
#line 3016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _tmp6_ <= 'F';
#line 17369 "number.c"
	} else {
#line 3016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = FALSE;
#line 17373 "number.c"
	}
#line 3016 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 17377 "number.c"
		gchar _tmp7_ = '\0';
#line 3017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = digit;
#line 3017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (_tmp7_ - 'A') + 10;
#line 3017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 17385 "number.c"
	}
#line 3018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = digit;
#line 3018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_ >= 'a') {
#line 17391 "number.c"
		gchar _tmp10_ = '\0';
#line 3018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = digit;
#line 3018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _tmp10_ <= 'f';
#line 17397 "number.c"
	} else {
#line 3018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = FALSE;
#line 17401 "number.c"
	}
#line 3018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp8_) {
#line 17405 "number.c"
		gchar _tmp11_ = '\0';
#line 3019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = digit;
#line 3019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (_tmp11_ - 'a') + 10;
#line 3019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 17413 "number.c"
	}
#line 3020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = 0;
#line 3020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 17419 "number.c"
}


static gchar* number_to_hex_string (Number* self) {
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 3023 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 3025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
#line 3025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	serializer = _tmp0_;
#line 3026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = serializer_to_string (serializer, self);
#line 3026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 3026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (serializer);
#line 3026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 17442 "number.c"
}


Number* number_construct (GType object_type) {
	Number * self = NULL;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 17452 "number.c"
}


Number* number_new (void) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct (TYPE_NUMBER);
#line 17459 "number.c"
}


static void number_class_init (NumberClass * klass) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_parent_class = g_type_class_peek_parent (klass);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
#line 17468 "number.c"
}


static void number_instance_init (Number * self) {
}


static void number_finalize (GObject* obj) {
	Number * self;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
#line 17482 "number.c"
}


GType number_get_type (void) {
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


void mperr (const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 3039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_if_fail (text != NULL);
#line 3041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = text;
#line 3041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 3041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (mp_error);
#line 3041 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_error = _tmp1_;
#line 17511 "number.c"
}


gchar* mp_get_error (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 3048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = mp_error;
#line 3048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 3048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 3048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 17527 "number.c"
}


void mp_clear_error (void) {
#line 3054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (mp_error);
#line 3054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mp_error = NULL;
#line 17536 "number.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 17561 "number.c"
		gchar* _tmp4_ = NULL;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 17569 "number.c"
	} else {
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 17575 "number.c"
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 17598 "number.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 17613 "number.c"
		}
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 17617 "number.c"
	} else {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 17625 "number.c"
		}
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 17629 "number.c"
	}
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (c) {
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 17635 "number.c"
	}
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1055 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1055 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (0 < _tmp0_) {
#line 17650 "number.c"
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = *index;
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp2_ - ((gchar*) self));
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_vala_c = _tmp4_;
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 17673 "number.c"
		}
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 17677 "number.c"
	} else {
#line 1060 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 17687 "number.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 17691 "number.c"
	}
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (c) {
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 17697 "number.c"
	}
}


Number* mp_set_from_string (const gchar* str, gint default_base) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 3064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gunichar base_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
#line 17708 "number.c"
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp7_ = 0;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp24_ = 0;
	gboolean negate = FALSE;
	const gchar* _tmp26_ = NULL;
	gunichar _tmp27_ = 0U;
	gunichar _tmp28_ = 0U;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
#line 3120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gunichar fractions[] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
#line 3121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gint numerators[] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
#line 3122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gint denominators[] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
#line 17728 "number.c"
	gboolean has_fraction = FALSE;
	const gchar* _tmp54_ = NULL;
	gunichar _tmp55_ = 0U;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gboolean _tmp108_ = FALSE;
#line 3058 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 3060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = str;
#line 3060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
#line 3060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ >= 0) {
#line 17745 "number.c"
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
#line 3061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = str;
#line 3061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = set_from_sexagesimal (_tmp2_);
#line 3061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 3061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 17756 "number.c"
	}
#line 3065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	index = 0;
#line 3067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 17762 "number.c"
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
#line 3067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = str;
#line 3067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
#line 3067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp5_;
#line 3067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp6_) {
#line 3067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 17776 "number.c"
		}
	}
#line 3068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = index;
#line 3068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	end = _tmp7_;
#line 3069 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_base = 0;
#line 3070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	base_multiplier = 1;
#line 3071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 17789 "number.c"
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gint value = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 3071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = str;
#line 3071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
#line 3071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp9_;
#line 3071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp10_) {
#line 3071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 17810 "number.c"
		}
#line 3073 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		value = -1;
#line 17814 "number.c"
		{
			gint i = 0;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 17819 "number.c"
			{
				gboolean _tmp11_ = FALSE;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = TRUE;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 17826 "number.c"
					gint _tmp13_ = 0;
					gunichar _tmp14_ = 0U;
					gint _tmp15_ = 0;
					gunichar _tmp16_ = 0U;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp11_) {
#line 17833 "number.c"
						gint _tmp12_ = 0;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp12_ = i;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp12_ + 1;
#line 17839 "number.c"
					}
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = FALSE;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = i;
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp13_ < G_N_ELEMENTS (base_digits))) {
#line 3074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 17849 "number.c"
					}
#line 3076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp14_ = c;
#line 3076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = i;
#line 3076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = base_digits[_tmp15_];
#line 3076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp14_ == _tmp16_) {
#line 17859 "number.c"
						gint _tmp17_ = 0;
#line 3078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp17_ = i;
#line 3078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						value = _tmp17_;
#line 3079 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 17867 "number.c"
					}
				}
			}
		}
#line 3082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = value;
#line 3082 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp18_ < 0) {
#line 3083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 17878 "number.c"
		}
#line 3085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = index;
#line 3085 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		end = _tmp19_;
#line 3086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_base;
#line 3086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = value;
#line 3086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = base_multiplier;
#line 3086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_base = _tmp20_ + (_tmp21_ * _tmp22_);
#line 3087 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = base_multiplier;
#line 3087 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_multiplier = _tmp23_ * 10;
#line 17896 "number.c"
	}
#line 3089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = base_multiplier;
#line 3089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp24_ == 1) {
#line 17902 "number.c"
		gint _tmp25_ = 0;
#line 3090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = default_base;
#line 3090 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_base = _tmp25_;
#line 17908 "number.c"
	}
#line 3093 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	negate = FALSE;
#line 3094 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	index = 0;
#line 3095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = str;
#line 3095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp26_, &index, &_tmp27_);
#line 3095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp27_;
#line 3096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = c;
#line 3096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp28_ == ((gunichar) '+')) {
#line 3097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		negate = FALSE;
#line 17926 "number.c"
	} else {
		gboolean _tmp29_ = FALSE;
		gunichar _tmp30_ = 0U;
#line 3098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = c;
#line 3098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp30_ == ((gunichar) '-')) {
#line 3098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = TRUE;
#line 17936 "number.c"
		} else {
			gunichar _tmp31_ = 0U;
#line 3098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = c;
#line 3098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = _tmp31_ == 8722U;
#line 17943 "number.c"
		}
#line 3098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp29_) {
#line 3099 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			negate = TRUE;
#line 17949 "number.c"
		} else {
			const gchar* _tmp32_ = NULL;
			gunichar _tmp33_ = 0U;
#line 3101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp32_ = str;
#line 3101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			string_get_prev_char (_tmp32_, &index, &_tmp33_);
#line 3101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp33_;
#line 17959 "number.c"
		}
	}
#line 3104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_new_integer ((gint64) 0);
#line 3104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp34_;
#line 3105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 17968 "number.c"
		const gchar* _tmp35_ = NULL;
		gunichar _tmp36_ = 0U;
		gboolean _tmp37_ = FALSE;
		gint i = 0;
		gunichar _tmp38_ = 0U;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
#line 3105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = str;
#line 3105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = string_get_next_char (_tmp35_, &index, &_tmp36_);
#line 3105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp36_;
#line 3105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp37_) {
#line 3105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 17997 "number.c"
		}
#line 3107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = c;
#line 3107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = number_base;
#line 3107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = char_val (_tmp38_, _tmp39_);
#line 3107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp40_;
#line 3108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = i;
#line 3108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = number_base;
#line 3108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp41_ > _tmp42_) {
#line 3109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = NULL;
#line 3109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 3109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 18019 "number.c"
		}
#line 3110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = i;
#line 3110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp43_ < 0) {
#line 18025 "number.c"
			const gchar* _tmp44_ = NULL;
			gunichar _tmp45_ = 0U;
#line 3112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp44_ = str;
#line 3112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			string_get_prev_char (_tmp44_, &index, &_tmp45_);
#line 3112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp45_;
#line 3113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 18036 "number.c"
		}
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = z;
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = number_base;
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp48_ = number_multiply_integer (_tmp46_, (gint64) _tmp47_);
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49_ = _tmp48_;
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = i;
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp51_ = number_new_integer ((gint64) _tmp50_);
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp52_ = _tmp51_;
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp53_ = number_add (_tmp49_, _tmp52_);
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp53_;
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp52_);
#line 3116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp49_);
#line 18062 "number.c"
	}
#line 3123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	has_fraction = FALSE;
#line 3124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = str;
#line 3124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = string_get_next_char (_tmp54_, &index, &_tmp55_);
#line 3124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp55_;
#line 3124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp56_) {
#line 18074 "number.c"
		gunichar _tmp74_ = 0U;
		{
			gint i = 0;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 18080 "number.c"
			{
				gboolean _tmp57_ = FALSE;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp57_ = TRUE;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 18087 "number.c"
					gint _tmp59_ = 0;
					gunichar _tmp60_ = 0U;
					gint _tmp61_ = 0;
					gunichar _tmp62_ = 0U;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp57_) {
#line 18094 "number.c"
						gint _tmp58_ = 0;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp58_ = i;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp58_ + 1;
#line 18100 "number.c"
					}
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp57_ = FALSE;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp59_ = i;
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp59_ < G_N_ELEMENTS (fractions))) {
#line 3126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 18110 "number.c"
					}
#line 3128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp60_ = c;
#line 3128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp61_ = i;
#line 3128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp62_ = fractions[_tmp61_];
#line 3128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp60_ == _tmp62_) {
#line 18120 "number.c"
						Number* fraction = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
						Number* _tmp67_ = NULL;
						Number* _tmp68_ = NULL;
						Number* _tmp69_ = NULL;
						Number* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gunichar _tmp72_ = 0U;
						gboolean _tmp73_ = FALSE;
#line 3130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp63_ = i;
#line 3130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp64_ = numerators[_tmp63_];
#line 3130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp65_ = i;
#line 3130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp66_ = denominators[_tmp65_];
#line 3130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp67_ = number_new_fraction ((gint64) _tmp64_, (gint64) _tmp66_);
#line 3130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						fraction = _tmp67_;
#line 3131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp68_ = z;
#line 3131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp69_ = fraction;
#line 3131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp70_ = number_add (_tmp68_, _tmp69_);
#line 3131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 3131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						z = _tmp70_;
#line 3134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp71_ = str;
#line 3134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp73_ = string_get_next_char (_tmp71_, &index, &_tmp72_);
#line 3134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						c = _tmp72_;
#line 3134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp73_) {
#line 3135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							result = z;
#line 3135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (fraction);
#line 3135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							return result;
#line 18169 "number.c"
						} else {
#line 3137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							result = NULL;
#line 3137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (fraction);
#line 3137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (z);
#line 3137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							return result;
#line 18179 "number.c"
						}
#line 3128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (fraction);
#line 18183 "number.c"
					}
				}
			}
		}
#line 3142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp74_ = c;
#line 3142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp74_ == ((gunichar) '.')) {
#line 3143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			has_fraction = TRUE;
#line 18194 "number.c"
		} else {
			const gchar* _tmp75_ = NULL;
			gunichar _tmp76_ = 0U;
#line 3145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp75_ = str;
#line 3145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			string_get_prev_char (_tmp75_, &index, &_tmp76_);
#line 3145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp76_;
#line 18204 "number.c"
		}
	}
#line 3149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp77_ = has_fraction;
#line 3149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp77_) {
#line 18211 "number.c"
		Number* numerator = NULL;
		Number* _tmp78_ = NULL;
		Number* denominator = NULL;
		Number* _tmp79_ = NULL;
		Number* _tmp100_ = NULL;
		Number* _tmp101_ = NULL;
		Number* _tmp102_ = NULL;
		Number* _tmp103_ = NULL;
		Number* _tmp104_ = NULL;
		Number* _tmp105_ = NULL;
#line 3151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp78_ = number_new_integer ((gint64) 0);
#line 3151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		numerator = _tmp78_;
#line 3152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp79_ = number_new_integer ((gint64) 1);
#line 3152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		denominator = _tmp79_;
#line 3154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 18232 "number.c"
			const gchar* _tmp80_ = NULL;
			gunichar _tmp81_ = 0U;
			gboolean _tmp82_ = FALSE;
			gint i = 0;
			gunichar _tmp83_ = 0U;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			Number* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			Number* _tmp91_ = NULL;
			Number* _tmp92_ = NULL;
			gint _tmp93_ = 0;
			Number* _tmp94_ = NULL;
			Number* _tmp95_ = NULL;
			gint _tmp96_ = 0;
			Number* _tmp97_ = NULL;
			Number* _tmp98_ = NULL;
			Number* _tmp99_ = NULL;
#line 3154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp80_ = str;
#line 3154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp82_ = string_get_next_char (_tmp80_, &index, &_tmp81_);
#line 3154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp81_;
#line 3154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp82_) {
#line 3154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 18262 "number.c"
			}
#line 3156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp83_ = c;
#line 3156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp84_ = number_base;
#line 3156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp85_ = char_val (_tmp83_, _tmp84_);
#line 3156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = _tmp85_;
#line 3157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp86_ = i;
#line 3157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp86_ < 0) {
#line 18276 "number.c"
				const gchar* _tmp87_ = NULL;
				gunichar _tmp88_ = 0U;
#line 3159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp87_ = str;
#line 3159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				string_get_prev_char (_tmp87_, &index, &_tmp88_);
#line 3159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = _tmp88_;
#line 3160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 18287 "number.c"
			}
#line 3163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp89_ = denominator;
#line 3163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp90_ = number_base;
#line 3163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp91_ = number_multiply_integer (_tmp89_, (gint64) _tmp90_);
#line 3163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (denominator);
#line 3163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			denominator = _tmp91_;
#line 3164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp92_ = numerator;
#line 3164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp93_ = number_base;
#line 3164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp94_ = number_multiply_integer (_tmp92_, (gint64) _tmp93_);
#line 3164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (numerator);
#line 3164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			numerator = _tmp94_;
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp95_ = numerator;
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp96_ = i;
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp97_ = number_new_integer ((gint64) _tmp96_);
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp98_ = _tmp97_;
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp99_ = number_add (_tmp95_, _tmp98_);
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (numerator);
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			numerator = _tmp99_;
#line 3165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp98_);
#line 18325 "number.c"
		}
#line 3168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp100_ = numerator;
#line 3168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp101_ = denominator;
#line 3168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp102_ = number_divide (_tmp100_, _tmp101_);
#line 3168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (numerator);
#line 3168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		numerator = _tmp102_;
#line 3169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp103_ = z;
#line 3169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp104_ = numerator;
#line 3169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp105_ = number_add (_tmp103_, _tmp104_);
#line 3169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 3169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp105_;
#line 3149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (denominator);
#line 3149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (numerator);
#line 18351 "number.c"
	}
#line 3172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp106_ = index;
#line 3172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp107_ = end;
#line 3172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp106_ != _tmp107_) {
#line 3173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 3173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18365 "number.c"
	}
#line 3175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp108_ = negate;
#line 3175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp108_) {
#line 18371 "number.c"
		Number* _tmp109_ = NULL;
		Number* _tmp110_ = NULL;
#line 3176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp109_ = z;
#line 3176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp110_ = number_invert_sign (_tmp109_);
#line 3176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 3176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp110_;
#line 18382 "number.c"
	}
#line 3178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 3178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 18388 "number.c"
}


gint char_val (gunichar c, gint number_base) {
	gint result = 0;
	gunichar _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gint value = 0;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 3183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = c;
#line 3183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = g_unichar_isxdigit (_tmp0_);
#line 3183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 3184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = -1;
#line 3184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18411 "number.c"
	}
#line 3186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = c;
#line 3186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = g_unichar_xdigit_value (_tmp2_);
#line 3186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	value = _tmp3_;
#line 3188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = value;
#line 3188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_base;
#line 3188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ >= _tmp5_) {
#line 3189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = -1;
#line 3189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18429 "number.c"
	}
#line 3191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = value;
#line 3191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 18435 "number.c"
}


Number* set_from_sexagesimal (const gchar* str) {
	Number* result = NULL;
	gint degree_index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Number* degrees = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint minute_start = 0;
	gint _tmp10_ = 0;
	gunichar c = 0U;
	const gchar* _tmp11_ = NULL;
	gunichar _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	gint minute_index = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Number* minutes = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	Number* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	gint second_start = 0;
	gint _tmp34_ = 0;
	const gchar* _tmp35_ = NULL;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar _tmp39_ = '\0';
	gint second_index = 0;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	Number* seconds = NULL;
	const gchar* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	Number* _tmp50_ = NULL;
	Number* _tmp51_ = NULL;
	Number* _tmp52_ = NULL;
	Number* _tmp53_ = NULL;
	Number* _tmp54_ = NULL;
	Number* _tmp55_ = NULL;
	Number* _tmp56_ = NULL;
	Number* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	gunichar _tmp59_ = 0U;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gchar _tmp62_ = '\0';
#line 3194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 3196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = str;
#line 3196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
#line 3196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degree_index = _tmp1_;
#line 3197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = degree_index;
#line 3197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ < 0) {
#line 3198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18529 "number.c"
	}
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = str;
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = degree_index;
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) _tmp4_);
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = mp_set_from_string (_tmp6_, 10);
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp6_);
#line 3199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degrees = _tmp8_;
#line 3200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = degrees;
#line 3200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_ == NULL) {
#line 3201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 3201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18557 "number.c"
	}
#line 3202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = degree_index;
#line 3202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	minute_start = _tmp10_;
#line 3204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = str;
#line 3204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp11_, &minute_start, &_tmp12_);
#line 3204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp12_;
#line 3206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = str;
#line 3206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = minute_start;
#line 3206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 3206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp15_ == '\0') {
#line 3207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = degrees;
#line 3207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18581 "number.c"
	}
#line 3208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = str;
#line 3208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = minute_start;
#line 3208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = string_index_of_char (_tmp16_, (gunichar) '\'', _tmp17_);
#line 3208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	minute_index = _tmp18_;
#line 3209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = minute_index;
#line 3209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp19_ < 0) {
#line 3210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 3210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18601 "number.c"
	}
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = str;
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = minute_start;
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = minute_index;
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = minute_start;
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = _tmp24_;
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = mp_set_from_string (_tmp25_, 10);
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = _tmp26_;
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp25_);
#line 3211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	minutes = _tmp27_;
#line 3212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = minutes;
#line 3212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp28_ == NULL) {
#line 3213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 3213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 3213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18635 "number.c"
	}
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp29_ = degrees;
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = minutes;
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 60);
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = _tmp31_;
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = number_add (_tmp29_, _tmp32_);
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (degrees);
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degrees = _tmp33_;
#line 3214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp32_);
#line 3215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = minute_index;
#line 3215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	second_start = _tmp34_;
#line 3216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = str;
#line 3216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
#line 3216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp36_;
#line 3218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = str;
#line 3218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = second_start;
#line 3218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
#line 3218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp39_ == '\0') {
#line 3219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = degrees;
#line 3219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 3219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18677 "number.c"
	}
#line 3220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp40_ = str;
#line 3220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = second_start;
#line 3220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp42_ = string_index_of_char (_tmp40_, (gunichar) '"', _tmp41_);
#line 3220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	second_index = _tmp42_;
#line 3221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = second_index;
#line 3221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp43_ < 0) {
#line 3222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 3222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 3222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18699 "number.c"
	}
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp44_ = str;
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp45_ = second_start;
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp46_ = second_index;
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp47_ = second_start;
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp48_ = string_substring (_tmp44_, (glong) _tmp45_, (glong) (_tmp46_ - _tmp47_));
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp49_ = _tmp48_;
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp50_ = mp_set_from_string (_tmp49_, 10);
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp51_ = _tmp50_;
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp49_);
#line 3223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	seconds = _tmp51_;
#line 3224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52_ = seconds;
#line 3224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp52_ == NULL) {
#line 3225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (seconds);
#line 3225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 3225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 3225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18735 "number.c"
	}
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = degrees;
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = seconds;
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp55_ = number_divide_integer (_tmp54_, (gint64) 3600);
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = _tmp55_;
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_ = number_add (_tmp53_, _tmp56_);
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (degrees);
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degrees = _tmp57_;
#line 3226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp56_);
#line 3227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp58_ = str;
#line 3227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp58_, &second_index, &_tmp59_);
#line 3227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp59_;
#line 3230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp60_ = str;
#line 3230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp61_ = second_index;
#line 3230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp62_ = string_get (_tmp60_, (glong) _tmp61_);
#line 3230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp62_ == '\0') {
#line 3231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = degrees;
#line 3231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (seconds);
#line 3231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 3231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18775 "number.c"
	} else {
#line 3233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 3233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (seconds);
#line 3233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 3233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 3233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 18787 "number.c"
	}
#line 3194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (seconds);
#line 3194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (minutes);
#line 3194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (degrees);
#line 18795 "number.c"
}


void mp_gcd (gint64* k, gint64* l) {
	gint64 i = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 j = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp17_ = 0LL;
	gint64 _tmp18_ = 0LL;
	gint64 _tmp19_ = 0LL;
	gint64 _tmp20_ = 0LL;
#line 3242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = *k;
#line 3242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = llabs (_tmp0_);
#line 3242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	i = _tmp1_;
#line 3243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = *l;
#line 3243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = llabs (_tmp2_);
#line 3243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	j = _tmp3_;
#line 3244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = j;
#line 3244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ == ((gint64) 0)) {
#line 18827 "number.c"
		gint64 _tmp5_ = 0LL;
#line 3247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		*k = (gint64) 1;
#line 3248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		*l = (gint64) 0;
#line 3249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = i;
#line 3249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp5_ == ((gint64) 0)) {
#line 3250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			*k = (gint64) 0;
#line 18839 "number.c"
		}
#line 3251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return;
#line 18843 "number.c"
	}
	{
		gboolean _tmp6_ = FALSE;
#line 3255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = TRUE;
#line 3255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 18851 "number.c"
			gint64 _tmp8_ = 0LL;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			gint64 _tmp15_ = 0LL;
			gint64 _tmp16_ = 0LL;
#line 3255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp6_) {
#line 18859 "number.c"
				gint64 _tmp7_ = 0LL;
#line 3265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = j;
#line 3265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp7_ != ((gint64) 0))) {
#line 3265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 18867 "number.c"
				}
			}
#line 3255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = FALSE;
#line 3257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = i;
#line 3257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = j;
#line 3257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = _tmp8_ % _tmp9_;
#line 3258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = i;
#line 3258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp10_ == ((gint64) 0)) {
#line 18882 "number.c"
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				gint64 _tmp14_ = 0LL;
#line 3260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = *k;
#line 3260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp12_ = j;
#line 3260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				*k = _tmp11_ / _tmp12_;
#line 3261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = *l;
#line 3261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp14_ = j;
#line 3261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				*l = _tmp13_ / _tmp14_;
#line 3262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				return;
#line 18901 "number.c"
			}
#line 3264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = j;
#line 3264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp16_ = i;
#line 3264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			j = _tmp15_ % _tmp16_;
#line 18909 "number.c"
		}
	}
#line 3268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = *k;
#line 3268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = i;
#line 3268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	*k = _tmp17_ / _tmp18_;
#line 3269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = *l;
#line 3269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = i;
#line 3269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	*l = _tmp19_ / _tmp20_;
#line 18924 "number.c"
}


void mp_normalize (Number** x) {
	gint start_index = 0;
	gint _tmp7_ = 0;
	gint _tmp10_ = 0;
#line 3276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_if_fail (*x != NULL);
#line 18934 "number.c"
	{
		gboolean _tmp0_ = FALSE;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		start_index = 0;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 18943 "number.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp0_) {
#line 18948 "number.c"
				gint _tmp1_ = 0;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp1_ = start_index;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				start_index = _tmp1_ + 1;
#line 18954 "number.c"
			}
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp0_ = FALSE;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = start_index;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp3_ < SIZE) {
#line 18962 "number.c"
				Number* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp4_ = *x;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = start_index;
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = _tmp4_->re_fraction[_tmp5_];
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp2_ = _tmp6_ == 0;
#line 18974 "number.c"
			} else {
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp2_ = FALSE;
#line 18978 "number.c"
			}
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp2_) {
#line 3281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 18984 "number.c"
			}
		}
	}
#line 3284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = start_index;
#line 3284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_ >= SIZE) {
#line 18992 "number.c"
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 3286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = *x;
#line 3286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_->re_sign = 0;
#line 3287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = *x;
#line 3287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_->re_exponent = 0;
#line 3288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return;
#line 19005 "number.c"
	}
#line 3292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = start_index;
#line 3292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_ > 0) {
#line 19011 "number.c"
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint i = 0;
#line 3294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = *x;
#line 3294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = *x;
#line 3294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = _tmp12_->re_exponent;
#line 3294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = start_index;
#line 3294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_->re_exponent = _tmp13_ - _tmp14_;
#line 3295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 0;
#line 19029 "number.c"
		{
			gboolean _tmp15_ = FALSE;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = TRUE;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 19036 "number.c"
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				Number* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				Number* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp15_) {
#line 19048 "number.c"
					gint _tmp16_ = 0;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = i;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp16_ + 1;
#line 19054 "number.c"
				}
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp15_ = FALSE;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp17_ = i;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp18_ = start_index;
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!((_tmp17_ + _tmp18_) < SIZE)) {
#line 3296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 19066 "number.c"
				}
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = *x;
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = i;
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = *x;
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = i;
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp23_ = start_index;
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = _tmp21_->re_fraction[_tmp22_ + _tmp23_];
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_->re_fraction[_tmp20_] = _tmp24_;
#line 3297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = _tmp19_->re_fraction[_tmp20_];
#line 19084 "number.c"
			}
		}
		{
			gboolean _tmp26_ = FALSE;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = TRUE;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 19093 "number.c"
				gint _tmp28_ = 0;
				Number* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp26_) {
#line 19100 "number.c"
					gint _tmp27_ = 0;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp27_ = i;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp27_ + 1;
#line 19106 "number.c"
				}
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = FALSE;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = i;
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp28_ < SIZE)) {
#line 3298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 19116 "number.c"
				}
#line 3299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_ = *x;
#line 3299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = i;
#line 3299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_->re_fraction[_tmp30_] = 0;
#line 3299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = _tmp29_->re_fraction[_tmp30_];
#line 19126 "number.c"
			}
		}
	}
}


gboolean mp_is_overflow (Number* x, gint wordlen) {
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 3304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (x != NULL, FALSE);
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 2);
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = wordlen;
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_xpowy_integer (_tmp1_, (gint64) _tmp2_);
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 3306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp4_;
#line 3307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = x;
#line 3307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_compare (t2, _tmp5_);
#line 3307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_ > 0;
#line 3307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 3307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 19169 "number.c"
}



