/* math-display.c generated by valac 0.22.1, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <pango/pango.h>
#include <atk/atk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;

#define TYPE_MATH_VARIABLES (math_variables_get_type ())
#define MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLES, MathVariables))
#define MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLES, MathVariablesClass))
#define IS_MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLES))
#define IS_MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLES))
#define MATH_VARIABLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLES, MathVariablesClass))

typedef struct _MathVariables MathVariables;
typedef struct _MathVariablesClass MathVariablesClass;

#define TYPE_NUMBER_MODE (number_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;

#define TYPE_FUNCTION_MANAGER (function_manager_get_type ())
#define FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_MANAGER, FunctionManager))
#define FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_MANAGER, FunctionManagerClass))
#define IS_FUNCTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_MANAGER))
#define IS_FUNCTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_MANAGER))
#define FUNCTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_MANAGER, FunctionManagerClass))

typedef struct _FunctionManager FunctionManager;
typedef struct _FunctionManagerClass FunctionManagerClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))

struct _MathDisplay {
	GtkViewport parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkViewportClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	GtkSourceView* source_view;
	GtkTextBuffer* info_buffer;
	GtkSpinner* spinner;
};

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_name) (CompletionProvider* self);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	gboolean (*activate_proposal) (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
	void (*populate) (CompletionProvider* self, GtkSourceCompletionContext* context);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};


static gpointer math_display_parent_class = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface* completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static gpointer variable_completion_provider_parent_class = NULL;

GType math_display_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
#define MATH_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_DISPLAY, MathDisplayPrivate))
enum  {
	MATH_DISPLAY_DUMMY_PROPERTY,
	MATH_DISPLAY_EQUATION
};
MathDisplay* math_display_new (MathEquation* equation);
MathDisplay* math_display_construct (GType object_type, MathEquation* equation);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event);
static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void math_display_create_autocompletion (MathDisplay* self);
static void __lambda9_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda10_ (MathDisplay* self, GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
FunctionCompletionProvider* function_completion_provider_new (void);
FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
GType completion_provider_get_type (void) G_GNUC_CONST;
GType function_completion_provider_get_type (void) G_GNUC_CONST;
MathEquation* math_display_get_equation (MathDisplay* self);
VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation);
GType variable_completion_provider_get_type (void) G_GNUC_CONST;
static gboolean math_display_function_completion_window_visible (MathDisplay* self);
GType math_function_get_type (void) G_GNUC_CONST;
MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1);
GType math_variables_get_type (void) G_GNUC_CONST;
gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1);
MathVariables* math_equation_get_variables (MathEquation* self);
static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event);
void math_equation_solve (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert (MathEquation* self, const gchar* text);
void math_equation_insert_subtract (MathEquation* self);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_factorize (MathEquation* self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
gchar* math_equation_get_status (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
guint math_equation_get_error_token_start (MathEquation* self);
static void math_display_finalize (GObject* obj);
static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
gchar* completion_provider_get_name (CompletionProvider* self);
static gchar* completion_provider_real_get_name (CompletionProvider* self);
void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context);
CompletionProvider* completion_provider_new (void);
CompletionProvider* completion_provider_construct (GType object_type);
enum  {
	FUNCTION_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* function_completion_provider_real_get_name (CompletionProvider* base);
GType function_manager_get_type (void) G_GNUC_CONST;
FunctionManager* function_manager_get_default_function_manager (void);
MathFunction** function_manager_functions_eligible_for_autocompletion_for_text (FunctionManager* self, const gchar* display_text, int* result_length1);
static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
const gchar* math_function_get_name (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self, int* result_length1);
const gchar* math_function_get_description (MathFunction* self);
gboolean math_function_is_custom_function (MathFunction* self);
const gchar* math_function_get_expression (MathFunction* self);
#define VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderPrivate))
enum  {
	VARIABLE_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static gchar* variable_completion_provider_real_get_name (CompletionProvider* base);
gchar** math_variables_variables_eligible_for_autocompletion (MathVariables* self, const gchar* text, int* result_length1);
static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* math_equation_get_serializer (MathEquation* self);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self, Number* x);
Number* math_variables_get (MathVariables* self, const gchar* name);
static void variable_completion_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self) {
	return g_boxed_copy (pango_font_description_get_type (), self);
}


static gpointer __vala_PangoFontDescription_copy0 (gpointer self) {
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}


static gboolean _math_display_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = math_display_key_press_cb (self, event);
	return result;
}


static void __lambda9_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}


static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda9_ (self, pspec);
}


static void __lambda10_ (MathDisplay* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}


static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda10_ (self, pspec);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


MathDisplay* math_display_construct (GType object_type, MathEquation* equation) {
	MathDisplay * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	GtkBox* main_box = NULL;
	GtkBox* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	GtkSourceView* _tmp4_ = NULL;
	GtkSourceView* _tmp5_ = NULL;
	GtkSourceView* _tmp6_ = NULL;
	GtkSourceView* _tmp7_ = NULL;
	GtkSourceView* _tmp8_ = NULL;
	GtkSourceView* _tmp9_ = NULL;
	PangoFontDescription* font_desc = NULL;
	GtkSourceView* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	PangoFontDescription* _tmp12_ = NULL;
	PangoFontDescription* _tmp13_ = NULL;
	GtkSourceView* _tmp14_ = NULL;
	GtkSourceView* _tmp15_ = NULL;
	GtkSourceView* _tmp16_ = NULL;
	AtkObject* _tmp17_ = NULL;
	GtkSourceView* _tmp18_ = NULL;
	GtkSourceView* _tmp19_ = NULL;
	GtkBox* info_box = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp21_ = NULL;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkSpinner* _tmp24_ = NULL;
	GtkSpinner* _tmp25_ = NULL;
	GtkSourceView* _tmp26_ = NULL;
	MathEquation* _tmp27_ = NULL;
	MathEquation* _tmp28_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	main_box = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_box);
	_tmp3_ = equation;
	_tmp4_ = (GtkSourceView*) gtk_source_view_new_with_buffer ((GtkSourceBuffer*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp4_;
	_tmp5_ = self->priv->source_view;
	gtk_text_view_set_accepts_tab ((GtkTextView*) _tmp5_, FALSE);
	_tmp6_ = self->priv->source_view;
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) _tmp6_, 8);
	_tmp7_ = self->priv->source_view;
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp7_, 2);
	_tmp8_ = self->priv->source_view;
	gtk_text_view_set_justification ((GtkTextView*) _tmp8_, GTK_JUSTIFY_RIGHT);
	_tmp9_ = self->priv->source_view;
	gtk_widget_ensure_style ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->source_view;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	_tmp12_ = gtk_style_context_get_font (_tmp11_, GTK_STATE_FLAG_NORMAL);
	_tmp13_ = __vala_PangoFontDescription_copy0 (_tmp12_);
	font_desc = _tmp13_;
	pango_font_description_set_size (font_desc, 16 * PANGO_SCALE);
	_tmp14_ = self->priv->source_view;
	gtk_widget_override_font ((GtkWidget*) _tmp14_, font_desc);
	_tmp15_ = self->priv->source_view;
	gtk_buildable_set_name ((GtkBuildable*) _tmp15_, "displayitem");
	_tmp16_ = self->priv->source_view;
	_tmp17_ = gtk_widget_get_accessible ((GtkWidget*) _tmp16_);
	atk_object_set_role (_tmp17_, ATK_ROLE_EDITBAR);
	_tmp18_ = self->priv->source_view;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "key-press-event", (GCallback) _math_display_key_press_cb_gtk_widget_key_press_event, self, 0);
	math_display_create_autocompletion (self);
	_tmp19_ = self->priv->source_view;
	gtk_box_pack_start (main_box, (GtkWidget*) _tmp19_, TRUE, TRUE, (guint) 0);
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp20_);
	info_box = _tmp20_;
	gtk_box_pack_start (main_box, (GtkWidget*) info_box, FALSE, TRUE, (guint) 0);
	_tmp21_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp21_);
	info_view = _tmp21_;
	gtk_text_view_set_wrap_mode (info_view, GTK_WRAP_WORD);
	gtk_widget_set_can_focus ((GtkWidget*) info_view, TRUE);
	gtk_text_view_set_cursor_visible (info_view, FALSE);
	gtk_text_view_set_editable (info_view, FALSE);
	gtk_text_view_set_justification (info_view, GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start (info_box, (GtkWidget*) info_view, TRUE, TRUE, (guint) 0);
	_tmp22_ = gtk_text_view_get_buffer (info_view);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp23_;
	_tmp24_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp24_;
	_tmp25_ = self->priv->spinner;
	gtk_box_pack_end (info_box, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) info_box);
	gtk_widget_show ((GtkWidget*) info_view);
	_tmp26_ = self->priv->source_view;
	gtk_widget_show ((GtkWidget*) _tmp26_);
	gtk_widget_show ((GtkWidget*) main_box);
	_tmp27_ = equation;
	g_signal_connect_object ((GObject*) _tmp27_, "notify::status", (GCallback) ___lambda9__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	_tmp28_ = equation;
	g_signal_connect_object ((GObject*) _tmp28_, "notify::error-token-end", (GCallback) ___lambda10__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (main_box);
	return self;
}


MathDisplay* math_display_new (MathEquation* equation) {
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}


static void math_display_create_autocompletion (MathDisplay* self) {
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GtkSourceCompletion* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	{
		GtkSourceCompletion* _tmp3_ = NULL;
		FunctionCompletionProvider* _tmp4_ = NULL;
		FunctionCompletionProvider* _tmp5_ = NULL;
		GtkSourceCompletion* _tmp6_ = NULL;
		MathEquation* _tmp7_ = NULL;
		MathEquation* _tmp8_ = NULL;
		VariableCompletionProvider* _tmp9_ = NULL;
		VariableCompletionProvider* _tmp10_ = NULL;
		_tmp3_ = completion;
		_tmp4_ = function_completion_provider_new ();
		_tmp5_ = _tmp4_;
		gtk_source_completion_add_provider (_tmp3_, (GtkSourceCompletionProvider*) _tmp5_, &_inner_error_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp6_ = completion;
		_tmp7_ = math_display_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = variable_completion_provider_new (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_source_completion_add_provider (_tmp6_, (GtkSourceCompletionProvider*) _tmp10_, &_inner_error_);
		_g_object_unref0 (_tmp10_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("math-display.vala:90: Could not add CompletionProvider to source-view");
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (completion);
}


static gboolean math_display_function_completion_window_visible (MathDisplay* self) {
	gboolean result = FALSE;
	GList* providers_list = NULL;
	GtkSourceView* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = gtk_source_completion_get_providers (_tmp1_);
	providers_list = _tmp2_;
	_tmp3_ = providers_list;
	_tmp4_ = g_list_length (_tmp3_);
	if (_tmp4_ > ((guint) 0)) {
		MathFunction** functions = NULL;
		MathEquation* _tmp5_ = NULL;
		MathEquation* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		MathFunction** _tmp8_ = NULL;
		gint functions_length1 = 0;
		gint _functions_size_ = 0;
		gchar** variables = NULL;
		MathEquation* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		MathEquation* _tmp11_ = NULL;
		MathEquation* _tmp12_ = NULL;
		MathVariables* _tmp13_ = NULL;
		MathVariables* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar** _tmp16_ = NULL;
		gint variables_length1 = 0;
		gint _variables_size_ = 0;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		MathFunction** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		_tmp5_ = math_display_get_equation (self);
		_tmp6_ = _tmp5_;
		_tmp8_ = function_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp6_, &_tmp7_);
		functions = _tmp8_;
		functions_length1 = _tmp7_;
		_functions_size_ = functions_length1;
		_tmp9_ = math_display_get_equation (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = math_display_get_equation (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = math_equation_get_variables (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp16_ = variable_completion_provider_get_matches_for_completion_at_cursor ((GtkTextBuffer*) _tmp10_, _tmp14_, &_tmp15_);
		variables = _tmp16_;
		variables_length1 = _tmp15_;
		_variables_size_ = variables_length1;
		_tmp19_ = functions;
		_tmp19__length1 = functions_length1;
		if (_tmp19__length1 > 0) {
			_tmp18_ = TRUE;
		} else {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			_tmp20_ = variables;
			_tmp20__length1 = variables_length1;
			_tmp18_ = _tmp20__length1 > 0;
		}
		_tmp21_ = _tmp18_;
		if (_tmp21_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = FALSE;
		}
		_tmp22_ = _tmp17_;
		result = _tmp22_;
		variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
		functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean math_display_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MathDisplay * self;
	gboolean result = FALSE;
	GtkSourceView* _tmp0_ = NULL;
	GdkEventKey _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	self = (MathDisplay*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = *event;
	g_signal_emit_by_name ((GtkWidget*) _tmp0_, "key-press-event", &_tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


static gboolean math_display_key_press_cb (MathDisplay* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint new_keyval = 0U;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GdkModifierType state = 0;
	GdkEventKey _tmp7_ = {0};
	GdkModifierType _tmp8_ = 0;
	guint32 c = 0U;
	GdkEventKey _tmp9_ = {0};
	guint _tmp10_ = 0U;
	guint32 _tmp11_ = 0U;
	gboolean _tmp12_ = FALSE;
	GdkEventKey _tmp13_ = {0};
	guint _tmp14_ = 0U;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GdkEventKey _tmp24_ = {0};
	guint _tmp25_ = 0U;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GdkEventKey _tmp42_ = {0};
	guint _tmp43_ = 0U;
	GdkModifierType _tmp46_ = 0;
	GdkModifierType _tmp56_ = 0;
	GdkModifierType _tmp79_ = 0;
	gboolean _tmp86_ = FALSE;
	GdkModifierType _tmp87_ = 0;
	gboolean _tmp92_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	new_keyval = (guint) 0;
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = (guint) GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = (guint) GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = (guint) GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = (guint) GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = (guint) GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = (guint) GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = (guint) GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = (guint) GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = (guint) GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = (guint) GDK_KEY_9;
			break;
		}
		default:
		break;
	}
	_tmp2_ = new_keyval;
	if (_tmp2_ != ((guint) 0)) {
		GdkEventKey new_event = {0};
		GdkEventKey _tmp3_ = {0};
		guint _tmp4_ = 0U;
		GdkEventKey _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		_tmp3_ = *event;
		new_event = _tmp3_;
		_tmp4_ = new_keyval;
		new_event.keyval = _tmp4_;
		_tmp5_ = new_event;
		g_signal_emit_by_name ((GtkWidget*) self, "key-press-event", &_tmp5_, &_tmp6_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = *event;
	_tmp8_ = _tmp7_.state;
	state = _tmp8_ & (GDK_CONTROL_MASK | GDK_MOD1_MASK);
	_tmp9_ = *event;
	_tmp10_ = _tmp9_.keyval;
	_tmp11_ = gdk_keyval_to_unicode (_tmp10_);
	c = _tmp11_;
	_tmp13_ = *event;
	_tmp14_ = _tmp13_.keyval;
	if (_tmp14_ == ((guint) GDK_KEY_Return)) {
		_tmp12_ = TRUE;
	} else {
		GdkEventKey _tmp15_ = {0};
		guint _tmp16_ = 0U;
		_tmp15_ = *event;
		_tmp16_ = _tmp15_.keyval;
		_tmp12_ = _tmp16_ == ((guint) GDK_KEY_KP_Enter);
	}
	_tmp17_ = _tmp12_;
	if (_tmp17_) {
		gboolean _tmp18_ = FALSE;
		MathEquation* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		_tmp18_ = math_display_function_completion_window_visible (self);
		if (_tmp18_) {
			result = FALSE;
			return result;
		}
		_tmp19_ = math_display_get_equation (self);
		_tmp20_ = _tmp19_;
		math_equation_solve (_tmp20_);
		result = TRUE;
		return result;
	}
	_tmp24_ = *event;
	_tmp25_ = _tmp24_.keyval;
	if (_tmp25_ == ((guint) GDK_KEY_Escape)) {
		GdkModifierType _tmp26_ = 0;
		_tmp26_ = state;
		_tmp23_ = _tmp26_ == 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp27_ = _tmp23_;
	if (_tmp27_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp28_ = FALSE;
		GdkEventKey _tmp29_ = {0};
		guint _tmp30_ = 0U;
		gboolean _tmp32_ = FALSE;
		_tmp29_ = *event;
		_tmp30_ = _tmp29_.keyval;
		if (_tmp30_ == ((guint) GDK_KEY_BackSpace)) {
			GdkModifierType _tmp31_ = 0;
			_tmp31_ = state;
			_tmp28_ = _tmp31_ == GDK_CONTROL_MASK;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp32_ = _tmp28_;
		_tmp22_ = _tmp32_;
	}
	_tmp33_ = _tmp22_;
	if (_tmp33_) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp34_ = FALSE;
		GdkEventKey _tmp35_ = {0};
		guint _tmp36_ = 0U;
		gboolean _tmp38_ = FALSE;
		_tmp35_ = *event;
		_tmp36_ = _tmp35_.keyval;
		if (_tmp36_ == ((guint) GDK_KEY_Delete)) {
			GdkModifierType _tmp37_ = 0;
			_tmp37_ = state;
			_tmp34_ = _tmp37_ == GDK_SHIFT_MASK;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp38_ = _tmp34_;
		_tmp21_ = _tmp38_;
	}
	_tmp39_ = _tmp21_;
	if (_tmp39_) {
		MathEquation* _tmp40_ = NULL;
		MathEquation* _tmp41_ = NULL;
		_tmp40_ = math_display_get_equation (self);
		_tmp41_ = _tmp40_;
		math_equation_clear (_tmp41_);
		result = TRUE;
		return result;
	}
	_tmp42_ = *event;
	_tmp43_ = _tmp42_.keyval;
	if (_tmp43_ == ((guint) GDK_KEY_KP_Decimal)) {
		MathEquation* _tmp44_ = NULL;
		MathEquation* _tmp45_ = NULL;
		_tmp44_ = math_display_get_equation (self);
		_tmp45_ = _tmp44_;
		math_equation_insert_numeric_point (_tmp45_);
		result = TRUE;
		return result;
	}
	_tmp46_ = state;
	if (_tmp46_ == 0) {
		guint32 _tmp47_ = 0U;
		guint32 _tmp50_ = 0U;
		guint32 _tmp53_ = 0U;
		_tmp47_ = c;
		if (_tmp47_ == ((guint32) '*')) {
			MathEquation* _tmp48_ = NULL;
			MathEquation* _tmp49_ = NULL;
			_tmp48_ = math_display_get_equation (self);
			_tmp49_ = _tmp48_;
			math_equation_insert (_tmp49_, "×");
			result = TRUE;
			return result;
		}
		_tmp50_ = c;
		if (_tmp50_ == ((guint32) '/')) {
			MathEquation* _tmp51_ = NULL;
			MathEquation* _tmp52_ = NULL;
			_tmp51_ = math_display_get_equation (self);
			_tmp52_ = _tmp51_;
			math_equation_insert (_tmp52_, "÷");
			result = TRUE;
			return result;
		}
		_tmp53_ = c;
		if (_tmp53_ == ((guint32) '-')) {
			MathEquation* _tmp54_ = NULL;
			MathEquation* _tmp55_ = NULL;
			_tmp54_ = math_display_get_equation (self);
			_tmp55_ = _tmp54_;
			math_equation_insert_subtract (_tmp55_);
			result = TRUE;
			return result;
		}
	}
	_tmp56_ = state;
	if (_tmp56_ == GDK_CONTROL_MASK) {
		GdkEventKey _tmp57_ = {0};
		guint _tmp58_ = 0U;
		_tmp57_ = *event;
		_tmp58_ = _tmp57_.keyval;
		switch (_tmp58_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp59_ = NULL;
				MathEquation* _tmp60_ = NULL;
				_tmp59_ = math_display_get_equation (self);
				_tmp60_ = _tmp59_;
				math_equation_insert (_tmp60_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp61_ = NULL;
				MathEquation* _tmp62_ = NULL;
				_tmp61_ = math_display_get_equation (self);
				_tmp62_ = _tmp61_;
				math_equation_insert (_tmp62_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp63_ = NULL;
				MathEquation* _tmp64_ = NULL;
				_tmp63_ = math_display_get_equation (self);
				_tmp64_ = _tmp63_;
				math_equation_insert_exponent (_tmp64_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp65_ = NULL;
				MathEquation* _tmp66_ = NULL;
				_tmp65_ = math_display_get_equation (self);
				_tmp66_ = _tmp65_;
				math_equation_factorize (_tmp66_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp67_ = NULL;
				MathEquation* _tmp68_ = NULL;
				_tmp67_ = math_display_get_equation (self);
				_tmp68_ = _tmp67_;
				math_equation_insert (_tmp68_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp69_ = NULL;
				MathEquation* _tmp70_ = NULL;
				_tmp69_ = math_display_get_equation (self);
				_tmp70_ = _tmp69_;
				math_equation_insert (_tmp70_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp71_ = NULL;
				MathEquation* _tmp72_ = NULL;
				_tmp71_ = math_display_get_equation (self);
				_tmp72_ = _tmp71_;
				math_equation_insert (_tmp72_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp73_ = NULL;
				MathEquation* _tmp74_ = NULL;
				_tmp73_ = math_display_get_equation (self);
				_tmp74_ = _tmp73_;
				math_equation_insert (_tmp74_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp75_ = NULL;
				MathEquation* _tmp76_ = NULL;
				_tmp75_ = math_display_get_equation (self);
				_tmp76_ = _tmp75_;
				math_equation_insert (_tmp76_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp77_ = NULL;
				MathEquation* _tmp78_ = NULL;
				_tmp77_ = math_display_get_equation (self);
				_tmp78_ = _tmp77_;
				math_equation_insert (_tmp78_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp79_ = state;
	if (_tmp79_ == GDK_MOD1_MASK) {
		GdkEventKey _tmp80_ = {0};
		guint _tmp81_ = 0U;
		_tmp80_ = *event;
		_tmp81_ = _tmp80_.keyval;
		switch (_tmp81_) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp82_ = NULL;
				MathEquation* _tmp83_ = NULL;
				_tmp82_ = math_display_get_equation (self);
				_tmp83_ = _tmp82_;
				math_equation_insert (_tmp83_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp84_ = NULL;
				MathEquation* _tmp85_ = NULL;
				_tmp84_ = math_display_get_equation (self);
				_tmp85_ = _tmp84_;
				math_equation_insert (_tmp85_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	_tmp87_ = state;
	if (_tmp87_ == GDK_CONTROL_MASK) {
		_tmp86_ = TRUE;
	} else {
		MathEquation* _tmp88_ = NULL;
		MathEquation* _tmp89_ = NULL;
		NumberMode _tmp90_ = 0;
		NumberMode _tmp91_ = 0;
		_tmp88_ = math_display_get_equation (self);
		_tmp89_ = _tmp88_;
		_tmp90_ = math_equation_get_number_mode (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp86_ = _tmp91_ == NUMBER_MODE_SUPERSCRIPT;
	}
	_tmp92_ = _tmp86_;
	if (_tmp92_) {
		GdkEventKey _tmp93_ = {0};
		guint _tmp94_ = 0U;
		_tmp93_ = *event;
		_tmp94_ = _tmp93_.keyval;
		switch (_tmp94_) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp95_ = NULL;
				MathEquation* _tmp96_ = NULL;
				_tmp95_ = math_display_get_equation (self);
				_tmp96_ = _tmp95_;
				math_equation_insert (_tmp96_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp97_ = NULL;
				MathEquation* _tmp98_ = NULL;
				_tmp97_ = math_display_get_equation (self);
				_tmp98_ = _tmp97_;
				math_equation_insert (_tmp98_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp99_ = NULL;
				MathEquation* _tmp100_ = NULL;
				_tmp99_ = math_display_get_equation (self);
				_tmp100_ = _tmp99_;
				math_equation_insert (_tmp100_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp101_ = NULL;
				MathEquation* _tmp102_ = NULL;
				_tmp101_ = math_display_get_equation (self);
				_tmp102_ = _tmp101_;
				math_equation_insert (_tmp102_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp103_ = NULL;
				MathEquation* _tmp104_ = NULL;
				_tmp103_ = math_display_get_equation (self);
				_tmp104_ = _tmp103_;
				math_equation_insert (_tmp104_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp105_ = NULL;
				MathEquation* _tmp106_ = NULL;
				_tmp105_ = math_display_get_equation (self);
				_tmp106_ = _tmp105_;
				math_equation_insert (_tmp106_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp107_ = NULL;
				MathEquation* _tmp108_ = NULL;
				_tmp107_ = math_display_get_equation (self);
				_tmp108_ = _tmp107_;
				math_equation_insert (_tmp108_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp109_ = NULL;
				MathEquation* _tmp110_ = NULL;
				_tmp109_ = math_display_get_equation (self);
				_tmp110_ = _tmp109_;
				math_equation_insert (_tmp110_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp111_ = NULL;
				MathEquation* _tmp112_ = NULL;
				_tmp111_ = math_display_get_equation (self);
				_tmp112_ = _tmp111_;
				math_equation_insert (_tmp112_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp113_ = NULL;
				MathEquation* _tmp114_ = NULL;
				_tmp113_ = math_display_get_equation (self);
				_tmp114_ = _tmp113_;
				math_equation_insert (_tmp114_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp115_ = FALSE;
		GdkModifierType _tmp116_ = 0;
		gboolean _tmp121_ = FALSE;
		_tmp116_ = state;
		if (_tmp116_ == GDK_MOD1_MASK) {
			_tmp115_ = TRUE;
		} else {
			MathEquation* _tmp117_ = NULL;
			MathEquation* _tmp118_ = NULL;
			NumberMode _tmp119_ = 0;
			NumberMode _tmp120_ = 0;
			_tmp117_ = math_display_get_equation (self);
			_tmp118_ = _tmp117_;
			_tmp119_ = math_equation_get_number_mode (_tmp118_);
			_tmp120_ = _tmp119_;
			_tmp115_ = _tmp120_ == NUMBER_MODE_SUBSCRIPT;
		}
		_tmp121_ = _tmp115_;
		if (_tmp121_) {
			GdkEventKey _tmp122_ = {0};
			guint _tmp123_ = 0U;
			_tmp122_ = *event;
			_tmp123_ = _tmp122_.keyval;
			switch (_tmp123_) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp124_ = NULL;
					MathEquation* _tmp125_ = NULL;
					_tmp124_ = math_display_get_equation (self);
					_tmp125_ = _tmp124_;
					math_equation_insert (_tmp125_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp126_ = NULL;
					MathEquation* _tmp127_ = NULL;
					_tmp126_ = math_display_get_equation (self);
					_tmp127_ = _tmp126_;
					math_equation_insert (_tmp127_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp128_ = NULL;
					MathEquation* _tmp129_ = NULL;
					_tmp128_ = math_display_get_equation (self);
					_tmp129_ = _tmp128_;
					math_equation_insert (_tmp129_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp130_ = NULL;
					MathEquation* _tmp131_ = NULL;
					_tmp130_ = math_display_get_equation (self);
					_tmp131_ = _tmp130_;
					math_equation_insert (_tmp131_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp132_ = NULL;
					MathEquation* _tmp133_ = NULL;
					_tmp132_ = math_display_get_equation (self);
					_tmp133_ = _tmp132_;
					math_equation_insert (_tmp133_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp134_ = NULL;
					MathEquation* _tmp135_ = NULL;
					_tmp134_ = math_display_get_equation (self);
					_tmp135_ = _tmp134_;
					math_equation_insert (_tmp135_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp136_ = NULL;
					MathEquation* _tmp137_ = NULL;
					_tmp136_ = math_display_get_equation (self);
					_tmp137_ = _tmp136_;
					math_equation_insert (_tmp137_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp138_ = NULL;
					MathEquation* _tmp139_ = NULL;
					_tmp138_ = math_display_get_equation (self);
					_tmp139_ = _tmp138_;
					math_equation_insert (_tmp139_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp140_ = NULL;
					MathEquation* _tmp141_ = NULL;
					_tmp140_ = math_display_get_equation (self);
					_tmp141_ = _tmp140_;
					math_equation_insert (_tmp141_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp142_ = NULL;
					MathEquation* _tmp143_ = NULL;
					_tmp142_ = math_display_get_equation (self);
					_tmp143_ = _tmp142_;
					math_equation_insert (_tmp143_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void math_display_status_changed_cb (MathDisplay* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_ = NULL;
	MathEquation* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->priv->spinner;
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp13_ = _tmp6_;
	if (_tmp13_) {
		GtkSpinner* _tmp14_ = NULL;
		GtkSpinner* _tmp15_ = NULL;
		_tmp14_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->spinner;
		gtk_spinner_start (_tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		MathEquation* _tmp17_ = NULL;
		MathEquation* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp17_ = math_display_get_equation (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = math_equation_get_in_solve (_tmp18_);
		_tmp20_ = _tmp19_;
		if (!_tmp20_) {
			GtkSpinner* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = self->priv->spinner;
			_tmp22_ = gtk_widget_get_visible ((GtkWidget*) _tmp21_);
			_tmp16_ = _tmp22_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp23_ = _tmp16_;
		if (_tmp23_) {
			GtkSpinner* _tmp24_ = NULL;
			GtkSpinner* _tmp25_ = NULL;
			_tmp24_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp24_);
			_tmp25_ = self->priv->spinner;
			gtk_spinner_stop (_tmp25_);
		}
	}
}


static void math_display_error_status_changed_cb (MathDisplay* self) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_ = NULL;
	MathEquation* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_ = NULL;
	MathEquation* _tmp12_ = NULL;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_ = NULL;
	MathEquation* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	MathEquation* _tmp18_ = NULL;
	MathEquation* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	MathEquation* _tmp22_ = NULL;
	MathEquation* _tmp23_ = NULL;
	GtkTextIter _tmp24_ = {0};
	GtkTextIter _tmp25_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}


MathEquation* math_display_get_equation (MathDisplay* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static void math_display_class_init (MathDisplayClass * klass) {
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathDisplayPrivate));
	GTK_WIDGET_CLASS (klass)->key_press_event = math_display_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_display_instance_init (MathDisplay * self) {
	self->priv = MATH_DISPLAY_GET_PRIVATE (self);
}


static void math_display_finalize (GObject* obj) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->source_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}


GType math_display_get_type (void) {
	static volatile gsize math_display_type_id__volatile = 0;
	if (g_once_init_enter (&math_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
		GType math_display_type_id;
		math_display_type_id = g_type_register_static (GTK_TYPE_VIEWPORT, "MathDisplay", &g_define_type_info, 0);
		g_once_init_leave (&math_display_type_id__volatile, math_display_type_id);
	}
	return math_display_type_id__volatile;
}


static void _vala_math_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gchar* completion_provider_real_get_name (CompletionProvider* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


gchar* completion_provider_get_name (CompletionProvider* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_name (self);
}


void completion_provider_move_iter_to_name_start (GtkTextIter* iter) {
	g_return_if_fail (iter != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gunichar current_char = 0U;
		gunichar _tmp1_ = 0U;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = gtk_text_iter_backward_char (iter);
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = gtk_text_iter_get_char (iter);
		current_char = _tmp1_;
		_tmp2_ = current_char;
		_tmp3_ = g_unichar_isalpha (_tmp2_);
		if (!_tmp3_) {
			gtk_text_iter_forward_char (iter);
			break;
		}
	}
}


static gboolean completion_provider_real_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	gboolean result = FALSE;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean completion_provider_get_start_iter (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->get_start_iter (self, context, proposal, iter);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean completion_provider_real_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	gboolean result = FALSE;
	gchar* proposed_string = NULL;
	GtkSourceCompletionProposal* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	GtkTextBuffer* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	proposed_string = _tmp1_;
	_tmp2_ = gtk_text_iter_get_buffer (iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	_tmp5_ = gtk_text_iter_get_offset (iter);
	gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp6_, _tmp5_);
	start_iter = _tmp6_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp7_ = buffer;
	_tmp8_ = start_iter;
	gtk_text_buffer_place_cursor (_tmp7_, &_tmp8_);
	_tmp9_ = buffer;
	_tmp10_ = start_iter;
	_tmp11_ = *iter;
	g_signal_emit_by_name (_tmp9_, "delete-range", &_tmp10_, &_tmp11_);
	_tmp12_ = buffer;
	_tmp13_ = proposed_string;
	_tmp14_ = proposed_string;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_text_buffer_insert_at_cursor (_tmp12_, _tmp13_, _tmp16_);
	_tmp17_ = proposed_string;
	_tmp18_ = string_contains (_tmp17_, "()");
	if (_tmp18_) {
		GtkTextBuffer* _tmp19_ = NULL;
		GtkTextBuffer* _tmp20_ = NULL;
		GtkTextMark* _tmp21_ = NULL;
		GtkTextIter _tmp22_ = {0};
		GtkTextBuffer* _tmp23_ = NULL;
		GtkTextIter _tmp24_ = {0};
		_tmp19_ = buffer;
		_tmp20_ = buffer;
		_tmp21_ = gtk_text_buffer_get_insert (_tmp20_);
		gtk_text_buffer_get_iter_at_mark (_tmp19_, &_tmp22_, _tmp21_);
		end = _tmp22_;
		gtk_text_iter_backward_chars (&end, 1);
		_tmp23_ = buffer;
		_tmp24_ = end;
		gtk_text_buffer_place_cursor (_tmp23_, &_tmp24_);
	}
	result = TRUE;
	_g_object_unref0 (buffer);
	_g_free0 (proposed_string);
	return result;
}


gboolean completion_provider_activate_proposal (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	g_return_val_if_fail (self != NULL, FALSE);
	return COMPLETION_PROVIDER_GET_CLASS (self)->activate_proposal (self, proposal, iter);
}


static void completion_provider_real_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
	g_return_if_fail (context != NULL);
}


void completion_provider_populate (CompletionProvider* self, GtkSourceCompletionContext* context) {
	g_return_if_fail (self != NULL);
	COMPLETION_PROVIDER_GET_CLASS (self)->populate (self, context);
}


CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	return self;
}


CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	COMPLETION_PROVIDER_CLASS (klass)->get_name = completion_provider_real_get_name;
	COMPLETION_PROVIDER_CLASS (klass)->get_start_iter = completion_provider_real_get_start_iter;
	COMPLETION_PROVIDER_CLASS (klass)->activate_proposal = completion_provider_real_activate_proposal;
	COMPLETION_PROVIDER_CLASS (klass)->populate = completion_provider_real_populate;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) completion_provider_get_name;
	iface->get_start_iter = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_get_start_iter;
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_activate_proposal;
	iface->populate = (void (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_populate;
}


static void completion_provider_instance_init (CompletionProvider * self) {
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gchar* function_completion_provider_real_get_name (CompletionProvider* base) {
	FunctionCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (FunctionCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Functions");
	result = _tmp0_;
	return result;
}


MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, int* result_length1) {
	MathFunction** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp12_ = NULL;
	MathFunction** functions = NULL;
	gint _tmp13_ = 0;
	MathFunction** _tmp14_ = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	MathFunction** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	_tmp0_ = text_buffer;
	_tmp1_ = text_buffer;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = text_buffer;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	start_iter = _tmp7_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp8_ = text_buffer;
	_tmp9_ = start_iter;
	_tmp10_ = end_iter;
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
	search_pattern = _tmp11_;
	_tmp12_ = function_manager_get_default_function_manager ();
	function_manager = _tmp12_;
	_tmp14_ = function_manager_functions_eligible_for_autocompletion_for_text (function_manager, search_pattern, &_tmp13_);
	functions = _tmp14_;
	functions_length1 = _tmp13_;
	_functions_size_ = functions_length1;
	_tmp15_ = functions;
	_tmp15__length1 = functions_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_object_unref0 (function_manager);
	_g_free0 (search_pattern);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void function_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	FunctionCompletionProvider * self;
	GtkTextBuffer* text_buffer = NULL;
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	MathFunction** functions = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	MathFunction** _tmp6_ = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	GList* proposals = NULL;
	MathFunction** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GtkSourceCompletionContext* _tmp51_ = NULL;
	GList* _tmp52_ = NULL;
	self = (FunctionCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	_tmp2_ = gtk_text_iter_get_buffer (&_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	text_buffer = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp6_ = function_completion_provider_get_matches_for_completion_at_cursor (_tmp4_, &_tmp5_);
	functions = _tmp6_;
	functions_length1 = _tmp5_;
	_functions_size_ = functions_length1;
	proposals = NULL;
	_tmp7_ = functions;
	_tmp7__length1 = functions_length1;
	if (_tmp7__length1 > 0) {
		MathFunction** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp8_ = functions;
		_tmp8__length1 = functions_length1;
		{
			MathFunction** function_collection = NULL;
			gint function_collection_length1 = 0;
			gint _function_collection_size_ = 0;
			gint function_it = 0;
			function_collection = _tmp8_;
			function_collection_length1 = _tmp8__length1;
			for (function_it = 0; function_it < _tmp8__length1; function_it = function_it + 1) {
				MathFunction* _tmp9_ = NULL;
				MathFunction* function = NULL;
				_tmp9_ = _g_object_ref0 (function_collection[function_it]);
				function = _tmp9_;
				{
					gchar* display_text = NULL;
					MathFunction* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					MathFunction* _tmp13_ = NULL;
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* details_text = NULL;
					MathFunction* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* label_text = NULL;
					MathFunction* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					MathFunction* _tmp28_ = NULL;
					gboolean _tmp29_ = FALSE;
					GtkSourceCompletionItem* proposal = NULL;
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					GtkSourceCompletionItem* _tmp48_ = NULL;
					GtkSourceCompletionItem* _tmp49_ = NULL;
					GtkSourceCompletionItem* _tmp50_ = NULL;
					_tmp10_ = function;
					_tmp11_ = math_function_get_name (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = function;
					_tmp14_ = math_function_get_arguments (_tmp13_, &_tmp14__length1);
					_tmp15_ = _tmp14_;
					_tmp15__length1 = _tmp14__length1;
					_tmp16_ = g_strjoinv (";", _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup_printf ("%s(%s)", _tmp12_, _tmp17_);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp17_);
					display_text = _tmp19_;
					_tmp20_ = function;
					_tmp21_ = math_function_get_description (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf ("%s", _tmp22_);
					details_text = _tmp23_;
					_tmp24_ = function;
					_tmp25_ = math_function_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp26_, "()", NULL);
					label_text = _tmp27_;
					_tmp28_ = function;
					_tmp29_ = math_function_is_custom_function (_tmp28_);
					if (_tmp29_) {
						MathFunction* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						MathFunction* _tmp33_ = NULL;
						gchar** _tmp34_ = NULL;
						gint _tmp34__length1 = 0;
						gchar** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						MathFunction* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						MathFunction* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						const gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						_tmp30_ = function;
						_tmp31_ = math_function_get_name (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = function;
						_tmp34_ = math_function_get_arguments (_tmp33_, &_tmp34__length1);
						_tmp35_ = _tmp34_;
						_tmp35__length1 = _tmp34__length1;
						_tmp36_ = g_strjoinv (";", _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = function;
						_tmp39_ = math_function_get_expression (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = function;
						_tmp42_ = math_function_get_description (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = g_strdup_printf ("%s(%s)=%s\n%s", _tmp32_, _tmp37_, _tmp40_, _tmp43_);
						_g_free0 (details_text);
						details_text = _tmp44_;
						_g_free0 (_tmp37_);
					}
					_tmp45_ = display_text;
					_tmp46_ = label_text;
					_tmp47_ = details_text;
					_tmp48_ = gtk_source_completion_item_new (_tmp45_, _tmp46_, NULL, _tmp47_);
					proposal = _tmp48_;
					_tmp49_ = proposal;
					_tmp50_ = _g_object_ref0 (_tmp49_);
					proposals = g_list_append (proposals, _tmp50_);
					_g_object_unref0 (proposal);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_object_unref0 (function);
				}
			}
		}
	}
	_tmp51_ = context;
	_tmp52_ = proposals;
	gtk_source_completion_context_add_proposals (_tmp51_, (GtkSourceCompletionProvider*) self, _tmp52_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (text_buffer);
}


FunctionCompletionProvider* function_completion_provider_construct (GType object_type) {
	FunctionCompletionProvider * self = NULL;
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
	return self;
}


FunctionCompletionProvider* function_completion_provider_new (void) {
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
}


static void function_completion_provider_class_init (FunctionCompletionProviderClass * klass) {
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
	COMPLETION_PROVIDER_CLASS (klass)->get_name = function_completion_provider_real_get_name;
	COMPLETION_PROVIDER_CLASS (klass)->populate = function_completion_provider_real_populate;
}


static void function_completion_provider_instance_init (FunctionCompletionProvider * self) {
}


GType function_completion_provider_get_type (void) {
	static volatile gsize function_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&function_completion_provider_type_id__volatile, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__volatile;
}


VariableCompletionProvider* variable_completion_provider_construct (GType object_type, MathEquation* equation) {
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	return self;
}


VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation) {
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
}


static gchar* variable_completion_provider_real_get_name (CompletionProvider* base) {
	VariableCompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (VariableCompletionProvider*) base;
	_tmp0_ = g_strdup ("Defined Variables");
	result = _tmp0_;
	return result;
}


gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkTextBuffer* text_buffer, MathVariables* variables, int* result_length1) {
	gchar** result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	gchar* search_pattern = NULL;
	GtkTextBuffer* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	gchar** math_variables = NULL;
	MathVariables* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint math_variables_length1 = 0;
	gint _math_variables_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (text_buffer != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	_tmp0_ = text_buffer;
	_tmp1_ = text_buffer;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	gtk_text_buffer_get_iter_at_mark (_tmp0_, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = text_buffer;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	start_iter = _tmp7_;
	completion_provider_move_iter_to_name_start (&start_iter);
	_tmp8_ = text_buffer;
	_tmp9_ = start_iter;
	_tmp10_ = end_iter;
	_tmp11_ = gtk_text_buffer_get_slice (_tmp8_, &_tmp9_, &_tmp10_, FALSE);
	search_pattern = _tmp11_;
	_tmp12_ = variables;
	_tmp14_ = math_variables_variables_eligible_for_autocompletion (_tmp12_, search_pattern, &_tmp13_);
	math_variables = _tmp14_;
	math_variables_length1 = _tmp13_;
	_math_variables_size_ = math_variables_length1;
	_tmp15_ = math_variables;
	_tmp15__length1 = math_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (search_pattern);
	return result;
}


static void variable_completion_provider_real_populate (CompletionProvider* base, GtkSourceCompletionContext* context) {
	VariableCompletionProvider * self;
	GtkTextBuffer* text_buffer = NULL;
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	gchar** variables = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	MathVariables* _tmp6_ = NULL;
	MathVariables* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gint variables_length1 = 0;
	gint _variables_size_ = 0;
	GList* proposals = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GtkSourceCompletionContext* _tmp34_ = NULL;
	GList* _tmp35_ = NULL;
	self = (VariableCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	_tmp2_ = gtk_text_iter_get_buffer (&_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	text_buffer = _tmp3_;
	_tmp4_ = text_buffer;
	_tmp5_ = self->priv->_equation;
	_tmp6_ = math_equation_get_variables (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = variable_completion_provider_get_matches_for_completion_at_cursor (_tmp4_, _tmp7_, &_tmp8_);
	variables = _tmp9_;
	variables_length1 = _tmp8_;
	_variables_size_ = variables_length1;
	proposals = NULL;
	_tmp10_ = variables;
	_tmp10__length1 = variables_length1;
	if (_tmp10__length1 > 0) {
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		__g_list_free__g_object_unref0_0 (proposals);
		proposals = NULL;
		_tmp11_ = variables;
		_tmp11__length1 = variables_length1;
		{
			gchar** variable_collection = NULL;
			gint variable_collection_length1 = 0;
			gint _variable_collection_size_ = 0;
			gint variable_it = 0;
			variable_collection = _tmp11_;
			variable_collection_length1 = _tmp11__length1;
			for (variable_it = 0; variable_it < _tmp11__length1; variable_it = variable_it + 1) {
				gchar* _tmp12_ = NULL;
				gchar* variable = NULL;
				_tmp12_ = g_strdup (variable_collection[variable_it]);
				variable = _tmp12_;
				{
					gchar* display_text = NULL;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* details_text = NULL;
					MathEquation* _tmp15_ = NULL;
					Serializer* _tmp16_ = NULL;
					Serializer* _tmp17_ = NULL;
					MathEquation* _tmp18_ = NULL;
					MathVariables* _tmp19_ = NULL;
					MathVariables* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					Number* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* label_text = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					GtkSourceCompletionItem* proposal = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					GtkSourceCompletionItem* _tmp31_ = NULL;
					GtkSourceCompletionItem* _tmp32_ = NULL;
					GtkSourceCompletionItem* _tmp33_ = NULL;
					_tmp13_ = variable;
					_tmp14_ = g_strdup_printf ("%s", _tmp13_);
					display_text = _tmp14_;
					_tmp15_ = self->priv->_equation;
					_tmp16_ = math_equation_get_serializer (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = self->priv->_equation;
					_tmp19_ = math_equation_get_variables (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = variable;
					_tmp22_ = math_variables_get (_tmp20_, _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = serializer_to_string (_tmp17_, _tmp23_);
					_tmp25_ = _tmp24_;
					_number_unref0 (_tmp23_);
					details_text = _tmp25_;
					_tmp26_ = variable;
					_tmp27_ = g_strdup (_tmp26_);
					label_text = _tmp27_;
					_tmp28_ = display_text;
					_tmp29_ = label_text;
					_tmp30_ = details_text;
					_tmp31_ = gtk_source_completion_item_new (_tmp28_, _tmp29_, NULL, _tmp30_);
					proposal = _tmp31_;
					_tmp32_ = proposal;
					_tmp33_ = _g_object_ref0 (_tmp32_);
					proposals = g_list_append (proposals, _tmp33_);
					_g_object_unref0 (proposal);
					_g_free0 (label_text);
					_g_free0 (details_text);
					_g_free0 (display_text);
					_g_free0 (variable);
				}
			}
		}
	}
	_tmp34_ = context;
	_tmp35_ = proposals;
	gtk_source_completion_context_add_proposals (_tmp34_, (GtkSourceCompletionProvider*) self, _tmp35_, TRUE);
	__g_list_free__g_object_unref0_0 (proposals);
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (text_buffer);
}


static void variable_completion_provider_class_init (VariableCompletionProviderClass * klass) {
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VariableCompletionProviderPrivate));
	COMPLETION_PROVIDER_CLASS (klass)->get_name = variable_completion_provider_real_get_name;
	COMPLETION_PROVIDER_CLASS (klass)->populate = variable_completion_provider_real_populate;
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
}


static void variable_completion_provider_instance_init (VariableCompletionProvider * self) {
	self->priv = VARIABLE_COMPLETION_PROVIDER_GET_PRIVATE (self);
}


static void variable_completion_provider_finalize (GObject* obj) {
	VariableCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
	_g_object_unref0 (self->priv->_equation);
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
}


GType variable_completion_provider_get_type (void) {
	static volatile gsize variable_completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
		g_once_init_leave (&variable_completion_provider_type_id__volatile, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



