/* win7-installer.c generated by valac 0.16.0, the Vala compiler
 * generated from win7-installer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* Automated installer media for Windows 7 and 2008*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>


#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
typedef struct _BoxesUnattendedInstallerPrivate BoxesUnattendedInstallerPrivate;

#define BOXES_TYPE_WINDOWS_INSTALLER (boxes_windows_installer_get_type ())
#define BOXES_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstaller))
#define BOXES_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))
#define BOXES_IS_WINDOWS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_IS_WINDOWS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WINDOWS_INSTALLER))
#define BOXES_WINDOWS_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WINDOWS_INSTALLER, BoxesWindowsInstallerClass))

typedef struct _BoxesWindowsInstaller BoxesWindowsInstaller;
typedef struct _BoxesWindowsInstallerClass BoxesWindowsInstallerClass;
typedef struct _BoxesWindowsInstallerPrivate BoxesWindowsInstallerPrivate;

#define BOXES_TYPE_WIN7_INSTALLER (boxes_win7_installer_get_type ())
#define BOXES_WIN7_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7Installer))
#define BOXES_WIN7_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7InstallerClass))
#define BOXES_IS_WIN7_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_WIN7_INSTALLER))
#define BOXES_IS_WIN7_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_WIN7_INSTALLER))
#define BOXES_WIN7_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_WIN7_INSTALLER, BoxesWin7InstallerClass))

typedef struct _BoxesWin7Installer BoxesWin7Installer;
typedef struct _BoxesWin7InstallerClass BoxesWin7InstallerClass;
typedef struct _BoxesWin7InstallerPrivate BoxesWin7InstallerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
};

typedef enum  {
	UNATTENDED_INSTALLER_ERROR_COMMAND_FAILED,
	UNATTENDED_INSTALLER_ERROR_SETUP_INCOMPLETE
} UnattendedInstallerError;
#define UNATTENDED_INSTALLER_ERROR unattended_installer_error_quark ()
struct _BoxesUnattendedInstaller {
	BoxesInstallerMedia parent_instance;
	BoxesUnattendedInstallerPrivate * priv;
	gchar* unattended_src_path;
	gchar* unattended_dest_name;
	GDataStreamNewlineType newline_type;
	gchar* disk_path;
	GtkTable* setup_table;
	GtkLabel* setup_label;
	GtkHBox* setup_hbox;
	GtkSwitch* express_toggle;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	gchar* timezone;
	gchar* kbd;
	gchar* lang;
};

struct _BoxesUnattendedInstallerClass {
	BoxesInstallerMediaClass parent_class;
	void (*populate_setup_vbox) (BoxesUnattendedInstaller* self, GtkVBox* setup_vbox);
	void (*set_direct_boot_params) (BoxesUnattendedInstaller* self, GVirConfigDomainOs* os);
	GVirConfigDomainDisk* (*get_unattended_disk_config) (BoxesUnattendedInstaller* self);
	void (*check_needed_info) (BoxesUnattendedInstaller* self, GError** error);
	void (*setup_ui) (BoxesUnattendedInstaller* self);
	void (*clean_up) (BoxesUnattendedInstaller* self, GError** error);
	gchar* (*fill_unattended_data) (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
	void (*prepare_direct_boot) (BoxesUnattendedInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_direct_boot_finish) (BoxesUnattendedInstaller* self, GAsyncResult* _res_, GError** error);
};

struct _BoxesWindowsInstaller {
	BoxesUnattendedInstaller parent_instance;
	BoxesWindowsInstallerPrivate * priv;
};

struct _BoxesWindowsInstallerClass {
	BoxesUnattendedInstallerClass parent_class;
};

struct _BoxesWin7Installer {
	BoxesWindowsInstaller parent_instance;
	BoxesWin7InstallerPrivate * priv;
};

struct _BoxesWin7InstallerClass {
	BoxesWindowsInstallerClass parent_class;
};


static gpointer boxes_win7_installer_parent_class = NULL;
static GRegex* boxes_win7_installer_arch_regex;
static GRegex* boxes_win7_installer_arch_regex = NULL;

GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
GQuark unattended_installer_error_quark (void);
GType boxes_windows_installer_get_type (void) G_GNUC_CONST;
GType boxes_win7_installer_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_WIN7_INSTALLER_DUMMY_PROPERTY
};
static gchar* boxes_win7_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error);
gchar* boxes_unattended_installer_fill_unattended_data (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
BoxesWin7Installer* boxes_win7_installer_new_copy (BoxesInstallerMedia* media, GError** error);
BoxesWin7Installer* boxes_win7_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error);
gchar* boxes_get_unattended_dir (const gchar* file_name);
BoxesUnattendedInstaller* boxes_unattended_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, const gchar* unattended_src_path, const gchar* unattended_dest_name, GError** error);
BoxesWin7Installer* boxes_win7_installer_new (void);
BoxesWin7Installer* boxes_win7_installer_construct (GType object_type);
BoxesWindowsInstaller* boxes_windows_installer_construct (GType object_type);
static void boxes_win7_installer_finalize (GObject* obj);

static GRegex* _tmp_regex_0 = NULL;

static gchar* boxes_win7_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error) {
	BoxesWin7Installer * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* str;
	OsinfoMedia* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	GError * _inner_error_ = NULL;
	self = (BoxesWin7Installer*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = BOXES_UNATTENDED_INSTALLER_CLASS (boxes_win7_installer_parent_class)->fill_unattended_data ((BoxesUnattendedInstaller*) BOXES_WINDOWS_INSTALLER (self), _tmp0_, &_inner_error_);
	str = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = ((BoxesInstallerMedia*) self)->os_media;
	g_object_get (_tmp2_, "architecture", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	g_free (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("x86_64")))) {
		switch (0) {
			default:
			{
				GRegex* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp8_ = boxes_win7_installer_arch_regex;
				_tmp9_ = str;
				_tmp10_ = str;
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_regex_replace (_tmp8_, _tmp9_, (gssize) _tmp12_, 0, "amd64", 0, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (str);
						return NULL;
					} else {
						_g_free0 (str);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				result = _tmp14_;
				_g_free0 (str);
				return result;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("i386")))) {
		switch (0) {
			default:
			{
				GRegex* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				_tmp15_ = boxes_win7_installer_arch_regex;
				_tmp16_ = str;
				_tmp17_ = str;
				_tmp18_ = strlen (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_regex_replace (_tmp15_, _tmp16_, (gssize) _tmp19_, 0, "x86", 0, &_inner_error_);
				_tmp21_ = _tmp20_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (str);
						return NULL;
					} else {
						_g_free0 (str);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				result = _tmp21_;
				_g_free0 (str);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				OsinfoMedia* _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GRegex* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				_tmp22_ = ((BoxesInstallerMedia*) self)->os_media;
				g_object_get (_tmp22_, "architecture", &_tmp23_, NULL);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				g_warning ("win7-installer.vala:28: Unexpected osinfo win7 arch: %s", _tmp25_);
				_g_free0 (_tmp25_);
				_tmp26_ = boxes_win7_installer_arch_regex;
				_tmp27_ = str;
				_tmp28_ = str;
				_tmp29_ = strlen (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_regex_replace (_tmp26_, _tmp27_, (gssize) _tmp30_, 0, "x86", 0, &_inner_error_);
				_tmp32_ = _tmp31_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_REGEX_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (str);
						return NULL;
					} else {
						_g_free0 (str);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				result = _tmp32_;
				_g_free0 (str);
				return result;
			}
		}
	}
	_g_free0 (str);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch64_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch64_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally64;
	__catch64_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally64:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


BoxesWin7Installer* boxes_win7_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error) {
	BoxesWin7Installer * self = NULL;
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* unattended_source;
	BoxesInstallerMedia* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = media;
	_tmp1_ = _tmp0_->os;
	_tmp2_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".xml", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = boxes_get_unattended_dir (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	unattended_source = _tmp7_;
	_tmp8_ = media;
	_tmp9_ = unattended_source;
	self = (BoxesWin7Installer*) boxes_unattended_installer_construct_copy (object_type, _tmp8_, _tmp9_, "Autounattend.xml", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (unattended_source);
		_g_object_unref0 (self);
		return NULL;
	}
	((BoxesUnattendedInstaller*) self)->newline_type = G_DATA_STREAM_NEWLINE_TYPE_CR_LF;
	_tmp10_ = ((BoxesUnattendedInstaller*) self)->lang;
	_tmp11_ = string_replace (_tmp10_, "_", "-");
	_g_free0 (((BoxesUnattendedInstaller*) self)->lang);
	((BoxesUnattendedInstaller*) self)->lang = _tmp11_;
	_tmp12_ = ((BoxesUnattendedInstaller*) self)->lang;
	_tmp13_ = g_regex_replace (_thread_safe_regex_init (&_tmp_regex_0, "\\..*", 0 | G_REGEX_CASELESS), _tmp12_, (gssize) (-1), 0, "", 0, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (unattended_source);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_free0 (((BoxesUnattendedInstaller*) self)->lang);
	((BoxesUnattendedInstaller*) self)->lang = _tmp14_;
	_g_free0 (unattended_source);
	return self;
}


BoxesWin7Installer* boxes_win7_installer_new_copy (BoxesInstallerMedia* media, GError** error) {
	return boxes_win7_installer_construct_copy (BOXES_TYPE_WIN7_INSTALLER, media, error);
}


BoxesWin7Installer* boxes_win7_installer_construct (GType object_type) {
	BoxesWin7Installer * self = NULL;
	self = (BoxesWin7Installer*) boxes_windows_installer_construct (object_type);
	return self;
}


BoxesWin7Installer* boxes_win7_installer_new (void) {
	return boxes_win7_installer_construct (BOXES_TYPE_WIN7_INSTALLER);
}


static void boxes_win7_installer_class_init (BoxesWin7InstallerClass * klass) {
	GError * _inner_error_ = NULL;
	boxes_win7_installer_parent_class = g_type_class_peek_parent (klass);
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->fill_unattended_data = boxes_win7_installer_real_fill_unattended_data;
	G_OBJECT_CLASS (klass)->finalize = boxes_win7_installer_finalize;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("BOXES_CPU", 0, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch65_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (boxes_win7_installer_arch_regex);
		boxes_win7_installer_arch_regex = _tmp1_;
	}
	goto __finally65;
	__catch65_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally65:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void boxes_win7_installer_instance_init (BoxesWin7Installer * self) {
}


static void boxes_win7_installer_finalize (GObject* obj) {
	BoxesWin7Installer * self;
	self = BOXES_WIN7_INSTALLER (obj);
	G_OBJECT_CLASS (boxes_win7_installer_parent_class)->finalize (obj);
}


GType boxes_win7_installer_get_type (void) {
	static volatile gsize boxes_win7_installer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_win7_installer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesWin7InstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_win7_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesWin7Installer), 0, (GInstanceInitFunc) boxes_win7_installer_instance_init, NULL };
		GType boxes_win7_installer_type_id;
		boxes_win7_installer_type_id = g_type_register_static (BOXES_TYPE_WINDOWS_INSTALLER, "BoxesWin7Installer", &g_define_type_info, 0);
		g_once_init_leave (&boxes_win7_installer_type_id__volatile, boxes_win7_installer_type_id);
	}
	return boxes_win7_installer_type_id__volatile;
}



