/* vm-configurator.c generated by valac 0.15.1.29-64309, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <osinfo/osinfo.h>
#include <config.h>
#include <unistd.h>
#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value, gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_VM_CONFIGURATOR_DUMMY_PROPERTY
};
#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesVMConfigurator* self, BoxesInstallerMedia* install_media, const gchar* name, const gchar* target_path);
gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static void boxes_vm_configurator_set_os_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_target_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, const gchar* target_path);
static void boxes_vm_configurator_set_unattended_disk_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_source_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
gboolean boxes_unattended_installer_get_express_install (BoxesUnattendedInstaller* self);
gchar* boxes_unattended_installer_get_password (BoxesUnattendedInstaller* self);
static void boxes_vm_configurator_set_video_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
void boxes_vm_configurator_post_install_setup (BoxesVMConfigurator* self, GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_install_config (BoxesVMConfigurator* self, GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (BoxesVMConfigurator* self, GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_live_config (BoxesVMConfigurator* self, GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (BoxesVMConfigurator* self, const gchar* name, gint64 storage, GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (BoxesVMConfigurator* self);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (BoxesVMConfigurator* self, GError** error);
gchar* boxes_get_user_pkgdata (const gchar* file_name);
void boxes_ensure_directory (const gchar* dir);
GVirConfigDomainDisk* boxes_unattended_installer_get_unattended_disk_config (BoxesUnattendedInstaller* self);
static void boxes_vm_configurator_set_direct_boot_params (BoxesVMConfigurator* self, GVirConfigDomainOs* os, BoxesInstallerMedia* install_media);
void boxes_unattended_installer_set_direct_boot_params (BoxesUnattendedInstaller* self, GVirConfigDomainOs* os);
OsinfoDevice* boxes_get_os_device_by_prop (OsinfoOs* os, const gchar* prop_name, const gchar* prop_value);
gint boxes_get_enum_value (const gchar* value_nick, GType enum_type);
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesVMConfigurator* self, BoxesInstallerMedia* install_media, const gchar* name, const gchar* target_path) {
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* _tmp0_;
	GVirConfigDomain* domain;
	GVirConfigDomain* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	BoxesInstallerMedia* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* xml;
	GVirConfigDomain* _tmp10_;
	BoxesInstallerMedia* _tmp11_;
	OsinfoResources* _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	GVirConfigDomain* _tmp15_;
	BoxesInstallerMedia* _tmp16_;
	OsinfoResources* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GVirConfigDomain* _tmp20_;
	GVirConfigDomain* _tmp21_;
	BoxesInstallerMedia* _tmp22_;
	GVirConfigDomain* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GVirConfigDomainClock* _tmp29_;
	GVirConfigDomainClock* clock;
	gboolean _tmp30_ = FALSE;
	BoxesInstallerMedia* _tmp31_;
	OsinfoOs* _tmp32_;
	gboolean _tmp38_;
	GVirConfigDomain* _tmp41_;
	GVirConfigDomainClock* _tmp42_;
	GVirConfigDomain* _tmp43_;
	const gchar* _tmp44_;
	GVirConfigDomain* _tmp45_;
	BoxesInstallerMedia* _tmp46_;
	GVirConfigDomain* _tmp47_;
	BoxesInstallerMedia* _tmp48_;
	GVirConfigDomainGraphicsSpice* _tmp49_;
	GVirConfigDomainGraphicsSpice* graphics;
	GVirConfigDomainGraphicsSpice* _tmp50_;
	BoxesInstallerMedia* _tmp51_;
	GVirConfigDomain* _tmp68_;
	GVirConfigDomainGraphicsSpice* _tmp69_;
	GVirConfigDomain* _tmp70_;
	BoxesInstallerMedia* _tmp71_;
	GVirConfigDomain* _tmp72_;
	BoxesInstallerMedia* _tmp73_;
	GVirConfigDomain* _tmp74_;
	BoxesInstallerMedia* _tmp75_;
	GVirConfigDomain* _tmp76_;
	GVirConfigDomain* _tmp77_;
	GVirConfigDomain* _tmp78_;
	GVirConfigDomainConsole* _tmp79_;
	GVirConfigDomainConsole* console;
	GVirConfigDomainChardevSourcePty* _tmp80_;
	GVirConfigDomainChardevSourcePty* _tmp81_;
	GVirConfigDomain* _tmp82_;
	GVirConfigDomainInterfaceUser* _tmp83_;
	GVirConfigDomainInterfaceUser* iface;
	GVirConfigDomain* _tmp84_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (install_media != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (target_path != NULL, NULL);
	_tmp0_ = gvir_config_domain_new ();
	domain = _tmp0_;
	_tmp1_ = domain;
	_tmp2_ = name;
	gvir_config_domain_set_name (_tmp1_, _tmp2_);
	_tmp4_ = install_media;
	_tmp5_ = boxes_installer_media_get_live (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		_tmp3_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
	} else {
		_tmp3_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
	}
	_tmp7_ = _tmp3_;
	_tmp8_ = g_strdup (_tmp7_);
	xml = _tmp8_;
	{
		GVirConfigDomain* _tmp9_;
		_tmp9_ = domain;
		gvir_config_domain_set_custom_xml (_tmp9_, xml, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		_g_free0 (xml);
		_g_object_unref0 (domain);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = domain;
	_tmp11_ = install_media;
	_tmp12_ = _tmp11_->resources;
	_tmp13_ = osinfo_resources_get_ram (_tmp12_);
	_tmp14_ = _tmp13_;
	gvir_config_domain_set_memory (_tmp10_, (guint64) (_tmp14_ / OSINFO_KIBIBYTES));
	_tmp15_ = domain;
	_tmp16_ = install_media;
	_tmp17_ = _tmp16_->resources;
	_tmp18_ = osinfo_resources_get_n_cpus (_tmp17_);
	_tmp19_ = _tmp18_;
	g_object_set (_tmp15_, "vcpu", (guint64) _tmp19_, NULL);
	_tmp20_ = domain;
	gvir_config_domain_set_virt_type (_tmp20_, GVIR_CONFIG_DOMAIN_VIRT_KVM);
	_tmp21_ = domain;
	_tmp22_ = install_media;
	boxes_vm_configurator_set_os_config (self, _tmp21_, _tmp22_);
	_tmp23_ = domain;
	_tmp24_ = g_strdup ("acpi");
	_tmp25_ = g_strdup ("apic");
	_tmp26_ = g_strdup ("pae");
	_tmp27_ = g_new0 (gchar*, 3 + 1);
	_tmp27_[0] = _tmp24_;
	_tmp27_[1] = _tmp25_;
	_tmp27_[2] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 3;
	gvir_config_domain_set_features (_tmp23_, _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = gvir_config_domain_clock_new ();
	clock = _tmp29_;
	_tmp31_ = install_media;
	_tmp32_ = _tmp31_->os;
	if (_tmp32_ != NULL) {
		BoxesInstallerMedia* _tmp33_;
		OsinfoOs* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gboolean _tmp37_ = FALSE;
		_tmp33_ = install_media;
		_tmp34_ = _tmp33_->os;
		_tmp35_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = string_contains (_tmp36_, "win");
		_tmp30_ = _tmp37_;
	} else {
		_tmp30_ = FALSE;
	}
	_tmp38_ = _tmp30_;
	if (_tmp38_) {
		GVirConfigDomainClock* _tmp39_;
		_tmp39_ = clock;
		gvir_config_domain_clock_set_offset (_tmp39_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
	} else {
		GVirConfigDomainClock* _tmp40_;
		_tmp40_ = clock;
		gvir_config_domain_clock_set_offset (_tmp40_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
	}
	_tmp41_ = domain;
	_tmp42_ = clock;
	gvir_config_domain_set_clock (_tmp41_, _tmp42_);
	_tmp43_ = domain;
	_tmp44_ = target_path;
	boxes_vm_configurator_set_target_media_config (self, _tmp43_, _tmp44_);
	_tmp45_ = domain;
	_tmp46_ = install_media;
	boxes_vm_configurator_set_unattended_disk_config (self, _tmp45_, _tmp46_);
	_tmp47_ = domain;
	_tmp48_ = install_media;
	boxes_vm_configurator_set_source_media_config (self, _tmp47_, _tmp48_);
	_tmp49_ = gvir_config_domain_graphics_spice_new ();
	graphics = _tmp49_;
	_tmp50_ = graphics;
	gvir_config_domain_graphics_spice_set_autoport (_tmp50_, TRUE);
	_tmp51_ = install_media;
	if (BOXES_IS_UNATTENDED_INSTALLER (_tmp51_)) {
		BoxesInstallerMedia* _tmp52_;
		BoxesUnattendedInstaller* _tmp53_;
		BoxesUnattendedInstaller* unattended;
		gboolean _tmp54_ = FALSE;
		BoxesUnattendedInstaller* _tmp55_;
		gboolean _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp62_;
		_tmp52_ = install_media;
		_tmp53_ = _g_object_ref0 (BOXES_IS_UNATTENDED_INSTALLER (_tmp52_) ? ((BoxesUnattendedInstaller*) _tmp52_) : NULL);
		unattended = _tmp53_;
		_tmp55_ = unattended;
		_tmp56_ = boxes_unattended_installer_get_express_install (_tmp55_);
		_tmp57_ = _tmp56_;
		if (_tmp57_) {
			BoxesUnattendedInstaller* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp58_ = unattended;
			_tmp59_ = boxes_unattended_installer_get_password (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = _tmp60_;
			_tmp54_ = g_strcmp0 (_tmp61_, "") != 0;
			_g_free0 (_tmp61_);
		} else {
			_tmp54_ = FALSE;
		}
		_tmp62_ = _tmp54_;
		if (_tmp62_) {
			GVirConfigDomainGraphicsSpice* _tmp63_;
			BoxesUnattendedInstaller* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp63_ = graphics;
			_tmp64_ = unattended;
			_tmp65_ = boxes_unattended_installer_get_password (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = _tmp66_;
			gvir_config_domain_graphics_spice_set_password (_tmp63_, _tmp67_);
			_g_free0 (_tmp67_);
		}
		_g_object_unref0 (unattended);
	}
	_tmp68_ = domain;
	_tmp69_ = graphics;
	gvir_config_domain_add_device (_tmp68_, (GVirConfigDomainDevice*) _tmp69_);
	_tmp70_ = domain;
	_tmp71_ = install_media;
	boxes_vm_configurator_set_video_config (self, _tmp70_, _tmp71_);
	_tmp72_ = domain;
	_tmp73_ = install_media;
	boxes_vm_configurator_set_sound_config (self, _tmp72_, _tmp73_);
	_tmp74_ = domain;
	_tmp75_ = install_media;
	boxes_vm_configurator_set_tablet_config (self, _tmp74_, _tmp75_);
	_tmp76_ = domain;
	gvir_config_domain_set_lifecycle (_tmp76_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp77_ = domain;
	gvir_config_domain_set_lifecycle (_tmp77_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp78_ = domain;
	gvir_config_domain_set_lifecycle (_tmp78_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
	_tmp79_ = gvir_config_domain_console_new ();
	console = _tmp79_;
	_tmp80_ = gvir_config_domain_chardev_source_pty_new ();
	_tmp81_ = _tmp80_;
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) console, (GVirConfigDomainChardevSource*) _tmp81_);
	_g_object_unref0 (_tmp81_);
	_tmp82_ = domain;
	gvir_config_domain_add_device (_tmp82_, (GVirConfigDomainDevice*) console);
	_tmp83_ = gvir_config_domain_interface_user_new ();
	iface = _tmp83_;
	_tmp84_ = domain;
	gvir_config_domain_add_device (_tmp84_, (GVirConfigDomainDevice*) iface);
	result = domain;
	_g_object_unref0 (iface);
	_g_object_unref0 (console);
	_g_object_unref0 (graphics);
	_g_object_unref0 (clock);
	_g_free0 (xml);
	return result;
}


void boxes_vm_configurator_post_install_setup (BoxesVMConfigurator* self, GVirConfigDomain* domain) {
	GVirConfigDomain* _tmp1_;
	GVirConfigDomain* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	{
		GVirConfigDomain* _tmp0_;
		_tmp0_ = domain;
		gvir_config_domain_set_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_INSTALLED_XML, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = domain;
	boxes_vm_configurator_set_os_config (self, _tmp1_, NULL);
	_tmp2_ = domain;
	gvir_config_domain_set_lifecycle (_tmp2_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
}


gboolean boxes_vm_configurator_is_install_config (BoxesVMConfigurator* self, GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = domain;
	_tmp1_ = boxes_vm_configurator_get_os_state (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean boxes_vm_configurator_is_live_config (BoxesVMConfigurator* self, GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = domain;
	_tmp1_ = boxes_vm_configurator_get_os_state (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (BoxesVMConfigurator* self, const gchar* name, gint64 storage, GError** error) {
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* _tmp0_;
	GVirConfigStorageVol* volume;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	GVirConfigStorageVolTarget* _tmp3_;
	GVirConfigStorageVolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gvir_config_storage_vol_new ();
	volume = _tmp0_;
	_tmp1_ = name;
	gvir_config_storage_vol_set_name (volume, _tmp1_);
	_tmp2_ = storage;
	gvir_config_storage_vol_set_capacity (volume, (guint64) _tmp2_);
	_tmp3_ = gvir_config_storage_vol_target_new ();
	target = _tmp3_;
	gvir_config_storage_vol_target_set_format (target, "qcow2");
	_tmp4_ = boxes_vm_configurator_get_default_permissions (self);
	permissions = _tmp4_;
	gvir_config_storage_vol_target_set_permissions (target, permissions);
	gvir_config_storage_vol_set_target (volume, target);
	result = volume;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	return result;
}


GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (BoxesVMConfigurator* self, GError** error) {
	GVirConfigStoragePool* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* pool_path;
	GVirConfigStoragePool* _tmp1_;
	GVirConfigStoragePool* pool;
	GVirConfigStoragePoolSource* _tmp2_;
	GVirConfigStoragePoolSource* source;
	GVirConfigStoragePoolTarget* _tmp3_;
	GVirConfigStoragePoolTarget* target;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
	GVirConfigStoragePermissions* permissions;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = boxes_get_user_pkgdata ("images");
	pool_path = _tmp0_;
	boxes_ensure_directory (pool_path);
	_tmp1_ = gvir_config_storage_pool_new ();
	pool = _tmp1_;
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
	_tmp2_ = gvir_config_storage_pool_source_new ();
	source = _tmp2_;
	gvir_config_storage_pool_source_set_directory (source, pool_path);
	gvir_config_storage_pool_set_source (pool, source);
	_tmp3_ = gvir_config_storage_pool_target_new ();
	target = _tmp3_;
	gvir_config_storage_pool_target_set_path (target, pool_path);
	_tmp4_ = boxes_vm_configurator_get_default_permissions (self);
	permissions = _tmp4_;
	gvir_config_storage_pool_target_set_permissions (target, permissions);
	gvir_config_storage_pool_set_target (pool, target);
	result = pool;
	_g_object_unref0 (permissions);
	_g_object_unref0 (target);
	_g_object_unref0 (source);
	_g_free0 (pool_path);
	return result;
}


static void boxes_vm_configurator_set_target_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, const gchar* target_path) {
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* disk;
	const gchar* _tmp1_;
	GVirConfigDomain* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (target_path != NULL);
	_tmp0_ = gvir_config_domain_disk_new ();
	disk = _tmp0_;
	gvir_config_domain_disk_set_type (disk, GVIR_CONFIG_DOMAIN_DISK_FILE);
	gvir_config_domain_disk_set_guest_device_type (disk, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
	gvir_config_domain_disk_set_driver_name (disk, "qemu");
	gvir_config_domain_disk_set_driver_type (disk, "qcow2");
	_tmp1_ = target_path;
	gvir_config_domain_disk_set_source (disk, _tmp1_);
	gvir_config_domain_disk_set_target_dev (disk, "hda");
	gvir_config_domain_disk_set_target_bus (disk, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
	_tmp2_ = domain;
	gvir_config_domain_add_device (_tmp2_, (GVirConfigDomainDevice*) disk);
	_g_object_unref0 (disk);
}


static void boxes_vm_configurator_set_source_media_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainDisk* _tmp0_;
	GVirConfigDomainDisk* disk;
	GVirConfigDomainDisk* _tmp1_;
	GVirConfigDomainDisk* _tmp2_;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomainDisk* _tmp4_;
	BoxesInstallerMedia* _tmp5_;
	const gchar* _tmp6_;
	GVirConfigDomainDisk* _tmp7_;
	GVirConfigDomainDisk* _tmp8_;
	BoxesInstallerMedia* _tmp9_;
	gboolean _tmp10_;
	GVirConfigDomain* _tmp13_;
	GVirConfigDomainDisk* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = gvir_config_domain_disk_new ();
	disk = _tmp0_;
	_tmp1_ = disk;
	gvir_config_domain_disk_set_guest_device_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_CDROM);
	_tmp2_ = disk;
	gvir_config_domain_disk_set_driver_name (_tmp2_, "qemu");
	_tmp3_ = disk;
	gvir_config_domain_disk_set_driver_type (_tmp3_, "raw");
	_tmp4_ = disk;
	_tmp5_ = install_media;
	_tmp6_ = _tmp5_->device_file;
	gvir_config_domain_disk_set_source (_tmp4_, _tmp6_);
	_tmp7_ = disk;
	gvir_config_domain_disk_set_target_dev (_tmp7_, "hdc");
	_tmp8_ = disk;
	gvir_config_domain_disk_set_target_bus (_tmp8_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
	_tmp9_ = install_media;
	_tmp10_ = _tmp9_->from_image;
	if (_tmp10_) {
		GVirConfigDomainDisk* _tmp11_;
		_tmp11_ = disk;
		gvir_config_domain_disk_set_type (_tmp11_, GVIR_CONFIG_DOMAIN_DISK_FILE);
	} else {
		GVirConfigDomainDisk* _tmp12_;
		_tmp12_ = disk;
		gvir_config_domain_disk_set_type (_tmp12_, GVIR_CONFIG_DOMAIN_DISK_BLOCK);
	}
	_tmp13_ = domain;
	_tmp14_ = disk;
	gvir_config_domain_add_device (_tmp13_, (GVirConfigDomainDevice*) _tmp14_);
	_g_object_unref0 (disk);
}


static void boxes_vm_configurator_set_unattended_disk_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	GVirConfigDomainDisk* _tmp2_ = NULL;
	GVirConfigDomainDisk* disk;
	GVirConfigDomainDisk* _tmp3_;
	GVirConfigDomain* _tmp4_;
	GVirConfigDomainDisk* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	if (!BOXES_IS_UNATTENDED_INSTALLER (_tmp0_)) {
		return;
	}
	_tmp1_ = install_media;
	_tmp2_ = boxes_unattended_installer_get_unattended_disk_config (BOXES_IS_UNATTENDED_INSTALLER (_tmp1_) ? ((BoxesUnattendedInstaller*) _tmp1_) : NULL);
	disk = _tmp2_;
	_tmp3_ = disk;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (disk);
		return;
	}
	_tmp4_ = domain;
	_tmp5_ = disk;
	gvir_config_domain_add_device (_tmp4_, (GVirConfigDomainDevice*) _tmp5_);
	_g_object_unref0 (disk);
}


static void boxes_vm_configurator_set_os_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainOs* _tmp0_;
	GVirConfigDomainOs* os;
	GVirConfigDomainOs* _tmp1_;
	GVirConfigDomainOs* _tmp2_;
	GList* boot_devices;
	BoxesInstallerMedia* _tmp3_;
	GVirConfigDomainOs* _tmp6_;
	GList* _tmp7_;
	GVirConfigDomain* _tmp8_;
	GVirConfigDomainOs* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	_tmp0_ = gvir_config_domain_os_new ();
	os = _tmp0_;
	_tmp1_ = os;
	gvir_config_domain_os_set_os_type (_tmp1_, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
	_tmp2_ = os;
	gvir_config_domain_os_set_arch (_tmp2_, "x86_64");
	boot_devices = NULL;
	_tmp3_ = install_media;
	if (_tmp3_ != NULL) {
		GVirConfigDomainOs* _tmp4_;
		BoxesInstallerMedia* _tmp5_;
		_tmp4_ = os;
		_tmp5_ = install_media;
		boxes_vm_configurator_set_direct_boot_params (self, _tmp4_, _tmp5_);
		boot_devices = g_list_append (boot_devices, GINT_TO_POINTER (GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
	}
	boot_devices = g_list_append (boot_devices, GINT_TO_POINTER (GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
	_tmp6_ = os;
	_tmp7_ = boot_devices;
	gvir_config_domain_os_set_boot_devices (_tmp6_, _tmp7_);
	_tmp8_ = domain;
	_tmp9_ = os;
	gvir_config_domain_set_os (_tmp8_, _tmp9_);
	_g_list_free0 (boot_devices);
	_g_object_unref0 (os);
}


static void boxes_vm_configurator_set_direct_boot_params (BoxesVMConfigurator* self, GVirConfigDomainOs* os, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	GVirConfigDomainOs* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	if (!BOXES_IS_UNATTENDED_INSTALLER (_tmp0_)) {
		return;
	}
	_tmp1_ = install_media;
	_tmp2_ = os;
	boxes_unattended_installer_set_direct_boot_params (BOXES_IS_UNATTENDED_INSTALLER (_tmp1_) ? ((BoxesUnattendedInstaller*) _tmp1_) : NULL, _tmp2_);
}


static void boxes_vm_configurator_set_video_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	OsinfoDevice* _tmp2_ = NULL;
	OsinfoDevice* device;
	OsinfoDevice* _tmp3_;
	GVirConfigDomainVideo* _tmp4_;
	GVirConfigDomainVideo* video;
	OsinfoDevice* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint model;
	gint _tmp8_;
	GVirConfigDomainVideo* _tmp9_;
	gint _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomainVideo* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	_tmp1_ = _tmp0_->os;
	_tmp2_ = boxes_get_os_device_by_prop (_tmp1_, OSINFO_DEVICE_PROP_CLASS, "video");
	device = _tmp2_;
	_tmp3_ = device;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp4_ = gvir_config_domain_video_new ();
	video = _tmp4_;
	_tmp5_ = device;
	_tmp6_ = osinfo_device_get_name (_tmp5_);
	_tmp7_ = boxes_get_enum_value (_tmp6_, GVIR_CONFIG_TYPE_DOMAIN_VIDEO_MODEL);
	model = _tmp7_;
	_tmp8_ = model;
	g_return_if_fail (_tmp8_ != (-1));
	_tmp9_ = video;
	_tmp10_ = model;
	gvir_config_domain_video_set_model (_tmp9_, (GVirConfigDomainVideoModel) _tmp10_);
	_tmp11_ = domain;
	_tmp12_ = video;
	gvir_config_domain_add_device (_tmp11_, (GVirConfigDomainDevice*) _tmp12_);
	_g_object_unref0 (video);
	_g_object_unref0 (device);
}


static void boxes_vm_configurator_set_sound_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	OsinfoDevice* _tmp2_ = NULL;
	OsinfoDevice* device;
	OsinfoDevice* _tmp3_;
	GVirConfigDomainSound* _tmp4_;
	GVirConfigDomainSound* sound;
	OsinfoDevice* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint model;
	gint _tmp8_;
	GVirConfigDomainSound* _tmp9_;
	gint _tmp10_;
	GVirConfigDomain* _tmp11_;
	GVirConfigDomainSound* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	_tmp1_ = _tmp0_->os;
	_tmp2_ = boxes_get_os_device_by_prop (_tmp1_, OSINFO_DEVICE_PROP_CLASS, "audio");
	device = _tmp2_;
	_tmp3_ = device;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp4_ = gvir_config_domain_sound_new ();
	sound = _tmp4_;
	_tmp5_ = device;
	_tmp6_ = osinfo_device_get_name (_tmp5_);
	_tmp7_ = boxes_get_enum_value (_tmp6_, GVIR_CONFIG_TYPE_DOMAIN_SOUND_MODEL);
	model = _tmp7_;
	_tmp8_ = model;
	g_return_if_fail (_tmp8_ != (-1));
	_tmp9_ = sound;
	_tmp10_ = model;
	gvir_config_domain_sound_set_model (_tmp9_, (GVirConfigDomainSoundModel) _tmp10_);
	_tmp11_ = domain;
	_tmp12_ = sound;
	gvir_config_domain_add_device (_tmp11_, (GVirConfigDomainDevice*) _tmp12_);
	_g_object_unref0 (sound);
	_g_object_unref0 (device);
}


static void boxes_vm_configurator_set_tablet_config (BoxesVMConfigurator* self, GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	BoxesInstallerMedia* _tmp0_;
	OsinfoOs* _tmp1_;
	OsinfoDevice* _tmp2_ = NULL;
	OsinfoDevice* device;
	OsinfoDevice* _tmp3_;
	GVirConfigDomainInput* _tmp4_;
	GVirConfigDomainInput* input;
	OsinfoDevice* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint bus;
	gint _tmp8_;
	GVirConfigDomainInput* _tmp9_;
	gint _tmp10_;
	GVirConfigDomainInput* _tmp11_;
	GVirConfigDomain* _tmp12_;
	GVirConfigDomainInput* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	g_return_if_fail (install_media != NULL);
	_tmp0_ = install_media;
	_tmp1_ = _tmp0_->os;
	_tmp2_ = boxes_get_os_device_by_prop (_tmp1_, OSINFO_DEVICE_PROP_NAME, "tablet");
	device = _tmp2_;
	_tmp3_ = device;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp4_ = gvir_config_domain_input_new ();
	input = _tmp4_;
	_tmp5_ = device;
	_tmp6_ = osinfo_device_get_bus_type (_tmp5_);
	_tmp7_ = boxes_get_enum_value (_tmp6_, GVIR_CONFIG_TYPE_DOMAIN_INPUT_BUS);
	bus = _tmp7_;
	_tmp8_ = bus;
	g_return_if_fail (_tmp8_ != (-1));
	_tmp9_ = input;
	_tmp10_ = bus;
	gvir_config_domain_input_set_bus (_tmp9_, (GVirConfigDomainInputBus) _tmp10_);
	_tmp11_ = input;
	gvir_config_domain_input_set_device_type (_tmp11_, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
	_tmp12_ = domain;
	_tmp13_ = input;
	gvir_config_domain_add_device (_tmp12_, (GVirConfigDomainDevice*) _tmp13_);
	_g_object_unref0 (input);
	_g_object_unref0 (device);
}


static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (BoxesVMConfigurator* self) {
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* _tmp0_;
	GVirConfigStoragePermissions* permissions;
	uid_t _tmp1_ = {0};
	gid_t _tmp2_ = {0};
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gvir_config_storage_permissions_new ();
	permissions = _tmp0_;
	_tmp1_ = getuid ();
	gvir_config_storage_permissions_set_owner (permissions, (guint) _tmp1_);
	_tmp2_ = getgid ();
	gvir_config_storage_permissions_set_group (permissions, (guint) _tmp2_);
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
	result = permissions;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gchar* boxes_vm_configurator_get_os_state (BoxesVMConfigurator* self, GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* xml;
	const gchar* _tmp2_;
	GVirConfigDomain* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	_tmp0_ = domain;
	_tmp1_ = gvir_config_domain_get_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
	xml = _tmp1_;
	_tmp2_ = xml;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		xmlTextReader* _tmp9_;
		xmlTextReader* reader;
		_tmp3_ = xml;
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		_tmp6_ = xml;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = xmlReaderForMemory ((gchar*) _tmp5_, _tmp8_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, NULL, (gint) XML_PARSE_COMPACT);
		reader = _tmp9_;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				xmlTextReader* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gboolean _tmp17_;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					xmlTextReader* _tmp12_;
					gint _tmp13_ = 0;
					_tmp12_ = reader;
					_tmp13_ = xmlTextReaderNext (_tmp12_);
					if (!(_tmp13_ == 1)) {
						break;
					}
				}
				_tmp10_ = FALSE;
				_tmp14_ = reader;
				_tmp15_ = xmlTextReaderName (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strcmp0 (_tmp16_, "boxes:os-state") == 0;
				_g_free0 (_tmp16_);
				if (_tmp17_) {
					xmlTextReader* _tmp18_;
					gchar* _tmp19_ = NULL;
					_tmp18_ = reader;
					_tmp19_ = xmlTextReaderReadString (_tmp18_);
					result = _tmp19_;
					_xmlFreeTextReader0 (reader);
					_g_free0 (xml);
					return result;
				}
			}
		}
		_xmlFreeTextReader0 (reader);
	}
	_tmp20_ = domain;
	_tmp21_ = gvir_config_domain_get_name (_tmp20_);
	_tmp22_ = _tmp21_;
	g_warning ("vm-configurator.vala:250: Failed to find OS state for domain '%s'.", _tmp22_);
	_g_free0 (_tmp22_);
	result = NULL;
	_g_free0 (xml);
	return result;
}


BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type) {
	BoxesVMConfigurator* self = NULL;
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
	return self;
}


BoxesVMConfigurator* boxes_vm_configurator_new (void) {
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
}


static void boxes_value_vm_configurator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void boxes_value_vm_configurator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		boxes_vm_configurator_unref (value->data[0].v_pointer);
	}
}


static void boxes_value_vm_configurator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer boxes_value_vm_configurator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* boxes_value_vm_configurator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BoxesVMConfigurator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* boxes_value_vm_configurator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesVMConfigurator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecVMConfigurator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer boxes_value_get_vm_configurator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
	return value->data[0].v_pointer;
}


void boxes_value_set_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		boxes_vm_configurator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}


void boxes_value_take_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		boxes_vm_configurator_unref (old);
	}
}


static void boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass) {
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
	BOXES_VM_CONFIGURATOR_CLASS (klass)->finalize = boxes_vm_configurator_finalize;
}


static void boxes_vm_configurator_instance_init (BoxesVMConfigurator * self) {
	self->ref_count = 1;
}


static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj) {
	BoxesVMConfigurator * self;
	self = BOXES_VM_CONFIGURATOR (obj);
}


GType boxes_vm_configurator_get_type (void) {
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer boxes_vm_configurator_ref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void boxes_vm_configurator_unref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



