/* archive-reader.c generated by valac 0.39.5, the Vala compiler
 * generated from archive-reader.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <archive.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <archive_entry.h>
#include <libcommon.h>
#include <stdio.h>
#include <glib/gstdio.h>


#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _BoxesArchiveReaderPrivate BoxesArchiveReaderPrivate;
enum  {
	BOXES_ARCHIVE_READER_0_PROPERTY,
	BOXES_ARCHIVE_READER_NUM_PROPERTIES
};
static GParamSpec* boxes_archive_reader_properties[BOXES_ARCHIVE_READER_NUM_PROPERTIES];
#define _archive_read_finish0(var) ((var == NULL) ? NULL : (var = (archive_read_finish (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block12Data Block12Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesArchiveReader {
	GObject parent_instance;
	BoxesArchiveReaderPrivate * priv;
	struct archive* archive;
};

struct _BoxesArchiveReaderClass {
	GObjectClass parent_class;
};

struct _BoxesArchiveReaderPrivate {
	gchar* filename;
	int* format;
	GList* filters;
};

struct _Block11Data {
	int _ref_count_;
	BoxesArchiveReader* self;
	FILE* fd;
};

struct _Block12Data {
	int _ref_count_;
	BoxesArchiveReader* self;
	int filter;
};


static gpointer boxes_archive_reader_parent_class = NULL;

GType boxes_archive_reader_get_type (void) G_GNUC_CONST;
#define BOXES_ARCHIVE_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderPrivate))
#define BOXES_ARCHIVE_READER_BLOCK_SIZE 10240
BoxesArchiveReader* boxes_archive_reader_new (const gchar* filename,
                                              int* format,
                                              GList* filters,
                                              GError** error);
BoxesArchiveReader* boxes_archive_reader_construct (GType object_type,
                                                    const gchar* filename,
                                                    int* format,
                                                    GList* filters,
                                                    GError** error);
static int* _archive_format_dup (int* self);
static void boxes_archive_reader_open_archive (BoxesArchiveReader* self,
                                        GError** error);
GList* boxes_archive_reader_get_file_list (BoxesArchiveReader* self,
                                           GError** error);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
void boxes_archive_reader_extract_file (BoxesArchiveReader* self,
                                        const gchar* src,
                                        const gchar* dest,
                                        gboolean override_if_necessary,
                                        GError** error);
static void boxes_archive_reader_extract_files_recursive (BoxesArchiveReader* self,
                                                   gchar** src_list,
                                                   int src_list_length1,
                                                   gchar** dest_list,
                                                   int dest_list_length1,
                                                   gboolean override_if_necessary,
                                                   gboolean follow_hardlinks,
                                                   GError** error);
void boxes_archive_reader_reset (BoxesArchiveReader* self,
                                 GError** error);
static int _archive_read_close_boxes_libarchive_function (gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gchar* boxes_archive_reader_get_dest_file (BoxesArchiveReader* self,
                                           gchar** src_list,
                                           int src_list_length1,
                                           gchar** dest_list,
                                           int dest_list_length1,
                                           const gchar* src);
static int _archive_read_data_skip_boxes_libarchive_function (gpointer self);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static int ___lambda34_ (Block11Data* _data11_);
static int ____lambda34__boxes_libarchive_function (gpointer self);
static int _archive_read_support_format_all_boxes_libarchive_function (gpointer self);
static int ___lambda31_ (BoxesArchiveReader* self);
static int ____lambda31__boxes_libarchive_function (gpointer self);
static int _archive_read_support_filter_all_boxes_libarchive_function (gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static int _____lambda32_ (Block12Data* _data12_);
static int ______lambda32__boxes_libarchive_function (gpointer self);
static int __lambda33_ (BoxesArchiveReader* self);
static int ___lambda33__boxes_libarchive_function (gpointer self);
static void boxes_archive_reader_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static int*
_archive_format_dup (int* self)
{
	int* dup;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	dup = g_new0 (int, 1);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	memcpy (dup, self, sizeof (int));
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return dup;
#line 161 "archive-reader.c"
}


static gpointer
__archive_format_dup0 (gpointer self)
{
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return self ? _archive_format_dup (self) : NULL;
#line 170 "archive-reader.c"
}


BoxesArchiveReader*
boxes_archive_reader_construct (GType object_type,
                                const gchar* filename,
                                int* format,
                                GList* filters,
                                GError** error)
{
	BoxesArchiveReader * self = NULL;
	gchar* _tmp0_;
	int* _tmp1_;
	GError * _inner_error_ = NULL;
#line 13 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 13 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self = (BoxesArchiveReader*) g_object_new (object_type, NULL);
#line 17 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = g_strdup (filename);
#line 17 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->filename);
#line 17 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self->priv->filename = _tmp0_;
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = __archive_format_dup0 (format);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->format);
#line 18 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self->priv->format = _tmp1_;
#line 19 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (filters != NULL) {
#line 203 "archive-reader.c"
		GList* _tmp2_;
#line 20 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp2_ = g_list_copy (filters);
#line 20 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_g_list_free0 (self->priv->filters);
#line 20 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		self->priv->filters = _tmp2_;
#line 211 "archive-reader.c"
	}
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_open_archive (self, &_inner_error_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_g_object_unref0 (self);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return NULL;
#line 225 "archive-reader.c"
		} else {
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 22 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return NULL;
#line 233 "archive-reader.c"
		}
	}
#line 13 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return self;
#line 238 "archive-reader.c"
}


BoxesArchiveReader*
boxes_archive_reader_new (const gchar* filename,
                          int* format,
                          GList* filters,
                          GError** error)
{
#line 13 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return boxes_archive_reader_construct (BOXES_TYPE_ARCHIVE_READER, filename, format, filters, error);
#line 250 "archive-reader.c"
}


static void
_g_free0_ (gpointer var)
{
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	var = (g_free (var), NULL);
#line 259 "archive-reader.c"
}


static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 268 "archive-reader.c"
}


GList*
boxes_archive_reader_get_file_list (BoxesArchiveReader* self,
                                    GError** error)
{
	GList* result = NULL;
	GList* _result_ = NULL;
	struct archive_entry* iterator = NULL;
	GError * _inner_error_ = NULL;
#line 25 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_result_ = NULL;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	while (TRUE) {
#line 286 "archive-reader.c"
		gboolean _tmp0_ = FALSE;
		struct archive* _tmp1_;
		struct archive_entry* _tmp2_ = NULL;
		gboolean _tmp3_;
		struct archive_entry* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp1_ = self->archive;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp3_ = boxes_get_next_header (_tmp1_, &_tmp2_, (guint) 1, &_inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		iterator = _tmp2_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp0_ = _tmp3_;
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				__g_list_free__g_free0_0 (_result_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return NULL;
#line 312 "archive-reader.c"
			} else {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				__g_list_free__g_free0_0 (_result_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return NULL;
#line 322 "archive-reader.c"
			}
		}
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (!_tmp0_) {
#line 28 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			break;
#line 329 "archive-reader.c"
		}
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp4_ = iterator;
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp5_ = archive_entry_pathname (_tmp4_);
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 29 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_result_ = g_list_append (_result_, _tmp6_);
#line 339 "archive-reader.c"
	}
#line 31 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	result = _result_;
#line 31 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 345 "archive-reader.c"
}


void
boxes_archive_reader_extract_file (BoxesArchiveReader* self,
                                   const gchar* src,
                                   const gchar* dest,
                                   gboolean override_if_necessary,
                                   GError** error)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (src != NULL);
#line 35 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (dest != NULL);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = g_strdup (src);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_[0] = _tmp0_;
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = _tmp1_;
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp2__length1 = 1;
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp3_ = g_strdup (dest);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp4_ = g_new0 (gchar*, 1 + 1);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp4_[0] = _tmp3_;
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp5_ = _tmp4_;
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp5__length1 = 1;
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_extract_files_recursive (self, _tmp2_, 1, _tmp5_, 1, override_if_necessary, TRUE, &_inner_error_);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 405 "archive-reader.c"
		} else {
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 39 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 413 "archive-reader.c"
		}
	}
}


static int
_archive_read_close_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_close ((struct archive*) self);
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 426 "archive-reader.c"
}


void
boxes_archive_reader_reset (BoxesArchiveReader* self,
                            GError** error)
{
	struct archive* _tmp0_;
	struct archive* _tmp1_;
	GError * _inner_error_ = NULL;
#line 42 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->archive;
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_execute_libarchive_function (_tmp0_, _archive_read_close_boxes_libarchive_function, _tmp1_, (guint) 1, &_inner_error_);
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 453 "archive-reader.c"
		} else {
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 43 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 461 "archive-reader.c"
		}
	}
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_open_archive (self, &_inner_error_);
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 474 "archive-reader.c"
		} else {
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 482 "archive-reader.c"
		}
	}
}


static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return _data11_;
#line 495 "archive-reader.c"
}


static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 506 "archive-reader.c"
		BoxesArchiveReader* self;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		self = _data11_->self;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_fclose0 (_data11_->fd);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_g_object_unref0 (self);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		g_slice_free (Block11Data, _data11_);
#line 516 "archive-reader.c"
	}
}


static int
_archive_read_data_skip_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_data_skip ((struct archive*) self);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 528 "archive-reader.c"
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if ((*length) == (*size)) {
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 544 "archive-reader.c"
	}
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	(*array)[(*length)++] = value;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	(*array)[*length] = NULL;
#line 550 "archive-reader.c"
}


static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if ((*length) == (*size)) {
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 566 "archive-reader.c"
	}
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	(*array)[(*length)++] = value;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	(*array)[*length] = NULL;
#line 572 "archive-reader.c"
}


static int
___lambda34_ (Block11Data* _data11_)
{
	BoxesArchiveReader* self;
	int result = 0;
	struct archive* _tmp0_;
	FILE* _tmp1_;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self = _data11_->self;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = _data11_->fd;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	result = archive_read_data_into_fd (_tmp0_, fileno (_tmp1_));
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 593 "archive-reader.c"
}


static int
____lambda34__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda34_ (self);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 604 "archive-reader.c"
}


static void
boxes_archive_reader_extract_files_recursive (BoxesArchiveReader* self,
                                              gchar** src_list,
                                              int src_list_length1,
                                              gchar** dest_list,
                                              int dest_list_length1,
                                              gboolean override_if_necessary,
                                              gboolean follow_hardlinks,
                                              GError** error)
{
	struct archive_entry* iterator = NULL;
	guint i = 0U;
	gchar** hardlink_src = NULL;
	gchar** _tmp0_;
	gint hardlink_src_length1;
	gint _hardlink_src_size_;
	gchar** hardlink_dest = NULL;
	gchar** _tmp1_;
	gint hardlink_dest_length1;
	gint _hardlink_dest_size_;
	guint _tmp40_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	GError * _inner_error_ = NULL;
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_vala_return_if_fail (src_list_length1 == dest_list_length1, "src_list.length == dest_list.length");
#line 53 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (src_list_length1 == 0) {
#line 54 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		return;
#line 640 "archive-reader.c"
	}
#line 57 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	i = (guint) 0;
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	hardlink_src = _tmp0_;
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	hardlink_src_length1 = 0;
#line 58 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_hardlink_src_size_ = hardlink_src_length1;
#line 59 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = g_new0 (gchar*, 0 + 1);
#line 59 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	hardlink_dest = _tmp1_;
#line 59 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	hardlink_dest_length1 = 0;
#line 59 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_hardlink_dest_size_ = hardlink_dest_length1;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	while (TRUE) {
#line 662 "archive-reader.c"
		Block11Data* _data11_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		struct archive* _tmp4_;
		struct archive_entry* _tmp5_ = NULL;
		gboolean _tmp6_;
		gchar* dest = NULL;
		struct archive_entry* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp14_ = FALSE;
		struct archive_entry* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp34_;
		FILE* _tmp35_;
		struct archive* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		guint _tmp39_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_data11_ = g_slice_new0 (Block11Data);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_data11_->_ref_count_ = 1;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_data11_->self = g_object_ref (self);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp4_ = self->archive;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = boxes_get_next_header (_tmp4_, &_tmp5_, (guint) 1, &_inner_error_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		iterator = _tmp5_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp3_ = _tmp6_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				block11_data_unref (_data11_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_data11_ = NULL;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 714 "archive-reader.c"
			} else {
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				block11_data_unref (_data11_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_data11_ = NULL;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 730 "archive-reader.c"
			}
		}
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_tmp3_) {
#line 735 "archive-reader.c"
			guint _tmp7_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp7_ = i;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp2_ = _tmp7_ < ((guint) src_list_length1);
#line 741 "archive-reader.c"
		} else {
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp2_ = FALSE;
#line 745 "archive-reader.c"
		}
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (!_tmp2_) {
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			block11_data_unref (_data11_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_data11_ = NULL;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			break;
#line 755 "archive-reader.c"
		}
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp8_ = iterator;
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp9_ = archive_entry_pathname (_tmp8_);
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp10_ = boxes_archive_reader_get_dest_file (self, src_list, src_list_length1, dest_list, dest_list_length1, _tmp9_);
#line 62 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		dest = _tmp10_;
#line 64 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp11_ = dest;
#line 64 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_tmp11_ == NULL) {
#line 769 "archive-reader.c"
			struct archive* _tmp12_;
			struct archive* _tmp13_;
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp12_ = self->archive;
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp13_ = self->archive;
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			boxes_execute_libarchive_function (_tmp12_, _archive_read_data_skip_boxes_libarchive_function, _tmp13_, (guint) 1, &_inner_error_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					g_propagate_error (error, _inner_error_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_g_free0 (dest);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					block11_data_unref (_data11_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data11_ = NULL;
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					return;
#line 796 "archive-reader.c"
				} else {
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_g_free0 (dest);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					block11_data_unref (_data11_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data11_ = NULL;
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					g_clear_error (&_inner_error_);
#line 66 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					return;
#line 814 "archive-reader.c"
				}
			}
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_g_free0 (dest);
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			block11_data_unref (_data11_);
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_data11_ = NULL;
#line 68 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			continue;
#line 825 "archive-reader.c"
		}
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp15_ = iterator;
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp16_ = archive_entry_hardlink (_tmp15_);
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_tmp16_ != NULL) {
#line 833 "archive-reader.c"
			struct archive_entry* _tmp17_;
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp17_ = iterator;
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp14_ = archive_entry_size (_tmp17_) == ((gint64) 0);
#line 839 "archive-reader.c"
		} else {
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp14_ = FALSE;
#line 843 "archive-reader.c"
		}
#line 71 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_tmp14_) {
#line 847 "archive-reader.c"
			struct archive_entry* _tmp18_;
			const gchar* _tmp19_;
			struct archive_entry* _tmp20_;
			const gchar* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			struct archive_entry* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			guint _tmp29_;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp18_ = iterator;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp19_ = archive_entry_pathname (_tmp18_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp20_ = iterator;
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp21_ = archive_entry_hardlink (_tmp20_);
#line 72 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_debug ("archive-reader.vala:72: Following hardlink of '%s' to '%s'.", _tmp19_, _tmp21_);
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp22_ = hardlink_src;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp22__length1 = hardlink_src_length1;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp23_ = iterator;
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp24_ = archive_entry_hardlink (_tmp23_);
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp25_ = g_strdup (_tmp24_);
#line 73 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_vala_array_add1 (&hardlink_src, &hardlink_src_length1, &_hardlink_src_size_, _tmp25_);
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp26_ = hardlink_dest;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp26__length1 = hardlink_dest_length1;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp27_ = dest;
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 74 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_vala_array_add2 (&hardlink_dest, &hardlink_dest_length1, &_hardlink_dest_size_, _tmp28_);
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp29_ = i;
#line 75 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			i = _tmp29_ + 1;
#line 77 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_g_free0 (dest);
#line 77 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			block11_data_unref (_data11_);
#line 77 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_data11_ = NULL;
#line 77 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			continue;
#line 906 "archive-reader.c"
		}
#line 80 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (!override_if_necessary) {
#line 910 "archive-reader.c"
			const gchar* _tmp31_;
#line 80 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp31_ = dest;
#line 80 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp30_ = g_file_test (_tmp31_, G_FILE_TEST_EXISTS);
#line 916 "archive-reader.c"
		} else {
#line 80 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp30_ = FALSE;
#line 920 "archive-reader.c"
		}
#line 80 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_tmp30_) {
#line 924 "archive-reader.c"
			const gchar* _tmp32_;
			GError* _tmp33_;
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp32_ = dest;
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp33_ = g_error_new (G_IO_ERROR, G_IO_ERROR_EXISTS, "Destination file '%s' already exists.", _tmp32_);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_inner_error_ = _tmp33_;
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				block11_data_unref (_data11_);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_data11_ = NULL;
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 949 "archive-reader.c"
			} else {
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				block11_data_unref (_data11_);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_data11_ = NULL;
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 81 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 967 "archive-reader.c"
			}
		}
#line 84 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp34_ = dest;
#line 84 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp35_ = g_fopen (_tmp34_, "w+");
#line 84 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_data11_->fd = _tmp35_;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp36_ = self->archive;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp36_, ____lambda34__boxes_libarchive_function, _data11_, (guint) 1, &_inner_error_);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				block11_data_unref (_data11_);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_data11_ = NULL;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 998 "archive-reader.c"
			} else {
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_g_free0 (dest);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				block11_data_unref (_data11_);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_data11_ = NULL;
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 85 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1016 "archive-reader.c"
			}
		}
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp37_ = dest;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp38_ = self->priv->filename;
#line 87 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		g_debug ("archive-reader.vala:87: Extracted file '%s' from archive '%s'.", _tmp37_, _tmp38_);
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp39_ = i;
#line 88 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		i = _tmp39_ + 1;
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_g_free0 (dest);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		block11_data_unref (_data11_);
#line 61 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_data11_ = NULL;
#line 1035 "archive-reader.c"
	}
#line 91 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp40_ = i;
#line 91 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (((guint) src_list_length1) != _tmp40_) {
#line 1041 "archive-reader.c"
		GError* _tmp41_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp41_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "At least one specified file was not found in the archive.");
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_inner_error_ = _tmp41_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 1057 "archive-reader.c"
		} else {
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 92 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 1069 "archive-reader.c"
		}
	}
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_reset (self, &_inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 1086 "archive-reader.c"
		} else {
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 1098 "archive-reader.c"
		}
	}
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp42_ = hardlink_src;
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp42__length1 = hardlink_src_length1;
#line 96 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (_tmp42__length1 > 0) {
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (follow_hardlinks) {
#line 1109 "archive-reader.c"
			gchar** _tmp43_;
			gint _tmp43__length1;
			gchar** _tmp44_;
			gint _tmp44__length1;
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp43_ = hardlink_src;
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp43__length1 = hardlink_src_length1;
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp44_ = hardlink_dest;
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp44__length1 = hardlink_dest_length1;
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			boxes_archive_reader_extract_files_recursive (self, _tmp43_, _tmp43__length1, _tmp44_, _tmp44__length1, override_if_necessary, FALSE, &_inner_error_);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				if (_inner_error_->domain == G_IO_ERROR) {
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					g_propagate_error (error, _inner_error_);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					return;
#line 1136 "archive-reader.c"
				} else {
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					g_clear_error (&_inner_error_);
#line 98 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					return;
#line 1148 "archive-reader.c"
				}
			}
		} else {
			gchar* msg = NULL;
			gchar* _tmp45_;
			const gchar* _tmp46_;
			GError* _tmp47_;
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp45_ = g_strdup ("Maximum recursion depth exceeded. It is likely that a hardlink points " \
"to itself.");
#line 100 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			msg = _tmp45_;
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp46_ = msg;
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp47_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_WOULD_RECURSE, _tmp46_);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_inner_error_ = _tmp47_;
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_g_free0 (msg);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1178 "archive-reader.c"
			} else {
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_g_free0 (msg);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 102 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1192 "archive-reader.c"
			}
#line 97 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_g_free0 (msg);
#line 1196 "archive-reader.c"
		}
	}
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	hardlink_dest = (_vala_array_free (hardlink_dest, hardlink_dest_length1, (GDestroyNotify) g_free), NULL);
#line 47 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	hardlink_src = (_vala_array_free (hardlink_src, hardlink_src_length1, (GDestroyNotify) g_free), NULL);
#line 1203 "archive-reader.c"
}


static gchar*
boxes_archive_reader_get_dest_file (BoxesArchiveReader* self,
                                    gchar** src_list,
                                    int src_list_length1,
                                    gchar** dest_list,
                                    int dest_list_length1,
                                    const gchar* src)
{
	gchar* result = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 1220 "archive-reader.c"
	{
		guint j = 0U;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		j = (guint) 0;
#line 1225 "archive-reader.c"
		{
			gboolean _tmp0_ = FALSE;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			_tmp0_ = TRUE;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			while (TRUE) {
#line 1232 "archive-reader.c"
				guint _tmp2_;
				guint _tmp3_;
				const gchar* _tmp4_;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				if (!_tmp0_) {
#line 1238 "archive-reader.c"
					guint _tmp1_;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_tmp1_ = j;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					j = _tmp1_ + 1;
#line 1244 "archive-reader.c"
				}
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_tmp0_ = FALSE;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_tmp2_ = j;
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				if (!(_tmp2_ < ((guint) src_list_length1))) {
#line 108 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					break;
#line 1254 "archive-reader.c"
				}
#line 109 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_tmp3_ = j;
#line 109 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				_tmp4_ = src_list[_tmp3_];
#line 109 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				if (g_strcmp0 (_tmp4_, src) == 0) {
#line 1262 "archive-reader.c"
					guint _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_tmp5_ = j;
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_tmp6_ = dest_list[_tmp5_];
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_tmp7_ = g_strdup (_tmp6_);
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					result = _tmp7_;
#line 110 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					return result;
#line 1276 "archive-reader.c"
				}
			}
		}
	}
#line 113 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	result = NULL;
#line 113 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1285 "archive-reader.c"
}


static int
_archive_read_support_format_all_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_support_format_all ((struct archive*) self);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1296 "archive-reader.c"
}


static int
___lambda31_ (BoxesArchiveReader* self)
{
	int result = 0;
	struct archive* _tmp0_;
	int* _tmp1_;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->priv->format;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	result = archive_read_set_format (_tmp0_, *_tmp1_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1314 "archive-reader.c"
}


static int
____lambda31__boxes_libarchive_function (gpointer self)
{
	int result;
	result = ___lambda31_ ((BoxesArchiveReader*) self);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1325 "archive-reader.c"
}


static int
_archive_read_support_filter_all_boxes_libarchive_function (gpointer self)
{
	int result;
	result = archive_read_support_filter_all ((struct archive*) self);
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1336 "archive-reader.c"
}


static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return _data12_;
#line 1347 "archive-reader.c"
}


static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 1358 "archive-reader.c"
		BoxesArchiveReader* self;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		self = _data12_->self;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_g_object_unref0 (self);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		g_slice_free (Block12Data, _data12_);
#line 1366 "archive-reader.c"
	}
}


static int
_____lambda32_ (Block12Data* _data12_)
{
	BoxesArchiveReader* self;
	int result = 0;
	struct archive* _tmp0_;
	int _tmp1_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self = _data12_->self;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = _data12_->filter;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	result = archive_read_append_filter (_tmp0_, _tmp1_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1388 "archive-reader.c"
}


static int
______lambda32__boxes_libarchive_function (gpointer self)
{
	int result;
	result = _____lambda32_ (self);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1399 "archive-reader.c"
}


static int
__lambda33_ (BoxesArchiveReader* self)
{
	int result = 0;
	struct archive* _tmp0_;
	const gchar* _tmp1_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = self->archive;
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->priv->filename;
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	result = archive_read_open_filename (_tmp0_, _tmp1_, (gsize) BOXES_ARCHIVE_READER_BLOCK_SIZE);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1417 "archive-reader.c"
}


static int
___lambda33__boxes_libarchive_function (gpointer self)
{
	int result;
	result = __lambda33_ ((BoxesArchiveReader*) self);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	return result;
#line 1428 "archive-reader.c"
}


static void
boxes_archive_reader_open_archive (BoxesArchiveReader* self,
                                   GError** error)
{
	struct archive* _tmp0_;
	int* _tmp1_;
	GList* _tmp5_;
	struct archive* _tmp10_;
	GError * _inner_error_ = NULL;
#line 116 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp0_ = archive_read_new ();
#line 117 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_archive_read_finish0 (self->archive);
#line 117 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self->archive = _tmp0_;
#line 119 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp1_ = self->priv->format;
#line 119 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (_tmp1_ == NULL) {
#line 1453 "archive-reader.c"
		struct archive* _tmp2_;
		struct archive* _tmp3_;
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp2_ = self->archive;
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp3_ = self->archive;
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp2_, _archive_read_support_format_all_boxes_libarchive_function, _tmp3_, (guint) 1, &_inner_error_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1470 "archive-reader.c"
			} else {
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 120 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1478 "archive-reader.c"
			}
		}
	} else {
		struct archive* _tmp4_;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp4_ = self->archive;
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp4_, ____lambda31__boxes_libarchive_function, self, (guint) 1, &_inner_error_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1495 "archive-reader.c"
			} else {
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 122 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1503 "archive-reader.c"
			}
		}
	}
#line 124 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp5_ = self->priv->filters;
#line 124 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (_tmp5_ == NULL) {
#line 1511 "archive-reader.c"
		struct archive* _tmp6_;
		struct archive* _tmp7_;
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp6_ = self->archive;
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp7_ = self->archive;
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		boxes_execute_libarchive_function (_tmp6_, _archive_read_support_filter_all_boxes_libarchive_function, _tmp7_, (guint) 1, &_inner_error_);
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_propagate_error (error, _inner_error_);
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1528 "archive-reader.c"
			} else {
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				g_clear_error (&_inner_error_);
#line 125 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				return;
#line 1536 "archive-reader.c"
			}
		}
	} else {
		GList* _tmp8_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		_tmp8_ = self->priv->filters;
#line 1543 "archive-reader.c"
		{
			GList* filter_collection = NULL;
			GList* filter_it = NULL;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			filter_collection = _tmp8_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
#line 1551 "archive-reader.c"
				int filter = 0;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
				filter = (int) ((gintptr) filter_it->data);
#line 1555 "archive-reader.c"
				{
					Block12Data* _data12_;
					struct archive* _tmp9_;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data12_ = g_slice_new0 (Block12Data);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data12_->_ref_count_ = 1;
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data12_->self = g_object_ref (self);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data12_->filter = filter;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_tmp9_ = self->archive;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					boxes_execute_libarchive_function (_tmp9_, ______lambda32__boxes_libarchive_function, _data12_, (guint) 1, &_inner_error_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
						if (_inner_error_->domain == G_IO_ERROR) {
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							g_propagate_error (error, _inner_error_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							block12_data_unref (_data12_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							_data12_ = NULL;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							return;
#line 1583 "archive-reader.c"
						} else {
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							block12_data_unref (_data12_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							_data12_ = NULL;
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							g_clear_error (&_inner_error_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
							return;
#line 1595 "archive-reader.c"
						}
					}
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					block12_data_unref (_data12_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
					_data12_ = NULL;
#line 1602 "archive-reader.c"
				}
			}
		}
	}
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_tmp10_ = self->archive;
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_execute_libarchive_function (_tmp10_, ___lambda33__boxes_libarchive_function, self, (guint) 1, &_inner_error_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_propagate_error (error, _inner_error_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 1619 "archive-reader.c"
		} else {
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			g_clear_error (&_inner_error_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
			return;
#line 1627 "archive-reader.c"
		}
	}
}


static void
boxes_archive_reader_class_init (BoxesArchiveReaderClass * klass)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	boxes_archive_reader_parent_class = g_type_class_peek_parent (klass);
#line 3 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	g_type_class_add_private (klass, sizeof (BoxesArchiveReaderPrivate));
#line 3 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_archive_reader_finalize;
#line 1642 "archive-reader.c"
}


static void
boxes_archive_reader_instance_init (BoxesArchiveReader * self)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self->priv = BOXES_ARCHIVE_READER_GET_PRIVATE (self);
#line 1651 "archive-reader.c"
}


static void
boxes_archive_reader_finalize (GObject * obj)
{
	BoxesArchiveReader * self;
#line 3 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader);
#line 7 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_archive_read_finish0 (self->archive);
#line 9 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->filename);
#line 10 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_g_free0 (self->priv->format);
#line 11 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	_g_list_free0 (self->priv->filters);
#line 3 "/home/fborges/checkout/gnome-boxes/src/archive-reader.vala"
	G_OBJECT_CLASS (boxes_archive_reader_parent_class)->finalize (obj);
#line 1671 "archive-reader.c"
}


GType
boxes_archive_reader_get_type (void)
{
	static volatile gsize boxes_archive_reader_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_archive_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesArchiveReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_archive_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesArchiveReader), 0, (GInstanceInitFunc) boxes_archive_reader_instance_init, NULL };
		GType boxes_archive_reader_type_id;
		boxes_archive_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesArchiveReader", &g_define_type_info, 0);
		g_once_init_leave (&boxes_archive_reader_type_id__volatile, boxes_archive_reader_type_id);
	}
	return boxes_archive_reader_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



