/* vm-configurator.c generated by valac 0.22.0.39-4730, the Vala compiler
 * generated from vm-configurator.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <libcommon.h>
#include <gtk/gtk.h>
#include <osinfo/osinfo.h>
#include <config.h>
#include <unistd.h>
#include <libxml/xmlreader.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_VM_CONFIGURATOR (boxes_vm_configurator_get_type ())
#define BOXES_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator))
#define BOXES_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))
#define BOXES_IS_VM_CONFIGURATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_IS_VM_CONFIGURATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CONFIGURATOR))
#define BOXES_VM_CONFIGURATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfiguratorClass))

typedef struct _BoxesVMConfigurator BoxesVMConfigurator;
typedef struct _BoxesVMConfiguratorClass BoxesVMConfiguratorClass;
typedef struct _BoxesVMConfiguratorPrivate BoxesVMConfiguratorPrivate;

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))

#define BOXES_TYPE_INSTALLED_MEDIA (boxes_installed_media_get_type ())
#define BOXES_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMedia))
#define BOXES_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))
#define BOXES_IS_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_IS_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_INSTALLED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))

typedef struct _BoxesInstalledMedia BoxesInstalledMedia;
typedef struct _BoxesInstalledMediaClass BoxesInstalledMediaClass;

#define BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA (boxes_libvirt_system_media_get_type ())
#define BOXES_LIBVIRT_SYSTEM_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA, BoxesLibvirtSystemMedia))
#define BOXES_LIBVIRT_SYSTEM_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA, BoxesLibvirtSystemMediaClass))
#define BOXES_IS_LIBVIRT_SYSTEM_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA))
#define BOXES_IS_LIBVIRT_SYSTEM_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA))
#define BOXES_LIBVIRT_SYSTEM_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA, BoxesLibvirtSystemMediaClass))

typedef struct _BoxesLibvirtSystemMedia BoxesLibvirtSystemMedia;
typedef struct _BoxesLibvirtSystemMediaClass BoxesLibvirtSystemMediaClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _BoxesParamSpecVMConfigurator BoxesParamSpecVMConfigurator;

typedef enum  {
	BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS
} BoxesVMConfiguratorError;
#define BOXES_VM_CONFIGURATOR_ERROR boxes_vm_configurator_error_quark ()
struct _BoxesVMConfigurator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesVMConfiguratorPrivate * priv;
};

struct _BoxesVMConfiguratorClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesVMConfigurator *self);
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_vbox) (BoxesInstallerMedia* self, GtkBox* setup_vbox);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	BoxesVMCreator* (*get_vm_creator) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_ready_to_create) (BoxesInstallerMedia* self);
	gboolean (*get_live) (BoxesInstallerMedia* self);
	gchar* (*get_architecture) (BoxesInstallerMedia* self);
};

struct _BoxesParamSpecVMConfigurator {
	GParamSpec parent_instance;
};


static gpointer boxes_vm_configurator_parent_class = NULL;

GQuark boxes_vm_configurator_error_quark (void);
gpointer boxes_vm_configurator_ref (gpointer instance);
void boxes_vm_configurator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_configurator (GValue* value, gpointer v_object);
void boxes_value_take_vm_configurator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_configurator (const GValue* value);
GType boxes_vm_configurator_get_type (void) G_GNUC_CONST;
enum  {
	BOXES_VM_CONFIGURATOR_DUMMY_PROPERTY
};
#define BOXES_VM_CONFIGURATOR_BOXES_NS "boxes"
#define BOXES_VM_CONFIGURATOR_BOXES_NS_URI "http://live.gnome.org/Boxes/"
#define BOXES_VM_CONFIGURATOR_BOXES_XML "<gnome-boxes>%s</gnome-boxes>"
#define BOXES_VM_CONFIGURATOR_LIVE_STATE "live"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "installation"
#define BOXES_VM_CONFIGURATOR_IMPORT_STATE "importing"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE "libvirt-system-importing"
#define BOXES_VM_CONFIGURATOR_INSTALLED_STATE "installed"
#define BOXES_VM_CONFIGURATOR_LIVE_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIVE_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLATION_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLATION_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_IMPORT_XML "<os-state>" BOXES_VM_CONFIGURATOR_IMPORT_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_XML "<os-state>" BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_INSTALLED_XML "<os-state>" BOXES_VM_CONFIGURATOR_INSTALLED_STATE "</os-state>"
#define BOXES_VM_CONFIGURATOR_OS_ID_XML "<os-id>%s</os-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_ID_XML "<media-id>%s</media-id>"
#define BOXES_VM_CONFIGURATOR_MEDIA_XML "<media>%s</media>"
#define BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML "<num-reboots>%u</num-reboots>"
GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error);
void boxes_vm_configurator_setup_custom_xml (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error);
gpointer boxes_vm_creator_ref (gpointer instance);
void boxes_vm_creator_unref (gpointer instance);
GParamSpec* boxes_param_spec_vm_creator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_vm_creator (GValue* value, gpointer v_object);
void boxes_value_take_vm_creator (GValue* value, gpointer v_object);
gpointer boxes_value_get_vm_creator (const GValue* value);
GType boxes_vm_creator_get_type (void) G_GNUC_CONST;
static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps);
static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps);
static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps);
static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media);
void boxes_installer_media_setup_domain_config (BoxesInstallerMedia* self, GVirConfigDomain* domain);
void boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain);
void boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain);
static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
gboolean boxes_installer_media_get_supports_virtio_net (BoxesInstallerMedia* self);
void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain);
void boxes_installer_media_setup_post_install_domain_config (BoxesInstallerMedia* self, GVirConfigDomain* domain);
static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain, BoxesInstallerMedia* install_media);
gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_import_config (GVirConfigDomain* domain);
gboolean boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain);
GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error);
static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void);
GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error);
gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain);
static gchar* boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain, const gchar* node_name);
gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain);
gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain);
guint boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain);
void boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots);
static void boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots, gboolean installed);
gboolean boxes_installer_media_get_supports_virtio_disk (BoxesInstallerMedia* self);
void boxes_installer_media_set_direct_boot_params (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
OsinfoDevice* boxes_find_device_by_prop (OsinfoDeviceList* devices, const gchar* prop_name, const gchar* prop_value);
OsinfoDeviceList* boxes_installer_media_get_supported_devices (BoxesInstallerMedia* self);
GType boxes_installed_media_get_type (void) G_GNUC_CONST;
GType boxes_libvirt_system_media_get_type (void) G_GNUC_CONST;
gboolean boxes_installer_media_get_live (BoxesInstallerMedia* self);
static GVirConfigDomainControllerUsb* boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model, GVirConfigDomainControllerUsb* master, guint index, guint start_port);
void boxes_vm_configurator_remove_usb_controllers (GVirConfigDomain* domain, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean boxes_installer_media_is_architecture_compatible (BoxesInstallerMedia* self, const gchar* architecture);
static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps);
BoxesVMConfigurator* boxes_vm_configurator_new (void);
BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type);
static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_vm_configurator_error_quark (void) {
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	return g_quark_from_static_string ("boxes_vm_configurator_error-quark");
#line 237 "vm-configurator.c"
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 248 "vm-configurator.c"
	}
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 254 "vm-configurator.c"
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 265 "vm-configurator.c"
	}
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 271 "vm-configurator.c"
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if ((*length) == (*size)) {
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 282 "vm-configurator.c"
	}
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[(*length)++] = value;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(*array)[*length] = NULL;
#line 288 "vm-configurator.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1237 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1237 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1238 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1238 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1238 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1238 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 308 "vm-configurator.c"
}


GVirConfigDomain* boxes_vm_configurator_create_domain_config (BoxesInstallerMedia* install_media, const gchar* target_path, GVirConfigCapabilities* caps, GError** error) {
	GVirConfigDomain* result = NULL;
	GVirConfigDomain* domain = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	BoxesInstallerMedia* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuest* best_caps = NULL;
	GVirConfigCapabilities* _tmp2_ = NULL;
	BoxesInstallerMedia* _tmp3_ = NULL;
	GVirConfigCapabilitiesGuest* _tmp4_ = NULL;
	BoxesInstallerMedia* _tmp5_ = NULL;
	OsinfoResources* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	GVirConfigCapabilities* _tmp9_ = NULL;
	GVirConfigDomainVirtType _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	GVirConfigDomainVirtType virt_type = 0;
	GVirConfigDomainVirtType _tmp12_ = 0;
	GVirConfigDomainVirtType _tmp13_ = 0;
	BoxesInstallerMedia* _tmp14_ = NULL;
	gchar** features = NULL;
	gchar** _tmp15_ = NULL;
	gint features_length1 = 0;
	gint _features_size_ = 0;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	GVirConfigDomainClock* clock = NULL;
	GVirConfigDomainClock* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	BoxesInstallerMedia* _tmp28_ = NULL;
	OsinfoOs* _tmp29_ = NULL;
	gboolean _tmp35_ = FALSE;
	GVirConfigDomainTimer* timer = NULL;
	GVirConfigDomainTimerRtc* _tmp38_ = NULL;
	GVirConfigDomainTimer* _tmp39_ = NULL;
	GVirConfigDomainClock* _tmp40_ = NULL;
	GVirConfigDomainTimer* _tmp41_ = NULL;
	GVirConfigDomainTimerPit* _tmp42_ = NULL;
	GVirConfigDomainTimer* _tmp43_ = NULL;
	GVirConfigDomainClock* _tmp44_ = NULL;
	GVirConfigDomainTimer* _tmp45_ = NULL;
	GVirConfigDomainClock* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	BoxesInstallerMedia* _tmp48_ = NULL;
	BoxesInstallerMedia* _tmp49_ = NULL;
	GVirConfigDomainGraphicsSpice* graphics = NULL;
	GVirConfigDomainGraphicsSpice* _tmp50_ = NULL;
	GVirConfigDomainGraphicsSpice* _tmp51_ = NULL;
	GVirConfigDomainGraphicsSpice* _tmp52_ = NULL;
	GVirConfigDomainGraphicsSpice* _tmp53_ = NULL;
	GVirConfigDomainChannel* channel = NULL;
	GVirConfigDomainChannel* _tmp54_ = NULL;
	GVirConfigDomainChannel* _tmp55_ = NULL;
	GVirConfigDomainChannel* _tmp56_ = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp57_ = NULL;
	GVirConfigDomainChannel* _tmp58_ = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp59_ = NULL;
	GVirConfigDomainChannel* _tmp60_ = NULL;
	BoxesInstallerMedia* _tmp61_ = NULL;
	BoxesInstallerMedia* _tmp62_ = NULL;
	BoxesInstallerMedia* _tmp63_ = NULL;
	GVirConfigDomainPowerManagement* pm = NULL;
	GVirConfigDomainPowerManagement* _tmp64_ = NULL;
	GVirConfigDomainPowerManagement* _tmp65_ = NULL;
	GVirConfigDomainPowerManagement* _tmp66_ = NULL;
	GVirConfigDomainPowerManagement* _tmp67_ = NULL;
	GVirConfigDomainConsole* console = NULL;
	GVirConfigDomainConsole* _tmp68_ = NULL;
	GVirConfigDomainConsole* _tmp69_ = NULL;
	GVirConfigDomainChardevSourcePty* _tmp70_ = NULL;
	GVirConfigDomainChardevSourcePty* _tmp71_ = NULL;
	GVirConfigDomainConsole* _tmp72_ = NULL;
	GVirConfigDomainInterfaceUser* iface = NULL;
	GVirConfigDomainInterfaceUser* _tmp73_ = NULL;
	BoxesInstallerMedia* _tmp74_ = NULL;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	GVirConfigDomainInterfaceUser* _tmp78_ = NULL;
	GError * _inner_error_ = NULL;
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (target_path != NULL, NULL);
#line 30 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_new ();
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	domain = _tmp0_;
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_setup_custom_xml (domain, _tmp1_);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = caps;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = install_media;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_best_guest_caps (_tmp2_, _tmp3_, &_inner_error_);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	best_caps = _tmp4_;
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_propagate_error (error, _inner_error_);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 427 "vm-configurator.c"
		} else {
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_object_unref0 (domain);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_clear_error (&_inner_error_);
#line 36 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return NULL;
#line 437 "vm-configurator.c"
		}
	}
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = install_media;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_->resources;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = osinfo_resources_get_ram (_tmp6_);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = _tmp7_;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_memory (domain, (guint64) (_tmp8_ / OSINFO_KIBIBYTES));
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = caps;
#line 38 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_cpu_config (domain, _tmp9_);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = boxes_vm_configurator_guest_kvm_enabled (best_caps);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp11_) {
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = GVIR_CONFIG_DOMAIN_VIRT_KVM;
#line 460 "vm-configurator.c"
	} else {
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = GVIR_CONFIG_DOMAIN_VIRT_QEMU;
#line 464 "vm-configurator.c"
	}
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = _tmp10_;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	virt_type = _tmp12_;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = virt_type;
#line 41 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_virt_type (domain, _tmp13_);
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = install_media;
#line 43 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_os_config (domain, _tmp14_, best_caps);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = g_new0 (gchar*, 0 + 1);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features = _tmp15_;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features_length1 = 0;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_features_size_ = features_length1;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = boxes_vm_configurator_guest_supports_feature (best_caps, "acpi");
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp16_) {
#line 490 "vm-configurator.c"
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gchar* _tmp18_ = NULL;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp17_ = features;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp17__length1 = features_length1;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = g_strdup ("acpi");
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add9 (&features, &features_length1, &_features_size_, _tmp18_);
#line 502 "vm-configurator.c"
	}
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = boxes_vm_configurator_guest_supports_feature (best_caps, "apic");
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp19_) {
#line 508 "vm-configurator.c"
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gchar* _tmp21_ = NULL;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp20_ = features;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp20__length1 = features_length1;
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp21_ = g_strdup ("apic");
#line 49 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add10 (&features, &features_length1, &_features_size_, _tmp21_);
#line 520 "vm-configurator.c"
	}
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp22_ = boxes_vm_configurator_guest_supports_feature (best_caps, "pae");
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp22_) {
#line 526 "vm-configurator.c"
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gchar* _tmp24_ = NULL;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp23_ = features;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp23__length1 = features_length1;
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp24_ = g_strdup ("pae");
#line 51 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_vala_array_add11 (&features, &features_length1, &_features_size_, _tmp24_);
#line 538 "vm-configurator.c"
	}
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp25_ = features;
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp25__length1 = features_length1;
#line 52 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_features (domain, _tmp25_);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp26_ = gvir_config_domain_clock_new ();
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	clock = _tmp26_;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp28_ = install_media;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp29_ = _tmp28_->os;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp29_ != NULL) {
#line 556 "vm-configurator.c"
		BoxesInstallerMedia* _tmp30_ = NULL;
		OsinfoOs* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp30_ = install_media;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp31_ = _tmp30_->os;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp32_ = osinfo_product_get_short_id ((OsinfoProduct*) _tmp31_);
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp33_ = _tmp32_;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp34_ = string_contains (_tmp33_, "win");
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp27_ = _tmp34_;
#line 574 "vm-configurator.c"
	} else {
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp27_ = FALSE;
#line 578 "vm-configurator.c"
	}
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp35_ = _tmp27_;
#line 55 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp35_) {
#line 584 "vm-configurator.c"
		GVirConfigDomainClock* _tmp36_ = NULL;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp36_ = clock;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp36_, GVIR_CONFIG_DOMAIN_CLOCK_LOCALTIME);
#line 590 "vm-configurator.c"
	} else {
		GVirConfigDomainClock* _tmp37_ = NULL;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp37_ = clock;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_clock_set_offset (_tmp37_, GVIR_CONFIG_DOMAIN_CLOCK_UTC);
#line 597 "vm-configurator.c"
	}
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp38_ = gvir_config_domain_timer_rtc_new ();
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp38_;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp39_ = timer;
#line 61 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp39_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_CATCHUP);
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp40_ = clock;
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp41_ = timer;
#line 62 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp40_, _tmp41_);
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp42_ = gvir_config_domain_timer_pit_new ();
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	timer = (GVirConfigDomainTimer*) _tmp42_;
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp43_ = timer;
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_timer_set_tick_policy (_tmp43_, GVIR_CONFIG_DOMAIN_TIMER_TICK_POLICY_DELAY);
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp44_ = clock;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp45_ = timer;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_clock_add_timer (_tmp44_, _tmp45_);
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp46_ = clock;
#line 66 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_clock (domain, _tmp46_);
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp47_ = target_path;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp48_ = install_media;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_target_media_config (domain, _tmp47_, _tmp48_);
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp49_ = install_media;
#line 69 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_setup_domain_config (_tmp49_, domain);
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp50_ = gvir_config_domain_graphics_spice_new ();
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	graphics = _tmp50_;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp51_ = graphics;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_autoport (_tmp51_, TRUE);
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp52_ = graphics;
#line 73 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_graphics_spice_set_image_compression (_tmp52_, GVIR_CONFIG_DOMAIN_GRAPHICS_SPICE_IMAGE_COMPRESSION_OFF);
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp53_ = graphics;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp53_);
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp54_ = gvir_config_domain_channel_new ();
#line 77 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	channel = _tmp54_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp55_ = channel;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_type (_tmp55_, GVIR_CONFIG_DOMAIN_CHANNEL_TARGET_VIRTIO);
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp56_ = channel;
#line 79 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_channel_set_target_name (_tmp56_, "com.redhat.spice.0");
#line 80 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp57_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 80 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp57_;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp58_ = channel;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp59_ = vmc;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp58_, (GVirConfigDomainChardevSource*) _tmp59_);
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp60_ = channel;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp60_);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (HAVE_USBREDIR) {
#line 86 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_add_usb_support (domain);
#line 689 "vm-configurator.c"
	}
#line 88 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (HAVE_SMARTCARD) {
#line 89 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_add_smartcard_support (domain);
#line 695 "vm-configurator.c"
	}
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp61_ = install_media;
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_video_config (domain, _tmp61_);
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp62_ = install_media;
#line 92 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_sound_config (domain, _tmp62_);
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp63_ = install_media;
#line 93 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_tablet_config (domain, _tmp63_);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_POWEROFF, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (domain, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_CRASH, GVIR_CONFIG_DOMAIN_LIFECYCLE_DESTROY);
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp64_ = gvir_config_domain_power_management_new ();
#line 99 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pm = _tmp64_;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp65_ = pm;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_power_management_set_mem_suspend_enabled (_tmp65_, FALSE);
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp66_ = pm;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_power_management_set_disk_suspend_enabled (_tmp66_, FALSE);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp67_ = pm;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_power_management (domain, _tmp67_);
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp68_ = gvir_config_domain_console_new ();
#line 104 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	console = _tmp68_;
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp69_ = console;
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp70_ = gvir_config_domain_chardev_source_pty_new ();
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp71_ = _tmp70_;
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp69_, (GVirConfigDomainChardevSource*) _tmp71_);
#line 105 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp71_);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp72_ = console;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp72_);
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp73_ = gvir_config_domain_interface_user_new ();
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	iface = _tmp73_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp74_ = install_media;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp75_ = boxes_installer_media_get_supports_virtio_net (_tmp74_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp76_ = _tmp75_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp76_) {
#line 761 "vm-configurator.c"
		GVirConfigDomainInterfaceUser* _tmp77_ = NULL;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp77_ = iface;
#line 110 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_interface_set_model ((GVirConfigDomainInterface*) _tmp77_, "virtio");
#line 767 "vm-configurator.c"
	}
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp78_ = iface;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (domain, (GVirConfigDomainDevice*) _tmp78_);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = domain;
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (iface);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (console);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (pm);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (channel);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (graphics);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (timer);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (clock);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	features = (_vala_array_free (features, features_length1, (GDestroyNotify) g_free), NULL);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (best_caps);
#line 113 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 797 "vm-configurator.c"
}


void boxes_vm_configurator_post_install_setup (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomain* _tmp0_ = NULL;
	GVirConfigDomain* _tmp1_ = NULL;
	BoxesInstallerMedia* _tmp2_ = NULL;
	GVirConfigDomain* _tmp5_ = NULL;
	BoxesInstallerMedia* _tmp6_ = NULL;
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 117 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_set_post_install_os_config (_tmp0_);
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_lifecycle (_tmp1_, GVIR_CONFIG_DOMAIN_LIFECYCLE_ON_REBOOT, GVIR_CONFIG_DOMAIN_LIFECYCLE_RESTART);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = install_media;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp2_ != NULL) {
#line 821 "vm-configurator.c"
		BoxesInstallerMedia* _tmp3_ = NULL;
		GVirConfigDomain* _tmp4_ = NULL;
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = install_media;
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = domain;
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_installer_media_setup_post_install_domain_config (_tmp3_, _tmp4_);
#line 830 "vm-configurator.c"
	}
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = domain;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = install_media;
#line 123 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_mark_as_installed (_tmp5_, _tmp6_);
#line 838 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_install_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_INSTALLATION_STATE) == 0;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 127 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 864 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 130 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_LIVE_STATE) == 0;
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 131 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 890 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_import_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 134 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_IMPORT_STATE) == 0;
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 135 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 916 "vm-configurator.c"
}


gboolean boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain) {
	gboolean result = FALSE;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 138 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_os_state (_tmp0_);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_STATE) == 0;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (_tmp2_);
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp3_;
#line 139 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 942 "vm-configurator.c"
}


GVirConfigStorageVol* boxes_vm_configurator_create_volume_config (const gchar* name, gint64 storage, GError** error) {
	GVirConfigStorageVol* result = NULL;
	GVirConfigStorageVol* volume = NULL;
	GVirConfigStorageVol* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	GVirConfigStorageVolTarget* target = NULL;
	GVirConfigStorageVolTarget* _tmp3_ = NULL;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
#line 142 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_vol_new ();
#line 143 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	volume = _tmp0_;
#line 144 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = name;
#line 144 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_name (volume, _tmp1_);
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = storage;
#line 145 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_capacity (volume, (guint64) _tmp2_);
#line 146 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_vol_target_new ();
#line 146 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 147 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_format (target, "qcow2");
#line 148 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 148 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 149 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_target_set_permissions (target, permissions);
#line 150 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_vol_set_target (volume, target);
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = volume;
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 152 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 992 "vm-configurator.c"
}


GVirConfigStoragePool* boxes_vm_configurator_get_pool_config (GError** error) {
	GVirConfigStoragePool* result = NULL;
	gchar* pool_path = NULL;
	gchar* _tmp0_ = NULL;
	GVirConfigStoragePool* pool = NULL;
	GVirConfigStoragePool* _tmp1_ = NULL;
	GVirConfigStoragePoolSource* source = NULL;
	GVirConfigStoragePoolSource* _tmp2_ = NULL;
	GVirConfigStoragePoolTarget* target = NULL;
	GVirConfigStoragePoolTarget* _tmp3_ = NULL;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp4_ = NULL;
#line 156 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = boxes_get_user_pkgdata ("images");
#line 156 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pool_path = _tmp0_;
#line 157 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_ensure_directory (pool_path);
#line 159 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_storage_pool_new ();
#line 159 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	pool = _tmp1_;
#line 160 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_pool_type (pool, GVIR_CONFIG_STORAGE_POOL_TYPE_DIR);
#line 161 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_name (pool, PACKAGE_TARNAME);
#line 163 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_storage_pool_source_new ();
#line 163 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	source = _tmp2_;
#line 164 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_source_set_directory (source, pool_path);
#line 165 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_source (pool, source);
#line 167 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_storage_pool_target_new ();
#line 167 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	target = _tmp3_;
#line 168 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_path (target, pool_path);
#line 169 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = boxes_vm_configurator_get_default_permissions ();
#line 169 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp4_;
#line 170 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_target_set_permissions (target, permissions);
#line 171 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_pool_set_target (pool, target);
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = pool;
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (permissions);
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (target);
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (source);
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (pool_path);
#line 173 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1056 "vm-configurator.c"
}


gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 176 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "os-id");
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 177 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1074 "vm-configurator.c"
}


gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 180 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 181 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 181 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "media-id");
#line 181 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 181 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1092 "vm-configurator.c"
}


gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 184 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "media");
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 185 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1110 "vm-configurator.c"
}


guint boxes_vm_configurator_get_num_reboots (GVirConfigDomain* domain) {
	guint result = 0U;
	gchar* str = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
#line 188 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, 0U);
#line 189 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 189 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "num-reboots");
#line 189 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	str = _tmp1_;
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = str;
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp3_ != NULL) {
#line 1133 "vm-configurator.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = str;
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = atoi (_tmp4_);
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = _tmp5_;
#line 1142 "vm-configurator.c"
	} else {
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = 0;
#line 1146 "vm-configurator.c"
	}
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = (guint) _tmp2_;
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (str);
#line 190 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1154 "vm-configurator.c"
}


void boxes_vm_configurator_set_num_reboots (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots) {
	GVirConfigDomain* _tmp0_ = NULL;
	BoxesInstallerMedia* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 193 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 194 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 194 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 194 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = num_reboots;
#line 194 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (_tmp0_, _tmp1_, _tmp2_, FALSE);
#line 1174 "vm-configurator.c"
}


void boxes_vm_configurator_setup_custom_xml (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomain* _tmp0_ = NULL;
	BoxesInstallerMedia* _tmp1_ = NULL;
#line 197 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 197 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 198 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 198 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 198 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (_tmp0_, _tmp1_, (guint) 0, FALSE);
#line 1191 "vm-configurator.c"
}


static void boxes_vm_configurator_mark_as_installed (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomain* _tmp0_ = NULL;
	BoxesInstallerMedia* _tmp1_ = NULL;
#line 201 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 202 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_update_custom_xml (_tmp0_, _tmp1_, (guint) 0, TRUE);
#line 1206 "vm-configurator.c"
}


static void boxes_vm_configurator_set_cpu_config (GVirConfigDomain* domain, GVirConfigCapabilities* caps) {
	GVirConfigCapabilitiesCpuTopology* topology = NULL;
	GVirConfigCapabilities* _tmp0_ = NULL;
	GVirConfigCapabilitiesHost* _tmp1_ = NULL;
	GVirConfigCapabilitiesHost* _tmp2_ = NULL;
	GVirConfigCapabilitiesCpu* _tmp3_ = NULL;
	GVirConfigCapabilitiesCpu* _tmp4_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp5_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp6_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp7_ = NULL;
	GVirConfigDomain* _tmp8_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp9_ = NULL;
	guint64 _tmp10_ = 0ULL;
	GVirConfigCapabilitiesCpuTopology* _tmp11_ = NULL;
	guint64 _tmp12_ = 0ULL;
	GVirConfigCapabilitiesCpuTopology* _tmp13_ = NULL;
	guint64 _tmp14_ = 0ULL;
	GVirConfigDomainCpu* cpu = NULL;
	GVirConfigDomainCpu* _tmp15_ = NULL;
	GVirConfigDomainCpu* _tmp16_ = NULL;
	GVirConfigDomainCpu* _tmp17_ = NULL;
	GVirConfigCapabilitiesCpuTopology* _tmp18_ = NULL;
	GVirConfigDomain* _tmp19_ = NULL;
	GVirConfigDomainCpu* _tmp20_ = NULL;
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (caps != NULL);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = caps;
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_get_host (_tmp0_);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = _tmp1_;
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_host_get_cpu (_tmp2_);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = gvir_config_capabilities_cpu_get_topology (_tmp4_);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp2_);
#line 206 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	topology = _tmp6_;
#line 208 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = topology;
#line 208 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp7_ == NULL) {
#line 209 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_object_unref0 (topology);
#line 209 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return;
#line 1266 "vm-configurator.c"
	}
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = domain;
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = topology;
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = gvir_config_capabilities_cpu_topology_get_sockets (_tmp9_);
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = topology;
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = gvir_config_capabilities_cpu_topology_get_cores (_tmp11_);
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = topology;
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = gvir_config_capabilities_cpu_topology_get_threads (_tmp13_);
#line 211 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_object_set (_tmp8_, "vcpu", (_tmp10_ * _tmp12_) * _tmp14_, NULL);
#line 213 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = gvir_config_domain_cpu_new ();
#line 213 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	cpu = _tmp15_;
#line 214 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = cpu;
#line 214 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_cpu_set_mode (_tmp16_, GVIR_CONFIG_DOMAIN_CPU_MODE_HOST_MODEL);
#line 215 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = cpu;
#line 215 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = topology;
#line 215 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_capabilities_cpu_set_topology ((GVirConfigCapabilitiesCpu*) _tmp17_, _tmp18_);
#line 216 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = domain;
#line 216 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = cpu;
#line 216 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_cpu (_tmp19_, _tmp20_);
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (cpu);
#line 205 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (topology);
#line 1308 "vm-configurator.c"
}


static void boxes_vm_configurator_set_target_media_config (GVirConfigDomain* domain, const gchar* target_path, BoxesInstallerMedia* install_media) {
	GVirConfigDomainDisk* disk = NULL;
	GVirConfigDomainDisk* _tmp0_ = NULL;
	GVirConfigDomainDisk* _tmp1_ = NULL;
	GVirConfigDomainDisk* _tmp2_ = NULL;
	GVirConfigDomainDisk* _tmp3_ = NULL;
	GVirConfigDomainDisk* _tmp4_ = NULL;
	GVirConfigDomainDisk* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GVirConfigDomainDisk* _tmp7_ = NULL;
	BoxesInstallerMedia* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GVirConfigDomain* _tmp15_ = NULL;
	GVirConfigDomainDisk* _tmp16_ = NULL;
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (target_path != NULL);
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 220 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_disk_new ();
#line 220 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	disk = _tmp0_;
#line 221 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = disk;
#line 221 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_type (_tmp1_, GVIR_CONFIG_DOMAIN_DISK_FILE);
#line 222 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = disk;
#line 222 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_guest_device_type (_tmp2_, GVIR_CONFIG_DOMAIN_DISK_GUEST_DEVICE_DISK);
#line 223 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = disk;
#line 223 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_name (_tmp3_, "qemu");
#line 224 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = disk;
#line 224 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_format (_tmp4_, GVIR_CONFIG_DOMAIN_DISK_FORMAT_QCOW2);
#line 225 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = disk;
#line 225 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = target_path;
#line 225 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_source (_tmp5_, _tmp6_);
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = disk;
#line 226 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_disk_set_driver_cache (_tmp7_, GVIR_CONFIG_DOMAIN_DISK_CACHE_NONE);
#line 228 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = install_media;
#line 228 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp9_ = boxes_installer_media_get_supports_virtio_disk (_tmp8_);
#line 228 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp10_ = _tmp9_;
#line 228 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp10_) {
#line 1371 "vm-configurator.c"
		GVirConfigDomainDisk* _tmp11_ = NULL;
		GVirConfigDomainDisk* _tmp12_ = NULL;
#line 229 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:229: Using virtio controller for the main disk");
#line 230 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = disk;
#line 230 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp11_, GVIR_CONFIG_DOMAIN_DISK_BUS_VIRTIO);
#line 231 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = disk;
#line 231 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp12_, "vda");
#line 1384 "vm-configurator.c"
	} else {
		GVirConfigDomainDisk* _tmp13_ = NULL;
		GVirConfigDomainDisk* _tmp14_ = NULL;
#line 233 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_debug ("vm-configurator.vala:233: Using IDE controller for the main disk");
#line 234 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = disk;
#line 234 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_bus (_tmp13_, GVIR_CONFIG_DOMAIN_DISK_BUS_IDE);
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp14_ = disk;
#line 235 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_disk_set_target_dev (_tmp14_, "hda");
#line 1398 "vm-configurator.c"
	}
#line 238 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = domain;
#line 238 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = disk;
#line 238 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp15_, (GVirConfigDomainDevice*) _tmp16_);
#line 219 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (disk);
#line 1408 "vm-configurator.c"
}


static void boxes_vm_configurator_set_post_install_os_config (GVirConfigDomain* domain) {
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_ = NULL;
	GVirConfigDomainOs* old_os = NULL;
	GVirConfigDomain* _tmp1_ = NULL;
	GVirConfigDomainOs* _tmp2_ = NULL;
	GList* boot_devices = NULL;
	GList* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GVirConfigDomain* _tmp5_ = NULL;
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 242 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 242 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 243 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 245 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 245 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_domain_get_os (_tmp1_);
#line 245 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old_os = _tmp2_;
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_domain_os_get_boot_devices (old_os);
#line 246 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = _tmp3_;
#line 247 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_remove (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 248 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 250 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = gvir_config_domain_os_get_arch (old_os);
#line 250 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp4_);
#line 252 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = domain;
#line 252 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (_tmp5_, os);
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (old_os);
#line 241 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 1458 "vm-configurator.c"
}


static void boxes_vm_configurator_set_os_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, GVirConfigCapabilitiesGuest* guest_caps) {
	GVirConfigDomainOs* os = NULL;
	GVirConfigDomainOs* _tmp0_ = NULL;
	GVirConfigCapabilitiesGuest* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp2_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GList* boot_devices = NULL;
	BoxesInstallerMedia* _tmp5_ = NULL;
	GVirConfigDomain* _tmp6_ = NULL;
#line 255 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 255 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 255 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (guest_caps != NULL);
#line 256 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_os_new ();
#line 256 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	os = _tmp0_;
#line 257 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_os_type (os, GVIR_CONFIG_DOMAIN_OS_TYPE_HVM);
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = guest_caps;
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = gvir_config_capabilities_guest_get_arch (_tmp1_);
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = gvir_config_capabilities_guest_arch_get_name (_tmp3_);
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_arch (os, _tmp4_);
#line 258 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp3_);
#line 260 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = NULL;
#line 261 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = install_media;
#line 261 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_installer_media_set_direct_boot_params (_tmp5_, os);
#line 262 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_CDROM));
#line 263 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boot_devices = g_list_append (boot_devices, (gpointer) ((gintptr) GVIR_CONFIG_DOMAIN_OS_BOOT_DEVICE_HD));
#line 264 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_os_set_boot_devices (os, boot_devices);
#line 266 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = domain;
#line 266 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_os (_tmp6_, os);
#line 255 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_list_free0 (boot_devices);
#line 255 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (os);
#line 1516 "vm-configurator.c"
}


static void boxes_vm_configurator_set_video_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainVideo* video = NULL;
	GVirConfigDomainVideo* _tmp0_ = NULL;
	OsinfoDevice* device = NULL;
	BoxesInstallerMedia* _tmp1_ = NULL;
	OsinfoDeviceList* _tmp2_ = NULL;
	OsinfoDeviceList* _tmp3_ = NULL;
	OsinfoDeviceList* _tmp4_ = NULL;
	OsinfoDevice* _tmp5_ = NULL;
	OsinfoDevice* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	OsinfoDevice* _tmp8_ = NULL;
	gint model = 0;
	gint _tmp12_ = 0;
	GVirConfigDomainVideo* _tmp13_ = NULL;
	GVirConfigDomain* _tmp14_ = NULL;
	GVirConfigDomainVideo* _tmp15_ = NULL;
#line 269 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 269 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 270 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_video_new ();
#line 270 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	video = _tmp0_;
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = boxes_installer_media_get_supported_devices (_tmp1_);
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = boxes_find_device_by_prop (_tmp4_, OSINFO_DEVICE_PROP_CLASS, "video");
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 271 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	device = _tmp6_;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = device;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp8_ != NULL) {
#line 1565 "vm-configurator.c"
		OsinfoDevice* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = device;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = osinfo_device_get_name (_tmp9_);
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = boxes_get_enum_value (_tmp10_, gvir_config_domain_video_model_get_type ());
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = _tmp11_;
#line 1577 "vm-configurator.c"
	} else {
#line 273 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = (gint) GVIR_CONFIG_DOMAIN_VIDEO_MODEL_QXL;
#line 1581 "vm-configurator.c"
	}
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = _tmp7_;
#line 272 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	model = _tmp12_;
#line 274 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != (-1));
#line 275 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = video;
#line 275 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_video_set_model (_tmp13_, (GVirConfigDomainVideoModel) model);
#line 277 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = domain;
#line 277 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = video;
#line 277 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
#line 269 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 269 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (video);
#line 1603 "vm-configurator.c"
}


static void boxes_vm_configurator_set_sound_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainSound* sound = NULL;
	GVirConfigDomainSound* _tmp0_ = NULL;
	OsinfoDevice* device = NULL;
	BoxesInstallerMedia* _tmp1_ = NULL;
	OsinfoDeviceList* _tmp2_ = NULL;
	OsinfoDeviceList* _tmp3_ = NULL;
	OsinfoDeviceList* _tmp4_ = NULL;
	OsinfoDevice* _tmp5_ = NULL;
	OsinfoDevice* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	OsinfoDevice* _tmp8_ = NULL;
	gint model = 0;
	gint _tmp12_ = 0;
	GVirConfigDomainSound* _tmp13_ = NULL;
	GVirConfigDomain* _tmp14_ = NULL;
	GVirConfigDomainSound* _tmp15_ = NULL;
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 281 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_sound_new ();
#line 281 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	sound = _tmp0_;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = boxes_installer_media_get_supported_devices (_tmp1_);
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp2_;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = _tmp3_;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = boxes_find_device_by_prop (_tmp4_, OSINFO_DEVICE_PROP_CLASS, "audio");
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = _tmp5_;
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (_tmp4_);
#line 282 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	device = _tmp6_;
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp8_ = device;
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp8_ != NULL) {
#line 1652 "vm-configurator.c"
		OsinfoDevice* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = device;
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = osinfo_device_get_name (_tmp9_);
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = boxes_get_enum_value (_tmp10_, gvir_config_domain_sound_model_get_type ());
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = _tmp11_;
#line 1664 "vm-configurator.c"
	} else {
#line 284 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = (gint) GVIR_CONFIG_DOMAIN_SOUND_MODEL_AC97;
#line 1668 "vm-configurator.c"
	}
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = _tmp7_;
#line 283 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	model = _tmp12_;
#line 285 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (model != (-1));
#line 286 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = sound;
#line 286 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_sound_set_model (_tmp13_, (GVirConfigDomainSoundModel) model);
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = domain;
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = sound;
#line 288 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (device);
#line 280 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (sound);
#line 1690 "vm-configurator.c"
}


static void boxes_vm_configurator_set_tablet_config (GVirConfigDomain* domain, BoxesInstallerMedia* install_media) {
	GVirConfigDomainInput* input = NULL;
	GVirConfigDomainInput* _tmp0_ = NULL;
	GVirConfigDomain* _tmp1_ = NULL;
#line 291 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 291 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (install_media != NULL);
#line 292 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_input_new ();
#line 292 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	input = _tmp0_;
#line 293 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_input_set_device_type (input, GVIR_CONFIG_DOMAIN_INPUT_DEVICE_TABLET);
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = domain;
#line 295 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp1_, (GVirConfigDomainDevice*) input);
#line 291 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (input);
#line 1714 "vm-configurator.c"
}


static GVirConfigStoragePermissions* boxes_vm_configurator_get_default_permissions (void) {
	GVirConfigStoragePermissions* result = NULL;
	GVirConfigStoragePermissions* permissions = NULL;
	GVirConfigStoragePermissions* _tmp0_ = NULL;
	uid_t _tmp1_ = {0};
	gid_t _tmp2_ = {0};
#line 299 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_storage_permissions_new ();
#line 299 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	permissions = _tmp0_;
#line 301 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = getuid ();
#line 301 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_owner (permissions, (guint) _tmp1_);
#line 302 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = getgid ();
#line 302 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_group (permissions, (guint) _tmp2_);
#line 303 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_storage_permissions_set_mode (permissions, (guint) 744);
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = permissions;
#line 305 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1742 "vm-configurator.c"
}


static gchar* boxes_vm_configurator_get_os_state (GVirConfigDomain* domain) {
	gchar* result = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 308 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 309 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 309 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = boxes_vm_configurator_get_custom_xml_node (_tmp0_, "os-state");
#line 309 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = _tmp1_;
#line 309 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1760 "vm-configurator.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1259 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1260 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1260 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1260 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1261 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1261 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1261 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1261 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1804 "vm-configurator.c"
	}
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1262 "/home/zeenix/jhbuild/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1810 "vm-configurator.c"
}


static gchar* boxes_vm_configurator_get_custom_xml_node (GVirConfigDomain* domain, const gchar* node_name) {
	gchar* result = NULL;
	gchar* xml = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp28_ = NULL;
	GVirConfigDomain* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 312 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (node_name != NULL, NULL);
#line 313 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 313 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_custom_xml (_tmp0_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI);
#line 313 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	xml = _tmp1_;
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = xml;
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp2_ != NULL) {
#line 1837 "vm-configurator.c"
		xmlTextReader* reader = NULL;
		const gchar* _tmp3_ = NULL;
		guint8* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		xmlTextReader* _tmp9_ = NULL;
		xmlTextReader* _tmp10_ = NULL;
		xmlNode* node = NULL;
		xmlTextReader* _tmp11_ = NULL;
		xmlNode* _tmp12_ = NULL;
		xmlNode* _tmp13_ = NULL;
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp3_ = xml;
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = _tmp4_;
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5__length1 = _tmp4__length1;
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = xml;
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = strlen (_tmp6_);
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = _tmp7_;
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp9_ = xmlReaderForMemory ((gchar*) _tmp5_, _tmp8_, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, NULL, (gint) XML_PARSE_COMPACT);
#line 315 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		reader = _tmp9_;
#line 320 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp10_ = reader;
#line 320 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		xmlTextReaderNext (_tmp10_);
#line 322 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp11_ = reader;
#line 322 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp12_ = xmlTextReaderExpand (_tmp11_);
#line 322 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		node = _tmp12_;
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp13_ = node;
#line 323 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp13_ != NULL) {
#line 1885 "vm-configurator.c"
			xmlNode* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp14_ = node;
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp15_ = _tmp14_->name;
#line 325 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			if (g_strcmp0 (_tmp15_, "gnome-boxes") == 0) {
#line 1894 "vm-configurator.c"
				xmlNode* _tmp16_ = NULL;
				xmlNode* _tmp17_ = NULL;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp16_ = node;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = _tmp16_->children;
#line 326 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				node = _tmp17_;
#line 1903 "vm-configurator.c"
			}
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 1907 "vm-configurator.c"
				xmlNode* _tmp18_ = NULL;
				xmlNode* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				xmlNode* _tmp26_ = NULL;
				xmlNode* _tmp27_ = NULL;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp18_ = node;
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!(_tmp18_ != NULL)) {
#line 328 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 1920 "vm-configurator.c"
				}
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp19_ = node;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp20_ = _tmp19_->name;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp21_ = node_name;
#line 329 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (_tmp20_, _tmp21_) == 0) {
#line 1930 "vm-configurator.c"
					xmlNode* _tmp22_ = NULL;
					xmlNode* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp22_ = node;
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp23_ = _tmp22_->children;
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp24_ = _tmp23_->content;
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp25_ = g_strdup (_tmp24_);
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = _tmp25_;
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_xmlFreeTextReader0 (reader);
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_free0 (xml);
#line 330 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 1951 "vm-configurator.c"
				}
#line 332 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp26_ = node;
#line 332 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp27_ = _tmp26_->next;
#line 332 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				node = _tmp27_;
#line 1959 "vm-configurator.c"
			}
		}
#line 314 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_xmlFreeTextReader0 (reader);
#line 1964 "vm-configurator.c"
	}
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp28_ = node_name;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp29_ = domain;
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp30_ = gvir_config_domain_get_name (_tmp29_);
#line 337 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_debug ("vm-configurator.vala:337: No XML node %s' for domain '%s'.", _tmp28_, _tmp30_);
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = NULL;
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (xml);
#line 339 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 1980 "vm-configurator.c"
}


static void boxes_vm_configurator_update_custom_xml (GVirConfigDomain* domain, BoxesInstallerMedia* install_media, guint num_reboots, gboolean installed) {
	gboolean _tmp0_ = FALSE;
	BoxesInstallerMedia* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* custom_xml = NULL;
	gboolean _tmp4_ = FALSE;
	BoxesInstallerMedia* _tmp16_ = NULL;
	guint _tmp45_ = 0U;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GError * _inner_error_ = NULL;
#line 342 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = install_media;
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp1_ != NULL) {
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp0_ = TRUE;
#line 2003 "vm-configurator.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp2_ = installed;
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp0_ = _tmp2_;
#line 2010 "vm-configurator.c"
	}
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = _tmp0_;
#line 346 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (_tmp3_);
#line 349 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = installed;
#line 349 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp4_) {
#line 2020 "vm-configurator.c"
		gchar* _tmp5_ = NULL;
#line 350 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp5_ = g_strdup (BOXES_VM_CONFIGURATOR_INSTALLED_XML);
#line 350 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 350 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp5_;
#line 2028 "vm-configurator.c"
	} else {
		BoxesInstallerMedia* _tmp6_ = NULL;
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = install_media;
#line 351 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, BOXES_TYPE_LIBVIRT_SYSTEM_MEDIA)) {
#line 2035 "vm-configurator.c"
			gchar* _tmp7_ = NULL;
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp7_ = g_strdup (BOXES_VM_CONFIGURATOR_LIBVIRT_SYS_IMPORT_XML);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 352 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp7_;
#line 2043 "vm-configurator.c"
		} else {
			BoxesInstallerMedia* _tmp8_ = NULL;
#line 353 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp8_ = install_media;
#line 353 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, BOXES_TYPE_INSTALLED_MEDIA)) {
#line 2050 "vm-configurator.c"
				gchar* _tmp9_ = NULL;
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = g_strdup (BOXES_VM_CONFIGURATOR_IMPORT_XML);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (custom_xml);
#line 354 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				custom_xml = _tmp9_;
#line 2058 "vm-configurator.c"
			} else {
				const gchar* _tmp10_ = NULL;
				BoxesInstallerMedia* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp11_ = install_media;
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp12_ = boxes_installer_media_get_live (_tmp11_);
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp13_ = _tmp12_;
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp13_) {
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp10_ = BOXES_VM_CONFIGURATOR_LIVE_XML;
#line 2076 "vm-configurator.c"
				} else {
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp10_ = BOXES_VM_CONFIGURATOR_INSTALLATION_XML;
#line 2080 "vm-configurator.c"
				}
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp14_ = _tmp10_;
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp15_ = g_strdup (_tmp14_);
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (custom_xml);
#line 356 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				custom_xml = _tmp15_;
#line 2090 "vm-configurator.c"
			}
		}
	}
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = install_media;
#line 358 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp16_ != NULL) {
#line 2098 "vm-configurator.c"
		BoxesInstallerMedia* _tmp17_ = NULL;
		OsinfoOs* _tmp18_ = NULL;
		BoxesInstallerMedia* _tmp28_ = NULL;
		OsinfoMedia* _tmp29_ = NULL;
		const gchar* _tmp39_ = NULL;
		BoxesInstallerMedia* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
#line 359 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp17_ = install_media;
#line 359 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp18_ = _tmp17_->os;
#line 359 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp18_ != NULL) {
#line 2115 "vm-configurator.c"
			const gchar* _tmp19_ = NULL;
			BoxesInstallerMedia* _tmp20_ = NULL;
			OsinfoOs* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp19_ = custom_xml;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp20_ = install_media;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp21_ = _tmp20_->os;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_object_get ((OsinfoEntity*) _tmp21_, "id", &_tmp22_, NULL);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp23_ = _tmp22_;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp24_ = _tmp23_;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp25_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_OS_ID_XML, _tmp24_);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp26_ = _tmp25_;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp27_ = g_strconcat (_tmp19_, _tmp26_, NULL);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp27_;
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp26_);
#line 360 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp24_);
#line 2151 "vm-configurator.c"
		}
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp28_ = install_media;
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp29_ = _tmp28_->os_media;
#line 361 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_tmp29_ != NULL) {
#line 2159 "vm-configurator.c"
			const gchar* _tmp30_ = NULL;
			BoxesInstallerMedia* _tmp31_ = NULL;
			OsinfoMedia* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp30_ = custom_xml;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp31_ = install_media;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp32_ = _tmp31_->os_media;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			g_object_get ((OsinfoEntity*) _tmp32_, "id", &_tmp33_, NULL);
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp34_ = _tmp33_;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp35_ = _tmp34_;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp36_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_ID_XML, _tmp35_);
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp37_ = _tmp36_;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp38_ = g_strconcat (_tmp30_, _tmp37_, NULL);
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (custom_xml);
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			custom_xml = _tmp38_;
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp37_);
#line 362 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_g_free0 (_tmp35_);
#line 2195 "vm-configurator.c"
		}
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp39_ = custom_xml;
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp40_ = install_media;
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp41_ = _tmp40_->device_file;
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp42_ = g_markup_printf_escaped (BOXES_VM_CONFIGURATOR_MEDIA_XML, _tmp41_);
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp43_ = _tmp42_;
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp44_ = g_strconcat (_tmp39_, _tmp43_, NULL);
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp44_;
#line 363 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp43_);
#line 2215 "vm-configurator.c"
	}
#line 366 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp45_ = num_reboots;
#line 366 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp45_ != ((guint) 0)) {
#line 2221 "vm-configurator.c"
		const gchar* _tmp46_ = NULL;
		guint _tmp47_ = 0U;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp46_ = custom_xml;
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp47_ = num_reboots;
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp48_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_NUM_REBOOTS_XML, _tmp47_);
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp49_ = _tmp48_;
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		custom_xml = _tmp50_;
#line 367 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (_tmp49_);
#line 2243 "vm-configurator.c"
	}
#line 369 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp51_ = custom_xml;
#line 369 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp52_ = g_strdup_printf (BOXES_VM_CONFIGURATOR_BOXES_XML, _tmp51_);
#line 369 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (custom_xml);
#line 369 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	custom_xml = _tmp52_;
#line 2253 "vm-configurator.c"
	{
		GVirConfigDomain* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
#line 371 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp53_ = domain;
#line 371 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp54_ = custom_xml;
#line 371 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_set_custom_xml (_tmp53_, _tmp54_, BOXES_VM_CONFIGURATOR_BOXES_NS, BOXES_VM_CONFIGURATOR_BOXES_NS_URI, &_inner_error_);
#line 371 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (_inner_error_ != NULL) {
#line 2265 "vm-configurator.c"
			goto __catch92_g_error;
		}
	}
	goto __finally92;
	__catch92_g_error:
	{
		GError* _error_ = NULL;
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_error_ = _inner_error_;
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_inner_error_ = NULL;
#line 372 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_assert_not_reached ();
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_error_free0 (_error_);
#line 2281 "vm-configurator.c"
	}
	__finally92:
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_ != NULL) {
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_g_free0 (custom_xml);
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 370 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return;
#line 2294 "vm-configurator.c"
	}
#line 342 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_free0 (custom_xml);
#line 2298 "vm-configurator.c"
}


void boxes_vm_configurator_add_smartcard_support (GVirConfigDomain* domain) {
	GVirConfigDomainSmartcardPassthrough* smartcard = NULL;
	GVirConfigDomainSmartcardPassthrough* _tmp0_ = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
	GVirConfigDomainChardevSourceSpiceVmc* _tmp1_ = NULL;
	GVirConfigDomain* _tmp2_ = NULL;
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 376 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_smartcard_passthrough_new ();
#line 376 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	smartcard = _tmp0_;
#line 377 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 377 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	vmc = _tmp1_;
#line 378 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_smartcard_passthrough_set_source (smartcard, (GVirConfigDomainChardevSource*) vmc);
#line 379 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = domain;
#line 379 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp2_, (GVirConfigDomainDevice*) smartcard);
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (vmc);
#line 375 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (smartcard);
#line 2328 "vm-configurator.c"
}


void boxes_vm_configurator_add_usb_support (GVirConfigDomain* domain) {
	GVirConfigDomainControllerUsb* master_controller = NULL;
	GVirConfigDomainControllerUsb* _tmp11_ = NULL;
	GVirConfigDomain* _tmp12_ = NULL;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp13_ = NULL;
	GVirConfigDomain* _tmp14_ = NULL;
	GVirConfigDomainControllerUsb* _tmp15_ = NULL;
	GVirConfigDomainControllerUsb* _tmp16_ = NULL;
	GVirConfigDomain* _tmp17_ = NULL;
	GVirConfigDomainControllerUsb* _tmp18_ = NULL;
	GVirConfigDomainControllerUsb* _tmp19_ = NULL;
	GVirConfigDomain* _tmp20_ = NULL;
	GVirConfigDomainControllerUsb* _tmp21_ = NULL;
#line 382 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 2348 "vm-configurator.c"
	{
		gint i = 0;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		i = 0;
#line 2353 "vm-configurator.c"
		{
			gboolean _tmp0_ = FALSE;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp0_ = TRUE;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			while (TRUE) {
#line 2360 "vm-configurator.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				GVirConfigDomainRedirdev* usb_redir = NULL;
				GVirConfigDomainRedirdev* _tmp4_ = NULL;
				GVirConfigDomainRedirdev* _tmp5_ = NULL;
				GVirConfigDomainChardevSourceSpiceVmc* vmc = NULL;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp6_ = NULL;
				GVirConfigDomainRedirdev* _tmp7_ = NULL;
				GVirConfigDomainChardevSourceSpiceVmc* _tmp8_ = NULL;
				GVirConfigDomain* _tmp9_ = NULL;
				GVirConfigDomainRedirdev* _tmp10_ = NULL;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp1_ = _tmp0_;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!_tmp1_) {
#line 2376 "vm-configurator.c"
					gint _tmp2_ = 0;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp2_ = i;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					i = _tmp2_ + 1;
#line 2382 "vm-configurator.c"
				}
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp0_ = FALSE;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = i;
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!(_tmp3_ < 4)) {
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 2392 "vm-configurator.c"
				}
#line 385 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = gvir_config_domain_redirdev_new ();
#line 385 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				usb_redir = _tmp4_;
#line 386 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = usb_redir;
#line 386 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_redirdev_set_bus (_tmp5_, GVIR_CONFIG_DOMAIN_REDIRDEV_BUS_USB);
#line 387 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_domain_chardev_source_spicevmc_new ();
#line 387 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				vmc = _tmp6_;
#line 388 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = usb_redir;
#line 388 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = vmc;
#line 388 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_chardev_set_source ((GVirConfigDomainChardev*) _tmp7_, (GVirConfigDomainChardevSource*) _tmp8_);
#line 389 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = domain;
#line 389 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = usb_redir;
#line 389 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				gvir_config_domain_add_device (_tmp9_, (GVirConfigDomainDevice*) _tmp10_);
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (vmc);
#line 384 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (usb_redir);
#line 2422 "vm-configurator.c"
			}
		}
	}
#line 393 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp11_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_EHCI1, NULL, (guint) 0, (guint) 0);
#line 393 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	master_controller = _tmp11_;
#line 394 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp12_ = domain;
#line 394 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp12_, (GVirConfigDomainDevice*) master_controller);
#line 395 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp13_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI1, master_controller, (guint) 0, (guint) 0);
#line 395 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp13_;
#line 396 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp14_ = domain;
#line 396 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = controller;
#line 396 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp14_, (GVirConfigDomainDevice*) _tmp15_);
#line 397 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp16_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI2, master_controller, (guint) 0, (guint) 2);
#line 397 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 397 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp16_;
#line 398 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp17_ = domain;
#line 398 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp18_ = controller;
#line 398 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp17_, (GVirConfigDomainDevice*) _tmp18_);
#line 399 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = boxes_vm_configurator_create_usb_controller (GVIR_CONFIG_DOMAIN_CONTROLLER_USB_MODEL_ICH9_UHCI3, master_controller, (guint) 0, (guint) 4);
#line 399 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 399 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp19_;
#line 400 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp20_ = domain;
#line 400 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp21_ = controller;
#line 400 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_add_device (_tmp20_, (GVirConfigDomainDevice*) _tmp21_);
#line 382 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (controller);
#line 382 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (master_controller);
#line 2472 "vm-configurator.c"
}


static GVirConfigDomainControllerUsb* boxes_vm_configurator_create_usb_controller (GVirConfigDomainControllerUsbModel model, GVirConfigDomainControllerUsb* master, guint index, guint start_port) {
	GVirConfigDomainControllerUsb* result = NULL;
	GVirConfigDomainControllerUsb* controller = NULL;
	GVirConfigDomainControllerUsb* _tmp0_ = NULL;
	GVirConfigDomainControllerUsb* _tmp1_ = NULL;
	GVirConfigDomainControllerUsbModel _tmp2_ = 0;
	GVirConfigDomainControllerUsb* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GVirConfigDomainControllerUsb* _tmp5_ = NULL;
#line 407 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = gvir_config_domain_controller_usb_new ();
#line 407 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	controller = _tmp0_;
#line 408 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = controller;
#line 408 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = model;
#line 408 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_controller_usb_set_model (_tmp1_, _tmp2_);
#line 409 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = controller;
#line 409 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp4_ = index;
#line 409 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_controller_set_index ((GVirConfigDomainController*) _tmp3_, _tmp4_);
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp5_ = master;
#line 410 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_tmp5_ != NULL) {
#line 2505 "vm-configurator.c"
		GVirConfigDomainControllerUsb* _tmp6_ = NULL;
		GVirConfigDomainControllerUsb* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
#line 411 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp6_ = controller;
#line 411 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp7_ = master;
#line 411 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		_tmp8_ = start_port;
#line 411 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		gvir_config_domain_controller_usb_set_master (_tmp6_, _tmp7_, _tmp8_);
#line 2517 "vm-configurator.c"
	}
#line 413 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = controller;
#line 413 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2523 "vm-configurator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return self ? g_object_ref (self) : NULL;
#line 2530 "vm-configurator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2537 "vm-configurator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_list_free (self);
#line 2546 "vm-configurator.c"
}


void boxes_vm_configurator_remove_usb_controllers (GVirConfigDomain* domain, GError** error) {
	GList* devices = NULL;
	GVirConfigDomain* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GVirConfigDomain* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
#line 417 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (domain != NULL);
#line 418 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	devices = NULL;
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = domain;
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_domain_get_devices (_tmp0_);
#line 2564 "vm-configurator.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		device_collection = _tmp1_;
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 2572 "vm-configurator.c"
			GVirConfigDomainDevice* _tmp2_ = NULL;
			GVirConfigDomainDevice* device = NULL;
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = _g_object_ref0 ((GVirConfigDomainDevice*) device_it->data);
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			device = _tmp2_;
#line 2579 "vm-configurator.c"
			{
				GVirConfigDomainDevice* _tmp3_ = NULL;
#line 420 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = device;
#line 420 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gvir_config_domain_controller_usb_get_type ())) {
#line 2586 "vm-configurator.c"
					GVirConfigDomainDevice* _tmp4_ = NULL;
					GVirConfigDomainDevice* _tmp5_ = NULL;
#line 421 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp4_ = device;
#line 421 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp5_ = _g_object_ref0 (_tmp4_);
#line 421 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					devices = g_list_prepend (devices, _tmp5_);
#line 2595 "vm-configurator.c"
				}
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (device);
#line 2599 "vm-configurator.c"
			}
		}
#line 419 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (device_collection);
#line 2604 "vm-configurator.c"
	}
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	devices = g_list_reverse (devices);
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp6_ = domain;
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp7_ = devices;
#line 425 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	gvir_config_domain_set_devices (_tmp6_, _tmp7_);
#line 417 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (devices);
#line 2616 "vm-configurator.c"
}


static GVirConfigCapabilitiesGuest* boxes_vm_configurator_get_best_guest_caps (GVirConfigCapabilities* caps, BoxesInstallerMedia* install_media, GError** error) {
	GVirConfigCapabilitiesGuest* result = NULL;
	GList* guests_caps = NULL;
	GVirConfigCapabilities* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* compat_guests_caps = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp15_ = NULL;
	GList* _tmp19_ = NULL;
	const gchar* _tmp23_ = NULL;
	GError* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (caps != NULL, NULL);
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (install_media != NULL, NULL);
#line 430 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = caps;
#line 430 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_get_guests (_tmp0_);
#line 430 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	guests_caps = _tmp1_;
#line 433 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	compat_guests_caps = NULL;
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = guests_caps;
#line 2646 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp2_;
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2654 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp3_ = NULL;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp3_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp3_;
#line 2661 "vm-configurator.c"
			{
				gchar* guest_arch = NULL;
				GVirConfigCapabilitiesGuest* _tmp4_ = NULL;
				GVirConfigCapabilitiesGuestArch* _tmp5_ = NULL;
				GVirConfigCapabilitiesGuestArch* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				BoxesInstallerMedia* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = guest_caps;
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_capabilities_guest_get_arch (_tmp4_);
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = _tmp5_;
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp7_ = gvir_config_capabilities_guest_arch_get_name (_tmp6_);
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp9_ = _tmp8_;
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (_tmp6_);
#line 435 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				guest_arch = _tmp9_;
#line 437 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp10_ = install_media;
#line 437 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp11_ = guest_arch;
#line 437 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp12_ = boxes_installer_media_is_architecture_compatible (_tmp10_, _tmp11_);
#line 437 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp12_) {
#line 2697 "vm-configurator.c"
					GVirConfigCapabilitiesGuest* _tmp13_ = NULL;
					GVirConfigCapabilitiesGuest* _tmp14_ = NULL;
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp13_ = guest_caps;
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_tmp14_ = _g_object_ref0 (_tmp13_);
#line 438 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					compat_guests_caps = g_list_append (compat_guests_caps, _tmp14_);
#line 2706 "vm-configurator.c"
				}
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_free0 (guest_arch);
#line 434 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2712 "vm-configurator.c"
			}
		}
	}
#line 442 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp15_ = compat_guests_caps;
#line 2718 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 442 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp15_;
#line 442 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2726 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp16_ = NULL;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 442 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp16_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 442 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp16_;
#line 2733 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
#line 443 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp17_ = guest_caps;
#line 443 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp18_ = boxes_vm_configurator_guest_kvm_enabled (_tmp17_);
#line 443 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp18_) {
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 444 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2751 "vm-configurator.c"
				}
#line 442 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2755 "vm-configurator.c"
			}
		}
	}
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp19_ = compat_guests_caps;
#line 2761 "vm-configurator.c"
	{
		GList* guest_caps_collection = NULL;
		GList* guest_caps_it = NULL;
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		guest_caps_collection = _tmp19_;
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (guest_caps_it = guest_caps_collection; guest_caps_it != NULL; guest_caps_it = guest_caps_it->next) {
#line 2769 "vm-configurator.c"
			GVirConfigCapabilitiesGuest* _tmp20_ = NULL;
			GVirConfigCapabilitiesGuest* guest_caps = NULL;
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp20_ = _g_object_ref0 ((GVirConfigCapabilitiesGuest*) guest_caps_it->data);
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			guest_caps = _tmp20_;
#line 2776 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuest* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
#line 448 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp21_ = guest_caps;
#line 448 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp22_ = boxes_vm_configurator_guest_is_qemu (_tmp21_);
#line 448 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp22_) {
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = guest_caps;
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (guests_caps);
#line 449 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2794 "vm-configurator.c"
				}
#line 447 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (guest_caps);
#line 2798 "vm-configurator.c"
			}
		}
	}
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp23_ = _ ("Incapable host system");
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp24_ = g_error_new_literal (BOXES_VM_CONFIGURATOR_ERROR, BOXES_VM_CONFIGURATOR_ERROR_NO_GUEST_CAPS, _tmp23_);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_inner_error_ = _tmp24_;
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (_inner_error_->domain == BOXES_VM_CONFIGURATOR_ERROR) {
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_propagate_error (error, _inner_error_);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 2818 "vm-configurator.c"
	} else {
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (guests_caps);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_clear_error (&_inner_error_);
#line 453 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return NULL;
#line 2830 "vm-configurator.c"
	}
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (compat_guests_caps);
#line 428 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	__g_list_free__g_object_unref0_0 (guests_caps);
#line 2836 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_kvm_enabled (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuest* _tmp0_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
#line 456 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 457 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 457 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
#line 457 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp1_;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = arch;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
#line 2859 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp3_;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 2867 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp4_ = NULL;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp4_;
#line 2874 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_ = NULL;
				GVirConfigDomainVirtType _tmp6_ = 0;
#line 459 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = domain;
#line 459 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
#line 459 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_KVM) {
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 460 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2894 "vm-configurator.c"
				}
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 2898 "vm-configurator.c"
			}
		}
#line 458 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 2903 "vm-configurator.c"
	}
#line 462 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 462 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 462 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2911 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_is_qemu (GVirConfigCapabilitiesGuest* guest_caps) {
	gboolean result = FALSE;
	GVirConfigCapabilitiesGuestArch* arch = NULL;
	GVirConfigCapabilitiesGuest* _tmp0_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp1_ = NULL;
	GVirConfigCapabilitiesGuestArch* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
#line 465 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 466 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 466 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_arch (_tmp0_);
#line 466 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	arch = _tmp1_;
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp2_ = arch;
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp3_ = gvir_config_capabilities_guest_arch_get_domains (_tmp2_);
#line 2934 "vm-configurator.c"
	{
		GList* domain_collection = NULL;
		GList* domain_it = NULL;
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		domain_collection = _tmp3_;
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (domain_it = domain_collection; domain_it != NULL; domain_it = domain_it->next) {
#line 2942 "vm-configurator.c"
			GVirConfigCapabilitiesGuestDomain* _tmp4_ = NULL;
			GVirConfigCapabilitiesGuestDomain* domain = NULL;
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp4_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestDomain*) domain_it->data);
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			domain = _tmp4_;
#line 2949 "vm-configurator.c"
			{
				GVirConfigCapabilitiesGuestDomain* _tmp5_ = NULL;
				GVirConfigDomainVirtType _tmp6_ = 0;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = domain;
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp6_ = gvir_config_capabilities_guest_domain_get_virt_type (_tmp5_);
#line 468 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (_tmp6_ == GVIR_CONFIG_DOMAIN_VIRT_QEMU) {
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					result = TRUE;
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (domain);
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					__g_list_free__g_object_unref0_0 (domain_collection);
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (arch);
#line 469 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					return result;
#line 2969 "vm-configurator.c"
				}
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (domain);
#line 2973 "vm-configurator.c"
			}
		}
#line 467 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (domain_collection);
#line 2978 "vm-configurator.c"
	}
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = FALSE;
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_g_object_unref0 (arch);
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 2986 "vm-configurator.c"
}


static gboolean boxes_vm_configurator_guest_supports_feature (GVirConfigCapabilitiesGuest* guest_caps, const gchar* feature_name) {
	gboolean result = FALSE;
	gboolean supports = FALSE;
	GVirConfigCapabilitiesGuest* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 474 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (guest_caps != NULL, FALSE);
#line 474 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (feature_name != NULL, FALSE);
#line 475 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	supports = FALSE;
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp0_ = guest_caps;
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	_tmp1_ = gvir_config_capabilities_guest_get_features (_tmp0_);
#line 3005 "vm-configurator.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		feature_collection = _tmp1_;
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 3013 "vm-configurator.c"
			GVirConfigCapabilitiesGuestFeature* _tmp2_ = NULL;
			GVirConfigCapabilitiesGuestFeature* feature = NULL;
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			_tmp2_ = _g_object_ref0 ((GVirConfigCapabilitiesGuestFeature*) feature_it->data);
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			feature = _tmp2_;
#line 3020 "vm-configurator.c"
			{
				const gchar* _tmp3_ = NULL;
				GVirConfigCapabilitiesGuestFeature* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
#line 478 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp3_ = feature_name;
#line 478 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp4_ = feature;
#line 478 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_tmp5_ = gvir_config_capabilities_guest_feature_get_name (_tmp4_);
#line 478 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 479 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					supports = TRUE;
#line 481 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					_g_object_unref0 (feature);
#line 481 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
					break;
#line 3039 "vm-configurator.c"
				}
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
				_g_object_unref0 (feature);
#line 3043 "vm-configurator.c"
			}
		}
#line 477 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		__g_list_free__g_object_unref0_0 (feature_collection);
#line 3048 "vm-configurator.c"
	}
#line 484 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	result = supports;
#line 484 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return result;
#line 3054 "vm-configurator.c"
}


BoxesVMConfigurator* boxes_vm_configurator_construct (GType object_type) {
	BoxesVMConfigurator* self = NULL;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self = (BoxesVMConfigurator*) g_type_create_instance (object_type);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return self;
#line 3064 "vm-configurator.c"
}


BoxesVMConfigurator* boxes_vm_configurator_new (void) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return boxes_vm_configurator_construct (BOXES_TYPE_VM_CONFIGURATOR);
#line 3071 "vm-configurator.c"
}


static void boxes_value_vm_configurator_init (GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	value->data[0].v_pointer = NULL;
#line 3078 "vm-configurator.c"
}


static void boxes_value_vm_configurator_free_value (GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (value->data[0].v_pointer);
#line 3087 "vm-configurator.c"
	}
}


static void boxes_value_vm_configurator_copy_value (const GValue* src_value, GValue* dest_value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = boxes_vm_configurator_ref (src_value->data[0].v_pointer);
#line 3097 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3101 "vm-configurator.c"
	}
}


static gpointer boxes_value_vm_configurator_peek_pointer (const GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 3109 "vm-configurator.c"
}


static gchar* boxes_value_vm_configurator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (collect_values[0].v_pointer) {
#line 3116 "vm-configurator.c"
		BoxesVMConfigurator* object;
		object = collect_values[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3123 "vm-configurator.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3127 "vm-configurator.c"
		}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = boxes_vm_configurator_ref (object);
#line 3131 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3135 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 3139 "vm-configurator.c"
}


static gchar* boxes_value_vm_configurator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesVMConfigurator** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (!object_p) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3150 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = NULL;
#line 3156 "vm-configurator.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = value->data[0].v_pointer;
#line 3160 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		*object_p = boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 3164 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return NULL;
#line 3168 "vm-configurator.c"
}


GParamSpec* boxes_param_spec_vm_configurator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecVMConfigurator* spec;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return G_PARAM_SPEC (spec);
#line 3182 "vm-configurator.c"
}


gpointer boxes_value_get_vm_configurator (const GValue* value) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR), NULL);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return value->data[0].v_pointer;
#line 3191 "vm-configurator.c"
}


void boxes_value_set_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_ref (value->data[0].v_pointer);
#line 3211 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3215 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 3221 "vm-configurator.c"
	}
}


void boxes_value_take_vm_configurator (GValue* value, gpointer v_object) {
	BoxesVMConfigurator* old;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	old = value->data[0].v_pointer;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (v_object) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_VM_CONFIGURATOR));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = v_object;
#line 3240 "vm-configurator.c"
	} else {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		value->data[0].v_pointer = NULL;
#line 3244 "vm-configurator.c"
	}
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (old) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		boxes_vm_configurator_unref (old);
#line 3250 "vm-configurator.c"
	}
}


static void boxes_vm_configurator_class_init (BoxesVMConfiguratorClass * klass) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	boxes_vm_configurator_parent_class = g_type_class_peek_parent (klass);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	BOXES_VM_CONFIGURATOR_CLASS (klass)->finalize = boxes_vm_configurator_finalize;
#line 3260 "vm-configurator.c"
}


static void boxes_vm_configurator_instance_init (BoxesVMConfigurator * self) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self->ref_count = 1;
#line 3267 "vm-configurator.c"
}


static void boxes_vm_configurator_finalize (BoxesVMConfigurator* obj) {
	BoxesVMConfigurator * self;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_VM_CONFIGURATOR, BoxesVMConfigurator);
#line 3275 "vm-configurator.c"
}


GType boxes_vm_configurator_get_type (void) {
	static volatile gsize boxes_vm_configurator_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_vm_configurator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_vm_configurator_init, boxes_value_vm_configurator_free_value, boxes_value_vm_configurator_copy_value, boxes_value_vm_configurator_peek_pointer, "p", boxes_value_vm_configurator_collect_value, "p", boxes_value_vm_configurator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesVMConfiguratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_vm_configurator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesVMConfigurator), 0, (GInstanceInitFunc) boxes_vm_configurator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_vm_configurator_type_id;
		boxes_vm_configurator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesVMConfigurator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_vm_configurator_type_id__volatile, boxes_vm_configurator_type_id);
	}
	return boxes_vm_configurator_type_id__volatile;
}


gpointer boxes_vm_configurator_ref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	return instance;
#line 3300 "vm-configurator.c"
}


void boxes_vm_configurator_unref (gpointer instance) {
	BoxesVMConfigurator* self;
	self = instance;
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		BOXES_VM_CONFIGURATOR_GET_CLASS (self)->finalize (self);
#line 10 "/extra-data/checkout/gnome/gnome-boxes/src/vm-configurator.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3313 "vm-configurator.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3321 "vm-configurator.c"
		int i;
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3329 "vm-configurator.c"
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 471 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 3341 "vm-configurator.c"
}



