## ------------------------
## Python file handling
## From Andrew Dalke
## Updated by James Henstridge
## ------------------------

# AM_PATH_PYTHON([MINIMUM-VERSION])

# Adds support for distributing Python modules and packages.  To
# install modules, copy them to $(pythondir), using the python_PYTHON
# automake variable.  To install a package with the same name as the
# automake package, install to $(pkgpythondir), or use the
# pkgpython_PYTHON automake variable.

# The variables $(pyexecdir) and $(pkgpyexecdir) are provided as
# locations to install python extension modules (shared libraries).
# Another macro is required to find the appropriate flags to compile
# extension modules.

# If your package is configured with a different prefix to python,
# users will have to add the install directory to the PYTHONPATH
# environment variable, or create a .pth file (see the python
# documentation for details).

# If the MINIUMUM-VERSION argument is passed, AM_PATH_PYTHON will
# cause an error if the version of python installed on the system
# doesn't meet the requirement.  MINIMUM-VERSION should consist of
# numbers and dots only.


AC_DEFUN([AM_PATH_PYTHON],
 [
  dnl Find a version of Python.  I could check for python versions 1.4
  dnl or earlier, but the default installation locations changed from
  dnl $prefix/lib/site-python in 1.4 to $prefix/lib/python1.5/site-packages
  dnl in 1.5, and I don't want to maintain that logic.

  AC_PATH_PROG(PYTHON, python python2.1 python2.0 python1.6 python1.5)

  dnl should we do the version check?
  ifelse([$1],[],,[
    AC_MSG_CHECKING(if Python version >= $1)
    changequote(<<, >>)dnl
    prog="
import sys, string
minver = '$1'
pyver = string.split(sys.version)[0]  # first word is version string
# split strings by '.' and convert to numeric
minver = map(string.atoi, string.split(minver, '.'))
pyver = map(string.atoi, string.split(pyver, '.'))
# we can now do comparisons on the two lists:
if pyver >= minver:
	sys.exit(0)
else:
	sys.exit(1)"
    changequote([, ])dnl
    if $PYTHON -c "$prog" 1>&AC_FD_CC 2>&AC_FD_CC
    then
      AC_MSG_RESULT(okay)
    else
      AC_MSG_ERROR(too old)
    fi
  ])

  AC_MSG_CHECKING([local Python configuration])

  dnl Query Python for its version number.  Getting [:3] seems to be
  dnl the best way to do this; it's what "site.py" does in the standard
  dnl library.  Need to change quote character because of [:3]

  AC_SUBST(PYTHON_VERSION)
  changequote(<<, >>)dnl
  PYTHON_VERSION=`$PYTHON -c "import sys; print sys.version[:3]"`
  changequote([, ])dnl


  dnl Use the values of $prefix and $exec_prefix for the corresponding
  dnl values of PYTHON_PREFIX and PYTHON_EXEC_PREFIX.  These are made
  dnl distinct variables so they can be overridden if need be.  However,
  dnl general consensus is that you shouldn't need this ability.

  AC_SUBST(PYTHON_PREFIX)
  changequote(<<, >>)dnl
  PYTHON_PREFIX=`$PYTHON -c "import sys; print sys.prefix"`
  changequote([, ])dnl

  AC_SUBST(PYTHON_EXEC_PREFIX)
  PYTHON_EXEC_PREFIX='${exec_prefix}'

  dnl At times (like when building shared libraries) you may want
  dnl to know which OS platform Python thinks this is.

  AC_SUBST(PYTHON_PLATFORM)
  PYTHON_PLATFORM=`$PYTHON -c "import sys; print sys.platform"`


  dnl Set up 4 directories:

  dnl pythondir -- where to install python scripts.  This is the
  dnl   site-packages directory, not the python standard library
  dnl   directory like in previous automake betas.  This behaviour
  dnl   is more consistent with lispdir.m4 for example.
  dnl
  dnl Also, if the package prefix isn't the same as python's prefix,
  dnl then the old $(pythondir) was pretty useless.

  AC_SUBST(pythondir)
  pythondir=$PYTHON_PREFIX${libdir##$prefix}"/python"$PYTHON_VERSION"/site-packages"

  dnl pkgpythondir -- $PACKAGE directory under pythondir.  Was
  dnl   PYTHON_SITE_PACKAGE in previous betas, but this naming is
  dnl   more consistent with the rest of automake.
  dnl   Maybe this should be put in python.am?

  AC_SUBST(pkgpythondir)
  pkgpythondir=\${pythondir}/$PACKAGE

  dnl pyexecdir -- directory for installing python extension modules
  dnl   (shared libraries)  Was PYTHON_SITE_EXEC in previous betas.

  AC_SUBST(pyexecdir)
  pyexecdir=$PYTHON_EXEC_PREFIX"/lib/python"$PYTHON_VERSION/site-packages

  dnl pkgpyexecdir -- $(pyexecdir)/$(PACKAGE)
  dnl   Maybe this should be put in python.am?

  AC_SUBST(pkgpyexecdir)
  pkgpyexecdir=\${pyexecdir}/$PACKAGE

  AC_MSG_RESULT([looks good])
])
dnl -- taken from gnome-python -- thanks james henstridge
dnl a macro to check for ability to create python extensions
dnl  AM_CHECK_PYTHON_HEADERS([ACTION-IF-POSSIBLE], [ACTION-IF-NOT-POSSIBLE])
dnl function also defines PYTHON_INCLUDES
AC_DEFUN([AM_CHECK_PYTHON_HEADERS],
[AC_REQUIRE([AM_PATH_PYTHON])
AC_MSG_CHECKING(for headers required to compile python extensions)
dnl deduce PYTHON_INCLUDES
py_prefix=`$PYTHON -c "import sys; print sys.prefix"`
py_exec_prefix=`$PYTHON -c "import sys; print sys.exec_prefix"`
PYTHON_INCLUDES="-I${py_prefix}/include/python${PYTHON_VERSION}"
if test "$py_prefix" != "$py_exec_prefix"; then
  PYTHON_INCLUDES="$PYTHON_INCLUDES -I${py_exec_prefix}/include/python${PYTHON_VERSION}"
fi
AC_SUBST(PYTHON_INCLUDES)
dnl check if the headers exist:
save_CPPFLAGS="$CPPFLAGS"
CPPFLAGS="$CPPFLAGS $PYTHON_INCLUDES"
AC_TRY_CPP([#include <Python.h>],dnl
[AC_MSG_RESULT(found)
$1],dnl
[AC_MSG_RESULT(not found)
$2])
CPPFLAGS="$save_CPPFLAGS"
])

dnl
dnl JH_ADD_CFLAG(FLAG)
dnl checks whether the C compiler supports the given flag, and if so, adds
dnl it to $CFLAGS.  If the flag is already present in the list, then the
dnl check is not performed.
AC_DEFUN([JH_ADD_CFLAG],
[
case " $CFLAGS " in
*@<:@\	\ @:>@$1@<:@\	\ @:>@*)
  ;;
*)
  save_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS $1"
  AC_MSG_CHECKING([whether [$]CC understands $1])
  AC_TRY_COMPILE([], [], [jh_has_option=yes], [jh_has_option=no])
  AC_MSG_RESULT($jh_has_option)
  if test $jh_has_option = no; then
    CFLAGS="$save_CFLAGS"
  fi
  ;;
esac])
dnl Configure paths for libsdp
dnl Edd Dumbill <edd@usefulinc.com>
dnl Shamelessly stolen from Jack Moffitt, who stole
dnl it from Owen Taylor and Manish Singh

dnl BLUEZ_PATH_SDP([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl
AC_DEFUN([BLUEZ_PATH_SDP],
[dnl 
dnl Get the cflags and libraries
dnl
AC_ARG_ENABLE(sdptest, [  --disable-sdptest       Do not try to compile and run a test SDP program],, enable_sdptest=yes)

  SDP_LIBS="-lsdp"
  SDP_CFLAGS=""

  AC_MSG_CHECKING(for SDP support)
  no_sdp=""

  if test "x$enable_sdptest" = "xyes" ; then
    ac_save_CFLAGS="$CFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $SDP_CFLAGS $GLIB_CFLAGS $BLUETOOTH_CFLAGS"
    LIBS="$LIBS $SDP_LIBS $GLIB_LIBS"
dnl
dnl Now check if the installed Sdp is sufficiently new.
dnl
      rm -f conf.sdptest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bluetooth/sdp.h>
#include <bluetooth/sdp_lib.h>

int main ()
{
  uuid_t group;
  sdp_uuid16_create(&group, PUBLIC_BROWSE_GROUP);
  system("touch conf.sdptest");
  return 0;
}

],, no_sdp=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
  fi

  if test "x$no_sdp" = "x" ; then
     AC_MSG_RESULT(yes)
     ifelse([$1], , :, [$1])     
  else
     AC_MSG_RESULT(no)
     if test -f conf.sdptest ; then
       :
     else
       echo "*** Could not run libsdp test program, checking why..."
       CFLAGS="$CFLAGS $SDP_CFLAGS $GLIB_CFLAGS"
       LIBS="$LIBS $SDP_LIBS $GLIB_LIBS"
       AC_TRY_LINK([
#include <stdio.h>
#include <bluetooth/sdp.h>
],     [ return 0; ],
       [ echo "*** The test program compiled, but did not run. This usually means"
       echo "*** that the run-time linker is not finding libsdp 1.0 or finding the wrong"
       echo "*** version of libsdp. "
       echo "***"
       echo "*** You can ignore this if your bluez-libs is version 2.6 or better."
       echo "*** If not, you won't be able to compile this code until you install"
       echo "*** bluez-sdp."
       ],
       [ echo "*** The test program failed to compile or link. See the file config.log for the"
       echo "*** exact error that occurred. This usually means libsdp was incorrectly"
       echo "*** installed or that you have moved libsdp since it was installed."
       echo "***"
       echo "*** You can ignore this if your bluez-libs is version 2.7 or better."
       echo "*** If not, you won't be able to compile this code until you install"
       echo "*** bluez-sdp."

       ])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
     SDP_CFLAGS=""
     SDP_LIBS=""
     ifelse([$2], , :, [$2])
  fi
  AC_SUBST(SDP_CFLAGS)
  AC_SUBST(SDP_LIBS)
  rm -f conf.sdptest
])
# Configure paths for libbluetooth
# Edd Dumbill <edd@usefulinc.com>
# Shamelessly stolen from Jack Moffitt, who stole
# it from Owen Taylor and Manish Singh

dnl BLUEZ_PATH_BLUETOOTH([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for libbluetooth, and define BLUETOOTH_CFLAGS and BLUETOOTH_LIBS
dnl
AC_DEFUN([BLUEZ_PATH_BLUETOOTH],
[dnl 
dnl Get the cflags and libraries
dnl
AC_ARG_WITH(bluetooth,[  --with-bluetooth=PFX   Prefix where libbluetooth is installed (optional)], bluetooth_prefix="$withval", bluetooth_prefix="")
AC_ARG_WITH(bluetooth-libraries,[  --with-bluetooth-libraries=DIR   Directory where libbluetooth library is installed (optional)], bluetooth_libraries="$withval", bluetooth_libraries="")
AC_ARG_WITH(bluetooth-includes,[  --with-bluetooth-includes=DIR   Directory where libbluetooth header files are installed (optional)], bluetooth_includes="$withval", bluetooth_includes="")
AC_ARG_ENABLE(bluetoothtest, [  --disable-bluetoothtest       Do not try to compile and run a test Bluetooth program],, enable_bluetoothtest=yes)

  if test "x$bluetooth_libraries" != "x" ; then
    BLUETOOTH_LIBS="-L$bluetooth_libraries"
  elif test "x$bluetooth_prefix" != "x" ; then
    BLUETOOTH_LIBS="-L$bluetooth_prefix/lib"
  elif test "x$prefix" != "xNONE" ; then
    BLUETOOTH_LIBS="-L$prefix/lib"
  fi

  BLUETOOTH_LIBS="$BLUETOOTH_LIBS -lbluetooth"

  if test "x$bluetooth_includes" != "x" ; then
    BLUETOOTH_CFLAGS="-I$bluetooth_includes"
  elif test "x$bluetooth_prefix" != "x" ; then
    BLUETOOTH_CFLAGS="-I$bluetooth_prefix/include"
  elif test "$prefix" != "xNONE"; then
    BLUETOOTH_CFLAGS="-I$prefix/include"
  fi

  AC_MSG_CHECKING(for libbluetooth)
  no_bluetooth=""


  if test "x$enable_bluetoothtest" = "xyes" ; then
    ac_save_CFLAGS="$CFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $BLUETOOTH_CFLAGS"
    LIBS="$LIBS $BLUETOOTH_LIBS"
dnl
dnl Now check if the installed Bluetooth is sufficiently new.
dnl
      rm -f conf.bluetoothtest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bluetooth/bluetooth.h>

int main ()
{
  bdaddr_t bdaddr;

  str2ba("00:00:00:11:11:11", &bdaddr);
  system("touch conf.bluetoothtest");
  return 0;
}

],, no_bluetooth=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
  fi

  if test "x$no_bluetooth" = "x" ; then
     AC_MSG_RESULT(yes)
     ifelse([$1], , :, [$1])     
  else
     AC_MSG_RESULT(no)
     if test -f conf.bluetoothtest ; then
       :
     else
       echo "*** Could not run libluetooth test program, checking why..."
       CFLAGS="$CFLAGS $BLUETOOTH_CFLAGS"
       LIBS="$LIBS $BLUETOOTH_LIBS"
       AC_TRY_LINK([
#include <stdio.h>
#include <bluetooth/bluetooth.h>
],     [ return 0; ],
       [ echo "*** The test program compiled, but did not run. This usually means"
       echo "*** that the run-time linker is not finding libbluetooth or finding the wrong"
       echo "*** version of libbluetooth. If it is not finding libbluetooth, you'll need to set your"
       echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
       echo "*** to the installed location  Also, make sure you have run ldconfig if that"
       echo "*** is required on your system"
       echo "***"
       echo "*** If you have an old version installed, it is best to remove it, although"
       echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
       [ echo "*** The test program failed to compile or link. See the file config.log for the"
       echo "*** exact error that occurred. This usually means libbluetooth was incorrectly installed"
       echo "*** or that you have moved libbluetooth since it was installed." ])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
     BLUETOOTH_CFLAGS=""
     BLUETOOTH_LIBS=""
     ifelse([$2], , :, [$2])
  fi
  AC_SUBST(BLUETOOTH_CFLAGS)
  AC_SUBST(BLUETOOTH_LIBS)
  rm -f conf.bluetoothtest
])
