/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GSWITCHIT_CONFIG_H__
#define __GSWITCHIT_CONFIG_H__

#include <X11/Xlib.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gconf/gconf-client.h>

extern const char GSWITCHIT_CONFIG_DIR[];
extern const char GSWITCHIT_CONFIG_KEY_DEFAULT_GROUP[];
extern const char GSWITCHIT_CONFIG_KEY_GROUP_PER_WINDOW[];
extern const char GSWITCHIT_CONFIG_KEY_HANDLE_INDICATORS[];
extern const char GSWITCHIT_CONFIG_KEY_LAYOUT_NAMES_AS_GROUP_NAMES[];

extern const char GSWITCHIT_KBD_CONFIG_DIR[];
extern const char GSWITCHIT_KBD_CONFIG_KEY_OVERRIDE_SETTINGS[];
extern const char GSWITCHIT_KBD_CONFIG_KEY_MODEL[];
extern const char GSWITCHIT_KBD_CONFIG_KEY_LAYOUTS[];
extern const char GSWITCHIT_KBD_CONFIG_KEY_OPTIONS[];

/*
 * General configuration
 */
typedef struct _GSwitchItConfig {
	int defaultGroup;
	gboolean groupPerApp;
	gboolean handleIndicators;
	gboolean layoutNamesAsGroupNames;

	/* private, transient */
	GConfClient *confClient;
} GSwitchItConfig;

/*
 * Keyboard Configuration
 */
typedef struct _GSwitchItKbdConfig {
	gboolean overrideSettings;
	gchar *model;
	GSList *layouts;
	GSList *options;

	/* private, transient */
	GConfClient *confClient;
} GSwitchItKbdConfig;

/*
 * Applet configuration
 */
typedef struct _GSwitchItAppletConfig {
	int secondaryGroupsMask;
	gboolean showFlags;

	GSList *enabledPlugins;

	/* private, transient */
	GConfClient *confClient;
	GSList *images;
	GtkIconTheme *iconTheme;
} GSwitchItAppletConfig;

/**
 * GSwitchItConfig functions
 */
extern void GSwitchItConfigInit (GSwitchItConfig * config,
				 GConfClient * confClient);
extern void GSwitchItConfigTerm (GSwitchItConfig * config);

extern void GSwitchItConfigLoad (GSwitchItConfig * config);

extern void GSwitchItConfigSave (GSwitchItConfig * config);

extern gboolean GSwitchItConfigActivate (GSwitchItConfig * config);

/* Affected by XKB and XKB/GConf configuration */
extern GSList *
GSwitchItConfigLoadGroupDescriptionsUtf8 (GSwitchItConfig * config);

extern void GSwitchItConfigLockNextGroup (void);

extern void GSwitchItConfigLockPrevGroup (void);

extern void GSwitchItConfigRestoreGroup (void);

extern void GSwitchItConfigStartListen (GSwitchItConfig * config,
					GConfClientNotifyFunc func, 
					gpointer user_data);

extern void GSwitchItConfigStopListen (GSwitchItConfig * config);

/**
 * GSwitchItKbdConfig functions
 */
extern void GSwitchItKbdConfigInit (GSwitchItKbdConfig * kbdConfig,
				    GConfClient * confClient);
extern void GSwitchItKbdConfigTerm (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigLoad (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigSave (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigLoadSysBackup (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigSaveSysBackup (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigLoadInitial (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigLoadCurrent (GSwitchItKbdConfig * kbdConfig);

extern void GSwitchItKbdConfigStartListen (GSwitchItKbdConfig * kbdConfig,
					   GConfClientNotifyFunc func, 
					   gpointer user_data);

extern void GSwitchItKbdConfigStopListen (GSwitchItKbdConfig * kbdConfig);

extern gboolean GSwitchItKbdConfigEquals (GSwitchItKbdConfig * kbdConfig1,
					  GSwitchItKbdConfig * kbdConfig2);

extern gboolean GSwitchItKbdConfigActivate (GSwitchItKbdConfig * kbdConfig);

extern const char *GSwitchItKbdConfigMergeItems (const char *parent,
						 const char *child);

extern gboolean GSwitchItKbdConfigSplitItems (const char *merged,
					      char **parent, char **child);

extern Bool GSwitchItKbdConfigGetDescriptions (const char *name,
					       char **layoutShortDescr,
					       char **layoutDescr,
					       char **variantShortDescr,
					       char **variantDescr);

extern const char *GSwitchItKbdConfigFormatFullLayout (const char *layoutDescr, 
						       const char *variantDescr);

/**
 * GSwitchItAppletConfig functions - 
 * some of them require GSwitchItKbdConfig as well - 
 * for loading approptiate images
 */
extern void GSwitchItAppletConfigInit (GSwitchItAppletConfig *
				       appletConfig,
				       GConfClient * confClient);
extern void GSwitchItAppletConfigTerm (GSwitchItAppletConfig *
				       appletConfig);

extern void GSwitchItAppletConfigLoad (GSwitchItAppletConfig *
				       appletConfig);
extern void GSwitchItAppletConfigSave (GSwitchItAppletConfig *
				       appletConfig);

extern char
*GSwitchItAppletConfigGetImagesFile (GSwitchItAppletConfig *
				     appletConfig,
				     GSwitchItKbdConfig * kbdConfig,
				     int group);

extern void GSwitchItAppletConfigLoadImages (GSwitchItAppletConfig *
					     appletConfig,
					     GSwitchItKbdConfig *
					     kbdConfig);
extern void GSwitchItAppletConfigFreeImages (GSwitchItAppletConfig *
					     appletConfig);

/* Should be updated on Applet/GConf and Kbd/GConf configuration change */
extern void GSwitchItAppletConfigUpdateImages (GSwitchItAppletConfig *
					       appletConfig,
					       GSwitchItKbdConfig *
					       kbdConfig);

/* Should be updated on Applet/GConf configuration change */
extern void GSwitchItAppletConfigActivate (GSwitchItAppletConfig *
					   appletConfig);

extern void GSwitchItAppletConfigStartListen (GSwitchItAppletConfig *
					      appletConfig,
					      GConfClientNotifyFunc
					      func, gpointer user_data);

extern void GSwitchItAppletConfigStopListen (GSwitchItAppletConfig *
					     appletConfig);

#endif
