/* application.c generated by valac 0.33.1, the Vala compiler
 * generated from application.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
 * Copyright (C) 2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgnome-games-support.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <clutter/clutter.h>
#include <stdio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk/gdk.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* _settings;
	gint _window_width;
	gint _window_height;
	gboolean _window_maximized;
	gint WINDOW_MINIMUM_SIZE_HEIGHT;
	gint WINDOW_MINIMUM_SIZE_WIDTH;
	GtkWindow* _window;
	GtkHeaderBar* _header_bar;
	GtkButton* _undo_button;
	GtkButton* _new_game_button;
	GtkDialog* _preferences_dialog;
	GtkDialog* _congrats_dialog;
	GtkLabel* _congrats_message;
	GtkLabel* _score;
	GtkComboBoxText* _grid_size_combo;
	GamesScoresContext* _scores_ctx;
	GamesScoresCategory* _grid4_cat;
	GamesScoresCategory* _grid5_cat;
	gboolean _game_restored;
	Game* _game;
};


static gpointer application_parent_class = NULL;

GType application_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static void application_undo_cb (Application* self);
static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_new_game_cb (Application* self);
static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_scores_cb (Application* self);
static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_preferences_cb (Application* self);
static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_about_cb (Application* self);
static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_quit_cb (Application* self);
static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint application_main (gchar** args, int args_length1);
Application* application_new (void);
Application* application_construct (GType object_type);
static void application_real_startup (GApplication* base);
static void _application_init_game (Application* self);
static void _application_create_window (Application* self, GtkBuilder* builder);
static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder);
static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder);
static void _application_create_scores (Application* self);
gboolean game_restore_game (Game* self);
static void application_real_activate (GApplication* base);
static void application_real_shutdown (GApplication* base);
void game_save_game (Game* self);
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
static void __lambda4_ (Application* self, GObject* s, GParamSpec* p);
guint game_get_score (Game* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (Application* self, Game* s);
static void ___lambda6_ (Application* self, GObject* object, GAsyncResult* _result_);
static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda5__game_finished (Game* _sender, gpointer self);
static void __lambda7_ (Application* self, Game* s, guint v);
static void ___lambda7__game_target_value_reached (Game* _sender, guint val, gpointer self);
static void __lambda8_ (Application* self, Game* s);
static void ___lambda8__game_undo_enabled (Game* _sender, gpointer self);
static void __lambda9_ (Application* self, Game* s);
static void ___lambda9__game_undo_disabled (Game* _sender, gpointer self);
static void _application_create_header_bar (Application* self);
static void _application_create_game_view (Application* self, GtkBuilder* builder);
static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void application_window_size_allocate_cb (Application* self);
static void _application_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event);
static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
void game_set_view (Game* self, ClutterActor* value);
static void __lambda10_ (Application* self, gint response_id);
static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda11_ (Application* self, GdkEventAny* response_id);
gboolean game_reload_settings (Game* self);
static gboolean ___lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda12_ (Application* self, gint response_id);
static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda13_ (Application* self, GdkEventAny* response_id);
static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static GamesScoresCategory* application_category_request (Application* self, const gchar* key);
static GamesScoresCategory* _application_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
void game_undo (Game* self);
void game_new_game (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
static void application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_action_entries[6] = {{"undo", _application_undo_cb_gsimple_action_activate_callback}, {"new-game", _application_new_game_cb_gsimple_action_activate_callback}, {"scores", _application_scores_cb_gsimple_action_activate_callback}, {"preferences", _application_preferences_cb_gsimple_action_activate_callback}, {"about", _application_about_cb_gsimple_action_activate_callback}, {"quit", _application_quit_cb_gsimple_action_activate_callback}};

static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_undo_cb ((Application*) self);
#line 177 "application.c"
}


static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_new_game_cb ((Application*) self);
#line 184 "application.c"
}


static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_scores_cb ((Application*) self);
#line 191 "application.c"
}


static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_preferences_cb ((Application*) self);
#line 198 "application.c"
}


static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_about_cb ((Application*) self);
#line 205 "application.c"
}


static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_quit_cb ((Application*) self);
#line 212 "application.c"
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	Application* app = NULL;
	Application* _tmp18_ = NULL;
	Application* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	setlocale (LC_ALL, "");
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	textdomain (GETTEXT_PACKAGE);
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_option_context_new ("");
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	context = _tmp0_;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = context;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = gtk_get_option_group (TRUE);
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_option_context_add_group (_tmp1_, _tmp2_);
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = context;
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = clutter_get_option_group_without_init ();
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 255 "application.c"
	{
		GOptionContext* _tmp5_ = NULL;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = context;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "application.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp6_ = stderr;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp7_ = e;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp8_ = _tmp7_->message;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = EXIT_FAILURE;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 295 "application.c"
	}
	__finally0:
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return 0;
#line 308 "application.c"
	}
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_set_application_name ("org.gnome.gnome-2048");
#line 90 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_default_icon_name ("gnome-2048");
#line 314 "application.c"
	{
		GOptionEntry* _tmp9_ = NULL;
		GOptionEntry* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp9_ = g_new0 (GOptionEntry, 0);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = _tmp9_;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10__length1 = 0;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_clutter_init_with_args (&args_length1, &args, "", _tmp10_, NULL, &_inner_error_);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = (g_free (_tmp10_), NULL);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 331 "application.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkMessageDialog* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_ = NULL;
		GtkMessageDialog* _tmp17_ = NULL;
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp11_ = e;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp12_ = _tmp11_->message;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp12_);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_object_ref_sink (_tmp13_);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		dialog = _tmp13_;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp14_ = dialog;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp15_ = g_get_application_name ();
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_window_set_title ((GtkWindow*) _tmp14_, _tmp15_);
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp16_ = dialog;
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_dialog_run ((GtkDialog*) _tmp16_);
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp17_ = dialog;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp17_);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = EXIT_FAILURE;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (dialog);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 385 "application.c"
	}
	__finally1:
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 92 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return 0;
#line 398 "application.c"
	}
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = application_new ();
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	app = _tmp18_;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = app;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20_ = args;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20__length1 = args_length1;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp21_ = g_application_run ((GApplication*) _tmp19_, _tmp20__length1, _tmp20_);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp21_;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (app);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_option_context_free0 (context);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 420 "application.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return application_main (argv, argc);
#line 430 "application.c"
}


Application* application_construct (GType object_type) {
	Application * self = NULL;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.gnome-2048", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return self;
#line 440 "application.c"
}


Application* application_new (void) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return application_construct (TYPE_APPLICATION);
#line 447 "application.c"
}


static void application_real_startup (GApplication* base) {
	Application * self;
	GSettings* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) base;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_APPLICATION_CLASS (application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 119 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_action_map_add_action_entries ((GActionMap*) self, APPLICATION_action_entries, G_N_ELEMENTS (APPLICATION_action_entries), self);
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_settings_new ("org.gnome.2048");
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_settings);
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_settings = _tmp0_;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_init_game (self);
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = gtk_builder_new ();
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	builder = _tmp1_;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = builder;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_window (self, _tmp2_);
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = builder;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_preferences_dialog (self, _tmp3_);
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_congrats_dialog (self, _tmp4_);
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_scores (self);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_window;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_game;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = game_restore_game (_tmp6_);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game_restored = _tmp7_;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_game_restored;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (!_tmp8_) {
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		application_new_game_cb (self);
#line 511 "application.c"
	}
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (builder);
#line 515 "application.c"
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkWindow* _tmp0_ = NULL;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) base;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_window;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_present (_tmp0_);
#line 528 "application.c"
}


static void application_real_shutdown (GApplication* base) {
	Application * self;
	Game* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) base;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_APPLICATION_CLASS (application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_game;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_save_game (_tmp0_);
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_settings;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_window_width;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp1_, "window-width", _tmp2_);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_settings;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_window_height;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp3_, "window-height", _tmp4_);
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_settings;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_window_maximized;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_boolean (_tmp5_, "window-maximized", _tmp6_);
#line 567 "application.c"
}


static void __lambda4_ (Application* self, GObject* s, GParamSpec* p) {
	GtkLabel* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (p != NULL);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_score;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_game;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = game_get_score (_tmp1_);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = _tmp2_;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = _tmp4_;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_label_set_label (_tmp0_, _tmp5_);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_free0 (_tmp5_);
#line 598 "application.c"
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda4_ ((Application*) self, _sender, pspec);
#line 605 "application.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return self ? g_object_ref (self) : NULL;
#line 612 "application.c"
}


static void ___lambda6_ (Application* self, GObject* object, GAsyncResult* _result_) {
	GAction* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (_result_ != NULL);
#line 621 "application.c"
	{
		GamesScoresContext* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = self->priv->_scores_ctx;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = _result_;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 633 "application.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = stderr;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = e;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = _tmp3_->message;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp2_, "%s\n", _tmp4_);
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 658 "application.c"
	}
	__finally2:
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 669 "application.c"
	}
#line 177 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "scores");
#line 177 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_debug ("application.vala:178: score added");
#line 677 "application.c"
}


static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	___lambda6_ ((Application*) self, source_object, res);
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_unref (self);
#line 686 "application.c"
}


static void __lambda5_ (Application* self, Game* s) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_header_bar;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = _ ("Game Over");
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_subtitle (_tmp0_, _tmp1_);
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_game_restored;
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (!_tmp2_) {
#line 706 "application.c"
		GamesScoresCategory* _tmp3_ = NULL;
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GamesScoresCategory* cat = NULL;
		GamesScoresCategory* _tmp8_ = NULL;
		GamesScoresContext* _tmp9_ = NULL;
		Game* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		GamesScoresCategory* _tmp13_ = NULL;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = self->priv->_settings;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = g_settings_get_int (_tmp4_, "rows");
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (_tmp5_ == 4) {
#line 723 "application.c"
			GamesScoresCategory* _tmp6_ = NULL;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp6_ = self->priv->_grid4_cat;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp3_ = _tmp6_;
#line 729 "application.c"
		} else {
			GamesScoresCategory* _tmp7_ = NULL;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp7_ = self->priv->_grid5_cat;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp3_ = _tmp7_;
#line 736 "application.c"
		}
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp8_ = _g_object_ref0 (_tmp3_);
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		cat = _tmp8_;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp9_ = self->priv->_scores_ctx;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = self->priv->_game;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp11_ = game_get_score (_tmp10_);
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp12_ = _tmp11_;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp13_ = cat;
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		games_scores_context_add_score (_tmp9_, (glong) _tmp12_, _tmp13_, NULL, ____lambda6__gasync_ready_callback, g_object_ref (self));
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (cat);
#line 756 "application.c"
	}
#line 182 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_debug ("application.vala:182: finished");
#line 760 "application.c"
}


static void ___lambda5__game_finished (Game* _sender, gpointer self) {
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda5_ ((Application*) self, _sender);
#line 767 "application.c"
}


static void __lambda7_ (Application* self, Game* s, guint v) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_settings;
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "do-congrat");
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp1_) {
#line 782 "application.c"
		gchar* message = NULL;
		guint _tmp2_ = 0U;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkDialog* _tmp10_ = NULL;
		GSettings* _tmp11_ = NULL;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = v;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = g_strdup_printf ("You have obtained the %u tile", _tmp2_);
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = _tmp3_;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = _ (_tmp4_);
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp7_ = _tmp6_;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_free0 (_tmp4_);
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		message = _tmp7_;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp8_ = self->priv->_congrats_message;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp9_ = message;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_label_set_text (_tmp8_, _tmp9_);
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = self->priv->_congrats_dialog;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_window_present ((GtkWindow*) _tmp10_);
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp11_ = self->priv->_settings;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_settings_set_boolean (_tmp11_, "do-congrat", FALSE);
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_free0 (message);
#line 826 "application.c"
	}
#line 192 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_debug ("application.vala:192: target value reached");
#line 830 "application.c"
}


static void ___lambda7__game_target_value_reached (Game* _sender, guint val, gpointer self) {
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda7_ ((Application*) self, _sender, val);
#line 837 "application.c"
}


static void __lambda8_ (Application* self, Game* s) {
	GAction* _tmp0_ = NULL;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 849 "application.c"
}


static void ___lambda8__game_undo_enabled (Game* _sender, gpointer self) {
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda8_ ((Application*) self, _sender);
#line 856 "application.c"
}


static void __lambda9_ (Application* self, Game* s) {
	GAction* _tmp0_ = NULL;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 868 "application.c"
}


static void ___lambda9__game_undo_disabled (Game* _sender, gpointer self) {
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda9_ ((Application*) self, _sender);
#line 875 "application.c"
}


static void _application_init_game (Application* self) {
	GSettings* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_settings;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = game_new (_tmp0_);
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_game);
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game = _tmp1_;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_game;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::score", (GCallback) ___lambda4__g_object_notify, self, 0);
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_game;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp3_, "finished", (GCallback) ___lambda5__game_finished, self, 0);
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_game;
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp4_, "target-value-reached", (GCallback) ___lambda7__game_target_value_reached, self, 0);
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_game;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp5_, "undo-enabled", (GCallback) ___lambda8__game_undo_enabled, self, 0);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_game;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp6_, "undo-disabled", (GCallback) ___lambda9__game_undo_disabled, self, 0);
#line 917 "application.c"
}


static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = application_key_press_event_cb ((Application*) self, _sender, event);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 926 "application.c"
}


static void _application_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_window_size_allocate_cb ((Application*) self);
#line 933 "application.c"
}


static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = application_window_state_event_cb ((Application*) self, event);
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 942 "application.c"
}


static void _application_create_window (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GtkWindow* _tmp15_ = NULL;
	GtkBuilder* _tmp16_ = NULL;
	GtkWindow* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkWindow* _tmp20_ = NULL;
	GtkWindow* _tmp21_ = NULL;
	GtkWindow* _tmp22_ = NULL;
	GdkGeometry geom = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GtkWindow* _tmp25_ = NULL;
	GtkWindow* _tmp26_ = NULL;
	GdkGeometry _tmp27_ = {0};
	GError * _inner_error_ = NULL;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 976 "application.c"
	{
		GtkBuilder* _tmp0_ = NULL;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = builder;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/mainwindow.ui", &_inner_error_);
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 985 "application.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = stderr;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = e;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->message;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp1_, "%s\n", _tmp3_);
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 1010 "application.c"
	}
	__finally3:
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 1021 "application.c"
	}
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_builder_get_object (_tmp4_, "applicationwindow");
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _g_object_ref0 ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_window);
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_window = _tmp6_;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_window;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_settings;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = g_settings_get_int (_tmp8_, "window-width");
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = self->priv->_settings;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "window-height");
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_default_size (_tmp7_, _tmp9_, _tmp11_);
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = self->priv->_settings;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = g_settings_get_boolean (_tmp12_, "window-maximized");
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp13_) {
#line 1051 "application.c"
		GtkWindow* _tmp14_ = NULL;
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp14_ = self->priv->_window;
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_window_maximize (_tmp14_);
#line 1057 "application.c"
	}
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = self->priv->_window;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_application_add_window ((GtkApplication*) self, _tmp15_);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_header_bar (self);
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = builder;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_game_view (self, _tmp16_);
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_window;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = self->priv->_window;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = gtk_widget_get_events ((GtkWidget*) _tmp18_);
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_set_events ((GtkWidget*) _tmp17_, ((_tmp19_ | GDK_STRUCTURE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20_ = self->priv->_window;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp20_, "key-press-event", (GCallback) _application_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp21_ = self->priv->_window;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp21_, "size-allocate", (GCallback) _application_window_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp22_ = self->priv->_window;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp22_, "window-state-event", (GCallback) _application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 225 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	memset (&geom, 0, sizeof (GdkGeometry));
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp23_ = self->priv->WINDOW_MINIMUM_SIZE_HEIGHT;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	geom.min_height = _tmp23_;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp24_ = self->priv->WINDOW_MINIMUM_SIZE_WIDTH;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	geom.min_width = _tmp24_;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp25_ = self->priv->_window;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp26_ = self->priv->_window;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp27_ = geom;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_geometry_hints (_tmp25_, (GtkWidget*) _tmp26_, &_tmp27_, GDK_HINT_MIN_SIZE);
#line 1107 "application.c"
}


static void _application_create_header_bar (Application* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkHeaderBar* _tmp1_ = NULL;
	GtkHeaderBar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkHeaderBar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkHeaderBar* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkHeaderBar* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp0_);
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_header_bar);
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_header_bar = _tmp0_;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_header_bar;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_show_close_button (_tmp1_, TRUE);
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_header_bar;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_title (_tmp2_, "2048");
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_window;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_header_bar;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_titlebar (_tmp3_, (GtkWidget*) _tmp4_);
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = (GtkLabel*) gtk_label_new ("0");
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp5_);
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_score);
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_score = _tmp5_;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_header_bar;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_score;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_pack_end (_tmp6_, (GtkWidget*) _tmp7_);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp8_);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_undo_button);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_undo_button = _tmp8_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_undo_button;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp9_, "app.undo");
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = self->priv->_header_bar;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = self->priv->_undo_button;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_pack_start (_tmp10_, (GtkWidget*) _tmp11_);
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = _ ("New Game");
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_tmp13_);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp14_);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_new_game_button);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_new_game_button = _tmp14_;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = self->priv->_new_game_button;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp15_, "app.new-game");
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = self->priv->_header_bar;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_new_game_button;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_pack_start (_tmp16_, (GtkWidget*) _tmp17_);
#line 1210 "application.c"
}


static void _application_create_game_view (Application* self, GtkBuilder* builder) {
	GtkClutterEmbed* embed = NULL;
	GtkClutterEmbed* _tmp0_ = NULL;
	GtkAspectFrame* frame = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkAspectFrame* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = (GtkClutterEmbed*) gtk_clutter_embed_new ();
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp0_);
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	embed = _tmp0_;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = builder;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = gtk_builder_get_object (_tmp1_, "aspectframe");
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_aspect_frame_get_type (), GtkAspectFrame));
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	frame = _tmp3_;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) embed);
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_game;
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_clutter_embed_get_stage (embed);
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_set_view (_tmp4_, _tmp5_);
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (frame);
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (embed);
#line 1253 "application.c"
}


static void __lambda10_ (Application* self, gint response_id) {
	GtkDialog* _tmp0_ = NULL;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_preferences_dialog;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
#line 1263 "application.c"
}


static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda10_ ((Application*) self, response_id);
#line 1270 "application.c"
}


static gboolean __lambda11_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	gint grid_size = 0;
	gint rows = 0;
	gint cols = 0;
	gboolean settings_changed = FALSE;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Game* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkDialog* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (response_id != NULL, FALSE);
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_grid_size_combo;
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	grid_size = _tmp1_;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = grid_size;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp2_ == 0) {
#line 1304 "application.c"
		gint _tmp3_ = 0;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		cols = 4;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = cols;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		rows = _tmp3_;
#line 1312 "application.c"
	} else {
		gint _tmp4_ = 0;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		cols = 5;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = cols;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		rows = _tmp4_;
#line 1321 "application.c"
	}
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_settings;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = rows;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp5_, "rows", _tmp6_);
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_settings;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = cols;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp7_, "cols", _tmp8_);
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_game;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = game_reload_settings (_tmp9_);
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	settings_changed = _tmp10_;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = settings_changed;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp11_) {
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		application_new_game_cb (self);
#line 1347 "application.c"
	}
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = self->priv->_preferences_dialog;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp12_);
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp13_;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1357 "application.c"
}


static gboolean ___lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda11_ ((Application*) self, event);
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1366 "application.c"
}


static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GtkComboBoxText* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 1395 "application.c"
	{
		GtkBuilder* _tmp0_ = NULL;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = builder;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/preferences.ui", &_inner_error_);
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1404 "application.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = stderr;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = e;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->message;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp1_, "%s\n", _tmp3_);
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 1429 "application.c"
	}
	__finally4:
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 1440 "application.c"
	}
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_builder_get_object (_tmp4_, "preferencesdialog");
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_dialog_get_type (), GtkDialog));
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_preferences_dialog);
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_preferences_dialog = _tmp6_;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_preferences_dialog;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_window;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = builder;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = gtk_builder_get_object (_tmp9_, "gridsizecombo");
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_combo_box_text_get_type (), GtkComboBoxText));
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid_size_combo);
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_grid_size_combo = _tmp11_;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = self->priv->_preferences_dialog;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp12_, "response", (GCallback) ___lambda10__gtk_dialog_response, self, 0);
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = self->priv->_preferences_dialog;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp13_, "delete-event", (GCallback) ___lambda11__gtk_widget_delete_event, self, 0);
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp14_ = self->priv->_settings;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = builder;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "congratswitch");
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_bind (_tmp14_, "do-congrat", _tmp16_, "active", G_SETTINGS_BIND_DEFAULT);
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_settings;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = builder;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "animationsspeed");
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_bind (_tmp17_, "animations-speed", _tmp19_, "value", G_SETTINGS_BIND_DEFAULT);
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20_ = self->priv->_settings;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp21_ = builder;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "undoswitch");
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_bind (_tmp20_, "allow-undo", _tmp22_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1500 "application.c"
}


static void __lambda12_ (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkDialog* _tmp1_ = NULL;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = response_id;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp0_ == 0) {
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		application_new_game_cb (self);
#line 1513 "application.c"
	}
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_congrats_dialog;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1519 "application.c"
}


static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda12_ ((Application*) self, response_id);
#line 1526 "application.c"
}


static gboolean __lambda13_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (response_id != NULL, FALSE);
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_congrats_dialog;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp1_;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1544 "application.c"
}


static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda13_ ((Application*) self, event);
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1553 "application.c"
}


static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 1573 "application.c"
	{
		GtkBuilder* _tmp0_ = NULL;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = builder;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/congrats.ui", &_inner_error_);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1582 "application.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = stderr;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = e;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->message;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp1_, "%s\n", _tmp3_);
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 1607 "application.c"
	}
	__finally5:
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 1618 "application.c"
	}
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_builder_get_object (_tmp4_, "congratsdialog");
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_dialog_get_type (), GtkDialog));
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_dialog);
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_congrats_dialog = _tmp6_;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_congrats_dialog;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_window;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_congrats_dialog;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp9_, "response", (GCallback) ___lambda12__gtk_dialog_response, self, 0);
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = self->priv->_congrats_dialog;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) ___lambda13__gtk_widget_delete_event, self, 0);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = builder;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = gtk_builder_get_object (_tmp11_, "messagelabel");
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_label_get_type (), GtkLabel));
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_message);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_congrats_message = _tmp13_;
#line 1654 "application.c"
}


static GamesScoresCategory* application_category_request (Application* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = key;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (g_strcmp0 (_tmp0_, "grid4") == 0) {
#line 1670 "application.c"
		GamesScoresCategory* _tmp1_ = NULL;
		GamesScoresCategory* _tmp2_ = NULL;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = self->priv->_grid4_cat;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = _tmp2_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 1681 "application.c"
	}
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = key;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (g_strcmp0 (_tmp3_, "grid5") == 0) {
#line 1687 "application.c"
		GamesScoresCategory* _tmp4_ = NULL;
		GamesScoresCategory* _tmp5_ = NULL;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = self->priv->_grid5_cat;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = _tmp5_;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 1698 "application.c"
	}
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_assert_not_reached ();
#line 1702 "application.c"
}


static GamesScoresCategory* _application_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = application_category_request ((Application*) self, category_key);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1711 "application.c"
}


static void _application_create_scores (Application* self) {
	GamesScoresCategory* _tmp0_ = NULL;
	GamesScoresCategory* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GamesScoresContext* _tmp3_ = NULL;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = games_scores_category_new ("grid4", "Grid 4 x 4");
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid4_cat);
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_grid4_cat = _tmp0_;
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = games_scores_category_new ("grid5", "Grid 5 x 5");
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid5_cat);
#line 334 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_grid5_cat = _tmp1_;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_window;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = games_scores_context_new ("gnome-2048", "", _tmp2_, _application_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_scores_ctx);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_scores_ctx = _tmp3_;
#line 1742 "application.c"
}


static void application_undo_cb (Application* self) {
	Game* _tmp0_ = NULL;
#line 344 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_game;
#line 346 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_undo (_tmp0_);
#line 1754 "application.c"
}


static void application_new_game_cb (Application* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 351 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_header_bar;
#line 351 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game_restored = FALSE;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_game;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_new_game (_tmp1_);
#line 1773 "application.c"
}


static void application_scores_cb (Application* self) {
	GamesScoresContext* _tmp0_ = NULL;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_scores_ctx;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	games_scores_context_run_dialog (_tmp0_);
#line 1785 "application.c"
}


static void application_preferences_cb (Application* self) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkDialog* _tmp4_ = NULL;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_settings;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = g_settings_get_int (_tmp0_, "rows");
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp1_ == 4) {
#line 1801 "application.c"
		GtkComboBoxText* _tmp2_ = NULL;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = self->priv->_grid_size_combo;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_combo_box_set_active ((GtkComboBox*) _tmp2_, 0);
#line 1807 "application.c"
	} else {
		GtkComboBoxText* _tmp3_ = NULL;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = self->priv->_grid_size_combo;
#line 367 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, 1);
#line 1814 "application.c"
	}
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_preferences_dialog;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_present ((GtkWindow*) _tmp4_);
#line 1820 "application.c"
}


static void application_about_cb (Application* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	GtkWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_strdup ("Juan R. García Blanco");
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = g_strdup ("Arnaud Bonatti");
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = g_new0 (gchar*, 2 + 1);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_[0] = _tmp0_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_[1] = _tmp1_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	authors = _tmp2_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	authors_length1 = 2;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_authors_size_ = authors_length1;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_window;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = _ ("A clone of 2048 for GNOME");
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = _ ("Copyright \xc2\xa9 2014-2015 – Juan R. García Blanco\n" \
"Copyright \xc2\xa9 2016 – Arnaud Bonatti");
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _ ("translator-credits");
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_show_about_dialog (_tmp3_, "program-name", "2048", "version", VERSION, "comments", _tmp4_, "copyright", _tmp5_, "license-type", GTK_LICENSE_GPL_3_0, "wrap-license", FALSE, "authors", authors, "translator-credits", _tmp6_, "logo-icon-name", "gnome-2048", "website", "http://www.gnome.org", NULL, NULL);
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1865 "application.c"
}


static void application_quit_cb (Application* self) {
	GtkWindow* _tmp0_ = NULL;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_window;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1877 "application.c"
}


static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game_restored = FALSE;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_game;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = event;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = game_key_pressed (_tmp0_, _tmp1_);
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp2_;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1904 "application.c"
}


static void application_window_size_allocate_cb (Application* self) {
	gboolean _tmp0_ = FALSE;
	GtkWindow* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 416 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_window_maximized;
#line 416 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp0_) {
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 1921 "application.c"
	}
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_window;
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_get_size (_tmp1_, &_tmp2_, &_tmp3_);
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_window_width = _tmp2_;
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_window_height = _tmp3_;
#line 1931 "application.c"
}


static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = event;
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1949 "application.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 424 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = event;
#line 424 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 424 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		self->priv->_window_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1958 "application.c"
	}
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = FALSE;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1964 "application.c"
}


static void application_class_init (ApplicationClass * klass) {
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_parent_class = g_type_class_peek_parent (klass);
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	((GApplicationClass *) klass)->startup = application_real_startup;
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	((GApplicationClass *) klass)->activate = application_real_activate;
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	((GApplicationClass *) klass)->shutdown = application_real_shutdown;
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
#line 1981 "application.c"
}


static void application_instance_init (Application * self) {
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv = APPLICATION_GET_PRIVATE (self);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->WINDOW_MINIMUM_SIZE_HEIGHT = 600;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->WINDOW_MINIMUM_SIZE_WIDTH = 600;
#line 1992 "application.c"
}


static void application_finalize (GObject* obj) {
	Application * self;
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
#line 26 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_settings);
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_window);
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_header_bar);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_undo_button);
#line 39 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_new_game_button);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_preferences_dialog);
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_dialog);
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_message);
#line 43 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_score);
#line 44 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid_size_combo);
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_scores_ctx);
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid4_cat);
#line 48 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid5_cat);
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_game);
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
#line 2030 "application.c"
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (gtk_application_get_type (), "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



