/* grid.c generated by valac 0.30.0, the Vala compiler
 * generated from grid.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;
typedef struct _GridPrivate GridPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TILE (tile_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _Tile Tile;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Grid {
	GObject parent_instance;
	GridPrivate * priv;
};

struct _GridClass {
	GObjectClass parent_class;
};

struct _GridPrivate {
	guint* _grid;
	gint _grid_length1;
	gint _grid_length2;
	gint _rows;
	gint _cols;
	guint _target_value;
	gboolean _target_value_reached;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};


static gpointer grid_parent_class = NULL;

GType grid_get_type (void) G_GNUC_CONST;
#define GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GRID, GridPrivate))
enum  {
	GRID_DUMMY_PROPERTY,
	GRID_ROWS,
	GRID_COLS,
	GRID_TARGET_VALUE,
	GRID_TARGET_VALUE_REACHED
};
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void grid_clear (Grid* self);
Grid* grid_clone (Grid* self);
static guint* _vala_array_dup1 (guint* self, int length);
GType tile_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static gboolean _grid_grid_is_full (Grid* self);
static void _grid_random_position (Grid* self, GridPosition* result);
static void _grid_check_target_value_reached (Grid* self, guint val);
GType tile_movement_get_type (void) G_GNUC_CONST;
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gboolean grid_is_finished (Grid* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_save (Grid* self);
static gchar* _grid_convert_to_string (Grid* self);
gboolean grid_load (Grid* self, const gchar* content);
static gboolean _grid_load_from_string (Grid* self, const gchar* contents);
gchar* grid_to_string (Grid* self);
static guint* _vala_array_dup2 (guint* self, int length);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gint grid_get_rows (Grid* self);
void grid_set_rows (Grid* self, gint value);
gint grid_get_cols (Grid* self);
void grid_set_cols (Grid* self, gint value);
void grid_set_target_value (Grid* self, guint value);
gboolean grid_get_target_value_reached (Grid* self);
static void grid_finalize (GObject* obj);
static void _vala_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Grid* grid_construct (GType object_type, gint rows, gint cols) {
	Grid * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	guint* _tmp4_ = NULL;
	_tmp0_ = rows;
	_tmp1_ = cols;
	self = (Grid*) g_object_new (object_type, "rows", _tmp0_, "cols", _tmp1_, NULL);
	_tmp2_ = rows;
	_tmp3_ = cols;
	_tmp4_ = g_new0 (guint, _tmp2_ * _tmp3_);
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
	self->priv->_grid = _tmp4_;
	self->priv->_grid_length1 = _tmp2_;
	self->priv->_grid_length2 = _tmp3_;
	grid_clear (self);
	self->priv->_target_value = (guint) 0;
	return self;
}


Grid* grid_new (gint rows, gint cols) {
	return grid_construct (TYPE_GRID, rows, cols);
}


static guint* _vala_array_dup1 (guint* self, int length) {
	return g_memdup (self, length * sizeof (guint));
}


Grid* grid_clone (Grid* self) {
	Grid* result = NULL;
	Grid* grid = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Grid* _tmp2_ = NULL;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	guint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = grid_new (_tmp0_, _tmp1_);
	grid = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp3__length1 = self->priv->_grid_length1;
	_tmp3__length2 = self->priv->_grid_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	grid->priv->_grid = (g_free (grid->priv->_grid), NULL);
	grid->priv->_grid = _tmp4_;
	grid->priv->_grid_length1 = _tmp4__length1;
	grid->priv->_grid_length2 = _tmp4__length2;
	_tmp5_ = self->priv->_target_value;
	grid->priv->_target_value = _tmp5_;
	_tmp6_ = self->priv->_target_value_reached;
	grid->priv->_target_value_reached = _tmp6_;
	result = grid;
	return result;
}


void grid_clear (Grid* self) {
	g_return_if_fail (self != NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_ = 0U;
				guint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
				gint _tmp4_ = 0;
				if (!_tmp0_) {
					guint _tmp1_ = 0U;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_grid;
				_tmp3__length1 = self->priv->_grid_length1;
				_tmp3__length2 = self->priv->_grid_length2;
				_tmp4_ = _tmp3__length1;
				if (!(_tmp2_ < ((guint) _tmp4_))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							guint _tmp7_ = 0U;
							guint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							guint* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							guint _tmp11_ = 0U;
							guint _tmp12_ = 0U;
							guint _tmp13_ = 0U;
							if (!_tmp5_) {
								guint _tmp6_ = 0U;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_grid;
							_tmp8__length1 = self->priv->_grid_length1;
							_tmp8__length2 = self->priv->_grid_length2;
							_tmp9_ = _tmp8__length2;
							if (!(_tmp7_ < ((guint) _tmp9_))) {
								break;
							}
							_tmp10_ = self->priv->_grid;
							_tmp10__length1 = self->priv->_grid_length1;
							_tmp10__length2 = self->priv->_grid_length2;
							_tmp11_ = i;
							_tmp12_ = j;
							_tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_] = (guint) 0;
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
						}
					}
				}
			}
		}
	}
}


gboolean grid_new_tile (Grid* self, Tile* tile) {
	Tile _vala_tile = {0};
	gboolean result = FALSE;
	GridPosition pos = {0};
	GridPosition _tmp0_ = {0};
	guint val = 0U;
	GridPosition _tmp1_ = {0};
	Tile _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_.row = (guint) 0;
	_tmp0_.col = (guint) 0;
	pos = _tmp0_;
	_tmp1_ = pos;
	_tmp2_.pos = _tmp1_;
	_tmp2_.val = (guint) 0;
	_vala_tile = _tmp2_;
	_tmp3_ = _grid_grid_is_full (self);
	if (_tmp3_) {
		result = FALSE;
		if (tile) {
			*tile = _vala_tile;
		}
		return result;
	}
	val = (guint) 2;
	while (TRUE) {
		GridPosition _tmp4_ = {0};
		guint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		GridPosition _tmp6_ = {0};
		guint _tmp7_ = 0U;
		GridPosition _tmp8_ = {0};
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		_grid_random_position (self, &_tmp4_);
		pos = _tmp4_;
		_tmp5_ = self->priv->_grid;
		_tmp5__length1 = self->priv->_grid_length1;
		_tmp5__length2 = self->priv->_grid_length2;
		_tmp6_ = pos;
		_tmp7_ = _tmp6_.row;
		_tmp8_ = pos;
		_tmp9_ = _tmp8_.col;
		_tmp10_ = _tmp5_[(_tmp7_ * _tmp5__length2) + _tmp9_];
		if (_tmp10_ == ((guint) 0)) {
			guint* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			gint _tmp11__length2 = 0;
			GridPosition _tmp12_ = {0};
			guint _tmp13_ = 0U;
			GridPosition _tmp14_ = {0};
			guint _tmp15_ = 0U;
			guint _tmp16_ = 0U;
			guint _tmp17_ = 0U;
			guint _tmp18_ = 0U;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			Tile _tmp21_ = {0};
			_tmp11_ = self->priv->_grid;
			_tmp11__length1 = self->priv->_grid_length1;
			_tmp11__length2 = self->priv->_grid_length2;
			_tmp12_ = pos;
			_tmp13_ = _tmp12_.row;
			_tmp14_ = pos;
			_tmp15_ = _tmp14_.col;
			_tmp16_ = val;
			_tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_] = _tmp16_;
			_tmp17_ = _tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_];
			_tmp18_ = val;
			_grid_check_target_value_reached (self, _tmp18_);
			_tmp19_ = pos;
			_tmp20_ = val;
			_tmp21_.pos = _tmp19_;
			_tmp21_.val = _tmp20_;
			_vala_tile = _tmp21_;
			result = TRUE;
			if (tile) {
				*tile = _vala_tile;
			}
			return result;
		}
	}
	if (tile) {
		*tile = _vala_tile;
	}
}


void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	_tmp0_ = to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GridPosition _tmp9_ = {0};
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_cols;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->_rows;
				_tmp8_ = i;
				_tmp9_.row = (guint) _tmp7_;
				_tmp9_.col = (guint) _tmp8_;
				free = _tmp9_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							GridPosition _tmp18_ = {0};
							guint* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							GridPosition _tmp22_ = {0};
							guint _tmp23_ = 0U;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							GridPosition _tmp30_ = {0};
							gboolean _tmp47_ = FALSE;
							if (!_tmp10_) {
								gint _tmp11_ = 0;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = j;
							_tmp13_ = self->priv->_rows;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->_rows;
							_tmp15_ = j;
							row = (_tmp14_ - _tmp15_) - 1;
							_tmp16_ = row;
							_tmp17_ = i;
							_tmp18_.row = (guint) _tmp16_;
							_tmp18_.col = (guint) _tmp17_;
							cur = _tmp18_;
							_tmp19_ = self->priv->_grid;
							_tmp19__length1 = self->priv->_grid_length1;
							_tmp19__length2 = self->priv->_grid_length2;
							_tmp20_ = cur;
							_tmp21_ = _tmp20_.row;
							_tmp22_ = cur;
							_tmp23_ = _tmp22_.col;
							_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
							val = _tmp24_;
							_tmp25_ = val;
							if (_tmp25_ == ((guint) 0)) {
								GridPosition _tmp26_ = {0};
								guint _tmp27_ = 0U;
								gint _tmp28_ = 0;
								_tmp26_ = free;
								_tmp27_ = _tmp26_.row;
								_tmp28_ = self->priv->_rows;
								if (_tmp27_ == ((guint) _tmp28_)) {
									gint _tmp29_ = 0;
									_tmp29_ = row;
									free.row = (guint) _tmp29_;
								}
								continue;
							}
							_tmp30_.row = (guint) 0;
							_tmp30_.col = (guint) 0;
							match = _tmp30_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp31_ = 0;
								_tmp31_ = row;
								k = _tmp31_ - 1;
								{
									gboolean _tmp32_ = FALSE;
									_tmp32_ = TRUE;
									while (TRUE) {
										gint _tmp34_ = 0;
										guint k_val = 0U;
										guint* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
										gint _tmp35__length2 = 0;
										gint _tmp36_ = 0;
										GridPosition _tmp37_ = {0};
										guint _tmp38_ = 0U;
										guint _tmp39_ = 0U;
										guint _tmp40_ = 0U;
										if (!_tmp32_) {
											gint _tmp33_ = 0;
											_tmp33_ = k;
											k = _tmp33_ - 1;
										}
										_tmp32_ = FALSE;
										_tmp34_ = k;
										if (!(_tmp34_ >= 0)) {
											break;
										}
										_tmp35_ = self->priv->_grid;
										_tmp35__length1 = self->priv->_grid_length1;
										_tmp35__length2 = self->priv->_grid_length2;
										_tmp36_ = k;
										_tmp37_ = cur;
										_tmp38_ = _tmp37_.col;
										_tmp39_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp38_];
										k_val = _tmp39_;
										_tmp40_ = k_val;
										if (_tmp40_ != ((guint) 0)) {
											guint _tmp41_ = 0U;
											guint _tmp42_ = 0U;
											_tmp41_ = k_val;
											_tmp42_ = val;
											if (_tmp41_ == _tmp42_) {
												gint _tmp43_ = 0;
												GridPosition _tmp44_ = {0};
												guint _tmp45_ = 0U;
												GridPosition _tmp46_ = {0};
												has_match = TRUE;
												_tmp43_ = k;
												_tmp44_ = cur;
												_tmp45_ = _tmp44_.col;
												_tmp46_.row = (guint) _tmp43_;
												_tmp46_.col = _tmp45_;
												match = _tmp46_;
											}
											break;
										}
									}
								}
							}
							_tmp47_ = has_match;
							if (_tmp47_) {
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GridPosition _tmp52_ = {0};
								guint _tmp53_ = 0U;
								gint _tmp54_ = 0;
								GridPosition _tmp56_ = {0};
								GridPosition _tmp57_ = {0};
								TileMovement _tmp58_ = {0};
								GeeLinkedList* _tmp59_ = NULL;
								TileMovement _tmp60_ = {0};
								GridPosition _tmp61_ = {0};
								GridPosition _tmp62_ = {0};
								TileMovement _tmp63_ = {0};
								GeeLinkedList* _tmp64_ = NULL;
								TileMovement _tmp65_ = {0};
								GridPosition _tmp66_ = {0};
								guint _tmp67_ = 0U;
								Tile _tmp68_ = {0};
								GeeLinkedList* _tmp69_ = NULL;
								Tile _tmp70_ = {0};
								guint* _tmp71_ = NULL;
								gint _tmp71__length1 = 0;
								gint _tmp71__length2 = 0;
								GridPosition _tmp72_ = {0};
								guint _tmp73_ = 0U;
								GridPosition _tmp74_ = {0};
								guint _tmp75_ = 0U;
								guint _tmp76_ = 0U;
								guint* _tmp77_ = NULL;
								gint _tmp77__length1 = 0;
								gint _tmp77__length2 = 0;
								GridPosition _tmp78_ = {0};
								guint _tmp79_ = 0U;
								GridPosition _tmp80_ = {0};
								guint _tmp81_ = 0U;
								guint _tmp82_ = 0U;
								guint* _tmp83_ = NULL;
								gint _tmp83__length1 = 0;
								gint _tmp83__length2 = 0;
								GridPosition _tmp84_ = {0};
								guint _tmp85_ = 0U;
								GridPosition _tmp86_ = {0};
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								guint _tmp89_ = 0U;
								guint _tmp90_ = 0U;
								guint _tmp91_ = 0U;
								_tmp48_ = grid_position_to_string (&match);
								_tmp49_ = _tmp48_;
								_tmp50_ = g_strconcat ("matching tile found at ", _tmp49_, NULL);
								_tmp51_ = _tmp50_;
								g_debug ("grid.vala:139: %s", _tmp51_);
								_g_free0 (_tmp51_);
								_g_free0 (_tmp49_);
								_tmp52_ = free;
								_tmp53_ = _tmp52_.row;
								_tmp54_ = self->priv->_rows;
								if (_tmp53_ == ((guint) _tmp54_)) {
									gint _tmp55_ = 0;
									_tmp55_ = row;
									free.row = (guint) _tmp55_;
								}
								_tmp56_ = cur;
								_tmp57_ = free;
								_tmp58_.from = _tmp56_;
								_tmp58_.to = _tmp57_;
								mov = _tmp58_;
								_tmp59_ = to_hide;
								_tmp60_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, &_tmp60_);
								_tmp61_ = match;
								_tmp62_ = free;
								_tmp63_.from = _tmp61_;
								_tmp63_.to = _tmp62_;
								mov = _tmp63_;
								_tmp64_ = to_hide;
								_tmp65_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, &_tmp65_);
								_tmp66_ = free;
								_tmp67_ = val;
								_tmp68_.pos = _tmp66_;
								_tmp68_.val = _tmp67_ * 2;
								tile = _tmp68_;
								_tmp69_ = to_show;
								_tmp70_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, &_tmp70_);
								_tmp71_ = self->priv->_grid;
								_tmp71__length1 = self->priv->_grid_length1;
								_tmp71__length2 = self->priv->_grid_length2;
								_tmp72_ = cur;
								_tmp73_ = _tmp72_.row;
								_tmp74_ = cur;
								_tmp75_ = _tmp74_.col;
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
								_tmp77_ = self->priv->_grid;
								_tmp77__length1 = self->priv->_grid_length1;
								_tmp77__length2 = self->priv->_grid_length2;
								_tmp78_ = match;
								_tmp79_ = _tmp78_.row;
								_tmp80_ = match;
								_tmp81_ = _tmp80_.col;
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = (guint) 0;
								_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
								_tmp83_ = self->priv->_grid;
								_tmp83__length1 = self->priv->_grid_length1;
								_tmp83__length2 = self->priv->_grid_length2;
								_tmp84_ = free;
								_tmp85_ = _tmp84_.row;
								_tmp86_ = free;
								_tmp87_ = _tmp86_.col;
								_tmp88_ = val;
								_tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_] = _tmp88_ * 2;
								_tmp89_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
								_tmp90_ = val;
								_grid_check_target_value_reached (self, _tmp90_ * 2);
								_tmp91_ = free.row;
								free.row = _tmp91_ - 1;
							} else {
								GridPosition _tmp92_ = {0};
								guint _tmp93_ = 0U;
								gint _tmp94_ = 0;
								_tmp92_ = free;
								_tmp93_ = _tmp92_.row;
								_tmp94_ = self->priv->_rows;
								if (_tmp93_ != ((guint) _tmp94_)) {
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_ = NULL;
									gchar* _tmp98_ = NULL;
									gchar* _tmp99_ = NULL;
									gchar* _tmp100_ = NULL;
									GridPosition _tmp101_ = {0};
									GridPosition _tmp102_ = {0};
									TileMovement _tmp103_ = {0};
									GeeLinkedList* _tmp104_ = NULL;
									TileMovement _tmp105_ = {0};
									guint* _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									gint _tmp106__length2 = 0;
									GridPosition _tmp107_ = {0};
									guint _tmp108_ = 0U;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									guint _tmp111_ = 0U;
									guint* _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									gint _tmp112__length2 = 0;
									GridPosition _tmp113_ = {0};
									guint _tmp114_ = 0U;
									GridPosition _tmp115_ = {0};
									guint _tmp116_ = 0U;
									guint _tmp117_ = 0U;
									guint _tmp118_ = 0U;
									guint _tmp119_ = 0U;
									_tmp95_ = grid_position_to_string (&cur);
									_tmp96_ = _tmp95_;
									_tmp97_ = grid_position_to_string (&free);
									_tmp98_ = _tmp97_;
									_tmp99_ = g_strconcat ("moving ", _tmp96_, " to ", _tmp98_, NULL);
									_tmp100_ = _tmp99_;
									g_debug ("grid.vala:159: %s", _tmp100_);
									_g_free0 (_tmp100_);
									_g_free0 (_tmp98_);
									_g_free0 (_tmp96_);
									_tmp101_ = cur;
									_tmp102_ = free;
									_tmp103_.from = _tmp101_;
									_tmp103_.to = _tmp102_;
									mov = _tmp103_;
									_tmp104_ = to_move;
									_tmp105_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, &_tmp105_);
									_tmp106_ = self->priv->_grid;
									_tmp106__length1 = self->priv->_grid_length1;
									_tmp106__length2 = self->priv->_grid_length2;
									_tmp107_ = cur;
									_tmp108_ = _tmp107_.row;
									_tmp109_ = cur;
									_tmp110_ = _tmp109_.col;
									_tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_] = (guint) 0;
									_tmp111_ = _tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_];
									_tmp112_ = self->priv->_grid;
									_tmp112__length1 = self->priv->_grid_length1;
									_tmp112__length2 = self->priv->_grid_length2;
									_tmp113_ = free;
									_tmp114_ = _tmp113_.row;
									_tmp115_ = free;
									_tmp116_ = _tmp115_.col;
									_tmp117_ = val;
									_tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_] = _tmp117_;
									_tmp118_ = _tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_];
									_tmp119_ = free.row;
									free.row = _tmp119_ - 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	_tmp0_ = to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GridPosition _tmp8_ = {0};
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_cols;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_.row = (guint) -1;
				_tmp8_.col = (guint) _tmp7_;
				free = _tmp8_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GridPosition _tmp16_ = {0};
							guint* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							GridPosition _tmp18_ = {0};
							guint _tmp19_ = 0U;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							guint _tmp23_ = 0U;
							GridPosition _tmp27_ = {0};
							gboolean _tmp45_ = FALSE;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = j;
							_tmp12_ = self->priv->_rows;
							if (!(_tmp11_ < _tmp12_)) {
								break;
							}
							_tmp13_ = j;
							row = _tmp13_;
							_tmp14_ = row;
							_tmp15_ = i;
							_tmp16_.row = (guint) _tmp14_;
							_tmp16_.col = (guint) _tmp15_;
							cur = _tmp16_;
							_tmp17_ = self->priv->_grid;
							_tmp17__length1 = self->priv->_grid_length1;
							_tmp17__length2 = self->priv->_grid_length2;
							_tmp18_ = cur;
							_tmp19_ = _tmp18_.row;
							_tmp20_ = cur;
							_tmp21_ = _tmp20_.col;
							_tmp22_ = _tmp17_[(_tmp19_ * _tmp17__length2) + _tmp21_];
							val = _tmp22_;
							_tmp23_ = val;
							if (_tmp23_ == ((guint) 0)) {
								GridPosition _tmp24_ = {0};
								guint _tmp25_ = 0U;
								_tmp24_ = free;
								_tmp25_ = _tmp24_.row;
								if (_tmp25_ == ((guint) -1)) {
									gint _tmp26_ = 0;
									_tmp26_ = row;
									free.row = (guint) _tmp26_;
								}
								continue;
							}
							_tmp27_.row = (guint) 0;
							_tmp27_.col = (guint) 0;
							match = _tmp27_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp28_ = 0;
								_tmp28_ = row;
								k = _tmp28_ + 1;
								{
									gboolean _tmp29_ = FALSE;
									_tmp29_ = TRUE;
									while (TRUE) {
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										guint k_val = 0U;
										guint* _tmp33_ = NULL;
										gint _tmp33__length1 = 0;
										gint _tmp33__length2 = 0;
										gint _tmp34_ = 0;
										GridPosition _tmp35_ = {0};
										guint _tmp36_ = 0U;
										guint _tmp37_ = 0U;
										guint _tmp38_ = 0U;
										if (!_tmp29_) {
											gint _tmp30_ = 0;
											_tmp30_ = k;
											k = _tmp30_ + 1;
										}
										_tmp29_ = FALSE;
										_tmp31_ = k;
										_tmp32_ = self->priv->_rows;
										if (!(_tmp31_ < _tmp32_)) {
											break;
										}
										_tmp33_ = self->priv->_grid;
										_tmp33__length1 = self->priv->_grid_length1;
										_tmp33__length2 = self->priv->_grid_length2;
										_tmp34_ = k;
										_tmp35_ = cur;
										_tmp36_ = _tmp35_.col;
										_tmp37_ = _tmp33_[(_tmp34_ * _tmp33__length2) + _tmp36_];
										k_val = _tmp37_;
										_tmp38_ = k_val;
										if (_tmp38_ != ((guint) 0)) {
											guint _tmp39_ = 0U;
											guint _tmp40_ = 0U;
											_tmp39_ = k_val;
											_tmp40_ = val;
											if (_tmp39_ == _tmp40_) {
												gint _tmp41_ = 0;
												GridPosition _tmp42_ = {0};
												guint _tmp43_ = 0U;
												GridPosition _tmp44_ = {0};
												has_match = TRUE;
												_tmp41_ = k;
												_tmp42_ = cur;
												_tmp43_ = _tmp42_.col;
												_tmp44_.row = (guint) _tmp41_;
												_tmp44_.col = _tmp43_;
												match = _tmp44_;
											}
											break;
										}
									}
								}
							}
							_tmp45_ = has_match;
							if (_tmp45_) {
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								GridPosition _tmp50_ = {0};
								guint _tmp51_ = 0U;
								GridPosition _tmp53_ = {0};
								GridPosition _tmp54_ = {0};
								TileMovement _tmp55_ = {0};
								GeeLinkedList* _tmp56_ = NULL;
								TileMovement _tmp57_ = {0};
								GridPosition _tmp58_ = {0};
								GridPosition _tmp59_ = {0};
								TileMovement _tmp60_ = {0};
								GeeLinkedList* _tmp61_ = NULL;
								TileMovement _tmp62_ = {0};
								GridPosition _tmp63_ = {0};
								guint _tmp64_ = 0U;
								Tile _tmp65_ = {0};
								GeeLinkedList* _tmp66_ = NULL;
								Tile _tmp67_ = {0};
								guint* _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								gint _tmp68__length2 = 0;
								GridPosition _tmp69_ = {0};
								guint _tmp70_ = 0U;
								GridPosition _tmp71_ = {0};
								guint _tmp72_ = 0U;
								guint _tmp73_ = 0U;
								guint* _tmp74_ = NULL;
								gint _tmp74__length1 = 0;
								gint _tmp74__length2 = 0;
								GridPosition _tmp75_ = {0};
								guint _tmp76_ = 0U;
								GridPosition _tmp77_ = {0};
								guint _tmp78_ = 0U;
								guint _tmp79_ = 0U;
								guint* _tmp80_ = NULL;
								gint _tmp80__length1 = 0;
								gint _tmp80__length2 = 0;
								GridPosition _tmp81_ = {0};
								guint _tmp82_ = 0U;
								GridPosition _tmp83_ = {0};
								guint _tmp84_ = 0U;
								guint _tmp85_ = 0U;
								guint _tmp86_ = 0U;
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								_tmp46_ = grid_position_to_string (&match);
								_tmp47_ = _tmp46_;
								_tmp48_ = g_strconcat ("matching tile found at ", _tmp47_, NULL);
								_tmp49_ = _tmp48_;
								g_debug ("grid.vala:221: %s", _tmp49_);
								_g_free0 (_tmp49_);
								_g_free0 (_tmp47_);
								_tmp50_ = free;
								_tmp51_ = _tmp50_.row;
								if (_tmp51_ == ((guint) -1)) {
									gint _tmp52_ = 0;
									_tmp52_ = row;
									free.row = (guint) _tmp52_;
								}
								_tmp53_ = cur;
								_tmp54_ = free;
								_tmp55_.from = _tmp53_;
								_tmp55_.to = _tmp54_;
								mov = _tmp55_;
								_tmp56_ = to_hide;
								_tmp57_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
								_tmp58_ = match;
								_tmp59_ = free;
								_tmp60_.from = _tmp58_;
								_tmp60_.to = _tmp59_;
								mov = _tmp60_;
								_tmp61_ = to_hide;
								_tmp62_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, &_tmp62_);
								_tmp63_ = free;
								_tmp64_ = val;
								_tmp65_.pos = _tmp63_;
								_tmp65_.val = _tmp64_ * 2;
								tile = _tmp65_;
								_tmp66_ = to_show;
								_tmp67_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
								_tmp68_ = self->priv->_grid;
								_tmp68__length1 = self->priv->_grid_length1;
								_tmp68__length2 = self->priv->_grid_length2;
								_tmp69_ = cur;
								_tmp70_ = _tmp69_.row;
								_tmp71_ = cur;
								_tmp72_ = _tmp71_.col;
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
								_tmp74_ = self->priv->_grid;
								_tmp74__length1 = self->priv->_grid_length1;
								_tmp74__length2 = self->priv->_grid_length2;
								_tmp75_ = match;
								_tmp76_ = _tmp75_.row;
								_tmp77_ = match;
								_tmp78_ = _tmp77_.col;
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = (guint) 0;
								_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
								_tmp80_ = self->priv->_grid;
								_tmp80__length1 = self->priv->_grid_length1;
								_tmp80__length2 = self->priv->_grid_length2;
								_tmp81_ = free;
								_tmp82_ = _tmp81_.row;
								_tmp83_ = free;
								_tmp84_ = _tmp83_.col;
								_tmp85_ = val;
								_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = _tmp85_ * 2;
								_tmp86_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
								_tmp87_ = val;
								_grid_check_target_value_reached (self, _tmp87_ * 2);
								_tmp88_ = free.row;
								free.row = _tmp88_ + 1;
							} else {
								GridPosition _tmp89_ = {0};
								guint _tmp90_ = 0U;
								_tmp89_ = free;
								_tmp90_ = _tmp89_.row;
								if (_tmp90_ != ((guint) -1)) {
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									GridPosition _tmp97_ = {0};
									GridPosition _tmp98_ = {0};
									TileMovement _tmp99_ = {0};
									GeeLinkedList* _tmp100_ = NULL;
									TileMovement _tmp101_ = {0};
									guint* _tmp102_ = NULL;
									gint _tmp102__length1 = 0;
									gint _tmp102__length2 = 0;
									GridPosition _tmp103_ = {0};
									guint _tmp104_ = 0U;
									GridPosition _tmp105_ = {0};
									guint _tmp106_ = 0U;
									guint _tmp107_ = 0U;
									guint* _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									gint _tmp108__length2 = 0;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									GridPosition _tmp111_ = {0};
									guint _tmp112_ = 0U;
									guint _tmp113_ = 0U;
									guint _tmp114_ = 0U;
									guint _tmp115_ = 0U;
									_tmp91_ = grid_position_to_string (&cur);
									_tmp92_ = _tmp91_;
									_tmp93_ = grid_position_to_string (&free);
									_tmp94_ = _tmp93_;
									_tmp95_ = g_strconcat ("moving ", _tmp92_, " to ", _tmp94_, NULL);
									_tmp96_ = _tmp95_;
									g_debug ("grid.vala:241: %s", _tmp96_);
									_g_free0 (_tmp96_);
									_g_free0 (_tmp94_);
									_g_free0 (_tmp92_);
									_tmp97_ = cur;
									_tmp98_ = free;
									_tmp99_.from = _tmp97_;
									_tmp99_.to = _tmp98_;
									mov = _tmp99_;
									_tmp100_ = to_move;
									_tmp101_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, &_tmp101_);
									_tmp102_ = self->priv->_grid;
									_tmp102__length1 = self->priv->_grid_length1;
									_tmp102__length2 = self->priv->_grid_length2;
									_tmp103_ = cur;
									_tmp104_ = _tmp103_.row;
									_tmp105_ = cur;
									_tmp106_ = _tmp105_.col;
									_tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_] = (guint) 0;
									_tmp107_ = _tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_];
									_tmp108_ = self->priv->_grid;
									_tmp108__length1 = self->priv->_grid_length1;
									_tmp108__length2 = self->priv->_grid_length2;
									_tmp109_ = free;
									_tmp110_ = _tmp109_.row;
									_tmp111_ = free;
									_tmp112_ = _tmp111_.col;
									_tmp113_ = val;
									_tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_] = _tmp113_;
									_tmp114_ = _tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_];
									_tmp115_ = free.row;
									free.row = _tmp115_ + 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	_tmp0_ = to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GridPosition _tmp8_ = {0};
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_rows;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_.row = (guint) _tmp7_;
				_tmp8_.col = (guint) -1;
				free = _tmp8_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GridPosition _tmp16_ = {0};
							guint* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							GridPosition _tmp18_ = {0};
							guint _tmp19_ = 0U;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							guint _tmp23_ = 0U;
							GridPosition _tmp27_ = {0};
							gboolean _tmp45_ = FALSE;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = j;
							_tmp12_ = self->priv->_cols;
							if (!(_tmp11_ < _tmp12_)) {
								break;
							}
							_tmp13_ = j;
							col = _tmp13_;
							_tmp14_ = i;
							_tmp15_ = col;
							_tmp16_.row = (guint) _tmp14_;
							_tmp16_.col = (guint) _tmp15_;
							cur = _tmp16_;
							_tmp17_ = self->priv->_grid;
							_tmp17__length1 = self->priv->_grid_length1;
							_tmp17__length2 = self->priv->_grid_length2;
							_tmp18_ = cur;
							_tmp19_ = _tmp18_.row;
							_tmp20_ = cur;
							_tmp21_ = _tmp20_.col;
							_tmp22_ = _tmp17_[(_tmp19_ * _tmp17__length2) + _tmp21_];
							val = _tmp22_;
							_tmp23_ = val;
							if (_tmp23_ == ((guint) 0)) {
								GridPosition _tmp24_ = {0};
								guint _tmp25_ = 0U;
								_tmp24_ = free;
								_tmp25_ = _tmp24_.col;
								if (_tmp25_ == ((guint) -1)) {
									gint _tmp26_ = 0;
									_tmp26_ = col;
									free.col = (guint) _tmp26_;
								}
								continue;
							}
							_tmp27_.row = (guint) 0;
							_tmp27_.col = (guint) 0;
							match = _tmp27_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp28_ = 0;
								_tmp28_ = col;
								k = _tmp28_ + 1;
								{
									gboolean _tmp29_ = FALSE;
									_tmp29_ = TRUE;
									while (TRUE) {
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										guint k_val = 0U;
										guint* _tmp33_ = NULL;
										gint _tmp33__length1 = 0;
										gint _tmp33__length2 = 0;
										GridPosition _tmp34_ = {0};
										guint _tmp35_ = 0U;
										gint _tmp36_ = 0;
										guint _tmp37_ = 0U;
										guint _tmp38_ = 0U;
										if (!_tmp29_) {
											gint _tmp30_ = 0;
											_tmp30_ = k;
											k = _tmp30_ + 1;
										}
										_tmp29_ = FALSE;
										_tmp31_ = k;
										_tmp32_ = self->priv->_rows;
										if (!(_tmp31_ < _tmp32_)) {
											break;
										}
										_tmp33_ = self->priv->_grid;
										_tmp33__length1 = self->priv->_grid_length1;
										_tmp33__length2 = self->priv->_grid_length2;
										_tmp34_ = cur;
										_tmp35_ = _tmp34_.row;
										_tmp36_ = k;
										_tmp37_ = _tmp33_[(_tmp35_ * _tmp33__length2) + _tmp36_];
										k_val = _tmp37_;
										_tmp38_ = k_val;
										if (_tmp38_ != ((guint) 0)) {
											guint _tmp39_ = 0U;
											guint _tmp40_ = 0U;
											_tmp39_ = k_val;
											_tmp40_ = val;
											if (_tmp39_ == _tmp40_) {
												GridPosition _tmp41_ = {0};
												guint _tmp42_ = 0U;
												gint _tmp43_ = 0;
												GridPosition _tmp44_ = {0};
												has_match = TRUE;
												_tmp41_ = cur;
												_tmp42_ = _tmp41_.row;
												_tmp43_ = k;
												_tmp44_.row = _tmp42_;
												_tmp44_.col = (guint) _tmp43_;
												match = _tmp44_;
											}
											break;
										}
									}
								}
							}
							_tmp45_ = has_match;
							if (_tmp45_) {
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								GridPosition _tmp50_ = {0};
								guint _tmp51_ = 0U;
								GridPosition _tmp53_ = {0};
								GridPosition _tmp54_ = {0};
								TileMovement _tmp55_ = {0};
								GeeLinkedList* _tmp56_ = NULL;
								TileMovement _tmp57_ = {0};
								GridPosition _tmp58_ = {0};
								GridPosition _tmp59_ = {0};
								TileMovement _tmp60_ = {0};
								GeeLinkedList* _tmp61_ = NULL;
								TileMovement _tmp62_ = {0};
								GridPosition _tmp63_ = {0};
								guint _tmp64_ = 0U;
								Tile _tmp65_ = {0};
								GeeLinkedList* _tmp66_ = NULL;
								Tile _tmp67_ = {0};
								guint* _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								gint _tmp68__length2 = 0;
								GridPosition _tmp69_ = {0};
								guint _tmp70_ = 0U;
								GridPosition _tmp71_ = {0};
								guint _tmp72_ = 0U;
								guint _tmp73_ = 0U;
								guint* _tmp74_ = NULL;
								gint _tmp74__length1 = 0;
								gint _tmp74__length2 = 0;
								GridPosition _tmp75_ = {0};
								guint _tmp76_ = 0U;
								GridPosition _tmp77_ = {0};
								guint _tmp78_ = 0U;
								guint _tmp79_ = 0U;
								guint* _tmp80_ = NULL;
								gint _tmp80__length1 = 0;
								gint _tmp80__length2 = 0;
								GridPosition _tmp81_ = {0};
								guint _tmp82_ = 0U;
								GridPosition _tmp83_ = {0};
								guint _tmp84_ = 0U;
								guint _tmp85_ = 0U;
								guint _tmp86_ = 0U;
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								_tmp46_ = grid_position_to_string (&match);
								_tmp47_ = _tmp46_;
								_tmp48_ = g_strconcat ("matching tile found at ", _tmp47_, NULL);
								_tmp49_ = _tmp48_;
								g_debug ("grid.vala:303: %s", _tmp49_);
								_g_free0 (_tmp49_);
								_g_free0 (_tmp47_);
								_tmp50_ = free;
								_tmp51_ = _tmp50_.col;
								if (_tmp51_ == ((guint) -1)) {
									gint _tmp52_ = 0;
									_tmp52_ = col;
									free.col = (guint) _tmp52_;
								}
								_tmp53_ = cur;
								_tmp54_ = free;
								_tmp55_.from = _tmp53_;
								_tmp55_.to = _tmp54_;
								mov = _tmp55_;
								_tmp56_ = to_hide;
								_tmp57_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
								_tmp58_ = match;
								_tmp59_ = free;
								_tmp60_.from = _tmp58_;
								_tmp60_.to = _tmp59_;
								mov = _tmp60_;
								_tmp61_ = to_hide;
								_tmp62_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, &_tmp62_);
								_tmp63_ = free;
								_tmp64_ = val;
								_tmp65_.pos = _tmp63_;
								_tmp65_.val = _tmp64_ * 2;
								tile = _tmp65_;
								_tmp66_ = to_show;
								_tmp67_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
								_tmp68_ = self->priv->_grid;
								_tmp68__length1 = self->priv->_grid_length1;
								_tmp68__length2 = self->priv->_grid_length2;
								_tmp69_ = cur;
								_tmp70_ = _tmp69_.row;
								_tmp71_ = cur;
								_tmp72_ = _tmp71_.col;
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
								_tmp74_ = self->priv->_grid;
								_tmp74__length1 = self->priv->_grid_length1;
								_tmp74__length2 = self->priv->_grid_length2;
								_tmp75_ = match;
								_tmp76_ = _tmp75_.row;
								_tmp77_ = match;
								_tmp78_ = _tmp77_.col;
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = (guint) 0;
								_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
								_tmp80_ = self->priv->_grid;
								_tmp80__length1 = self->priv->_grid_length1;
								_tmp80__length2 = self->priv->_grid_length2;
								_tmp81_ = free;
								_tmp82_ = _tmp81_.row;
								_tmp83_ = free;
								_tmp84_ = _tmp83_.col;
								_tmp85_ = val;
								_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = _tmp85_ * 2;
								_tmp86_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
								_tmp87_ = val;
								_grid_check_target_value_reached (self, _tmp87_ * 2);
								_tmp88_ = free.col;
								free.col = _tmp88_ + 1;
							} else {
								GridPosition _tmp89_ = {0};
								guint _tmp90_ = 0U;
								_tmp89_ = free;
								_tmp90_ = _tmp89_.col;
								if (_tmp90_ != ((guint) -1)) {
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									GridPosition _tmp97_ = {0};
									GridPosition _tmp98_ = {0};
									TileMovement _tmp99_ = {0};
									GeeLinkedList* _tmp100_ = NULL;
									TileMovement _tmp101_ = {0};
									guint* _tmp102_ = NULL;
									gint _tmp102__length1 = 0;
									gint _tmp102__length2 = 0;
									GridPosition _tmp103_ = {0};
									guint _tmp104_ = 0U;
									GridPosition _tmp105_ = {0};
									guint _tmp106_ = 0U;
									guint _tmp107_ = 0U;
									guint* _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									gint _tmp108__length2 = 0;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									GridPosition _tmp111_ = {0};
									guint _tmp112_ = 0U;
									guint _tmp113_ = 0U;
									guint _tmp114_ = 0U;
									guint _tmp115_ = 0U;
									_tmp91_ = grid_position_to_string (&cur);
									_tmp92_ = _tmp91_;
									_tmp93_ = grid_position_to_string (&free);
									_tmp94_ = _tmp93_;
									_tmp95_ = g_strconcat ("moving ", _tmp92_, " to ", _tmp94_, NULL);
									_tmp96_ = _tmp95_;
									g_debug ("grid.vala:323: %s", _tmp96_);
									_g_free0 (_tmp96_);
									_g_free0 (_tmp94_);
									_g_free0 (_tmp92_);
									_tmp97_ = cur;
									_tmp98_ = free;
									_tmp99_.from = _tmp97_;
									_tmp99_.to = _tmp98_;
									mov = _tmp99_;
									_tmp100_ = to_move;
									_tmp101_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, &_tmp101_);
									_tmp102_ = self->priv->_grid;
									_tmp102__length1 = self->priv->_grid_length1;
									_tmp102__length2 = self->priv->_grid_length2;
									_tmp103_ = cur;
									_tmp104_ = _tmp103_.row;
									_tmp105_ = cur;
									_tmp106_ = _tmp105_.col;
									_tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_] = (guint) 0;
									_tmp107_ = _tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_];
									_tmp108_ = self->priv->_grid;
									_tmp108__length1 = self->priv->_grid_length1;
									_tmp108__length2 = self->priv->_grid_length2;
									_tmp109_ = free;
									_tmp110_ = _tmp109_.row;
									_tmp111_ = free;
									_tmp112_ = _tmp111_.col;
									_tmp113_ = val;
									_tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_] = _tmp113_;
									_tmp114_ = _tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_];
									_tmp115_ = free.col;
									free.col = _tmp115_ + 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_move != NULL);
	g_return_if_fail (to_hide != NULL);
	g_return_if_fail (to_show != NULL);
	_tmp0_ = to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GridPosition _tmp9_ = {0};
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->_rows;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = self->priv->_cols;
				_tmp9_.row = (guint) _tmp7_;
				_tmp9_.col = (guint) _tmp8_;
				free = _tmp9_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							GridPosition _tmp18_ = {0};
							guint* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							GridPosition _tmp22_ = {0};
							guint _tmp23_ = 0U;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							GridPosition _tmp30_ = {0};
							gboolean _tmp47_ = FALSE;
							if (!_tmp10_) {
								gint _tmp11_ = 0;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = j;
							_tmp13_ = self->priv->_cols;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->_cols;
							_tmp15_ = j;
							col = (_tmp14_ - _tmp15_) - 1;
							_tmp16_ = i;
							_tmp17_ = col;
							_tmp18_.row = (guint) _tmp16_;
							_tmp18_.col = (guint) _tmp17_;
							cur = _tmp18_;
							_tmp19_ = self->priv->_grid;
							_tmp19__length1 = self->priv->_grid_length1;
							_tmp19__length2 = self->priv->_grid_length2;
							_tmp20_ = cur;
							_tmp21_ = _tmp20_.row;
							_tmp22_ = cur;
							_tmp23_ = _tmp22_.col;
							_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
							val = _tmp24_;
							_tmp25_ = val;
							if (_tmp25_ == ((guint) 0)) {
								GridPosition _tmp26_ = {0};
								guint _tmp27_ = 0U;
								gint _tmp28_ = 0;
								_tmp26_ = free;
								_tmp27_ = _tmp26_.col;
								_tmp28_ = self->priv->_cols;
								if (_tmp27_ == ((guint) _tmp28_)) {
									gint _tmp29_ = 0;
									_tmp29_ = col;
									free.col = (guint) _tmp29_;
								}
								continue;
							}
							_tmp30_.row = (guint) 0;
							_tmp30_.col = (guint) 0;
							match = _tmp30_;
							has_match = FALSE;
							{
								gint k = 0;
								gint _tmp31_ = 0;
								_tmp31_ = col;
								k = _tmp31_ - 1;
								{
									gboolean _tmp32_ = FALSE;
									_tmp32_ = TRUE;
									while (TRUE) {
										gint _tmp34_ = 0;
										guint k_val = 0U;
										guint* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
										gint _tmp35__length2 = 0;
										GridPosition _tmp36_ = {0};
										guint _tmp37_ = 0U;
										gint _tmp38_ = 0;
										guint _tmp39_ = 0U;
										guint _tmp40_ = 0U;
										if (!_tmp32_) {
											gint _tmp33_ = 0;
											_tmp33_ = k;
											k = _tmp33_ - 1;
										}
										_tmp32_ = FALSE;
										_tmp34_ = k;
										if (!(_tmp34_ >= 0)) {
											break;
										}
										_tmp35_ = self->priv->_grid;
										_tmp35__length1 = self->priv->_grid_length1;
										_tmp35__length2 = self->priv->_grid_length2;
										_tmp36_ = cur;
										_tmp37_ = _tmp36_.row;
										_tmp38_ = k;
										_tmp39_ = _tmp35_[(_tmp37_ * _tmp35__length2) + _tmp38_];
										k_val = _tmp39_;
										_tmp40_ = k_val;
										if (_tmp40_ != ((guint) 0)) {
											guint _tmp41_ = 0U;
											guint _tmp42_ = 0U;
											_tmp41_ = k_val;
											_tmp42_ = val;
											if (_tmp41_ == _tmp42_) {
												GridPosition _tmp43_ = {0};
												guint _tmp44_ = 0U;
												gint _tmp45_ = 0;
												GridPosition _tmp46_ = {0};
												has_match = TRUE;
												_tmp43_ = cur;
												_tmp44_ = _tmp43_.row;
												_tmp45_ = k;
												_tmp46_.row = _tmp44_;
												_tmp46_.col = (guint) _tmp45_;
												match = _tmp46_;
											}
											break;
										}
									}
								}
							}
							_tmp47_ = has_match;
							if (_tmp47_) {
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GridPosition _tmp52_ = {0};
								guint _tmp53_ = 0U;
								gint _tmp54_ = 0;
								GridPosition _tmp56_ = {0};
								GridPosition _tmp57_ = {0};
								TileMovement _tmp58_ = {0};
								GeeLinkedList* _tmp59_ = NULL;
								TileMovement _tmp60_ = {0};
								GridPosition _tmp61_ = {0};
								GridPosition _tmp62_ = {0};
								TileMovement _tmp63_ = {0};
								GeeLinkedList* _tmp64_ = NULL;
								TileMovement _tmp65_ = {0};
								GridPosition _tmp66_ = {0};
								guint _tmp67_ = 0U;
								Tile _tmp68_ = {0};
								GeeLinkedList* _tmp69_ = NULL;
								Tile _tmp70_ = {0};
								guint* _tmp71_ = NULL;
								gint _tmp71__length1 = 0;
								gint _tmp71__length2 = 0;
								GridPosition _tmp72_ = {0};
								guint _tmp73_ = 0U;
								GridPosition _tmp74_ = {0};
								guint _tmp75_ = 0U;
								guint _tmp76_ = 0U;
								guint* _tmp77_ = NULL;
								gint _tmp77__length1 = 0;
								gint _tmp77__length2 = 0;
								GridPosition _tmp78_ = {0};
								guint _tmp79_ = 0U;
								GridPosition _tmp80_ = {0};
								guint _tmp81_ = 0U;
								guint _tmp82_ = 0U;
								guint* _tmp83_ = NULL;
								gint _tmp83__length1 = 0;
								gint _tmp83__length2 = 0;
								GridPosition _tmp84_ = {0};
								guint _tmp85_ = 0U;
								GridPosition _tmp86_ = {0};
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								guint _tmp89_ = 0U;
								guint _tmp90_ = 0U;
								guint _tmp91_ = 0U;
								_tmp48_ = grid_position_to_string (&match);
								_tmp49_ = _tmp48_;
								_tmp50_ = g_strconcat ("matching tile found at ", _tmp49_, NULL);
								_tmp51_ = _tmp50_;
								g_debug ("grid.vala:385: %s", _tmp51_);
								_g_free0 (_tmp51_);
								_g_free0 (_tmp49_);
								_tmp52_ = free;
								_tmp53_ = _tmp52_.col;
								_tmp54_ = self->priv->_cols;
								if (_tmp53_ == ((guint) _tmp54_)) {
									gint _tmp55_ = 0;
									_tmp55_ = col;
									free.col = (guint) _tmp55_;
								}
								_tmp56_ = cur;
								_tmp57_ = free;
								_tmp58_.from = _tmp56_;
								_tmp58_.to = _tmp57_;
								mov = _tmp58_;
								_tmp59_ = to_hide;
								_tmp60_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, &_tmp60_);
								_tmp61_ = match;
								_tmp62_ = free;
								_tmp63_.from = _tmp61_;
								_tmp63_.to = _tmp62_;
								mov = _tmp63_;
								_tmp64_ = to_hide;
								_tmp65_ = mov;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, &_tmp65_);
								_tmp66_ = free;
								_tmp67_ = val;
								_tmp68_.pos = _tmp66_;
								_tmp68_.val = _tmp67_ * 2;
								tile = _tmp68_;
								_tmp69_ = to_show;
								_tmp70_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, &_tmp70_);
								_tmp71_ = self->priv->_grid;
								_tmp71__length1 = self->priv->_grid_length1;
								_tmp71__length2 = self->priv->_grid_length2;
								_tmp72_ = cur;
								_tmp73_ = _tmp72_.row;
								_tmp74_ = cur;
								_tmp75_ = _tmp74_.col;
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
								_tmp77_ = self->priv->_grid;
								_tmp77__length1 = self->priv->_grid_length1;
								_tmp77__length2 = self->priv->_grid_length2;
								_tmp78_ = match;
								_tmp79_ = _tmp78_.row;
								_tmp80_ = match;
								_tmp81_ = _tmp80_.col;
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = (guint) 0;
								_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
								_tmp83_ = self->priv->_grid;
								_tmp83__length1 = self->priv->_grid_length1;
								_tmp83__length2 = self->priv->_grid_length2;
								_tmp84_ = free;
								_tmp85_ = _tmp84_.row;
								_tmp86_ = free;
								_tmp87_ = _tmp86_.col;
								_tmp88_ = val;
								_tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_] = _tmp88_ * 2;
								_tmp89_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
								_tmp90_ = val;
								_grid_check_target_value_reached (self, _tmp90_ * 2);
								_tmp91_ = free.col;
								free.col = _tmp91_ - 1;
							} else {
								GridPosition _tmp92_ = {0};
								guint _tmp93_ = 0U;
								gint _tmp94_ = 0;
								_tmp92_ = free;
								_tmp93_ = _tmp92_.col;
								_tmp94_ = self->priv->_cols;
								if (_tmp93_ != ((guint) _tmp94_)) {
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_ = NULL;
									gchar* _tmp98_ = NULL;
									gchar* _tmp99_ = NULL;
									gchar* _tmp100_ = NULL;
									GridPosition _tmp101_ = {0};
									GridPosition _tmp102_ = {0};
									TileMovement _tmp103_ = {0};
									GeeLinkedList* _tmp104_ = NULL;
									TileMovement _tmp105_ = {0};
									guint* _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									gint _tmp106__length2 = 0;
									GridPosition _tmp107_ = {0};
									guint _tmp108_ = 0U;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									guint _tmp111_ = 0U;
									guint* _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									gint _tmp112__length2 = 0;
									GridPosition _tmp113_ = {0};
									guint _tmp114_ = 0U;
									GridPosition _tmp115_ = {0};
									guint _tmp116_ = 0U;
									guint _tmp117_ = 0U;
									guint _tmp118_ = 0U;
									guint _tmp119_ = 0U;
									_tmp95_ = grid_position_to_string (&cur);
									_tmp96_ = _tmp95_;
									_tmp97_ = grid_position_to_string (&free);
									_tmp98_ = _tmp97_;
									_tmp99_ = g_strconcat ("moving ", _tmp96_, " to ", _tmp98_, NULL);
									_tmp100_ = _tmp99_;
									g_debug ("grid.vala:405: %s", _tmp100_);
									_g_free0 (_tmp100_);
									_g_free0 (_tmp98_);
									_g_free0 (_tmp96_);
									_tmp101_ = cur;
									_tmp102_ = free;
									_tmp103_.from = _tmp101_;
									_tmp103_.to = _tmp102_;
									mov = _tmp103_;
									_tmp104_ = to_move;
									_tmp105_ = mov;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, &_tmp105_);
									_tmp106_ = self->priv->_grid;
									_tmp106__length1 = self->priv->_grid_length1;
									_tmp106__length2 = self->priv->_grid_length2;
									_tmp107_ = cur;
									_tmp108_ = _tmp107_.row;
									_tmp109_ = cur;
									_tmp110_ = _tmp109_.col;
									_tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_] = (guint) 0;
									_tmp111_ = _tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_];
									_tmp112_ = self->priv->_grid;
									_tmp112__length1 = self->priv->_grid_length1;
									_tmp112__length2 = self->priv->_grid_length2;
									_tmp113_ = free;
									_tmp114_ = _tmp113_.row;
									_tmp115_ = free;
									_tmp116_ = _tmp115_.col;
									_tmp117_ = val;
									_tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_] = _tmp117_;
									_tmp118_ = _tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_];
									_tmp119_ = free.col;
									free.col = _tmp119_ - 1;
								}
							}
						}
					}
				}
			}
		}
	}
}


gboolean grid_is_finished (Grid* self) {
	gboolean result = FALSE;
	guint val = 0U;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _grid_grid_is_full (self);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	} else {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					if (!_tmp1_) {
						gint _tmp2_ = 0;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = i;
					_tmp4_ = self->priv->_rows;
					if (!(_tmp3_ < _tmp4_)) {
						break;
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp5_ = FALSE;
							_tmp5_ = TRUE;
							while (TRUE) {
								gint _tmp7_ = 0;
								gint _tmp8_ = 0;
								guint* _tmp9_ = NULL;
								gint _tmp9__length1 = 0;
								gint _tmp9__length2 = 0;
								gint _tmp10_ = 0;
								gint _tmp11_ = 0;
								guint _tmp12_ = 0U;
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								if (!_tmp5_) {
									gint _tmp6_ = 0;
									_tmp6_ = j;
									j = _tmp6_ + 1;
								}
								_tmp5_ = FALSE;
								_tmp7_ = j;
								_tmp8_ = self->priv->_cols;
								if (!(_tmp7_ < _tmp8_)) {
									break;
								}
								_tmp9_ = self->priv->_grid;
								_tmp9__length1 = self->priv->_grid_length1;
								_tmp9__length2 = self->priv->_grid_length2;
								_tmp10_ = i;
								_tmp11_ = j;
								_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
								val = _tmp12_;
								_tmp13_ = i;
								_tmp14_ = self->priv->_rows;
								if (_tmp13_ < (_tmp14_ - 1)) {
									guint _tmp15_ = 0U;
									guint* _tmp16_ = NULL;
									gint _tmp16__length1 = 0;
									gint _tmp16__length2 = 0;
									gint _tmp17_ = 0;
									gint _tmp18_ = 0;
									guint _tmp19_ = 0U;
									_tmp15_ = val;
									_tmp16_ = self->priv->_grid;
									_tmp16__length1 = self->priv->_grid_length1;
									_tmp16__length2 = self->priv->_grid_length2;
									_tmp17_ = i;
									_tmp18_ = j;
									_tmp19_ = _tmp16_[((_tmp17_ + 1) * _tmp16__length2) + _tmp18_];
									if (_tmp15_ == _tmp19_) {
										result = FALSE;
										return result;
									}
								}
								_tmp20_ = j;
								_tmp21_ = self->priv->_cols;
								if (_tmp20_ < (_tmp21_ - 1)) {
									guint _tmp22_ = 0U;
									guint* _tmp23_ = NULL;
									gint _tmp23__length1 = 0;
									gint _tmp23__length2 = 0;
									gint _tmp24_ = 0;
									gint _tmp25_ = 0;
									guint _tmp26_ = 0U;
									_tmp22_ = val;
									_tmp23_ = self->priv->_grid;
									_tmp23__length1 = self->priv->_grid_length1;
									_tmp23__length2 = self->priv->_grid_length2;
									_tmp24_ = i;
									_tmp25_ = j;
									_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + (_tmp25_ + 1)];
									if (_tmp22_ == _tmp26_) {
										result = FALSE;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


guint grid_get (Grid* self, gint row, gint col) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = row;
	_tmp2_ = self->priv->_rows;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp3_ = col;
		_tmp4_ = self->priv->_cols;
		_tmp0_ = _tmp3_ >= _tmp4_;
	}
	if (_tmp0_) {
		result = (guint) 0;
		return result;
	}
	_tmp5_ = self->priv->_grid;
	_tmp5__length1 = self->priv->_grid_length1;
	_tmp5__length2 = self->priv->_grid_length2;
	_tmp6_ = row;
	_tmp7_ = col;
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	result = _tmp8_;
	return result;
}


gchar* grid_save (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = self->priv->_rows;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, " ", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp1_, _tmp6_, NULL);
	_g_free0 (ret);
	ret = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp8_ = ret;
	_tmp9_ = self->priv->_cols;
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
	_g_free0 (ret);
	ret = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp15_ = ret;
	_tmp16_ = _grid_convert_to_string (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
	_g_free0 (ret);
	ret = _tmp18_;
	_g_free0 (_tmp17_);
	result = ret;
	return result;
}


gboolean grid_load (Grid* self, const gchar* content) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (content != NULL, FALSE);
	_tmp0_ = content;
	_tmp1_ = _grid_load_from_string (self, _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* grid_to_string (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = _grid_convert_to_string (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_g_free0 (ret);
	ret = _tmp4_;
	_g_free0 (_tmp3_);
	result = ret;
	return result;
}


static gchar* _grid_convert_to_string (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp3_ = 0U;
				gint _tmp4_ = 0;
				if (!_tmp1_) {
					guint _tmp2_ = 0U;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_rows;
				if (!(_tmp3_ < ((guint) _tmp4_))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							guint _tmp7_ = 0U;
							gint _tmp8_ = 0;
							const gchar* _tmp9_ = NULL;
							guint _tmp10_ = 0U;
							gint _tmp11_ = 0;
							const gchar* _tmp12_ = NULL;
							guint* _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp13__length2 = 0;
							guint _tmp14_ = 0U;
							guint _tmp15_ = 0U;
							guint _tmp16_ = 0U;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							if (!_tmp5_) {
								guint _tmp6_ = 0U;
								_tmp6_ = j;
								j = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = j;
							_tmp8_ = self->priv->_cols;
							if (!(_tmp7_ < ((guint) _tmp8_))) {
								break;
							}
							_tmp10_ = j;
							_tmp11_ = self->priv->_cols;
							if (_tmp10_ == ((guint) (_tmp11_ - 1))) {
								_tmp9_ = "\n";
							} else {
								_tmp9_ = " ";
							}
							_tmp12_ = ret;
							_tmp13_ = self->priv->_grid;
							_tmp13__length1 = self->priv->_grid_length1;
							_tmp13__length2 = self->priv->_grid_length2;
							_tmp14_ = i;
							_tmp15_ = j;
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
							_tmp17_ = g_strdup_printf ("%u%s", _tmp16_, _tmp9_);
							_tmp18_ = _tmp17_;
							_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
							_g_free0 (ret);
							ret = _tmp19_;
							_g_free0 (_tmp18_);
						}
					}
				}
			}
		}
	}
	result = ret;
	return result;
}


static guint* _vala_array_dup2 (guint* self, int length) {
	return g_memdup (self, length * sizeof (guint));
}


static gboolean _grid_load_from_string (Grid* self, const gchar* contents) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** tokens = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	guint* grid = NULL;
	gint grid_length1 = 0;
	gint grid_length2 = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	guint* _tmp22_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	guint* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gint _tmp48__length2 = 0;
	guint* _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gint _tmp49__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	rows = 0;
	cols = 0;
	_tmp0_ = contents;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = lines_length1;
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	if (_tmp3__length1 < 3) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = lines;
	_tmp4__length1 = lines_length1;
	_tmp5_ = _tmp4_[0];
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 0);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	tokens = _tmp7_;
	tokens_length1 = _vala_array_length (_tmp6_);
	_tokens_size_ = tokens_length1;
	_tmp8_ = tokens;
	_tmp8__length1 = tokens_length1;
	if (_tmp8__length1 != 2) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp9_ = tokens;
	_tmp9__length1 = tokens_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = atoi (_tmp10_);
	rows = _tmp11_;
	_tmp12_ = tokens;
	_tmp12__length1 = tokens_length1;
	_tmp13_ = _tmp12_[1];
	_tmp14_ = atoi (_tmp13_);
	cols = _tmp14_;
	_tmp16_ = rows;
	if (_tmp16_ < 2) {
		_tmp15_ = TRUE;
	} else {
		gint _tmp17_ = 0;
		_tmp17_ = cols;
		_tmp15_ = _tmp17_ < 2;
	}
	if (_tmp15_) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp18_ = lines;
	_tmp18__length1 = lines_length1;
	_tmp19_ = rows;
	if (_tmp18__length1 < (_tmp19_ + 1)) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp20_ = rows;
	_tmp21_ = cols;
	_tmp22_ = g_new0 (guint, _tmp20_ * _tmp21_);
	grid = (g_free (grid), NULL);
	grid = _tmp22_;
	grid_length1 = _tmp20_;
	grid_length2 = _tmp21_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				const gchar* _tmp29_ = NULL;
				gchar** _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				if (!_tmp23_) {
					gint _tmp24_ = 0;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = rows;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = lines;
				_tmp27__length1 = lines_length1;
				_tmp28_ = i;
				_tmp29_ = _tmp27_[_tmp28_ + 1];
				_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, " ", 0);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				tokens = _tmp31_;
				tokens_length1 = _vala_array_length (_tmp30_);
				_tokens_size_ = tokens_length1;
				_tmp32_ = tokens;
				_tmp32__length1 = tokens_length1;
				_tmp33_ = cols;
				if (_tmp32__length1 != _tmp33_) {
					result = FALSE;
					grid = (g_free (grid), NULL);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp34_ = FALSE;
						_tmp34_ = TRUE;
						while (TRUE) {
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							guint* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							gint _tmp42_ = 0;
							const gchar* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							guint _tmp45_ = 0U;
							if (!_tmp34_) {
								gint _tmp35_ = 0;
								_tmp35_ = j;
								j = _tmp35_ + 1;
							}
							_tmp34_ = FALSE;
							_tmp36_ = j;
							_tmp37_ = cols;
							if (!(_tmp36_ < _tmp37_)) {
								break;
							}
							_tmp38_ = grid;
							_tmp38__length1 = grid_length1;
							_tmp38__length2 = grid_length2;
							_tmp39_ = i;
							_tmp40_ = j;
							_tmp41_ = tokens;
							_tmp41__length1 = tokens_length1;
							_tmp42_ = j;
							_tmp43_ = _tmp41_[_tmp42_];
							_tmp44_ = atoi (_tmp43_);
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = (guint) _tmp44_;
							_tmp45_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
						}
					}
				}
			}
		}
	}
	_tmp46_ = rows;
	self->priv->_rows = _tmp46_;
	_tmp47_ = cols;
	self->priv->_cols = _tmp47_;
	_tmp48_ = grid;
	_tmp48__length1 = grid_length1;
	_tmp48__length2 = grid_length2;
	_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup2 (_tmp48_, _tmp48__length1 * _tmp48__length2) : ((gpointer) _tmp48_);
	_tmp49__length1 = _tmp48__length1;
	_tmp49__length2 = _tmp48__length2;
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
	self->priv->_grid = _tmp49_;
	self->priv->_grid_length1 = _tmp49__length1;
	self->priv->_grid_length2 = _tmp49__length2;
	result = TRUE;
	grid = (g_free (grid), NULL);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean _grid_grid_is_full (Grid* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_ = 0U;
				gint _tmp3_ = 0;
				if (!_tmp0_) {
					guint _tmp1_ = 0U;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_rows;
				if (!(_tmp2_ < ((guint) _tmp3_))) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							guint _tmp6_ = 0U;
							gint _tmp7_ = 0;
							guint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							guint _tmp9_ = 0U;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
							if (!_tmp4_) {
								guint _tmp5_ = 0U;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = j;
							_tmp7_ = self->priv->_cols;
							if (!(_tmp6_ < ((guint) _tmp7_))) {
								break;
							}
							_tmp8_ = self->priv->_grid;
							_tmp8__length1 = self->priv->_grid_length1;
							_tmp8__length2 = self->priv->_grid_length2;
							_tmp9_ = i;
							_tmp10_ = j;
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
							if (_tmp11_ == ((guint) 0)) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void _grid_random_position (Grid* self, GridPosition* result) {
	GridPosition ret = {0};
	gint _tmp0_ = 0;
	gint32 _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint32 _tmp3_ = 0;
	GridPosition _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp0_));
	_tmp2_ = self->priv->_cols;
	_tmp3_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp2_));
	_tmp4_.row = (guint) _tmp1_;
	_tmp4_.col = (guint) _tmp3_;
	ret = _tmp4_;
	*result = ret;
	return;
}


static void _grid_check_target_value_reached (Grid* self, guint val) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_value;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = val;
		_tmp2_ = self->priv->_target_value;
		if (_tmp1_ == _tmp2_) {
			grid_set_target_value_reached (self, TRUE);
		}
	}
}


gint grid_get_rows (Grid* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	result = _tmp0_;
	return result;
}


void grid_set_rows (Grid* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rows = _tmp0_;
	g_object_notify ((GObject *) self, "rows");
}


gint grid_get_cols (Grid* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cols;
	result = _tmp0_;
	return result;
}


void grid_set_cols (Grid* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_cols = _tmp0_;
	g_object_notify ((GObject *) self, "cols");
}


guint grid_get_target_value (Grid* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_target_value;
	result = _tmp0_;
	return result;
}


void grid_set_target_value (Grid* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_target_value = _tmp0_;
	g_object_notify ((GObject *) self, "target-value");
}


gboolean grid_get_target_value_reached (Grid* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_target_value_reached;
	result = _tmp0_;
	return result;
}


void grid_set_target_value_reached (Grid* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_target_value_reached = _tmp0_;
	g_object_notify ((GObject *) self, "target-value-reached");
}


static void grid_class_init (GridClass * klass) {
	grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GridPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_grid_set_property;
	G_OBJECT_CLASS (klass)->finalize = grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE, g_param_spec_uint ("target-value", "target-value", "target-value", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_REACHED, g_param_spec_boolean ("target-value-reached", "target-value-reached", "target-value-reached", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void grid_instance_init (Grid * self) {
	self->priv = GRID_GET_PRIVATE (self);
}


static void grid_finalize (GObject* obj) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRID, Grid);
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
	G_OBJECT_CLASS (grid_parent_class)->finalize (obj);
}


GType grid_get_type (void) {
	static volatile gsize grid_type_id__volatile = 0;
	if (g_once_init_enter (&grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Grid), 0, (GInstanceInitFunc) grid_instance_init, NULL };
		GType grid_type_id;
		grid_type_id = g_type_register_static (G_TYPE_OBJECT, "Grid", &g_define_type_info, 0);
		g_once_init_leave (&grid_type_id__volatile, grid_type_id);
	}
	return grid_type_id__volatile;
}


static void _vala_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
	switch (property_id) {
		case GRID_ROWS:
		g_value_set_int (value, grid_get_rows (self));
		break;
		case GRID_COLS:
		g_value_set_int (value, grid_get_cols (self));
		break;
		case GRID_TARGET_VALUE:
		g_value_set_uint (value, grid_get_target_value (self));
		break;
		case GRID_TARGET_VALUE_REACHED:
		g_value_set_boolean (value, grid_get_target_value_reached (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
	switch (property_id) {
		case GRID_ROWS:
		grid_set_rows (self, g_value_get_int (value));
		break;
		case GRID_COLS:
		grid_set_cols (self, g_value_get_int (value));
		break;
		case GRID_TARGET_VALUE:
		grid_set_target_value (self, g_value_get_uint (value));
		break;
		case GRID_TARGET_VALUE_REACHED:
		grid_set_target_value_reached (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gchar* grid_position_to_string (GridPosition *self) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = (*self).row;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (*self).col;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("(", _tmp2_, ",", _tmp5_, ")", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}


GridPosition* grid_position_dup (const GridPosition* self) {
	GridPosition* dup;
	dup = g_new0 (GridPosition, 1);
	memcpy (dup, self, sizeof (GridPosition));
	return dup;
}


void grid_position_free (GridPosition* self) {
	g_free (self);
}


GType grid_position_get_type (void) {
	static volatile gsize grid_position_type_id__volatile = 0;
	if (g_once_init_enter (&grid_position_type_id__volatile)) {
		GType grid_position_type_id;
		grid_position_type_id = g_boxed_type_register_static ("GridPosition", (GBoxedCopyFunc) grid_position_dup, (GBoxedFreeFunc) grid_position_free);
		g_once_init_leave (&grid_position_type_id__volatile, grid_position_type_id);
	}
	return grid_position_type_id__volatile;
}


TileMovement* tile_movement_dup (const TileMovement* self) {
	TileMovement* dup;
	dup = g_new0 (TileMovement, 1);
	memcpy (dup, self, sizeof (TileMovement));
	return dup;
}


void tile_movement_free (TileMovement* self) {
	g_free (self);
}


GType tile_movement_get_type (void) {
	static volatile gsize tile_movement_type_id__volatile = 0;
	if (g_once_init_enter (&tile_movement_type_id__volatile)) {
		GType tile_movement_type_id;
		tile_movement_type_id = g_boxed_type_register_static ("TileMovement", (GBoxedCopyFunc) tile_movement_dup, (GBoxedFreeFunc) tile_movement_free);
		g_once_init_leave (&tile_movement_type_id__volatile, tile_movement_type_id);
	}
	return tile_movement_type_id__volatile;
}


Tile* tile_dup (const Tile* self) {
	Tile* dup;
	dup = g_new0 (Tile, 1);
	memcpy (dup, self, sizeof (Tile));
	return dup;
}


void tile_free (Tile* self) {
	g_free (self);
}


GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		GType tile_type_id;
		tile_type_id = g_boxed_type_register_static ("Tile", (GBoxedCopyFunc) tile_dup, (GBoxedFreeFunc) tile_free);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



