/* game.c generated by valac 0.30.0, the Vala compiler
 * generated from game.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _TileMovement TileMovement;

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;

#define GAME_TYPE_GAME_STATE (game_game_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tile_movement_free0(var) ((var == NULL) ? NULL : (var = (tile_movement_free (var), NULL)))
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

typedef enum  {
	GAME_GAME_STATE_STOPPED,
	GAME_GAME_STATE_IDLE,
	GAME_GAME_STATE_MOVING_DOWN,
	GAME_GAME_STATE_MOVING_UP,
	GAME_GAME_STATE_MOVING_RIGHT,
	GAME_GAME_STATE_MOVING_LEFT,
	GAME_GAME_STATE_SHOWING_FIRST_TILE,
	GAME_GAME_STATE_SHOWING_SECOND_TILE,
	GAME_GAME_STATE_RESTORING_TILES
} GameGameState;

struct _GamePrivate {
	gint BLANK_ROW_HEIGHT;
	gint BLANK_COL_WIDTH;
	Grid* _grid;
	guint _finish_move_id;
	ClutterActor* _view;
	ClutterActor* _view_background;
	ClutterActor* _view_foreground;
	RoundedRectangle** _background;
	gint _background_length1;
	gint _background_length2;
	TileView** _foreground_cur;
	gint _foreground_cur_length1;
	gint _foreground_cur_length2;
	TileView** _foreground_nxt;
	gint _foreground_nxt_length1;
	gint _foreground_nxt_length2;
	GeeLinkedList* _to_move;
	GeeLinkedList* _to_hide;
	GeeLinkedList* _to_show;
	GameGameState _state;
	ClutterTransitionGroup* _show_hide_trans;
	ClutterTransitionGroup* _move_trans;
	gint _animations_duration;
	gboolean _allow_undo;
	guint _undo_stack_max_size;
	GeeLinkedList* _undo_stack;
	GeeLinkedList* _undo_score_stack;
	GSettings* _settings;
	gchar* _saved_path;
	guint _resize_view_id;
	guint _score;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType grid_get_type (void) G_GNUC_CONST;
GType rounded_rectangle_get_type (void) G_GNUC_CONST;
GType tile_view_get_type (void) G_GNUC_CONST;
GType tile_movement_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
GType tile_get_type (void) G_GNUC_CONST;
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
static GType game_game_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_VIEW,
	GAME_SCORE
};
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void game_new_game (Game* self);
void grid_clear (Grid* self);
static void _game_init_background (Game* self);
static void _game_clear_foreground (Game* self);
void game_set_score (Game* self, guint value);
static void _game_create_random_tile (Game* self);
void game_undo (Game* self);
static void _game_restore_foreground (Game* self, gboolean animate);
guint game_get_score (Game* self);
void game_save_game (Game* self);
gchar* grid_save (Grid* self);
gboolean game_restore_game (Game* self);
gboolean grid_load (Grid* self, const gchar* content);
static void _game_clear_background (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
static guint _game_upper_key (Game* self, guint keyval);
static void _game_move_down (Game* self);
static void _game_move_up (Game* self);
static void _game_move_left (Game* self);
static void _game_move_right (Game* self);
gboolean game_reload_settings (Game* self);
gint grid_get_rows (Grid* self);
gint grid_get_cols (Grid* self);
static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags);
static void _game_resize_view (Game* self);
RoundedRectangle* rounded_rectangle_new (gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
RoundedRectangle* rounded_rectangle_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
void rounded_rectangle_resize (RoundedRectangle* self, gfloat x, gfloat y, gfloat width, gfloat height);
static gboolean _game_idle_resize_view (Game* self);
static gboolean __game_idle_resize_view_gsource_func (gpointer self);
void rounded_rectangle_idle_resize (RoundedRectangle* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static void _game_create_show_hide_transition (Game* self, gboolean animate);
static void _game_create_tile (Game* self, Tile* tile);
static void _game_show_tile (Game* self, GridPosition* pos);
TileView* tile_view_new (gfloat x, gfloat y, gfloat width, gfloat height, guint val);
TileView* tile_view_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, guint val);
static void _game_store_movement (Game* self);
static void _game_on_move_trans_stopped (Game* self, gboolean is_finished);
static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to);
static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
static void _game_dim_tile (Game* self, GridPosition* pos);
guint tile_view_get_value (TileView* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_to_string (Grid* self);
static void _game_store_score_update (Game* self, guint delta_score);
static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished);
static gboolean _game_finish_move (Game* self);
static gboolean __game_finish_move_gsource_func (gpointer self);
static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
gboolean grid_get_target_value_reached (Grid* self);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gboolean grid_is_finished (Grid* self);
Grid* grid_clone (Grid* self);
ClutterActor* game_get_view (Game* self);
void game_set_view (Game* self, ClutterActor* value);
static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType game_game_state_get_type (void) {
	static volatile gsize game_game_state_type_id__volatile = 0;
	if (g_once_init_enter (&game_game_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_GAME_STATE_STOPPED, "GAME_GAME_STATE_STOPPED", "stopped"}, {GAME_GAME_STATE_IDLE, "GAME_GAME_STATE_IDLE", "idle"}, {GAME_GAME_STATE_MOVING_DOWN, "GAME_GAME_STATE_MOVING_DOWN", "moving-down"}, {GAME_GAME_STATE_MOVING_UP, "GAME_GAME_STATE_MOVING_UP", "moving-up"}, {GAME_GAME_STATE_MOVING_RIGHT, "GAME_GAME_STATE_MOVING_RIGHT", "moving-right"}, {GAME_GAME_STATE_MOVING_LEFT, "GAME_GAME_STATE_MOVING_LEFT", "moving-left"}, {GAME_GAME_STATE_SHOWING_FIRST_TILE, "GAME_GAME_STATE_SHOWING_FIRST_TILE", "showing-first-tile"}, {GAME_GAME_STATE_SHOWING_SECOND_TILE, "GAME_GAME_STATE_SHOWING_SECOND_TILE", "showing-second-tile"}, {GAME_GAME_STATE_RESTORING_TILES, "GAME_GAME_STATE_RESTORING_TILES", "restoring-tiles"}, {0, NULL, NULL}};
		GType game_game_state_type_id;
		game_game_state_type_id = g_enum_register_static ("GameGameState", values);
		g_once_init_leave (&game_game_state_type_id__volatile, game_game_state_type_id);
	}
	return game_game_state_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Game* game_construct (GType object_type, GSettings* settings) {
	Game * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint rows = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint cols = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Grid* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GSettings* _tmp9_ = NULL;
	Grid* _tmp10_ = NULL;
	GeeLinkedList* _tmp11_ = NULL;
	GeeLinkedList* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	GeeLinkedList* _tmp18_ = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GSettings* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	_tmp2_ = self->priv->_settings;
	_tmp3_ = g_settings_get_int (_tmp2_, "rows");
	rows = _tmp3_;
	_tmp4_ = self->priv->_settings;
	_tmp5_ = g_settings_get_int (_tmp4_, "cols");
	cols = _tmp5_;
	_tmp6_ = grid_new (rows, cols);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_grid = _tmp6_;
	_tmp7_ = self->priv->_settings;
	_tmp8_ = g_settings_get_double (_tmp7_, "animations-speed");
	self->priv->_animations_duration = (gint) _tmp8_;
	_tmp9_ = self->priv->_settings;
	_tmp10_ = self->priv->_grid;
	g_settings_bind (_tmp9_, "target-value", (GObject*) _tmp10_, "target_value", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_to_move);
	self->priv->_to_move = _tmp11_;
	_tmp12_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_to_hide);
	self->priv->_to_hide = _tmp12_;
	_tmp13_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, tile_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_to_show);
	self->priv->_to_show = _tmp13_;
	_tmp14_ = clutter_actor_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->_view_background);
	self->priv->_view_background = _tmp14_;
	_tmp15_ = clutter_actor_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->_view_foreground);
	self->priv->_view_foreground = _tmp15_;
	_tmp16_ = self->priv->_view_background;
	clutter_actor_show (_tmp16_);
	_tmp17_ = self->priv->_view_foreground;
	clutter_actor_show (_tmp17_);
	_tmp18_ = gee_linked_list_new (TYPE_GRID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_undo_stack);
	self->priv->_undo_stack = _tmp18_;
	_tmp19_ = gee_linked_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_undo_score_stack);
	self->priv->_undo_score_stack = _tmp19_;
	_tmp20_ = self->priv->_settings;
	_tmp21_ = g_settings_get_boolean (_tmp20_, "allow-undo");
	self->priv->_allow_undo = _tmp21_;
	_tmp22_ = self->priv->_settings;
	_tmp23_ = g_settings_get_int (_tmp22_, "allow-undo-max");
	self->priv->_undo_stack_max_size = (guint) _tmp23_;
	_tmp24_ = g_get_user_data_dir ();
	_tmp25_ = g_build_filename (_tmp24_, "gnome-2048", "saved", NULL);
	_g_free0 (self->priv->_saved_path);
	self->priv->_saved_path = _tmp25_;
	self->priv->_state = GAME_GAME_STATE_STOPPED;
	return self;
}


Game* game_new (GSettings* settings) {
	return game_construct (TYPE_GAME, settings);
}


void game_new_game (Game* self) {
	guint _tmp0_ = 0U;
	Grid* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	RoundedRectangle** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_finish_move_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->_finish_move_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->priv->_grid;
	grid_clear (_tmp2_);
	_tmp3_ = self->priv->_undo_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	_tmp4_ = self->priv->_undo_score_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
	_tmp5_ = self->priv->_background;
	_tmp5__length1 = self->priv->_background_length1;
	_tmp5__length2 = self->priv->_background_length2;
	if (_tmp5_ == NULL) {
		_game_init_background (self);
	} else {
		_game_clear_foreground (self);
	}
	game_set_score (self, (guint) 0);
	self->priv->_state = GAME_GAME_STATE_SHOWING_FIRST_TILE;
	_game_create_random_tile (self);
	g_signal_emit_by_name (self, "undo-disabled");
}


void game_undo (Game* self) {
	Grid* grid = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	guint delta_score = 0U;
	GeeLinkedList* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	Grid* _tmp4_ = NULL;
	Grid* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	GeeLinkedList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_undo_stack;
	_tmp1_ = gee_deque_poll_head ((GeeDeque*) _tmp0_);
	grid = (Grid*) _tmp1_;
	_tmp2_ = self->priv->_undo_score_stack;
	_tmp3_ = gee_deque_poll_head ((GeeDeque*) _tmp2_);
	delta_score = (guint) ((guintptr) _tmp3_);
	_game_clear_foreground (self);
	_tmp4_ = grid;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_grid = _tmp5_;
	_game_restore_foreground (self, FALSE);
	_tmp6_ = self->priv->_score;
	_tmp7_ = delta_score;
	game_set_score (self, _tmp6_ - _tmp7_);
	_tmp8_ = self->priv->_undo_stack;
	_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 0) {
		g_signal_emit_by_name (self, "undo-disabled");
	}
	_g_object_unref0 (grid);
}


void game_save_game (Game* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = contents;
	_tmp2_ = self->priv->_grid;
	_tmp3_ = grid_save (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
	_g_free0 (contents);
	contents = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = contents;
	_tmp7_ = self->priv->_score;
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
	_g_free0 (contents);
	contents = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	{
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp13_ = self->priv->_saved_path;
		_tmp14_ = g_path_get_dirname (_tmp13_);
		_tmp15_ = _tmp14_;
		g_mkdir_with_parents (_tmp15_, 0775);
		_g_free0 (_tmp15_);
		_tmp16_ = self->priv->_saved_path;
		_tmp17_ = contents;
		g_file_set_contents (_tmp16_, _tmp17_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_debug ("game.vala:160: game saved successfully");
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("game.vala:162: Failed to save game: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
}


gboolean game_restore_game (Game* self) {
	gboolean result = FALSE;
	gchar* contents = NULL;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	Grid* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	RoundedRectangle** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->_saved_path;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch10_g_file_error;
			}
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally10;
	__catch10_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (contents);
		return result;
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = self->priv->_grid;
	_tmp3_ = contents;
	_tmp4_ = grid_load (_tmp2_, _tmp3_);
	if (!_tmp4_) {
		g_warning ("game.vala:178: Failed to restore game from saved file");
		result = FALSE;
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (contents);
		return result;
	}
	_tmp5_ = contents;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	lines = _tmp7_;
	lines_length1 = _vala_array_length (_tmp6_);
	_lines_size_ = lines_length1;
	_tmp8_ = lines;
	_tmp8__length1 = lines_length1;
	_tmp9_ = lines;
	_tmp9__length1 = lines_length1;
	_tmp10_ = _tmp8_[_tmp9__length1 - 2];
	_tmp11_ = atoi (_tmp10_);
	game_set_score (self, (guint) _tmp11_);
	_tmp12_ = self->priv->_background;
	_tmp12__length1 = self->priv->_background_length1;
	_tmp12__length2 = self->priv->_background_length2;
	if (_tmp12_ != NULL) {
		_game_clear_background (self);
	}
	_game_init_background (self);
	_game_restore_foreground (self, TRUE);
	g_debug ("game.vala:190: game restored successfully");
	result = TRUE;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (contents);
	return result;
}


gboolean game_key_pressed (Game* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	guint keyval = 0U;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != GAME_GAME_STATE_IDLE) {
		result = TRUE;
		return result;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = _game_upper_key (self, _tmp2_);
	keyval = _tmp3_;
	_tmp4_ = keyval;
	if (_tmp4_ == ((guint) GDK_KEY_Down)) {
		_game_move_down (self);
	} else {
		guint _tmp5_ = 0U;
		_tmp5_ = keyval;
		if (_tmp5_ == ((guint) GDK_KEY_Up)) {
			_game_move_up (self);
		} else {
			guint _tmp6_ = 0U;
			_tmp6_ = keyval;
			if (_tmp6_ == ((guint) GDK_KEY_Left)) {
				_game_move_left (self);
			} else {
				guint _tmp7_ = 0U;
				_tmp7_ = keyval;
				if (_tmp7_ == ((guint) GDK_KEY_Right)) {
					_game_move_right (self);
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean game_reload_settings (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gboolean allow_undo = FALSE;
	GSettings* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	Grid* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_double (_tmp0_, "animations-speed");
	self->priv->_animations_duration = (gint) _tmp1_;
	_tmp2_ = self->priv->_settings;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "allow-undo");
	allow_undo = _tmp3_;
	_tmp5_ = self->priv->_allow_undo;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = allow_undo;
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GeeLinkedList* _tmp7_ = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		_tmp7_ = self->priv->_undo_stack;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
		_tmp8_ = self->priv->_undo_score_stack;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
		g_signal_emit_by_name (self, "undo-disabled");
	}
	_tmp9_ = allow_undo;
	self->priv->_allow_undo = _tmp9_;
	_tmp10_ = self->priv->_settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "allow-undo-max");
	self->priv->_undo_stack_max_size = (guint) _tmp11_;
	_tmp12_ = self->priv->_settings;
	_tmp13_ = g_settings_get_int (_tmp12_, "rows");
	rows = _tmp13_;
	_tmp14_ = self->priv->_settings;
	_tmp15_ = g_settings_get_int (_tmp14_, "cols");
	cols = _tmp15_;
	_tmp17_ = rows;
	_tmp18_ = self->priv->_grid;
	_tmp19_ = grid_get_rows (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp17_ != _tmp20_) {
		_tmp16_ = TRUE;
	} else {
		gint _tmp21_ = 0;
		Grid* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		_tmp21_ = cols;
		_tmp22_ = self->priv->_grid;
		_tmp23_ = grid_get_cols (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp16_ = _tmp21_ != _tmp24_;
	}
	if (_tmp16_) {
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		Grid* _tmp27_ = NULL;
		_game_clear_foreground (self);
		_game_clear_background (self);
		_tmp25_ = rows;
		_tmp26_ = cols;
		_tmp27_ = grid_new (_tmp25_, _tmp26_);
		_g_object_unref0 (self->priv->_grid);
		self->priv->_grid = _tmp27_;
		_game_init_background (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static guint _game_upper_key (Game* self, guint keyval) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = keyval;
	if (_tmp1_ > ((guint) 255)) {
		guint _tmp2_ = 0U;
		_tmp2_ = keyval;
		_tmp0_ = _tmp2_;
	} else {
		guint _tmp3_ = 0U;
		gchar _tmp4_ = '\0';
		_tmp3_ = keyval;
		_tmp4_ = g_ascii_toupper ((gchar) _tmp3_);
		_tmp0_ = (guint) _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags) {
	RoundedRectangle** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->_background;
	_tmp0__length1 = self->priv->_background_length1;
	_tmp0__length2 = self->priv->_background_length2;
	if (_tmp0_ == NULL) {
		_game_init_background (self);
	} else {
		_game_resize_view (self);
	}
}


static void _game_init_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ClutterColor background_color = {0};
	ClutterActor* _tmp6_ = NULL;
	ClutterColor _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	RoundedRectangle** _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	TileView** _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	TileView** _tmp16_ = NULL;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp19_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gfloat _tmp26_ = 0.0F;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp29_ = 0.0F;
	gint _tmp30_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp31_ = 0.0F;
	gint _tmp32_ = 0;
	ClutterColor color = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	clutter_color_from_string (&background_color, "#babdb6");
	_tmp6_ = self->priv->_view;
	_tmp7_ = background_color;
	clutter_actor_set_background_color (_tmp6_, &_tmp7_);
	_tmp8_ = rows;
	_tmp9_ = cols;
	_tmp10_ = g_new0 (RoundedRectangle*, (_tmp8_ * _tmp9_) + 1);
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_background = _tmp10_;
	self->priv->_background_length1 = _tmp8_;
	self->priv->_background_length2 = _tmp9_;
	_tmp11_ = rows;
	_tmp12_ = cols;
	_tmp13_ = g_new0 (TileView*, (_tmp11_ * _tmp12_) + 1);
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_cur = _tmp13_;
	self->priv->_foreground_cur_length1 = _tmp11_;
	self->priv->_foreground_cur_length2 = _tmp12_;
	_tmp14_ = rows;
	_tmp15_ = cols;
	_tmp16_ = g_new0 (TileView*, (_tmp14_ * _tmp15_) + 1);
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_nxt = _tmp16_;
	self->priv->_foreground_nxt_length1 = _tmp14_;
	self->priv->_foreground_nxt_length2 = _tmp15_;
	_tmp17_ = self->priv->_view;
	_tmp18_ = clutter_actor_get_width (_tmp17_);
	_tmp19_ = _tmp18_;
	canvas_width = _tmp19_;
	_tmp20_ = self->priv->_view;
	_tmp21_ = clutter_actor_get_height (_tmp20_);
	_tmp22_ = _tmp21_;
	canvas_height = _tmp22_;
	_tmp23_ = canvas_width;
	_tmp24_ = cols;
	_tmp25_ = self->priv->BLANK_COL_WIDTH;
	canvas_width = _tmp23_ - ((_tmp24_ + 1) * _tmp25_);
	_tmp26_ = canvas_height;
	_tmp27_ = rows;
	_tmp28_ = self->priv->BLANK_ROW_HEIGHT;
	canvas_height = _tmp26_ - ((_tmp27_ + 1) * _tmp28_);
	_tmp29_ = canvas_width;
	_tmp30_ = cols;
	tile_width = _tmp29_ / _tmp30_;
	_tmp31_ = canvas_height;
	_tmp32_ = rows;
	tile_height = _tmp31_ / _tmp32_;
	clutter_color_from_string (&color, "#ffffff");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				if (!_tmp33_) {
					gint _tmp34_ = 0;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				_tmp36_ = rows;
				if (!(_tmp35_ < _tmp36_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp37_ = FALSE;
						_tmp37_ = TRUE;
						while (TRUE) {
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gfloat x = 0.0F;
							gint _tmp41_ = 0;
							gfloat _tmp42_ = 0.0F;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gfloat y = 0.0F;
							gint _tmp45_ = 0;
							gfloat _tmp46_ = 0.0F;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							RoundedRectangle* rect = NULL;
							gfloat _tmp49_ = 0.0F;
							gfloat _tmp50_ = 0.0F;
							gfloat _tmp51_ = 0.0F;
							gfloat _tmp52_ = 0.0F;
							ClutterColor _tmp53_ = {0};
							RoundedRectangle* _tmp54_ = NULL;
							ClutterActor* _tmp55_ = NULL;
							RoundedRectangle* _tmp56_ = NULL;
							ClutterActor* _tmp57_ = NULL;
							ClutterActor* _tmp58_ = NULL;
							RoundedRectangle* _tmp59_ = NULL;
							ClutterCanvas* _tmp60_ = NULL;
							ClutterCanvas* _tmp61_ = NULL;
							RoundedRectangle* _tmp62_ = NULL;
							ClutterActor* _tmp63_ = NULL;
							ClutterActor* _tmp64_ = NULL;
							RoundedRectangle** _tmp65_ = NULL;
							gint _tmp65__length1 = 0;
							gint _tmp65__length2 = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							RoundedRectangle* _tmp68_ = NULL;
							RoundedRectangle* _tmp69_ = NULL;
							RoundedRectangle* _tmp70_ = NULL;
							TileView** _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							TileView* _tmp74_ = NULL;
							TileView** _tmp75_ = NULL;
							gint _tmp75__length1 = 0;
							gint _tmp75__length2 = 0;
							gint _tmp76_ = 0;
							gint _tmp77_ = 0;
							TileView* _tmp78_ = NULL;
							if (!_tmp37_) {
								gint _tmp38_ = 0;
								_tmp38_ = j;
								j = _tmp38_ + 1;
							}
							_tmp37_ = FALSE;
							_tmp39_ = j;
							_tmp40_ = cols;
							if (!(_tmp39_ < _tmp40_)) {
								break;
							}
							_tmp41_ = j;
							_tmp42_ = tile_width;
							_tmp43_ = j;
							_tmp44_ = self->priv->BLANK_COL_WIDTH;
							x = (_tmp41_ * _tmp42_) + ((_tmp43_ + 1) * _tmp44_);
							_tmp45_ = i;
							_tmp46_ = tile_height;
							_tmp47_ = i;
							_tmp48_ = self->priv->BLANK_ROW_HEIGHT;
							y = (_tmp45_ * _tmp46_) + ((_tmp47_ + 1) * _tmp48_);
							_tmp49_ = x;
							_tmp50_ = y;
							_tmp51_ = tile_width;
							_tmp52_ = tile_height;
							_tmp53_ = color;
							_tmp54_ = rounded_rectangle_new (_tmp49_, _tmp50_, _tmp51_, _tmp52_, &_tmp53_);
							rect = _tmp54_;
							_tmp55_ = self->priv->_view_background;
							_tmp56_ = rect;
							_tmp57_ = rounded_rectangle_get_actor (_tmp56_);
							_tmp58_ = _tmp57_;
							clutter_actor_add_child (_tmp55_, _tmp58_);
							_tmp59_ = rect;
							_tmp60_ = rounded_rectangle_get_canvas (_tmp59_);
							_tmp61_ = _tmp60_;
							clutter_content_invalidate ((ClutterContent*) _tmp61_);
							_tmp62_ = rect;
							_tmp63_ = rounded_rectangle_get_actor (_tmp62_);
							_tmp64_ = _tmp63_;
							clutter_actor_show (_tmp64_);
							_tmp65_ = self->priv->_background;
							_tmp65__length1 = self->priv->_background_length1;
							_tmp65__length2 = self->priv->_background_length2;
							_tmp66_ = i;
							_tmp67_ = j;
							_tmp68_ = rect;
							_tmp69_ = _g_object_ref0 (_tmp68_);
							_g_object_unref0 (_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_]);
							_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = _tmp69_;
							_tmp70_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
							_tmp71_ = self->priv->_foreground_cur;
							_tmp71__length1 = self->priv->_foreground_cur_length1;
							_tmp71__length2 = self->priv->_foreground_cur_length2;
							_tmp72_ = i;
							_tmp73_ = j;
							_g_object_unref0 (_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_]);
							_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_] = NULL;
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
							_tmp75_ = self->priv->_foreground_nxt;
							_tmp75__length1 = self->priv->_foreground_nxt_length1;
							_tmp75__length2 = self->priv->_foreground_nxt_length2;
							_tmp76_ = i;
							_tmp77_ = j;
							_g_object_unref0 (_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_]);
							_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_] = NULL;
							_tmp78_ = _tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_];
							_g_object_unref0 (rect);
						}
					}
				}
			}
		}
	}
}


static gboolean __game_idle_resize_view_gsource_func (gpointer self) {
	gboolean result;
	result = _game_idle_resize_view ((Game*) self);
	return result;
}


static void _game_resize_view (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp6_ = NULL;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp9_ = NULL;
	gfloat _tmp10_ = 0.0F;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gfloat _tmp15_ = 0.0F;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gint _tmp19_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp20_ = 0.0F;
	gint _tmp21_ = 0;
	guint _tmp70_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_tmp6_ = self->priv->_view;
	_tmp7_ = clutter_actor_get_width (_tmp6_);
	_tmp8_ = _tmp7_;
	canvas_width = _tmp8_;
	_tmp9_ = self->priv->_view;
	_tmp10_ = clutter_actor_get_height (_tmp9_);
	_tmp11_ = _tmp10_;
	canvas_height = _tmp11_;
	_tmp12_ = canvas_width;
	_tmp13_ = cols;
	_tmp14_ = self->priv->BLANK_COL_WIDTH;
	canvas_width = _tmp12_ - ((_tmp13_ + 1) * _tmp14_);
	_tmp15_ = canvas_height;
	_tmp16_ = rows;
	_tmp17_ = self->priv->BLANK_ROW_HEIGHT;
	canvas_height = _tmp15_ - ((_tmp16_ + 1) * _tmp17_);
	_tmp18_ = canvas_width;
	_tmp19_ = cols;
	tile_width = _tmp18_ / _tmp19_;
	_tmp20_ = canvas_height;
	_tmp21_ = rows;
	tile_height = _tmp20_ / _tmp21_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = rows;
				if (!(_tmp24_ < _tmp25_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gfloat x = 0.0F;
							gint _tmp30_ = 0;
							gfloat _tmp31_ = 0.0F;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gfloat y = 0.0F;
							gint _tmp34_ = 0;
							gfloat _tmp35_ = 0.0F;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							RoundedRectangle** _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							RoundedRectangle* _tmp41_ = NULL;
							gfloat _tmp42_ = 0.0F;
							gfloat _tmp43_ = 0.0F;
							gfloat _tmp44_ = 0.0F;
							gfloat _tmp45_ = 0.0F;
							TileView** _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							TileView* _tmp49_ = NULL;
							TileView** _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							gint _tmp58__length2 = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							TileView* _tmp61_ = NULL;
							if (!_tmp26_) {
								gint _tmp27_ = 0;
								_tmp27_ = j;
								j = _tmp27_ + 1;
							}
							_tmp26_ = FALSE;
							_tmp28_ = j;
							_tmp29_ = cols;
							if (!(_tmp28_ < _tmp29_)) {
								break;
							}
							_tmp30_ = j;
							_tmp31_ = tile_width;
							_tmp32_ = j;
							_tmp33_ = self->priv->BLANK_COL_WIDTH;
							x = (_tmp30_ * _tmp31_) + ((_tmp32_ + 1) * _tmp33_);
							_tmp34_ = i;
							_tmp35_ = tile_height;
							_tmp36_ = i;
							_tmp37_ = self->priv->BLANK_ROW_HEIGHT;
							y = (_tmp34_ * _tmp35_) + ((_tmp36_ + 1) * _tmp37_);
							_tmp38_ = self->priv->_background;
							_tmp38__length1 = self->priv->_background_length1;
							_tmp38__length2 = self->priv->_background_length2;
							_tmp39_ = i;
							_tmp40_ = j;
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
							_tmp42_ = x;
							_tmp43_ = y;
							_tmp44_ = tile_width;
							_tmp45_ = tile_height;
							rounded_rectangle_resize (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_);
							_tmp46_ = self->priv->_foreground_cur;
							_tmp46__length1 = self->priv->_foreground_cur_length1;
							_tmp46__length2 = self->priv->_foreground_cur_length2;
							_tmp47_ = i;
							_tmp48_ = j;
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
							if (_tmp49_ != NULL) {
								TileView** _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								gint _tmp50__length2 = 0;
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								TileView* _tmp53_ = NULL;
								gfloat _tmp54_ = 0.0F;
								gfloat _tmp55_ = 0.0F;
								gfloat _tmp56_ = 0.0F;
								gfloat _tmp57_ = 0.0F;
								_tmp50_ = self->priv->_foreground_cur;
								_tmp50__length1 = self->priv->_foreground_cur_length1;
								_tmp50__length2 = self->priv->_foreground_cur_length2;
								_tmp51_ = i;
								_tmp52_ = j;
								_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
								_tmp54_ = x;
								_tmp55_ = y;
								_tmp56_ = tile_width;
								_tmp57_ = tile_height;
								rounded_rectangle_resize ((RoundedRectangle*) _tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
							}
							_tmp58_ = self->priv->_foreground_nxt;
							_tmp58__length1 = self->priv->_foreground_nxt_length1;
							_tmp58__length2 = self->priv->_foreground_nxt_length2;
							_tmp59_ = i;
							_tmp60_ = j;
							_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
							if (_tmp61_ != NULL) {
								TileView** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								gint _tmp62__length2 = 0;
								gint _tmp63_ = 0;
								gint _tmp64_ = 0;
								TileView* _tmp65_ = NULL;
								gfloat _tmp66_ = 0.0F;
								gfloat _tmp67_ = 0.0F;
								gfloat _tmp68_ = 0.0F;
								gfloat _tmp69_ = 0.0F;
								_tmp62_ = self->priv->_foreground_nxt;
								_tmp62__length1 = self->priv->_foreground_nxt_length1;
								_tmp62__length2 = self->priv->_foreground_nxt_length2;
								_tmp63_ = i;
								_tmp64_ = j;
								_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
								_tmp66_ = x;
								_tmp67_ = y;
								_tmp68_ = tile_width;
								_tmp69_ = tile_height;
								rounded_rectangle_resize ((RoundedRectangle*) _tmp65_, _tmp66_, _tmp67_, _tmp68_, _tmp69_);
							}
						}
					}
				}
			}
		}
	}
	_tmp70_ = self->priv->_resize_view_id;
	if (_tmp70_ == ((guint) 0)) {
		guint _tmp71_ = 0U;
		_tmp71_ = clutter_threads_add_timeout ((guint) 1000, __game_idle_resize_view_gsource_func, self);
		self->priv->_resize_view_id = _tmp71_;
	}
}


static gboolean _game_idle_resize_view (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = rows;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							TileView** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp18__length2 = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							TileView* _tmp21_ = NULL;
							if (!_tmp10_) {
								gint _tmp11_ = 0;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = j;
							_tmp13_ = cols;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->_background;
							_tmp14__length1 = self->priv->_background_length1;
							_tmp14__length2 = self->priv->_background_length2;
							_tmp15_ = i;
							_tmp16_ = j;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							rounded_rectangle_idle_resize (_tmp17_);
							_tmp18_ = self->priv->_foreground_cur;
							_tmp18__length1 = self->priv->_foreground_cur_length1;
							_tmp18__length2 = self->priv->_foreground_cur_length2;
							_tmp19_ = i;
							_tmp20_ = j;
							_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
							if (_tmp21_ != NULL) {
								TileView** _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp22__length2 = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								TileView* _tmp25_ = NULL;
								_tmp22_ = self->priv->_foreground_cur;
								_tmp22__length1 = self->priv->_foreground_cur_length1;
								_tmp22__length2 = self->priv->_foreground_cur_length2;
								_tmp23_ = i;
								_tmp24_ = j;
								_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
								rounded_rectangle_idle_resize ((RoundedRectangle*) _tmp25_);
							}
						}
					}
				}
			}
		}
	}
	self->priv->_resize_view_id = (guint) 0;
	result = FALSE;
	return result;
}


static void _game_create_random_tile (Game* self) {
	Tile tile = {0};
	Grid* _tmp0_ = NULL;
	Tile _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp2_ = grid_new_tile (_tmp0_, &_tmp1_);
	tile = _tmp1_;
	if (_tmp2_) {
		Tile _tmp3_ = {0};
		GeeLinkedList* _tmp4_ = NULL;
		Tile _tmp5_ = {0};
		Tile _tmp6_ = {0};
		GridPosition _tmp7_ = {0};
		ClutterTransitionGroup* _tmp8_ = NULL;
		_game_create_show_hide_transition (self, TRUE);
		_tmp3_ = tile;
		_game_create_tile (self, &_tmp3_);
		_tmp4_ = self->priv->_to_show;
		_tmp5_ = tile;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
		_tmp6_ = tile;
		_tmp7_ = _tmp6_.pos;
		_game_show_tile (self, &_tmp7_);
		_tmp8_ = self->priv->_show_hide_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp8_);
	}
}


static void _game_create_tile (Game* self, Tile* tile) {
	GridPosition pos = {0};
	RoundedRectangle* rect = NULL;
	TileView* view = NULL;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	Tile _tmp0_ = {0};
	GridPosition _tmp1_ = {0};
	RoundedRectangle** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	GridPosition _tmp3_ = {0};
	guint _tmp4_ = 0U;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	RoundedRectangle* _tmp7_ = NULL;
	RoundedRectangle* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterActor* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	gfloat _tmp23_ = 0.0F;
	gfloat _tmp24_ = 0.0F;
	TileView** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp25__length2 = 0;
	GridPosition _tmp26_ = {0};
	guint _tmp27_ = 0U;
	GridPosition _tmp28_ = {0};
	guint _tmp29_ = 0U;
	TileView* _tmp30_ = NULL;
	Tile _tmp31_ = {0};
	guint _tmp32_ = 0U;
	TileView* _tmp33_ = NULL;
	TileView** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gint _tmp34__length2 = 0;
	GridPosition _tmp35_ = {0};
	guint _tmp36_ = 0U;
	GridPosition _tmp37_ = {0};
	guint _tmp38_ = 0U;
	TileView* _tmp39_ = NULL;
	TileView* _tmp40_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = *tile;
	_tmp1_ = _tmp0_.pos;
	pos = _tmp1_;
	_tmp2_ = self->priv->_background;
	_tmp2__length1 = self->priv->_background_length1;
	_tmp2__length2 = self->priv->_background_length2;
	_tmp3_ = pos;
	_tmp4_ = _tmp3_.row;
	_tmp5_ = pos;
	_tmp6_ = _tmp5_.col;
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (rect);
	rect = _tmp8_;
	_tmp9_ = rounded_rectangle_get_actor (rect);
	_tmp10_ = _tmp9_;
	_tmp11_ = clutter_actor_get_x (_tmp10_);
	_tmp12_ = _tmp11_;
	x = _tmp12_;
	_tmp13_ = rounded_rectangle_get_actor (rect);
	_tmp14_ = _tmp13_;
	_tmp15_ = clutter_actor_get_y (_tmp14_);
	_tmp16_ = _tmp15_;
	y = _tmp16_;
	_tmp17_ = rounded_rectangle_get_actor (rect);
	_tmp18_ = _tmp17_;
	_tmp19_ = clutter_actor_get_width (_tmp18_);
	_tmp20_ = _tmp19_;
	width = _tmp20_;
	_tmp21_ = rounded_rectangle_get_actor (rect);
	_tmp22_ = _tmp21_;
	_tmp23_ = clutter_actor_get_height (_tmp22_);
	_tmp24_ = _tmp23_;
	height = _tmp24_;
	_tmp25_ = self->priv->_foreground_nxt;
	_tmp25__length1 = self->priv->_foreground_nxt_length1;
	_tmp25__length2 = self->priv->_foreground_nxt_length2;
	_tmp26_ = pos;
	_tmp27_ = _tmp26_.row;
	_tmp28_ = pos;
	_tmp29_ = _tmp28_.col;
	_tmp30_ = _tmp25_[(_tmp27_ * _tmp25__length2) + _tmp29_];
	_vala_assert (_tmp30_ == NULL, "_foreground_nxt[pos.row,pos.col] == null");
	_tmp31_ = *tile;
	_tmp32_ = _tmp31_.val;
	_tmp33_ = tile_view_new (x, y, width, height, _tmp32_);
	_g_object_unref0 (view);
	view = _tmp33_;
	_tmp34_ = self->priv->_foreground_nxt;
	_tmp34__length1 = self->priv->_foreground_nxt_length1;
	_tmp34__length2 = self->priv->_foreground_nxt_length2;
	_tmp35_ = pos;
	_tmp36_ = _tmp35_.row;
	_tmp37_ = pos;
	_tmp38_ = _tmp37_.col;
	_tmp39_ = _g_object_ref0 (view);
	_g_object_unref0 (_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_]);
	_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_] = _tmp39_;
	_tmp40_ = _tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_];
	_g_object_unref0 (view);
	_g_object_unref0 (rect);
}


static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
	_game_on_move_trans_stopped ((Game*) self, is_finished);
}


static void _game_move_down (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("game.vala:391: move down");
	_game_store_movement (self);
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_move_trans);
	self->priv->_move_trans = _tmp0_;
	_tmp1_ = self->priv->_move_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
	_tmp2_ = self->priv->_move_trans;
	_tmp3_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
	_tmp4_ = self->priv->_grid;
	_tmp5_ = self->priv->_to_move;
	_tmp6_ = self->priv->_to_hide;
	_tmp7_ = self->priv->_to_show;
	grid_move_down (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
		_tmp8_ = self->priv->_to_move;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
			_tmp13_ = _e_index;
			_e_index = _tmp13_ + 1;
			_tmp14_ = _e_index;
			_tmp15_ = _e_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _e_list;
			_tmp17_ = _e_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			e = (TileMovement*) _tmp18_;
			_tmp19_ = e;
			_tmp20_ = (*_tmp19_).from;
			_tmp21_ = e;
			_tmp22_ = (*_tmp21_).to;
			_game_move_tile (self, &_tmp20_, &_tmp22_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
		_tmp23_ = self->priv->_to_hide;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_e_list = _tmp24_;
		_tmp25_ = _e_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_e_size = _tmp27_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
			_tmp28_ = _e_index;
			_e_index = _tmp28_ + 1;
			_tmp29_ = _e_index;
			_tmp30_ = _e_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _e_list;
			_tmp32_ = _e_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			e = (TileMovement*) _tmp33_;
			_tmp34_ = e;
			_tmp35_ = (*_tmp34_).from;
			_tmp36_ = e;
			_tmp37_ = (*_tmp36_).to;
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp40_ = self->priv->_to_move;
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 0) {
		_tmp39_ = TRUE;
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp43_ = self->priv->_to_hide;
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_ > 0;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		_tmp46_ = self->priv->_to_show;
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp38_ = _tmp48_ > 0;
	}
	has_moved = _tmp38_;
	_tmp49_ = has_moved;
	if (_tmp49_) {
		ClutterTransitionGroup* _tmp50_ = NULL;
		self->priv->_state = GAME_GAME_STATE_MOVING_DOWN;
		_tmp50_ = self->priv->_move_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
	}
}


static void _game_move_up (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("game.vala:419: move up");
	_game_store_movement (self);
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_move_trans);
	self->priv->_move_trans = _tmp0_;
	_tmp1_ = self->priv->_move_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
	_tmp2_ = self->priv->_move_trans;
	_tmp3_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
	_tmp4_ = self->priv->_grid;
	_tmp5_ = self->priv->_to_move;
	_tmp6_ = self->priv->_to_hide;
	_tmp7_ = self->priv->_to_show;
	grid_move_up (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
		_tmp8_ = self->priv->_to_move;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
			_tmp13_ = _e_index;
			_e_index = _tmp13_ + 1;
			_tmp14_ = _e_index;
			_tmp15_ = _e_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _e_list;
			_tmp17_ = _e_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			e = (TileMovement*) _tmp18_;
			_tmp19_ = e;
			_tmp20_ = (*_tmp19_).from;
			_tmp21_ = e;
			_tmp22_ = (*_tmp21_).to;
			_game_move_tile (self, &_tmp20_, &_tmp22_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
		_tmp23_ = self->priv->_to_hide;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_e_list = _tmp24_;
		_tmp25_ = _e_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_e_size = _tmp27_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
			_tmp28_ = _e_index;
			_e_index = _tmp28_ + 1;
			_tmp29_ = _e_index;
			_tmp30_ = _e_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _e_list;
			_tmp32_ = _e_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			e = (TileMovement*) _tmp33_;
			_tmp34_ = e;
			_tmp35_ = (*_tmp34_).from;
			_tmp36_ = e;
			_tmp37_ = (*_tmp36_).to;
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp40_ = self->priv->_to_move;
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 0) {
		_tmp39_ = TRUE;
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp43_ = self->priv->_to_hide;
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_ > 0;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		_tmp46_ = self->priv->_to_show;
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp38_ = _tmp48_ > 0;
	}
	has_moved = _tmp38_;
	_tmp49_ = has_moved;
	if (_tmp49_) {
		ClutterTransitionGroup* _tmp50_ = NULL;
		self->priv->_state = GAME_GAME_STATE_MOVING_UP;
		_tmp50_ = self->priv->_move_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
	}
}


static void _game_move_left (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("game.vala:447: move left");
	_game_store_movement (self);
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_move_trans);
	self->priv->_move_trans = _tmp0_;
	_tmp1_ = self->priv->_move_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
	_tmp2_ = self->priv->_move_trans;
	_tmp3_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
	_tmp4_ = self->priv->_grid;
	_tmp5_ = self->priv->_to_move;
	_tmp6_ = self->priv->_to_hide;
	_tmp7_ = self->priv->_to_show;
	grid_move_left (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
		_tmp8_ = self->priv->_to_move;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
			_tmp13_ = _e_index;
			_e_index = _tmp13_ + 1;
			_tmp14_ = _e_index;
			_tmp15_ = _e_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _e_list;
			_tmp17_ = _e_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			e = (TileMovement*) _tmp18_;
			_tmp19_ = e;
			_tmp20_ = (*_tmp19_).from;
			_tmp21_ = e;
			_tmp22_ = (*_tmp21_).to;
			_game_move_tile (self, &_tmp20_, &_tmp22_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
		_tmp23_ = self->priv->_to_hide;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_e_list = _tmp24_;
		_tmp25_ = _e_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_e_size = _tmp27_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
			_tmp28_ = _e_index;
			_e_index = _tmp28_ + 1;
			_tmp29_ = _e_index;
			_tmp30_ = _e_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _e_list;
			_tmp32_ = _e_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			e = (TileMovement*) _tmp33_;
			_tmp34_ = e;
			_tmp35_ = (*_tmp34_).from;
			_tmp36_ = e;
			_tmp37_ = (*_tmp36_).to;
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp40_ = self->priv->_to_move;
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 0) {
		_tmp39_ = TRUE;
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp43_ = self->priv->_to_hide;
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_ > 0;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		_tmp46_ = self->priv->_to_show;
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp38_ = _tmp48_ > 0;
	}
	has_moved = _tmp38_;
	_tmp49_ = has_moved;
	if (_tmp49_) {
		ClutterTransitionGroup* _tmp50_ = NULL;
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
		_tmp50_ = self->priv->_move_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
	}
}


static void _game_move_right (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("game.vala:475: move right");
	_game_store_movement (self);
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_move_trans);
	self->priv->_move_trans = _tmp0_;
	_tmp1_ = self->priv->_move_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
	_tmp2_ = self->priv->_move_trans;
	_tmp3_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
	_tmp4_ = self->priv->_grid;
	_tmp5_ = self->priv->_to_move;
	_tmp6_ = self->priv->_to_hide;
	_tmp7_ = self->priv->_to_show;
	grid_move_right (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
		_tmp8_ = self->priv->_to_move;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_e_list = _tmp9_;
		_tmp10_ = _e_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_e_size = _tmp12_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
			_tmp13_ = _e_index;
			_e_index = _tmp13_ + 1;
			_tmp14_ = _e_index;
			_tmp15_ = _e_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _e_list;
			_tmp17_ = _e_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			e = (TileMovement*) _tmp18_;
			_tmp19_ = e;
			_tmp20_ = (*_tmp19_).from;
			_tmp21_ = e;
			_tmp22_ = (*_tmp21_).to;
			_game_move_tile (self, &_tmp20_, &_tmp22_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
		_tmp23_ = self->priv->_to_hide;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_e_list = _tmp24_;
		_tmp25_ = _e_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_e_size = _tmp27_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
			_tmp28_ = _e_index;
			_e_index = _tmp28_ + 1;
			_tmp29_ = _e_index;
			_tmp30_ = _e_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _e_list;
			_tmp32_ = _e_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			e = (TileMovement*) _tmp33_;
			_tmp34_ = e;
			_tmp35_ = (*_tmp34_).from;
			_tmp36_ = e;
			_tmp37_ = (*_tmp36_).to;
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp40_ = self->priv->_to_move;
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ > 0) {
		_tmp39_ = TRUE;
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp43_ = self->priv->_to_hide;
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_ > 0;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		_tmp46_ = self->priv->_to_show;
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp38_ = _tmp48_ > 0;
	}
	has_moved = _tmp38_;
	_tmp49_ = has_moved;
	if (_tmp49_) {
		ClutterTransitionGroup* _tmp50_ = NULL;
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
		_tmp50_ = self->priv->_move_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
	}
}


static void _game_show_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView* view = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	TileView* _tmp10_ = NULL;
	ClutterCanvas* _tmp11_ = NULL;
	ClutterCanvas* _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterPropertyTransition* _tmp20_ = NULL;
	ClutterPropertyTransition* _tmp21_ = NULL;
	GValue _tmp22_ = {0};
	ClutterPropertyTransition* _tmp23_ = NULL;
	GValue _tmp24_ = {0};
	ClutterPropertyTransition* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ClutterPropertyTransition* _tmp27_ = NULL;
	ClutterActor* _tmp28_ = NULL;
	ClutterActor* _tmp29_ = NULL;
	ClutterTransitionGroup* _tmp30_ = NULL;
	ClutterPropertyTransition* _tmp31_ = NULL;
	ClutterPropertyTransition* _tmp32_ = NULL;
	ClutterPropertyTransition* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	ClutterPropertyTransition* _tmp35_ = NULL;
	GValue _tmp36_ = {0};
	ClutterPropertyTransition* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ClutterPropertyTransition* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterTransitionGroup* _tmp42_ = NULL;
	ClutterPropertyTransition* _tmp43_ = NULL;
	ClutterPropertyTransition* _tmp44_ = NULL;
	ClutterPropertyTransition* _tmp45_ = NULL;
	GValue _tmp46_ = {0};
	ClutterPropertyTransition* _tmp47_ = NULL;
	GValue _tmp48_ = {0};
	ClutterPropertyTransition* _tmp49_ = NULL;
	ClutterPropertyTransition* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	ClutterActor* _tmp52_ = NULL;
	ClutterActor* _tmp53_ = NULL;
	ClutterPropertyTransition* _tmp54_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = grid_position_to_string (pos);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("show tile pos ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("game.vala:503: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->_foreground_nxt;
	_tmp4__length1 = self->priv->_foreground_nxt_length1;
	_tmp4__length2 = self->priv->_foreground_nxt_length2;
	_tmp5_ = *pos;
	_tmp6_ = _tmp5_.row;
	_tmp7_ = *pos;
	_tmp8_ = _tmp7_.col;
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (view);
	view = _tmp10_;
	_tmp11_ = rounded_rectangle_get_canvas ((RoundedRectangle*) view);
	_tmp12_ = _tmp11_;
	clutter_content_invalidate ((ClutterContent*) _tmp12_);
	_tmp13_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
	_tmp14_ = _tmp13_;
	clutter_actor_set_opacity (_tmp14_, (guint8) 0);
	_tmp15_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
	_tmp16_ = _tmp15_;
	clutter_actor_show (_tmp16_);
	_tmp17_ = self->priv->_view_foreground;
	_tmp18_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
	_tmp19_ = _tmp18_;
	clutter_actor_add_child (_tmp17_, _tmp19_);
	_tmp20_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
	_g_object_unref0 (trans);
	trans = _tmp20_;
	_tmp21_ = trans;
	g_value_init (&_tmp22_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp22_, 1.0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp21_, &_tmp22_);
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
	_tmp23_ = trans;
	g_value_init (&_tmp24_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp24_, 1.1);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp23_, &_tmp24_);
	G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
	_tmp25_ = trans;
	_tmp26_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp25_, (guint) _tmp26_);
	_tmp27_ = trans;
	_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
	_tmp29_ = _tmp28_;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp27_, (ClutterAnimatable*) _tmp29_);
	_tmp30_ = self->priv->_show_hide_trans;
	_tmp31_ = trans;
	clutter_transition_group_add_transition (_tmp30_, (ClutterTransition*) _tmp31_);
	_tmp32_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
	_g_object_unref0 (trans);
	trans = _tmp32_;
	_tmp33_ = trans;
	g_value_init (&_tmp34_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp34_, 1.0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp33_, &_tmp34_);
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
	_tmp35_ = trans;
	g_value_init (&_tmp36_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp36_, 1.1);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp35_, &_tmp36_);
	G_IS_VALUE (&_tmp36_) ? (g_value_unset (&_tmp36_), NULL) : NULL;
	_tmp37_ = trans;
	_tmp38_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp37_, (guint) _tmp38_);
	_tmp39_ = trans;
	_tmp40_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
	_tmp41_ = _tmp40_;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp39_, (ClutterAnimatable*) _tmp41_);
	_tmp42_ = self->priv->_show_hide_trans;
	_tmp43_ = trans;
	clutter_transition_group_add_transition (_tmp42_, (ClutterTransition*) _tmp43_);
	_tmp44_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	_g_object_unref0 (trans);
	trans = _tmp44_;
	_tmp45_ = trans;
	g_value_init (&_tmp46_, G_TYPE_INT);
	g_value_set_int (&_tmp46_, 0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp45_, &_tmp46_);
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
	_tmp47_ = trans;
	g_value_init (&_tmp48_, G_TYPE_INT);
	g_value_set_int (&_tmp48_, 255);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp47_, &_tmp48_);
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
	_tmp49_ = trans;
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp49_, TRUE);
	_tmp50_ = trans;
	_tmp51_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp50_, (guint) (_tmp51_ / 2));
	_tmp52_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
	_tmp53_ = _tmp52_;
	_tmp54_ = trans;
	clutter_actor_add_transition (_tmp53_, "show", (ClutterTransition*) _tmp54_);
	_g_object_unref0 (view);
	_g_object_unref0 (trans);
}


static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GridPosition _tmp6_ = {0};
	GridPosition _tmp7_ = {0};
	TileView** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	GridPosition _tmp9_ = {0};
	guint _tmp10_ = 0U;
	GridPosition _tmp11_ = {0};
	guint _tmp12_ = 0U;
	TileView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	TileView* _tmp18_ = NULL;
	TileView* _tmp19_ = NULL;
	TileView* _tmp20_ = NULL;
	TileView** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	GridPosition _tmp22_ = {0};
	guint _tmp23_ = 0U;
	GridPosition _tmp24_ = {0};
	guint _tmp25_ = 0U;
	TileView* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = grid_position_to_string (from);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (to);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("move tile from ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("game.vala:538: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = *from;
	_tmp7_ = *to;
	_game_prepare_move_tile (self, &_tmp6_, &_tmp7_);
	_tmp8_ = self->priv->_foreground_nxt;
	_tmp8__length1 = self->priv->_foreground_nxt_length1;
	_tmp8__length2 = self->priv->_foreground_nxt_length2;
	_tmp9_ = *to;
	_tmp10_ = _tmp9_.row;
	_tmp11_ = *to;
	_tmp12_ = _tmp11_.col;
	_tmp13_ = self->priv->_foreground_cur;
	_tmp13__length1 = self->priv->_foreground_cur_length1;
	_tmp13__length2 = self->priv->_foreground_cur_length2;
	_tmp14_ = *from;
	_tmp15_ = _tmp14_.row;
	_tmp16_ = *from;
	_tmp17_ = _tmp16_.col;
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_]);
	_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_] = _tmp19_;
	_tmp20_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
	_tmp21_ = self->priv->_foreground_cur;
	_tmp21__length1 = self->priv->_foreground_cur_length1;
	_tmp21__length2 = self->priv->_foreground_cur_length2;
	_tmp22_ = *from;
	_tmp23_ = _tmp22_.row;
	_tmp24_ = *from;
	_tmp25_ = _tmp24_.col;
	_g_object_unref0 (_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_]);
	_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_] = NULL;
	_tmp26_ = _tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_];
}


static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean row_move = FALSE;
	gchar* trans_name = NULL;
	ClutterPropertyTransition* trans = NULL;
	RoundedRectangle* rect_from = NULL;
	RoundedRectangle* rect_to = NULL;
	GridPosition _tmp6_ = {0};
	guint _tmp7_ = 0U;
	GridPosition _tmp8_ = {0};
	guint _tmp9_ = 0U;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_ = NULL;
	RoundedRectangle** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	RoundedRectangle* _tmp18_ = NULL;
	RoundedRectangle* _tmp19_ = NULL;
	RoundedRectangle** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp20__length2 = 0;
	GridPosition _tmp21_ = {0};
	guint _tmp22_ = 0U;
	GridPosition _tmp23_ = {0};
	guint _tmp24_ = 0U;
	RoundedRectangle* _tmp25_ = NULL;
	RoundedRectangle* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	ClutterPropertyTransition* _tmp28_ = NULL;
	gfloat _tmp29_ = 0.0F;
	gboolean _tmp30_ = FALSE;
	ClutterPropertyTransition* _tmp41_ = NULL;
	GValue _tmp42_ = {0};
	gfloat _tmp43_ = 0.0F;
	gboolean _tmp44_ = FALSE;
	ClutterPropertyTransition* _tmp55_ = NULL;
	GValue _tmp56_ = {0};
	ClutterPropertyTransition* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	ClutterPropertyTransition* _tmp59_ = NULL;
	TileView** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	gint _tmp60__length2 = 0;
	GridPosition _tmp61_ = {0};
	guint _tmp62_ = 0U;
	GridPosition _tmp63_ = {0};
	guint _tmp64_ = 0U;
	TileView* _tmp65_ = NULL;
	ClutterActor* _tmp66_ = NULL;
	ClutterActor* _tmp67_ = NULL;
	ClutterTransitionGroup* _tmp68_ = NULL;
	ClutterPropertyTransition* _tmp69_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = grid_position_to_string (from);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (to);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("prepare move tile from ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("game.vala:548: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = *from;
	_tmp7_ = _tmp6_.col;
	_tmp8_ = *to;
	_tmp9_ = _tmp8_.col;
	row_move = _tmp7_ == _tmp9_;
	_tmp11_ = row_move;
	if (_tmp11_) {
		_tmp10_ = "y";
	} else {
		_tmp10_ = "x";
	}
	_tmp12_ = g_strdup (_tmp10_);
	_g_free0 (trans_name);
	trans_name = _tmp12_;
	_tmp13_ = self->priv->_background;
	_tmp13__length1 = self->priv->_background_length1;
	_tmp13__length2 = self->priv->_background_length2;
	_tmp14_ = *from;
	_tmp15_ = _tmp14_.row;
	_tmp16_ = *from;
	_tmp17_ = _tmp16_.col;
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (rect_from);
	rect_from = _tmp19_;
	_tmp20_ = self->priv->_background;
	_tmp20__length1 = self->priv->_background_length1;
	_tmp20__length2 = self->priv->_background_length2;
	_tmp21_ = *to;
	_tmp22_ = _tmp21_.row;
	_tmp23_ = *to;
	_tmp24_ = _tmp23_.col;
	_tmp25_ = _tmp20_[(_tmp22_ * _tmp20__length2) + _tmp24_];
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (rect_to);
	rect_to = _tmp26_;
	_tmp27_ = trans_name;
	_tmp28_ = (ClutterPropertyTransition*) clutter_property_transition_new (_tmp27_);
	_g_object_unref0 (trans);
	trans = _tmp28_;
	_tmp30_ = row_move;
	if (_tmp30_) {
		RoundedRectangle* _tmp31_ = NULL;
		ClutterActor* _tmp32_ = NULL;
		ClutterActor* _tmp33_ = NULL;
		gfloat _tmp34_ = 0.0F;
		gfloat _tmp35_ = 0.0F;
		_tmp31_ = rect_from;
		_tmp32_ = rounded_rectangle_get_actor (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = clutter_actor_get_y (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp29_ = _tmp35_;
	} else {
		RoundedRectangle* _tmp36_ = NULL;
		ClutterActor* _tmp37_ = NULL;
		ClutterActor* _tmp38_ = NULL;
		gfloat _tmp39_ = 0.0F;
		gfloat _tmp40_ = 0.0F;
		_tmp36_ = rect_from;
		_tmp37_ = rounded_rectangle_get_actor (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = clutter_actor_get_x (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp29_ = _tmp40_;
	}
	_tmp41_ = trans;
	g_value_init (&_tmp42_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp42_, _tmp29_);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp41_, &_tmp42_);
	G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
	_tmp44_ = row_move;
	if (_tmp44_) {
		RoundedRectangle* _tmp45_ = NULL;
		ClutterActor* _tmp46_ = NULL;
		ClutterActor* _tmp47_ = NULL;
		gfloat _tmp48_ = 0.0F;
		gfloat _tmp49_ = 0.0F;
		_tmp45_ = rect_to;
		_tmp46_ = rounded_rectangle_get_actor (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = clutter_actor_get_y (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp43_ = _tmp49_;
	} else {
		RoundedRectangle* _tmp50_ = NULL;
		ClutterActor* _tmp51_ = NULL;
		ClutterActor* _tmp52_ = NULL;
		gfloat _tmp53_ = 0.0F;
		gfloat _tmp54_ = 0.0F;
		_tmp50_ = rect_to;
		_tmp51_ = rounded_rectangle_get_actor (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = clutter_actor_get_x (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp43_ = _tmp54_;
	}
	_tmp55_ = trans;
	g_value_init (&_tmp56_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp56_, _tmp43_);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp55_, &_tmp56_);
	G_IS_VALUE (&_tmp56_) ? (g_value_unset (&_tmp56_), NULL) : NULL;
	_tmp57_ = trans;
	_tmp58_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp57_, (guint) _tmp58_);
	_tmp59_ = trans;
	_tmp60_ = self->priv->_foreground_cur;
	_tmp60__length1 = self->priv->_foreground_cur_length1;
	_tmp60__length2 = self->priv->_foreground_cur_length2;
	_tmp61_ = *from;
	_tmp62_ = _tmp61_.row;
	_tmp63_ = *from;
	_tmp64_ = _tmp63_.col;
	_tmp65_ = _tmp60_[(_tmp62_ * _tmp60__length2) + _tmp64_];
	_tmp66_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp65_);
	_tmp67_ = _tmp66_;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp59_, (ClutterAnimatable*) _tmp67_);
	_tmp68_ = self->priv->_move_trans;
	_tmp69_ = trans;
	clutter_transition_group_add_transition (_tmp68_, (ClutterTransition*) _tmp69_);
	_g_object_unref0 (rect_to);
	_g_object_unref0 (rect_from);
	_g_object_unref0 (trans);
	_g_free0 (trans_name);
}


static void _game_dim_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	ClutterActor* actor = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	GridPosition _tmp17_ = {0};
	guint _tmp18_ = 0U;
	GridPosition _tmp19_ = {0};
	guint _tmp20_ = 0U;
	TileView* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	ClutterActor* _tmp23_ = NULL;
	ClutterActor* _tmp24_ = NULL;
	ClutterPropertyTransition* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	GValue _tmp28_ = {0};
	GValue _tmp29_ = {0};
	gint _tmp30_ = 0;
	ClutterTransitionGroup* _tmp31_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = grid_position_to_string (pos);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("diming tile at ", _tmp1_, " ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_foreground_cur;
	_tmp4__length1 = self->priv->_foreground_cur_length1;
	_tmp4__length2 = self->priv->_foreground_cur_length2;
	_tmp5_ = *pos;
	_tmp6_ = _tmp5_.row;
	_tmp7_ = *pos;
	_tmp8_ = _tmp7_.col;
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
	_tmp10_ = tile_view_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%u", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp3_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	g_debug ("game.vala:572: %s", _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp16_ = self->priv->_foreground_cur;
	_tmp16__length1 = self->priv->_foreground_cur_length1;
	_tmp16__length2 = self->priv->_foreground_cur_length2;
	_tmp17_ = *pos;
	_tmp18_ = _tmp17_.row;
	_tmp19_ = *pos;
	_tmp20_ = _tmp19_.col;
	_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
	_tmp22_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (actor);
	actor = _tmp24_;
	_tmp25_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	_g_object_unref0 (trans);
	trans = _tmp25_;
	_tmp26_ = clutter_actor_get_opacity (actor);
	_tmp27_ = _tmp26_;
	g_value_init (&_tmp28_, G_TYPE_UINT);
	g_value_set_uint (&_tmp28_, _tmp27_);
	clutter_transition_set_from_value ((ClutterTransition*) trans, &_tmp28_);
	G_IS_VALUE (&_tmp28_) ? (g_value_unset (&_tmp28_), NULL) : NULL;
	g_value_init (&_tmp29_, G_TYPE_INT);
	g_value_set_int (&_tmp29_, 0);
	clutter_transition_set_to_value ((ClutterTransition*) trans, &_tmp29_);
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
	_tmp30_ = self->priv->_animations_duration;
	clutter_timeline_set_duration ((ClutterTimeline*) trans, (guint) _tmp30_);
	clutter_transition_set_animatable ((ClutterTransition*) trans, (ClutterAnimatable*) actor);
	_tmp31_ = self->priv->_show_hide_trans;
	clutter_transition_group_add_transition (_tmp31_, (ClutterTransition*) trans);
	_g_object_unref0 (trans);
	_g_object_unref0 (actor);
}


static void _game_clear_background (Game* self) {
	ClutterActor* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_view_background;
	clutter_actor_remove_all_children (_tmp0_);
}


static void _game_clear_foreground (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ClutterActor* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_tmp6_ = self->priv->_view_foreground;
	clutter_actor_remove_all_children (_tmp6_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = rows;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							TileView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							TileView* _tmp18_ = NULL;
							TileView** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							TileView* _tmp26_ = NULL;
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								_tmp12_ = j;
								j = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp13_ = j;
							_tmp14_ = cols;
							if (!(_tmp13_ < _tmp14_)) {
								break;
							}
							_tmp15_ = self->priv->_foreground_cur;
							_tmp15__length1 = self->priv->_foreground_cur_length1;
							_tmp15__length2 = self->priv->_foreground_cur_length2;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
							if (_tmp18_ != NULL) {
								TileView** _tmp19_ = NULL;
								gint _tmp19__length1 = 0;
								gint _tmp19__length2 = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								TileView* _tmp22_ = NULL;
								_tmp19_ = self->priv->_foreground_cur;
								_tmp19__length1 = self->priv->_foreground_cur_length1;
								_tmp19__length2 = self->priv->_foreground_cur_length2;
								_tmp20_ = i;
								_tmp21_ = j;
								_g_object_unref0 (_tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_]);
								_tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_] = NULL;
								_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
							}
							_tmp23_ = self->priv->_foreground_nxt;
							_tmp23__length1 = self->priv->_foreground_nxt_length1;
							_tmp23__length2 = self->priv->_foreground_nxt_length2;
							_tmp24_ = i;
							_tmp25_ = j;
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
							if (_tmp26_ != NULL) {
								TileView** _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
								gint _tmp27__length2 = 0;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								TileView* _tmp30_ = NULL;
								_tmp27_ = self->priv->_foreground_nxt;
								_tmp27__length1 = self->priv->_foreground_nxt_length1;
								_tmp27__length2 = self->priv->_foreground_nxt_length2;
								_tmp28_ = i;
								_tmp29_ = j;
								_g_object_unref0 (_tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_]);
								_tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_] = NULL;
								_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
							}
						}
					}
				}
			}
		}
	}
}


static void _game_restore_foreground (Game* self, gboolean animate) {
	guint val = 0U;
	GridPosition pos = {0};
	Tile tile = {0};
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GeeLinkedList* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_tmp6_ = animate;
	_game_create_show_hide_transition (self, _tmp6_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = rows;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Grid* _tmp15_ = NULL;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							guint _tmp18_ = 0U;
							guint _tmp19_ = 0U;
							if (!_tmp11_) {
								gint _tmp12_ = 0;
								_tmp12_ = j;
								j = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp13_ = j;
							_tmp14_ = cols;
							if (!(_tmp13_ < _tmp14_)) {
								break;
							}
							_tmp15_ = self->priv->_grid;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = grid_get (_tmp15_, _tmp16_, _tmp17_);
							val = _tmp18_;
							_tmp19_ = val;
							if (_tmp19_ != ((guint) 0)) {
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								GridPosition _tmp22_ = {0};
								GridPosition _tmp23_ = {0};
								guint _tmp24_ = 0U;
								Tile _tmp25_ = {0};
								Tile _tmp26_ = {0};
								GeeLinkedList* _tmp27_ = NULL;
								Tile _tmp28_ = {0};
								GridPosition _tmp29_ = {0};
								_tmp20_ = i;
								_tmp21_ = j;
								_tmp22_.row = (guint) _tmp20_;
								_tmp22_.col = (guint) _tmp21_;
								pos = _tmp22_;
								_tmp23_ = pos;
								_tmp24_ = val;
								_tmp25_.pos = _tmp23_;
								_tmp25_.val = _tmp24_;
								tile = _tmp25_;
								_tmp26_ = tile;
								_game_create_tile (self, &_tmp26_);
								_tmp27_ = self->priv->_to_show;
								_tmp28_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, &_tmp28_);
								_tmp29_ = pos;
								_game_show_tile (self, &_tmp29_);
							}
						}
					}
				}
			}
		}
	}
	_tmp30_ = self->priv->_to_show;
	_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 0) {
		ClutterTransitionGroup* _tmp33_ = NULL;
		self->priv->_state = GAME_GAME_STATE_RESTORING_TILES;
		_tmp33_ = self->priv->_show_hide_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp33_);
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void _game_on_move_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Grid* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint delta_score = 0U;
	ClutterTransitionGroup* _tmp8_ = NULL;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	guint _tmp42_ = 0U;
	ClutterTransitionGroup* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_finished;
	_tmp1_ = bool_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("move animation stopped; finished ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_debug ("game.vala:639: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = self->priv->_grid;
	_tmp6_ = grid_to_string (_tmp5_);
	_tmp7_ = _tmp6_;
	g_debug ("game.vala:640: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->_move_trans;
	clutter_transition_group_remove_all (_tmp8_);
	_game_create_show_hide_transition (self, TRUE);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _e_index = 0;
		_tmp9_ = self->priv->_to_hide;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_e_list = _tmp10_;
		_tmp11_ = _e_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_e_size = _tmp13_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			TileMovement* _tmp20_ = NULL;
			GridPosition _tmp21_ = {0};
			_tmp14_ = _e_index;
			_e_index = _tmp14_ + 1;
			_tmp15_ = _e_index;
			_tmp16_ = _e_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _e_list;
			_tmp18_ = _e_index;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
			e = (TileMovement*) _tmp19_;
			_tmp20_ = e;
			_tmp21_ = (*_tmp20_).from;
			_game_dim_tile (self, &_tmp21_);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	delta_score = (guint) 0;
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _e_index = 0;
		_tmp22_ = self->priv->_to_show;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_e_list = _tmp23_;
		_tmp24_ = _e_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_e_size = _tmp26_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			Tile* _tmp33_ = NULL;
			Tile _tmp34_ = {0};
			Tile* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			Tile* _tmp38_ = NULL;
			guint _tmp39_ = 0U;
			_tmp27_ = _e_index;
			_e_index = _tmp27_ + 1;
			_tmp28_ = _e_index;
			_tmp29_ = _e_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _e_list;
			_tmp31_ = _e_index;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
			e = (Tile*) _tmp32_;
			_tmp33_ = e;
			_tmp34_ = *_tmp33_;
			_game_create_tile (self, &_tmp34_);
			_tmp35_ = e;
			_tmp36_ = (*_tmp35_).pos;
			_game_show_tile (self, &_tmp36_);
			_tmp37_ = delta_score;
			_tmp38_ = e;
			_tmp39_ = (*_tmp38_).val;
			delta_score = _tmp37_ + _tmp39_;
			_tile_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp40_ = self->priv->_score;
	_tmp41_ = delta_score;
	game_set_score (self, _tmp40_ + _tmp41_);
	_tmp42_ = delta_score;
	_game_store_score_update (self, _tmp42_);
	_game_create_random_tile (self);
	_tmp43_ = self->priv->_show_hide_trans;
	clutter_timeline_start ((ClutterTimeline*) _tmp43_);
}


static gboolean __game_finish_move_gsource_func (gpointer self) {
	gboolean result;
	result = _game_finish_move ((Game*) self);
	return result;
}


static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	ClutterTransitionGroup* _tmp5_ = NULL;
	ClutterTimelineDirection _tmp6_ = 0;
	ClutterTimelineDirection _tmp7_ = 0;
	Grid* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	ClutterTransitionGroup* _tmp13_ = NULL;
	guint _tmp63_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_finished;
	_tmp1_ = bool_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("show/hide animation stopped; finished ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_debug ("game.vala:668: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = self->priv->_show_hide_trans;
	_tmp6_ = clutter_timeline_get_direction ((ClutterTimeline*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == CLUTTER_TIMELINE_FORWARD) {
		ClutterTransitionGroup* _tmp8_ = NULL;
		ClutterTransitionGroup* _tmp9_ = NULL;
		_tmp8_ = self->priv->_show_hide_trans;
		clutter_timeline_set_direction ((ClutterTimeline*) _tmp8_, CLUTTER_TIMELINE_BACKWARD);
		_tmp9_ = self->priv->_show_hide_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp9_);
		return;
	}
	_tmp10_ = self->priv->_grid;
	_tmp11_ = grid_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	g_debug ("game.vala:676: %s", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->_show_hide_trans;
	clutter_transition_group_remove_all (_tmp13_);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		GeeLinkedList* _tmp15_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _e_index = 0;
		_tmp14_ = self->priv->_to_hide;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_e_list = _tmp15_;
		_tmp16_ = _e_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_e_size = _tmp18_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			TileView* view = NULL;
			TileView** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			TileMovement* _tmp26_ = NULL;
			GridPosition _tmp27_ = {0};
			guint _tmp28_ = 0U;
			TileMovement* _tmp29_ = NULL;
			GridPosition _tmp30_ = {0};
			guint _tmp31_ = 0U;
			TileView* _tmp32_ = NULL;
			TileView* _tmp33_ = NULL;
			TileView* _tmp34_ = NULL;
			ClutterActor* _tmp35_ = NULL;
			ClutterActor* _tmp36_ = NULL;
			TileView** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp37__length2 = 0;
			TileMovement* _tmp38_ = NULL;
			GridPosition _tmp39_ = {0};
			guint _tmp40_ = 0U;
			TileMovement* _tmp41_ = NULL;
			GridPosition _tmp42_ = {0};
			guint _tmp43_ = 0U;
			TileView* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
			guint _tmp46_ = 0U;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			ClutterActor* _tmp51_ = NULL;
			TileView* _tmp52_ = NULL;
			ClutterActor* _tmp53_ = NULL;
			ClutterActor* _tmp54_ = NULL;
			TileView** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gint _tmp55__length2 = 0;
			TileMovement* _tmp56_ = NULL;
			GridPosition _tmp57_ = {0};
			guint _tmp58_ = 0U;
			TileMovement* _tmp59_ = NULL;
			GridPosition _tmp60_ = {0};
			guint _tmp61_ = 0U;
			TileView* _tmp62_ = NULL;
			_tmp19_ = _e_index;
			_e_index = _tmp19_ + 1;
			_tmp20_ = _e_index;
			_tmp21_ = _e_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _e_list;
			_tmp23_ = _e_index;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
			e = (TileMovement*) _tmp24_;
			_tmp25_ = self->priv->_foreground_cur;
			_tmp25__length1 = self->priv->_foreground_cur_length1;
			_tmp25__length2 = self->priv->_foreground_cur_length2;
			_tmp26_ = e;
			_tmp27_ = (*_tmp26_).from;
			_tmp28_ = _tmp27_.row;
			_tmp29_ = e;
			_tmp30_ = (*_tmp29_).from;
			_tmp31_ = _tmp30_.col;
			_tmp32_ = _tmp25_[(_tmp28_ * _tmp25__length2) + _tmp31_];
			_tmp33_ = _g_object_ref0 (_tmp32_);
			view = _tmp33_;
			_tmp34_ = view;
			_tmp35_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp34_);
			_tmp36_ = _tmp35_;
			clutter_actor_hide (_tmp36_);
			_tmp37_ = self->priv->_foreground_cur;
			_tmp37__length1 = self->priv->_foreground_cur_length1;
			_tmp37__length2 = self->priv->_foreground_cur_length2;
			_tmp38_ = e;
			_tmp39_ = (*_tmp38_).from;
			_tmp40_ = _tmp39_.row;
			_tmp41_ = e;
			_tmp42_ = (*_tmp41_).from;
			_tmp43_ = _tmp42_.col;
			_tmp44_ = _tmp37_[(_tmp40_ * _tmp37__length2) + _tmp43_];
			_tmp45_ = tile_view_get_value (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf ("%u", _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat ("remove child ", _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			g_debug ("game.vala:683: %s", _tmp50_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
			_tmp51_ = self->priv->_view_foreground;
			_tmp52_ = view;
			_tmp53_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp52_);
			_tmp54_ = _tmp53_;
			clutter_actor_remove_child (_tmp51_, _tmp54_);
			_tmp55_ = self->priv->_foreground_cur;
			_tmp55__length1 = self->priv->_foreground_cur_length1;
			_tmp55__length2 = self->priv->_foreground_cur_length2;
			_tmp56_ = e;
			_tmp57_ = (*_tmp56_).from;
			_tmp58_ = _tmp57_.row;
			_tmp59_ = e;
			_tmp60_ = (*_tmp59_).from;
			_tmp61_ = _tmp60_.col;
			_g_object_unref0 (_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_]);
			_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_] = NULL;
			_tmp62_ = _tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_];
			_g_object_unref0 (view);
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp63_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __game_finish_move_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_finish_move_id = _tmp63_;
}


static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
	_game_on_show_hide_trans_stopped ((Game*) self, is_finished);
}


static void _game_create_show_hide_transition (Game* self, gboolean animate) {
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	ClutterTransitionGroup* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_show_hide_trans);
	self->priv->_show_hide_trans = _tmp0_;
	_tmp1_ = self->priv->_show_hide_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_show_hide_trans_stopped_clutter_timeline_stopped, self, 0);
	_tmp3_ = animate;
	if (_tmp3_) {
		gint _tmp4_ = 0;
		_tmp4_ = self->priv->_animations_duration;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = 10;
	}
	_tmp5_ = self->priv->_show_hide_trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp5_, (guint) _tmp2_);
}


static gboolean _game_finish_move (Game* self) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	GeeLinkedList* _tmp75_ = NULL;
	GeeLinkedList* _tmp76_ = NULL;
	GeeLinkedList* _tmp77_ = NULL;
	Grid* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	Grid* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
		self->priv->_state = GAME_GAME_STATE_SHOWING_SECOND_TILE;
		g_debug ("game.vala:703: state show second tile");
		_game_create_random_tile (self);
	} else {
		GameGameState _tmp1_ = 0;
		_tmp1_ = self->priv->_state;
		if (_tmp1_ == GAME_GAME_STATE_SHOWING_SECOND_TILE) {
			self->priv->_state = GAME_GAME_STATE_IDLE;
			g_debug ("game.vala:707: state idle");
		} else {
			GameGameState _tmp2_ = 0;
			_tmp2_ = self->priv->_state;
			if (_tmp2_ != GAME_GAME_STATE_IDLE) {
				self->priv->_state = GAME_GAME_STATE_IDLE;
				g_debug ("game.vala:710: state idle");
			}
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _e_index = 0;
		_tmp3_ = self->priv->_to_move;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_e_list = _tmp4_;
		_tmp5_ = _e_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_e_size = _tmp7_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			TileView** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			TileMovement* _tmp15_ = NULL;
			GridPosition _tmp16_ = {0};
			guint _tmp17_ = 0U;
			TileMovement* _tmp18_ = NULL;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			TileView** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			TileMovement* _tmp22_ = NULL;
			GridPosition _tmp23_ = {0};
			guint _tmp24_ = 0U;
			TileMovement* _tmp25_ = NULL;
			GridPosition _tmp26_ = {0};
			guint _tmp27_ = 0U;
			TileView* _tmp28_ = NULL;
			TileView* _tmp29_ = NULL;
			TileView* _tmp30_ = NULL;
			TileView** _tmp31_ = NULL;
			gint _tmp31__length1 = 0;
			gint _tmp31__length2 = 0;
			TileMovement* _tmp32_ = NULL;
			GridPosition _tmp33_ = {0};
			guint _tmp34_ = 0U;
			TileMovement* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			TileView* _tmp38_ = NULL;
			_tmp8_ = _e_index;
			_e_index = _tmp8_ + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = _e_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			e = (TileMovement*) _tmp13_;
			_tmp14_ = self->priv->_foreground_cur;
			_tmp14__length1 = self->priv->_foreground_cur_length1;
			_tmp14__length2 = self->priv->_foreground_cur_length2;
			_tmp15_ = e;
			_tmp16_ = (*_tmp15_).to;
			_tmp17_ = _tmp16_.row;
			_tmp18_ = e;
			_tmp19_ = (*_tmp18_).to;
			_tmp20_ = _tmp19_.col;
			_tmp21_ = self->priv->_foreground_nxt;
			_tmp21__length1 = self->priv->_foreground_nxt_length1;
			_tmp21__length2 = self->priv->_foreground_nxt_length2;
			_tmp22_ = e;
			_tmp23_ = (*_tmp22_).to;
			_tmp24_ = _tmp23_.row;
			_tmp25_ = e;
			_tmp26_ = (*_tmp25_).to;
			_tmp27_ = _tmp26_.col;
			_tmp28_ = _tmp21_[(_tmp24_ * _tmp21__length2) + _tmp27_];
			_tmp29_ = _g_object_ref0 (_tmp28_);
			_g_object_unref0 (_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_]);
			_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_] = _tmp29_;
			_tmp30_ = _tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_];
			_tmp31_ = self->priv->_foreground_nxt;
			_tmp31__length1 = self->priv->_foreground_nxt_length1;
			_tmp31__length2 = self->priv->_foreground_nxt_length2;
			_tmp32_ = e;
			_tmp33_ = (*_tmp32_).to;
			_tmp34_ = _tmp33_.row;
			_tmp35_ = e;
			_tmp36_ = (*_tmp35_).to;
			_tmp37_ = _tmp36_.col;
			_g_object_unref0 (_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_]);
			_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_] = NULL;
			_tmp38_ = _tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_];
			_tile_movement_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp39_ = NULL;
		GeeLinkedList* _tmp40_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		gint _e_index = 0;
		_tmp39_ = self->priv->_to_show;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_e_list = _tmp40_;
		_tmp41_ = _e_list;
		_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_e_size = _tmp43_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gpointer _tmp49_ = NULL;
			TileView** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gint _tmp50__length2 = 0;
			Tile* _tmp51_ = NULL;
			GridPosition _tmp52_ = {0};
			guint _tmp53_ = 0U;
			Tile* _tmp54_ = NULL;
			GridPosition _tmp55_ = {0};
			guint _tmp56_ = 0U;
			TileView** _tmp57_ = NULL;
			gint _tmp57__length1 = 0;
			gint _tmp57__length2 = 0;
			Tile* _tmp58_ = NULL;
			GridPosition _tmp59_ = {0};
			guint _tmp60_ = 0U;
			Tile* _tmp61_ = NULL;
			GridPosition _tmp62_ = {0};
			guint _tmp63_ = 0U;
			TileView* _tmp64_ = NULL;
			TileView* _tmp65_ = NULL;
			TileView* _tmp66_ = NULL;
			TileView** _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			Tile* _tmp68_ = NULL;
			GridPosition _tmp69_ = {0};
			guint _tmp70_ = 0U;
			Tile* _tmp71_ = NULL;
			GridPosition _tmp72_ = {0};
			guint _tmp73_ = 0U;
			TileView* _tmp74_ = NULL;
			_tmp44_ = _e_index;
			_e_index = _tmp44_ + 1;
			_tmp45_ = _e_index;
			_tmp46_ = _e_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _e_list;
			_tmp48_ = _e_index;
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
			e = (Tile*) _tmp49_;
			_tmp50_ = self->priv->_foreground_cur;
			_tmp50__length1 = self->priv->_foreground_cur_length1;
			_tmp50__length2 = self->priv->_foreground_cur_length2;
			_tmp51_ = e;
			_tmp52_ = (*_tmp51_).pos;
			_tmp53_ = _tmp52_.row;
			_tmp54_ = e;
			_tmp55_ = (*_tmp54_).pos;
			_tmp56_ = _tmp55_.col;
			_tmp57_ = self->priv->_foreground_nxt;
			_tmp57__length1 = self->priv->_foreground_nxt_length1;
			_tmp57__length2 = self->priv->_foreground_nxt_length2;
			_tmp58_ = e;
			_tmp59_ = (*_tmp58_).pos;
			_tmp60_ = _tmp59_.row;
			_tmp61_ = e;
			_tmp62_ = (*_tmp61_).pos;
			_tmp63_ = _tmp62_.col;
			_tmp64_ = _tmp57_[(_tmp60_ * _tmp57__length2) + _tmp63_];
			_tmp65_ = _g_object_ref0 (_tmp64_);
			_g_object_unref0 (_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_]);
			_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_] = _tmp65_;
			_tmp66_ = _tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_];
			_tmp67_ = self->priv->_foreground_nxt;
			_tmp67__length1 = self->priv->_foreground_nxt_length1;
			_tmp67__length2 = self->priv->_foreground_nxt_length2;
			_tmp68_ = e;
			_tmp69_ = (*_tmp68_).pos;
			_tmp70_ = _tmp69_.row;
			_tmp71_ = e;
			_tmp72_ = (*_tmp71_).pos;
			_tmp73_ = _tmp72_.col;
			_g_object_unref0 (_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_]);
			_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_] = NULL;
			_tmp74_ = _tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_];
			_tile_free0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	_tmp75_ = self->priv->_to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp75_);
	_tmp76_ = self->priv->_to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
	_tmp77_ = self->priv->_to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
	_tmp78_ = self->priv->_grid;
	_tmp79_ = grid_get_target_value_reached (_tmp78_);
	_tmp80_ = _tmp79_;
	if (_tmp80_) {
		Grid* _tmp81_ = NULL;
		guint _tmp82_ = 0U;
		guint _tmp83_ = 0U;
		Grid* _tmp84_ = NULL;
		_tmp81_ = self->priv->_grid;
		_tmp82_ = grid_get_target_value (_tmp81_);
		_tmp83_ = _tmp82_;
		g_signal_emit_by_name (self, "target-value-reached", _tmp83_);
		_tmp84_ = self->priv->_grid;
		grid_set_target_value_reached (_tmp84_, FALSE);
	}
	_tmp85_ = self->priv->_grid;
	_tmp86_ = grid_is_finished (_tmp85_);
	if (_tmp86_) {
		g_signal_emit_by_name (self, "finished");
	}
	self->priv->_finish_move_id = (guint) 0;
	result = FALSE;
	return result;
}


static void _game_store_movement (Game* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_allow_undo;
	if (_tmp0_) {
		GeeLinkedList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		guint _tmp4_ = 0U;
		GeeLinkedList* _tmp8_ = NULL;
		Grid* _tmp9_ = NULL;
		Grid* _tmp10_ = NULL;
		Grid* _tmp11_ = NULL;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp1_ = self->priv->_undo_stack;
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_undo_stack_max_size;
		if (((guint) _tmp3_) == _tmp4_) {
			GeeLinkedList* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			Grid* _tmp7_ = NULL;
			_tmp5_ = self->priv->_undo_stack;
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) _tmp5_);
			_tmp7_ = (Grid*) _tmp6_;
			_g_object_unref0 (_tmp7_);
		}
		_tmp8_ = self->priv->_undo_stack;
		_tmp9_ = self->priv->_grid;
		_tmp10_ = grid_clone (_tmp9_);
		_tmp11_ = _tmp10_;
		gee_deque_offer_head ((GeeDeque*) _tmp8_, _tmp11_);
		_g_object_unref0 (_tmp11_);
		_tmp12_ = self->priv->_undo_stack;
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == 1) {
			g_signal_emit_by_name (self, "undo-enabled");
		}
	}
}


static void _game_store_score_update (Game* self, guint delta_score) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_allow_undo;
	if (_tmp0_) {
		GeeLinkedList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		guint _tmp4_ = 0U;
		GeeLinkedList* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		_tmp1_ = self->priv->_undo_score_stack;
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_undo_stack_max_size;
		if (((guint) _tmp3_) == _tmp4_) {
			GeeLinkedList* _tmp5_ = NULL;
			_tmp5_ = self->priv->_undo_score_stack;
			gee_deque_poll_tail ((GeeDeque*) _tmp5_);
		}
		_tmp6_ = self->priv->_undo_score_stack;
		_tmp7_ = delta_score;
		gee_deque_offer_head ((GeeDeque*) _tmp6_, (gpointer) ((guintptr) _tmp7_));
	}
}


ClutterActor* game_get_view (Game* self) {
	ClutterActor* result;
	ClutterActor* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}


static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	_game_on_allocation_changed ((Game*) self, box, flags);
}


void game_set_view (Game* self, ClutterActor* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	ClutterActor* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = _tmp1_;
	_tmp2_ = self->priv->_view;
	g_signal_connect_object (_tmp2_, "allocation-changed", (GCallback) __game_on_allocation_changed_clutter_actor_allocation_changed, self, 0);
	_tmp3_ = self->priv->_view;
	_tmp4_ = self->priv->_view_background;
	clutter_actor_add_child (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->_view;
	_tmp6_ = self->priv->_view_foreground;
	clutter_actor_add_child (_tmp5_, _tmp6_);
	g_object_notify ((GObject *) self, "view");
}


guint game_get_score (Game* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_score;
	result = _tmp0_;
	return result;
}


void game_set_score (Game* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_score = _tmp0_;
	g_object_notify ((GObject *) self, "score");
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW, g_param_spec_object ("view", "view", "view", clutter_actor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE, g_param_spec_uint ("score", "score", "score", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("finished", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("target_value_reached", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	g_signal_new ("undo_enabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("undo_disabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->BLANK_ROW_HEIGHT = 10;
	self->priv->BLANK_COL_WIDTH = 10;
	self->priv->_finish_move_id = (guint) 0;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->priv->_grid);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_view_background);
	_g_object_unref0 (self->priv->_view_foreground);
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_to_move);
	_g_object_unref0 (self->priv->_to_hide);
	_g_object_unref0 (self->priv->_to_show);
	_g_object_unref0 (self->priv->_show_hide_trans);
	_g_object_unref0 (self->priv->_move_trans);
	_g_object_unref0 (self->priv->_undo_stack);
	_g_object_unref0 (self->priv->_undo_score_stack);
	_g_object_unref0 (self->priv->_settings);
	_g_free0 (self->priv->_saved_path);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_VIEW:
		g_value_set_object (value, game_get_view (self));
		break;
		case GAME_SCORE:
		g_value_set_uint (value, game_get_score (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_VIEW:
		game_set_view (self, g_value_get_object (value));
		break;
		case GAME_SCORE:
		game_set_score (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



