/* game.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from game.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _TileMovement TileMovement;

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;

#define GAME_TYPE_GAME_STATE (game_game_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tile_movement_free0(var) ((var == NULL) ? NULL : (var = (tile_movement_free (var), NULL)))
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

typedef enum  {
	GAME_GAME_STATE_STOPPED,
	GAME_GAME_STATE_IDLE,
	GAME_GAME_STATE_MOVING_DOWN,
	GAME_GAME_STATE_MOVING_UP,
	GAME_GAME_STATE_MOVING_RIGHT,
	GAME_GAME_STATE_MOVING_LEFT,
	GAME_GAME_STATE_SHOWING_FIRST_TILE,
	GAME_GAME_STATE_SHOWING_SECOND_TILE,
	GAME_GAME_STATE_RESTORING_TILES
} GameGameState;

struct _GamePrivate {
	gint BLANK_ROW_HEIGHT;
	gint BLANK_COL_WIDTH;
	Grid* _grid;
	ClutterActor* _view;
	RoundedRectangle** _background;
	gint _background_length1;
	gint _background_length2;
	TileView** _foreground_cur;
	gint _foreground_cur_length1;
	gint _foreground_cur_length2;
	TileView** _foreground_nxt;
	gint _foreground_nxt_length1;
	gint _foreground_nxt_length2;
	GeeLinkedList* _to_move;
	GeeLinkedList* _to_hide;
	GeeLinkedList* _to_show;
	GameGameState _state;
	ClutterTransitionGroup* _show_hide_trans;
	ClutterTransitionGroup* _move_trans;
	gint _animations_duration;
	gboolean _allow_undo;
	guint _undo_stack_max_size;
	GeeLinkedList* _undo_stack;
	GSettings* _settings;
	gchar* _saved_path;
	guint _resize_view_id;
	guint _score;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType grid_get_type (void) G_GNUC_CONST;
GType rounded_rectangle_get_type (void) G_GNUC_CONST;
GType tile_view_get_type (void) G_GNUC_CONST;
GType tile_movement_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
GType tile_get_type (void) G_GNUC_CONST;
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
static GType game_game_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_VIEW,
	GAME_SCORE
};
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void game_new_game (Game* self);
void grid_clear (Grid* self);
static void _game_init_background (Game* self);
static void _game_clear_foreground (Game* self);
void game_set_score (Game* self, guint value);
static void _game_create_random_tile (Game* self);
void game_undo (Game* self);
static void _game_restore_foreground (Game* self, gboolean animate);
void game_save_game (Game* self);
gchar* grid_save (Grid* self);
gboolean game_restore_game (Game* self);
gboolean grid_load (Grid* self, const gchar* content);
static void _game_clear_background (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
static guint _game_upper_key (Game* self, guint keyval);
static void _game_move_down (Game* self);
static void _game_move_up (Game* self);
static void _game_move_left (Game* self);
static void _game_move_right (Game* self);
gboolean game_reload_settings (Game* self);
gint grid_get_rows (Grid* self);
gint grid_get_cols (Grid* self);
static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags);
static void _game_resize_view (Game* self);
RoundedRectangle* rounded_rectangle_new (gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
RoundedRectangle* rounded_rectangle_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
void rounded_rectangle_resize (RoundedRectangle* self, gfloat x, gfloat y, gfloat width, gfloat height);
static gboolean _game_idle_resize_view (Game* self);
static gboolean __game_idle_resize_view_gsource_func (gpointer self);
void rounded_rectangle_idle_resize (RoundedRectangle* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static void _game_create_show_hide_transition (Game* self, gboolean animate);
static void _game_create_tile (Game* self, Tile* tile);
static void _game_show_tile (Game* self, GridPosition* pos);
TileView* tile_view_new (gfloat x, gfloat y, gfloat width, gfloat height, guint val);
TileView* tile_view_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, guint val);
static void _game_store_movement (Game* self);
static void _game_on_move_trans_stopped (Game* self, gboolean is_finished);
static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to);
static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
static void _game_dim_tile (Game* self, GridPosition* pos);
guint tile_view_get_value (TileView* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_to_string (Grid* self);
guint game_get_score (Game* self);
static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished);
static gboolean _game_finish_move (Game* self);
static gboolean __game_finish_move_gsource_func (gpointer self);
static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
gboolean grid_get_target_value_reached (Grid* self);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gboolean grid_is_finished (Grid* self);
Grid* grid_clone (Grid* self);
ClutterActor* game_get_view (Game* self);
void game_set_view (Game* self, ClutterActor* value);
static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType game_game_state_get_type (void) {
	static volatile gsize game_game_state_type_id__volatile = 0;
	if (g_once_init_enter (&game_game_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_GAME_STATE_STOPPED, "GAME_GAME_STATE_STOPPED", "stopped"}, {GAME_GAME_STATE_IDLE, "GAME_GAME_STATE_IDLE", "idle"}, {GAME_GAME_STATE_MOVING_DOWN, "GAME_GAME_STATE_MOVING_DOWN", "moving-down"}, {GAME_GAME_STATE_MOVING_UP, "GAME_GAME_STATE_MOVING_UP", "moving-up"}, {GAME_GAME_STATE_MOVING_RIGHT, "GAME_GAME_STATE_MOVING_RIGHT", "moving-right"}, {GAME_GAME_STATE_MOVING_LEFT, "GAME_GAME_STATE_MOVING_LEFT", "moving-left"}, {GAME_GAME_STATE_SHOWING_FIRST_TILE, "GAME_GAME_STATE_SHOWING_FIRST_TILE", "showing-first-tile"}, {GAME_GAME_STATE_SHOWING_SECOND_TILE, "GAME_GAME_STATE_SHOWING_SECOND_TILE", "showing-second-tile"}, {GAME_GAME_STATE_RESTORING_TILES, "GAME_GAME_STATE_RESTORING_TILES", "restoring-tiles"}, {0, NULL, NULL}};
		GType game_game_state_type_id;
		game_game_state_type_id = g_enum_register_static ("GameGameState", values);
		g_once_init_leave (&game_game_state_type_id__volatile, game_game_state_type_id);
	}
	return game_game_state_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return self ? g_object_ref (self) : NULL;
#line 278 "game.c"
}


Game* game_construct (GType object_type, GSettings* settings) {
	Game * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint rows = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint cols = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Grid* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GSettings* _tmp9_ = NULL;
	Grid* _tmp10_ = NULL;
	GeeLinkedList* _tmp11_ = NULL;
	GeeLinkedList* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = settings;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_settings);
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_settings = _tmp1_;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_settings;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_settings_get_int (_tmp2_, "rows");
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp3_;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_settings;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = g_settings_get_int (_tmp4_, "cols");
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_new (rows, cols);
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_grid = _tmp6_;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_settings;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = g_settings_get_double (_tmp7_, "animations-speed");
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_animations_duration = (gint) _tmp8_;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_settings;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_grid;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_settings_bind (_tmp9_, "target-value", (GObject*) _tmp10_, "target_value", G_SETTINGS_BIND_DEFAULT);
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_move);
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_move = _tmp11_;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_hide);
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_hide = _tmp12_;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, tile_free, NULL, NULL, NULL);
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_show);
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_show = _tmp13_;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = gee_linked_list_new (TYPE_GRID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_undo_stack);
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack = _tmp14_;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = self->priv->_settings;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = g_settings_get_boolean (_tmp15_, "allow-undo");
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_allow_undo = _tmp16_;
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_settings;
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "allow-undo-max");
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack_max_size = (guint) _tmp18_;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = g_get_user_data_dir ();
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = g_build_filename (_tmp19_, "gnome-2048", "saved", NULL);
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (self->priv->_saved_path);
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_saved_path = _tmp20_;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_state = GAME_GAME_STATE_STOPPED;
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return self;
#line 397 "game.c"
}


Game* game_new (GSettings* settings) {
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return game_construct (TYPE_GAME, settings);
#line 404 "game.c"
}


void game_new_game (Game* self) {
	Grid* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	RoundedRectangle** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_clear (_tmp0_);
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_undo_stack;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_background;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length1 = self->priv->_background_length1;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length2 = self->priv->_background_length2;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp2_ == NULL) {
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 434 "game.c"
	} else {
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_foreground (self);
#line 438 "game.c"
	}
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, (guint) 0);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_state = GAME_GAME_STATE_SHOWING_FIRST_TILE;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_random_tile (self);
#line 446 "game.c"
}


void game_undo (Game* self) {
	Grid* grid = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	Grid* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_undo_stack;
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = gee_deque_poll_head ((GeeDeque*) _tmp0_);
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid = (Grid*) _tmp1_;
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_clear_foreground (self);
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid;
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_grid = _tmp3_;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_restore_foreground (self, FALSE);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_undo_stack;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp6_ == 0) {
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "undo-disabled");
#line 489 "game.c"
	}
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (grid);
#line 493 "game.c"
}


void game_save_game (Game* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = g_strdup ("");
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp0_;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = contents;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_grid;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = grid_save (_tmp2_);
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp5_;
#line 135 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = contents;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_score;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp12_;
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp11_);
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp9_);
#line 557 "game.c"
	{
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = self->priv->_saved_path;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = g_path_get_dirname (_tmp13_);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _tmp14_;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_mkdir_with_parents (_tmp15_, 0775);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (_tmp15_);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp16_ = self->priv->_saved_path;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp17_ = contents;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_file_set_contents (_tmp16_, _tmp17_, (gssize) -1, &_inner_error_);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 584 "game.c"
				goto __catch9_g_file_error;
			}
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (contents);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_clear_error (&_inner_error_);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			return;
#line 595 "game.c"
		}
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_debug ("game.vala:141: game saved successfully");
#line 599 "game.c"
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		e = _inner_error_;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_inner_error_ = NULL;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp18_ = e;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp19_ = _tmp18_->message;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_warning ("game.vala:143: Failed to save game: %s", _tmp19_);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_error_free0 (e);
#line 619 "game.c"
	}
	__finally9:
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_clear_error (&_inner_error_);
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return;
#line 632 "game.c"
	}
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 636 "game.c"
}


gboolean game_restore_game (Game* self) {
	gboolean result = FALSE;
	gchar* contents = NULL;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	Grid* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	RoundedRectangle** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	GError * _inner_error_ = NULL;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 664 "game.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = self->priv->_saved_path;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		contents = _tmp1_;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 680 "game.c"
				goto __catch10_g_file_error;
			}
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (contents);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_clear_error (&_inner_error_);
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			return FALSE;
#line 693 "game.c"
		}
	}
	goto __finally10;
	__catch10_g_file_error:
	{
		GError* e = NULL;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		e = _inner_error_;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_inner_error_ = NULL;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = FALSE;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_error_free0 (e);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 714 "game.c"
	}
	__finally10:
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_clear_error (&_inner_error_);
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return FALSE;
#line 729 "game.c"
	}
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_grid;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = contents;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_load (_tmp2_, _tmp3_);
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (!_tmp4_) {
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_warning ("game.vala:159: Failed to restore game from saved file");
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = FALSE;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 749 "game.c"
	}
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = contents;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = _tmp7_;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines_length1 = _vala_array_length (_tmp6_);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_lines_size_ = lines_length1;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = lines;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length1 = lines_length1;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = lines;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9__length1 = lines_length1;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp8_[_tmp9__length1 - 2];
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = atoi (_tmp10_);
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, (guint) _tmp11_);
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = self->priv->_background;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12__length1 = self->priv->_background_length1;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12__length2 = self->priv->_background_length2;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp12_ != NULL) {
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_background (self);
#line 787 "game.c"
	}
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_init_background (self);
#line 169 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_restore_foreground (self, TRUE);
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:171: game restored successfully");
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = TRUE;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 803 "game.c"
}


gboolean game_key_pressed (Game* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	guint keyval = 0U;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 177 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_state;
#line 177 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ != GAME_GAME_STATE_IDLE) {
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = TRUE;
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 827 "game.c"
	}
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = event;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_->keyval;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _game_upper_key (self, _tmp2_);
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	keyval = _tmp3_;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = keyval;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp4_ == ((guint) GDK_KEY_Down)) {
#line 184 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_move_down (self);
#line 843 "game.c"
	} else {
		guint _tmp5_ = 0U;
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = keyval;
#line 185 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp5_ == ((guint) GDK_KEY_Up)) {
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_up (self);
#line 852 "game.c"
		} else {
			guint _tmp6_ = 0U;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = keyval;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_tmp6_ == ((guint) GDK_KEY_Left)) {
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_game_move_left (self);
#line 861 "game.c"
			} else {
				guint _tmp7_ = 0U;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp7_ = keyval;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (_tmp7_ == ((guint) GDK_KEY_Right)) {
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_game_move_right (self);
#line 870 "game.c"
				}
			}
		}
	}
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 879 "game.c"
}


gboolean game_reload_settings (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gboolean allow_undo = FALSE;
	GSettings* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	Grid* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_settings;
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = g_settings_get_double (_tmp0_, "animations-speed");
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_animations_duration = (gint) _tmp1_;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_settings;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_settings_get_boolean (_tmp2_, "allow-undo");
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	allow_undo = _tmp3_;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_allow_undo;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp5_) {
#line 924 "game.c"
		gboolean _tmp6_ = FALSE;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = allow_undo;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = !_tmp6_;
#line 930 "game.c"
	} else {
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = FALSE;
#line 934 "game.c"
	}
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp4_) {
#line 938 "game.c"
		GeeLinkedList* _tmp7_ = NULL;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = self->priv->_undo_stack;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "undo-disabled");
#line 946 "game.c"
	}
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = allow_undo;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_allow_undo = _tmp8_;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_settings;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_settings_get_int (_tmp9_, "allow-undo-max");
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack_max_size = (guint) _tmp10_;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = self->priv->_settings;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_settings_get_int (_tmp11_, "rows");
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp12_;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_settings;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = g_settings_get_int (_tmp13_, "cols");
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp14_;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = rows;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_grid;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = grid_get_rows (_tmp17_);
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp16_ != _tmp19_) {
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = TRUE;
#line 982 "game.c"
	} else {
		gint _tmp20_ = 0;
		Grid* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp20_ = cols;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp21_ = self->priv->_grid;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp22_ = grid_get_cols (_tmp21_);
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = _tmp22_;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _tmp20_ != _tmp23_;
#line 998 "game.c"
	}
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp15_) {
#line 1002 "game.c"
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		Grid* _tmp26_ = NULL;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_foreground (self);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_background (self);
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = rows;
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = cols;
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = grid_new (_tmp24_, _tmp25_);
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (self->priv->_grid);
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_grid = _tmp26_;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = TRUE;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 1026 "game.c"
	}
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1032 "game.c"
}


static guint _game_upper_key (Game* self, guint keyval) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = keyval;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp1_ > ((guint) 255)) {
#line 1046 "game.c"
		guint _tmp2_ = 0U;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = keyval;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = _tmp2_;
#line 1052 "game.c"
	} else {
		guint _tmp3_ = 0U;
		gchar _tmp4_ = '\0';
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = keyval;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = g_ascii_toupper ((gchar) _tmp3_);
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = (guint) _tmp4_;
#line 1062 "game.c"
	}
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1068 "game.c"
}


static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags) {
	RoundedRectangle** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (box != NULL);
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_background;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0__length1 = self->priv->_background_length1;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0__length2 = self->priv->_background_length2;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ == NULL) {
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 1090 "game.c"
	} else {
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_resize_view (self);
#line 1094 "game.c"
	}
}


static void _game_init_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ClutterColor background_color = {0};
	ClutterActor* _tmp6_ = NULL;
	ClutterColor _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	RoundedRectangle** _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	TileView** _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	TileView** _tmp16_ = NULL;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp19_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gfloat _tmp26_ = 0.0F;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp29_ = 0.0F;
	gint _tmp30_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp31_ = 0.0F;
	gint _tmp32_ = 0;
	ClutterColor color = {0};
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_color_from_string (&background_color, "#babdb6");
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_view;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = background_color;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_set_background_color (_tmp6_, &_tmp7_);
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = rows;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = cols;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_new0 (RoundedRectangle*, (_tmp8_ * _tmp9_) + 1);
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = _tmp10_;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background_length1 = _tmp8_;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background_length2 = _tmp9_;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = rows;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = cols;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = g_new0 (TileView*, (_tmp11_ * _tmp12_) + 1);
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = _tmp13_;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur_length1 = _tmp11_;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur_length2 = _tmp12_;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = rows;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = cols;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = g_new0 (TileView*, (_tmp14_ * _tmp15_) + 1);
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = _tmp16_;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt_length1 = _tmp14_;
#line 252 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt_length2 = _tmp15_;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_view;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = clutter_actor_get_width (_tmp17_);
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp19_;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = self->priv->_view;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = clutter_actor_get_height (_tmp20_);
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp22_;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = canvas_width;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = cols;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = self->priv->BLANK_COL_WIDTH;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp23_ - ((_tmp24_ + 1) * _tmp25_);
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = canvas_height;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = rows;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = self->priv->BLANK_ROW_HEIGHT;
#line 258 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp26_ - ((_tmp27_ + 1) * _tmp28_);
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = canvas_width;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = cols;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_width = _tmp29_ / _tmp30_;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = canvas_height;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = rows;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_height = _tmp31_ / _tmp32_;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_color_from_string (&color, "#ffffff");
#line 1255 "game.c"
	{
		gint i = 0;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1260 "game.c"
		{
			gboolean _tmp33_ = FALSE;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = TRUE;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1267 "game.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp33_) {
#line 1272 "game.c"
					gint _tmp34_ = 0;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp34_ = i;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp34_ + 1;
#line 1278 "game.c"
				}
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp33_ = FALSE;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp35_ = i;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp36_ = rows;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp35_ < _tmp36_)) {
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1290 "game.c"
				}
				{
					gint j = 0;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1296 "game.c"
					{
						gboolean _tmp37_ = FALSE;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp37_ = TRUE;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1303 "game.c"
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gfloat x = 0.0F;
							gint _tmp41_ = 0;
							gfloat _tmp42_ = 0.0F;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gfloat y = 0.0F;
							gint _tmp45_ = 0;
							gfloat _tmp46_ = 0.0F;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							RoundedRectangle* rect = NULL;
							gfloat _tmp49_ = 0.0F;
							gfloat _tmp50_ = 0.0F;
							gfloat _tmp51_ = 0.0F;
							gfloat _tmp52_ = 0.0F;
							ClutterColor _tmp53_ = {0};
							RoundedRectangle* _tmp54_ = NULL;
							ClutterActor* _tmp55_ = NULL;
							RoundedRectangle* _tmp56_ = NULL;
							ClutterActor* _tmp57_ = NULL;
							ClutterActor* _tmp58_ = NULL;
							RoundedRectangle* _tmp59_ = NULL;
							ClutterCanvas* _tmp60_ = NULL;
							ClutterCanvas* _tmp61_ = NULL;
							RoundedRectangle* _tmp62_ = NULL;
							ClutterActor* _tmp63_ = NULL;
							ClutterActor* _tmp64_ = NULL;
							RoundedRectangle** _tmp65_ = NULL;
							gint _tmp65__length1 = 0;
							gint _tmp65__length2 = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							RoundedRectangle* _tmp68_ = NULL;
							RoundedRectangle* _tmp69_ = NULL;
							RoundedRectangle* _tmp70_ = NULL;
							TileView** _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							TileView* _tmp74_ = NULL;
							TileView** _tmp75_ = NULL;
							gint _tmp75__length1 = 0;
							gint _tmp75__length2 = 0;
							gint _tmp76_ = 0;
							gint _tmp77_ = 0;
							TileView* _tmp78_ = NULL;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp37_) {
#line 1355 "game.c"
								gint _tmp38_ = 0;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp38_ = j;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp38_ + 1;
#line 1361 "game.c"
							}
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp37_ = FALSE;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp39_ = j;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp40_ = cols;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp39_ < _tmp40_)) {
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1373 "game.c"
							}
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp41_ = j;
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp42_ = tile_width;
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp43_ = j;
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp44_ = self->priv->BLANK_COL_WIDTH;
#line 267 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							x = (_tmp41_ * _tmp42_) + ((_tmp43_ + 1) * _tmp44_);
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp45_ = i;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46_ = tile_height;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp47_ = i;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp48_ = self->priv->BLANK_ROW_HEIGHT;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							y = (_tmp45_ * _tmp46_) + ((_tmp47_ + 1) * _tmp48_);
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp49_ = x;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp50_ = y;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp51_ = tile_width;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp52_ = tile_height;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp53_ = color;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp54_ = rounded_rectangle_new (_tmp49_, _tmp50_, _tmp51_, _tmp52_, &_tmp53_);
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rect = _tmp54_;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp55_ = self->priv->_view;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp56_ = rect;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp57_ = rounded_rectangle_get_actor (_tmp56_);
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58_ = _tmp57_;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_add_child (_tmp55_, _tmp58_);
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp59_ = rect;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp60_ = rounded_rectangle_get_canvas (_tmp59_);
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp61_ = _tmp60_;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_content_invalidate ((ClutterContent*) _tmp61_);
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp62_ = rect;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp63_ = rounded_rectangle_get_actor (_tmp62_);
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp64_ = _tmp63_;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_show (_tmp64_);
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65_ = self->priv->_background;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65__length1 = self->priv->_background_length1;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65__length2 = self->priv->_background_length2;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp66_ = i;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp67_ = j;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp68_ = rect;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp69_ = _g_object_ref0 (_tmp68_);
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_]);
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = _tmp69_;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp70_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71_ = self->priv->_foreground_cur;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71__length1 = self->priv->_foreground_cur_length1;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71__length2 = self->priv->_foreground_cur_length2;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp72_ = i;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp73_ = j;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_]);
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_] = NULL;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75_ = self->priv->_foreground_nxt;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75__length1 = self->priv->_foreground_nxt_length1;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75__length2 = self->priv->_foreground_nxt_length2;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp76_ = i;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp77_ = j;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_]);
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_] = NULL;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp78_ = _tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_];
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (rect);
#line 1489 "game.c"
						}
					}
				}
			}
		}
	}
}


static gboolean __game_idle_resize_view_gsource_func (gpointer self) {
	gboolean result;
	result = _game_idle_resize_view ((Game*) self);
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1504 "game.c"
}


static void _game_resize_view (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp6_ = NULL;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp9_ = NULL;
	gfloat _tmp10_ = 0.0F;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gfloat _tmp15_ = 0.0F;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gint _tmp19_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp20_ = 0.0F;
	gint _tmp21_ = 0;
	guint _tmp70_ = 0U;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_view;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = clutter_actor_get_width (_tmp6_);
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_;
#line 287 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp8_;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_view;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = clutter_actor_get_height (_tmp9_);
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp11_;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = canvas_width;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = cols;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = self->priv->BLANK_COL_WIDTH;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp12_ - ((_tmp13_ + 1) * _tmp14_);
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = canvas_height;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = rows;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->BLANK_ROW_HEIGHT;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp15_ - ((_tmp16_ + 1) * _tmp17_);
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = canvas_width;
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = cols;
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_width = _tmp18_ / _tmp19_;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = canvas_height;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = rows;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_height = _tmp20_ / _tmp21_;
#line 1600 "game.c"
	{
		gint i = 0;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1605 "game.c"
		{
			gboolean _tmp22_ = FALSE;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = TRUE;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1612 "game.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp22_) {
#line 1617 "game.c"
					gint _tmp23_ = 0;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp23_ = i;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp23_ + 1;
#line 1623 "game.c"
				}
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp22_ = FALSE;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp24_ = i;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp25_ = rows;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1635 "game.c"
				}
				{
					gint j = 0;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1641 "game.c"
					{
						gboolean _tmp26_ = FALSE;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp26_ = TRUE;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1648 "game.c"
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gfloat x = 0.0F;
							gint _tmp30_ = 0;
							gfloat _tmp31_ = 0.0F;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gfloat y = 0.0F;
							gint _tmp34_ = 0;
							gfloat _tmp35_ = 0.0F;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							RoundedRectangle** _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							RoundedRectangle* _tmp41_ = NULL;
							gfloat _tmp42_ = 0.0F;
							gfloat _tmp43_ = 0.0F;
							gfloat _tmp44_ = 0.0F;
							gfloat _tmp45_ = 0.0F;
							TileView** _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							TileView* _tmp49_ = NULL;
							TileView** _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							gint _tmp58__length2 = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							TileView* _tmp61_ = NULL;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp26_) {
#line 1685 "game.c"
								gint _tmp27_ = 0;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = j;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp27_ + 1;
#line 1691 "game.c"
							}
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp26_ = FALSE;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp28_ = j;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp29_ = cols;
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp28_ < _tmp29_)) {
#line 297 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1703 "game.c"
							}
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp30_ = j;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp31_ = tile_width;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp32_ = j;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp33_ = self->priv->BLANK_COL_WIDTH;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							x = (_tmp30_ * _tmp31_) + ((_tmp32_ + 1) * _tmp33_);
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp34_ = i;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp35_ = tile_height;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp36_ = i;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp37_ = self->priv->BLANK_ROW_HEIGHT;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							y = (_tmp34_ * _tmp35_) + ((_tmp36_ + 1) * _tmp37_);
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38_ = self->priv->_background;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38__length1 = self->priv->_background_length1;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38__length2 = self->priv->_background_length2;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp39_ = i;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp40_ = j;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp42_ = x;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp43_ = y;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp44_ = tile_width;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp45_ = tile_height;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rounded_rectangle_resize (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46_ = self->priv->_foreground_cur;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46__length1 = self->priv->_foreground_cur_length1;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46__length2 = self->priv->_foreground_cur_length2;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp47_ = i;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp48_ = j;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp49_ != NULL) {
#line 1761 "game.c"
								TileView** _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								gint _tmp50__length2 = 0;
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								TileView* _tmp53_ = NULL;
								gfloat _tmp54_ = 0.0F;
								gfloat _tmp55_ = 0.0F;
								gfloat _tmp56_ = 0.0F;
								gfloat _tmp57_ = 0.0F;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50_ = self->priv->_foreground_cur;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50__length1 = self->priv->_foreground_cur_length1;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50__length2 = self->priv->_foreground_cur_length2;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp51_ = i;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp52_ = j;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp54_ = x;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp55_ = y;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp56_ = tile_width;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp57_ = tile_height;
#line 304 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_resize ((RoundedRectangle*) _tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
#line 1794 "game.c"
							}
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58_ = self->priv->_foreground_nxt;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58__length1 = self->priv->_foreground_nxt_length1;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58__length2 = self->priv->_foreground_nxt_length2;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp59_ = i;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp60_ = j;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp61_ != NULL) {
#line 1810 "game.c"
								TileView** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								gint _tmp62__length2 = 0;
								gint _tmp63_ = 0;
								gint _tmp64_ = 0;
								TileView* _tmp65_ = NULL;
								gfloat _tmp66_ = 0.0F;
								gfloat _tmp67_ = 0.0F;
								gfloat _tmp68_ = 0.0F;
								gfloat _tmp69_ = 0.0F;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62_ = self->priv->_foreground_nxt;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62__length1 = self->priv->_foreground_nxt_length1;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62__length2 = self->priv->_foreground_nxt_length2;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp63_ = i;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp64_ = j;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp66_ = x;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp67_ = y;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp68_ = tile_width;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp69_ = tile_height;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_resize ((RoundedRectangle*) _tmp65_, _tmp66_, _tmp67_, _tmp68_, _tmp69_);
#line 1843 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp70_ = self->priv->_resize_view_id;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp70_ == ((guint) 0)) {
#line 1855 "game.c"
		guint _tmp71_ = 0U;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp71_ = clutter_threads_add_timeout ((guint) 1000, __game_idle_resize_view_gsource_func, self);
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_resize_view_id = _tmp71_;
#line 1861 "game.c"
	}
}


static gboolean _game_idle_resize_view (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 1894 "game.c"
	{
		gint i = 0;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1899 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1906 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 1911 "game.c"
					gint _tmp7_ = 0;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 1917 "game.c"
				}
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1929 "game.c"
				}
				{
					gint j = 0;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1935 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1942 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							TileView** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp18__length2 = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							TileView* _tmp21_ = NULL;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 1959 "game.c"
								gint _tmp11_ = 0;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 1965 "game.c"
							}
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1977 "game.c"
							}
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_background;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_background_length1;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_background_length2;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rounded_rectangle_idle_resize (_tmp17_);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = self->priv->_foreground_cur;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18__length1 = self->priv->_foreground_cur_length1;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18__length2 = self->priv->_foreground_cur_length2;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = i;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp20_ = j;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp21_ != NULL) {
#line 2007 "game.c"
								TileView** _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp22__length2 = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								TileView* _tmp25_ = NULL;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_ = self->priv->_foreground_cur;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22__length1 = self->priv->_foreground_cur_length1;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22__length2 = self->priv->_foreground_cur_length2;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = i;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = j;
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 324 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_idle_resize ((RoundedRectangle*) _tmp25_);
#line 2028 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_resize_view_id = (guint) 0;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 2042 "game.c"
}


static void _game_create_random_tile (Game* self) {
	Tile tile = {0};
	Grid* _tmp0_ = NULL;
	Tile _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_new_tile (_tmp0_, &_tmp1_);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile = _tmp1_;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp2_) {
#line 2061 "game.c"
		Tile _tmp3_ = {0};
		GeeLinkedList* _tmp4_ = NULL;
		Tile _tmp5_ = {0};
		Tile _tmp6_ = {0};
		GridPosition _tmp7_ = {0};
		ClutterTransitionGroup* _tmp8_ = NULL;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_show_hide_transition (self, TRUE);
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = tile;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_tile (self, &_tmp3_);
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_to_show;
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = tile;
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = tile;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = _tmp6_.pos;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_show_tile (self, &_tmp7_);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_show_hide_trans;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp8_);
#line 2090 "game.c"
	}
}


static void _game_create_tile (Game* self, Tile* tile) {
	GridPosition pos = {0};
	RoundedRectangle* rect = NULL;
	TileView* view = NULL;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	Tile _tmp0_ = {0};
	GridPosition _tmp1_ = {0};
	RoundedRectangle** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	GridPosition _tmp3_ = {0};
	guint _tmp4_ = 0U;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	RoundedRectangle* _tmp7_ = NULL;
	RoundedRectangle* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterActor* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	gfloat _tmp23_ = 0.0F;
	gfloat _tmp24_ = 0.0F;
	TileView** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp25__length2 = 0;
	GridPosition _tmp26_ = {0};
	guint _tmp27_ = 0U;
	GridPosition _tmp28_ = {0};
	guint _tmp29_ = 0U;
	TileView* _tmp30_ = NULL;
	Tile _tmp31_ = {0};
	guint _tmp32_ = 0U;
	TileView* _tmp33_ = NULL;
	TileView** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gint _tmp34__length2 = 0;
	GridPosition _tmp35_ = {0};
	guint _tmp36_ = 0U;
	GridPosition _tmp37_ = {0};
	guint _tmp38_ = 0U;
	TileView* _tmp39_ = NULL;
	TileView* _tmp40_ = NULL;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (tile != NULL);
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = *tile;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_.pos;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	pos = _tmp1_;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_background;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length1 = self->priv->_background_length1;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length2 = self->priv->_background_length2;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = pos;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_.row;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = pos;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.col;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect);
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect = _tmp8_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = rounded_rectangle_get_actor (rect);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp9_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = clutter_actor_get_x (_tmp10_);
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	x = _tmp12_;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = rounded_rectangle_get_actor (rect);
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = _tmp13_;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = clutter_actor_get_y (_tmp14_);
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = _tmp15_;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	y = _tmp16_;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = rounded_rectangle_get_actor (rect);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp17_;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = clutter_actor_get_width (_tmp18_);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp19_;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	width = _tmp20_;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = rounded_rectangle_get_actor (rect);
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = clutter_actor_get_height (_tmp22_);
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _tmp23_;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	height = _tmp24_;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = self->priv->_foreground_nxt;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25__length1 = self->priv->_foreground_nxt_length1;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25__length2 = self->priv->_foreground_nxt_length2;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = pos;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = _tmp26_.row;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = pos;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = _tmp28_.col;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = _tmp25_[(_tmp27_ * _tmp25__length2) + _tmp29_];
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_vala_assert (_tmp30_ == NULL, "_foreground_nxt[pos.row,pos.col] == null");
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = *tile;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = _tmp31_.val;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp33_ = tile_view_new (x, y, width, height, _tmp32_);
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	view = _tmp33_;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34_ = self->priv->_foreground_nxt;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34__length1 = self->priv->_foreground_nxt_length1;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34__length2 = self->priv->_foreground_nxt_length2;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp35_ = pos;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp36_ = _tmp35_.row;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp37_ = pos;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp38_ = _tmp37_.col;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp39_ = _g_object_ref0 (view);
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_]);
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_] = _tmp39_;
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = _tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_];
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect);
#line 2276 "game.c"
}


static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_move_trans_stopped ((Game*) self, is_finished);
#line 2283 "game.c"
}


static void _game_move_down (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 369 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 371 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:371: move down");
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 379 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_down (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2335 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2363 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2387 "game.c"
			}
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2409 "game.c"
		}
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2413 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2442 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2466 "game.c"
			}
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2488 "game.c"
		}
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2492 "game.c"
	}
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 2504 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 2517 "game.c"
	}
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 2523 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 2536 "game.c"
	}
#line 389 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 2544 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_DOWN;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 2552 "game.c"
	}
}


static void _game_move_up (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 397 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:399: move up");
#line 403 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 406 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 406 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_up (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2605 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2633 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2657 "game.c"
			}
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 412 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 412 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 412 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 412 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 412 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2679 "game.c"
		}
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2683 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2712 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2736 "game.c"
			}
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2758 "game.c"
		}
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2762 "game.c"
	}
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 2774 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 2787 "game.c"
	}
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 2793 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 2806 "game.c"
	}
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 419 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 419 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 2814 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_UP;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 2822 "game.c"
	}
}


static void _game_move_left (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:427: move left");
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 433 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 433 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 433 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_left (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2875 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2903 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2927 "game.c"
			}
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2949 "game.c"
		}
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2953 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2982 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3006 "game.c"
			}
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3028 "game.c"
		}
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3032 "game.c"
	}
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 3044 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 3057 "game.c"
	}
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 3063 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 3076 "game.c"
	}
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 3084 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 3092 "game.c"
	}
}


static void _game_move_right (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 453 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 455 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:455: move right");
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 461 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 461 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 461 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 463 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 463 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 463 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_right (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 3145 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 3173 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3197 "game.c"
			}
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 468 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 468 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 468 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 468 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 468 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3219 "game.c"
		}
#line 467 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3223 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 3252 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3276 "game.c"
			}
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3298 "game.c"
		}
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3302 "game.c"
	}
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 3314 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 3327 "game.c"
	}
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 3333 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 3346 "game.c"
	}
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 3354 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 476 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
#line 477 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 477 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 3362 "game.c"
	}
}


static void _game_show_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView* view = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	TileView* _tmp10_ = NULL;
	ClutterCanvas* _tmp11_ = NULL;
	ClutterCanvas* _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterPropertyTransition* _tmp20_ = NULL;
	ClutterPropertyTransition* _tmp21_ = NULL;
	GValue _tmp22_ = {0};
	ClutterPropertyTransition* _tmp23_ = NULL;
	GValue _tmp24_ = {0};
	ClutterPropertyTransition* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ClutterPropertyTransition* _tmp27_ = NULL;
	ClutterActor* _tmp28_ = NULL;
	ClutterActor* _tmp29_ = NULL;
	ClutterTransitionGroup* _tmp30_ = NULL;
	ClutterPropertyTransition* _tmp31_ = NULL;
	ClutterPropertyTransition* _tmp32_ = NULL;
	ClutterPropertyTransition* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	ClutterPropertyTransition* _tmp35_ = NULL;
	GValue _tmp36_ = {0};
	ClutterPropertyTransition* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ClutterPropertyTransition* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterTransitionGroup* _tmp42_ = NULL;
	ClutterPropertyTransition* _tmp43_ = NULL;
	ClutterPropertyTransition* _tmp44_ = NULL;
	ClutterPropertyTransition* _tmp45_ = NULL;
	GValue _tmp46_ = {0};
	ClutterPropertyTransition* _tmp47_ = NULL;
	GValue _tmp48_ = {0};
	ClutterPropertyTransition* _tmp49_ = NULL;
	ClutterPropertyTransition* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	ClutterActor* _tmp52_ = NULL;
	ClutterActor* _tmp53_ = NULL;
	ClutterPropertyTransition* _tmp54_ = NULL;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (pos != NULL);
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (pos);
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = g_strconcat ("show tile pos ", _tmp1_, NULL);
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:483: %s", _tmp3_);
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_foreground_nxt;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length1 = self->priv->_foreground_nxt_length1;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length2 = self->priv->_foreground_nxt_length2;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = *pos;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.row;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *pos;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_.col;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	view = _tmp10_;
#line 489 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = rounded_rectangle_get_canvas ((RoundedRectangle*) view);
#line 489 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 489 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_content_invalidate ((ClutterContent*) _tmp12_);
#line 490 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 490 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = _tmp13_;
#line 490 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_set_opacity (_tmp14_, (guint8) 0);
#line 491 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 491 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = _tmp15_;
#line 491 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_show (_tmp16_);
#line 492 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_view;
#line 492 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 492 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 492 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_add_child (_tmp17_, _tmp19_);
#line 494 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
#line 494 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 494 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp20_;
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = trans;
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp22_, G_TYPE_DOUBLE);
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp22_, 1.0);
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp21_, &_tmp22_);
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
#line 496 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = trans;
#line 496 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp24_, G_TYPE_DOUBLE);
#line 496 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp24_, 1.1);
#line 496 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp23_, &_tmp24_);
#line 496 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = trans;
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = self->priv->_animations_duration;
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp25_, (guint) _tmp26_);
#line 498 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = trans;
#line 498 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 498 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = _tmp28_;
#line 498 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp27_, (ClutterAnimatable*) _tmp29_);
#line 499 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_show_hide_trans;
#line 499 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = trans;
#line 499 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp30_, (ClutterTransition*) _tmp31_);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp32_;
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp33_ = trans;
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp34_, G_TYPE_DOUBLE);
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp34_, 1.0);
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp33_, &_tmp34_);
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp35_ = trans;
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp36_, G_TYPE_DOUBLE);
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp36_, 1.1);
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp35_, &_tmp36_);
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp36_) ? (g_value_unset (&_tmp36_), NULL) : NULL;
#line 504 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp37_ = trans;
#line 504 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp38_ = self->priv->_animations_duration;
#line 504 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp37_, (guint) _tmp38_);
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp39_ = trans;
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = _tmp40_;
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp39_, (ClutterAnimatable*) _tmp41_);
#line 506 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = self->priv->_show_hide_trans;
#line 506 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp43_ = trans;
#line 506 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp42_, (ClutterTransition*) _tmp43_);
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp44_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp44_;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp45_ = trans;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp46_, G_TYPE_INT);
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp46_, 0);
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp45_, &_tmp46_);
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp47_ = trans;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp48_, G_TYPE_INT);
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp48_, 255);
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp47_, &_tmp48_);
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = trans;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp49_, TRUE);
#line 512 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp50_ = trans;
#line 512 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp51_ = self->priv->_animations_duration;
#line 512 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp50_, (guint) (_tmp51_ / 2));
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp52_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp53_ = _tmp52_;
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp54_ = trans;
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_add_transition (_tmp53_, "show", (ClutterTransition*) _tmp54_);
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 3633 "game.c"
}


static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GridPosition _tmp6_ = {0};
	GridPosition _tmp7_ = {0};
	TileView** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	GridPosition _tmp9_ = {0};
	guint _tmp10_ = 0U;
	GridPosition _tmp11_ = {0};
	guint _tmp12_ = 0U;
	TileView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	TileView* _tmp18_ = NULL;
	TileView* _tmp19_ = NULL;
	TileView* _tmp20_ = NULL;
	TileView** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	GridPosition _tmp22_ = {0};
	guint _tmp23_ = 0U;
	GridPosition _tmp24_ = {0};
	guint _tmp25_ = 0U;
	TileView* _tmp26_ = NULL;
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (from != NULL);
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (to != NULL);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (from);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_position_to_string (to);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = g_strconcat ("move tile from ", _tmp1_, " to ", _tmp3_, NULL);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:518: %s", _tmp5_);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp5_);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 520 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = *from;
#line 520 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *to;
#line 520 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_prepare_move_tile (self, &_tmp6_, &_tmp7_);
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = self->priv->_foreground_nxt;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length1 = self->priv->_foreground_nxt_length1;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length2 = self->priv->_foreground_nxt_length2;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = *to;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp9_.row;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = *to;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_.col;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_foreground_cur;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length1 = self->priv->_foreground_cur_length1;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length2 = self->priv->_foreground_cur_length2;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = *from;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_.row;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = *from;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = _tmp16_.col;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_]);
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_] = _tmp19_;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = self->priv->_foreground_cur;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21__length1 = self->priv->_foreground_cur_length1;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21__length2 = self->priv->_foreground_cur_length2;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = *from;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = _tmp22_.row;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = *from;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = _tmp24_.col;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_]);
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_] = NULL;
#line 523 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = _tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_];
#line 3761 "game.c"
}


static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean row_move = FALSE;
	gchar* trans_name = NULL;
	ClutterPropertyTransition* trans = NULL;
	RoundedRectangle* rect_from = NULL;
	RoundedRectangle* rect_to = NULL;
	GridPosition _tmp6_ = {0};
	guint _tmp7_ = 0U;
	GridPosition _tmp8_ = {0};
	guint _tmp9_ = 0U;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_ = NULL;
	RoundedRectangle** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	RoundedRectangle* _tmp18_ = NULL;
	RoundedRectangle* _tmp19_ = NULL;
	RoundedRectangle** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp20__length2 = 0;
	GridPosition _tmp21_ = {0};
	guint _tmp22_ = 0U;
	GridPosition _tmp23_ = {0};
	guint _tmp24_ = 0U;
	RoundedRectangle* _tmp25_ = NULL;
	RoundedRectangle* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	ClutterPropertyTransition* _tmp28_ = NULL;
	gfloat _tmp29_ = 0.0F;
	gboolean _tmp30_ = FALSE;
	ClutterPropertyTransition* _tmp41_ = NULL;
	GValue _tmp42_ = {0};
	gfloat _tmp43_ = 0.0F;
	gboolean _tmp44_ = FALSE;
	ClutterPropertyTransition* _tmp55_ = NULL;
	GValue _tmp56_ = {0};
	ClutterPropertyTransition* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	ClutterPropertyTransition* _tmp59_ = NULL;
	TileView** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	gint _tmp60__length2 = 0;
	GridPosition _tmp61_ = {0};
	guint _tmp62_ = 0U;
	GridPosition _tmp63_ = {0};
	guint _tmp64_ = 0U;
	TileView* _tmp65_ = NULL;
	ClutterActor* _tmp66_ = NULL;
	ClutterActor* _tmp67_ = NULL;
	ClutterTransitionGroup* _tmp68_ = NULL;
	ClutterPropertyTransition* _tmp69_ = NULL;
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (from != NULL);
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (to != NULL);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (from);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_position_to_string (to);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = g_strconcat ("prepare move tile from ", _tmp1_, " to ", _tmp3_, NULL);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:528: %s", _tmp5_);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp5_);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 536 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = *from;
#line 536 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_.col;
#line 536 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = *to;
#line 536 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_.col;
#line 536 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	row_move = _tmp7_ == _tmp9_;
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = row_move;
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp11_) {
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = "y";
#line 3869 "game.c"
	} else {
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = "x";
#line 3873 "game.c"
	}
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strdup (_tmp10_);
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (trans_name);
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans_name = _tmp12_;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_background;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length1 = self->priv->_background_length1;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length2 = self->priv->_background_length2;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = *from;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_.row;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = *from;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = _tmp16_.col;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_from);
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect_from = _tmp19_;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = self->priv->_background;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20__length1 = self->priv->_background_length1;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20__length2 = self->priv->_background_length2;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = *to;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_.row;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = *to;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _tmp23_.col;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = _tmp20_[(_tmp22_ * _tmp20__length2) + _tmp24_];
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_to);
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect_to = _tmp26_;
#line 542 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = trans_name;
#line 542 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = (ClutterPropertyTransition*) clutter_property_transition_new (_tmp27_);
#line 542 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 542 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp28_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = row_move;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp30_) {
#line 3937 "game.c"
		RoundedRectangle* _tmp31_ = NULL;
		ClutterActor* _tmp32_ = NULL;
		ClutterActor* _tmp33_ = NULL;
		gfloat _tmp34_ = 0.0F;
		gfloat _tmp35_ = 0.0F;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp31_ = rect_from;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp32_ = rounded_rectangle_get_actor (_tmp31_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp33_ = _tmp32_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp34_ = clutter_actor_get_y (_tmp33_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp35_ = _tmp34_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp29_ = _tmp35_;
#line 3955 "game.c"
	} else {
		RoundedRectangle* _tmp36_ = NULL;
		ClutterActor* _tmp37_ = NULL;
		ClutterActor* _tmp38_ = NULL;
		gfloat _tmp39_ = 0.0F;
		gfloat _tmp40_ = 0.0F;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp36_ = rect_from;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp37_ = rounded_rectangle_get_actor (_tmp36_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp37_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = clutter_actor_get_x (_tmp38_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp40_ = _tmp39_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp29_ = _tmp40_;
#line 3974 "game.c"
	}
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = trans;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp42_, G_TYPE_FLOAT);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_float (&_tmp42_, _tmp29_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp41_, &_tmp42_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp44_ = row_move;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp44_) {
#line 3990 "game.c"
		RoundedRectangle* _tmp45_ = NULL;
		ClutterActor* _tmp46_ = NULL;
		ClutterActor* _tmp47_ = NULL;
		gfloat _tmp48_ = 0.0F;
		gfloat _tmp49_ = 0.0F;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = rect_to;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = rounded_rectangle_get_actor (_tmp45_);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = _tmp46_;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = clutter_actor_get_y (_tmp47_);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp49_ = _tmp48_;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp49_;
#line 4008 "game.c"
	} else {
		RoundedRectangle* _tmp50_ = NULL;
		ClutterActor* _tmp51_ = NULL;
		ClutterActor* _tmp52_ = NULL;
		gfloat _tmp53_ = 0.0F;
		gfloat _tmp54_ = 0.0F;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = rect_to;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp51_ = rounded_rectangle_get_actor (_tmp50_);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp52_ = _tmp51_;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp53_ = clutter_actor_get_x (_tmp52_);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp54_ = _tmp53_;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp54_;
#line 4027 "game.c"
	}
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp55_ = trans;
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp56_, G_TYPE_FLOAT);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_float (&_tmp56_, _tmp43_);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp55_, &_tmp56_);
#line 544 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp56_) ? (g_value_unset (&_tmp56_), NULL) : NULL;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp57_ = trans;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp58_ = self->priv->_animations_duration;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp57_, (guint) _tmp58_);
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp59_ = trans;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60_ = self->priv->_foreground_cur;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60__length1 = self->priv->_foreground_cur_length1;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60__length2 = self->priv->_foreground_cur_length2;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp61_ = *from;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp62_ = _tmp61_.row;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp63_ = *from;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp64_ = _tmp63_.col;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp65_ = _tmp60_[(_tmp62_ * _tmp60__length2) + _tmp64_];
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp66_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp65_);
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp67_ = _tmp66_;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp59_, (ClutterAnimatable*) _tmp67_);
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp68_ = self->priv->_move_trans;
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp69_ = trans;
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp68_, (ClutterTransition*) _tmp69_);
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_to);
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_from);
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 526 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (trans_name);
#line 4083 "game.c"
}


static void _game_dim_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	ClutterActor* actor = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	GridPosition _tmp17_ = {0};
	guint _tmp18_ = 0U;
	GridPosition _tmp19_ = {0};
	guint _tmp20_ = 0U;
	TileView* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	ClutterActor* _tmp23_ = NULL;
	ClutterActor* _tmp24_ = NULL;
	ClutterPropertyTransition* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	GValue _tmp28_ = {0};
	GValue _tmp29_ = {0};
	gint _tmp30_ = 0;
	ClutterTransitionGroup* _tmp31_ = NULL;
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (pos != NULL);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (pos);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = g_strconcat ("diming tile at ", _tmp1_, " ", NULL);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_foreground_cur;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length1 = self->priv->_foreground_cur_length1;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length2 = self->priv->_foreground_cur_length2;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = *pos;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.row;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *pos;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_.col;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = tile_view_get_value (_tmp9_);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strdup_printf ("%u", _tmp11_);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = _tmp12_;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = g_strconcat (_tmp3_, _tmp13_, NULL);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:552: %s", _tmp15_);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp15_);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp13_);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = self->priv->_foreground_cur;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16__length1 = self->priv->_foreground_cur_length1;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16__length2 = self->priv->_foreground_cur_length2;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = *pos;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp17_.row;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = *pos;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp19_.col;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp21_);
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = _tmp22_;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (actor);
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	actor = _tmp24_;
#line 559 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
#line 559 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 559 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp25_;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = clutter_actor_get_opacity (actor);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = _tmp26_;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp28_, G_TYPE_UINT);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_uint (&_tmp28_, _tmp27_);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) trans, &_tmp28_);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp28_) ? (g_value_unset (&_tmp28_), NULL) : NULL;
#line 561 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp29_, G_TYPE_INT);
#line 561 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp29_, 0);
#line 561 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) trans, &_tmp29_);
#line 561 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
#line 562 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_animations_duration;
#line 562 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) trans, (guint) _tmp30_);
#line 563 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) trans, (ClutterAnimatable*) actor);
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = self->priv->_show_hide_trans;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp31_, (ClutterTransition*) trans);
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (actor);
#line 4242 "game.c"
}


static void _game_clear_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 568 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 570 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 570 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 570 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 570 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 571 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 571 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 571 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 571 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 4273 "game.c"
	{
		gint i = 0;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4278 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4285 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 4290 "game.c"
					gint _tmp7_ = 0;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 4296 "game.c"
				}
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4308 "game.c"
				}
				{
					gint j = 0;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4314 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4321 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle* rect = NULL;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							RoundedRectangle* _tmp18_ = NULL;
							RoundedRectangle* _tmp19_ = NULL;
							ClutterActor* _tmp20_ = NULL;
							ClutterActor* _tmp21_ = NULL;
							ClutterActor* _tmp22_ = NULL;
							RoundedRectangle* _tmp23_ = NULL;
							ClutterActor* _tmp24_ = NULL;
							ClutterActor* _tmp25_ = NULL;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 4341 "game.c"
								gint _tmp11_ = 0;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 4347 "game.c"
							}
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4359 "game.c"
							}
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_background;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_background_length1;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_background_length2;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = _g_object_ref0 (_tmp17_);
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rect = _tmp18_;
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = rect;
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp20_ = rounded_rectangle_get_actor (_tmp19_);
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp21_ = _tmp20_;
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_hide (_tmp21_);
#line 577 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp22_ = self->priv->_view;
#line 577 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp23_ = rect;
#line 577 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp24_ = rounded_rectangle_get_actor (_tmp23_);
#line 577 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp25_ = _tmp24_;
#line 577 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_remove_child (_tmp22_, _tmp25_);
#line 574 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (rect);
#line 4397 "game.c"
						}
					}
				}
			}
		}
	}
}


static void _game_clear_foreground (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 582 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 584 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 584 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 584 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 584 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 585 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 585 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 585 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 585 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 4434 "game.c"
	{
		gint i = 0;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4439 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4446 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 4451 "game.c"
					gint _tmp7_ = 0;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 4457 "game.c"
				}
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 587 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4469 "game.c"
				}
				{
					gint j = 0;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4475 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4482 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							TileView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							TileView* _tmp17_ = NULL;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 4493 "game.c"
								gint _tmp11_ = 0;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 4499 "game.c"
							}
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4511 "game.c"
							}
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_foreground_cur;
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_foreground_cur_length1;
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_foreground_cur_length2;
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp17_ != NULL) {
#line 4527 "game.c"
								TileView* tile = NULL;
								TileView** _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp18__length2 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								TileView* _tmp21_ = NULL;
								TileView* _tmp22_ = NULL;
								TileView* _tmp23_ = NULL;
								ClutterActor* _tmp24_ = NULL;
								ClutterActor* _tmp25_ = NULL;
								ClutterActor* _tmp26_ = NULL;
								TileView* _tmp27_ = NULL;
								ClutterActor* _tmp28_ = NULL;
								ClutterActor* _tmp29_ = NULL;
								TileView** _tmp30_ = NULL;
								gint _tmp30__length1 = 0;
								gint _tmp30__length2 = 0;
								gint _tmp31_ = 0;
								gint _tmp32_ = 0;
								TileView* _tmp33_ = NULL;
								TileView** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								gint _tmp34__length2 = 0;
								gint _tmp35_ = 0;
								gint _tmp36_ = 0;
								TileView* _tmp37_ = NULL;
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18_ = self->priv->_foreground_cur;
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18__length1 = self->priv->_foreground_cur_length1;
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18__length2 = self->priv->_foreground_cur_length2;
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp19_ = i;
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp20_ = j;
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_ = _g_object_ref0 (_tmp21_);
#line 590 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								tile = _tmp22_;
#line 591 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = tile;
#line 591 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp23_);
#line 591 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_ = _tmp24_;
#line 591 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								clutter_actor_hide (_tmp25_);
#line 592 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp26_ = self->priv->_view;
#line 592 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = tile;
#line 592 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp27_);
#line 592 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp29_ = _tmp28_;
#line 592 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								clutter_actor_remove_child (_tmp26_, _tmp29_);
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30_ = self->priv->_foreground_cur;
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30__length1 = self->priv->_foreground_cur_length1;
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30__length2 = self->priv->_foreground_cur_length2;
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp31_ = i;
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp32_ = j;
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_]);
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_] = NULL;
#line 593 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34_ = self->priv->_foreground_nxt;
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34__length1 = self->priv->_foreground_nxt_length1;
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34__length2 = self->priv->_foreground_nxt_length2;
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp35_ = i;
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp36_ = j;
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_]);
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = NULL;
#line 594 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
#line 589 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (tile);
#line 4623 "game.c"
							}
						}
					}
				}
			}
		}
	}
}


static void _game_restore_foreground (Game* self, gboolean animate) {
	guint val = 0U;
	GridPosition pos = {0};
	Tile tile = {0};
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GeeLinkedList* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
#line 600 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 606 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 606 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 606 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 606 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 608 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = animate;
#line 608 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_show_hide_transition (self, _tmp6_);
#line 4672 "game.c"
	{
		gint i = 0;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4677 "game.c"
		{
			gboolean _tmp7_ = FALSE;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp7_ = TRUE;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4684 "game.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp7_) {
#line 4689 "game.c"
					gint _tmp8_ = 0;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp8_ = i;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp8_ + 1;
#line 4695 "game.c"
				}
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp7_ = FALSE;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = i;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp10_ = rows;
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 610 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4707 "game.c"
				}
				{
					gint j = 0;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4713 "game.c"
					{
						gboolean _tmp11_ = FALSE;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp11_ = TRUE;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4720 "game.c"
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Grid* _tmp15_ = NULL;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							guint _tmp18_ = 0U;
							guint _tmp19_ = 0U;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp11_) {
#line 4730 "game.c"
								gint _tmp12_ = 0;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp12_ = j;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp12_ + 1;
#line 4736 "game.c"
							}
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp11_ = FALSE;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = j;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = cols;
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp13_ < _tmp14_)) {
#line 611 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4748 "game.c"
							}
#line 612 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = self->priv->_grid;
#line 612 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = i;
#line 612 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = j;
#line 612 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = grid_get (_tmp15_, _tmp16_, _tmp17_);
#line 612 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							val = _tmp18_;
#line 613 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = val;
#line 613 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp19_ != ((guint) 0)) {
#line 4764 "game.c"
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								GridPosition _tmp22_ = {0};
								GridPosition _tmp23_ = {0};
								guint _tmp24_ = 0U;
								Tile _tmp25_ = {0};
								Tile _tmp26_ = {0};
								GeeLinkedList* _tmp27_ = NULL;
								Tile _tmp28_ = {0};
								GridPosition _tmp29_ = {0};
#line 614 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp20_ = i;
#line 614 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp21_ = j;
#line 614 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_.row = (guint) _tmp20_;
#line 614 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_.col = (guint) _tmp21_;
#line 614 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								pos = _tmp22_;
#line 615 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = pos;
#line 615 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = val;
#line 615 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_.pos = _tmp23_;
#line 615 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_.val = _tmp24_;
#line 615 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								tile = _tmp25_;
#line 616 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp26_ = tile;
#line 616 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_game_create_tile (self, &_tmp26_);
#line 617 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = self->priv->_to_show;
#line 617 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp28_ = tile;
#line 617 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, &_tmp28_);
#line 618 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp29_ = pos;
#line 618 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_game_show_tile (self, &_tmp29_);
#line 4809 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 623 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_to_show;
#line 623 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
#line 623 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = _tmp31_;
#line 623 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp32_ > 0) {
#line 4825 "game.c"
		ClutterTransitionGroup* _tmp33_ = NULL;
#line 624 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_RESTORING_TILES;
#line 625 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp33_ = self->priv->_show_hide_trans;
#line 625 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp33_);
#line 4833 "game.c"
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (self) {
#line 4842 "game.c"
		gchar* _tmp0_ = NULL;
#line 38 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4850 "game.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/run/media/triton/Guerre/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4859 "game.c"
	}
}


static void _game_on_move_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Grid* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint delta_score = 0U;
	ClutterTransitionGroup* _tmp8_ = NULL;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	ClutterTransitionGroup* _tmp42_ = NULL;
#line 629 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = is_finished;
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = bool_to_string (_tmp0_);
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_strconcat ("move animation stopped; finished ", _tmp2_, NULL);
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:631: %s", _tmp4_);
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 631 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp2_);
#line 632 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_grid;
#line 632 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_to_string (_tmp5_);
#line 632 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_;
#line 632 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:632: %s", _tmp7_);
#line 632 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp7_);
#line 636 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = self->priv->_move_trans;
#line 636 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_remove_all (_tmp8_);
#line 638 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_show_hide_transition (self, TRUE);
#line 4912 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _e_index = 0;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_to_hide;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp10_;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = _e_list;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = _tmp12_;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp13_;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 4940 "game.c"
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			TileMovement* _tmp20_ = NULL;
			GridPosition _tmp21_ = {0};
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp14_ + 1;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_index;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_size;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 4962 "game.c"
			}
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_list;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = _e_index;
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp19_;
#line 641 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = e;
#line 641 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = (*_tmp20_).from;
#line 641 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_dim_tile (self, &_tmp21_);
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 4980 "game.c"
		}
#line 640 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 4984 "game.c"
	}
#line 644 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	delta_score = (guint) 0;
#line 4988 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _e_index = 0;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp22_ = self->priv->_to_show;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp23_;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _e_list;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = _tmp25_;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp26_;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5016 "game.c"
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			Tile* _tmp33_ = NULL;
			Tile _tmp34_ = {0};
			Tile* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			Tile* _tmp38_ = NULL;
			guint _tmp39_ = 0U;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = _e_index;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp27_ + 1;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_size;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp28_ < _tmp29_)) {
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5043 "game.c"
			}
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_list;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_index;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (Tile*) _tmp32_;
#line 646 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = e;
#line 646 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = *_tmp33_;
#line 646 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_create_tile (self, &_tmp34_);
#line 647 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = e;
#line 647 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = (*_tmp35_).pos;
#line 647 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_show_tile (self, &_tmp36_);
#line 648 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = delta_score;
#line 648 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = e;
#line 648 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp39_ = (*_tmp38_).val;
#line 648 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			delta_score = _tmp37_ + _tmp39_;
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_free0 (e);
#line 5075 "game.c"
		}
#line 645 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5079 "game.c"
	}
#line 650 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_score;
#line 650 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = delta_score;
#line 650 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, _tmp40_ + _tmp41_);
#line 652 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_random_tile (self);
#line 654 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = self->priv->_show_hide_trans;
#line 654 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_start ((ClutterTimeline*) _tmp42_);
#line 5093 "game.c"
}


static gboolean __game_finish_move_gsource_func (gpointer self) {
	gboolean result;
	result = _game_finish_move ((Game*) self);
#line 680 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5102 "game.c"
}


static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	ClutterTransitionGroup* _tmp5_ = NULL;
	ClutterTimelineDirection _tmp6_ = 0;
	ClutterTimelineDirection _tmp7_ = 0;
	Grid* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	ClutterTransitionGroup* _tmp13_ = NULL;
#line 657 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = is_finished;
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = bool_to_string (_tmp0_);
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_strconcat ("show/hide animation stopped; finished ", _tmp2_, NULL);
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:659: %s", _tmp4_);
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 659 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp2_);
#line 661 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_show_hide_trans;
#line 661 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = clutter_timeline_get_direction ((ClutterTimeline*) _tmp5_);
#line 661 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_;
#line 661 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp7_ == CLUTTER_TIMELINE_FORWARD) {
#line 5145 "game.c"
		ClutterTransitionGroup* _tmp8_ = NULL;
		ClutterTransitionGroup* _tmp9_ = NULL;
#line 662 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_show_hide_trans;
#line 662 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_set_direction ((ClutterTimeline*) _tmp8_, CLUTTER_TIMELINE_BACKWARD);
#line 663 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_show_hide_trans;
#line 663 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp9_);
#line 664 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return;
#line 5158 "game.c"
	}
#line 667 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_grid;
#line 667 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = grid_to_string (_tmp10_);
#line 667 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 667 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:667: %s", _tmp12_);
#line 667 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp12_);
#line 669 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_show_hide_trans;
#line 669 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_remove_all (_tmp13_);
#line 5174 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		GeeLinkedList* _tmp15_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _e_index = 0;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = self->priv->_to_hide;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp15_;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp16_ = _e_list;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp18_ = _tmp17_;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp18_;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5202 "game.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			TileView* view = NULL;
			TileView** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			TileMovement* _tmp26_ = NULL;
			GridPosition _tmp27_ = {0};
			guint _tmp28_ = 0U;
			TileMovement* _tmp29_ = NULL;
			GridPosition _tmp30_ = {0};
			guint _tmp31_ = 0U;
			TileView* _tmp32_ = NULL;
			TileView* _tmp33_ = NULL;
			TileView* _tmp34_ = NULL;
			ClutterActor* _tmp35_ = NULL;
			ClutterActor* _tmp36_ = NULL;
			TileView** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp37__length2 = 0;
			TileMovement* _tmp38_ = NULL;
			GridPosition _tmp39_ = {0};
			guint _tmp40_ = 0U;
			TileMovement* _tmp41_ = NULL;
			GridPosition _tmp42_ = {0};
			guint _tmp43_ = 0U;
			TileView* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
			guint _tmp46_ = 0U;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			ClutterActor* _tmp51_ = NULL;
			TileView* _tmp52_ = NULL;
			ClutterActor* _tmp53_ = NULL;
			ClutterActor* _tmp54_ = NULL;
			TileView** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gint _tmp55__length2 = 0;
			TileMovement* _tmp56_ = NULL;
			GridPosition _tmp57_ = {0};
			guint _tmp58_ = 0U;
			TileMovement* _tmp59_ = NULL;
			GridPosition _tmp60_ = {0};
			guint _tmp61_ = 0U;
			TileView* _tmp62_ = NULL;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = _e_index;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp19_ + 1;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = _e_index;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = _e_size;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp20_ < _tmp21_)) {
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5267 "game.c"
			}
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = _e_list;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp23_ = _e_index;
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp24_;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25_ = self->priv->_foreground_cur;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25__length1 = self->priv->_foreground_cur_length1;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25__length2 = self->priv->_foreground_cur_length2;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp26_ = e;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = (*_tmp26_).from;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _tmp27_.row;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = e;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = (*_tmp29_).from;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _tmp30_.col;
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _tmp25_[(_tmp28_ * _tmp25__length2) + _tmp31_];
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 672 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			view = _tmp33_;
#line 673 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = view;
#line 673 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp34_);
#line 673 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = _tmp35_;
#line 673 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			clutter_actor_hide (_tmp36_);
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = self->priv->_foreground_cur;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37__length1 = self->priv->_foreground_cur_length1;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37__length2 = self->priv->_foreground_cur_length2;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = e;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp39_ = (*_tmp38_).from;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp40_ = _tmp39_.row;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp41_ = e;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp42_ = (*_tmp41_).from;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp43_ = _tmp42_.col;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp44_ = _tmp37_[(_tmp40_ * _tmp37__length2) + _tmp43_];
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp45_ = tile_view_get_value (_tmp44_);
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp46_ = _tmp45_;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp47_ = g_strdup_printf ("%u", _tmp46_);
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp48_ = _tmp47_;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp49_ = g_strconcat ("remove child ", _tmp48_, NULL);
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_ = _tmp49_;
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_debug ("game.vala:674: %s", _tmp50_);
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (_tmp50_);
#line 674 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (_tmp48_);
#line 675 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp51_ = self->priv->_view;
#line 675 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp52_ = view;
#line 675 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp53_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp52_);
#line 675 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp54_ = _tmp53_;
#line 675 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			clutter_actor_remove_child (_tmp51_, _tmp54_);
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_ = self->priv->_foreground_cur;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55__length1 = self->priv->_foreground_cur_length1;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55__length2 = self->priv->_foreground_cur_length2;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp56_ = e;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57_ = (*_tmp56_).from;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp58_ = _tmp57_.row;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp59_ = e;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp60_ = (*_tmp59_).from;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp61_ = _tmp60_.col;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_]);
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_] = NULL;
#line 677 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp62_ = _tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_];
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (view);
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 5385 "game.c"
		}
#line 671 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5389 "game.c"
	}
#line 680 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __game_finish_move_gsource_func, g_object_ref (self), g_object_unref);
#line 5393 "game.c"
}


static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
#line 686 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_show_hide_trans_stopped ((Game*) self, is_finished);
#line 5400 "game.c"
}


static void _game_create_show_hide_transition (Game* self, gboolean animate) {
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	ClutterTransitionGroup* _tmp5_ = NULL;
#line 683 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 685 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 685 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_show_hide_trans);
#line 685 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_show_hide_trans = _tmp0_;
#line 686 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_show_hide_trans;
#line 686 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_show_hide_trans_stopped_clutter_timeline_stopped, self, 0);
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = animate;
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp3_) {
#line 5426 "game.c"
		gint _tmp4_ = 0;
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_animations_duration;
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = _tmp4_;
#line 5432 "game.c"
	} else {
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = 10;
#line 5436 "game.c"
	}
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_show_hide_trans;
#line 687 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp5_, (guint) _tmp2_);
#line 5442 "game.c"
}


static gboolean _game_finish_move (Game* self) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	GeeLinkedList* _tmp75_ = NULL;
	GeeLinkedList* _tmp76_ = NULL;
	GeeLinkedList* _tmp77_ = NULL;
	Grid* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	Grid* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
#line 690 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 692 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_state;
#line 692 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
#line 693 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_SHOWING_SECOND_TILE;
#line 694 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_debug ("game.vala:694: state show second tile");
#line 695 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_random_tile (self);
#line 5469 "game.c"
	} else {
		GameGameState _tmp1_ = 0;
#line 696 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp1_ = self->priv->_state;
#line 696 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp1_ == GAME_GAME_STATE_SHOWING_SECOND_TILE) {
#line 697 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			self->priv->_state = GAME_GAME_STATE_IDLE;
#line 698 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_debug ("game.vala:698: state idle");
#line 5480 "game.c"
		} else {
			GameGameState _tmp2_ = 0;
#line 699 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp2_ = self->priv->_state;
#line 699 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_tmp2_ != GAME_GAME_STATE_IDLE) {
#line 700 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				self->priv->_state = GAME_GAME_STATE_IDLE;
#line 701 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				g_debug ("game.vala:701: state idle");
#line 5491 "game.c"
			}
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _e_index = 0;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = self->priv->_to_move;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp4_;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = _e_list;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = _tmp6_;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp7_;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5522 "game.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			TileView** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			TileMovement* _tmp15_ = NULL;
			GridPosition _tmp16_ = {0};
			guint _tmp17_ = 0U;
			TileMovement* _tmp18_ = NULL;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			TileView** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			TileMovement* _tmp22_ = NULL;
			GridPosition _tmp23_ = {0};
			guint _tmp24_ = 0U;
			TileMovement* _tmp25_ = NULL;
			GridPosition _tmp26_ = {0};
			guint _tmp27_ = 0U;
			TileView* _tmp28_ = NULL;
			TileView* _tmp29_ = NULL;
			TileView* _tmp30_ = NULL;
			TileView** _tmp31_ = NULL;
			gint _tmp31__length1 = 0;
			gint _tmp31__length2 = 0;
			TileMovement* _tmp32_ = NULL;
			GridPosition _tmp33_ = {0};
			guint _tmp34_ = 0U;
			TileMovement* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			TileView* _tmp38_ = NULL;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp8_ = _e_index;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp8_ + 1;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp9_ = _e_index;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp10_ = _e_size;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5573 "game.c"
			}
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp11_ = _e_list;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp12_ = _e_index;
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp13_;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = self->priv->_foreground_cur;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14__length1 = self->priv->_foreground_cur_length1;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14__length2 = self->priv->_foreground_cur_length2;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = e;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = (*_tmp15_).to;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _tmp16_.row;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = e;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = (*_tmp18_).to;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = _tmp19_.col;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = self->priv->_foreground_nxt;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21__length1 = self->priv->_foreground_nxt_length1;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21__length2 = self->priv->_foreground_nxt_length2;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = e;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp23_ = (*_tmp22_).to;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp24_ = _tmp23_.row;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25_ = e;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp26_ = (*_tmp25_).to;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = _tmp26_.col;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _tmp21_[(_tmp24_ * _tmp21__length2) + _tmp27_];
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _g_object_ref0 (_tmp28_);
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_]);
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_] = _tmp29_;
#line 705 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_];
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = self->priv->_foreground_nxt;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31__length1 = self->priv->_foreground_nxt_length1;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31__length2 = self->priv->_foreground_nxt_length2;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = e;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = (*_tmp32_).to;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = _tmp33_.row;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = e;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = (*_tmp35_).to;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = _tmp36_.col;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_]);
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_] = NULL;
#line 706 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = _tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_];
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 5655 "game.c"
		}
#line 704 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5659 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp39_ = NULL;
		GeeLinkedList* _tmp40_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		gint _e_index = 0;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = self->priv->_to_show;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp40_;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp41_ = _e_list;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp42_;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp43_;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5688 "game.c"
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gpointer _tmp49_ = NULL;
			TileView** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gint _tmp50__length2 = 0;
			Tile* _tmp51_ = NULL;
			GridPosition _tmp52_ = {0};
			guint _tmp53_ = 0U;
			Tile* _tmp54_ = NULL;
			GridPosition _tmp55_ = {0};
			guint _tmp56_ = 0U;
			TileView** _tmp57_ = NULL;
			gint _tmp57__length1 = 0;
			gint _tmp57__length2 = 0;
			Tile* _tmp58_ = NULL;
			GridPosition _tmp59_ = {0};
			guint _tmp60_ = 0U;
			Tile* _tmp61_ = NULL;
			GridPosition _tmp62_ = {0};
			guint _tmp63_ = 0U;
			TileView* _tmp64_ = NULL;
			TileView* _tmp65_ = NULL;
			TileView* _tmp66_ = NULL;
			TileView** _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			Tile* _tmp68_ = NULL;
			GridPosition _tmp69_ = {0};
			guint _tmp70_ = 0U;
			Tile* _tmp71_ = NULL;
			GridPosition _tmp72_ = {0};
			guint _tmp73_ = 0U;
			TileView* _tmp74_ = NULL;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp44_ = _e_index;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp44_ + 1;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp45_ = _e_index;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp46_ = _e_size;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp45_ < _tmp46_)) {
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5739 "game.c"
			}
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp47_ = _e_list;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp48_ = _e_index;
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (Tile*) _tmp49_;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_ = self->priv->_foreground_cur;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50__length1 = self->priv->_foreground_cur_length1;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50__length2 = self->priv->_foreground_cur_length2;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp51_ = e;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp52_ = (*_tmp51_).pos;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp53_ = _tmp52_.row;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp54_ = e;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_ = (*_tmp54_).pos;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp56_ = _tmp55_.col;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57_ = self->priv->_foreground_nxt;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57__length1 = self->priv->_foreground_nxt_length1;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57__length2 = self->priv->_foreground_nxt_length2;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp58_ = e;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp59_ = (*_tmp58_).pos;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp60_ = _tmp59_.row;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp61_ = e;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp62_ = (*_tmp61_).pos;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp63_ = _tmp62_.col;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp64_ = _tmp57_[(_tmp60_ * _tmp57__length2) + _tmp63_];
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp65_ = _g_object_ref0 (_tmp64_);
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_]);
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_] = _tmp65_;
#line 709 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp66_ = _tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_];
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67_ = self->priv->_foreground_nxt;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67__length1 = self->priv->_foreground_nxt_length1;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67__length2 = self->priv->_foreground_nxt_length2;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp68_ = e;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp69_ = (*_tmp68_).pos;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp70_ = _tmp69_.row;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp71_ = e;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp72_ = (*_tmp71_).pos;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp73_ = _tmp72_.col;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_]);
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_] = NULL;
#line 710 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp74_ = _tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_];
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_free0 (e);
#line 5821 "game.c"
		}
#line 708 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5825 "game.c"
	}
#line 713 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp75_ = self->priv->_to_hide;
#line 713 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp75_);
#line 714 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp76_ = self->priv->_to_move;
#line 714 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
#line 715 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp77_ = self->priv->_to_show;
#line 715 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
#line 717 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp78_ = self->priv->_grid;
#line 717 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp79_ = grid_get_target_value_reached (_tmp78_);
#line 717 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp80_ = _tmp79_;
#line 717 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp80_) {
#line 5847 "game.c"
		Grid* _tmp81_ = NULL;
		guint _tmp82_ = 0U;
		guint _tmp83_ = 0U;
		Grid* _tmp84_ = NULL;
#line 718 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp81_ = self->priv->_grid;
#line 718 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp82_ = grid_get_target_value (_tmp81_);
#line 718 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp83_ = _tmp82_;
#line 718 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "target-value-reached", _tmp83_);
#line 719 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp84_ = self->priv->_grid;
#line 719 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		grid_set_target_value_reached (_tmp84_, FALSE);
#line 5864 "game.c"
	}
#line 722 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp85_ = self->priv->_grid;
#line 722 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp86_ = grid_is_finished (_tmp85_);
#line 722 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp86_) {
#line 723 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "finished");
#line 5874 "game.c"
	}
#line 725 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 725 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5880 "game.c"
}


static void _game_store_movement (Game* self) {
	gboolean _tmp0_ = FALSE;
#line 728 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 730 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_allow_undo;
#line 730 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_) {
#line 5892 "game.c"
		GeeLinkedList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		guint _tmp4_ = 0U;
		GeeLinkedList* _tmp8_ = NULL;
		Grid* _tmp9_ = NULL;
		Grid* _tmp10_ = NULL;
		Grid* _tmp11_ = NULL;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 731 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp1_ = self->priv->_undo_stack;
#line 731 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 731 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = _tmp2_;
#line 731 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_undo_stack_max_size;
#line 731 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (((guint) _tmp3_) == _tmp4_) {
#line 5914 "game.c"
			GeeLinkedList* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			Grid* _tmp7_ = NULL;
#line 732 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp5_ = self->priv->_undo_stack;
#line 732 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) _tmp5_);
#line 732 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp7_ = (Grid*) _tmp6_;
#line 732 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp7_);
#line 5926 "game.c"
		}
#line 733 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_undo_stack;
#line 733 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_grid;
#line 733 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = grid_clone (_tmp9_);
#line 733 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = _tmp10_;
#line 733 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_deque_offer_head ((GeeDeque*) _tmp8_, _tmp11_);
#line 733 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_tmp11_);
#line 734 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = self->priv->_undo_stack;
#line 734 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 734 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = _tmp13_;
#line 734 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp14_ == 1) {
#line 735 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_signal_emit_by_name (self, "undo-enabled");
#line 5950 "game.c"
		}
	}
}


ClutterActor* game_get_view (Game* self) {
	ClutterActor* result;
	ClutterActor* _tmp0_ = NULL;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_view;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5967 "game.c"
}


static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_allocation_changed ((Game*) self, box, flags);
#line 5974 "game.c"
}


void game_set_view (Game* self, ClutterActor* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = value;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_view);
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_view = _tmp1_;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_view;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object (_tmp2_, "allocation-changed", (GCallback) __game_on_allocation_changed_clutter_actor_allocation_changed, self, 0);
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_notify ((GObject *) self, "view");
#line 5998 "game.c"
}


guint game_get_score (Game* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_score;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 6013 "game.c"
}


void game_set_score (Game* self, guint value) {
	guint _tmp0_ = 0U;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = value;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_score = _tmp0_;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_notify ((GObject *) self, "score");
#line 6027 "game.c"
}


static void game_class_init (GameClass * klass) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW, g_param_spec_object ("view", "view", "view", clutter_actor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE, g_param_spec_uint ("score", "score", "score", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("finished", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("target_value_reached", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("undo_enabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("undo_disabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6054 "game.c"
}


static void game_instance_init (Game * self) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->BLANK_ROW_HEIGHT = 10;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->BLANK_COL_WIDTH = 10;
#line 6065 "game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_view);
#line 39 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
#line 43 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_move);
#line 44 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_hide);
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_show);
#line 48 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_show_hide_trans);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 54 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_undo_stack);
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_settings);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (self->priv->_saved_path);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 6101 "game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	switch (property_id) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_VIEW:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_value_set_object (value, game_get_view (self));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_SCORE:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_value_set_uint (value, game_get_score (self));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6134 "game.c"
		default:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6140 "game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
	switch (property_id) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_VIEW:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		game_set_view (self, g_value_get_object (value));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_SCORE:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		game_set_score (self, g_value_get_uint (value));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6162 "game.c"
		default:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6168 "game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



