/* application.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from application.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgames-support.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <locale.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* _settings;
	GtkWindow* _window;
	GtkHeaderBar* _header_bar;
	GtkButton* _undo_button;
	GtkButton* _new_game_button;
	GtkAboutDialog* _about_dialog;
	GtkDialog* _preferences_dialog;
	GtkDialog* _congrats_dialog;
	GtkLabel* _congrats_message;
	GtkLabel* _score;
	GtkComboBoxText* _grid_size_combo;
	GamesScoresContext* _scores_ctx;
	GamesScoresCategory* _grid4_cat;
	GamesScoresCategory* _grid5_cat;
	gboolean _game_restored;
	gint _window_width;
	gint _window_height;
	gboolean _window_maximized;
	gint WINDOW_MINIMUM_SIZE_HEIGHT;
	gint WINDOW_MINIMUM_SIZE_WIDTH;
	Game* _game;
};


static gpointer application_parent_class = NULL;

GType application_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static void application_new_game_cb (Application* self);
static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_undo_cb (Application* self);
static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_scores_cb (Application* self);
static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_about_cb (Application* self);
static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_preferences_cb (Application* self);
static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_quit_cb (Application* self);
static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_help_cb (Application* self);
static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Application* application_new (void);
Application* application_construct (GType object_type);
static void application_real_startup (GApplication* base);
static void _application_init_style (Application* self);
static void _application_init_app_menu (Application* self);
static void _application_init_game (Application* self);
static void application_real_activate (GApplication* base);
static void _application_create_window (Application* self, GtkBuilder* builder);
static void _application_create_about_dialog (Application* self);
static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder);
static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder);
static void _application_create_scores (Application* self);
gboolean game_restore_game (Game* self);
static void application_real_shutdown (GApplication* base);
void game_save_game (Game* self);
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
static void __lambda4_ (Application* self, GObject* s, GParamSpec* p);
guint game_get_score (Game* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (Application* self, Game* s);
static void ___lambda6_ (Application* self, GObject* object, GAsyncResult* _result_);
static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda5__game_finished (Game* _sender, gpointer self);
static void __lambda7_ (Application* self, Game* s, guint v);
static void ___lambda7__game_target_value_reached (Game* _sender, guint val, gpointer self);
static void __lambda8_ (Application* self, Game* s);
static void ___lambda8__game_undo_enabled (Game* _sender, gpointer self);
static void __lambda9_ (Application* self, Game* s);
static void ___lambda9__game_undo_disabled (Game* _sender, gpointer self);
static void _application_create_header_bar (Application* self);
static void _application_create_game_view (Application* self, GtkBuilder* builder);
static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean application_window_configure_event_cb (Application* self, GdkEventConfigure* event);
static gboolean _application_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event);
static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
void game_set_view (Game* self, ClutterActor* value);
static void __lambda10_ (Application* self, gint response_id);
static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda11_ (Application* self, GdkEventAny* response_id);
static gboolean ___lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda12_ (Application* self, gint response_id);
static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda13_ (Application* self, GdkEventAny* response_id);
gboolean game_reload_settings (Game* self);
static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda14_ (Application* self, gint response_id);
static void ___lambda14__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda15_ (Application* self, GdkEventAny* response_id);
static gboolean ___lambda15__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static GamesScoresCategory* application_category_request (Application* self, const gchar* key);
static GamesScoresCategory* _application_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
void game_new_game (Game* self);
void game_undo (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
gint application_main (gchar** args, int args_length1);
static void application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_action_entries[7] = {{"new-game", _application_new_game_cb_gsimple_action_activate_callback}, {"undo", _application_undo_cb_gsimple_action_activate_callback}, {"scores", _application_scores_cb_gsimple_action_activate_callback}, {"about", _application_about_cb_gsimple_action_activate_callback}, {"preferences", _application_preferences_cb_gsimple_action_activate_callback}, {"quit", _application_quit_cb_gsimple_action_activate_callback}, {"help", _application_help_cb_gsimple_action_activate_callback}};

static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_new_game_cb ((Application*) self);
#line 186 "application.c"
}


static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_undo_cb ((Application*) self);
#line 193 "application.c"
}


static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_scores_cb ((Application*) self);
#line 200 "application.c"
}


static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_about_cb ((Application*) self);
#line 207 "application.c"
}


static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_preferences_cb ((Application*) self);
#line 214 "application.c"
}


static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_quit_cb ((Application*) self);
#line 221 "application.c"
}


static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_help_cb ((Application*) self);
#line 228 "application.c"
}


Application* application_construct (GType object_type) {
	Application * self = NULL;
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.gnome-2048", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return self;
#line 238 "application.c"
}


Application* application_new (void) {
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return application_construct (TYPE_APPLICATION);
#line 245 "application.c"
}


static void application_real_startup (GApplication* base) {
	Application * self;
	GSettings* _tmp0_ = NULL;
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) base;
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_APPLICATION_CLASS (application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_action_map_add_action_entries ((GActionMap*) self, APPLICATION_action_entries, G_N_ELEMENTS (APPLICATION_action_entries), self);
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_settings_new ("org.gnome.2048");
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_settings);
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_settings = _tmp0_;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_init_style (self);
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_init_app_menu (self);
#line 78 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_init_game (self);
#line 272 "application.c"
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) base;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_APPLICATION_CLASS (application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = gtk_builder_new ();
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	builder = _tmp0_;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = builder;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_window (self, _tmp1_);
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_about_dialog (self);
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = builder;
#line 88 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_preferences_dialog (self, _tmp2_);
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = builder;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_congrats_dialog (self, _tmp3_);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_scores (self);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_window;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_game;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = game_restore_game (_tmp5_);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game_restored = _tmp6_;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_game_restored;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (!_tmp7_) {
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		application_new_game_cb (self);
#line 327 "application.c"
	}
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (builder);
#line 331 "application.c"
}


static void application_real_shutdown (GApplication* base) {
	Application * self;
	Game* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 100 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = (Application*) base;
#line 102 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_APPLICATION_CLASS (application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_game;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_save_game (_tmp0_);
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_settings;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_window_width;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp1_, "window-width", _tmp2_);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_settings;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_window_height;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp3_, "window-height", _tmp4_);
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_settings;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_window_maximized;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_boolean (_tmp5_, "window-maximized", _tmp6_);
#line 370 "application.c"
}


static void _application_init_style (Application* self) {
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	provider = _tmp0_;
#line 384 "application.c"
	{
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GdkScreen* _tmp3_ = NULL;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = g_file_new_for_uri ("resource://org/gnome/gnome-2048/data/style.css");
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = _tmp1_;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_css_provider_load_from_file (provider, _tmp2_, &_inner_error_);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (_tmp2_);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 399 "application.c"
			goto __catch0_g_error;
		}
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = gdk_screen_get_default ();
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 406 "application.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = stderr;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = e;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp6_ = _tmp5_->message;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp4_, "%s\n", _tmp6_);
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 429 "application.c"
	}
	__finally0:
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (provider);
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 442 "application.c"
	}
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (provider);
#line 446 "application.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return self ? g_object_ref (self) : NULL;
#line 453 "application.c"
}


static void _application_init_app_menu (Application* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = gtk_builder_new ();
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	builder = _tmp0_;
#line 467 "application.c"
	{
		GMenuModel* menu = NULL;
		GObject* _tmp1_ = NULL;
		GMenuModel* _tmp2_ = NULL;
		GMenuModel* _tmp3_ = NULL;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (builder, "/org/gnome/gnome-2048/data/menus.ui", &_inner_error_);
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 477 "application.c"
			goto __catch1_g_error;
		}
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = gtk_builder_get_object (builder, "app-menu");
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp1_) : NULL);
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		menu = _tmp2_;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = menu;
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp3_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (menu);
#line 492 "application.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = stderr;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = e;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp6_ = _tmp5_->message;
#line 133 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp4_, "%s\n", _tmp6_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 515 "application.c"
	}
	__finally1:
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (builder);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 528 "application.c"
	}
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (builder);
#line 532 "application.c"
}


static void __lambda4_ (Application* self, GObject* s, GParamSpec* p) {
	GtkLabel* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (p != NULL);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_score;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_game;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = game_get_score (_tmp1_);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = _tmp2_;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = _tmp4_;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_label_set_label (_tmp0_, _tmp5_);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_free0 (_tmp5_);
#line 563 "application.c"
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda4_ ((Application*) self, _sender, pspec);
#line 570 "application.c"
}


static void ___lambda6_ (Application* self, GObject* object, GAsyncResult* _result_) {
	GAction* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (_result_ != NULL);
#line 579 "application.c"
	{
		GamesScoresContext* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = self->priv->_scores_ctx;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = _result_;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 591 "application.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = stderr;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = e;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = _tmp3_->message;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp2_, "%s\n", _tmp4_);
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 616 "application.c"
	}
	__finally2:
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 627 "application.c"
	}
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "scores");
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_debug ("application.vala:155: score added");
#line 635 "application.c"
}


static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	___lambda6_ ((Application*) self, source_object, res);
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_unref (self);
#line 644 "application.c"
}


static void __lambda5_ (Application* self, Game* s) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_header_bar;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = _ ("Game Over");
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_subtitle (_tmp0_, _tmp1_);
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_game_restored;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (!_tmp2_) {
#line 664 "application.c"
		GamesScoresCategory* _tmp3_ = NULL;
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GamesScoresCategory* cat = NULL;
		GamesScoresCategory* _tmp8_ = NULL;
		GamesScoresContext* _tmp9_ = NULL;
		Game* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		GamesScoresCategory* _tmp13_ = NULL;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = self->priv->_settings;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = g_settings_get_int (_tmp4_, "rows");
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (_tmp5_ == 4) {
#line 681 "application.c"
			GamesScoresCategory* _tmp6_ = NULL;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp6_ = self->priv->_grid4_cat;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp3_ = _tmp6_;
#line 687 "application.c"
		} else {
			GamesScoresCategory* _tmp7_ = NULL;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp7_ = self->priv->_grid5_cat;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp3_ = _tmp7_;
#line 694 "application.c"
		}
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp8_ = _g_object_ref0 (_tmp3_);
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		cat = _tmp8_;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp9_ = self->priv->_scores_ctx;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = self->priv->_game;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp11_ = game_get_score (_tmp10_);
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp12_ = _tmp11_;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp13_ = cat;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		games_scores_context_add_score (_tmp9_, (glong) _tmp12_, _tmp13_, NULL, ____lambda6__gasync_ready_callback, g_object_ref (self));
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (cat);
#line 714 "application.c"
	}
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_debug ("application.vala:159: finished");
#line 718 "application.c"
}


static void ___lambda5__game_finished (Game* _sender, gpointer self) {
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda5_ ((Application*) self, _sender);
#line 725 "application.c"
}


static void __lambda7_ (Application* self, Game* s, guint v) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_settings;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "do-congrat");
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp1_) {
#line 740 "application.c"
		gchar* message = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GSettings* _tmp7_ = NULL;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = _ ("You have obtained the $v tile");
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		message = _tmp3_;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = self->priv->_congrats_message;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = message;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_label_set_text (_tmp4_, _tmp5_);
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp6_ = self->priv->_congrats_dialog;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_window_present ((GtkWindow*) _tmp6_);
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp7_ = self->priv->_settings;
#line 166 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_settings_set_boolean (_tmp7_, "do-congrat", FALSE);
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_free0 (message);
#line 770 "application.c"
	}
#line 168 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_debug ("application.vala:168: target value reached");
#line 774 "application.c"
}


static void ___lambda7__game_target_value_reached (Game* _sender, guint val, gpointer self) {
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda7_ ((Application*) self, _sender, val);
#line 781 "application.c"
}


static void __lambda8_ (Application* self, Game* s) {
	GAction* _tmp0_ = NULL;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 171 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 793 "application.c"
}


static void ___lambda8__game_undo_enabled (Game* _sender, gpointer self) {
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda8_ ((Application*) self, _sender);
#line 800 "application.c"
}


static void __lambda9_ (Application* self, Game* s) {
	GAction* _tmp0_ = NULL;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (s != NULL);
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 174 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 812 "application.c"
}


static void ___lambda9__game_undo_disabled (Game* _sender, gpointer self) {
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda9_ ((Application*) self, _sender);
#line 819 "application.c"
}


static void _application_init_game (Application* self) {
	GSettings* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_settings;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = game_new (_tmp0_);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_game);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game = _tmp1_;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_game;
#line 140 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::score", (GCallback) ___lambda4__g_object_notify, self, 0);
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_game;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp3_, "finished", (GCallback) ___lambda5__game_finished, self, 0);
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_game;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp4_, "target-value-reached", (GCallback) ___lambda7__game_target_value_reached, self, 0);
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_game;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp5_, "undo-enabled", (GCallback) ___lambda8__game_undo_enabled, self, 0);
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_game;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp6_, "undo-disabled", (GCallback) ___lambda9__game_undo_disabled, self, 0);
#line 861 "application.c"
}


static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = application_key_press_event_cb ((Application*) self, _sender, event);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 870 "application.c"
}


static gboolean _application_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = application_window_configure_event_cb ((Application*) self, event);
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 879 "application.c"
}


static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = application_window_state_event_cb ((Application*) self, event);
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 888 "application.c"
}


static void _application_create_window (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GtkWindow* _tmp15_ = NULL;
	GtkBuilder* _tmp16_ = NULL;
	GtkWindow* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkWindow* _tmp20_ = NULL;
	GtkWindow* _tmp21_ = NULL;
	GtkWindow* _tmp22_ = NULL;
	GdkGeometry geom = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GtkWindow* _tmp25_ = NULL;
	GtkWindow* _tmp26_ = NULL;
	GdkGeometry _tmp27_ = {0};
	GError * _inner_error_ = NULL;
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 178 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 922 "application.c"
	{
		GtkBuilder* _tmp0_ = NULL;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = builder;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/mainwindow.ui", &_inner_error_);
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 931 "application.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = stderr;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = e;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->message;
#line 183 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp1_, "%s\n", _tmp3_);
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 956 "application.c"
	}
	__finally3:
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 180 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 967 "application.c"
	}
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_builder_get_object (_tmp4_, "applicationwindow");
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _g_object_ref0 ((GtkWindow*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp5_) : NULL));
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_window);
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_window = _tmp6_;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_window;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_settings;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = g_settings_get_int (_tmp8_, "window-width");
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = self->priv->_settings;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "window-height");
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_default_size (_tmp7_, _tmp9_, _tmp11_);
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = self->priv->_settings;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = g_settings_get_boolean (_tmp12_, "window-maximized");
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp13_) {
#line 997 "application.c"
		GtkWindow* _tmp14_ = NULL;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp14_ = self->priv->_window;
#line 189 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_window_maximize (_tmp14_);
#line 1003 "application.c"
	}
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = self->priv->_window;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_application_add_window ((GtkApplication*) self, _tmp15_);
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_header_bar (self);
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = builder;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_application_create_game_view (self, _tmp16_);
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_window;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = self->priv->_window;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = gtk_widget_get_events ((GtkWidget*) _tmp18_);
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_set_events ((GtkWidget*) _tmp17_, ((_tmp19_ | GDK_STRUCTURE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK);
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20_ = self->priv->_window;
#line 197 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp20_, "key-press-event", (GCallback) _application_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp21_ = self->priv->_window;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp21_, "configure-event", (GCallback) _application_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp22_ = self->priv->_window;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp22_, "window-state-event", (GCallback) _application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 201 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	memset (&geom, 0, sizeof (GdkGeometry));
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp23_ = self->priv->WINDOW_MINIMUM_SIZE_HEIGHT;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	geom.min_height = _tmp23_;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp24_ = self->priv->WINDOW_MINIMUM_SIZE_WIDTH;
#line 203 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	geom.min_width = _tmp24_;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp25_ = self->priv->_window;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp26_ = self->priv->_window;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp27_ = geom;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_geometry_hints (_tmp25_, (GtkWidget*) _tmp26_, &_tmp27_, GDK_HINT_MIN_SIZE);
#line 1053 "application.c"
}


static void _application_create_header_bar (Application* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkHeaderBar* _tmp1_ = NULL;
	GtkHeaderBar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkHeaderBar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkHeaderBar* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkHeaderBar* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = (GtkHeaderBar*) gtk_header_bar_new ();
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp0_);
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_header_bar);
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_header_bar = _tmp0_;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_header_bar;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_show_close_button (_tmp1_, TRUE);
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_header_bar;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_title (_tmp2_, "2048");
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_window;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_header_bar;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_titlebar (_tmp3_, (GtkWidget*) _tmp4_);
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = (GtkLabel*) gtk_label_new ("0");
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp5_);
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_score);
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_score = _tmp5_;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_header_bar;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_score;
#line 215 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_pack_end (_tmp6_, (GtkWidget*) _tmp7_);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp8_);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_undo_button);
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_undo_button = _tmp8_;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_undo_button;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp9_, "app.undo");
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = self->priv->_header_bar;
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = self->priv->_undo_button;
#line 219 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_pack_start (_tmp10_, (GtkWidget*) _tmp11_);
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = _ ("New Game");
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_tmp13_);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp14_);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_new_game_button);
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_new_game_button = _tmp14_;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = self->priv->_new_game_button;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_actionable_set_action_name ((GtkActionable*) _tmp15_, "app.new-game");
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = self->priv->_header_bar;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_new_game_button;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_pack_start (_tmp16_, (GtkWidget*) _tmp17_);
#line 1156 "application.c"
}


static void _application_create_game_view (Application* self, GtkBuilder* builder) {
	GtkClutterEmbed* embed = NULL;
	GtkClutterEmbed* _tmp0_ = NULL;
	GtkAspectFrame* frame = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkAspectFrame* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = (GtkClutterEmbed*) gtk_clutter_embed_new ();
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp0_);
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	embed = _tmp0_;
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = builder;
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = gtk_builder_get_object (_tmp1_, "aspectframe");
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_aspect_frame_get_type ()) ? ((GtkAspectFrame*) _tmp2_) : NULL);
#line 230 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	frame = _tmp3_;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) embed);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_game;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_clutter_embed_get_stage (embed);
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_set_view (_tmp4_, _tmp5_);
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (frame);
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (embed);
#line 1199 "application.c"
}


static void __lambda10_ (Application* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_about_dialog;
#line 254 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 1209 "application.c"
}


static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda10_ ((Application*) self, response_id);
#line 1216 "application.c"
}


static gboolean __lambda11_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	GtkAboutDialog* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (response_id != NULL, FALSE);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_about_dialog;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp1_;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1234 "application.c"
}


static gboolean ___lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda11_ ((Application*) self, event);
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1243 "application.c"
}


static void _application_create_about_dialog (Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkAboutDialog* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	GtkAboutDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	GtkAboutDialog* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	GtkAboutDialog* _tmp19_ = NULL;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_object_ref_sink (_tmp0_);
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_about_dialog);
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_about_dialog = _tmp0_;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_about_dialog;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_window;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp1_, _tmp2_);
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_about_dialog;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp3_, TRUE);
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = self->priv->_about_dialog;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_about_dialog;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_program_name (_tmp5_, "2048");
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = self->priv->_about_dialog;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_logo_icon_name (_tmp6_, "gnome-2048");
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_about_dialog;
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = _ ("A clone of 2048 for GNOME");
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_comments (_tmp7_, _tmp8_);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_about_dialog;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = g_strdup ("Juan R. García Blanco");
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = g_new0 (gchar*, 1 + 1);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_[0] = _tmp10_;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = _tmp11_;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12__length1 = 1;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_authors (_tmp9_, _tmp12_);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = self->priv->_about_dialog;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_copyright (_tmp13_, "Copyright © 2014-2015 Juan R. García Blanco");
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp14_ = self->priv->_about_dialog;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_version (_tmp14_, VERSION);
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = self->priv->_about_dialog;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_website (_tmp15_, "http://www.gnome.org");
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = self->priv->_about_dialog;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_license_type (_tmp16_, GTK_LICENSE_GPL_3_0);
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_about_dialog;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_about_dialog_set_wrap_license (_tmp17_, FALSE);
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = self->priv->_about_dialog;
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda10__gtk_dialog_response, self, 0);
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = self->priv->_about_dialog;
#line 256 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp19_, "delete-event", (GCallback) ___lambda11__gtk_widget_delete_event, self, 0);
#line 1351 "application.c"
}


static void __lambda12_ (Application* self, gint response_id) {
	GtkDialog* _tmp0_ = NULL;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_preferences_dialog;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
#line 1361 "application.c"
}


static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda12_ ((Application*) self, response_id);
#line 1368 "application.c"
}


static gboolean __lambda13_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	gint grid_size = 0;
	gint rows = 0;
	gint cols = 0;
	gboolean settings_changed = FALSE;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Game* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkDialog* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (response_id != NULL, FALSE);
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_grid_size_combo;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	grid_size = _tmp1_;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = grid_size;
#line 283 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp2_ == 0) {
#line 1402 "application.c"
		gint _tmp3_ = 0;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		cols = 4;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = cols;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		rows = _tmp3_;
#line 1410 "application.c"
	} else {
		gint _tmp4_ = 0;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		cols = 5;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = cols;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		rows = _tmp4_;
#line 1419 "application.c"
	}
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_settings;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = rows;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp5_, "rows", _tmp6_);
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_settings;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = cols;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_set_int (_tmp7_, "cols", _tmp8_);
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_game;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = game_reload_settings (_tmp9_);
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	settings_changed = _tmp10_;
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = settings_changed;
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp11_) {
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		application_new_game_cb (self);
#line 1445 "application.c"
	}
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = self->priv->_preferences_dialog;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp12_);
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp13_;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1455 "application.c"
}


static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda13_ ((Application*) self, event);
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1464 "application.c"
}


static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GtkComboBoxText* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 261 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 1493 "application.c"
	{
		GtkBuilder* _tmp0_ = NULL;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = builder;
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/preferences.ui", &_inner_error_);
#line 264 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1502 "application.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = stderr;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = e;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->message;
#line 266 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp1_, "%s\n", _tmp3_);
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 1527 "application.c"
	}
	__finally4:
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 1538 "application.c"
	}
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_builder_get_object (_tmp4_, "preferencesdialog");
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_preferences_dialog);
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_preferences_dialog = _tmp6_;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_preferences_dialog;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_window;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = builder;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = gtk_builder_get_object (_tmp9_, "gridsizecombo");
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_combo_box_text_get_type ()) ? ((GtkComboBoxText*) _tmp10_) : NULL);
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid_size_combo);
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_grid_size_combo = _tmp11_;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = self->priv->_preferences_dialog;
#line 274 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp12_, "response", (GCallback) ___lambda12__gtk_dialog_response, self, 0);
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = self->priv->_preferences_dialog;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp13_, "delete-event", (GCallback) ___lambda13__gtk_widget_delete_event, self, 0);
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp14_ = self->priv->_settings;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp15_ = builder;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "congratswitch");
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_bind (_tmp14_, "do-congrat", _tmp16_, "active", G_SETTINGS_BIND_DEFAULT);
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp17_ = self->priv->_settings;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = builder;
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "animationsspeed");
#line 299 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_bind (_tmp17_, "animations-speed", _tmp19_, "value", G_SETTINGS_BIND_DEFAULT);
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20_ = self->priv->_settings;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp21_ = builder;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "undoswitch");
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_settings_bind (_tmp20_, "allow-undo", _tmp22_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1598 "application.c"
}


static void __lambda14_ (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkDialog* _tmp1_ = NULL;
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = response_id;
#line 315 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp0_ == 0) {
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		application_new_game_cb (self);
#line 1611 "application.c"
	}
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_congrats_dialog;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1617 "application.c"
}


static void ___lambda14__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	__lambda14_ ((Application*) self, response_id);
#line 1624 "application.c"
}


static gboolean __lambda15_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (response_id != NULL, FALSE);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_congrats_dialog;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp1_;
#line 320 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1642 "application.c"
}


static gboolean ___lambda15__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda15_ ((Application*) self, event);
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1651 "application.c"
}


static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (builder != NULL);
#line 1671 "application.c"
	{
		GtkBuilder* _tmp0_ = NULL;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = builder;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/congrats.ui", &_inner_error_);
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1680 "application.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = stderr;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = e;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->message;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp1_, "%s\n", _tmp3_);
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 1705 "application.c"
	}
	__finally5:
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 1716 "application.c"
	}
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = builder;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = gtk_builder_get_object (_tmp4_, "congratsdialog");
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_dialog);
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_congrats_dialog = _tmp6_;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp7_ = self->priv->_congrats_dialog;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp8_ = self->priv->_window;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp9_ = self->priv->_congrats_dialog;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object (_tmp9_, "response", (GCallback) ___lambda14__gtk_dialog_response, self, 0);
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp10_ = self->priv->_congrats_dialog;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) ___lambda15__gtk_widget_delete_event, self, 0);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp11_ = builder;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp12_ = gtk_builder_get_object (_tmp11_, "messagelabel");
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp12_) : NULL);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_message);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_congrats_message = _tmp13_;
#line 1752 "application.c"
}


static GamesScoresCategory* application_category_request (Application* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
	const gchar* _tmp0_ = NULL;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = key;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (g_strcmp0 (_tmp0_, "grid4") == 0) {
#line 1767 "application.c"
		GamesScoresCategory* _tmp1_ = NULL;
		GamesScoresCategory* _tmp2_ = NULL;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = self->priv->_grid4_cat;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = _tmp2_;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 1778 "application.c"
	} else {
		const gchar* _tmp3_ = NULL;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = key;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (g_strcmp0 (_tmp3_, "grid5") == 0) {
#line 1785 "application.c"
			GamesScoresCategory* _tmp4_ = NULL;
			GamesScoresCategory* _tmp5_ = NULL;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp4_ = self->priv->_grid5_cat;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			_tmp5_ = _g_object_ref0 (_tmp4_);
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			result = _tmp5_;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
			return result;
#line 1796 "application.c"
		}
	}
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_assert_not_reached ();
#line 1801 "application.c"
}


static GamesScoresCategory* _application_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = application_category_request ((Application*) self, category_key);
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 1810 "application.c"
}


static void _application_create_scores (Application* self) {
	GamesScoresCategory* _tmp0_ = NULL;
	GamesScoresCategory* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GamesScoresContext* _tmp3_ = NULL;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = games_scores_category_new ("grid4", "Grid 4 x 4");
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid4_cat);
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_grid4_cat = _tmp0_;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = games_scores_category_new ("grid5", "Grid 5 x 5");
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid5_cat);
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_grid5_cat = _tmp1_;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = self->priv->_window;
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = games_scores_context_new ("gnome-2048", "", _tmp2_, _application_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_PLAIN_DESCENDING);
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_scores_ctx);
#line 342 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_scores_ctx = _tmp3_;
#line 1841 "application.c"
}


static void application_new_game_cb (Application* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_header_bar;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 348 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game_restored = FALSE;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = self->priv->_game;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_new_game (_tmp1_);
#line 1860 "application.c"
}


static void application_undo_cb (Application* self) {
	Game* _tmp0_ = NULL;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_game;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	game_undo (_tmp0_);
#line 1872 "application.c"
}


static void application_scores_cb (Application* self) {
	GamesScoresContext* _tmp0_ = NULL;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_scores_ctx;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	games_scores_context_run_dialog (_tmp0_);
#line 1884 "application.c"
}


static void application_about_cb (Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_about_dialog;
#line 365 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1896 "application.c"
}


static void application_preferences_cb (Application* self) {
	gint grid_size = 0;
	gint rows = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkComboBoxText* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkDialog* _tmp5_ = NULL;
#line 368 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_settings;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = g_settings_get_int (_tmp0_, "rows");
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	rows = _tmp1_;
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = rows;
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (_tmp2_ == 4) {
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		grid_size = 0;
#line 1923 "application.c"
	} else {
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		grid_size = 1;
#line 1927 "application.c"
	}
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = self->priv->_grid_size_combo;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = grid_size;
#line 381 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, _tmp4_);
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp5_ = self->priv->_preferences_dialog;
#line 383 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_present ((GtkWindow*) _tmp5_);
#line 1939 "application.c"
}


static void application_quit_cb (Application* self) {
	GtkWindow* _tmp0_ = NULL;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_window;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1951 "application.c"
}


static void application_help_cb (Application* self) {
	GError * _inner_error_ = NULL;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_if_fail (self != NULL);
#line 1959 "application.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp0_ = self->priv->_window;
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_show_uri (_tmp1_, "help:gnome-2048", _tmp2_, &_inner_error_);
#line 394 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1974 "application.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = e;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = _tmp3_->message;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_warning ("application.vala:396: Failed to show help: %s", _tmp4_);
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 1996 "application.c"
	}
	__finally6:
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return;
#line 2007 "application.c"
	}
}


static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 402 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->_game_restored = FALSE;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_game;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = event;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = game_key_pressed (_tmp0_, _tmp1_);
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp2_;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 2035 "application.c"
}


static gboolean application_window_configure_event_cb (Application* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = self->priv->_window_maximized;
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (!_tmp0_) {
#line 2050 "application.c"
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp1_ = event;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = _tmp1_->width;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		self->priv->_window_width = _tmp2_;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = event;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp4_ = _tmp3_->height;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		self->priv->_window_height = _tmp4_;
#line 2067 "application.c"
	}
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = FALSE;
#line 414 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 2073 "application.c"
}


static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 419 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = event;
#line 419 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 419 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 2091 "application.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp2_ = event;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		self->priv->_window_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 2100 "application.c"
	}
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = FALSE;
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 2106 "application.c"
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	Application* app = NULL;
	Application* _tmp18_ = NULL;
	Application* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	setlocale (LC_ALL, "");
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	textdomain (GETTEXT_PACKAGE);
#line 432 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp0_ = g_option_context_new ("");
#line 432 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	context = _tmp0_;
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp1_ = context;
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp2_ = gtk_get_option_group (TRUE);
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_option_context_add_group (_tmp1_, _tmp2_);
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp3_ = context;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp4_ = clutter_get_option_group_without_init ();
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 2149 "application.c"
	{
		GOptionContext* _tmp5_ = NULL;
#line 438 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp5_ = context;
#line 438 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 438 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2158 "application.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp6_ = stderr;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp7_ = e;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp8_ = _tmp7_->message;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 441 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = EXIT_FAILURE;
#line 441 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 441 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 441 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 2189 "application.c"
	}
	__finally7:
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return 0;
#line 2202 "application.c"
	}
#line 444 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_set_application_name ("org.gnome.gnome-2048");
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	gtk_window_set_default_icon_name ("gnome-2048");
#line 2208 "application.c"
	{
		GOptionEntry* _tmp9_ = NULL;
		GOptionEntry* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp9_ = g_new0 (GOptionEntry, 0);
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = _tmp9_;
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10__length1 = 0;
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_clutter_init_with_args (&args_length1, &args, "", _tmp10_, NULL, &_inner_error_);
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp10_ = (g_free (_tmp10_), NULL);
#line 448 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2225 "application.c"
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkMessageDialog* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_ = NULL;
		GtkMessageDialog* _tmp17_ = NULL;
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		e = _inner_error_;
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_inner_error_ = NULL;
#line 450 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp11_ = e;
#line 450 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp12_ = _tmp11_->message;
#line 450 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp12_);
#line 450 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_object_ref_sink (_tmp13_);
#line 450 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		dialog = _tmp13_;
#line 451 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp14_ = dialog;
#line 451 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp15_ = g_get_application_name ();
#line 451 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_window_set_title ((GtkWindow*) _tmp14_, _tmp15_);
#line 452 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp16_ = dialog;
#line 452 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_dialog_run ((GtkDialog*) _tmp16_);
#line 453 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_tmp17_ = dialog;
#line 453 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp17_);
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		result = EXIT_FAILURE;
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_object_unref0 (dialog);
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_error_free0 (e);
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return result;
#line 2279 "application.c"
	}
	__finally8:
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		_g_option_context_free0 (context);
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		g_clear_error (&_inner_error_);
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
		return 0;
#line 2292 "application.c"
	}
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp18_ = application_new ();
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	app = _tmp18_;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp19_ = app;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20_ = args;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp20__length1 = args_length1;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_tmp21_ = g_application_run ((GApplication*) _tmp19_, _tmp20__length1, _tmp20_);
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	result = _tmp21_;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (app);
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_option_context_free0 (context);
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return result;
#line 2314 "application.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	return application_main (argv, argc);
#line 2324 "application.c"
}


static void application_class_init (ApplicationClass * klass) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	application_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	((GApplicationClass *) klass)->startup = application_real_startup;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	((GApplicationClass *) klass)->activate = application_real_activate;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	((GApplicationClass *) klass)->shutdown = application_real_shutdown;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
#line 2341 "application.c"
}


static void application_instance_init (Application * self) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv = APPLICATION_GET_PRIVATE (self);
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->WINDOW_MINIMUM_SIZE_HEIGHT = 600;
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self->priv->WINDOW_MINIMUM_SIZE_WIDTH = 600;
#line 2352 "application.c"
}


static void application_finalize (GObject* obj) {
	Application * self;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_settings);
#line 25 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_window);
#line 26 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_header_bar);
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_undo_button);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_new_game_button);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_about_dialog);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_preferences_dialog);
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_dialog);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_congrats_message);
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_score);
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid_size_combo);
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_scores_ctx);
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid4_cat);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_grid5_cat);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	_g_object_unref0 (self->priv->_game);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/application.vala"
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
#line 2392 "application.c"
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (gtk_application_get_type (), "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



