/* game.c generated by valac 0.30.0, the Vala compiler
 * generated from game.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _TileMovement TileMovement;

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;

#define GAME_TYPE_GAME_STATE (game_game_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tile_movement_free0(var) ((var == NULL) ? NULL : (var = (tile_movement_free (var), NULL)))
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

typedef enum  {
	GAME_GAME_STATE_STOPPED,
	GAME_GAME_STATE_IDLE,
	GAME_GAME_STATE_MOVING_DOWN,
	GAME_GAME_STATE_MOVING_UP,
	GAME_GAME_STATE_MOVING_RIGHT,
	GAME_GAME_STATE_MOVING_LEFT,
	GAME_GAME_STATE_SHOWING_FIRST_TILE,
	GAME_GAME_STATE_SHOWING_SECOND_TILE,
	GAME_GAME_STATE_RESTORING_TILES
} GameGameState;

struct _GamePrivate {
	gint BLANK_ROW_HEIGHT;
	gint BLANK_COL_WIDTH;
	Grid* _grid;
	ClutterActor* _view;
	RoundedRectangle** _background;
	gint _background_length1;
	gint _background_length2;
	TileView** _foreground_cur;
	gint _foreground_cur_length1;
	gint _foreground_cur_length2;
	TileView** _foreground_nxt;
	gint _foreground_nxt_length1;
	gint _foreground_nxt_length2;
	GeeLinkedList* _to_move;
	GeeLinkedList* _to_hide;
	GeeLinkedList* _to_show;
	GameGameState _state;
	ClutterTransitionGroup* _show_hide_trans;
	ClutterTransitionGroup* _move_trans;
	gint _animations_duration;
	gboolean _allow_undo;
	guint _undo_stack_max_size;
	GeeLinkedList* _undo_stack;
	GSettings* _settings;
	gchar* _saved_path;
	guint _resize_view_id;
	guint _score;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType grid_get_type (void) G_GNUC_CONST;
GType rounded_rectangle_get_type (void) G_GNUC_CONST;
GType tile_view_get_type (void) G_GNUC_CONST;
GType tile_movement_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
GType tile_get_type (void) G_GNUC_CONST;
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
static GType game_game_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_VIEW,
	GAME_SCORE
};
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void game_new_game (Game* self);
void grid_clear (Grid* self);
static void _game_clear_foreground (Game* self);
void game_set_score (Game* self, guint value);
static void _game_create_random_tile (Game* self);
void game_undo (Game* self);
static void _game_restore_foreground (Game* self, gboolean animate);
void game_save_game (Game* self);
gchar* grid_save (Grid* self);
gboolean game_restore_game (Game* self);
gboolean grid_load (Grid* self, const gchar* content);
static void _game_clear_background (Game* self);
static void _game_init_background (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
static guint _game_upper_key (Game* self, guint keyval);
static void _game_move_down (Game* self);
static void _game_move_up (Game* self);
static void _game_move_left (Game* self);
static void _game_move_right (Game* self);
gboolean game_reload_settings (Game* self);
gint grid_get_rows (Grid* self);
gint grid_get_cols (Grid* self);
static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags);
static void _game_resize_view (Game* self);
RoundedRectangle* rounded_rectangle_new (gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
RoundedRectangle* rounded_rectangle_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
void rounded_rectangle_resize (RoundedRectangle* self, gfloat x, gfloat y, gfloat width, gfloat height);
static gboolean _game_idle_resize_view (Game* self);
static gboolean __game_idle_resize_view_gsource_func (gpointer self);
void rounded_rectangle_idle_resize (RoundedRectangle* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static void _game_create_show_hide_transition (Game* self, gboolean animate);
static void _game_create_tile (Game* self, Tile* tile);
static void _game_show_tile (Game* self, GridPosition* pos);
TileView* tile_view_new (gfloat x, gfloat y, gfloat width, gfloat height, guint val);
TileView* tile_view_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, guint val);
static void _game_store_movement (Game* self);
static void _game_on_move_trans_stopped (Game* self, gboolean is_finished);
static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to);
static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
static void _game_dim_tile (Game* self, GridPosition* pos);
guint tile_view_get_value (TileView* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_to_string (Grid* self);
guint game_get_score (Game* self);
static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished);
static gboolean _game_finish_move (Game* self);
static gboolean __game_finish_move_gsource_func (gpointer self);
static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
gboolean grid_get_target_value_reached (Grid* self);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gboolean grid_is_finished (Grid* self);
Grid* grid_clone (Grid* self);
ClutterActor* game_get_view (Game* self);
void game_set_view (Game* self, ClutterActor* value);
static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType game_game_state_get_type (void) {
	static volatile gsize game_game_state_type_id__volatile = 0;
	if (g_once_init_enter (&game_game_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_GAME_STATE_STOPPED, "GAME_GAME_STATE_STOPPED", "stopped"}, {GAME_GAME_STATE_IDLE, "GAME_GAME_STATE_IDLE", "idle"}, {GAME_GAME_STATE_MOVING_DOWN, "GAME_GAME_STATE_MOVING_DOWN", "moving-down"}, {GAME_GAME_STATE_MOVING_UP, "GAME_GAME_STATE_MOVING_UP", "moving-up"}, {GAME_GAME_STATE_MOVING_RIGHT, "GAME_GAME_STATE_MOVING_RIGHT", "moving-right"}, {GAME_GAME_STATE_MOVING_LEFT, "GAME_GAME_STATE_MOVING_LEFT", "moving-left"}, {GAME_GAME_STATE_SHOWING_FIRST_TILE, "GAME_GAME_STATE_SHOWING_FIRST_TILE", "showing-first-tile"}, {GAME_GAME_STATE_SHOWING_SECOND_TILE, "GAME_GAME_STATE_SHOWING_SECOND_TILE", "showing-second-tile"}, {GAME_GAME_STATE_RESTORING_TILES, "GAME_GAME_STATE_RESTORING_TILES", "restoring-tiles"}, {0, NULL, NULL}};
		GType game_game_state_type_id;
		game_game_state_type_id = g_enum_register_static ("GameGameState", values);
		g_once_init_leave (&game_game_state_type_id__volatile, game_game_state_type_id);
	}
	return game_game_state_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return self ? g_object_ref (self) : NULL;
#line 278 "game.c"
}


Game* game_construct (GType object_type, GSettings* settings) {
	Game * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint rows = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint cols = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Grid* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GSettings* _tmp9_ = NULL;
	Grid* _tmp10_ = NULL;
	GeeLinkedList* _tmp11_ = NULL;
	GeeLinkedList* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = settings;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_settings);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_settings = _tmp1_;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_settings;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_settings_get_int (_tmp2_, "rows");
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp3_;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_settings;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = g_settings_get_int (_tmp4_, "cols");
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_new (rows, cols);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_grid = _tmp6_;
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_settings;
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = g_settings_get_double (_tmp7_, "animations-speed");
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_animations_duration = (gint) _tmp8_;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_settings;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_grid;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_settings_bind (_tmp9_, "target-value", (GObject*) _tmp10_, "target_value", G_SETTINGS_BIND_DEFAULT);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_move);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_move = _tmp11_;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_hide);
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_hide = _tmp12_;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, tile_free, NULL, NULL, NULL);
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_show);
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_show = _tmp13_;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = gee_linked_list_new (TYPE_GRID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_undo_stack);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack = _tmp14_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = self->priv->_settings;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = g_settings_get_boolean (_tmp15_, "allow-undo");
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_allow_undo = _tmp16_;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_settings;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "allow-undo-max");
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack_max_size = (guint) _tmp18_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = g_get_user_data_dir ();
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = g_build_filename (_tmp19_, "gnome-2048", "saved", NULL);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (self->priv->_saved_path);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_saved_path = _tmp20_;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_state = GAME_GAME_STATE_STOPPED;
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return self;
#line 397 "game.c"
}


Game* game_new (GSettings* settings) {
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return game_construct (TYPE_GAME, settings);
#line 404 "game.c"
}


void game_new_game (Game* self) {
	Grid* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_clear (_tmp0_);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_undo_stack;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_clear_foreground (self);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, (guint) 0);
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_state = GAME_GAME_STATE_SHOWING_FIRST_TILE;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_random_tile (self);
#line 429 "game.c"
}


void game_undo (Game* self) {
	Grid* grid = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	Grid* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_undo_stack;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = gee_deque_poll_head ((GeeDeque*) _tmp0_);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid = (Grid*) _tmp1_;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_clear_foreground (self);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_grid = _tmp3_;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_restore_foreground (self, FALSE);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_undo_stack;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp6_ == 0) {
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "undo-disabled");
#line 472 "game.c"
	}
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (grid);
#line 476 "game.c"
}


void game_save_game (Game* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = g_strdup ("");
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp0_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = contents;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_grid;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = grid_save (_tmp2_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp5_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = contents;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_score;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp12_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp11_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp9_);
#line 540 "game.c"
	{
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = self->priv->_saved_path;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = g_path_get_dirname (_tmp13_);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _tmp14_;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_mkdir_with_parents (_tmp15_, 0775);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (_tmp15_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp16_ = self->priv->_saved_path;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp17_ = contents;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_file_set_contents (_tmp16_, _tmp17_, (gssize) -1, &_inner_error_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 567 "game.c"
				goto __catch9_g_file_error;
			}
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (contents);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_clear_error (&_inner_error_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			return;
#line 578 "game.c"
		}
#line 137 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_debug ("game.vala:137: game saved successfully");
#line 582 "game.c"
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		e = _inner_error_;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_inner_error_ = NULL;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp18_ = e;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp19_ = _tmp18_->message;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_warning ("game.vala:139: Failed to save game: %s", _tmp19_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_error_free0 (e);
#line 602 "game.c"
	}
	__finally9:
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_clear_error (&_inner_error_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return;
#line 615 "game.c"
	}
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 619 "game.c"
}


gboolean game_restore_game (Game* self) {
	gboolean result = FALSE;
	gchar* contents = NULL;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	Grid* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	RoundedRectangle** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	GError * _inner_error_ = NULL;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 645 "game.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = self->priv->_saved_path;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		contents = _tmp1_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 661 "game.c"
				goto __catch10_g_file_error;
			}
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (contents);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_clear_error (&_inner_error_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			return FALSE;
#line 674 "game.c"
		}
	}
	goto __finally10;
	__catch10_g_file_error:
	{
		GError* e = NULL;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		e = _inner_error_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_inner_error_ = NULL;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_error_free0 (e);
#line 687 "game.c"
	}
	__finally10:
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_clear_error (&_inner_error_);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return FALSE;
#line 702 "game.c"
	}
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_grid;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = grid_load (_tmp2_, contents);
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (!_tmp3_) {
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = FALSE;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 718 "game.c"
	}
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_ = g_strsplit (contents, "\n", 0);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = _tmp5_;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines_length1 = _vala_array_length (_tmp4_);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_lines_size_ = lines_length1;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = lines;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6__length1 = lines_length1;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = lines;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7__length1 = lines_length1;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp6_[_tmp7__length1 - 2];
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = atoi (_tmp8_);
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, (guint) _tmp9_);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_background;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10__length1 = self->priv->_background_length1;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10__length2 = self->priv->_background_length2;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp10_ != NULL) {
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_background (self);
#line 754 "game.c"
	}
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_init_background (self);
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_restore_foreground (self, TRUE);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:173: game restored successfully");
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = TRUE;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 770 "game.c"
}


gboolean game_key_pressed (Game* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	guint keyval = 0U;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_state;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ != GAME_GAME_STATE_IDLE) {
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = TRUE;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 794 "game.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = event;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_->keyval;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _game_upper_key (self, _tmp2_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	keyval = _tmp3_;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = keyval;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp4_ == ((guint) GDK_KEY_Down)) {
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_move_down (self);
#line 810 "game.c"
	} else {
		guint _tmp5_ = 0U;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = keyval;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp5_ == ((guint) GDK_KEY_Up)) {
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_up (self);
#line 819 "game.c"
		} else {
			guint _tmp6_ = 0U;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = keyval;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_tmp6_ == ((guint) GDK_KEY_Left)) {
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_game_move_left (self);
#line 828 "game.c"
			} else {
				guint _tmp7_ = 0U;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp7_ = keyval;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (_tmp7_ == ((guint) GDK_KEY_Right)) {
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_game_move_right (self);
#line 837 "game.c"
				}
			}
		}
	}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 846 "game.c"
}


gboolean game_reload_settings (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gboolean allow_undo = FALSE;
	GSettings* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	Grid* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_settings;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = g_settings_get_double (_tmp0_, "animations-speed");
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_animations_duration = (gint) _tmp1_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_settings;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_settings_get_boolean (_tmp2_, "allow-undo");
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	allow_undo = _tmp3_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_allow_undo;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp5_) {
#line 891 "game.c"
		gboolean _tmp6_ = FALSE;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = allow_undo;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = !_tmp6_;
#line 897 "game.c"
	} else {
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = FALSE;
#line 901 "game.c"
	}
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp4_) {
#line 905 "game.c"
		GeeLinkedList* _tmp7_ = NULL;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = self->priv->_undo_stack;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "undo-disabled");
#line 913 "game.c"
	}
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = allow_undo;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_allow_undo = _tmp8_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_settings;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_settings_get_int (_tmp9_, "allow-undo-max");
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack_max_size = (guint) _tmp10_;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = self->priv->_settings;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_settings_get_int (_tmp11_, "rows");
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp12_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_settings;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = g_settings_get_int (_tmp13_, "cols");
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp14_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = rows;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_grid;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = grid_get_rows (_tmp17_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp16_ != _tmp19_) {
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = TRUE;
#line 949 "game.c"
	} else {
		gint _tmp20_ = 0;
		Grid* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp20_ = cols;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp21_ = self->priv->_grid;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp22_ = grid_get_cols (_tmp21_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = _tmp22_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _tmp20_ != _tmp23_;
#line 965 "game.c"
	}
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp15_) {
#line 969 "game.c"
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		Grid* _tmp26_ = NULL;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_foreground (self);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_background (self);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = rows;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = cols;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = grid_new (_tmp24_, _tmp25_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (self->priv->_grid);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_grid = _tmp26_;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = TRUE;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 993 "game.c"
	}
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 999 "game.c"
}


static guint _game_upper_key (Game* self, guint keyval) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = keyval;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp1_ > ((guint) 255)) {
#line 1013 "game.c"
		guint _tmp2_ = 0U;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = keyval;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = _tmp2_;
#line 1019 "game.c"
	} else {
		guint _tmp3_ = 0U;
		gchar _tmp4_ = '\0';
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = keyval;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = g_ascii_toupper ((gchar) _tmp3_);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = (guint) _tmp4_;
#line 1029 "game.c"
	}
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1035 "game.c"
}


static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags) {
	RoundedRectangle** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (box != NULL);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_background;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0__length1 = self->priv->_background_length1;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0__length2 = self->priv->_background_length2;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ == NULL) {
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 1057 "game.c"
	} else {
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_resize_view (self);
#line 1061 "game.c"
	}
}


static void _game_init_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ClutterColor background_color = {0};
	ClutterActor* _tmp6_ = NULL;
	ClutterColor _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	RoundedRectangle** _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	TileView** _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	TileView** _tmp16_ = NULL;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp19_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gfloat _tmp26_ = 0.0F;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp29_ = 0.0F;
	gint _tmp30_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp31_ = 0.0F;
	gint _tmp32_ = 0;
	ClutterColor color = {0};
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_color_from_string (&background_color, "#babdb6");
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_view;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = background_color;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_set_background_color (_tmp6_, &_tmp7_);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = rows;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = cols;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_new0 (RoundedRectangle*, (_tmp8_ * _tmp9_) + 1);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = _tmp10_;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background_length1 = _tmp8_;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background_length2 = _tmp9_;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = rows;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = cols;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = g_new0 (TileView*, (_tmp11_ * _tmp12_) + 1);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = _tmp13_;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur_length1 = _tmp11_;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur_length2 = _tmp12_;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = rows;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = cols;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = g_new0 (TileView*, (_tmp14_ * _tmp15_) + 1);
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = _tmp16_;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt_length1 = _tmp14_;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt_length2 = _tmp15_;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_view;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = clutter_actor_get_width (_tmp17_);
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp19_;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = self->priv->_view;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = clutter_actor_get_height (_tmp20_);
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp22_;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = canvas_width;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = cols;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = self->priv->BLANK_COL_WIDTH;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp23_ - ((_tmp24_ + 1) * _tmp25_);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = canvas_height;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = rows;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = self->priv->BLANK_ROW_HEIGHT;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp26_ - ((_tmp27_ + 1) * _tmp28_);
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = canvas_width;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = cols;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_width = _tmp29_ / _tmp30_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = canvas_height;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = rows;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_height = _tmp31_ / _tmp32_;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_color_from_string (&color, "#ffffff");
#line 1222 "game.c"
	{
		gint i = 0;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1227 "game.c"
		{
			gboolean _tmp33_ = FALSE;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = TRUE;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1234 "game.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp33_) {
#line 1239 "game.c"
					gint _tmp34_ = 0;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp34_ = i;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp34_ + 1;
#line 1245 "game.c"
				}
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp33_ = FALSE;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp35_ = i;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp36_ = rows;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp35_ < _tmp36_)) {
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1257 "game.c"
				}
				{
					gint j = 0;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1263 "game.c"
					{
						gboolean _tmp37_ = FALSE;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp37_ = TRUE;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1270 "game.c"
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gfloat x = 0.0F;
							gint _tmp41_ = 0;
							gfloat _tmp42_ = 0.0F;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gfloat y = 0.0F;
							gint _tmp45_ = 0;
							gfloat _tmp46_ = 0.0F;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							RoundedRectangle* rect = NULL;
							gfloat _tmp49_ = 0.0F;
							gfloat _tmp50_ = 0.0F;
							gfloat _tmp51_ = 0.0F;
							gfloat _tmp52_ = 0.0F;
							ClutterColor _tmp53_ = {0};
							RoundedRectangle* _tmp54_ = NULL;
							ClutterActor* _tmp55_ = NULL;
							RoundedRectangle* _tmp56_ = NULL;
							ClutterActor* _tmp57_ = NULL;
							ClutterActor* _tmp58_ = NULL;
							RoundedRectangle* _tmp59_ = NULL;
							ClutterCanvas* _tmp60_ = NULL;
							ClutterCanvas* _tmp61_ = NULL;
							RoundedRectangle* _tmp62_ = NULL;
							ClutterActor* _tmp63_ = NULL;
							ClutterActor* _tmp64_ = NULL;
							RoundedRectangle** _tmp65_ = NULL;
							gint _tmp65__length1 = 0;
							gint _tmp65__length2 = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							RoundedRectangle* _tmp68_ = NULL;
							RoundedRectangle* _tmp69_ = NULL;
							RoundedRectangle* _tmp70_ = NULL;
							TileView** _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							TileView* _tmp74_ = NULL;
							TileView** _tmp75_ = NULL;
							gint _tmp75__length1 = 0;
							gint _tmp75__length2 = 0;
							gint _tmp76_ = 0;
							gint _tmp77_ = 0;
							TileView* _tmp78_ = NULL;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp37_) {
#line 1322 "game.c"
								gint _tmp38_ = 0;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp38_ = j;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp38_ + 1;
#line 1328 "game.c"
							}
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp37_ = FALSE;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp39_ = j;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp40_ = cols;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp39_ < _tmp40_)) {
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1340 "game.c"
							}
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp41_ = j;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp42_ = tile_width;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp43_ = j;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp44_ = self->priv->BLANK_COL_WIDTH;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							x = (_tmp41_ * _tmp42_) + ((_tmp43_ + 1) * _tmp44_);
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp45_ = i;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46_ = tile_height;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp47_ = i;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp48_ = self->priv->BLANK_ROW_HEIGHT;
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							y = (_tmp45_ * _tmp46_) + ((_tmp47_ + 1) * _tmp48_);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp49_ = x;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp50_ = y;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp51_ = tile_width;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp52_ = tile_height;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp53_ = color;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp54_ = rounded_rectangle_new (_tmp49_, _tmp50_, _tmp51_, _tmp52_, &_tmp53_);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rect = _tmp54_;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp55_ = self->priv->_view;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp56_ = rect;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp57_ = rounded_rectangle_get_actor (_tmp56_);
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58_ = _tmp57_;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_add_child (_tmp55_, _tmp58_);
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp59_ = rect;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp60_ = rounded_rectangle_get_canvas (_tmp59_);
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp61_ = _tmp60_;
#line 275 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_content_invalidate ((ClutterContent*) _tmp61_);
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp62_ = rect;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp63_ = rounded_rectangle_get_actor (_tmp62_);
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp64_ = _tmp63_;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_show (_tmp64_);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65_ = self->priv->_background;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65__length1 = self->priv->_background_length1;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65__length2 = self->priv->_background_length2;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp66_ = i;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp67_ = j;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp68_ = rect;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp69_ = _g_object_ref0 (_tmp68_);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_]);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = _tmp69_;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp70_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71_ = self->priv->_foreground_cur;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71__length1 = self->priv->_foreground_cur_length1;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71__length2 = self->priv->_foreground_cur_length2;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp72_ = i;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp73_ = j;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_]);
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_] = NULL;
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75_ = self->priv->_foreground_nxt;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75__length1 = self->priv->_foreground_nxt_length1;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75__length2 = self->priv->_foreground_nxt_length2;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp76_ = i;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp77_ = j;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_]);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_] = NULL;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp78_ = _tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_];
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (rect);
#line 1456 "game.c"
						}
					}
				}
			}
		}
	}
}


static gboolean __game_idle_resize_view_gsource_func (gpointer self) {
	gboolean result;
	result = _game_idle_resize_view ((Game*) self);
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1471 "game.c"
}


static void _game_resize_view (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp6_ = NULL;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp9_ = NULL;
	gfloat _tmp10_ = 0.0F;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gfloat _tmp15_ = 0.0F;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gint _tmp19_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp20_ = 0.0F;
	gint _tmp21_ = 0;
	guint _tmp70_ = 0U;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_view;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = clutter_actor_get_width (_tmp6_);
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp8_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_view;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = clutter_actor_get_height (_tmp9_);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp11_;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = canvas_width;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = cols;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = self->priv->BLANK_COL_WIDTH;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp12_ - ((_tmp13_ + 1) * _tmp14_);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = canvas_height;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = rows;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->BLANK_ROW_HEIGHT;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp15_ - ((_tmp16_ + 1) * _tmp17_);
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = canvas_width;
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = cols;
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_width = _tmp18_ / _tmp19_;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = canvas_height;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = rows;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_height = _tmp20_ / _tmp21_;
#line 1567 "game.c"
	{
		gint i = 0;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1572 "game.c"
		{
			gboolean _tmp22_ = FALSE;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = TRUE;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1579 "game.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp22_) {
#line 1584 "game.c"
					gint _tmp23_ = 0;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp23_ = i;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp23_ + 1;
#line 1590 "game.c"
				}
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp22_ = FALSE;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp24_ = i;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp25_ = rows;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1602 "game.c"
				}
				{
					gint j = 0;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1608 "game.c"
					{
						gboolean _tmp26_ = FALSE;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp26_ = TRUE;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1615 "game.c"
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gfloat x = 0.0F;
							gint _tmp30_ = 0;
							gfloat _tmp31_ = 0.0F;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gfloat y = 0.0F;
							gint _tmp34_ = 0;
							gfloat _tmp35_ = 0.0F;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							RoundedRectangle** _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							RoundedRectangle* _tmp41_ = NULL;
							gfloat _tmp42_ = 0.0F;
							gfloat _tmp43_ = 0.0F;
							gfloat _tmp44_ = 0.0F;
							gfloat _tmp45_ = 0.0F;
							TileView** _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							TileView* _tmp49_ = NULL;
							TileView** _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							gint _tmp58__length2 = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							TileView* _tmp61_ = NULL;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp26_) {
#line 1652 "game.c"
								gint _tmp27_ = 0;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = j;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp27_ + 1;
#line 1658 "game.c"
							}
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp26_ = FALSE;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp28_ = j;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp29_ = cols;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp28_ < _tmp29_)) {
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1670 "game.c"
							}
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp30_ = j;
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp31_ = tile_width;
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp32_ = j;
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp33_ = self->priv->BLANK_COL_WIDTH;
#line 300 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							x = (_tmp30_ * _tmp31_) + ((_tmp32_ + 1) * _tmp33_);
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp34_ = i;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp35_ = tile_height;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp36_ = i;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp37_ = self->priv->BLANK_ROW_HEIGHT;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							y = (_tmp34_ * _tmp35_) + ((_tmp36_ + 1) * _tmp37_);
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38_ = self->priv->_background;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38__length1 = self->priv->_background_length1;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38__length2 = self->priv->_background_length2;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp39_ = i;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp40_ = j;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp42_ = x;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp43_ = y;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp44_ = tile_width;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp45_ = tile_height;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rounded_rectangle_resize (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_);
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46_ = self->priv->_foreground_cur;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46__length1 = self->priv->_foreground_cur_length1;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46__length2 = self->priv->_foreground_cur_length2;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp47_ = i;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp48_ = j;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp49_ != NULL) {
#line 1728 "game.c"
								TileView** _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								gint _tmp50__length2 = 0;
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								TileView* _tmp53_ = NULL;
								gfloat _tmp54_ = 0.0F;
								gfloat _tmp55_ = 0.0F;
								gfloat _tmp56_ = 0.0F;
								gfloat _tmp57_ = 0.0F;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50_ = self->priv->_foreground_cur;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50__length1 = self->priv->_foreground_cur_length1;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50__length2 = self->priv->_foreground_cur_length2;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp51_ = i;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp52_ = j;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp54_ = x;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp55_ = y;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp56_ = tile_width;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp57_ = tile_height;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_resize ((RoundedRectangle*) _tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
#line 1761 "game.c"
							}
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58_ = self->priv->_foreground_nxt;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58__length1 = self->priv->_foreground_nxt_length1;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58__length2 = self->priv->_foreground_nxt_length2;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp59_ = i;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp60_ = j;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp61_ != NULL) {
#line 1777 "game.c"
								TileView** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								gint _tmp62__length2 = 0;
								gint _tmp63_ = 0;
								gint _tmp64_ = 0;
								TileView* _tmp65_ = NULL;
								gfloat _tmp66_ = 0.0F;
								gfloat _tmp67_ = 0.0F;
								gfloat _tmp68_ = 0.0F;
								gfloat _tmp69_ = 0.0F;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62_ = self->priv->_foreground_nxt;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62__length1 = self->priv->_foreground_nxt_length1;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62__length2 = self->priv->_foreground_nxt_length2;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp63_ = i;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp64_ = j;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp66_ = x;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp67_ = y;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp68_ = tile_width;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp69_ = tile_height;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_resize ((RoundedRectangle*) _tmp65_, _tmp66_, _tmp67_, _tmp68_, _tmp69_);
#line 1810 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp70_ = self->priv->_resize_view_id;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp70_ == ((guint) 0)) {
#line 1822 "game.c"
		guint _tmp71_ = 0U;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp71_ = clutter_threads_add_timeout ((guint) 1000, __game_idle_resize_view_gsource_func, self);
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_resize_view_id = _tmp71_;
#line 1828 "game.c"
	}
}


static gboolean _game_idle_resize_view (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 1861 "game.c"
	{
		gint i = 0;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1866 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1873 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 1878 "game.c"
					gint _tmp7_ = 0;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 1884 "game.c"
				}
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1896 "game.c"
				}
				{
					gint j = 0;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1902 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1909 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							TileView** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp18__length2 = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							TileView* _tmp21_ = NULL;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 1926 "game.c"
								gint _tmp11_ = 0;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 1932 "game.c"
							}
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1944 "game.c"
							}
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_background;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_background_length1;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_background_length2;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rounded_rectangle_idle_resize (_tmp17_);
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = self->priv->_foreground_cur;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18__length1 = self->priv->_foreground_cur_length1;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18__length2 = self->priv->_foreground_cur_length2;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = i;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp20_ = j;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp21_ != NULL) {
#line 1974 "game.c"
								TileView** _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp22__length2 = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								TileView* _tmp25_ = NULL;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_ = self->priv->_foreground_cur;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22__length1 = self->priv->_foreground_cur_length1;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22__length2 = self->priv->_foreground_cur_length2;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = i;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = j;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_idle_resize ((RoundedRectangle*) _tmp25_);
#line 1995 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_resize_view_id = (guint) 0;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 2009 "game.c"
}


static void _game_create_random_tile (Game* self) {
	Tile tile = {0};
	Grid* _tmp0_ = NULL;
	Tile _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_new_tile (_tmp0_, &_tmp1_);
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile = _tmp1_;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp2_) {
#line 2028 "game.c"
		Tile _tmp3_ = {0};
		GeeLinkedList* _tmp4_ = NULL;
		Tile _tmp5_ = {0};
		Tile _tmp6_ = {0};
		GridPosition _tmp7_ = {0};
		ClutterTransitionGroup* _tmp8_ = NULL;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_show_hide_transition (self, TRUE);
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = tile;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_tile (self, &_tmp3_);
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_to_show;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = tile;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = tile;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = _tmp6_.pos;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_show_tile (self, &_tmp7_);
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_show_hide_trans;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp8_);
#line 2057 "game.c"
	}
}


static void _game_create_tile (Game* self, Tile* tile) {
	GridPosition pos = {0};
	RoundedRectangle* rect = NULL;
	TileView* view = NULL;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	Tile _tmp0_ = {0};
	GridPosition _tmp1_ = {0};
	RoundedRectangle** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	GridPosition _tmp3_ = {0};
	guint _tmp4_ = 0U;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	RoundedRectangle* _tmp7_ = NULL;
	RoundedRectangle* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterActor* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	gfloat _tmp23_ = 0.0F;
	gfloat _tmp24_ = 0.0F;
	TileView** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp25__length2 = 0;
	GridPosition _tmp26_ = {0};
	guint _tmp27_ = 0U;
	GridPosition _tmp28_ = {0};
	guint _tmp29_ = 0U;
	TileView* _tmp30_ = NULL;
	Tile _tmp31_ = {0};
	guint _tmp32_ = 0U;
	TileView* _tmp33_ = NULL;
	TileView** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gint _tmp34__length2 = 0;
	GridPosition _tmp35_ = {0};
	guint _tmp36_ = 0U;
	GridPosition _tmp37_ = {0};
	guint _tmp38_ = 0U;
	TileView* _tmp39_ = NULL;
	TileView* _tmp40_ = NULL;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (tile != NULL);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = *tile;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_.pos;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	pos = _tmp1_;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_background;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length1 = self->priv->_background_length1;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length2 = self->priv->_background_length2;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = pos;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_.row;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = pos;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.col;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect = _tmp8_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = rounded_rectangle_get_actor (rect);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp9_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = clutter_actor_get_x (_tmp10_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	x = _tmp12_;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = rounded_rectangle_get_actor (rect);
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = _tmp13_;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = clutter_actor_get_y (_tmp14_);
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = _tmp15_;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	y = _tmp16_;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = rounded_rectangle_get_actor (rect);
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp17_;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = clutter_actor_get_width (_tmp18_);
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp19_;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	width = _tmp20_;
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = rounded_rectangle_get_actor (rect);
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_;
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = clutter_actor_get_height (_tmp22_);
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _tmp23_;
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	height = _tmp24_;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = self->priv->_foreground_nxt;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25__length1 = self->priv->_foreground_nxt_length1;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25__length2 = self->priv->_foreground_nxt_length2;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = pos;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = _tmp26_.row;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = pos;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = _tmp28_.col;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = _tmp25_[(_tmp27_ * _tmp25__length2) + _tmp29_];
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_vala_assert (_tmp30_ == NULL, "_foreground_nxt[pos.row,pos.col] == null");
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = *tile;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = _tmp31_.val;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp33_ = tile_view_new (x, y, width, height, _tmp32_);
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	view = _tmp33_;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34_ = self->priv->_foreground_nxt;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34__length1 = self->priv->_foreground_nxt_length1;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34__length2 = self->priv->_foreground_nxt_length2;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp35_ = pos;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp36_ = _tmp35_.row;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp37_ = pos;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp38_ = _tmp37_.col;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp39_ = _g_object_ref0 (view);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_]);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_] = _tmp39_;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = _tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_];
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect);
#line 2243 "game.c"
}


static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_move_trans_stopped ((Game*) self, is_finished);
#line 2250 "game.c"
}


static void _game_move_down (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:373: move down");
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_down (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2302 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2330 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2354 "game.c"
			}
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2376 "game.c"
		}
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2380 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2409 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2433 "game.c"
			}
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2455 "game.c"
		}
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2459 "game.c"
	}
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 2471 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 2484 "game.c"
	}
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 2490 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 2503 "game.c"
	}
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 2511 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_DOWN;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 2519 "game.c"
	}
}


static void _game_move_up (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 401 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:401: move up");
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_up (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2572 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2600 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2624 "game.c"
			}
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2646 "game.c"
		}
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2650 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2679 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2703 "game.c"
			}
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2725 "game.c"
		}
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2729 "game.c"
	}
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 2741 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 2754 "game.c"
	}
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 2760 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 2773 "game.c"
	}
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 2781 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_UP;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 2789 "game.c"
	}
}


static void _game_move_left (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:429: move left");
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_left (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2842 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2870 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2894 "game.c"
			}
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2916 "game.c"
		}
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2920 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2949 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2973 "game.c"
			}
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2995 "game.c"
		}
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2999 "game.c"
	}
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 3011 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 3024 "game.c"
	}
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 3030 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 3043 "game.c"
	}
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 3051 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 3059 "game.c"
	}
}


static void _game_move_right (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 455 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 457 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:457: move right");
#line 461 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_right (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 3112 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 3140 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3164 "game.c"
			}
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3186 "game.c"
		}
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3190 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 3219 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3243 "game.c"
			}
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3265 "game.c"
		}
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3269 "game.c"
	}
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 3281 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 3294 "game.c"
	}
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 3300 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 3313 "game.c"
	}
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 3321 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
#line 479 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 479 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 3329 "game.c"
	}
}


static void _game_show_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView* view = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	TileView* _tmp10_ = NULL;
	ClutterCanvas* _tmp11_ = NULL;
	ClutterCanvas* _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterPropertyTransition* _tmp20_ = NULL;
	ClutterPropertyTransition* _tmp21_ = NULL;
	GValue _tmp22_ = {0};
	ClutterPropertyTransition* _tmp23_ = NULL;
	GValue _tmp24_ = {0};
	ClutterPropertyTransition* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ClutterPropertyTransition* _tmp27_ = NULL;
	ClutterActor* _tmp28_ = NULL;
	ClutterActor* _tmp29_ = NULL;
	ClutterTransitionGroup* _tmp30_ = NULL;
	ClutterPropertyTransition* _tmp31_ = NULL;
	ClutterPropertyTransition* _tmp32_ = NULL;
	ClutterPropertyTransition* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	ClutterPropertyTransition* _tmp35_ = NULL;
	GValue _tmp36_ = {0};
	ClutterPropertyTransition* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ClutterPropertyTransition* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterTransitionGroup* _tmp42_ = NULL;
	ClutterPropertyTransition* _tmp43_ = NULL;
	ClutterPropertyTransition* _tmp44_ = NULL;
	ClutterPropertyTransition* _tmp45_ = NULL;
	GValue _tmp46_ = {0};
	ClutterPropertyTransition* _tmp47_ = NULL;
	GValue _tmp48_ = {0};
	ClutterPropertyTransition* _tmp49_ = NULL;
	ClutterPropertyTransition* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	ClutterActor* _tmp52_ = NULL;
	ClutterActor* _tmp53_ = NULL;
	ClutterPropertyTransition* _tmp54_ = NULL;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (pos != NULL);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (pos);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = g_strconcat ("show tile pos ", _tmp1_, NULL);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:485: %s", _tmp3_);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_foreground_nxt;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length1 = self->priv->_foreground_nxt_length1;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length2 = self->priv->_foreground_nxt_length2;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = *pos;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.row;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *pos;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_.col;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	view = _tmp10_;
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = rounded_rectangle_get_canvas ((RoundedRectangle*) view);
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_content_invalidate ((ClutterContent*) _tmp12_);
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = _tmp13_;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_set_opacity (_tmp14_, (guint8) 0);
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = _tmp15_;
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_show (_tmp16_);
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_view;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_add_child (_tmp17_, _tmp19_);
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp20_;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = trans;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp22_, G_TYPE_DOUBLE);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp22_, 1.0);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp21_, &_tmp22_);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = trans;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp24_, G_TYPE_DOUBLE);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp24_, 1.1);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp23_, &_tmp24_);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = trans;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = self->priv->_animations_duration;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp25_, (guint) _tmp26_);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = trans;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = _tmp28_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp27_, (ClutterAnimatable*) _tmp29_);
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_show_hide_trans;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = trans;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp30_, (ClutterTransition*) _tmp31_);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp32_;
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp33_ = trans;
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp34_, G_TYPE_DOUBLE);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp34_, 1.0);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp33_, &_tmp34_);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp35_ = trans;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp36_, G_TYPE_DOUBLE);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp36_, 1.1);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp35_, &_tmp36_);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp36_) ? (g_value_unset (&_tmp36_), NULL) : NULL;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp37_ = trans;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp38_ = self->priv->_animations_duration;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp37_, (guint) _tmp38_);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp39_ = trans;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = _tmp40_;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp39_, (ClutterAnimatable*) _tmp41_);
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = self->priv->_show_hide_trans;
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp43_ = trans;
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp42_, (ClutterTransition*) _tmp43_);
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp44_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp44_;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp45_ = trans;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp46_, G_TYPE_INT);
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp46_, 0);
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp45_, &_tmp46_);
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp47_ = trans;
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp48_, G_TYPE_INT);
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp48_, 255);
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp47_, &_tmp48_);
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = trans;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp49_, TRUE);
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp50_ = trans;
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp51_ = self->priv->_animations_duration;
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp50_, (guint) (_tmp51_ / 2));
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp52_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp53_ = _tmp52_;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp54_ = trans;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_add_transition (_tmp53_, "show", (ClutterTransition*) _tmp54_);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 3600 "game.c"
}


static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GridPosition _tmp6_ = {0};
	GridPosition _tmp7_ = {0};
	TileView** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	GridPosition _tmp9_ = {0};
	guint _tmp10_ = 0U;
	GridPosition _tmp11_ = {0};
	guint _tmp12_ = 0U;
	TileView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	TileView* _tmp18_ = NULL;
	TileView* _tmp19_ = NULL;
	TileView* _tmp20_ = NULL;
	TileView** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	GridPosition _tmp22_ = {0};
	guint _tmp23_ = 0U;
	GridPosition _tmp24_ = {0};
	guint _tmp25_ = 0U;
	TileView* _tmp26_ = NULL;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (from != NULL);
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (to != NULL);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (from);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_position_to_string (to);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = g_strconcat ("move tile from ", _tmp1_, " to ", _tmp3_, NULL);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:520: %s", _tmp5_);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp5_);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = *from;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *to;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_prepare_move_tile (self, &_tmp6_, &_tmp7_);
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = self->priv->_foreground_nxt;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length1 = self->priv->_foreground_nxt_length1;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length2 = self->priv->_foreground_nxt_length2;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = *to;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp9_.row;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = *to;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_.col;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_foreground_cur;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length1 = self->priv->_foreground_cur_length1;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length2 = self->priv->_foreground_cur_length2;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = *from;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_.row;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = *from;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = _tmp16_.col;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_]);
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_] = _tmp19_;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = self->priv->_foreground_cur;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21__length1 = self->priv->_foreground_cur_length1;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21__length2 = self->priv->_foreground_cur_length2;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = *from;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = _tmp22_.row;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = *from;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = _tmp24_.col;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_]);
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_] = NULL;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = _tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_];
#line 3728 "game.c"
}


static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean row_move = FALSE;
	gchar* trans_name = NULL;
	ClutterPropertyTransition* trans = NULL;
	RoundedRectangle* rect_from = NULL;
	RoundedRectangle* rect_to = NULL;
	GridPosition _tmp6_ = {0};
	guint _tmp7_ = 0U;
	GridPosition _tmp8_ = {0};
	guint _tmp9_ = 0U;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_ = NULL;
	RoundedRectangle** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	RoundedRectangle* _tmp18_ = NULL;
	RoundedRectangle* _tmp19_ = NULL;
	RoundedRectangle** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp20__length2 = 0;
	GridPosition _tmp21_ = {0};
	guint _tmp22_ = 0U;
	GridPosition _tmp23_ = {0};
	guint _tmp24_ = 0U;
	RoundedRectangle* _tmp25_ = NULL;
	RoundedRectangle* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	ClutterPropertyTransition* _tmp28_ = NULL;
	gfloat _tmp29_ = 0.0F;
	gboolean _tmp30_ = FALSE;
	ClutterPropertyTransition* _tmp41_ = NULL;
	GValue _tmp42_ = {0};
	gfloat _tmp43_ = 0.0F;
	gboolean _tmp44_ = FALSE;
	ClutterPropertyTransition* _tmp55_ = NULL;
	GValue _tmp56_ = {0};
	ClutterPropertyTransition* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	ClutterPropertyTransition* _tmp59_ = NULL;
	TileView** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	gint _tmp60__length2 = 0;
	GridPosition _tmp61_ = {0};
	guint _tmp62_ = 0U;
	GridPosition _tmp63_ = {0};
	guint _tmp64_ = 0U;
	TileView* _tmp65_ = NULL;
	ClutterActor* _tmp66_ = NULL;
	ClutterActor* _tmp67_ = NULL;
	ClutterTransitionGroup* _tmp68_ = NULL;
	ClutterPropertyTransition* _tmp69_ = NULL;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (from != NULL);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (to != NULL);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (from);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_position_to_string (to);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = g_strconcat ("prepare move tile from ", _tmp1_, " to ", _tmp3_, NULL);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:530: %s", _tmp5_);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp5_);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = *from;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_.col;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = *to;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_.col;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	row_move = _tmp7_ == _tmp9_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = row_move;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp11_) {
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = "y";
#line 3836 "game.c"
	} else {
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = "x";
#line 3840 "game.c"
	}
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strdup (_tmp10_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (trans_name);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans_name = _tmp12_;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_background;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length1 = self->priv->_background_length1;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length2 = self->priv->_background_length2;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = *from;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_.row;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = *from;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = _tmp16_.col;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_from);
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect_from = _tmp19_;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = self->priv->_background;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20__length1 = self->priv->_background_length1;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20__length2 = self->priv->_background_length2;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = *to;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_.row;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = *to;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _tmp23_.col;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = _tmp20_[(_tmp22_ * _tmp20__length2) + _tmp24_];
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_to);
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect_to = _tmp26_;
#line 544 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = trans_name;
#line 544 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = (ClutterPropertyTransition*) clutter_property_transition_new (_tmp27_);
#line 544 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 544 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp28_;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = row_move;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp30_) {
#line 3904 "game.c"
		RoundedRectangle* _tmp31_ = NULL;
		ClutterActor* _tmp32_ = NULL;
		ClutterActor* _tmp33_ = NULL;
		gfloat _tmp34_ = 0.0F;
		gfloat _tmp35_ = 0.0F;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp31_ = rect_from;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp32_ = rounded_rectangle_get_actor (_tmp31_);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp33_ = _tmp32_;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp34_ = clutter_actor_get_y (_tmp33_);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp35_ = _tmp34_;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp29_ = _tmp35_;
#line 3922 "game.c"
	} else {
		RoundedRectangle* _tmp36_ = NULL;
		ClutterActor* _tmp37_ = NULL;
		ClutterActor* _tmp38_ = NULL;
		gfloat _tmp39_ = 0.0F;
		gfloat _tmp40_ = 0.0F;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp36_ = rect_from;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp37_ = rounded_rectangle_get_actor (_tmp36_);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp37_;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = clutter_actor_get_x (_tmp38_);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp40_ = _tmp39_;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp29_ = _tmp40_;
#line 3941 "game.c"
	}
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = trans;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp42_, G_TYPE_FLOAT);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_float (&_tmp42_, _tmp29_);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp41_, &_tmp42_);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp44_ = row_move;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp44_) {
#line 3957 "game.c"
		RoundedRectangle* _tmp45_ = NULL;
		ClutterActor* _tmp46_ = NULL;
		ClutterActor* _tmp47_ = NULL;
		gfloat _tmp48_ = 0.0F;
		gfloat _tmp49_ = 0.0F;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = rect_to;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = rounded_rectangle_get_actor (_tmp45_);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = _tmp46_;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = clutter_actor_get_y (_tmp47_);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp49_ = _tmp48_;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp49_;
#line 3975 "game.c"
	} else {
		RoundedRectangle* _tmp50_ = NULL;
		ClutterActor* _tmp51_ = NULL;
		ClutterActor* _tmp52_ = NULL;
		gfloat _tmp53_ = 0.0F;
		gfloat _tmp54_ = 0.0F;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = rect_to;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp51_ = rounded_rectangle_get_actor (_tmp50_);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp52_ = _tmp51_;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp53_ = clutter_actor_get_x (_tmp52_);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp54_ = _tmp53_;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp54_;
#line 3994 "game.c"
	}
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp55_ = trans;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp56_, G_TYPE_FLOAT);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_float (&_tmp56_, _tmp43_);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp55_, &_tmp56_);
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp56_) ? (g_value_unset (&_tmp56_), NULL) : NULL;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp57_ = trans;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp58_ = self->priv->_animations_duration;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp57_, (guint) _tmp58_);
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp59_ = trans;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60_ = self->priv->_foreground_cur;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60__length1 = self->priv->_foreground_cur_length1;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60__length2 = self->priv->_foreground_cur_length2;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp61_ = *from;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp62_ = _tmp61_.row;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp63_ = *from;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp64_ = _tmp63_.col;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp65_ = _tmp60_[(_tmp62_ * _tmp60__length2) + _tmp64_];
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp66_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp65_);
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp67_ = _tmp66_;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp59_, (ClutterAnimatable*) _tmp67_);
#line 549 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp68_ = self->priv->_move_trans;
#line 549 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp69_ = trans;
#line 549 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp68_, (ClutterTransition*) _tmp69_);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_to);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_from);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (trans_name);
#line 4050 "game.c"
}


static void _game_dim_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	ClutterActor* actor = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	GridPosition _tmp17_ = {0};
	guint _tmp18_ = 0U;
	GridPosition _tmp19_ = {0};
	guint _tmp20_ = 0U;
	TileView* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	ClutterActor* _tmp23_ = NULL;
	ClutterActor* _tmp24_ = NULL;
	ClutterPropertyTransition* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	GValue _tmp28_ = {0};
	GValue _tmp29_ = {0};
	gint _tmp30_ = 0;
	ClutterTransitionGroup* _tmp31_ = NULL;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (pos != NULL);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (pos);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = g_strconcat ("diming tile at ", _tmp1_, " ", NULL);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_foreground_cur;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length1 = self->priv->_foreground_cur_length1;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length2 = self->priv->_foreground_cur_length2;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = *pos;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.row;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *pos;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_.col;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = tile_view_get_value (_tmp9_);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strdup_printf ("%u", _tmp11_);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = _tmp12_;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = g_strconcat (_tmp3_, _tmp13_, NULL);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:554: %s", _tmp15_);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp15_);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp13_);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = self->priv->_foreground_cur;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16__length1 = self->priv->_foreground_cur_length1;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16__length2 = self->priv->_foreground_cur_length2;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = *pos;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp17_.row;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = *pos;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp19_.col;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp21_);
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = _tmp22_;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (actor);
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	actor = _tmp24_;
#line 561 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
#line 561 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 561 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp25_;
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = clutter_actor_get_opacity (actor);
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = _tmp26_;
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp28_, G_TYPE_UINT);
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_uint (&_tmp28_, _tmp27_);
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) trans, &_tmp28_);
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp28_) ? (g_value_unset (&_tmp28_), NULL) : NULL;
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp29_, G_TYPE_INT);
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp29_, 0);
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) trans, &_tmp29_);
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
#line 564 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_animations_duration;
#line 564 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) trans, (guint) _tmp30_);
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) trans, (ClutterAnimatable*) actor);
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = self->priv->_show_hide_trans;
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp31_, (ClutterTransition*) trans);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (actor);
#line 4209 "game.c"
}


static void _game_clear_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 4240 "game.c"
	{
		gint i = 0;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4245 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4252 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 4257 "game.c"
					gint _tmp7_ = 0;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 4263 "game.c"
				}
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4275 "game.c"
				}
				{
					gint j = 0;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4281 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4288 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle* rect = NULL;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							RoundedRectangle* _tmp18_ = NULL;
							RoundedRectangle* _tmp19_ = NULL;
							ClutterActor* _tmp20_ = NULL;
							ClutterActor* _tmp21_ = NULL;
							ClutterActor* _tmp22_ = NULL;
							RoundedRectangle* _tmp23_ = NULL;
							ClutterActor* _tmp24_ = NULL;
							ClutterActor* _tmp25_ = NULL;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 4308 "game.c"
								gint _tmp11_ = 0;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 4314 "game.c"
							}
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4326 "game.c"
							}
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_background;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_background_length1;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_background_length2;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = _g_object_ref0 (_tmp17_);
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rect = _tmp18_;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = rect;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp20_ = rounded_rectangle_get_actor (_tmp19_);
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp21_ = _tmp20_;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_hide (_tmp21_);
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp22_ = self->priv->_view;
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp23_ = rect;
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp24_ = rounded_rectangle_get_actor (_tmp23_);
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp25_ = _tmp24_;
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_remove_child (_tmp22_, _tmp25_);
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (rect);
#line 4364 "game.c"
						}
					}
				}
			}
		}
	}
}


static void _game_clear_foreground (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 4401 "game.c"
	{
		gint i = 0;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4406 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4413 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 4418 "game.c"
					gint _tmp7_ = 0;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 4424 "game.c"
				}
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4436 "game.c"
				}
				{
					gint j = 0;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4442 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4449 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							TileView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							TileView* _tmp17_ = NULL;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 4460 "game.c"
								gint _tmp11_ = 0;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 4466 "game.c"
							}
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 590 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4478 "game.c"
							}
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_foreground_cur;
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_foreground_cur_length1;
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_foreground_cur_length2;
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp17_ != NULL) {
#line 4494 "game.c"
								TileView* tile = NULL;
								TileView** _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp18__length2 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								TileView* _tmp21_ = NULL;
								TileView* _tmp22_ = NULL;
								TileView* _tmp23_ = NULL;
								ClutterActor* _tmp24_ = NULL;
								ClutterActor* _tmp25_ = NULL;
								ClutterActor* _tmp26_ = NULL;
								TileView* _tmp27_ = NULL;
								ClutterActor* _tmp28_ = NULL;
								ClutterActor* _tmp29_ = NULL;
								TileView** _tmp30_ = NULL;
								gint _tmp30__length1 = 0;
								gint _tmp30__length2 = 0;
								gint _tmp31_ = 0;
								gint _tmp32_ = 0;
								TileView* _tmp33_ = NULL;
								TileView** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								gint _tmp34__length2 = 0;
								gint _tmp35_ = 0;
								gint _tmp36_ = 0;
								TileView* _tmp37_ = NULL;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18_ = self->priv->_foreground_cur;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18__length1 = self->priv->_foreground_cur_length1;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18__length2 = self->priv->_foreground_cur_length2;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp19_ = i;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp20_ = j;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_ = _g_object_ref0 (_tmp21_);
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								tile = _tmp22_;
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = tile;
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp23_);
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_ = _tmp24_;
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								clutter_actor_hide (_tmp25_);
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp26_ = self->priv->_view;
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = tile;
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp27_);
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp29_ = _tmp28_;
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								clutter_actor_remove_child (_tmp26_, _tmp29_);
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30_ = self->priv->_foreground_cur;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30__length1 = self->priv->_foreground_cur_length1;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30__length2 = self->priv->_foreground_cur_length2;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp31_ = i;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp32_ = j;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_]);
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_] = NULL;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34_ = self->priv->_foreground_nxt;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34__length1 = self->priv->_foreground_nxt_length1;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34__length2 = self->priv->_foreground_nxt_length2;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp35_ = i;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp36_ = j;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_]);
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = NULL;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (tile);
#line 4590 "game.c"
							}
						}
					}
				}
			}
		}
	}
}


static void _game_restore_foreground (Game* self, gboolean animate) {
	guint val = 0U;
	GridPosition pos = {0};
	Tile tile = {0};
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GeeLinkedList* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
#line 602 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = animate;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_show_hide_transition (self, _tmp6_);
#line 4639 "game.c"
	{
		gint i = 0;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4644 "game.c"
		{
			gboolean _tmp7_ = FALSE;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp7_ = TRUE;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4651 "game.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp7_) {
#line 4656 "game.c"
					gint _tmp8_ = 0;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp8_ = i;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp8_ + 1;
#line 4662 "game.c"
				}
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp7_ = FALSE;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = i;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp10_ = rows;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4674 "game.c"
				}
				{
					gint j = 0;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4680 "game.c"
					{
						gboolean _tmp11_ = FALSE;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp11_ = TRUE;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4687 "game.c"
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Grid* _tmp15_ = NULL;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							guint _tmp18_ = 0U;
							guint _tmp19_ = 0U;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp11_) {
#line 4697 "game.c"
								gint _tmp12_ = 0;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp12_ = j;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp12_ + 1;
#line 4703 "game.c"
							}
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp11_ = FALSE;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = j;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = cols;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp13_ < _tmp14_)) {
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4715 "game.c"
							}
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = self->priv->_grid;
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = i;
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = j;
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = grid_get (_tmp15_, _tmp16_, _tmp17_);
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							val = _tmp18_;
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = val;
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp19_ != ((guint) 0)) {
#line 4731 "game.c"
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								GridPosition _tmp22_ = {0};
								GridPosition _tmp23_ = {0};
								guint _tmp24_ = 0U;
								Tile _tmp25_ = {0};
								Tile _tmp26_ = {0};
								GeeLinkedList* _tmp27_ = NULL;
								Tile _tmp28_ = {0};
								GridPosition _tmp29_ = {0};
#line 616 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp20_ = i;
#line 616 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp21_ = j;
#line 616 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_.row = (guint) _tmp20_;
#line 616 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_.col = (guint) _tmp21_;
#line 616 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								pos = _tmp22_;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = pos;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = val;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_.pos = _tmp23_;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_.val = _tmp24_;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								tile = _tmp25_;
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp26_ = tile;
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_game_create_tile (self, &_tmp26_);
#line 619 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = self->priv->_to_show;
#line 619 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp28_ = tile;
#line 619 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, &_tmp28_);
#line 620 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp29_ = pos;
#line 620 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_game_show_tile (self, &_tmp29_);
#line 4776 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_to_show;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = _tmp31_;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp32_ > 0) {
#line 4792 "game.c"
		ClutterTransitionGroup* _tmp33_ = NULL;
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_RESTORING_TILES;
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp33_ = self->priv->_show_hide_trans;
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp33_);
#line 4800 "game.c"
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (self) {
#line 4809 "game.c"
		gchar* _tmp0_ = NULL;
#line 38 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4817 "game.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4826 "game.c"
	}
}


static void _game_on_move_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Grid* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint delta_score = 0U;
	ClutterTransitionGroup* _tmp8_ = NULL;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	ClutterTransitionGroup* _tmp42_ = NULL;
#line 631 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = is_finished;
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = bool_to_string (_tmp0_);
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_strconcat ("move animation stopped; finished ", _tmp2_, NULL);
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:633: %s", _tmp4_);
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp2_);
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_grid;
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_to_string (_tmp5_);
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_;
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:634: %s", _tmp7_);
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp7_);
#line 638 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = self->priv->_move_trans;
#line 638 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_remove_all (_tmp8_);
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_show_hide_transition (self, TRUE);
#line 4879 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _e_index = 0;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_to_hide;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp10_;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = _e_list;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = _tmp12_;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp13_;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 4907 "game.c"
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			TileMovement* _tmp20_ = NULL;
			GridPosition _tmp21_ = {0};
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp14_ + 1;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_index;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_size;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 4929 "game.c"
			}
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_list;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = _e_index;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp19_;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = e;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = (*_tmp20_).from;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_dim_tile (self, &_tmp21_);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 4947 "game.c"
		}
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 4951 "game.c"
	}
#line 646 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	delta_score = (guint) 0;
#line 4955 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _e_index = 0;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp22_ = self->priv->_to_show;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp23_;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _e_list;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = _tmp25_;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp26_;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 4983 "game.c"
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			Tile* _tmp33_ = NULL;
			Tile _tmp34_ = {0};
			Tile* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			Tile* _tmp38_ = NULL;
			guint _tmp39_ = 0U;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = _e_index;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp27_ + 1;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_size;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp28_ < _tmp29_)) {
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5010 "game.c"
			}
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_list;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_index;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (Tile*) _tmp32_;
#line 648 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = e;
#line 648 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = *_tmp33_;
#line 648 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_create_tile (self, &_tmp34_);
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = e;
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = (*_tmp35_).pos;
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_show_tile (self, &_tmp36_);
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = delta_score;
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = e;
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp39_ = (*_tmp38_).val;
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			delta_score = _tmp37_ + _tmp39_;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_free0 (e);
#line 5042 "game.c"
		}
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5046 "game.c"
	}
#line 652 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_score;
#line 652 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = delta_score;
#line 652 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, _tmp40_ + _tmp41_);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_random_tile (self);
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = self->priv->_show_hide_trans;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_start ((ClutterTimeline*) _tmp42_);
#line 5060 "game.c"
}


static gboolean __game_finish_move_gsource_func (gpointer self) {
	gboolean result;
	result = _game_finish_move ((Game*) self);
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5069 "game.c"
}


static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	ClutterTransitionGroup* _tmp5_ = NULL;
	ClutterTimelineDirection _tmp6_ = 0;
	ClutterTimelineDirection _tmp7_ = 0;
	Grid* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	ClutterTransitionGroup* _tmp13_ = NULL;
#line 659 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = is_finished;
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = bool_to_string (_tmp0_);
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_strconcat ("show/hide animation stopped; finished ", _tmp2_, NULL);
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:661: %s", _tmp4_);
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp2_);
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_show_hide_trans;
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = clutter_timeline_get_direction ((ClutterTimeline*) _tmp5_);
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_;
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp7_ == CLUTTER_TIMELINE_FORWARD) {
#line 5112 "game.c"
		ClutterTransitionGroup* _tmp8_ = NULL;
		ClutterTransitionGroup* _tmp9_ = NULL;
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_show_hide_trans;
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_set_direction ((ClutterTimeline*) _tmp8_, CLUTTER_TIMELINE_BACKWARD);
#line 665 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_show_hide_trans;
#line 665 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp9_);
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return;
#line 5125 "game.c"
	}
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_grid;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = grid_to_string (_tmp10_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:669: %s", _tmp12_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp12_);
#line 671 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_show_hide_trans;
#line 671 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_remove_all (_tmp13_);
#line 5141 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		GeeLinkedList* _tmp15_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _e_index = 0;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = self->priv->_to_hide;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp15_;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp16_ = _e_list;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp18_ = _tmp17_;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp18_;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5169 "game.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			TileView* view = NULL;
			TileView** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			TileMovement* _tmp26_ = NULL;
			GridPosition _tmp27_ = {0};
			guint _tmp28_ = 0U;
			TileMovement* _tmp29_ = NULL;
			GridPosition _tmp30_ = {0};
			guint _tmp31_ = 0U;
			TileView* _tmp32_ = NULL;
			TileView* _tmp33_ = NULL;
			TileView* _tmp34_ = NULL;
			ClutterActor* _tmp35_ = NULL;
			ClutterActor* _tmp36_ = NULL;
			TileView** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp37__length2 = 0;
			TileMovement* _tmp38_ = NULL;
			GridPosition _tmp39_ = {0};
			guint _tmp40_ = 0U;
			TileMovement* _tmp41_ = NULL;
			GridPosition _tmp42_ = {0};
			guint _tmp43_ = 0U;
			TileView* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
			guint _tmp46_ = 0U;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			ClutterActor* _tmp51_ = NULL;
			TileView* _tmp52_ = NULL;
			ClutterActor* _tmp53_ = NULL;
			ClutterActor* _tmp54_ = NULL;
			TileView** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gint _tmp55__length2 = 0;
			TileMovement* _tmp56_ = NULL;
			GridPosition _tmp57_ = {0};
			guint _tmp58_ = 0U;
			TileMovement* _tmp59_ = NULL;
			GridPosition _tmp60_ = {0};
			guint _tmp61_ = 0U;
			TileView* _tmp62_ = NULL;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = _e_index;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp19_ + 1;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = _e_index;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = _e_size;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp20_ < _tmp21_)) {
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5234 "game.c"
			}
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = _e_list;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp23_ = _e_index;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp24_;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25_ = self->priv->_foreground_cur;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25__length1 = self->priv->_foreground_cur_length1;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25__length2 = self->priv->_foreground_cur_length2;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp26_ = e;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = (*_tmp26_).from;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _tmp27_.row;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = e;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = (*_tmp29_).from;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _tmp30_.col;
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _tmp25_[(_tmp28_ * _tmp25__length2) + _tmp31_];
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 674 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			view = _tmp33_;
#line 675 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = view;
#line 675 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp34_);
#line 675 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = _tmp35_;
#line 675 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			clutter_actor_hide (_tmp36_);
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = self->priv->_foreground_cur;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37__length1 = self->priv->_foreground_cur_length1;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37__length2 = self->priv->_foreground_cur_length2;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = e;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp39_ = (*_tmp38_).from;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp40_ = _tmp39_.row;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp41_ = e;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp42_ = (*_tmp41_).from;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp43_ = _tmp42_.col;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp44_ = _tmp37_[(_tmp40_ * _tmp37__length2) + _tmp43_];
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp45_ = tile_view_get_value (_tmp44_);
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp46_ = _tmp45_;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp47_ = g_strdup_printf ("%u", _tmp46_);
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp48_ = _tmp47_;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp49_ = g_strconcat ("remove child ", _tmp48_, NULL);
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_ = _tmp49_;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_debug ("game.vala:676: %s", _tmp50_);
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (_tmp50_);
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (_tmp48_);
#line 677 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp51_ = self->priv->_view;
#line 677 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp52_ = view;
#line 677 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp53_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp52_);
#line 677 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp54_ = _tmp53_;
#line 677 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			clutter_actor_remove_child (_tmp51_, _tmp54_);
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_ = self->priv->_foreground_cur;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55__length1 = self->priv->_foreground_cur_length1;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55__length2 = self->priv->_foreground_cur_length2;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp56_ = e;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57_ = (*_tmp56_).from;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp58_ = _tmp57_.row;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp59_ = e;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp60_ = (*_tmp59_).from;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp61_ = _tmp60_.col;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_]);
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_] = NULL;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp62_ = _tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_];
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (view);
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 5352 "game.c"
		}
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5356 "game.c"
	}
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __game_finish_move_gsource_func, g_object_ref (self), g_object_unref);
#line 5360 "game.c"
}


static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
#line 688 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_show_hide_trans_stopped ((Game*) self, is_finished);
#line 5367 "game.c"
}


static void _game_create_show_hide_transition (Game* self, gboolean animate) {
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	ClutterTransitionGroup* _tmp5_ = NULL;
#line 685 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_show_hide_trans);
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_show_hide_trans = _tmp0_;
#line 688 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_show_hide_trans;
#line 688 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_show_hide_trans_stopped_clutter_timeline_stopped, self, 0);
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = animate;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp3_) {
#line 5393 "game.c"
		gint _tmp4_ = 0;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_animations_duration;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = _tmp4_;
#line 5399 "game.c"
	} else {
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = 10;
#line 5403 "game.c"
	}
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_show_hide_trans;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp5_, (guint) _tmp2_);
#line 5409 "game.c"
}


static gboolean _game_finish_move (Game* self) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	GeeLinkedList* _tmp75_ = NULL;
	GeeLinkedList* _tmp76_ = NULL;
	GeeLinkedList* _tmp77_ = NULL;
	Grid* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	Grid* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
#line 692 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_state;
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_SHOWING_SECOND_TILE;
#line 696 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_debug ("game.vala:696: state show second tile");
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_random_tile (self);
#line 5436 "game.c"
	} else {
		GameGameState _tmp1_ = 0;
#line 698 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp1_ = self->priv->_state;
#line 698 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp1_ == GAME_GAME_STATE_SHOWING_SECOND_TILE) {
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			self->priv->_state = GAME_GAME_STATE_IDLE;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_debug ("game.vala:700: state idle");
#line 5447 "game.c"
		} else {
			GameGameState _tmp2_ = 0;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp2_ = self->priv->_state;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_tmp2_ != GAME_GAME_STATE_IDLE) {
#line 702 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				self->priv->_state = GAME_GAME_STATE_IDLE;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				g_debug ("game.vala:703: state idle");
#line 5458 "game.c"
			}
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _e_index = 0;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = self->priv->_to_move;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp4_;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = _e_list;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = _tmp6_;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp7_;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5489 "game.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			TileView** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			TileMovement* _tmp15_ = NULL;
			GridPosition _tmp16_ = {0};
			guint _tmp17_ = 0U;
			TileMovement* _tmp18_ = NULL;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			TileView** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			TileMovement* _tmp22_ = NULL;
			GridPosition _tmp23_ = {0};
			guint _tmp24_ = 0U;
			TileMovement* _tmp25_ = NULL;
			GridPosition _tmp26_ = {0};
			guint _tmp27_ = 0U;
			TileView* _tmp28_ = NULL;
			TileView* _tmp29_ = NULL;
			TileView* _tmp30_ = NULL;
			TileView** _tmp31_ = NULL;
			gint _tmp31__length1 = 0;
			gint _tmp31__length2 = 0;
			TileMovement* _tmp32_ = NULL;
			GridPosition _tmp33_ = {0};
			guint _tmp34_ = 0U;
			TileMovement* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			TileView* _tmp38_ = NULL;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp8_ = _e_index;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp8_ + 1;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp9_ = _e_index;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp10_ = _e_size;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5540 "game.c"
			}
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp11_ = _e_list;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp12_ = _e_index;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp13_;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = self->priv->_foreground_cur;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14__length1 = self->priv->_foreground_cur_length1;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14__length2 = self->priv->_foreground_cur_length2;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = e;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = (*_tmp15_).to;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _tmp16_.row;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = e;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = (*_tmp18_).to;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = _tmp19_.col;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = self->priv->_foreground_nxt;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21__length1 = self->priv->_foreground_nxt_length1;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21__length2 = self->priv->_foreground_nxt_length2;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = e;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp23_ = (*_tmp22_).to;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp24_ = _tmp23_.row;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25_ = e;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp26_ = (*_tmp25_).to;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = _tmp26_.col;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _tmp21_[(_tmp24_ * _tmp21__length2) + _tmp27_];
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _g_object_ref0 (_tmp28_);
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_]);
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_] = _tmp29_;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_];
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = self->priv->_foreground_nxt;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31__length1 = self->priv->_foreground_nxt_length1;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31__length2 = self->priv->_foreground_nxt_length2;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = e;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = (*_tmp32_).to;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = _tmp33_.row;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = e;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = (*_tmp35_).to;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = _tmp36_.col;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_]);
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_] = NULL;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = _tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_];
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 5622 "game.c"
		}
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5626 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp39_ = NULL;
		GeeLinkedList* _tmp40_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		gint _e_index = 0;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = self->priv->_to_show;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp40_;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp41_ = _e_list;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp42_;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp43_;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5655 "game.c"
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gpointer _tmp49_ = NULL;
			TileView** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gint _tmp50__length2 = 0;
			Tile* _tmp51_ = NULL;
			GridPosition _tmp52_ = {0};
			guint _tmp53_ = 0U;
			Tile* _tmp54_ = NULL;
			GridPosition _tmp55_ = {0};
			guint _tmp56_ = 0U;
			TileView** _tmp57_ = NULL;
			gint _tmp57__length1 = 0;
			gint _tmp57__length2 = 0;
			Tile* _tmp58_ = NULL;
			GridPosition _tmp59_ = {0};
			guint _tmp60_ = 0U;
			Tile* _tmp61_ = NULL;
			GridPosition _tmp62_ = {0};
			guint _tmp63_ = 0U;
			TileView* _tmp64_ = NULL;
			TileView* _tmp65_ = NULL;
			TileView* _tmp66_ = NULL;
			TileView** _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			Tile* _tmp68_ = NULL;
			GridPosition _tmp69_ = {0};
			guint _tmp70_ = 0U;
			Tile* _tmp71_ = NULL;
			GridPosition _tmp72_ = {0};
			guint _tmp73_ = 0U;
			TileView* _tmp74_ = NULL;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp44_ = _e_index;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp44_ + 1;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp45_ = _e_index;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp46_ = _e_size;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp45_ < _tmp46_)) {
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5706 "game.c"
			}
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp47_ = _e_list;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp48_ = _e_index;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (Tile*) _tmp49_;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_ = self->priv->_foreground_cur;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50__length1 = self->priv->_foreground_cur_length1;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50__length2 = self->priv->_foreground_cur_length2;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp51_ = e;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp52_ = (*_tmp51_).pos;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp53_ = _tmp52_.row;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp54_ = e;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_ = (*_tmp54_).pos;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp56_ = _tmp55_.col;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57_ = self->priv->_foreground_nxt;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57__length1 = self->priv->_foreground_nxt_length1;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57__length2 = self->priv->_foreground_nxt_length2;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp58_ = e;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp59_ = (*_tmp58_).pos;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp60_ = _tmp59_.row;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp61_ = e;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp62_ = (*_tmp61_).pos;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp63_ = _tmp62_.col;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp64_ = _tmp57_[(_tmp60_ * _tmp57__length2) + _tmp63_];
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp65_ = _g_object_ref0 (_tmp64_);
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_]);
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_] = _tmp65_;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp66_ = _tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_];
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67_ = self->priv->_foreground_nxt;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67__length1 = self->priv->_foreground_nxt_length1;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67__length2 = self->priv->_foreground_nxt_length2;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp68_ = e;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp69_ = (*_tmp68_).pos;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp70_ = _tmp69_.row;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp71_ = e;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp72_ = (*_tmp71_).pos;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp73_ = _tmp72_.col;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_]);
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_] = NULL;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp74_ = _tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_];
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_free0 (e);
#line 5788 "game.c"
		}
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5792 "game.c"
	}
#line 715 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp75_ = self->priv->_to_hide;
#line 715 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp75_);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp76_ = self->priv->_to_move;
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
#line 717 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp77_ = self->priv->_to_show;
#line 717 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
#line 719 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp78_ = self->priv->_grid;
#line 719 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp79_ = grid_get_target_value_reached (_tmp78_);
#line 719 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp80_ = _tmp79_;
#line 719 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp80_) {
#line 5814 "game.c"
		Grid* _tmp81_ = NULL;
		guint _tmp82_ = 0U;
		guint _tmp83_ = 0U;
		Grid* _tmp84_ = NULL;
#line 720 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp81_ = self->priv->_grid;
#line 720 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp82_ = grid_get_target_value (_tmp81_);
#line 720 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp83_ = _tmp82_;
#line 720 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "target-value-reached", _tmp83_);
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp84_ = self->priv->_grid;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		grid_set_target_value_reached (_tmp84_, FALSE);
#line 5831 "game.c"
	}
#line 724 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp85_ = self->priv->_grid;
#line 724 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp86_ = grid_is_finished (_tmp85_);
#line 724 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp86_) {
#line 725 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "finished");
#line 5841 "game.c"
	}
#line 727 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 727 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5847 "game.c"
}


static void _game_store_movement (Game* self) {
	gboolean _tmp0_ = FALSE;
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 732 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_allow_undo;
#line 732 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_) {
#line 5859 "game.c"
		GeeLinkedList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		guint _tmp4_ = 0U;
		GeeLinkedList* _tmp8_ = NULL;
		Grid* _tmp9_ = NULL;
		Grid* _tmp10_ = NULL;
		Grid* _tmp11_ = NULL;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp1_ = self->priv->_undo_stack;
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = _tmp2_;
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_undo_stack_max_size;
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (((guint) _tmp3_) == _tmp4_) {
#line 5881 "game.c"
			GeeLinkedList* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			Grid* _tmp7_ = NULL;
#line 734 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp5_ = self->priv->_undo_stack;
#line 734 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) _tmp5_);
#line 734 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp7_ = (Grid*) _tmp6_;
#line 734 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp7_);
#line 5893 "game.c"
		}
#line 735 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_undo_stack;
#line 735 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_grid;
#line 735 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = grid_clone (_tmp9_);
#line 735 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = _tmp10_;
#line 735 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_deque_offer_head ((GeeDeque*) _tmp8_, _tmp11_);
#line 735 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_tmp11_);
#line 736 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = self->priv->_undo_stack;
#line 736 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 736 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = _tmp13_;
#line 736 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp14_ == 1) {
#line 737 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_signal_emit_by_name (self, "undo-enabled");
#line 5917 "game.c"
		}
	}
}


ClutterActor* game_get_view (Game* self) {
	ClutterActor* result;
	ClutterActor* _tmp0_ = NULL;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_view;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5934 "game.c"
}


static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_allocation_changed ((Game*) self, box, flags);
#line 5941 "game.c"
}


void game_set_view (Game* self, ClutterActor* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = value;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_view);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_view = _tmp1_;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_view;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object (_tmp2_, "allocation-changed", (GCallback) __game_on_allocation_changed_clutter_actor_allocation_changed, self, 0);
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_notify ((GObject *) self, "view");
#line 5965 "game.c"
}


guint game_get_score (Game* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_score;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5980 "game.c"
}


void game_set_score (Game* self, guint value) {
	guint _tmp0_ = 0U;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = value;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_score = _tmp0_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_notify ((GObject *) self, "score");
#line 5994 "game.c"
}


static void game_class_init (GameClass * klass) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW, g_param_spec_object ("view", "view", "view", clutter_actor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE, g_param_spec_uint ("score", "score", "score", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("finished", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("target_value_reached", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("undo_enabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("undo_disabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6021 "game.c"
}


static void game_instance_init (Game * self) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 33 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->BLANK_ROW_HEIGHT = 10;
#line 34 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->BLANK_COL_WIDTH = 10;
#line 6032 "game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 38 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_view);
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_move);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_hide);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_show);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_show_hide_trans);
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_undo_stack);
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_settings);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (self->priv->_saved_path);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 6068 "game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	switch (property_id) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_VIEW:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_value_set_object (value, game_get_view (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_SCORE:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_value_set_uint (value, game_get_score (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6101 "game.c"
		default:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6107 "game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	switch (property_id) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_VIEW:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		game_set_view (self, g_value_get_object (value));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_SCORE:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		game_set_score (self, g_value_get_uint (value));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6129 "game.c"
		default:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6135 "game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



