/* application.c generated by valac 0.29.2.9-c6c2, the Vala compiler
 * generated from application.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgames-support.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <locale.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* _settings;
	GtkWindow* _window;
	GtkHeaderBar* _header_bar;
	GtkButton* _undo_button;
	GtkButton* _new_game_button;
	GtkAboutDialog* _about_dialog;
	GtkDialog* _preferences_dialog;
	GtkDialog* _congrats_dialog;
	GtkLabel* _congrats_message;
	GtkLabel* _score;
	GtkComboBoxText* _grid_size_combo;
	GamesScoresContext* _scores_ctx;
	GamesScoresCategory* _grid4_cat;
	GamesScoresCategory* _grid5_cat;
	gboolean _game_restored;
	gint _window_width;
	gint _window_height;
	gboolean _window_maximized;
	gint WINDOW_MINIMUM_SIZE_HEIGHT;
	gint WINDOW_MINIMUM_SIZE_WIDTH;
	Game* _game;
};


static gpointer application_parent_class = NULL;

GType application_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static void application_new_game_cb (Application* self);
static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_undo_cb (Application* self);
static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_scores_cb (Application* self);
static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_about_cb (Application* self);
static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_preferences_cb (Application* self);
static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_quit_cb (Application* self);
static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_help_cb (Application* self);
static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Application* application_new (void);
Application* application_construct (GType object_type);
static void application_real_startup (GApplication* base);
static void _application_init_style (Application* self);
static void _application_init_app_menu (Application* self);
static void _application_init_game (Application* self);
static void application_real_activate (GApplication* base);
static void _application_create_window (Application* self, GtkBuilder* builder);
static void _application_create_about_dialog (Application* self);
static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder);
static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder);
static void _application_create_scores (Application* self);
gboolean game_restore_game (Game* self);
static void application_real_shutdown (GApplication* base);
void game_save_game (Game* self);
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
static void __lambda4_ (Application* self, GObject* s, GParamSpec* p);
guint game_get_score (Game* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (Application* self, Game* s);
static void ___lambda5__game_finished (Game* _sender, gpointer self);
static void __lambda6_ (Application* self, Game* s, guint v);
static void ___lambda6__game_target_value_reached (Game* _sender, guint val, gpointer self);
static void __lambda7_ (Application* self, Game* s);
static void ___lambda7__game_undo_enabled (Game* _sender, gpointer self);
static void __lambda8_ (Application* self, Game* s);
static void ___lambda8__game_undo_disabled (Game* _sender, gpointer self);
static void _application_create_header_bar (Application* self);
static void _application_create_game_view (Application* self, GtkBuilder* builder);
static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean application_window_configure_event_cb (Application* self, GdkEventConfigure* event);
static gboolean _application_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event);
static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
void game_set_view (Game* self, ClutterActor* value);
static void __lambda9_ (Application* self, gint response_id);
static void ___lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda10_ (Application* self, GdkEventAny* response_id);
static gboolean ___lambda10__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda11_ (Application* self, gint response_id);
static void ___lambda11__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda12_ (Application* self, GdkEventAny* response_id);
gboolean game_reload_settings (Game* self);
static gboolean ___lambda12__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda13_ (Application* self, gint response_id);
static void ___lambda13__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda14_ (Application* self, GdkEventAny* response_id);
static gboolean ___lambda14__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static GamesScoresCategory* __lambda15_ (Application* self, GamesScoresContext* s, const gchar* key);
static GamesScoresCategory* ___lambda15__games_scores_context_category_request (GamesScoresContext* _sender, const gchar* category_key, gpointer self);
void game_new_game (Game* self);
void game_undo (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
gint application_main (gchar** args, int args_length1);
static void application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_action_entries[7] = {{"new-game", _application_new_game_cb_gsimple_action_activate_callback}, {"undo", _application_undo_cb_gsimple_action_activate_callback}, {"scores", _application_scores_cb_gsimple_action_activate_callback}, {"about", _application_about_cb_gsimple_action_activate_callback}, {"preferences", _application_preferences_cb_gsimple_action_activate_callback}, {"quit", _application_quit_cb_gsimple_action_activate_callback}, {"help", _application_help_cb_gsimple_action_activate_callback}};

static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_new_game_cb ((Application*) self);
}


static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_undo_cb ((Application*) self);
}


static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_scores_cb ((Application*) self);
}


static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_about_cb ((Application*) self);
}


static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_preferences_cb ((Application*) self);
}


static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_quit_cb ((Application*) self);
}


static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_help_cb ((Application*) self);
}


Application* application_construct (GType object_type) {
	Application * self = NULL;
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.gnome-2048", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Application* application_new (void) {
	return application_construct (TYPE_APPLICATION);
}


static void application_real_startup (GApplication* base) {
	Application * self;
	GSettings* _tmp0_ = NULL;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, APPLICATION_action_entries, G_N_ELEMENTS (APPLICATION_action_entries), self);
	gtk_application_add_accelerator ((GtkApplication*) self, "F1", "app.help", NULL);
	_tmp0_ = g_settings_new ("org.gnome.2048");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_application_init_style (self);
	_application_init_app_menu (self);
	_application_init_game (self);
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	_tmp1_ = builder;
	_application_create_window (self, _tmp1_);
	_application_create_about_dialog (self);
	_tmp2_ = builder;
	_application_create_preferences_dialog (self, _tmp2_);
	_tmp3_ = builder;
	_application_create_congrats_dialog (self, _tmp3_);
	_application_create_scores (self);
	_tmp4_ = self->priv->_window;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->_game;
	_tmp6_ = game_restore_game (_tmp5_);
	self->priv->_game_restored = _tmp6_;
	_tmp7_ = self->priv->_game_restored;
	if (!_tmp7_) {
		application_new_game_cb (self);
	}
	_g_object_unref0 (builder);
}


static void application_real_shutdown (GApplication* base) {
	Application * self;
	Game* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->_game;
	game_save_game (_tmp0_);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = self->priv->_window_width;
	g_settings_set_int (_tmp1_, "window-width", _tmp2_);
	_tmp3_ = self->priv->_settings;
	_tmp4_ = self->priv->_window_height;
	g_settings_set_int (_tmp3_, "window-height", _tmp4_);
	_tmp5_ = self->priv->_settings;
	_tmp6_ = self->priv->_window_maximized;
	g_settings_set_boolean (_tmp5_, "window-maximized", _tmp6_);
}


static void _application_init_style (Application* self) {
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GdkScreen* _tmp3_ = NULL;
		_tmp1_ = g_file_new_for_uri ("resource://org/gnome/gnome-2048/data/style.css");
		_tmp2_ = _tmp1_;
		gtk_css_provider_load_from_file (provider, _tmp2_, &_inner_error_);
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = gdk_screen_get_default ();
		gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (provider);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _application_init_app_menu (Application* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		GMenuModel* menu = NULL;
		GObject* _tmp1_ = NULL;
		GMenuModel* _tmp2_ = NULL;
		GMenuModel* _tmp3_ = NULL;
		gtk_builder_add_from_resource (builder, "/org/gnome/gnome-2048/data/menus.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp1_ = gtk_builder_get_object (builder, "app-menu");
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp1_) : NULL);
		menu = _tmp2_;
		_tmp3_ = menu;
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp3_);
		_g_object_unref0 (menu);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (builder);
}


static void __lambda4_ (Application* self, GObject* s, GParamSpec* p) {
	GtkLabel* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_score;
	_tmp1_ = self->priv->_game;
	_tmp2_ = game_get_score (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ ((Application*) self, _sender, pspec);
}


static void __lambda5_ (Application* self, Game* s) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_header_bar;
	_tmp1_ = _ ("Game Over");
	gtk_header_bar_set_subtitle (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->_game_restored;
	if (!_tmp2_) {
		{
			GamesScoresCategory* _tmp3_ = NULL;
			GSettings* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			GamesScoresCategory* cat = NULL;
			GamesScoresCategory* _tmp8_ = NULL;
			GamesScoresContext* _tmp9_ = NULL;
			Game* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
			guint _tmp12_ = 0U;
			GamesScoresCategory* _tmp13_ = NULL;
			GAction* _tmp14_ = NULL;
			_tmp4_ = self->priv->_settings;
			_tmp5_ = g_settings_get_int (_tmp4_, "rows");
			if (_tmp5_ == 4) {
				GamesScoresCategory* _tmp6_ = NULL;
				_tmp6_ = self->priv->_grid4_cat;
				_tmp3_ = _tmp6_;
			} else {
				GamesScoresCategory* _tmp7_ = NULL;
				_tmp7_ = self->priv->_grid5_cat;
				_tmp3_ = _tmp7_;
			}
			_tmp8_ = _g_object_ref0 (_tmp3_);
			cat = _tmp8_;
			_tmp9_ = self->priv->_scores_ctx;
			_tmp10_ = self->priv->_game;
			_tmp11_ = game_get_score (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = cat;
			games_scores_context_add_score (_tmp9_, (glong) _tmp12_, _tmp13_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (cat);
				goto __catch2_g_error;
			}
			_tmp14_ = g_action_map_lookup_action ((GActionMap*) self, "scores");
			g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_simple_action_get_type (), GSimpleAction), TRUE);
			_g_object_unref0 (cat);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = stderr;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			fprintf (_tmp15_, "%s\n", _tmp17_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("application.vala:156: finished");
}


static void ___lambda5__game_finished (Game* _sender, gpointer self) {
	__lambda5_ ((Application*) self, _sender);
}


static void __lambda6_ (Application* self, Game* s, guint v) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "do-congrat");
	if (_tmp1_) {
		gchar* message = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GSettings* _tmp7_ = NULL;
		_tmp2_ = _ ("You have obtained the $v tile");
		_tmp3_ = g_strdup (_tmp2_);
		message = _tmp3_;
		_tmp4_ = self->priv->_congrats_message;
		_tmp5_ = message;
		gtk_label_set_text (_tmp4_, _tmp5_);
		_tmp6_ = self->priv->_congrats_dialog;
		gtk_window_present ((GtkWindow*) _tmp6_);
		_tmp7_ = self->priv->_settings;
		g_settings_set_boolean (_tmp7_, "do-congrat", FALSE);
		_g_free0 (message);
	}
	g_debug ("application.vala:165: target value reached");
}


static void ___lambda6__game_target_value_reached (Game* _sender, guint val, gpointer self) {
	__lambda6_ ((Application*) self, _sender, val);
}


static void __lambda7_ (Application* self, Game* s) {
	GAction* _tmp0_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), TRUE);
}


static void ___lambda7__game_undo_enabled (Game* _sender, gpointer self) {
	__lambda7_ ((Application*) self, _sender);
}


static void __lambda8_ (Application* self, Game* s) {
	GAction* _tmp0_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), FALSE);
}


static void ___lambda8__game_undo_disabled (Game* _sender, gpointer self) {
	__lambda8_ ((Application*) self, _sender);
}


static void _application_init_game (Application* self) {
	GSettings* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = game_new (_tmp0_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp1_;
	_tmp2_ = self->priv->_game;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::score", (GCallback) ___lambda4__g_object_notify, self, 0);
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "finished", (GCallback) ___lambda5__game_finished, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "target-value-reached", (GCallback) ___lambda6__game_target_value_reached, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "undo-enabled", (GCallback) ___lambda7__game_undo_enabled, self, 0);
	_tmp6_ = self->priv->_game;
	g_signal_connect_object (_tmp6_, "undo-disabled", (GCallback) ___lambda8__game_undo_disabled, self, 0);
}


static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = application_key_press_event_cb ((Application*) self, _sender, event);
	return result;
}


static gboolean _application_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = application_window_configure_event_cb ((Application*) self, event);
	return result;
}


static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = application_window_state_event_cb ((Application*) self, event);
	return result;
}


static void _application_create_window (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GtkWindow* _tmp15_ = NULL;
	GtkBuilder* _tmp16_ = NULL;
	GtkWindow* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkWindow* _tmp20_ = NULL;
	GtkWindow* _tmp21_ = NULL;
	GtkWindow* _tmp22_ = NULL;
	GdkGeometry geom = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GtkWindow* _tmp25_ = NULL;
	GtkWindow* _tmp26_ = NULL;
	GdkGeometry _tmp27_ = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	{
		GtkBuilder* _tmp0_ = NULL;
		_tmp0_ = builder;
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/mainwindow.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "applicationwindow");
	_tmp6_ = _g_object_ref0 ((GtkWindow*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp5_) : NULL));
	_g_object_unref0 (self->priv->_window);
	self->priv->_window = _tmp6_;
	_tmp7_ = self->priv->_window;
	_tmp8_ = self->priv->_settings;
	_tmp9_ = g_settings_get_int (_tmp8_, "window-width");
	_tmp10_ = self->priv->_settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "window-height");
	gtk_window_set_default_size (_tmp7_, _tmp9_, _tmp11_);
	_tmp12_ = self->priv->_settings;
	_tmp13_ = g_settings_get_boolean (_tmp12_, "window-maximized");
	if (_tmp13_) {
		GtkWindow* _tmp14_ = NULL;
		_tmp14_ = self->priv->_window;
		gtk_window_maximize (_tmp14_);
	}
	_tmp15_ = self->priv->_window;
	gtk_application_add_window ((GtkApplication*) self, _tmp15_);
	_application_create_header_bar (self);
	_tmp16_ = builder;
	_application_create_game_view (self, _tmp16_);
	_tmp17_ = self->priv->_window;
	_tmp18_ = self->priv->_window;
	_tmp19_ = gtk_widget_get_events ((GtkWidget*) _tmp18_);
	gtk_widget_set_events ((GtkWidget*) _tmp17_, ((_tmp19_ | GDK_STRUCTURE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK);
	_tmp20_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp20_, "key-press-event", (GCallback) _application_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	_tmp21_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "configure-event", (GCallback) _application_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp22_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "window-state-event", (GCallback) _application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	memset (&geom, 0, sizeof (GdkGeometry));
	_tmp23_ = self->priv->WINDOW_MINIMUM_SIZE_HEIGHT;
	geom.min_height = _tmp23_;
	_tmp24_ = self->priv->WINDOW_MINIMUM_SIZE_WIDTH;
	geom.min_width = _tmp24_;
	_tmp25_ = self->priv->_window;
	_tmp26_ = self->priv->_window;
	_tmp27_ = geom;
	gtk_window_set_geometry_hints (_tmp25_, (GtkWidget*) _tmp26_, &_tmp27_, GDK_HINT_MIN_SIZE);
}


static void _application_create_header_bar (Application* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkHeaderBar* _tmp1_ = NULL;
	GtkHeaderBar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkHeaderBar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkHeaderBar* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkHeaderBar* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp0_;
	_tmp1_ = self->priv->_header_bar;
	gtk_header_bar_set_show_close_button (_tmp1_, TRUE);
	_tmp2_ = self->priv->_header_bar;
	gtk_header_bar_set_title (_tmp2_, "2048");
	_tmp3_ = self->priv->_window;
	_tmp4_ = self->priv->_header_bar;
	gtk_window_set_titlebar (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkLabel*) gtk_label_new ("0");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->_score);
	self->priv->_score = _tmp5_;
	_tmp6_ = self->priv->_header_bar;
	_tmp7_ = self->priv->_score;
	gtk_header_bar_pack_end (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->_undo_button);
	self->priv->_undo_button = _tmp8_;
	_tmp9_ = self->priv->_undo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp9_, "app.undo");
	_tmp10_ = self->priv->_header_bar;
	_tmp11_ = self->priv->_undo_button;
	gtk_header_bar_pack_start (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction), FALSE);
	_tmp13_ = _ ("New Game");
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->_new_game_button);
	self->priv->_new_game_button = _tmp14_;
	_tmp15_ = self->priv->_new_game_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp15_, "app.new-game");
	_tmp16_ = self->priv->_header_bar;
	_tmp17_ = self->priv->_new_game_button;
	gtk_header_bar_pack_start (_tmp16_, (GtkWidget*) _tmp17_);
}


static void _application_create_game_view (Application* self, GtkBuilder* builder) {
	GtkClutterEmbed* embed = NULL;
	GtkClutterEmbed* _tmp0_ = NULL;
	GtkAspectFrame* frame = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkAspectFrame* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = (GtkClutterEmbed*) gtk_clutter_embed_new ();
	g_object_ref_sink (_tmp0_);
	embed = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "aspectframe");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_aspect_frame_get_type ()) ? ((GtkAspectFrame*) _tmp2_) : NULL);
	frame = _tmp3_;
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) embed);
	_tmp4_ = self->priv->_game;
	_tmp5_ = gtk_clutter_embed_get_stage (embed);
	game_set_view (_tmp4_, _tmp5_);
	_g_object_unref0 (frame);
	_g_object_unref0 (embed);
}


static void __lambda9_ (Application* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
	_tmp0_ = self->priv->_about_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void ___lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda9_ ((Application*) self, response_id);
}


static gboolean __lambda10_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	GtkAboutDialog* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (response_id != NULL, FALSE);
	_tmp0_ = self->priv->_about_dialog;
	_tmp1_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda10__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda10_ ((Application*) self, event);
	return result;
}


static void _application_create_about_dialog (Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkAboutDialog* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	GtkAboutDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	GtkAboutDialog* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	GtkAboutDialog* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_about_dialog);
	self->priv->_about_dialog = _tmp0_;
	_tmp1_ = self->priv->_about_dialog;
	_tmp2_ = self->priv->_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->_about_dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp3_, TRUE);
	_tmp4_ = self->priv->_about_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
	_tmp5_ = self->priv->_about_dialog;
	gtk_about_dialog_set_program_name (_tmp5_, "2048");
	_tmp6_ = self->priv->_about_dialog;
	gtk_about_dialog_set_logo_icon_name (_tmp6_, "gnome-2048");
	_tmp7_ = self->priv->_about_dialog;
	_tmp8_ = _ ("A clone of 2048 for GNOME");
	gtk_about_dialog_set_comments (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->_about_dialog;
	_tmp10_ = g_strdup ("Juan R. García Blanco");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_about_dialog_set_authors (_tmp9_, _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = self->priv->_about_dialog;
	gtk_about_dialog_set_copyright (_tmp13_, "Copyright © 2014-2015 Juan R. García Blanco");
	_tmp14_ = self->priv->_about_dialog;
	gtk_about_dialog_set_version (_tmp14_, VERSION);
	_tmp15_ = self->priv->_about_dialog;
	gtk_about_dialog_set_website (_tmp15_, "http://www.gnome.org");
	_tmp16_ = self->priv->_about_dialog;
	gtk_about_dialog_set_license_type (_tmp16_, GTK_LICENSE_GPL_3_0);
	_tmp17_ = self->priv->_about_dialog;
	gtk_about_dialog_set_wrap_license (_tmp17_, FALSE);
	_tmp18_ = self->priv->_about_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda9__gtk_dialog_response, self, 0);
	_tmp19_ = self->priv->_about_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp19_, "delete-event", (GCallback) ___lambda10__gtk_widget_delete_event, self, 0);
}


static void __lambda11_ (Application* self, gint response_id) {
	GtkDialog* _tmp0_ = NULL;
	_tmp0_ = self->priv->_preferences_dialog;
	gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
}


static void ___lambda11__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda11_ ((Application*) self, response_id);
}


static gboolean __lambda12_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	gint grid_size = 0;
	gint rows = 0;
	gint cols = 0;
	gboolean settings_changed = FALSE;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Game* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkDialog* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (response_id != NULL, FALSE);
	_tmp0_ = self->priv->_grid_size_combo;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	grid_size = _tmp1_;
	_tmp2_ = grid_size;
	if (_tmp2_ == 0) {
		gint _tmp3_ = 0;
		cols = 4;
		_tmp3_ = cols;
		rows = _tmp3_;
	} else {
		gint _tmp4_ = 0;
		cols = 5;
		_tmp4_ = cols;
		rows = _tmp4_;
	}
	_tmp5_ = self->priv->_settings;
	_tmp6_ = rows;
	g_settings_set_int (_tmp5_, "rows", _tmp6_);
	_tmp7_ = self->priv->_settings;
	_tmp8_ = cols;
	g_settings_set_int (_tmp7_, "cols", _tmp8_);
	_tmp9_ = self->priv->_game;
	_tmp10_ = game_reload_settings (_tmp9_);
	settings_changed = _tmp10_;
	_tmp11_ = settings_changed;
	if (_tmp11_) {
		application_new_game_cb (self);
	}
	_tmp12_ = self->priv->_preferences_dialog;
	_tmp13_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp12_);
	result = _tmp13_;
	return result;
}


static gboolean ___lambda12__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda12_ ((Application*) self, event);
	return result;
}


static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GtkComboBoxText* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	{
		GtkBuilder* _tmp0_ = NULL;
		_tmp0_ = builder;
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/preferences.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "preferencesdialog");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->_preferences_dialog);
	self->priv->_preferences_dialog = _tmp6_;
	_tmp7_ = self->priv->_preferences_dialog;
	_tmp8_ = self->priv->_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "gridsizecombo");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_combo_box_text_get_type ()) ? ((GtkComboBoxText*) _tmp10_) : NULL);
	_g_object_unref0 (self->priv->_grid_size_combo);
	self->priv->_grid_size_combo = _tmp11_;
	_tmp12_ = self->priv->_preferences_dialog;
	g_signal_connect_object (_tmp12_, "response", (GCallback) ___lambda11__gtk_dialog_response, self, 0);
	_tmp13_ = self->priv->_preferences_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "delete-event", (GCallback) ___lambda12__gtk_widget_delete_event, self, 0);
	_tmp14_ = self->priv->_settings;
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "congratswitch");
	g_settings_bind (_tmp14_, "do-congrat", _tmp16_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = self->priv->_settings;
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "animationsspeed");
	g_settings_bind (_tmp17_, "animations-speed", _tmp19_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp20_ = self->priv->_settings;
	_tmp21_ = builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "undoswitch");
	g_settings_bind (_tmp20_, "allow-undo", _tmp22_, "active", G_SETTINGS_BIND_DEFAULT);
}


static void __lambda13_ (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkDialog* _tmp1_ = NULL;
	_tmp0_ = response_id;
	if (_tmp0_ == 0) {
		application_new_game_cb (self);
	}
	_tmp1_ = self->priv->_congrats_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void ___lambda13__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda13_ ((Application*) self, response_id);
}


static gboolean __lambda14_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (response_id != NULL, FALSE);
	_tmp0_ = self->priv->_congrats_dialog;
	_tmp1_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda14__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda14_ ((Application*) self, event);
	return result;
}


static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkWindow* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	{
		GtkBuilder* _tmp0_ = NULL;
		_tmp0_ = builder;
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/congrats.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "congratsdialog");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->_congrats_dialog);
	self->priv->_congrats_dialog = _tmp6_;
	_tmp7_ = self->priv->_congrats_dialog;
	_tmp8_ = self->priv->_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->_congrats_dialog;
	g_signal_connect_object (_tmp9_, "response", (GCallback) ___lambda13__gtk_dialog_response, self, 0);
	_tmp10_ = self->priv->_congrats_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) ___lambda14__gtk_widget_delete_event, self, 0);
	_tmp11_ = builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "messagelabel");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->_congrats_message);
	self->priv->_congrats_message = _tmp13_;
}


static GamesScoresCategory* __lambda15_ (Application* self, GamesScoresContext* s, const gchar* key) {
	GamesScoresCategory* result = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "grid4") == 0) {
		GamesScoresCategory* _tmp1_ = NULL;
		GamesScoresCategory* _tmp2_ = NULL;
		_tmp1_ = self->priv->_grid4_cat;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = key;
		if (g_strcmp0 (_tmp3_, "grid5") == 0) {
			GamesScoresCategory* _tmp4_ = NULL;
			GamesScoresCategory* _tmp5_ = NULL;
			_tmp4_ = self->priv->_grid5_cat;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


static GamesScoresCategory* ___lambda15__games_scores_context_category_request (GamesScoresContext* _sender, const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = __lambda15_ ((Application*) self, _sender, category_key);
	return result;
}


static void _application_create_scores (Application* self) {
	GtkWindow* _tmp0_ = NULL;
	GamesScoresContext* _tmp1_ = NULL;
	GamesScoresCategory* _tmp2_ = NULL;
	GamesScoresCategory* _tmp3_ = NULL;
	GamesScoresContext* _tmp4_ = NULL;
	GamesScoresContext* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = games_scores_context_new ("gnome-2048", "", _tmp0_, GAMES_SCORES_STYLE_PLAIN_DESCENDING);
	_g_object_unref0 (self->priv->_scores_ctx);
	self->priv->_scores_ctx = _tmp1_;
	_tmp2_ = games_scores_category_new ("grid4", "Grid 4 x 4");
	_g_object_unref0 (self->priv->_grid4_cat);
	self->priv->_grid4_cat = _tmp2_;
	_tmp3_ = games_scores_category_new ("grid5", "Grid 5 x 5");
	_g_object_unref0 (self->priv->_grid5_cat);
	self->priv->_grid5_cat = _tmp3_;
	_tmp4_ = self->priv->_scores_ctx;
	g_signal_connect_object (_tmp4_, "category-request", (GCallback) ___lambda15__games_scores_context_category_request, self, 0);
	_tmp5_ = self->priv->_scores_ctx;
	_tmp6_ = games_scores_context_has_scores (_tmp5_);
	if (!_tmp6_) {
		GAction* _tmp7_ = NULL;
		_tmp7_ = g_action_map_lookup_action ((GActionMap*) self, "scores");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
}


static void application_new_game_cb (Application* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_header_bar;
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
	self->priv->_game_restored = FALSE;
	_tmp1_ = self->priv->_game;
	game_new_game (_tmp1_);
}


static void application_undo_cb (Application* self) {
	Game* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	game_undo (_tmp0_);
}


static void application_scores_cb (Application* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GamesScoresContext* _tmp0_ = NULL;
		_tmp0_ = self->priv->_scores_ctx;
		games_scores_context_run_dialog (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("application.vala:360: Failed to run scores dialog: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void application_about_cb (Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_about_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void application_preferences_cb (Application* self) {
	gint grid_size = 0;
	gint rows = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkComboBoxText* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_int (_tmp0_, "rows");
	rows = _tmp1_;
	_tmp2_ = rows;
	if (_tmp2_ == 4) {
		grid_size = 0;
	} else {
		grid_size = 1;
	}
	_tmp3_ = self->priv->_grid_size_combo;
	_tmp4_ = grid_size;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->_preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp5_);
}


static void application_quit_cb (Application* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void application_help_cb (Application* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->_window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-2048", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("application.vala:397: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->_game_restored = FALSE;
	_tmp0_ = self->priv->_game;
	_tmp1_ = event;
	_tmp2_ = game_key_pressed (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean application_window_configure_event_cb (Application* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_window_maximized;
	if (!_tmp0_) {
		GdkEventConfigure* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp1_ = event;
		_tmp2_ = _tmp1_->width;
		self->priv->_window_width = _tmp2_;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->height;
		self->priv->_window_height = _tmp4_;
	}
	result = FALSE;
	return result;
}


static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->_window_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	Application* app = NULL;
	Application* _tmp18_ = NULL;
	Application* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	_tmp2_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp1_, _tmp2_);
	_tmp3_ = context;
	_tmp4_ = clutter_get_option_group_without_init ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_set_application_name ("org.gnome.gnome-2048");
	gtk_window_set_default_icon_name ("gnome-2048");
	{
		GOptionEntry* _tmp9_ = NULL;
		GOptionEntry* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp9_ = g_new0 (GOptionEntry, 0);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 0;
		gtk_clutter_init_with_args (&args_length1, &args, "", _tmp10_, NULL, &_inner_error_);
		_tmp10_ = (g_free (_tmp10_), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkMessageDialog* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_ = NULL;
		GtkMessageDialog* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp12_);
		g_object_ref_sink (_tmp13_);
		dialog = _tmp13_;
		_tmp14_ = dialog;
		_tmp15_ = g_get_application_name ();
		gtk_window_set_title ((GtkWindow*) _tmp14_, _tmp15_);
		_tmp16_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp16_);
		_tmp17_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp17_);
		result = EXIT_FAILURE;
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp18_ = application_new ();
	app = _tmp18_;
	_tmp19_ = app;
	_tmp20_ = args;
	_tmp20__length1 = args_length1;
	_tmp21_ = g_application_run ((GApplication*) _tmp19_, _tmp20__length1, _tmp20_);
	result = _tmp21_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return application_main (argv, argc);
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
	((GApplicationClass *) klass)->startup = application_real_startup;
	((GApplicationClass *) klass)->activate = application_real_activate;
	((GApplicationClass *) klass)->shutdown = application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->WINDOW_MINIMUM_SIZE_HEIGHT = 600;
	self->priv->WINDOW_MINIMUM_SIZE_WIDTH = 600;
}


static void application_finalize (GObject* obj) {
	Application * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->_undo_button);
	_g_object_unref0 (self->priv->_new_game_button);
	_g_object_unref0 (self->priv->_about_dialog);
	_g_object_unref0 (self->priv->_preferences_dialog);
	_g_object_unref0 (self->priv->_congrats_dialog);
	_g_object_unref0 (self->priv->_congrats_message);
	_g_object_unref0 (self->priv->_score);
	_g_object_unref0 (self->priv->_grid_size_combo);
	_g_object_unref0 (self->priv->_scores_ctx);
	_g_object_unref0 (self->priv->_grid4_cat);
	_g_object_unref0 (self->priv->_grid5_cat);
	_g_object_unref0 (self->priv->_game);
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (gtk_application_get_type (), "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



