/*
 *  GMF: The GNOME Media Framework
 *
 *  Copyright (C) 1999 Elliot Lee
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Elliot Lee <sopwith@redhat.com>
 *
 */

#include "gmanip.h"

static void gmanip_avail_list_populate(AvailFilterList *list);
static void gmanip_avail_drag_begin(GtkWidget *widget, GdkDragContext *context,
				    AvailFilterList *list);
static void gmanip_avail_drag_data_get(GtkWidget *widget,
				       GdkDragContext *context,
				       GtkSelectionData *data,
				       guint info,
				       guint time,
				       AvailFilterList *list);
static void gmanip_avail_drag_begin(GtkWidget *widget,
				    GdkDragContext *context,
				    AvailFilterList *list);

static const GtkTargetEntry drag_targets[] = {
  {"application/x-gmffilter-goadid", 0, 0},
  {"application/x-gnome-goadid", 0, 1}
};

AvailFilterList *
gmanip_avail_create(void)
{
  static const char *column_titles[] = {
    "ID",
    "Description",
    "Input Types",
    "Output Types"
  };
  AvailFilterList *retval;

  retval = g_new0(AvailFilterList, 1);

  retval->slist = goad_server_list_get();
  retval->filtreg = gmf_filter_registry_get();
  retval->widget = GTK_CLIST(
    gtk_clist_new_with_titles(ELEMENTS(column_titles),
			      (char **)column_titles)
    );

  gmanip_avail_list_populate(retval);

  gtk_clist_columns_autosize(GTK_CLIST(retval->widget));

  /* XXX TODO - nice icon for filter drags */
  gtk_drag_source_set(GTK_WIDGET(retval->widget),
		      GDK_BUTTON1_MASK, drag_targets,
		      ELEMENTS(drag_targets),
		      GDK_ACTION_COPY);

  gtk_signal_connect(GTK_OBJECT(retval->widget), "drag_data_get",
		     GTK_SIGNAL_FUNC(gmanip_avail_drag_data_get), retval);
  gtk_signal_connect(GTK_OBJECT(retval->widget), "drag_begin",
		     GTK_SIGNAL_FUNC(gmanip_avail_drag_begin), retval);

  return retval;
}

static void
gmanip_avail_list_populate(AvailFilterList *list)
{
  GSList *ltmp;

  for(ltmp = list->filtreg->list; ltmp; ltmp = g_slist_next(ltmp)) {
    GMFFilterRegistryEntry *ent;
    GoadServer *goadent;
    char *cols[4];
    gint row_idx;

    ent = (GMFFilterRegistryEntry *)ltmp->data;
    goadent = g_hash_table_lookup(list->slist->by_goad_id, ent->goad_id);

    g_assert(goadent);

    cols[0] = ent->goad_id;
    cols[1] = goadent->description;
    cols[2] = g_strjoinv("\n", ent->input_types);
    cols[3] = g_strjoinv("\n", ent->output_types);

    row_idx = gtk_clist_append(GTK_CLIST(list->widget), cols);

    g_free(cols[2]);
    g_free(cols[3]);

    gtk_clist_set_row_data(GTK_CLIST(list->widget), row_idx, ent);
  }
}

void
gmanip_avail_destroy(AvailFilterList *list)
{
  gmf_filter_registry_free(list->filtreg);
  goad_server_list_free(list->slist);
  g_free(list);
}

static void
gmanip_avail_drag_begin(GtkWidget *widget,
			GdkDragContext *context,
			AvailFilterList *list)
{
  list->dragged_row = GTK_CLIST(widget)->focus_row;
}

static void
gmanip_avail_drag_data_get(GtkWidget *widget,
			   GdkDragContext *context,
			   GtkSelectionData *data,
			   guint info,
			   guint time,
			   AvailFilterList *list)
{
  GMFFilterRegistryEntry *ent;

  ent = gtk_clist_get_row_data(list->widget, list->dragged_row);

  gtk_selection_data_set(data,
			 gdk_atom_intern(drag_targets[info].target,
					 FALSE),
			 8, ent->goad_id,
			 strlen(ent->goad_id));
}
