/*
 *  GMF: The GNOME Media Framework
 *
 *  Copyright (C) 1999 Elliot Lee
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Elliot Lee <sopwith@redhat.com>
 *
 */

#ifndef GMF_FILTER_H
#define GMF_FILTER_H 1

#include <libgmf/gmf-corba.h>

/* GtkObject GMFFilter */
#define GMF_TYPE_FILTER	(gmf_filter_get_type())
#define GMF_FILTER(obj)	(GTK_CHECK_CAST((obj), GMF_TYPE_FILTER, GMFFilter))
#define GMF_FILTER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GMF_TYPE_FILTER, GMFFilterClass))
#define GMF_IS_FILTER(obj) (GTK_CHECK_TYPE((obj), GMF_TYPE_FILTER))
#define GMF_IS_FILTER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GMF_TYPE_FILTER))

struct _GMFFilter {
  GtkObject object;

  CORBA_Object corba_object;
  gpointer servant;

  GList *inputPipes, *outputPipes;
};

typedef struct {
  GtkObjectClass klass;
  void (*stop)(GMFFilter *filter);
  void (*pause)(GMFFilter *filter);
  void (*run)(GMFFilter *filter, GMF_TimeVal *timeBase);

  void (*get_pipe)(GMFFilter *filter, GMF_Direction pDirection, GMFPipe **pipe);

  void (*get_attributes)(GMFFilter *filter, GNOME_stringlist *retval);
  void (*get_attribute)(GMFFilter *filter, const char *attr_name, CORBA_any *ret_attr_val);
  void (*set_attribute)(GMFFilter *filter, const char *attr_name, CORBA_any *attr_val);
} GMFFilterClass;

GtkType gmf_filter_get_type (void);
GtkObject *gmf_filter_new (GMF_Filter_Type filter_type,
			   const char *goad_id);
void gmf_filter_add_pipe(GMFFilter *filter, GMFPipe *pipe);
void gmf_filter_remove_pipe(GMFFilter *filter, GMFPipe *pipe);

/* Sort of a convenience routine to go through all output filters
   and send the same sample to each of them. */
void gmf_filter_send_sample(GMFFilter *filter, GMF_Sample *sample);

/* GtkObject GMFSeekableFilter */
#define GMF_TYPE_SEEKABLE_FILTER	(gmf_filter_get_type())
#define GMF_SEEKABLE_FILTER(obj)	(GTK_CHECK_CAST((obj), GMF_TYPE_SEEKABLE_FILTER, GMFSeekableFilter))
#define GMF_SEEKABLE_FILTER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GMF_TYPE_SEEKABLE_FILTER, GMFSeekableFilterClass))
#define GMF_IS_SEEKABLE_FILTER(obj) (GTK_CHECK_TYPE((obj), GMF_TYPE_SEEKABLE_FILTER))
#define GMF_IS_SEEKABLE_FILTER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GMF_TYPE_SEEKABLE_FILTER))

typedef struct {
  GMFFilter filter;
} GMFSeekableFilter;

typedef struct {
  GMFFilterClass klass;

  void (*set_playbackRate)(GMFSeekableFilter *filt, gdouble rate);
  void (*get_playbackRate)(GMFSeekableFilter *filt, gdouble *rate);
  void (*get_can_seek_forward)(GMFSeekableFilter *filt,
			       gboolean *can_seek_forward);
  void (*get_can_seek_backward)(GMFSeekableFilter *filt,
				gboolean *can_seek_backward);
  void (*set_duration)(GMFSeekableFilter *filt,
		       GMF_TimeVal *duration);
  void (*get_duration)(GMFSeekableFilter *filt,
		       GMF_TimeVal *duration);
  void (*set_position)(GMFSeekableFilter *filt,
		       GMF_TimeVal *position);
  void (*get_position)(GMFSeekableFilter *filt,
		       GMF_TimeVal *position);
  void (*set_stopTime)(GMFSeekableFilter *filt,
		       GMF_TimeVal *stopTime);
  void (*get_stopTime)(GMFSeekableFilter *filt,
		       GMF_TimeVal *stopTime);
  void (*set_prerollTime)(GMFSeekableFilter *filt,
			  GMF_TimeVal *prerollTime);
  void (*get_prerollTime)(GMFSeekableFilter *filt,
			  GMF_TimeVal *prerollTime);
} GMFSeekableFilterClass;

GtkType gmf_seekable_filter_get_type (void);
GtkObject *gmf_seekable_filter_new (GMF_Filter_Type filter_type,
				    const char *goad_id);

#endif /* GMF_FILTER_H */
