/*
 *  GMF: The GNOME Media Framework
 *
 *  Copyright (C) 1999 Elliot Lee
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Elliot Lee <sopwith@redhat.com>
 *
 */

#include "config.h"
#include <gmf.h>
#include <stdlib.h>

typedef struct {
  /* This is a seekable filter for both GMFFilter and
     GMFSeekableFilter classes. */
  POA_GMF_SeekableFilter servant;

  PortableServer_POA poa;
  
  GMF_Filter_State attr_filterState;
  
  GMFFilter *gtkobj;

  GMF_FilterGraph attr_graph; CORBA_char *attr_graphName;
  GMF_Filter_Type attr_filterType;

  char *attr_goadID;
} impl_POA_GMF_Filter;

typedef impl_POA_GMF_Filter impl_POA_GMF_SeekableFilter;
typedef impl_POA_GMF_Filter impl_POA_GMF_MediaPosition;

#define FILTER_DATA(x) ((impl_POA_GMF_Filter *)(GMF_FILTER(x)->servant))

static void impl_GMF_Filter__destroy(impl_POA_GMF_Filter * servant,
				     CORBA_Environment * ev);

static GMF_Filter_State
impl_GMF_Filter__get_filterState(impl_POA_GMF_Filter * servant,
				 CORBA_Environment * ev);

static void
impl_GMF_Filter_Stop(impl_POA_GMF_Filter * servant,
		     CORBA_Environment * ev);

static void
impl_GMF_Filter_Pause(impl_POA_GMF_Filter * servant,
		      CORBA_Environment * ev);

static void
impl_GMF_Filter_Run(impl_POA_GMF_Filter * servant,
		    GMF_TimeVal * timeBase,
		    CORBA_Environment * ev);

static GMF_PipeList *
impl_GMF_Filter__get_inputPipes(impl_POA_GMF_Filter * servant,
				CORBA_Environment * ev);

static GMF_PipeList *
impl_GMF_Filter__get_outputPipes(impl_POA_GMF_Filter * servant,
				 CORBA_Environment * ev);

static GMF_Pipe
impl_GMF_Filter_GetPipe(impl_POA_GMF_Filter * servant,
			GMF_Direction pDirection,
			CORBA_Environment * ev);

static void
impl_GMF_Filter_JoinFilterGraph(impl_POA_GMF_Filter * servant,
				CORBA_char * name,
				GMF_FilterGraph fg,
				CORBA_Environment * ev);
static GMF_FilterGraph
impl_GMF_Filter__get_graph(impl_POA_GMF_Filter * servant,
			   CORBA_Environment * ev);
static CORBA_char *
impl_GMF_Filter__get_graphName(impl_POA_GMF_Filter *servant,
			       CORBA_Environment *ev);

static GMF_Filter_Type
impl_GMF_Filter__get_filterType(impl_POA_GMF_Filter *servant,
			       CORBA_Environment *ev);

static void
impl_GMF_Filter_invoke(impl_POA_GMF_Filter * servant,
		       CORBA_Environment * ev);
static CORBA_char *
impl_GMF_Filter__get_goadID(impl_POA_GMF_Filter *servant,
			    CORBA_Environment *ev);
static GNOME_stringlist *impl_GMF_Filter__get_attributes(impl_POA_GMF_Filter * servant,
							 CORBA_Environment *ev);
static CORBA_any *impl_GMF_Filter_get_attribute(impl_POA_GMF_Filter * servant,
						CORBA_char * attr_name,
						CORBA_Environment *ev);
static void impl_GMF_Filter_set_attribute(impl_POA_GMF_Filter * servant,
					  CORBA_char * attr_name,
					  CORBA_any * attr_val,
					  CORBA_Environment *ev);

static CORBA_double
impl_GMF_MediaPosition__get_playbackRate(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static void
impl_GMF_MediaPosition__set_playbackRate(impl_POA_GMF_SeekableFilter *servant,
CORBA_double value,
CORBA_Environment *ev);
static CORBA_boolean
impl_GMF_MediaPosition__get_can_seek_forward(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static CORBA_boolean
impl_GMF_MediaPosition__get_can_seek_backward(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static GMF_TimeVal
impl_GMF_MediaPosition__get_duration(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static GMF_TimeVal
impl_GMF_MediaPosition__get_position(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static void
impl_GMF_MediaPosition__set_position(impl_POA_GMF_SeekableFilter *servant,
GMF_TimeVal* value,
CORBA_Environment *ev);
static GMF_TimeVal
impl_GMF_MediaPosition__get_stopTime(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static void
impl_GMF_MediaPosition__set_stopTime(impl_POA_GMF_SeekableFilter *servant,
GMF_TimeVal* value,
CORBA_Environment *ev);
static GMF_TimeVal
impl_GMF_MediaPosition__get_prerollTime(impl_POA_GMF_SeekableFilter *servant,
CORBA_Environment *ev);
static void
impl_GMF_MediaPosition__set_prerollTime(impl_POA_GMF_SeekableFilter *servant,
					GMF_TimeVal* value,
					CORBA_Environment *ev);

static void impl_GNOME_Obj_ref(impl_POA_GMF_Filter * servant,
			       CORBA_Environment * ev);
static void impl_GNOME_Obj_unref(impl_POA_GMF_Filter * servant,
				 CORBA_Environment * ev);
static CORBA_Object impl_GNOME_Obj_query_interface(impl_POA_GMF_Filter * servant,
						   CORBA_char * repo_id,
						   CORBA_Environment * ev);

enum { STOP, PAUSE, RUN, GET_PIPE,
       GET_ATTRIBUTES,
       GET_ATTRIBUTE,
       SET_ATTRIBUTE,
       LAST_SIGNAL };
static guint filter_signals[LAST_SIGNAL] = { 0 };

enum { GET_PLAYBACKRATE,
       SET_PLAYBACKRATE,
       GET_CANSEEKFORWARD,
       GET_CANSEEKBACKWARD,
       GET_DURATION,
       GET_POSITION,
       SET_POSITION,
       GET_STOPTIME,
       SET_STOPTIME,
       GET_PREROLLTIME,
       SET_PREROLLTIME,
       S_LAST_SIGNAL
};
static guint seekable_filter_signals[S_LAST_SIGNAL] = { 0 };

static CORBA_Environment modev;

static PortableServer_ServantBase__epv impl_GMF_Filter_base_epv =
{
   NULL,			/* _private data */
   NULL,                        /* finalize routine */
   NULL,			/* default_POA routine */
};

static POA_GNOME_obj__epv gmf_impl_GNOME_Obj_epv =
{
  NULL, /* _private */
  (gpointer) & impl_GNOME_Obj_ref,
  (gpointer) & impl_GNOME_Obj_unref,
  (gpointer) & impl_GNOME_Obj_query_interface
};

static POA_GMF_Filter__epv impl_GMF_Filter_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GMF_Filter_Stop,
   (gpointer) & impl_GMF_Filter_Pause,
   (gpointer) & impl_GMF_Filter_Run,
   (gpointer) & impl_GMF_Filter__get_inputPipes,
   (gpointer) & impl_GMF_Filter__get_outputPipes,
   (gpointer) & impl_GMF_Filter_GetPipe,
   (gpointer) & impl_GMF_Filter_JoinFilterGraph,
   (gpointer) & impl_GMF_Filter__get_graph,
   (gpointer) & impl_GMF_Filter__get_graphName,
   (gpointer) & impl_GMF_Filter__get_filterState,
   (gpointer) & impl_GMF_Filter__get_filterType,
   (gpointer) & impl_GMF_Filter__get_goadID,
   (gpointer) & impl_GMF_Filter__get_attributes,
   (gpointer) & impl_GMF_Filter_get_attribute,
   (gpointer) & impl_GMF_Filter_set_attribute
};

static POA_GMF_Callback__epv impl_GMF_Filter_GMF_Callback_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GMF_Filter_invoke
};

static POA_GMF_MediaPosition__epv impl_GMF_MediaPosition_epv =
{
  NULL, /* _private */
  (gpointer) &impl_GMF_MediaPosition__get_playbackRate,
  (gpointer) &impl_GMF_MediaPosition__set_playbackRate,
  (gpointer) &impl_GMF_MediaPosition__get_can_seek_forward,
  (gpointer) &impl_GMF_MediaPosition__get_can_seek_backward,
  (gpointer) &impl_GMF_MediaPosition__get_duration,
  (gpointer) &impl_GMF_MediaPosition__get_position,
  (gpointer) &impl_GMF_MediaPosition__set_position,
  (gpointer) &impl_GMF_MediaPosition__get_stopTime,
  (gpointer) &impl_GMF_MediaPosition__set_stopTime,
  (gpointer) &impl_GMF_MediaPosition__get_prerollTime,
  (gpointer) &impl_GMF_MediaPosition__set_prerollTime
};

static POA_GMF_Filter__vepv impl_GMF_Filter_vepv =
{
   &impl_GMF_Filter_base_epv,
   &gmf_impl_GNOME_Obj_epv,
   &impl_GMF_Filter_GMF_Callback_epv,
   &impl_GMF_Filter_epv
};

static POA_GMF_SeekableFilter__vepv impl_GMF_SeekableFilter_vepv =
{
   &impl_GMF_Filter_base_epv,
   &gmf_impl_GNOME_Obj_epv,
   &impl_GMF_Filter_GMF_Callback_epv,
   &impl_GMF_Filter_epv,
   &impl_GMF_MediaPosition_epv
};

static void gmf_filter_class_init (GMFFilterClass * klass);
static void gmf_filter_init (GMFFilter * obj);
static void gmf_filter_destroy (GMFFilter *filter);
static void gmf_filter_relay_begin_flush(GMFPipe *pipe, GMFFilter *filter);
static void gmf_filter_relay_end_flush(GMFPipe *pipe, GMFFilter *filter);
static void gmf_filter_relay_end_of_stream(GMFPipe *pipe, GMFFilter *filter);

static void impl_GNOME_Obj_ref(impl_POA_GMF_Filter * servant,
			       CORBA_Environment * ev)
{
  gtk_object_ref(GTK_OBJECT(servant->gtkobj));
  gtk_object_sink(GTK_OBJECT(servant->gtkobj));
}

static void impl_GNOME_Obj_unref(impl_POA_GMF_Filter * servant,
				 CORBA_Environment * ev)
{
  gtk_object_unref(GTK_OBJECT(servant->gtkobj));
}

static CORBA_Object impl_GNOME_Obj_query_interface(impl_POA_GMF_Filter * servant,
						   CORBA_char * repo_id,
						   CORBA_Environment * ev)
{
  return CORBA_OBJECT_NIL;
}

static GMF_Filter
impl_GMF_Filter__create(PortableServer_POA poa, gpointer *ret_servant,
			gboolean is_seekable,
			CORBA_Environment * ev)
{
   GMF_Filter retval;
   impl_POA_GMF_Filter *newservant;
   PortableServer_ObjectId *objid;

   *ret_servant = newservant = g_new0(impl_POA_GMF_Filter, 1);
   newservant->poa = poa;


   /* Talk about bad hacks */
   if(is_seekable) {
     POA_GMF_SeekableFilter__init((PortableServer_Servant) newservant, ev);
     newservant->servant.vepv = &impl_GMF_SeekableFilter_vepv;
   } else {
     newservant->servant.vepv =
       (POA_GMF_SeekableFilter__vepv *)&impl_GMF_Filter_vepv;
     POA_GMF_Filter__init((PortableServer_Servant) newservant, ev);
   }

   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);

   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void
impl_GMF_Filter__destroy(impl_POA_GMF_Filter * servant, CORBA_Environment * ev)
{
  PortableServer_ObjectId *oid;

  if(servant->attr_graphName) {
    GMF_FilterGraph_RemoveFilter(servant->attr_graph,
				 servant->attr_graphName,
				 &modev);
  }

  g_list_foreach(servant->gtkobj->inputPipes, (GFunc)gtk_object_unref, NULL);
  g_list_free(servant->gtkobj->inputPipes);
  g_list_foreach(servant->gtkobj->outputPipes, (GFunc)gtk_object_unref, NULL);
  g_list_free(servant->gtkobj->outputPipes);

  oid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
  PortableServer_POA_deactivate_object(servant->poa, oid, ev);
  CORBA_free(oid);

  if(GMF_IS_SEEKABLE_FILTER(servant->gtkobj))
    POA_GMF_SeekableFilter__fini((PortableServer_Servant) servant, ev);
  else
    POA_GMF_Filter__fini((PortableServer_Servant) servant, ev);
  g_free(servant);
}

static GMF_Filter_State
impl_GMF_Filter__get_filterState(impl_POA_GMF_Filter * servant,
				 CORBA_Environment * ev)
{
   return servant->attr_filterState;
}

static void
impl_GMF_Filter_Stop(impl_POA_GMF_Filter * servant,
		     CORBA_Environment * ev)
{
  if(servant->attr_filterState != GMF_Filter_STOPPED) {
    servant->attr_filterState = GMF_Filter_STOPPED;
    gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[STOP]);
  }
}

static void
impl_GMF_Filter_Pause(impl_POA_GMF_Filter * servant,
		      CORBA_Environment * ev)
{
  if(servant->attr_filterState != GMF_Filter_PAUSED) {
    servant->attr_filterState = GMF_Filter_PAUSED;
    gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[PAUSE]);
  }
}

static void
impl_GMF_Filter_Run(impl_POA_GMF_Filter * servant,
		    GMF_TimeVal * timeBase,
		    CORBA_Environment * ev)
{
  if(servant->attr_filterState != GMF_Filter_RUNNING) {
    servant->attr_filterState = GMF_Filter_RUNNING;
    gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[RUN],
		    timeBase);
  }
}

static GMF_PipeList *
impl_GMF_Filter__get_inputPipes(impl_POA_GMF_Filter * servant,
				CORBA_Environment * ev)
{
   GMF_PipeList *retval;
   int i;
   GList *ltmp;

   retval = GMF_PipeList__alloc();
   retval->_length = g_list_length(servant->gtkobj->inputPipes);
   retval->_buffer = CORBA_sequence_GMF_Pipe_allocbuf(retval->_length);
   for(ltmp = servant->gtkobj->inputPipes, i = 0; ltmp; ltmp = g_list_next(ltmp), i++) {
     retval->_buffer[i] =
       CORBA_Object_duplicate(GMF_PIPE(ltmp->data)->corba_object, ev);
   }

   CORBA_sequence_set_release(retval, CORBA_TRUE);

   return retval;
}

static GMF_PipeList *
impl_GMF_Filter__get_outputPipes(impl_POA_GMF_Filter * servant,
				 CORBA_Environment * ev)
{
   GMF_PipeList *retval;
   int i;
   GList *ltmp;

   retval = GMF_PipeList__alloc();
   retval->_length = g_list_length(servant->gtkobj->outputPipes);
   retval->_buffer = CORBA_sequence_GMF_Pipe_allocbuf(retval->_length);
   for(ltmp = servant->gtkobj->outputPipes, i = 0; ltmp; ltmp = g_list_next(ltmp), i++) {
     retval->_buffer[i] =
       CORBA_Object_duplicate(GMF_PIPE(ltmp->data)->corba_object, ev);
   }

   CORBA_sequence_set_release(retval, CORBA_TRUE);

   return retval;
}

GMF_Pipe
impl_GMF_Filter_GetPipe(impl_POA_GMF_Filter * servant,
			GMF_Direction pDirection,
			CORBA_Environment * ev)
{
  GtkArg targ;
  GMF_Pipe retval = CORBA_OBJECT_NIL;
  GList *list;
  GMFPipe *ptmp = NULL;

  if(pDirection == GMF_IN)
    list = servant->gtkobj->inputPipes;
  else
    list = servant->gtkobj->outputPipes;

  for(; list; list = g_list_next(list)) {
    targ.type = GTK_TYPE_BOOL;
    targ.name = "inuse";
    gtk_object_getv(list->data, 1, &targ);
    if(!GTK_VALUE_BOOL(targ)) {
      retval = CORBA_Object_duplicate(GMF_PIPE(list->data)->corba_object, ev);
      break;
    }
  }

  if(CORBA_Object_is_nil(retval, ev)) {
    gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[GET_PIPE],
		    pDirection, &ptmp);

    if(ptmp) {
      gmf_filter_add_pipe(servant->gtkobj, ptmp);
      retval = CORBA_Object_duplicate(ptmp->corba_object, ev);
    }
  }

  return retval;
}

static void
impl_GMF_Filter_JoinFilterGraph(impl_POA_GMF_Filter * servant,
				CORBA_char * name,
				GMF_FilterGraph fg,
				CORBA_Environment * ev)
{
  if(servant->attr_graphName) {
    if(CORBA_Object_is_nil(fg, ev)) {
      CORBA_Object_release(servant->attr_graph, ev);
      servant->attr_graph = CORBA_OBJECT_NIL;
      CORBA_free(servant->attr_graphName); servant->attr_graphName = NULL;
    } else
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION,
			  ex_GMF_Filter_JoinRefused, NULL);
  } else {
    servant->attr_graph = CORBA_Object_duplicate(fg, ev);
    servant->attr_graphName = CORBA_string_dup(name);
  }
}

static GMF_FilterGraph
impl_GMF_Filter__get_graph(impl_POA_GMF_Filter * servant,
			   CORBA_Environment * ev)
{
  return CORBA_Object_duplicate(servant->attr_graph, ev);
}

static CORBA_char *
impl_GMF_Filter__get_graphName(impl_POA_GMF_Filter *servant,
			       CORBA_Environment *ev)
{
  return CORBA_string_dup(servant->attr_graphName);
}

static GMF_Filter_Type
impl_GMF_Filter__get_filterType(impl_POA_GMF_Filter *servant,
				CORBA_Environment *ev)
{
  return servant->attr_filterType;
}

static CORBA_char *
impl_GMF_Filter__get_goadID(impl_POA_GMF_Filter *servant,
			    CORBA_Environment *ev)
{
  return CORBA_string_dup(servant->attr_goadID);
}

static void
impl_GMF_Filter_invoke(impl_POA_GMF_Filter * servant,
		       CORBA_Environment * ev)
{
  g_error("GMF_Filter_invoke NYI - fix the time reference workings.");
}

static GNOME_stringlist *
impl_GMF_Filter__get_attributes(impl_POA_GMF_Filter * servant,
				CORBA_Environment *ev)
{
  GNOME_stringlist *retval;

  retval = GNOME_stringlist__alloc();
  retval->_length = 0;
  retval->_buffer = NULL;

  gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[GET_ATTRIBUTES],
		  retval);

  return retval;
}

static CORBA_any *
impl_GMF_Filter_get_attribute(impl_POA_GMF_Filter * servant,
			      CORBA_char * attr_name,
			      CORBA_Environment *ev)
{
  CORBA_any *retval;

  retval = CORBA_any_alloc();

  retval->_type = TC_void;
  retval->_value = NULL;
  CORBA_any_set_release(retval, CORBA_TRUE);

  gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[GET_ATTRIBUTE],
		  attr_name, retval);

  return retval;
}

static void
impl_GMF_Filter_set_attribute(impl_POA_GMF_Filter * servant,
			      CORBA_char * attr_name,
			      CORBA_any * attr_val,
			      CORBA_Environment *ev)
{
  gtk_signal_emit(GTK_OBJECT(servant->gtkobj), filter_signals[SET_ATTRIBUTE],
		  attr_name, attr_val);

}

GtkType
gmf_filter_get_type (void)
{
  static GtkType gmf_filter_type = 0;
  if (!gmf_filter_type)
    {
      static const GtkTypeInfo gmf_filter_info =
      {
	"GMFFilter",
	sizeof (GMFFilter),
	sizeof (GMFFilterClass),
	(GtkClassInitFunc) gmf_filter_class_init,
	(GtkObjectInitFunc) gmf_filter_init,
	NULL, NULL,		/* reserved 1 & 2 */
	NULL
      };

      gmf_filter_type = gtk_type_unique (gtk_object_get_type(), &gmf_filter_info);
    }

  return gmf_filter_type;
}

static void 
gmf_filter_class_init (GMFFilterClass * klass)
{
  GtkObjectClass *object_class = GTK_OBJECT_CLASS (klass);

  CORBA_exception_init(&modev);

  object_class->destroy = (void (*)(GtkObject *))gmf_filter_destroy;

  filter_signals[STOP] =
    gtk_signal_new("stop", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, stop),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);
  filter_signals[PAUSE] =
    gtk_signal_new("pause", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, pause),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);
  filter_signals[RUN] =
    gtk_signal_new("run", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, run),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  filter_signals[GET_PIPE] =
    gtk_signal_new("get_pipe", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, get_pipe),
		   gtk_marshal_NONE__INT_POINTER,
		   GTK_TYPE_NONE, 2, GTK_TYPE_ENUM, GTK_TYPE_POINTER);
  filter_signals[GET_ATTRIBUTES] =
    gtk_signal_new("get_attributes", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, get_attributes),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  filter_signals[GET_ATTRIBUTE] =
    gtk_signal_new("get_attribute", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, get_attribute),
		   gtk_marshal_NONE__POINTER_POINTER,
		   GTK_TYPE_NONE, 2, GTK_TYPE_POINTER, GTK_TYPE_POINTER);
  filter_signals[SET_ATTRIBUTE] =
    gtk_signal_new("set_attribute", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFFilterClass, set_attribute),
		   gtk_marshal_NONE__POINTER_POINTER,
		   GTK_TYPE_NONE, 2, GTK_TYPE_POINTER, GTK_TYPE_POINTER);

  gtk_object_class_add_signals(object_class, filter_signals, LAST_SIGNAL);
}

static void 
gmf_filter_init (GMFFilter * obj)
{
  PortableServer_POA poa;

  poa = (PortableServer_POA)
    CORBA_ORB_resolve_initial_references((CORBA_ORB)gnome_CORBA_ORB(), "RootPOA", &modev);
  obj->corba_object = impl_GMF_Filter__create(poa, &obj->servant, FALSE, &modev);
  CORBA_Object_release((CORBA_Object)poa, &modev);
}

static void
gmf_filter_destroy (GMFFilter *filter)
{
  g_free(FILTER_DATA(filter)->attr_goadID);
  impl_GMF_Filter__destroy(filter->servant, &modev);
  CORBA_Object_release(filter->corba_object, &modev);
}

GtkObject *
gmf_filter_new (GMF_Filter_Type filter_type, const char *goad_id)
{
  GtkObject *retval;
  GMFFilter *filter;
  impl_POA_GMF_Filter *servant;

  retval = gtk_type_new(gmf_filter_get_type());
  filter = GMF_FILTER(retval);

  servant = FILTER_DATA(filter);
  servant->gtkobj = filter;
  servant->attr_filterType = filter_type;
  servant->attr_goadID = g_strdup(goad_id);

  return retval;
}

void
gmf_filter_remove_pipe(GMFFilter *filter, GMFPipe *pipe)
{
  GtkArg targ;
  impl_POA_GMF_Filter *servant;

  servant = FILTER_DATA(filter);

  targ.type = GTK_TYPE_ENUM;
  targ.name = "direction";

  gtk_object_getv(GTK_OBJECT(pipe), 1, &targ);
  if(GTK_VALUE_ENUM(targ) == GMF_IN) {
    guint sigid;

    sigid = GPOINTER_TO_UINT(gtk_object_get_data(GTK_OBJECT(pipe),
						 "begin_flush_id"));
    gtk_signal_disconnect(GTK_OBJECT(pipe), sigid);

    sigid = GPOINTER_TO_UINT(gtk_object_get_data(GTK_OBJECT(pipe),
						 "end_flush_id"));
    gtk_signal_disconnect(GTK_OBJECT(pipe), sigid);

    sigid = GPOINTER_TO_UINT(gtk_object_get_data(GTK_OBJECT(pipe),
						 "end_of_stream_id"));
    gtk_signal_disconnect(GTK_OBJECT(pipe), sigid);

    servant->gtkobj->inputPipes = g_list_remove(servant->gtkobj->inputPipes, pipe);
  } else if(GTK_VALUE_ENUM(targ) == GMF_OUT) {
    servant->gtkobj->outputPipes = g_list_remove(servant->gtkobj->outputPipes, pipe);
  } else
    g_error("invalid pipe dir");

  gtk_object_unref(GTK_OBJECT(pipe));
}

void
gmf_filter_add_pipe(GMFFilter *filter, GMFPipe *pipe)
{
  GtkArg targ;
  impl_POA_GMF_Filter *servant;

  servant = FILTER_DATA(filter);

  targ.type = GTK_TYPE_ENUM;
  targ.name = "direction";

  gtk_object_getv(GTK_OBJECT(pipe), 1, &targ);
  if(GTK_VALUE_ENUM(targ) == GMF_IN) {
    guint sigid;

    g_return_if_fail(servant->attr_filterType != GMF_Filter_SOURCE);

    servant->gtkobj->inputPipes = g_list_prepend(servant->gtkobj->inputPipes, pipe);
    /* set up downstream relaying of flushes */
    sigid = gtk_signal_connect(GTK_OBJECT(pipe), "begin_flush",
			       GTK_SIGNAL_FUNC(gmf_filter_relay_begin_flush),
			       filter);
    gtk_object_set_data(GTK_OBJECT(pipe), "begin_flush_id",
			GUINT_TO_POINTER(sigid));
    gtk_signal_connect(GTK_OBJECT(pipe), "end_flush",
		       GTK_SIGNAL_FUNC(gmf_filter_relay_end_flush),
		       filter);
    gtk_object_set_data(GTK_OBJECT(pipe), "end_flush_id",
			GUINT_TO_POINTER(sigid));
    gtk_signal_connect(GTK_OBJECT(pipe), "end_of_stream",
		       GTK_SIGNAL_FUNC(gmf_filter_relay_end_of_stream),
		       filter);
    gtk_object_set_data(GTK_OBJECT(pipe), "end_of_stream_id",
			GUINT_TO_POINTER(sigid));
  } else if(GTK_VALUE_ENUM(targ) == GMF_OUT) {
    g_return_if_fail(servant->attr_filterType != GMF_Filter_RENDERER);

    servant->gtkobj->outputPipes = g_list_prepend(servant->gtkobj->outputPipes, pipe);
  } else
    g_error("invalid pipe dir");

  gtk_object_ref(GTK_OBJECT(pipe));
}

static void
gmf_filter_relay_begin_flush(GMFPipe *pipe,
			     GMFFilter *filter)
{
   GList *ltmp;

   for(ltmp = FILTER_DATA(filter)->gtkobj->outputPipes; ltmp; ltmp = g_list_next(ltmp))
     GMF_Pipe_BeginFlush(GMF_PIPE(ltmp->data)->corba_object, &modev);
}

static void
gmf_filter_relay_end_flush(GMFPipe *pipe,
			   GMFFilter *filter)
{
   GList *ltmp;

   for(ltmp = FILTER_DATA(filter)->gtkobj->outputPipes; ltmp; ltmp = g_list_next(ltmp))
     GMF_Pipe_EndFlush(GMF_PIPE(ltmp->data)->corba_object, &modev);
}

static void
gmf_filter_relay_end_of_stream(GMFPipe *pipe,
			       GMFFilter *filter)
{
   GList *ltmp;

   if(FILTER_DATA(filter)->gtkobj->outputPipes) {
     for(ltmp = FILTER_DATA(filter)->gtkobj->outputPipes; ltmp; ltmp = g_list_next(ltmp))
       GMF_Pipe_EndOfStream(GMF_PIPE(ltmp->data)->corba_object, &modev);
   } else if(!CORBA_Object_is_nil(FILTER_DATA(filter)->attr_graph, &modev)
	     && FILTER_DATA(filter)->attr_filterType == GMF_Filter_RENDERER)
     GMF_FilterGraph_EndOfStream(FILTER_DATA(filter)->attr_graph, &modev);
}

void
gmf_filter_send_sample(GMFFilter *filter, GMF_Sample *sample)
{
  GList *ltmp;

  impl_POA_GMF_Filter *servant;

  servant = FILTER_DATA(filter);

  for(ltmp = servant->gtkobj->outputPipes; ltmp; ltmp = g_list_next(ltmp))
    gmf_pipe_send_sample(GMF_PIPE(ltmp->data), sample);
}


/********* seekablefilter methods **********/

static CORBA_double
impl_GMF_MediaPosition__get_playbackRate(impl_POA_GMF_MediaPosition *servant,
					 CORBA_Environment *ev)
{
  CORBA_double retval = 0.0;

  return retval;
}

static void
impl_GMF_MediaPosition__set_playbackRate(impl_POA_GMF_MediaPosition *servant,
					 CORBA_double value,
					 CORBA_Environment *ev)
{
}


static CORBA_boolean
impl_GMF_MediaPosition__get_can_seek_forward(impl_POA_GMF_MediaPosition *servant,
					     CORBA_Environment *ev)
{
  CORBA_boolean retval = CORBA_TRUE;
  
  return retval;
}

static CORBA_boolean
impl_GMF_MediaPosition__get_can_seek_backward(impl_POA_GMF_MediaPosition *servant,
					      CORBA_Environment *ev)
{
  CORBA_boolean retval = CORBA_TRUE;
  
  return retval;
}


static GMF_TimeVal
impl_GMF_MediaPosition__get_duration(impl_POA_GMF_MediaPosition *servant,
				     CORBA_Environment *ev)
{
  GMF_TimeVal retval = {0,0};
  
  return retval;
}


static GMF_TimeVal
impl_GMF_MediaPosition__get_position(impl_POA_GMF_Filter *servant,
				     CORBA_Environment *ev)
{
  GMF_TimeVal retval={0,0};
  
  return retval;
}

static void
impl_GMF_MediaPosition__set_position(impl_POA_GMF_Filter *servant,
				     GMF_TimeVal* value,
				     CORBA_Environment *ev)
{
}


static GMF_TimeVal
impl_GMF_MediaPosition__get_stopTime(impl_POA_GMF_Filter *servant,
				     CORBA_Environment *ev)
{
  GMF_TimeVal retval={0,0};
  
  return retval;
}

static void
impl_GMF_MediaPosition__set_stopTime(impl_POA_GMF_Filter *servant,
				     GMF_TimeVal* value,
				     CORBA_Environment *ev)
{
}


static GMF_TimeVal
impl_GMF_MediaPosition__get_prerollTime(impl_POA_GMF_Filter *servant,
					CORBA_Environment *ev)
{
  GMF_TimeVal retval={0,0};
  
  return retval;
}

static void
impl_GMF_MediaPosition__set_prerollTime(impl_POA_GMF_Filter *servant,
					GMF_TimeVal* value,
					CORBA_Environment *ev)
{
}

typedef gboolean (*GtkSignal_NONE__DOUBLE) (GtkObject *object, 
					    gdouble arg1,
					    gpointer user_data);

static void
gtk_marshal_NONE__DOUBLE (GtkObject    *object, 
			  GtkSignalFunc func, 
			  gpointer      func_data, 
			  GtkArg       *args)
{
  GtkSignal_NONE__DOUBLE rfunc;

  rfunc = (GtkSignal_NONE__DOUBLE) func;
  (* rfunc) (object,
	     GTK_VALUE_DOUBLE(args[0]),
	     func_data);
}


static void 
gmf_seekable_filter_class_init (GMFSeekableFilterClass * klass)
{
  GtkObjectClass *object_class = GTK_OBJECT_CLASS (klass);

  CORBA_exception_init(&modev);

  seekable_filter_signals[GET_PLAYBACKRATE] =
    gtk_signal_new("get_playbackRate", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, get_playbackRate),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[SET_PLAYBACKRATE] =
    gtk_signal_new("set_playbackRate", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, set_playbackRate),
		   gtk_marshal_NONE__DOUBLE,
		   GTK_TYPE_NONE, 1, GTK_TYPE_DOUBLE);
  seekable_filter_signals[GET_CANSEEKFORWARD] =
    gtk_signal_new("get_can_seek_forward", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass,
				     get_can_seek_forward),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[GET_CANSEEKBACKWARD] =
    gtk_signal_new("get_can_seek_backward", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass,
				     get_can_seek_backward),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[GET_DURATION] =
    gtk_signal_new("get_duration", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, get_duration),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[GET_POSITION] =
    gtk_signal_new("get_position", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, get_position),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[SET_POSITION] =
    gtk_signal_new("set_position", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, set_position),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[GET_STOPTIME] =
    gtk_signal_new("get_stopTime", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, get_stopTime),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[SET_STOPTIME] =
    gtk_signal_new("set_stopTime", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, set_stopTime),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[GET_PREROLLTIME] =
    gtk_signal_new("get_prerollTime", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, get_prerollTime),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);
  seekable_filter_signals[SET_PREROLLTIME] =
    gtk_signal_new("set_prerollTime", GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GMFSeekableFilterClass, set_prerollTime),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1, GTK_TYPE_POINTER);

  gtk_object_class_add_signals(object_class,
			       seekable_filter_signals, LAST_SIGNAL);
}

GtkType
gmf_seekable_filter_get_type (void)
{
  static GtkType gmf_seekable_filter_type = 0;
  if (!gmf_seekable_filter_type)
    {
      static const GtkTypeInfo gmf_seekable_filter_info =
      {
	"GMFSeekableFilter",
	sizeof (GMFSeekableFilter),
	sizeof (GMFSeekableFilterClass),
	(GtkClassInitFunc) gmf_seekable_filter_class_init,
	NULL, /* instance init function */
	NULL, NULL,		/* reserved 1 & 2 */
	NULL
      };

      gmf_seekable_filter_type =
	gtk_type_unique (gmf_filter_get_type(), &gmf_seekable_filter_info);
    }

  return gmf_seekable_filter_type;
}


GtkObject *
gmf_seekable_filter_new (GMF_Filter_Type filter_type, const char *goad_id)
{
  GtkObject *retval;
  GMFFilter *filter;
  impl_POA_GMF_Filter *servant;

  retval = gtk_type_new(gmf_seekable_filter_get_type());
  filter = GMF_FILTER(retval);

  servant = FILTER_DATA(filter);
  servant->gtkobj = filter;
  servant->attr_filterType = filter_type;
  servant->attr_goadID = g_strdup(goad_id);

  return retval;
}

