/*  Glimmer - windows.c
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "windows.h"
#include "main.h"
#include "misc.h"
#include "signals.h"
#include "widgets/gdsfile.h"

void
new_window_cb (GtkWidget * widget, gpointer data)
{
    gchar *command = NULL;

    command = g_strdup_printf ("%s &", PACKAGE);
    system (command);
    g_free (command);
}

void
cycle_left_cb (GtkWidget *widget, gpointer data)
{
    GdsFile *new_file;
    gint index;
    gint new_index;
    gint total;

    total = g_list_length (GTK_NOTEBOOK (files_book)->children);
    index = get_nth_file_number (cur_file);
    if (index == -1)
        return;
    if (index == 0)
        new_index = total - 1;
    else
        new_index = index - 1;
    if (index == new_index)
        return;
    new_file = get_nth_file_proper (new_index);
    if (new_file)
        file_change (NULL, new_file);
}

void
cycle_right_cb (GtkWidget *widget, gpointer data)
{
    GdsFile *new_file;
    gint index;
    gint new_index;
    gint total;

    total = g_list_length (GTK_NOTEBOOK (files_book)->children);
    index = get_nth_file_number (cur_file);
    if (index == -1)
        return;
    if (index == total - 1)
        new_index = 0;
    else
        new_index = index + 1;
    if (index == new_index)
        return;
    new_file = get_nth_file_proper (new_index);
    if (new_file)
        file_change (NULL, new_file);
}

void
move_left_cb (GtkWidget *widget, gpointer data)
{
    GdsFile *new_file;
    GtkWidget *parent;
    GtkWidget *menu_item;
    gint index;
    gint new_index;
    gint new_file_index;
    gint total;

    total = g_list_length (GTK_NOTEBOOK (files_book)->children);
    index = get_nth_file_number (cur_file);
    if (index == -1)
        return;
    if (index == 0)
        new_index = total - 1;
    else
        new_index = index - 1;
    if (index == new_index)
        return;
#ifdef WITH_PYTHON
    app_emit_scripting_signal ("move-left");
#endif
    new_file = get_nth_file_proper (new_index);
    new_file_index = g_list_index (files_list, new_file);
    files_list = g_list_remove (files_list, (gpointer) cur_file);
    files_list =
        g_list_insert (files_list, (gpointer) cur_file, new_file_index);
    gtk_notebook_reorder_child (GTK_NOTEBOOK (files_book), cur_file->tear_away,
                                new_index);
    menu_item = cur_file->menu_item;
    parent = menu_item->parent;
    gtk_widget_ref (menu_item);
    gtk_container_remove (GTK_CONTAINER (parent), menu_item);
    gtk_menu_shell_insert (GTK_MENU_SHELL (parent), menu_item,
                           new_file_index + 2);
    gtk_widget_unref (menu_item);
    cur_page = new_index;
}

void
move_right_cb (GtkWidget *widget, gpointer data)
{
    GdsFile *new_file;
    GtkWidget *parent;
    GtkWidget *menu_item;
    gint index;
    gint new_index;
    gint new_file_index;
    gint total;

    total = g_list_length (GTK_NOTEBOOK (files_book)->children);
    index = get_nth_file_number (cur_file);
    if (index == -1)
        return;
    if (index == total - 1)
        new_index = 0;
    else
        new_index = index + 1;
    if (index == new_index)
        return;
#ifdef WITH_PYTHON
    app_emit_scripting_signal ("move-right");
#endif
    new_file = get_nth_file_proper (new_index);
    new_file_index = g_list_index (files_list, new_file);
    files_list = g_list_remove (files_list, (gpointer) cur_file);
    files_list =
        g_list_insert (files_list, (gpointer) cur_file, new_file_index);
    gtk_notebook_reorder_child (GTK_NOTEBOOK (files_book), cur_file->tear_away,
                                new_index);
    menu_item = cur_file->menu_item;
    parent = menu_item->parent;
    gtk_widget_ref (menu_item);
    gtk_container_remove (GTK_CONTAINER (parent), menu_item);
    gtk_menu_shell_insert (GTK_MENU_SHELL (parent), menu_item,
                           new_file_index + 2);
    gtk_widget_unref (menu_item);
    cur_page = new_index;
}

#ifdef WITH_PYTHON

void
cycle_left_paned_cb (GtkWidget *widget, gpointer data)
{
    gint index;
    gint new_index;
    gint total = 0;
    GtkWidget *w;

    if (!panedbook1)
        return;

    total = g_list_length (GTK_NOTEBOOK (panedbook1)->children);

    index = gtk_notebook_get_current_page (GTK_NOTEBOOK (panedbook1));
    if (index == -1)
        return;
    if (index == 0)
        new_index = total - 1;
    else
        new_index = index - 1;
    if (index == new_index)
        return;
    gtk_notebook_set_page (GTK_NOTEBOOK (panedbook1), new_index);
    w = gtk_notebook_get_nth_page (GTK_NOTEBOOK (panedbook1), index);
    focus_current_paned_cb (widget, NULL);
}

void
cycle_right_paned_cb (GtkWidget *widget, gpointer data)
{
    gint index;
    gint new_index;
    gint total;
    GtkWidget *w;

    total = g_list_length (GTK_NOTEBOOK (panedbook1)->children);

    index = gtk_notebook_get_current_page (GTK_NOTEBOOK (panedbook1));
    if (index == -1)
        return;
    if (index == total - 1)
        new_index = 0;
    else
        new_index = index + 1;
    if (index == new_index)
        return;
    gtk_notebook_set_page (GTK_NOTEBOOK (panedbook1), new_index);
    w = gtk_notebook_get_nth_page (GTK_NOTEBOOK (panedbook1), index);
    focus_current_paned_cb (widget, NULL);
}

void
focus_current_paned_cb (GtkWidget *widget, gpointer data)
{
    GList *contained_widgets;
    GtkWidget *current_page;
    GtkWidget *panedbook = NULL;
    GtkWidget *panedbooks[3];
    GtkWidget *w;
    gint i = 0;

    /* Panedbook1..4 are global vars defined in main.h */
    panedbooks[0] = panedbook1;
    panedbooks[1] = panedbook2;
    panedbooks[2] = panedbook3;
    panedbooks[3] = panedbook4;

    /* Find the first non-empy paned book */
    for (; i <= 3; i++) {
        if (panedbooks[i]) {
            panedbook = panedbooks[i];
            break;
        }
    }
    if (!panedbook)
        return;
    current_page =
        gtk_notebook_get_nth_page (GTK_NOTEBOOK (panedbook),
                                   gtk_notebook_get_current_page (GTK_NOTEBOOK
                                                                  (panedbook)));

    /* Widget mapped in notebook page may not be a container. */
    if (GTK_IS_CONTAINER (GTK_WIDGET (current_page))) {
        contained_widgets =
            g_list_first (gtk_container_children
                          (GTK_CONTAINER (current_page)));
        do {
            if (GTK_WIDGET_CAN_FOCUS (GTK_WIDGET (contained_widgets->data))) {
                /* The actual widget can focus, OK! */
                gtk_widget_grab_focus (GTK_WIDGET (contained_widgets->data));
                g_list_free (contained_widgets);
                return;
            }
            if (GTK_IS_CONTAINER (GTK_WIDGET (contained_widgets->data))) {
                /* The widget is a container, add his child to our list and remove itself to avoid recursion */
                w = contained_widgets->data;
                contained_widgets =
                    g_list_remove (contained_widgets, contained_widgets->data);
                contained_widgets =
                    g_list_concat (contained_widgets,
                                   gtk_container_children (GTK_CONTAINER (w)));
            }
            contained_widgets = g_list_next (contained_widgets);
        } while (contained_widgets);
        /* Unlikely to get here */
        g_list_free (contained_widgets);
        return;
    } else {
        if (GTK_WIDGET_CAN_FOCUS (GTK_WIDGET (current_page))) {
            /* Only one widget in the page, focus it! */
            gtk_widget_grab_focus (GTK_WIDGET (current_page));
            return;
        }
    }
}
#endif

void
focus_current_file_cb (GtkWidget *widget, gpointer data)
{
    if (cur_file)
        gtk_widget_grab_focus (cur_file->text);
}
