/*  Glimmer - gnome-settings.h
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <gnome.h>

#ifndef _GNOME_SETTINGS_H_
#define _GNOME_SETTINGS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_SETTINGS (gnome_settings_get_type())
#define GNOME_SETTINGS(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_SETTINGS, GnomeSettings))
#define GNOME_SETTINGS_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_SETTINGS, GnomeSettingsClass))
#define GNOME_IS_SETTINGS(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_SETTINGS))
#define GNOME_IS_SETTINGS_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_SETTINGS))

typedef struct _GnomeSettings GnomeSettings;
typedef struct _GnomeSettingsClass GnomeSettingsClass;

struct _GnomeSettings {
    GtkHPaned paned;
    GtkWidget *ctree;
    GtkWidget *hbox;
    GList *children;
    GtkWidget *current;
    gint selected_row;
};

struct _GnomeSettingsClass {
    GtkHPanedClass parent_class;
};

GtkType gnome_settings_get_type(void);

GtkWidget *gnome_settings_new(void);

GtkCTreeNode *gnome_settings_add_page(GnomeSettings *settings, GtkCTreeNode *parent,
                                      gchar *title, GnomePixmap *pixmap,
                                      GtkWidget *new_child);

#ifdef __cplusplus /* cpp compatibility */
}
#endif

#endif
