/*  Glimmer - gnome-password-dialog.h
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#ifndef _GNOME_PASSWORD_DIALOG_H_
#define _GNOME_PASSWORD_DIALOG_H_
#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_PASSWORD_DIALOG (gnome_password_dialog_get_type())
#define GNOME_PASSWORD_DIALOG(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_PASSWORD_DIALOG, GnomePasswordDialog))
#define GNOME_PASSWORD_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GNOME_TYPE_PASSWORD_DIALOG, GnomePasswordDialogClass))
#define GNOME_IS_PASSWORD_DIALOG(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_PASSWORD_DIALOG))
#define GNOME_IS_PASSWORD_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_TYPE_PASSWORD_DIALOG))

typedef struct _GnomePasswordDialog GnomePasswordDialog;
typedef struct _GnomePasswordDialogClass GnomePasswordDialogClass;

struct _GnomePasswordDialog {
    GtkWindow window;
    GtkWidget *username_entry;
    GtkWidget *password_entry;
    GtkWidget *save_pass;
    GtkWidget *ok_button;
    GtkWidget *cancel_button;
    GnomeVFSURI *uri;
};

struct _GnomePasswordDialogClass {
    GtkWindowClass parent_class;
};

GtkType gnome_password_dialog_get_type(void);

GtkWidget *gnome_password_dialog_new(gchar *title);
gchar *gnome_password_dialog_get_username(GnomePasswordDialog *dialog);
gchar *gnome_password_dialog_get_password(GnomePasswordDialog *dialog);
void gnome_password_dialog_set_username(GnomePasswordDialog *dialog, gchar *username);
void gnome_password_dialog_set_password(GnomePasswordDialog *dialog, gchar *password);

void gnome_password_dialog_set_save_pass(GnomePasswordDialog *dialog, gboolean save);
gboolean gnome_password_dialog_get_save_pass(GnomePasswordDialog *dialog);
#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
