/*  Glimmer - view.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "view.h"
#include "commandbar.h"
#include "findbar.h"
#include "highlightbar.h"
#include "linebar.h"
#include "menus.h"
#include "toolbar.h"

void init_view_settings(void)
{
   GtkCheckMenuItem *item;
   gint file, edit, build, highlight, find, line, status;
#ifdef WITH_PYTHON
   gint custom, command;
#endif
   if(!gnome_config_has_section("/" PACKAGE "/view"))
      save_view_defaults();

   file = gnome_config_get_int("/" PACKAGE "/view/filebar=1");
   edit = gnome_config_get_int("/" PACKAGE "/view/editbar=0");
   build = gnome_config_get_int("/" PACKAGE "/view/buildbar=0");
   highlight = gnome_config_get_int("/" PACKAGE "/view/highlightbar=1");
   find = gnome_config_get_int("/" PACKAGE "/view/findbar=1");
   line = gnome_config_get_int("/" PACKAGE "/view/linebar=0");
#ifdef WITH_PYTHON
   custom = gnome_config_get_int("/" PACKAGE "/view/custombar=0");
   command = gnome_config_get_int("/" PACKAGE "/view/commandbar=0");
#endif
   status = gnome_config_get_int("/" PACKAGE "/view/statusbar=0");

   item = GTK_CHECK_MENU_ITEM(view_file);
   gtk_check_menu_item_set_active(item, file);
   set_filebar_visibility(view_file, NULL);

   item = GTK_CHECK_MENU_ITEM(view_edit);
   gtk_check_menu_item_set_active(item, edit);
   set_editbar_visibility(view_edit, NULL);

   item = GTK_CHECK_MENU_ITEM(view_build);
   gtk_check_menu_item_set_active(item, build);
   set_buildbar_visibility(view_build, NULL);

   item = GTK_CHECK_MENU_ITEM(view_highlight);
   gtk_check_menu_item_set_active(item, highlight);
   set_highlightbar_visibility(view_highlight, NULL);

   item = GTK_CHECK_MENU_ITEM(view_find);
   gtk_check_menu_item_set_active(item, find);
   set_findbar_visibility(view_find, NULL);

   item = GTK_CHECK_MENU_ITEM(view_line);
   gtk_check_menu_item_set_active(item, line);
   set_linebar_visibility(view_line, NULL);

#ifdef WITH_PYTHON
   item = GTK_CHECK_MENU_ITEM(view_custom);
   gtk_check_menu_item_set_active(item, custom);
   set_custombar_visibility(view_custom, NULL);

   item = GTK_CHECK_MENU_ITEM(view_command);
   gtk_check_menu_item_set_active(item, command);
   set_commandbar_visibility(view_command, NULL);
#endif

   item = GTK_CHECK_MENU_ITEM(view_status);
   gtk_check_menu_item_set_active(item, status);
   set_statusbar_visibility(view_status, NULL);
}

void save_view_defaults(void)
{
   gnome_config_set_int("/" PACKAGE "/view/filebar", 1);
   gnome_config_set_int("/" PACKAGE "/view/editbar", 0);
   gnome_config_set_int("/" PACKAGE "/view/buildbar", 0);
   gnome_config_set_int("/" PACKAGE "/view/highlightbar", 1);
   gnome_config_set_int("/" PACKAGE "/view/findbar", 1);
   gnome_config_set_int("/" PACKAGE "/view/linebar", 0);
#ifdef WITH_PYTHON
   gnome_config_set_int("/" PACKAGE "/view/custombar", 0);
   gnome_config_set_int("/" PACKAGE "/view/commandbar", 0);
#endif
   gnome_config_set_int("/" PACKAGE "/view/statusbar",1);
   gnome_config_sync();
}

void save_view_settings(void)
{
   GtkCheckMenuItem *item;

   item = GTK_CHECK_MENU_ITEM(view_file);
   gnome_config_set_int("/" PACKAGE "/view/filebar", item->active);
   item = GTK_CHECK_MENU_ITEM(view_edit);
   gnome_config_set_int("/" PACKAGE "/view/editbar", item->active);
   item = GTK_CHECK_MENU_ITEM(view_build);
   gnome_config_set_int("/" PACKAGE "/view/buildbar", item->active);
   item = GTK_CHECK_MENU_ITEM(view_highlight);
   gnome_config_set_int("/" PACKAGE "/view/highlightbar", item->active);
   item = GTK_CHECK_MENU_ITEM(view_find);
   gnome_config_set_int("/" PACKAGE "/view/findbar", item->active);
   item = GTK_CHECK_MENU_ITEM(view_line);
   gnome_config_set_int("/" PACKAGE "/view/linebar", item->active);
#ifdef WITH_PYTHON
   item = GTK_CHECK_MENU_ITEM(view_custom);
   gnome_config_set_int("/" PACKAGE "/view/custombar", item->active);
   item = GTK_CHECK_MENU_ITEM(view_command);
   gnome_config_set_int("/" PACKAGE "/view/commandbar", item->active);
#endif
   item = GTK_CHECK_MENU_ITEM(view_status);
   gnome_config_set_int("/" PACKAGE "/view/statusbar",item->active);
   gnome_config_sync();
}

void save_view_settings_cb(GtkWidget *widget, gpointer data)
{
   save_view_settings();
}

void set_filebar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(filebar->parent);
   else
      gtk_widget_hide(filebar->parent);
   gtk_widget_queue_resize(window);
}

void set_editbar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(editbar->parent);
   else
      gtk_widget_hide(editbar->parent);
   gtk_widget_queue_resize(window);
}

void set_buildbar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(buildbar->parent);
   else
      gtk_widget_hide(buildbar->parent);
   gtk_widget_queue_resize(window);
}

void set_highlightbar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(highlightbar->parent);
   else
      gtk_widget_hide(highlightbar->parent);
   gtk_widget_queue_resize(window);
}

void set_findbar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(findbar->parent);
   else
   {
      gtk_entry_set_text(GTK_ENTRY(find_entry), "");
      gtk_widget_hide(findbar->parent);
   }
   gtk_widget_queue_resize(window);
}

void set_linebar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(linebar->parent);
   else
   {
      gtk_entry_set_text(GTK_ENTRY(line_entry), "");
      gtk_widget_hide(linebar->parent);
   }
   gtk_widget_queue_resize(window);
}

#ifdef WITH_PYTHON
void set_custombar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(custombar->parent->parent);
   else
      gtk_widget_hide(custombar->parent->parent);
   gtk_widget_queue_resize(window);
}
#endif

#ifdef WITH_PYTHON
void set_commandbar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(commandbar->parent);
   else
   {
      gtk_entry_set_text(GTK_ENTRY(macro_entry), "");
      gtk_widget_hide(commandbar->parent);
   }
   gtk_widget_queue_resize(window);
}
#endif

void set_statusbar_visibility(GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *item;
   item = GTK_CHECK_MENU_ITEM(widget);
   if(item->active)
      gtk_widget_show(appbar);
   else
      gtk_widget_hide(appbar);
   gtk_widget_queue_resize(window);
}
