/*  Glimmer - signals.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _SIGNALS_H__
#define _SIGNALS_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WITH_PYTHON

#include "declarations.h"
#include "widgets/gdsfile.h"

gboolean table_emit_scripting_signal(gchar *signal, GdsFileHighlightTable *table);
gboolean file_emit_scripting_signal(gchar *signal, GdsFile *file);
gboolean app_emit_scripting_signal(gchar *signal);

gboolean call_scripting_function(gpointer function);
gboolean check_scripting_function(gpointer function);
gboolean call_scripting_function_extended(gpointer function, gint control, gint shift, gint alt, gint key, gint pos);

void remove_signal_hooks(GdsFileHighlightTable *table);

extern GList *open_signals;
extern GList *revert_signals;
extern GList *save_signals;
extern GList *save_as_signals;
extern GList *close_signals;
extern GList *change_signals;

extern GList *move_left_signals;
extern GList *move_right_signals;
#endif

#ifdef __cplusplus
}
#endif

#endif
