/*  Glimmer - main.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _MAIN_H_
#define _MAIN_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gdsfile.h"

void main_finish(void *closure, int argc, char *argv[]);
void file_change(GtkWidget *widget, GdsFile *new_file);
void set_notebook_page(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer data);
void set_window_title(void);
void adjust_sensitivity(void);
void directory_check(void);
void destroy(GtkWidget *widget, gpointer data);
void kill_widget(GtkWidget *widget, GtkWidget *killer);
void pre_exit(GtkWidget *widget, gpointer data);
void try_exit(GtkWidget *widget, gpointer data);
void main_window_focused(GtkWidget *widget, GdkEventFocus *event, gpointer data);

extern GtkWidget *app;
extern GtkWidget *window;
extern GtkWidget *appbar;
extern GtkWidget *whole_window_box;
extern GtkWidget *hpaned1;
extern GtkWidget *vpaned2;
extern GtkWidget *hpaned3;
extern GtkWidget *vpaned4;
extern GtkWidget *panedbook1;
extern GtkWidget *panedbook2;
extern GtkWidget *panedbook3;
extern GtkWidget *panedbook4;
extern GHashTable *child_hash;
extern GtkWidget *main_window_box;
extern GtkWidget *edit_box;
extern GtkWidget *files_book;
extern GtkStyle *extext_style;
extern GtkAccelGroup *accel_group;
extern GnomePixmap *bookmark_pixmap;
extern gint cur_page;
extern gint total_files;
extern GList *files_list;
extern GdsFile *cur_file;

#ifdef __cplusplus
}
#endif

#endif
