/*  Glimmer - menus.c
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "menus.h"
#include "about.h"
#include "build.h"
#include "color-settings.h"
#include "dialogs.h"
#include "edit.h"
#include "file-io.h"
#include "insert.h"
#include "main.h"
#include "macro-language.h"
#include "misc.h"
#include "properties.h"
#include "searches.h"
#include "settings.h"
#include "session.h"
#include "syntax-highlight.h"
#include "windows.h"
#include "view.h"
#include "libprint/print.h"

#include "xpm/selection.xpm"
#include "xpm/select_all.xpm"
#include "xpm/debug.xpm"
#include "xpm/window.xpm"

GtkWidget *filemenu;
GtkWidget *recentmenu;
GtkWidget *editmenu;
GtkWidget *searchmenu;
GtkWidget *insertmenu;
GtkWidget *insertmenutitle;
GtkWidget *buildmenu;
GtkWidget *buildmenutitle;
GtkWidget *docsmenu;
GtkWidget *scriptsmenu;
GtkWidget *viewmenu;
GtkWidget *settingsmenu;
GtkWidget *windowmenu;
GtkWidget *helpmenu;
GtkWidget *file_menu_new;
GtkWidget *file_menu_open;
GtkWidget *file_menu_revert;
GtkWidget *file_menu_save;
GtkWidget *file_menu_saveas;
GtkWidget *file_menu_save_all;
GtkWidget *file_menu_close;
GtkWidget *file_menu_close_all;
GtkWidget *file_menu_print;
GtkWidget *file_menu_print_preview;
GtkWidget *edit_menu_undo;
GtkWidget *edit_menu_redo;
GtkWidget *search_menu_match;
GtkWidget *build_menu_compile;
GtkWidget *build_menu_kill_compile;
GtkWidget *build_menu_debug;
GtkWidget *build_menu_kill_debug;
GtkWidget *build_menu_execute;
GtkWidget *build_menu_kill_exec;
GtkWidget *view_file;
GtkWidget *view_edit;
GtkWidget *view_build;
GtkWidget *view_highlight;
GtkWidget *view_find;
GtkWidget *view_line;
GtkWidget *view_custom;
GtkWidget *view_command;
GtkWidget *view_status;
GtkWidget *windows_menu_prev;
GtkWidget *windows_menu_next;
GtkWidget *windows_menu_moveprev;
GtkWidget *windows_menu_movenext;
GtkWidget *edit_popup_menu;

GnomeUIInfo session_menu[] = {
   { GNOME_APP_UI_ITEM, _("_Save Current Session"), _("Save the current session"),(gpointer)save_session_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE, 'S',(GdkModifierType)(GDK_CONTROL_MASK | GDK_MOD1_MASK), 0 },
   { GNOME_APP_UI_ITEM, _("Save Session _As..."), _("Save the current session with a different name"),(gpointer)save_session_as_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE_AS, 'A',(GdkModifierType)(GDK_CONTROL_MASK | GDK_MOD1_MASK), 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Open Session..."), _("Open a session"),(gpointer)open_session_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_OPEN, 'O',(GdkModifierType)(GDK_CONTROL_MASK | GDK_MOD1_MASK), 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo recent_menu[] = {
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_END
};

GnomeUIInfo file_menu[] = {
   { GNOME_APP_UI_ITEM, _("_New"), _("Create a new file."),(gpointer)new_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW, 'N', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("_Open..."), _("Open a file."),(gpointer)open_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_OPEN, 'O', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Open _Multiple..."), _("Open window with explicit close."),(gpointer)open_files_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_OPEN, 'O',(GdkModifierType)(GDK_CONTROL_MASK | GDK_SHIFT_MASK), NULL },
   { GNOME_APP_UI_ITEM, _("_Revert"), _("Revert to saved file."),(gpointer)revert_current_file, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REVERT, 'R',(GdkModifierType)(GDK_CONTROL_MASK | GDK_SHIFT_MASK), 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Save"), _("Save the current file."),(gpointer)save_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE, 'S', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Save _As"), _("Save the current file."),(gpointer)save_file_as_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE_AS, 'A', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Sa_ve All"), _("Save all open files"),(gpointer)save_all_files_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE, 'S',(GdkModifierType)(GDK_CONTROL_MASK | GDK_SHIFT_MASK), 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Close"), _("Close the current file."),(gpointer)close_file_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE, 'W', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("C_lose All"), _("Close all open files"),(gpointer)close_all_files_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE, 'W',(GdkModifierType)(GDK_CONTROL_MASK | GDK_SHIFT_MASK), 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Print"), _("Print the current file."),(gpointer)glimmer_print_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PRINT, 'P', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Print Preview"), _("Preview printing of the current file."),(gpointer)glimmer_print_preview_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PRINT, 'P',(GdkModifierType)(GDK_CONTROL_MASK | GDK_SHIFT_MASK), 0 },
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_SUBTREE(_("Sess_ion"), session_menu),
   GNOMEUIINFO_SUBTREE(_("Recent Files"),(gpointer)recent_menu),
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Exit"), _("Exit the program."),(gpointer)pre_exit, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXIT, 'Q', GDK_CONTROL_MASK, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo edit_menu[] = {
   GNOMEUIINFO_MENU_UNDO_ITEM((gpointer)undo_last_cb, 0),
   GNOMEUIINFO_MENU_REDO_ITEM((gpointer)redo_last_cb, 0),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_MENU_CUT_ITEM((gpointer)cut_text_cb, 0),
   GNOMEUIINFO_MENU_COPY_ITEM((gpointer)copy_text_cb, 0),
   GNOMEUIINFO_MENU_PASTE_ITEM((gpointer)paste_text_cb, 0),
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Bookmark Line"), _("Reverse Bookmark"),(gpointer)reverse_bookmark_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_ADD, 'B', GDK_CONTROL_MASK, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("Clear"), _("Clear selection"),(gpointer)clear_text_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR, GDK_F8,(GdkModifierType) 0, 0 },
   { GNOME_APP_UI_ITEM, _("Clear Line"), _("Clear the current line"),(gpointer)clear_line_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR, GDK_F8, GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Clear to Line Start"), _("Clear the current line"),(gpointer)clear_start_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR, GDK_Home, GDK_MOD1_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Clear to Line End"), _("Clear the current line"),(gpointer)clear_end_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR, GDK_End, GDK_MOD1_MASK, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("Select _All"), _("Select the entire document"),(gpointer)select_all_text_cb, 0, 0, GNOME_APP_PIXMAP_DATA, select_all_xpm, 'A', GDK_MOD1_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Select _Line"), _("Select the current line."),(gpointer)select_line_cb, 0, 0, GNOME_APP_PIXMAP_NONE, NULL, 'L', GDK_MOD1_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("_Select Current"), _("Select the current word"),(gpointer)select_current_cb, 0, 0, GNOME_APP_PIXMAP_DATA, selection_xpm, 'C', GDK_MOD1_MASK, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("Re-Highlight"), _("Re-Highlight the current file"),(gpointer)highlight_syntax_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_JUMP_TO, GDK_F4,(GdkModifierType) 0, 0 },
   { GNOME_APP_UI_ITEM, _("Regenerate Highlight Tables"), _("Regenerate highlighting tables for the current mime-type"),(gpointer)reparse_highlight_table_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REFRESH, GDK_F4, GDK_CONTROL_MASK, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("P_roperties"), _("Edit properties"),(gpointer)edit_properties, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PROPERTIES, GDK_F2,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo search_menu[] = {
   GNOMEUIINFO_MENU_FIND_ITEM((gpointer)find_cb, 0),
   GNOMEUIINFO_MENU_REPLACE_ITEM((gpointer)replace_cb, 0),
   { GNOME_APP_UI_ITEM, _("Goto Line..."), _("Goto a line"),(gpointer)gotoline_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_JUMP_TO, 'L', GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Search Manpages(Local)"), _("Search manpages"),(gpointer)manpage_cb, GINT_TO_POINTER(0), 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_INDEX, GDK_F1, GDK_SHIFT_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Search Manpages(Gnome)"), _("Search manpages with gnome-help-browser"),(gpointer)manpage_cb, GINT_TO_POINTER(1), 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_INDEX, GDK_F1,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Previous Bookmark"), _("Goto the next bookmark"),(gpointer)last_bookmark_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_UP, 'B',(GdkModifierType)(GDK_CONTROL_MASK | GDK_MOD1_MASK), 0 },
   { GNOME_APP_UI_ITEM, _("_Next Bookmark"), _("Goto the next bookmark"),(gpointer)next_bookmark_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_DOWN, 'B',(GdkModifierType)(GDK_CONTROL_MASK | GDK_SHIFT_MASK), 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("Match Bracket"), _("Goto the matching bracket"),(gpointer)match_bracket_cb, 0, 0, GNOME_APP_PIXMAP_NONE, NULL, 'E', GDK_CONTROL_MASK, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo common_text_menu[] = {
   GNOMEUIINFO_ITEM_NONE(_("ChangeLog _Entry"), _("Insert ChangeLog entry"),(gpointer)insert_changelog_string),
   GNOMEUIINFO_ITEM_NONE(_("_Date & Time"), _("Insert current date and time"),(gpointer)insert_date_time),         
   GNOMEUIINFO_ITEM_NONE(_("_User Name"), _("Insert the name of the current user"),(gpointer)insert_username),         
   GNOMEUIINFO_ITEM_NONE(_("_Name"), _("Insert name(from prefs)"),(gpointer)insert_name),
   GNOMEUIINFO_ITEM_NONE(_("Email _Address"), _("Insert email(from prefs)"),(gpointer)insert_email),         
   GNOMEUIINFO_ITEM_NONE(_("_GPL Notice(C)"), _("Insert GPL notice with C comments"),(gpointer)insert_gpl_notice),
   GNOMEUIINFO_ITEM_NONE(_("G_PL Notice(C++)"), _("Insert GPL notice with C++ comments"),(gpointer)insert_gpl_noticepp),
   GNOMEUIINFO_ITEM_NONE(_("G_PL Notice(#)"), _("Insert GPL notice with # comments"),(gpointer)insert_gpl_noticepython),
   GNOMEUIINFO_END
};

GnomeUIInfo insert_menu[] = {
   GNOMEUIINFO_ITEM_NONE(_("I_ndent..."), _("Indent a selected area."),(gpointer)indent_cb),
   GNOMEUIINFO_ITEM_NONE(_("_Insert File..."), _("Insert a file"),(gpointer)insert_file_cb),
   GNOMEUIINFO_ITEM_NONE(_("_Insert Color..."), _("Insert a color"),(gpointer)insert_color_cb),
   GNOMEUIINFO_ITEM_NONE(_("_Ascii Character..."), _("Insert a chracter from the chooser"),(gpointer)insert_ascii_char_cb),
   GNOMEUIINFO_ITEM_NONE(_("_Shell Output..."), _("Insert output from a command"),(gpointer)runcmd_cb),
   GNOMEUIINFO_SUBTREE(_("_Common Text"), common_text_menu),   
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_END
};

GnomeUIInfo build_menu[] = {
   { GNOME_APP_UI_ITEM, _("_Compile"), _("Compile the current source file"),(gpointer)compile_file_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CONVERT, GDK_F5,(GdkModifierType) 0, 0 },
   { GNOME_APP_UI_ITEM, _("Stop Compile"), _("Kill the currently executing compile process"),(gpointer)kill_compile_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_STOP, 0,(GdkModifierType) 0, 0 },
   { GNOME_APP_UI_ITEM, _("_Debug"), _("Debug the current source file"),(gpointer)debug_file_cb, 0, 0, GNOME_APP_PIXMAP_DATA, debug_xpm, GDK_F5, GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Stop Debug"), _("Kill the currently executing debug process"),(gpointer)kill_debug_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_STOP, 0,(GdkModifierType) 0, 0 },
   { GNOME_APP_UI_ITEM, _("_Execute"), _("Execute the current program"),(gpointer)execute_file_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXEC, GDK_F5, GDK_SHIFT_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Stop Execution"), _("Kill the currently executing process"),(gpointer)kill_execute_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_STOP, 0,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo docs_menu[] = {
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_END
};

#ifdef WITH_PYTHON
GnomeUIInfo scripts_menu[] = {
   { GNOME_APP_UI_ITEM, _("_Regenerate Menu"), _("Regenerate the scripts menu"),(gpointer)regenerate_scripts_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REFRESH, 0,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_END
};
#endif

GnomeUIInfo view_menu[] = {
   { GNOME_APP_UI_TOGGLEITEM, _("File Toolbar"), _("Toggle the visibility of the file toolbar"),(gpointer)set_filebar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   { GNOME_APP_UI_TOGGLEITEM, _("Edit Toolbar"), _("Toggle the visibility of the edit toolbar"),(gpointer)set_editbar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   { GNOME_APP_UI_TOGGLEITEM, _("Build Toolbar"), _("Toggle the visibility of the build toolbar"),(gpointer)set_buildbar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   { GNOME_APP_UI_TOGGLEITEM, _("Highlight Toolbar"), _("Toggle the visibility of the highlight toolbar"),(gpointer)set_highlightbar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   { GNOME_APP_UI_TOGGLEITEM, _("Find Toolbar"), _("Toggle the visibility of the find toolbar"),(gpointer)set_findbar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   { GNOME_APP_UI_TOGGLEITEM, _("Line Toolbar"), _("Toggle the visibility of the line toolbar"),(gpointer)set_linebar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
#ifdef WITH_PYTHON
   { GNOME_APP_UI_TOGGLEITEM, _("Custom Toolbar"), _("Toggle the visibility of the custom toolbar"),(gpointer)set_custombar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   { GNOME_APP_UI_TOGGLEITEM, _("Command Toolbar"), _("Toggle the visibility of the command toolbar"),(gpointer)set_commandbar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
#endif
   { GNOME_APP_UI_TOGGLEITEM, _("Status Bar"), _("Toggle the visibility of the Status Bar"),(gpointer)set_statusbar_visibility, NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,(GdkModifierType) 0, NULL },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("Save View Settings"), _("Save the current view settings"),(gpointer)save_view_settings_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_SAVE, 0,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo settings_menu[] = {
   { GNOME_APP_UI_ITEM, _("Preferences..."), _("Edit the program preferences"),(gpointer)edit_preferences, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_PREFERENCES, 0,(GdkModifierType) 0, 0 },
   { GNOME_APP_UI_ITEM, _("Highlight Colors..."), _("Edit the highlighting colors"),(gpointer)change_colors_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_COLORSELECTOR, 0,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo window_menu[] = {
   { GNOME_APP_UI_ITEM, _("New Main _Window"), _("New instance of " PACKAGE),(gpointer)new_window_cb, 0, 0, GNOME_APP_PIXMAP_DATA, window_xpm, 0,(GdkModifierType) 0, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("_Previous File"), _("Goto the previous file in the list."),(gpointer)cycle_left_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_BACK, ',',(GdkModifierType) GDK_CONTROL_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("_Next File"), _("Goto the next file in the list."),(gpointer)cycle_right_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_FORWARD, '.',(GdkModifierType) GDK_CONTROL_MASK, 0 },
   GNOMEUIINFO_SEPARATOR,
   { GNOME_APP_UI_ITEM, _("Move File _Backward"), _("Move this file backward in the list."),(gpointer)move_left_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_BACK, ',',(GdkModifierType) GDK_MOD1_MASK, 0 },
   { GNOME_APP_UI_ITEM, _("Move File _Forward"), _("Move this file forward in the list."),(gpointer)move_right_cb, 0, 0, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_FORWARD, '.',(GdkModifierType) GDK_MOD1_MASK, 0 },
   GNOMEUIINFO_END
};

GnomeUIInfo help_menu[] = {
   GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_HELP((gpointer)PACKAGE),
   GNOMEUIINFO_MENU_ABOUT_ITEM((gpointer)do_about, 0),
   GNOMEUIINFO_END
};

GnomeUIInfo menubar[] = {
   GNOMEUIINFO_SUBTREE(_("_File"), file_menu),
   GNOMEUIINFO_SUBTREE(_("_Edit"), edit_menu),
   GNOMEUIINFO_SUBTREE(_("_Search"), search_menu),
   GNOMEUIINFO_SUBTREE(_("_Insert"), insert_menu),
   GNOMEUIINFO_SUBTREE(_("_Build"), build_menu),
   GNOMEUIINFO_SUBTREE(_("_Documents"), docs_menu),
#ifdef WITH_PYTHON
   GNOMEUIINFO_SUBTREE(_("Sc_ripts"), scripts_menu),
#endif
   GNOMEUIINFO_SUBTREE(_("_View"), view_menu),
   GNOMEUIINFO_SUBTREE(_("Se_ttings"), settings_menu),
   GNOMEUIINFO_SUBTREE(_("_Window"), window_menu),
   GNOMEUIINFO_SUBTREE(_("_Help"), help_menu),
   GNOMEUIINFO_END
};

static GtkItemFactoryEntry popup_items[] = {
   { _("/_File"), NULL,(GtkSignalFunc)NULL, 0, "<Branch>" },
   { _("/File/_Save"), NULL, GTK_SIGNAL_FUNC(save_file_cb), 0, NULL },
   { _("/File/Save _As..."), NULL, GTK_SIGNAL_FUNC(save_file_as_cb), 0, NULL },
   { _("/File/_Close"), NULL, GTK_SIGNAL_FUNC(close_file_cb), 0, NULL },
   { _("/File/sep1"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/File/Save Current Session"), NULL, GTK_SIGNAL_FUNC(save_session_cb), 0, NULL },	 
   { _("/_Edit"), NULL,(GtkSignalFunc)NULL, 0, "<Branch>" },
   { _("/Edit/_Undo"), NULL, GTK_SIGNAL_FUNC(undo_last_cb), 0, NULL },
   { _("/Edit/_Redo"), NULL, GTK_SIGNAL_FUNC(redo_last_cb), 0, NULL },
   { _("/Edit/sep23"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Edit/_Cut"), NULL, GTK_SIGNAL_FUNC(cut_text_cb), 0, NULL },
   { _("/Edit/C_opy"), NULL, GTK_SIGNAL_FUNC(copy_text_cb), 0, NULL },
   { _("/Edit/_Paste"), NULL, GTK_SIGNAL_FUNC(paste_text_cb), 0, NULL },
   { _("/Edit/sep2"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Edit/Bookmark Line"), NULL, GTK_SIGNAL_FUNC(reverse_bookmark_cb), 0, NULL },
   { _("/Edit/sep3"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Edit/Clear"), NULL, GTK_SIGNAL_FUNC(clear_text_cb), 0, NULL },
   { _("/Edit/Clear Line"), NULL, GTK_SIGNAL_FUNC(clear_line_cb), 0, NULL },
   { _("/Edit/Clear to Line Start"), NULL, GTK_SIGNAL_FUNC(clear_start_cb), 0, NULL },
   { _("/Edit/Clear to Line End"), NULL, GTK_SIGNAL_FUNC(clear_end_cb), 0, NULL },
   { _("/Edit/sep4"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Edit/Select All"), NULL, GTK_SIGNAL_FUNC(select_all_text_cb), 0, NULL },
   { _("/Edit/Select Line"), NULL, GTK_SIGNAL_FUNC(select_line_cb), 0, NULL },
   { _("/Edit/Select Current"), NULL, GTK_SIGNAL_FUNC(select_current_cb), 0, NULL },
   { _("/Edit/sep5"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Edit/Re-Highlight"), NULL, GTK_SIGNAL_FUNC(highlight_syntax_cb), 0, NULL },
   { _("/Edit/Regenerate Highlight Tables"), NULL, GTK_SIGNAL_FUNC(reparse_highlight_table_cb), 0, NULL },
   { _("/Edit/sep6"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Edit/P_roperties..."), NULL, GTK_SIGNAL_FUNC(edit_properties), 0, NULL },
   { _("/_Search"), NULL,(GtkSignalFunc)NULL, 0, "<Branch>" },
   { _("/Search/_Find..."), NULL, GTK_SIGNAL_FUNC(find_cb), 0, NULL },
   { _("/Search/_Replace..."), NULL, GTK_SIGNAL_FUNC(replace_cb), 0, NULL },
   { _("/Search/_Goto Line..."), NULL, GTK_SIGNAL_FUNC(gotoline_cb), 0, NULL },
   { _("/Search/_Search Manpages..."), NULL, GTK_SIGNAL_FUNC(manpage_cb), 0, NULL },
   { _("/Search/sep1"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Search/_Previous Bookmark"), NULL, GTK_SIGNAL_FUNC(last_bookmark_cb), 0, NULL },
   { _("/Search/_Next Bookmark"), NULL, GTK_SIGNAL_FUNC(next_bookmark_cb), 0, NULL },
   { _("/Search/sep2"), NULL,(GtkSignalFunc)NULL, 0, "<Separator>" },
   { _("/Search/_Match Bracket"), NULL, GTK_SIGNAL_FUNC(match_bracket_cb), 0, NULL },
   { _("/_Insert"), NULL,(GtkSignalFunc)NULL, 0, "<Branch>" },
   { _("/Insert/File..."), NULL, GTK_SIGNAL_FUNC(insert_file_cb), 0, NULL },
   { _("/Insert/Color..."), NULL, GTK_SIGNAL_FUNC(insert_color_cb), 0, NULL },
   { _("/Insert/Changelog Entry"), NULL, GTK_SIGNAL_FUNC(insert_changelog_string), 0, NULL },
   { _("/Insert/GPL Notice (C)"), NULL, GTK_SIGNAL_FUNC(insert_gpl_notice), 0, NULL },
   { _("/Insert/GPL Notice (C++)"), NULL, GTK_SIGNAL_FUNC(insert_gpl_noticepp), 0, NULL }
};

void make_menus(void)
{
   GtkItemFactory *item_factory;
   gint nmenu_items;
   gnome_app_create_menus(GNOME_APP(window), menubar);
   gnome_app_install_appbar_menu_hints(GNOME_APPBAR(appbar), menubar);

   filemenu = menubar[0].widget;
   recentmenu = recent_menu[0].widget->parent;
   editmenu = menubar[1].widget;
   searchmenu = menubar[2].widget;
   insertmenutitle = menubar[3].widget;
   insertmenu = insert_menu[0].widget->parent;
   buildmenutitle = menubar[4].widget;
   buildmenu = build_menu[0].widget->parent;
   docsmenu = docs_menu[0].widget->parent;
#ifdef WITH_PYTHON
   scriptsmenu = scripts_menu[0].widget->parent;
#endif
   viewmenu = menubar[7].widget;
   settingsmenu = menubar[8].widget;
   windowmenu = window_menu[0].widget->parent;
   helpmenu = menubar[10].widget;

   file_menu_new = file_menu[0].widget;
   file_menu_open = file_menu[1].widget;
   file_menu_revert = file_menu[3].widget;
   file_menu_save = file_menu[5].widget;
   file_menu_saveas = file_menu[6].widget;
   file_menu_save_all = file_menu[7].widget;
   file_menu_close = file_menu[9].widget;
   file_menu_close_all = file_menu[10].widget;
   file_menu_print = file_menu[12].widget;
   file_menu_print_preview = file_menu[13].widget;

   edit_menu_undo = edit_menu[0].widget;   
   edit_menu_redo = edit_menu[1].widget;   

   search_menu_match = search_menu[5].widget;

   build_menu_compile = build_menu[0].widget;
   build_menu_kill_compile = build_menu[1].widget;
   build_menu_debug = build_menu[2].widget;
   build_menu_kill_debug = build_menu[3].widget;
   build_menu_execute = build_menu[4].widget;
   build_menu_kill_exec = build_menu[5].widget;

   view_file = view_menu[0].widget;
   view_edit = view_menu[1].widget;
   view_build = view_menu[2].widget;
   view_highlight = view_menu[3].widget;
   view_find = view_menu[4].widget;
   view_line = view_menu[5].widget;
#ifdef WITH_PYTHON
   view_custom = view_menu[6].widget;
   view_command = view_menu[7].widget;
   view_status = view_menu[8].widget;
#else
   view_status = view_menu[6].widget;
#endif

   windows_menu_prev = window_menu[2].widget;
   windows_menu_next = window_menu[3].widget;
   windows_menu_moveprev = window_menu[5].widget;
   windows_menu_movenext = window_menu[6].widget;

   nmenu_items = sizeof(popup_items) / sizeof(popup_items[0]);
   item_factory = gtk_item_factory_new(GTK_TYPE_MENU, "<edit popup>", 0);
   gtk_item_factory_create_items(item_factory, nmenu_items, popup_items, 0);

   edit_popup_menu = gtk_item_factory_get_widget(item_factory, "<edit popup>");
   gtk_widget_show(edit_popup_menu);
}

void setup_recent_files_list(gint max_files)
{
   GList *temp = NULL;
   GList *current = NULL;
   temp = build_glist_from_file("files.hist", max_files);
   build_recent_files_menu(temp);
   
   current = g_list_first(temp);
   while(current)
   {
      g_free(current->data);
      current = current->next;
   }
   g_list_free(temp);
}

void build_recent_files_menu(GList *file_strings)
{
   GList *current = NULL;
   gchar *temp = NULL;
   GtkWidget *menuitem;
   
   kill_old_recent_menu();
   
   current = g_list_first(file_strings);
   while(current)
   {
      temp = (gchar *)current->data;
      menuitem = gtk_menu_item_new_with_label(temp);
      recent_files = g_list_append(recent_files, (gpointer)menuitem);
      gtk_signal_connect(GTK_OBJECT(menuitem), "activate", GTK_SIGNAL_FUNC(recent_files_callback), 0);  
      gtk_menu_append(GTK_MENU(recentmenu), menuitem);
      gtk_widget_show(menuitem);
      current = current->next;
   }
}

void recent_files_callback(GtkWidget *widget, gpointer data)
{
   GtkWidget *accel;
   gchar *string;
   g_return_if_fail(GTK_IS_BIN(widget));
   
   accel = GTK_BIN(widget)->child;
   gtk_label_get(GTK_LABEL(accel), &string);

   if(check_if_file_exists(string))
   {
      open_file_real(string);
   }
   else
   {
      if(check_if_file_can_exist(string))
      {
         remove(string);
         file_dne_error(string, GTK_SIGNAL_FUNC(open_file_error_cb));
      }
      else
      {
         read_error(string);
      }
   }
}

void add_file_to_recent_list(gchar *filename)
{
   add_string_to_file("files.hist", filename);
   setup_recent_files_list(general_preferences.history);
}

void kill_old_recent_menu(void)
{
   GList *temp = NULL;
   GtkWidget *current;
   
   temp = g_list_first(recent_files);
   while(temp)
   {
      current = (GtkWidget *)temp->data;
      if(GTK_IS_WIDGET(current))
         gtk_widget_destroy(current);
      temp = temp->next;
   }
   g_list_free(recent_files);
   recent_files = NULL;
}
