/*  Glimmer - macro-language.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _MACRO_LANGUAGE_H_
#define _MACRO_LANGUAGE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "bindings.h"

void initialize_macro_language(int argc, char *argv[]);

#ifdef WITH_PYTHON
void execute_macro_string(char* string);
void autoexec_script(void);
void build_scripts_menu(void);
void script_run_cb(GtkWidget *widget, gchar *filename);
void regenerate_scripts_cb(GtkWidget *widget, gpointer data);
void adjust_popup_menu(void);
void adjust_build_menu(void);
void remove_pyref(GtkWidget *widget, PyObject *object);
void call_python_function_cb(GtkWidget *widget, gpointer *function);
void init_scripting(void);
#endif

extern GList *dynamic_build;
extern GList *edit_entries;

#ifdef __cplusplus
}
#endif

#endif /* _MACRO_LANGUAGE_H_ */
