#include "gnome-settings.h"

static void gnome_settings_class_init(GnomeSettingsClass *_class);
static void gnome_settings_init(GnomeSettings *settings);
GtkWidget* gnome_settings_new(void);
static void gnome_settings_destroy(GtkObject *object);
static void select_event(GtkCTree *tree, gint row, gint col, GdkEvent *event, GnomeSettings *settings);
static void unselect_event(GtkCTree *tree, gint row, gint col, GdkEvent *event, GnomeSettings *settings);

static GtkHPanedClass *parent_class = NULL;

GtkType gnome_settings_get_type(void)
{
   static GtkType settings_type=0;
   if(!settings_type)
   {
      static const GtkTypeInfo settings_info = 
      {	
         "GnomeSettings",
         sizeof(GnomeSettings),
         sizeof(GnomeSettingsClass),
         (GtkClassInitFunc) gnome_settings_class_init,
         (GtkObjectInitFunc) gnome_settings_init,
         NULL,
         NULL,
         (GtkClassInitFunc)NULL,
      };
      settings_type = gtk_type_unique(gtk_hpaned_get_type(), &settings_info);
   }
   return(settings_type);
}

static void gnome_settings_class_init(GnomeSettingsClass *_class)
{
   GtkObjectClass *object_class;
   object_class = (GtkObjectClass*)_class;
   parent_class = gtk_type_class(gtk_hpaned_get_type());
   object_class->destroy = gnome_settings_destroy;
}

static void gnome_settings_init(GnomeSettings *settings)
{
   settings->current = NULL;
   settings->children = NULL;
   settings->selected_row = -1;
}

GtkWidget* gnome_settings_new()
{
   GnomeSettings *settings;
   GtkWidget *scrolled_window;

   settings = gtk_type_new(GNOME_TYPE_SETTINGS);
   scrolled_window = gtk_scrolled_window_new(0, 0);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_widget_set_usize(scrolled_window, 180, 380);
   gtk_widget_show(scrolled_window);

   settings->ctree = gtk_ctree_new(1, 0);
   gtk_clist_set_selection_mode(GTK_CLIST(settings->ctree), GTK_SELECTION_SINGLE);
   gtk_clist_set_shadow_type(GTK_CLIST(settings->ctree), GTK_SHADOW_ETCHED_IN);
   gtk_clist_set_column_justification(GTK_CLIST(settings->ctree), 0, GTK_JUSTIFY_LEFT);
   gtk_clist_set_row_height(GTK_CLIST(settings->ctree), 24);
   gtk_container_add(GTK_CONTAINER(scrolled_window), settings->ctree);
   gtk_signal_connect(GTK_OBJECT(settings->ctree), "select_row", GTK_SIGNAL_FUNC(select_event), settings);
   gtk_signal_connect(GTK_OBJECT(settings->ctree), "unselect_row", GTK_SIGNAL_FUNC(unselect_event), settings);
   gtk_paned_add1(GTK_PANED(settings), scrolled_window);
   gtk_widget_show(settings->ctree);

   scrolled_window = gtk_scrolled_window_new(0, 0);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_widget_set_usize(scrolled_window, 350, 380);
   gtk_widget_show(scrolled_window);

   settings->hbox = gtk_hbox_new(FALSE, 0);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), settings->hbox);
   gtk_widget_show(settings->hbox);
   gtk_paned_add2(GTK_PANED(settings), scrolled_window);
   return(GTK_WIDGET(settings));
}

static void gnome_settings_destroy(GtkObject *object)
{
   GtkWidget *settings;
   g_return_if_fail(object != NULL);
   g_return_if_fail(GNOME_IS_SETTINGS(object));
   settings = GTK_WIDGET(object);
   g_list_free(GNOME_SETTINGS(settings)->children);
   gtk_widget_destroy(settings);
}

static void select_event(GtkCTree *tree, gint row, gint col, GdkEvent *event, GnomeSettings *settings)
{
   GtkCTreeNode *node;
   gpointer data;
   settings->selected_row = row;   
   node = gtk_ctree_node_nth(tree, row);
   data = gtk_ctree_node_get_row_data(GTK_CTREE(settings->ctree), node);
   if(settings->current && data)
      gtk_widget_hide(settings->current);
   if(data)
   {
      gtk_widget_show(GTK_WIDGET(data));
      (void *)settings->current = data;
   }
}

static void unselect_event(GtkCTree *tree, gint row, gint col, GdkEvent *event, GnomeSettings *settings)
{
   settings->selected_row = -1;   
   if(settings->current) gtk_widget_hide(settings->current);
   settings->current = NULL;
}

GtkCTreeNode *gnome_settings_add_page(GnomeSettings *settings, GtkCTreeNode *parent, gchar *title, GnomePixmap *pixmap, GtkWidget *new_child)
{
   GtkCTreeNode *node;
   if(pixmap)
      node = gtk_ctree_insert_node(GTK_CTREE(settings->ctree), parent, NULL, &title, 8, pixmap->pixmap, pixmap->mask, pixmap->pixmap, pixmap->mask, FALSE, TRUE);
   else
      node = gtk_ctree_insert_node(GTK_CTREE(settings->ctree), parent, NULL, &title, 8, NULL, NULL, NULL, NULL, FALSE, TRUE);
   if(new_child)
   {
      gtk_ctree_node_set_row_data(GTK_CTREE(settings->ctree), node, (gpointer)new_child);
      gtk_widget_hide(new_child);
      gtk_box_pack_start(GTK_BOX(settings->hbox), new_child, TRUE, TRUE, 0);
      settings->children = g_list_append(settings->children, (gpointer)new_child);
   }
   else gtk_ctree_node_set_selectable(GTK_CTREE(settings->ctree), node, FALSE);
   return(node);
}

