/* Gnome Developers Studio
*  
*  File Widget (MDI entry, text widget etc.)
*  Copyright 2000 by Chris Phelps
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "../declarations.h"

#ifndef GDS_FILE_H__
#define GDS_FILE_H__
#ifdef __cplusplus
extern "C" {
#endif

#include "gdseditor.h"

#define GDS_TYPE_FILE (gds_file_get_type())
#define GDS_FILE(obj) (GTK_CHECK_CAST((obj), GDS_TYPE_FILE, GdsFile))
#define GDS_FILE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GDS_TYPE_FILE, GdsFileClass))
#define GDS_IS_FILE(obj) (GTK_CHECK_TYPE((obj), GDS_TYPE_FILE))
#define GDS_IS_FILE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDS_TYPE_FILE))

typedef struct _properties
{
   gboolean over_ride;
   gboolean bracketmatch;
   gboolean syntax;
   gboolean auto_indent;
   gboolean use_spaces;
   guint spaces;
   gchar *dir;
   gchar *compiler;
   gchar *debugger;
   gchar *execution;
}GdsFileProperties;

typedef struct _highlight_table
{
   gchar *filename;
   GList *extensions;
   GdsEditorHighlightTable *syntax;
   GdsEditorHighlightTable *pattern;
   GdsEditorHighlightTable *embedded;
   GdsFileProperties props;

   /* Menu and toolbar items that need to be killed */
   GList *menu_entries;
   GList *toolbar_entries;

   /* Callbacks for certain table events */
   gpointer table_add_callback;
   gpointer table_remove_callback;
   gpointer table_destroy_callback;

   /* Callbacks for certain file events */
   gpointer file_focus_callback;
   gpointer file_unfocus_callback;
   gpointer enter_pressed_callback;
   gpointer tab_pressed_callback;

   /* Callbacks for certain build events */
   gpointer compile_hook;
   gpointer stop_compile_hook;
   gpointer debug_hook;
   gpointer stop_debug_hook;
   gpointer execute_hook;
   gpointer stop_execute_hook;

   /*  Linked list of other signal hooks */
   GList *hooks;

   /* How many files are we attached to? */
   guint refcount;
}GdsFileHighlightTable;

typedef struct _GdsFile GdsFile;
typedef struct _GdsFileClass GdsFileClass;

struct _GdsFile
{
   GtkHBox box;
   GtkWidget *menu_item;
   GtkWidget *tear_away;
   GtkWidget *text;
   GtkWidget *vscroller;
   GtkWidget *paned;
   GtkWidget *file_data;
   GtkWidget *script_box;
   GtkWidget *props_dialog; // NULL unless there is a props dialog
   gchar *filename;
   gboolean changed_set;
   gboolean default_lang;
   time_t modtime;
   GdsFileHighlightTable *tables;
   gint compile_pid;
   gint debug_pid;
   gint exec_pid;
   GdsFileProperties props;
};

struct _GdsFileClass
{
   GtkHBoxClass parent_class;
};

GtkType gds_file_get_type(void);

GtkWidget *gds_file_new(gchar *filename, gboolean full);
void gds_file_set_filename(GdsFile *gds_file, gchar *filename);
void gds_file_set_title(GdsFile *gds_file, gchar *title, gboolean full);
gboolean find_bracket_match(GtkWidget *widget, gint *search);
void gds_file_set_global_props(gint undo, gint spaces, gboolean indent, gboolean bracket, gboolean tab_stops);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
