#include "declarations.h"
#include "signals.h"

/* Linked lists of signals of different types */
GList *open_signals = NULL;
GList *revert_signals = NULL;
GList *save_signals = NULL;
GList *save_as_signals = NULL;
GList *close_signals = NULL;
GList *change_signals = NULL;
GList *move_left_signals= NULL;
GList *move_right_signals = NULL;

gboolean table_emit_scripting_signal(gchar *signal, GdsFileHighlightTable *table)
{
   gint result = -1;

   if(!signal || !table) return(FALSE);
   if(!strcmp(signal, "table-add") && table->table_add_callback)
      result = call_scripting_function(table->table_add_callback);
   else if(!strcmp(signal, "table-remove") && table->table_remove_callback)
      result = call_scripting_function(table->table_remove_callback);
   else if(!strcmp(signal, "table-destroy") && table->table_destroy_callback)
      result = call_scripting_function(table->table_destroy_callback);
   if(result == 0) g_print("Scripting error reported (%s)\n", signal);
   return(result == 1 ? TRUE : FALSE);
}

gboolean file_emit_scripting_signal(gchar *signal, GdsFile *file)
{
   gint result = -1;

   if(!signal || !file || !file->tables) return(FALSE);
   if(!strcmp(signal, "focus-out") && file->tables->file_unfocus_callback)
      result = call_scripting_function(file->tables->file_unfocus_callback);
   else if(!strcmp(signal, "focus-in") && file->tables->file_focus_callback)
      result = call_scripting_function(file->tables->file_focus_callback);
   else if(!strcmp(signal, "enter-pressed") && file->tables->enter_pressed_callback)
      result = call_scripting_function(file->tables->enter_pressed_callback);
   else if(!strcmp(signal, "tab-pressed") && file->tables->tab_pressed_callback)
      result = call_scripting_function(file->tables->tab_pressed_callback);
   // Build system hooks
   else if(!strcmp(signal, "compile") && file->tables->compile_hook)
      result = call_scripting_function(file->tables->compile_hook);
   else if(!strcmp(signal, "stop-compile") && file->tables->stop_compile_hook)
      result = call_scripting_function(file->tables->stop_compile_hook);
   else if(!strcmp(signal, "debug") && file->tables->debug_hook)
      result = call_scripting_function(file->tables->debug_hook);
   else if(!strcmp(signal, "stop-debug") && file->tables->stop_debug_hook)
      result = call_scripting_function(file->tables->stop_debug_hook);
   else if(!strcmp(signal, "execute") && file->tables->execute_hook)
      result = call_scripting_function(file->tables->execute_hook);
   else if(!strcmp(signal, "stop-execute") && file->tables->stop_execute_hook)
      result = call_scripting_function(file->tables->stop_execute_hook);
   if(result == FALSE) g_print("Scripting error reported (%s)\n", signal);
   return(result == 1 ? TRUE : FALSE);
}

gboolean app_emit_scripting_signal(gchar *signal)
{
   gboolean result = FALSE;
   GList *list = NULL;
   gint called = 0;

   if(!signal) return(FALSE);
   if(!strcmp(signal, "open-file"))
      list = g_list_first(open_signals);
   else if(!strcmp(signal, "revert-file"))
      list = g_list_first(revert_signals);
   else if(!strcmp(signal, "save-file"))
      list = g_list_first(save_signals);
   else if(!strcmp(signal, "save-as-file"))
      list = g_list_first(save_as_signals);
   else if(!strcmp(signal, "close-file"))
      list = g_list_first(close_signals);
   else if(!strcmp(signal, "change-file"))
      list = g_list_first(change_signals);
   else if(!strcmp(signal, "move-left"))
      list = g_list_first(move_left_signals);
   else if(!strcmp(signal, "move-right"))
      list = g_list_first(move_right_signals);
   for(; list; list = list->next)
   {
      result = call_scripting_function(list->data);
      if(!result) g_print("Scripting error reported (%s)\n", signal);
      if(result) called++;
   }
   return(called ? TRUE : FALSE);
}

gboolean call_scripting_function(gpointer function)
{
   PyObject* result;
   if(!PyCallable_Check((PyObject*)function))
      return(FALSE);
   result = PyObject_CallObject((PyObject*)function, NULL);
   Py_XDECREF(result);
   return(TRUE);
}

gboolean check_scripting_function(gpointer function)
{
   if(!PyCallable_Check((PyObject*)function))
   {
      g_print("Error:\a Scripting function pointer exists, but is not callable!\n");
      return(FALSE);
   }
   return(TRUE);
}

/*
This is called when killing highlight tables.
It goes through the hook lists and decref's all entries
then removes them from the hook lists.
*/
void remove_signal_hooks(GdsFileHighlightTable *table)
{
   GList *hooks = NULL;
   GList *list = NULL;
   gpointer data;
   if(!table || !table->hooks) return;
   for(hooks = g_list_first(table->hooks); hooks; hooks = hooks->next)
   {
      if(!hooks->data) continue;
      data = hooks->data;
      Py_XDECREF((PyObject *)hooks->data);
      list = g_list_find(open_signals, data);
      if(list) open_signals = g_list_remove(open_signals, data);
      list = g_list_find(revert_signals, data);
      if(list) revert_signals = g_list_remove(revert_signals, data);
      list = g_list_find(save_signals, data);
      if(list) save_signals = g_list_remove(save_signals, data);
      list = g_list_find(save_as_signals, data);
      if(list) save_as_signals = g_list_remove(save_as_signals, data);
      list = g_list_find(close_signals, data);
      if(list) close_signals = g_list_remove(close_signals, data);
      list = g_list_find(change_signals, data);
      if(list) change_signals = g_list_remove(change_signals, data);
      list = g_list_find(move_left_signals, data);
      if(list) move_left_signals = g_list_remove(move_left_signals, data);
      list = g_list_find(move_right_signals, data);
      if(list) move_right_signals = g_list_remove(move_right_signals, data);
   }
   g_list_free(table->hooks);
}
