#include <gdk/gdkprivate.h>
#include <gtk/gtkprivate.h>
#include "declarations.h"
#include "widgets/gnomedirentry.h"
#include "widgets/gnome-settings.h"

#include "xpm/glimmer.xpm"
#include "xpm/folder_closed.xpm"
#include "xpm/window.xpm"

static void save_settings(GtkWidget *widget, gpointer data);
static void apply_settings(GtkWidget *widget, gpointer data);
static void get_defaults(GtkWidget *widget, gpointer data);
static void get_theme_defaults(GtkWidget *widget, gpointer data);
static void get_backups(GtkWidget *widget, gpointer data);
static void get_preferences(Preferences *source);
static void put_preferences(Preferences *source);
static void copy_preferences(Preferences *source, Preferences *dest);
static void set_font_changed(GtkWidget *gfp, gchar *font_name, gpointer data);
static void set_color_changed(GtkWidget *cp, guint r, guint g, guint b, guint a, gpointer data);
static void gtk_theme_switch_cb(GtkWidget *widget, gint *value);
static void apply_settings_changes(void);
void apply_window_settings_cb(GtkWidget *widget, gpointer data);
void get_window_settings_cb(GtkWidget *widget, gpointer data);
static void select_ctree_row(GtkCTree *tree, gint row, gint col, GdkEvent *event, gpointer data);

Preferences general_preferences;
Preferences backup_preferences;
Preferences default_preferences;

// The main window
static GtkWidget *settings_window;

// General Settings
static gint settings_selected_row = 2;

static GtkWidget *default_dir_entry = NULL;
static GtkWidget *projects_dir_entry = NULL;
static GtkWidget *save_toolbars = NULL;
static GtkWidget *save_session = NULL;
static GtkWidget *open_session = NULL;
static GtkWidget *auto_save = NULL;
static GtkWidget *hist_spin = NULL;
static GtkWidget *undo_spin = NULL;
static gboolean isave_toolbars;
static gboolean isave_session;
static gboolean iopen_session;
static gboolean iauto_save;

//Build settings
static GtkWidget *terminal_entry = NULL;
static GtkWidget *make_entry = NULL;

// User settings
static GtkWidget *name_of_user = NULL;
static GtkWidget *email_of_user = NULL;

// NoteBook Settings
static GtkWidget *notebook_pos_top = NULL;
static GtkWidget *notebook_pos_right = NULL;
static GtkWidget *notebook_pos_bottom = NULL;
static GtkWidget *notebook_pos_left = NULL;
static GtkWidget *notebook_pos_none = NULL;

// Colors & Fonts
static GtkWidget *gtk_theme = NULL;
static gboolean gtk_theme_changed = FALSE;
static gboolean iuse_gtk_theme;
static GtkWidget *color_frame;
static GtkWidget *font = NULL;
static gboolean font_changed = FALSE;
static GtkWidget *italic = NULL;
static gboolean italic_changed = FALSE;
static GtkWidget *bold = NULL;
static gboolean bold_changed = FALSE;
static GtkWidget *boldi = NULL;
static gboolean boldi_changed = FALSE;
static GtkWidget *fg = NULL;
static gboolean fg_changed = FALSE;
static GtkWidget *bg = NULL;
static gboolean bg_changed = FALSE;
static GtkWidget *bm_bg = NULL;
static gboolean bm_bg_changed = FALSE;
static GtkWidget *s_bg = NULL;
static gboolean s_bg_changed = FALSE;
static GtkWidget *bg_pixmap = NULL;
static gboolean bg_pixmap_changed = FALSE;

// File Settings
static GtkWidget *fullfilenamestitle = NULL;
static GtkWidget *fullfilenames = NULL;
static GtkWidget *closeall = NULL;
static GtkWidget *untitled = NULL;
static GtkWidget *drawnumbers = NULL;
static GtkWidget *drawpixmaps = NULL;
static GtkWidget *cursorblink = NULL;
static GtkWidget *fullselection = NULL;
static GtkWidget *bracketmatch = NULL;
static GtkWidget *select_line = NULL;
static GtkWidget *syntax = NULL;
static GtkWidget *auto_indent = NULL;
static GtkWidget *tab_stops = NULL;
static GtkWidget *use_spaces = NULL;
static GtkWidget *spaces_spin = NULL;
static gboolean ifullfilenamestitle;
static gboolean ifullfilenames;
static gboolean icloseall;
static gboolean iuntitled;
static gboolean idrawnumbers;
static gboolean idrawpixmaps;
static gboolean icursorblink;
static gboolean ifullselection;
static gboolean ibracketmatch;
static gboolean iselect_line;
static gboolean isyntax;
static gboolean iauto_indent;
static gboolean itab_stops;
static gboolean iuse_spaces;

// Window Settings
static GtkWidget *geometry0;
static GtkWidget *geometry1;
static GtkWidget *geometry2;
static GtkWidget *win_x_spin;
static GtkWidget *win_y_spin;
static GtkWidget *win_w_spin;
static GtkWidget *win_h_spin;

void edit_preferences(GtkWidget *widget, gpointer data)
{
   GtkWidget *main_box;
   GtkWidget *filesettings_box;

   GtkWidget *dir_frame;
   GtkWidget *dir_box;
   GtkWidget *history_frame;
   GtkWidget *history_box;
   GtkWidget *build_frame;
   GtkWidget *build_box;
   GtkWidget *user_box;
   GtkWidget *user_frame;
   GtkWidget *notebooktabs_frame;
   GtkWidget *notebooktabs_box;
   GtkWidget *font_box;
   GtkWidget *font_frame;
   GtkWidget *theme_frame;
   GtkWidget *color_box;
   GtkWidget *theme_colors_button;
   GtkWidget *generalui_frame;
   GtkWidget *generalui_box;
   GtkWidget *highlight_frame;
   GtkWidget *highlight_box;
   GtkWidget *tabs_frame;
   GtkWidget *tabs_box;
   GtkWidget *window_frame;
   GtkWidget *window_box;
  
   GtkWidget *util_box;
   GtkWidget *util_label;

   GtkWidget *buttons_box;
   GtkWidget *ok_button;
   GtkWidget *apply_button;
   GtkWidget *defaults_button;
   GtkWidget *undo_button;
   GtkWidget *cancel_button;
   GtkWidget *hsep;
   GtkWidget *apply_window_settings;
   GtkWidget *get_window_settings;
   GtkWidget *settings;
   GtkCTreeNode *topnode;
   GtkCTreeNode *pnode;
   GtkCTreeNode *node;
   GnomePixmap *pixmap;

   if(settings_window && GTK_IS_WINDOW(settings_window))
   {
      gdk_window_raise(settings_window->window);
      gtk_widget_grab_focus(settings_window);
      return;
   }

   copy_preferences(&general_preferences, &backup_preferences); //save the current preferences

   font_changed = FALSE;
   italic_changed = FALSE;
   bold_changed = FALSE;
   fg_changed = FALSE;
   bg_changed = FALSE;
   bm_bg_changed = FALSE;
   s_bg_changed = FALSE;
   bg_pixmap_changed = FALSE;

   isave_toolbars = general_preferences.save_toolbars;
   isave_session = general_preferences.save_session;
   iopen_session = general_preferences.open_session;
   iauto_save = general_preferences.auto_save;
   iuse_gtk_theme = general_preferences.use_gtk_theme;
   ifullfilenamestitle = general_preferences.full_filenames_title;
   ifullfilenames = general_preferences.full_filenames;
   icloseall = general_preferences.close_all;
   iuntitled = general_preferences.untitled;
   idrawnumbers = general_preferences.draw_numbers;
   idrawpixmaps = general_preferences.draw_pixmaps;
   icursorblink = general_preferences.cursor_blink;
   ifullselection = general_preferences.full_selection;
   ibracketmatch = general_preferences.bracketmatch;
   iselect_line = general_preferences.select_line;
   isyntax = general_preferences.syntax;
   iauto_indent = general_preferences.auto_indent;
   iuse_spaces = general_preferences.use_spaces;

   settings_window = gtk_window_new(GTK_WINDOW_DIALOG);
   gtk_container_set_border_width(GTK_CONTAINER(settings_window), 5);   
   gtk_window_set_title(GTK_WINDOW(settings_window), _("Edit " PACKAGE " Preferences"));

   main_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(settings_window), main_box);
   gtk_widget_show(main_box);

   settings = gnome_settings_new();
   gtk_box_pack_start(GTK_BOX(main_box), settings, TRUE, TRUE, 0);
   gtk_widget_show(settings);

   pixmap = (GnomePixmap *)gnome_pixmap_new_from_xpm_d_at_size(glimmer_xpm, 18, 18);
   topnode = gnome_settings_add_page(GNOME_SETTINGS(settings), NULL, PACKAGE, pixmap, NULL);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_BOOK_OPEN, 18, 18);
   pnode = gnome_settings_add_page(GNOME_SETTINGS(settings), topnode, "General", pixmap, NULL);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_widget_show(util_box);
   dir_frame = gtk_frame_new(_("Directory Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), dir_frame, TRUE, TRUE, 0);
   gtk_widget_show(dir_frame);
   pixmap = (GnomePixmap *)gnome_pixmap_new_from_xpm_d_at_size(folder_closed_xpm, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), pnode, _("Directory Settings"), pixmap, util_box);

   dir_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(dir_frame), dir_box);   
   gtk_container_set_border_width(GTK_CONTAINER(dir_box), 5);
   gtk_widget_show(dir_box);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(dir_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Default Directory:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);
   default_dir_entry = gnome_direntry_new();
   gtk_box_pack_start(GTK_BOX(util_box), default_dir_entry, TRUE, TRUE, 0);   
   gtk_widget_show(default_dir_entry);   

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(dir_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Projects Directory:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);   
   projects_dir_entry = gnome_direntry_new();
   gtk_box_pack_start(GTK_BOX(util_box), projects_dir_entry, TRUE, TRUE, 0);   
   gtk_widget_show(projects_dir_entry);   

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_widget_show(util_box);
   history_frame = gtk_frame_new(_("History Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), history_frame, TRUE, TRUE, 0);
   gtk_widget_show(history_frame);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_UNDO, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), pnode, _("History Settings"), pixmap, util_box);

   history_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(history_box), 5);
   gtk_container_add(GTK_CONTAINER(history_frame), history_box);   
   gtk_widget_show(history_box);

   save_toolbars = make_button(_("Save toolbar settings on exit?"), history_box, &isave_toolbars);
   save_session = make_button(_("Save session on exit?"), history_box, &isave_session);
   open_session = make_button(_("Open last session on startup?"), history_box, &iopen_session);
   auto_save = make_button(_("Auto-save session when files change?"), history_box, &iauto_save);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(history_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Items to show in history lists:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);

   hist_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, 50, 1, 10, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), hist_spin, TRUE, TRUE, 0);   
   gtk_widget_show(hist_spin);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(history_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Maximum Undo saves:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0); 
   gtk_widget_show(util_label);

   undo_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, 1000, 1, 10, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), undo_spin, TRUE, TRUE, 0);   
   gtk_widget_show(undo_spin);


   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_widget_show(util_box);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_CONVERT, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), pnode, _("Build Settings"), pixmap, util_box);

   build_frame = gtk_frame_new(_("Build Information"));
   gtk_box_pack_start(GTK_BOX(util_box), build_frame, TRUE, TRUE, 0);
   gtk_widget_show(build_frame);

   build_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(build_box), 5);
   gtk_container_add(GTK_CONTAINER(build_frame), build_box);   
   gtk_widget_show(build_box);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(build_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Terminal Command:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);   
   terminal_entry = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(util_box), terminal_entry, TRUE, TRUE, 0);   
   gtk_widget_show(terminal_entry);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(build_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Make Command:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);   
   make_entry = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(util_box), make_entry, TRUE, TRUE, 0);   
   gtk_widget_show(make_entry);

   /* Start of User Settings tab */
   
   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_widget_show(util_box);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_BOOK_BLUE, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), topnode, _("User Settings"), pixmap, util_box);

   user_frame = gtk_frame_new(_("User Information"));
   gtk_box_pack_start(GTK_BOX(util_box), user_frame, TRUE, TRUE, 0);
   gtk_widget_show(user_frame);

   user_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(user_box), 5);
   gtk_container_add(GTK_CONTAINER(user_frame), user_box);   
   gtk_widget_show(user_box);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(user_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Name of user:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);   
   name_of_user = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(util_box), name_of_user, TRUE, TRUE, 0);   
   gtk_widget_show(name_of_user);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(user_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Email of user:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);   
   email_of_user = gtk_entry_new();
   gtk_box_pack_start(GTK_BOX(util_box), email_of_user, TRUE, TRUE, 0);   
   gtk_widget_show(email_of_user);

   /* End of user settings */
   /* Start of notebook settings */

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_widget_show(util_box);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_MULTIPLE, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), topnode, _("MDI Settings"), pixmap, util_box);

   notebooktabs_frame = gtk_frame_new(_("Tab Position"));
   gtk_box_pack_start(GTK_BOX(util_box), notebooktabs_frame, TRUE, TRUE, 0);
   gtk_widget_show(notebooktabs_frame);

   notebooktabs_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(notebooktabs_box), 5);
   gtk_container_add(GTK_CONTAINER(notebooktabs_frame), notebooktabs_box);   
   gtk_widget_show(notebooktabs_box);

   util_box = gtk_vbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(notebooktabs_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);

   notebook_pos_left = gtk_radio_button_new_with_label(NULL, "Left");
   gtk_box_pack_start(GTK_BOX(util_box), notebook_pos_left, FALSE, FALSE, 0);
   gtk_widget_show(notebook_pos_left);
   notebook_pos_right = gtk_radio_button_new_with_label(GTK_RADIO_BUTTON(notebook_pos_left)->group, "Right");
   gtk_box_pack_start(GTK_BOX(util_box), notebook_pos_right, FALSE, FALSE, 0);
   gtk_widget_show(notebook_pos_right);
   notebook_pos_top = gtk_radio_button_new_with_label(GTK_RADIO_BUTTON(notebook_pos_left)->group, "Top");
   gtk_box_pack_start(GTK_BOX(util_box), notebook_pos_top, FALSE, FALSE, 0);
   gtk_widget_show(notebook_pos_top);
   notebook_pos_bottom = gtk_radio_button_new_with_label(GTK_RADIO_BUTTON(notebook_pos_left)->group, "Bottom");
   gtk_box_pack_start(GTK_BOX(util_box), notebook_pos_bottom, FALSE, FALSE, 0);
   gtk_widget_show(notebook_pos_bottom);
   notebook_pos_none = gtk_radio_button_new_with_label(GTK_RADIO_BUTTON(notebook_pos_left)->group, "No Tabs");
   gtk_box_pack_start(GTK_BOX(util_box), notebook_pos_none, FALSE, FALSE, 0);
   gtk_widget_show(notebook_pos_none);

   /* start of colors and fonts stuff */
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_ABOUT, 18, 18);
   pnode = gnome_settings_add_page(GNOME_SETTINGS(settings), topnode, _("Style Settings"), pixmap, NULL);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_widget_show(util_box);
   font_frame = gtk_frame_new(_("Font Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), font_frame, TRUE, TRUE, 0);
   gtk_widget_show(font_frame);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_FONT, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), pnode, _("Fonts"), pixmap, util_box);

   font_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(font_box), 5);
   gtk_container_add(GTK_CONTAINER(font_frame), font_box);   
   gtk_widget_show(font_box);
   
   util_box = gtk_hbox_new(FALSE, 5);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_box_pack_start(GTK_BOX(font_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Default Font:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   font = gnome_font_picker_new();
   gtk_signal_connect(GTK_OBJECT(font), "font_set", GTK_SIGNAL_FUNC(set_font_changed), 0);
   gnome_font_picker_set_mode(GNOME_FONT_PICKER(font), GNOME_FONT_PICKER_MODE_FONT_INFO);
   gnome_font_picker_set_preview_text(GNOME_FONT_PICKER(font), PACKAGE " v" VERSION);
   gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(font), TRUE, 14);
   gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(font), FALSE);
   gnome_font_picker_set_title(GNOME_FONT_PICKER(font), _(PACKAGE " Font Selection..."));
   gtk_box_pack_start(GTK_BOX(util_box), font, TRUE, TRUE, 0);
   gtk_widget_show(font);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_box_pack_start(GTK_BOX(font_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Italic Font:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   italic = gnome_font_picker_new();
   gtk_signal_connect(GTK_OBJECT(italic), "font_set", GTK_SIGNAL_FUNC(set_font_changed), 0);
   gnome_font_picker_set_mode(GNOME_FONT_PICKER(italic), GNOME_FONT_PICKER_MODE_FONT_INFO);
   gnome_font_picker_set_preview_text(GNOME_FONT_PICKER(italic), PACKAGE " v" VERSION);
   gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(italic), TRUE, 14);
   gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(italic), FALSE);
   gnome_font_picker_set_title(GNOME_FONT_PICKER(italic), _(PACKAGE " Font Selection..."));
   gtk_box_pack_start(GTK_BOX(util_box), italic, TRUE, TRUE, 0);
   gtk_widget_show(italic);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_box_pack_start(GTK_BOX(font_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Bold Font:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   bold = gnome_font_picker_new();
   gtk_signal_connect(GTK_OBJECT(bold), "font_set", GTK_SIGNAL_FUNC(set_font_changed), 0);
   gnome_font_picker_set_mode(GNOME_FONT_PICKER(bold), GNOME_FONT_PICKER_MODE_FONT_INFO);
   gnome_font_picker_set_preview_text(GNOME_FONT_PICKER(bold), PACKAGE " v" VERSION);
   gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(bold), TRUE, 14);
   gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(bold), FALSE);
   gnome_font_picker_set_title(GNOME_FONT_PICKER(bold), _(PACKAGE " Font Selection..."));
   gtk_box_pack_start(GTK_BOX(util_box), bold, TRUE, TRUE, 0);
   gtk_widget_show(bold);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_box_pack_start(GTK_BOX(font_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Bold-Italic Font:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   boldi = gnome_font_picker_new();
   gtk_signal_connect(GTK_OBJECT(boldi), "font_set", GTK_SIGNAL_FUNC(set_font_changed), 0);
   gnome_font_picker_set_mode(GNOME_FONT_PICKER(boldi), GNOME_FONT_PICKER_MODE_FONT_INFO);
   gnome_font_picker_set_preview_text(GNOME_FONT_PICKER(boldi), PACKAGE " v" VERSION);
   gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(boldi), TRUE, 14);
   gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(boldi), FALSE);
   gnome_font_picker_set_title(GNOME_FONT_PICKER(boldi), _(PACKAGE " Font Selection..."));
   gtk_box_pack_start(GTK_BOX(util_box), boldi, TRUE, TRUE, 0);
   gtk_widget_show(boldi);
   
   /* Theme settings */
   util_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_widget_show(util_box);
   theme_frame = gtk_frame_new(_("Theme Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), theme_frame, TRUE, TRUE, 0);
   gtk_widget_show(theme_frame);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_ATTACH, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), pnode, _("Theme Settings"), pixmap, util_box);

   util_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_container_add(GTK_CONTAINER(theme_frame), util_box);
   gtk_widget_show(util_box);
   gtk_theme = gtk_check_button_new_with_label(_("Gtk Theme over-rides local settings ?"));
   gtk_box_pack_start(GTK_BOX(util_box), gtk_theme, FALSE, TRUE, 0);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(gtk_theme), iuse_gtk_theme);
   gtk_signal_connect(GTK_OBJECT(gtk_theme), "clicked", GTK_SIGNAL_FUNC(gtk_theme_switch_cb), &iuse_gtk_theme);
   gtk_widget_show(gtk_theme);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);   
   gtk_widget_show(util_box);
   color_frame = gtk_frame_new(_("Color Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), color_frame, TRUE, TRUE, 0);
   gtk_widget_show(color_frame);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_COLORSELECTOR, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), pnode, _("Standard Colors"), pixmap, util_box);

   if(!iuse_gtk_theme)
      gtk_widget_set_sensitive(color_frame, TRUE);
   else
      gtk_widget_set_sensitive(color_frame, FALSE);

   color_box = gtk_vbox_new(FALSE, 5);
   gtk_container_set_border_width(GTK_CONTAINER(color_box), 10);
   gtk_container_add(GTK_CONTAINER(color_frame), color_box);   
   gtk_widget_show(color_box);

   util_box  = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(color_box), util_box, FALSE, TRUE, 0);         
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Normal Text Color:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   fg = gnome_color_picker_new();
   gtk_signal_connect(GTK_OBJECT(fg), "color_set", GTK_SIGNAL_FUNC(set_color_changed), 0);
   gnome_color_picker_set_dither(GNOME_COLOR_PICKER(fg), FALSE);   
   gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(fg), FALSE);   
   gtk_box_pack_end(GTK_BOX(util_box), fg, FALSE, FALSE, 0);
   gtk_widget_show(fg);

   util_box  = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(color_box), util_box, FALSE, TRUE, 0);         
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Normal Background Color:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   bg = gnome_color_picker_new();
   gtk_signal_connect(GTK_OBJECT(bg), "color_set", GTK_SIGNAL_FUNC(set_color_changed), 0);
   gnome_color_picker_set_dither(GNOME_COLOR_PICKER(bg), FALSE);   
   gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(bg), FALSE);   
   gtk_box_pack_end(GTK_BOX(util_box), bg, FALSE, FALSE, 0);
   gtk_widget_show(bg);

   util_box  = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(color_box), util_box, FALSE, TRUE, 0);         
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Selection Background Color:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   s_bg = gnome_color_picker_new();
   gtk_signal_connect(GTK_OBJECT(s_bg), "color_set", GTK_SIGNAL_FUNC(set_color_changed), 0);
   gnome_color_picker_set_dither(GNOME_COLOR_PICKER(s_bg), FALSE);   
   gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(s_bg), FALSE);   
   gtk_box_pack_end(GTK_BOX(util_box), s_bg, FALSE, FALSE, 0);
   gtk_widget_show(s_bg);

   util_box  = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(color_box), util_box, FALSE, TRUE, 0);         
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Bracket Background Color:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);         
   gtk_widget_show(util_label);
   bm_bg = gnome_color_picker_new();
   gtk_signal_connect(GTK_OBJECT(bm_bg), "color_set", GTK_SIGNAL_FUNC(set_color_changed), 0);
   gnome_color_picker_set_dither(GNOME_COLOR_PICKER(bm_bg), FALSE);   
   gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(bm_bg), FALSE);   
   gtk_box_pack_end(GTK_BOX(util_box), bm_bg, FALSE, FALSE, 0);
   gtk_widget_show(bm_bg);

   bg_pixmap = gnome_pixmap_entry_new(PACKAGE"-Background Image", "Change Image", 1);
   gtk_box_pack_start(GTK_BOX(color_box), bg_pixmap, FALSE, FALSE, 10);
   gnome_pixmap_entry_set_preview_size(GNOME_PIXMAP_ENTRY(bg_pixmap), 100, 100);
   gtk_widget_show(bg_pixmap);

   theme_colors_button = gtk_button_new_with_label("Default Theme Colors");
   gtk_box_pack_end(GTK_BOX(color_box), theme_colors_button, FALSE, FALSE, 5);
   gtk_signal_connect(GTK_OBJECT(theme_colors_button), "clicked", GTK_SIGNAL_FUNC(get_theme_defaults), 0);
   gtk_widget_show(theme_colors_button);

   /* File Settings */

   filesettings_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(filesettings_box), 5);
   gtk_widget_show(filesettings_box);
   generalui_frame = gtk_frame_new(_("General/UI"));
   gtk_box_pack_start(GTK_BOX(filesettings_box), generalui_frame, TRUE, TRUE, 0);
   gtk_widget_show(generalui_frame);
   pixmap = (GnomePixmap *)gnome_stock_pixmap_widget_at_size(GTK_WIDGET(settings_window), GNOME_STOCK_PIXMAP_NEW, 18, 18);
   node = gnome_settings_add_page(GNOME_SETTINGS(settings), topnode, _("File Settings"), pixmap, filesettings_box);

   generalui_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(generalui_box), 5);
   gtk_container_add(GTK_CONTAINER(generalui_frame), generalui_box);   
   gtk_widget_show(generalui_box);
   util_box  = gtk_vbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(generalui_box), util_box, TRUE, TRUE, 0);
   gtk_widget_show(util_box);
   fullfilenamestitle = make_button(_("Full filenames in main window title ?"), util_box, &ifullfilenamestitle);
   fullfilenames = make_button(_("Full filenames in notebook tabs ?"), util_box, &ifullfilenames);
   closeall = make_button(_("Close all on open session ?"), util_box, &icloseall);
   untitled = make_button(_("Persistant 'Untitled' document ?"), util_box, &iuntitled);
   drawnumbers = make_button(_("Show line numbers ?"), util_box, &idrawnumbers);
   drawpixmaps = make_button(_("Show line pixmaps ?"), util_box, &idrawpixmaps);
   cursorblink = make_button(_("Show blinking cursor ?"), util_box, &icursorblink);
   fullselection = make_button(_("Selection shows full width ?"), util_box, &ifullselection);

   highlight_frame = gtk_frame_new(_("Highlighting"));
   gtk_box_pack_start(GTK_BOX(filesettings_box), highlight_frame, FALSE, FALSE, 0);
   gtk_widget_show(highlight_frame);
   highlight_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(highlight_box), 5);
   gtk_container_add(GTK_CONTAINER(highlight_frame), highlight_box);   
   gtk_widget_show(highlight_box);
   util_box  = gtk_vbox_new(TRUE, 5);
   gtk_box_pack_start(GTK_BOX(highlight_box), util_box, FALSE, TRUE, 0);         
   gtk_widget_show(util_box);
   bracketmatch = make_button(_("Enable bracket highlighting ?"), util_box, &ibracketmatch);
   select_line = make_button(_("Auto line select ?"), util_box, &iselect_line);
   syntax = make_button(_("Enable syntax highlighting ?"), util_box, &isyntax);

   tabs_frame = gtk_frame_new(_("Indentation"));
   gtk_box_pack_start(GTK_BOX(filesettings_box), tabs_frame, TRUE, TRUE, 0);
   gtk_widget_show(tabs_frame);
   tabs_box = gtk_vbox_new(FALSE, 5);
   gtk_container_set_border_width(GTK_CONTAINER(tabs_box), 5);
   gtk_container_add(GTK_CONTAINER(tabs_frame), tabs_box);   
   gtk_widget_show(tabs_box);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(tabs_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   auto_indent = make_button(_("Auto Indent ?"), util_box, &iauto_indent);

   util_box = gtk_vbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(tabs_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   tab_stops = make_button(_("Use tab-stop spacing ?"), util_box, &itab_stops);
   use_spaces = make_button(_("Insert spaces instead of tabs ?"), util_box, &iuse_spaces);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(tabs_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   util_label = gtk_label_new(_("Tab-stop width:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);

   spaces_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 1, 8, 1, 2, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), spaces_spin, TRUE, TRUE, 0);   
   gtk_widget_show(spaces_spin);

   util_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(util_box), 5);
   gtk_widget_show(util_box);
   pixmap = (GnomePixmap *)gnome_pixmap_new_from_xpm_d_at_size(window_xpm, 18, 18);
   pnode = gnome_settings_add_page(GNOME_SETTINGS(settings), topnode, _("Window Geometry"), pixmap, util_box);

   window_frame = gtk_frame_new(_("Window Geometry"));
   gtk_box_pack_start(GTK_BOX(util_box), window_frame, TRUE, TRUE, 0);
   gtk_widget_show(window_frame);
   window_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(window_box), 5);
   gtk_container_add(GTK_CONTAINER(window_frame), window_box);
   gtk_widget_show(window_box);

   util_box = gtk_vbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(window_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);
   
   geometry0 = gtk_radio_button_new_with_label(NULL, "Use window manager settings");
   gtk_box_pack_start(GTK_BOX(util_box), geometry0, FALSE, FALSE, 0);
   gtk_widget_show(geometry0);
   geometry1 = gtk_radio_button_new_with_label(GTK_RADIO_BUTTON(geometry0)->group, "Restore geometry from previous session");
   gtk_box_pack_start(GTK_BOX(util_box), geometry1, FALSE, FALSE, 0);
   gtk_widget_show(geometry1);
   geometry2 = gtk_radio_button_new_with_label(GTK_RADIO_BUTTON(geometry0)->group, "Use explicit settings");
   gtk_box_pack_start(GTK_BOX(util_box), geometry2, FALSE, FALSE, 0);
   gtk_widget_show(geometry2);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(window_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);

   util_label = gtk_label_new(_("X:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);
   win_x_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, gdk_screen_width()/2, 1, 10, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), win_x_spin, TRUE, TRUE, 0);
   gtk_widget_show(win_x_spin);

   util_label = gtk_label_new(_("Y:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);
   win_y_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, gdk_screen_height()/2, 1, 10, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), win_y_spin, TRUE, TRUE, 0);
   gtk_widget_show(win_y_spin);

   util_box = gtk_hbox_new(FALSE, 5);
   gtk_box_pack_start(GTK_BOX(window_box), util_box, FALSE, FALSE, 5);
   gtk_widget_show(util_box);

   util_label = gtk_label_new(_("Width:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);
   win_w_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, gdk_screen_width(), 1, 10, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), win_w_spin, TRUE, TRUE, 0);
   gtk_widget_show(win_w_spin);

   util_label = gtk_label_new(_("Height:"));
   gtk_box_pack_start(GTK_BOX(util_box), util_label, FALSE, FALSE, 0);   
   gtk_widget_show(util_label);
   win_h_spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0, 0, gdk_screen_height(), 1, 10, 0)), 1, 0);
   gtk_box_pack_start(GTK_BOX(util_box), win_h_spin, TRUE, TRUE, 0);
   gtk_widget_show(win_h_spin);

   hsep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(window_box), hsep, FALSE, TRUE, 15);
   gtk_widget_show(hsep);

   util_box = gtk_hbox_new(TRUE, 5);
   gtk_box_pack_start(GTK_BOX(window_box), util_box, FALSE, FALSE, 0);
   gtk_widget_show(util_box);

   apply_window_settings = gnome_stock_or_ordinary_button(_("Apply Window Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), apply_window_settings, FALSE, TRUE, 0);   
   gtk_signal_connect(GTK_OBJECT(apply_window_settings), "clicked", GTK_SIGNAL_FUNC(apply_window_settings_cb), 0);
   gtk_widget_show(apply_window_settings);
   get_window_settings = gnome_stock_or_ordinary_button(_("Get Window Settings"));
   gtk_box_pack_start(GTK_BOX(util_box), get_window_settings, FALSE, TRUE, 0);   
   gtk_signal_connect(GTK_OBJECT(get_window_settings), "clicked", GTK_SIGNAL_FUNC(get_window_settings_cb), 0);
   gtk_widget_show(get_window_settings);

   /* Buttons Box */

   hsep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(main_box), hsep, FALSE, TRUE, 10);
   gtk_widget_show(hsep);

   buttons_box = gtk_hbutton_box_new();
   gtk_box_pack_start(GTK_BOX(main_box), buttons_box, FALSE, FALSE, 0);
   gtk_button_box_set_layout(GTK_BUTTON_BOX(buttons_box), gnome_preferences_get_button_layout());
   gtk_button_box_set_spacing(GTK_BUTTON_BOX(buttons_box), GNOME_PAD);
   gtk_widget_show(buttons_box);

   ok_button = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
   gtk_box_pack_start(GTK_BOX(buttons_box), ok_button, FALSE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC(save_settings), 0);
   gtk_signal_connect(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC(kill_widget), GTK_OBJECT(settings_window));
   GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
   gtk_widget_show(ok_button);

   apply_button = gnome_stock_button(GNOME_STOCK_BUTTON_APPLY);
   gtk_box_pack_start(GTK_BOX(buttons_box), apply_button, FALSE, TRUE, 0);
   gtk_signal_connect(GTK_OBJECT(apply_button), "clicked", GTK_SIGNAL_FUNC(apply_settings), 0);
   GTK_WIDGET_SET_FLAGS(apply_button, GTK_CAN_DEFAULT);
   gtk_widget_show(apply_button);

   defaults_button = gnome_stock_or_ordinary_button(_("Defaults"));
   gtk_box_pack_start(GTK_BOX(buttons_box), defaults_button, FALSE, TRUE, 0);   
   gtk_signal_connect(GTK_OBJECT(defaults_button), "clicked", GTK_SIGNAL_FUNC(get_defaults), 0);
   GTK_WIDGET_SET_FLAGS(defaults_button, GTK_CAN_DEFAULT);
   gtk_widget_show(defaults_button);

   undo_button = gnome_stock_or_ordinary_button(_("Undo"));
   gtk_box_pack_start(GTK_BOX(buttons_box), undo_button, FALSE, TRUE, 0);   
   gtk_signal_connect(GTK_OBJECT(undo_button), "clicked", GTK_SIGNAL_FUNC(get_backups), 0);
   GTK_WIDGET_SET_FLAGS(undo_button, GTK_CAN_DEFAULT);
   gtk_widget_show(undo_button);

   cancel_button = gnome_stock_button(GNOME_STOCK_BUTTON_CLOSE);
   gtk_box_pack_start(GTK_BOX(buttons_box), cancel_button, FALSE, TRUE, 0);   
   gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked", GTK_SIGNAL_FUNC(kill_widget), GTK_OBJECT(settings_window));
   GTK_WIDGET_SET_FLAGS(cancel_button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(cancel_button);
   gtk_widget_show(cancel_button);

   gtk_signal_connect(GTK_OBJECT(settings_window), "destroy", GTK_SIGNAL_FUNC(kill_widget_ptr), &settings_window);
   gtk_widget_show(settings_window);
   gtk_clist_select_row(GTK_CLIST(GNOME_SETTINGS(settings)->ctree), settings_selected_row, 0);
   gtk_signal_connect(GTK_OBJECT(GNOME_SETTINGS(settings)->ctree), "select_row", GTK_SIGNAL_FUNC(select_ctree_row), NULL);
   put_preferences(&general_preferences);
}

static void save_settings(GtkWidget *widget, gpointer data)
{
   get_preferences(&general_preferences);
   save_prefs();
   apply_settings_changes();
}

static void apply_settings(GtkWidget *widget, gpointer data)
{
   get_preferences(&general_preferences);
   apply_settings_changes();
}

static void get_defaults(GtkWidget *widget, gpointer data)
{
   put_preferences(&default_preferences);
   gtk_signal_emit_by_name(GTK_OBJECT(fg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bm_bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(s_bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(font), "font_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(italic), "font_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bold), "font_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(boldi), "font_set", 0);
   if(default_preferences.use_gtk_theme != general_preferences.use_gtk_theme)
      gtk_signal_emit_by_name(GTK_OBJECT(gtk_theme), "clicked", &iuse_gtk_theme);
}

static void get_theme_defaults(GtkWidget *widget, gpointer data)
{
   GtkWidget *win;
   GtkWidget *text_widget;
   GtkStyle *style;
   win = gtk_window_new(GTK_WINDOW_DIALOG);   
   text_widget = gtk_text_new(0, 0);
   gtk_container_add(GTK_CONTAINER(win), text_widget);
   gtk_widget_realize(text_widget);
   style = text_widget->style;
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fg), style->text[GTK_STATE_NORMAL].red, style->text[GTK_STATE_NORMAL].green, style->text[GTK_STATE_NORMAL].blue, 0);
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(bg), style->bg[GTK_STATE_NORMAL].red, style->bg[GTK_STATE_NORMAL].green, style->bg[GTK_STATE_NORMAL].blue, 0);
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(bm_bg), style->bg[GTK_STATE_PRELIGHT].red, style->bg[GTK_STATE_PRELIGHT].green, style->bg[GTK_STATE_PRELIGHT].blue, 0);
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(s_bg), style->bg[GTK_STATE_SELECTED].red, style->bg[GTK_STATE_SELECTED].green, style->bg[GTK_STATE_SELECTED].blue, 0);
   gtk_signal_emit_by_name(GTK_OBJECT(fg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bm_bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(s_bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(font), "font_set", 0);
   gtk_widget_destroy(win);
}

static void get_backups(GtkWidget *widget, gpointer data)
{
   put_preferences(&backup_preferences);
   gtk_signal_emit_by_name(GTK_OBJECT(fg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bm_bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(s_bg), "color_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(font), "font_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(italic), "font_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(bold), "font_set", 0);
   gtk_signal_emit_by_name(GTK_OBJECT(boldi), "font_set", 0);
   if(backup_preferences.use_gtk_theme != iuse_gtk_theme)
      gtk_signal_emit_by_name(GTK_OBJECT(gtk_theme), "clicked", &iuse_gtk_theme);
}

static void get_preferences(Preferences *source)
{
   GdkFont *old_font;
   gchar *text;
   text = gnome_direntry_get_dir(GNOME_DIRENTRY(default_dir_entry));
   strncpy(source->default_dir, text, sizeof(source->default_dir));
   text = gnome_direntry_get_dir(GNOME_DIRENTRY(projects_dir_entry));
   strncpy(source->projects_dir, text, sizeof(source->projects_dir));
   source->save_toolbars = isave_toolbars;
   source->save_session = isave_session;
   source->open_session = iopen_session;
   source->auto_save = iauto_save;
   source->history = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(hist_spin));
   source->undo_max = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(undo_spin));
   strncpy(source->terminal, gtk_entry_get_text(GTK_ENTRY(terminal_entry)), sizeof(source->terminal));
   strncpy(source->make, gtk_entry_get_text(GTK_ENTRY(make_entry)), sizeof(source->make));
   strncpy(source->name, gtk_entry_get_text(GTK_ENTRY(name_of_user)), sizeof(source->name));
   strncpy(source->email, gtk_entry_get_text(GTK_ENTRY(email_of_user)), sizeof(source->email));
   source->notebook_tab_position = get_which_radio_active(GTK_RADIO_BUTTON(notebook_pos_none)->group);
   if(font_changed)
   { 
      strcpy(source->font_name, gnome_font_picker_get_font_name(GNOME_FONT_PICKER(font)));
      old_font = source->font;
      if(source->font) gdk_font_unref(source->font);
      if((source->font = gdk_font_load(source->font_name)))
      {
         g_print("Font allocated.\n");
      }
      else if((source->font = gdk_font_load(default_preferences.font_name)))
      {
         strcpy(source->font_name, default_preferences.font_name);
         g_print("Default Font allocated.\n");
      }
      else
      {
         font_changed = FALSE;
         source->font = old_font;
         if(old_font) gdk_font_ref(source->font);
      }
   }
   if(italic_changed)
   { 
      strcpy(source->italic_name, gnome_font_picker_get_font_name(GNOME_FONT_PICKER(italic)));
      old_font = source->italic;
      if(source->italic) gdk_font_unref(source->italic);
      if((source->italic = gdk_font_load(source->italic_name)))
      {
         g_print("Italic Font allocated.\n");
      }
      else if((source->italic = gdk_font_load(default_preferences.italic_name)))
      {
         strcpy(source->italic_name, default_preferences.italic_name);
         g_print("Default Italic Font allocated.\n");
      }
      else
      {
         font_changed = FALSE;
         source->italic = old_font;
         if(old_font) gdk_font_ref(source->italic);
      }
   }
   if(bold_changed)
   { 
      strcpy(source->bold_name, gnome_font_picker_get_font_name(GNOME_FONT_PICKER(bold)));
      old_font = source->bold;
      if(source->bold) gdk_font_unref(source->bold);
      if((source->bold = gdk_font_load(source->bold_name)))
      {
         g_print("Bold Font allocated.\n");
      }
      else if((source->bold = gdk_font_load(default_preferences.bold_name)))
      {
         strcpy(source->font_name, default_preferences.bold_name);
         g_print("Default Bold Font allocated.\n");
      }
      else
      {
         bold_changed = FALSE;
         source->bold = old_font;
         if(old_font) gdk_font_ref(source->bold);
      }
   }
   if(boldi_changed)
   { 
      strcpy(source->boldi_name, gnome_font_picker_get_font_name(GNOME_FONT_PICKER(boldi)));
      old_font = source->boldi;
      if(source->boldi) gdk_font_unref(source->boldi);
      if((source->boldi = gdk_font_load(source->boldi_name)))
      {
         g_print("Bold-Italic Font allocated.\n");
      }
      else if((source->boldi = gdk_font_load(default_preferences.boldi_name)))
      {
         strcpy(source->font_name, default_preferences.bold_name);
         g_print("Default Bold-Italic Font allocated.\n");
      }
      else
      {
         boldi_changed = FALSE;
         source->boldi = old_font;
         if(old_font) gdk_font_ref(source->boldi);
      }
   }
   source->use_gtk_theme = iuse_gtk_theme;
   gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fg), &source->fg.red, &source->fg.green, &source->fg.blue, NULL);
   gnome_color_picker_get_i16(GNOME_COLOR_PICKER(bg), &source->bg.red, &source->bg.green, &source->bg.blue, NULL);
   gnome_color_picker_get_i16(GNOME_COLOR_PICKER(bm_bg), &source->bm_bg.red, &source->bm_bg.green, &source->bm_bg.blue, NULL);
   gnome_color_picker_get_i16(GNOME_COLOR_PICKER(s_bg), &source->s_bg.red, &source->s_bg.green, &source->s_bg.blue, NULL);

   text = gnome_pixmap_entry_get_filename(GNOME_PIXMAP_ENTRY(bg_pixmap));
   if(text) strncpy(general_preferences.pixmap_name, text, 256);
   else strcpy(general_preferences.pixmap_name, "");

   source->full_filenames_title = ifullfilenamestitle;
   source->full_filenames = ifullfilenames;
   source->close_all = icloseall;
   source->untitled = iuntitled;
   source->draw_numbers = idrawnumbers;
   source->draw_pixmaps = idrawpixmaps;
   source->cursor_blink = icursorblink;
   source->full_selection = ifullselection;
   source->bracketmatch = ibracketmatch;
   source->select_line = iselect_line;
   source->syntax = isyntax;
   source->auto_indent = iauto_indent;
   source->tab_stops = itab_stops;
   source->use_spaces = iuse_spaces;
   source->spaces = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spaces_spin));
   source->geometry = get_which_radio_active(GTK_RADIO_BUTTON(geometry2)->group);
   source->x = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_x_spin));
   source->y = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_y_spin));
   source->w = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_w_spin));
   source->h = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_h_spin));
}

static void put_preferences(Preferences *source)
{
   GtkWidget *entry;
   gnome_direntry_set_dir(GNOME_DIRENTRY(default_dir_entry), source->default_dir);
   gnome_direntry_set_dir(GNOME_DIRENTRY(projects_dir_entry), source->projects_dir);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(save_toolbars), source->save_toolbars);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(save_session), source->save_session);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(open_session), source->open_session);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(auto_save), source->auto_save);
   isave_toolbars = source->save_toolbars;
   isave_session = source->save_session;
   iopen_session = source->open_session;
   iauto_save = source->auto_save;
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(hist_spin), (gfloat)source->history);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(undo_spin), (gfloat)source->undo_max);
   gtk_entry_set_text(GTK_ENTRY(terminal_entry), source->terminal);
   gtk_entry_set_text(GTK_ENTRY(make_entry), source->make);
   gtk_entry_set_text(GTK_ENTRY(name_of_user), source->name);
   gtk_entry_set_text(GTK_ENTRY(email_of_user), source->email);
   set_which_radio_active(GTK_RADIO_BUTTON(notebook_pos_none)->group, source->notebook_tab_position);

   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(gtk_theme), source->use_gtk_theme);
   iuse_gtk_theme = source->use_gtk_theme;

   if(strlen(general_preferences.font_name)>1)
      gnome_font_picker_set_font_name(GNOME_FONT_PICKER(font), general_preferences.font_name);
   else
      font_changed = TRUE;
   if(strlen(general_preferences.italic_name)>1)
      gnome_font_picker_set_font_name(GNOME_FONT_PICKER(italic), general_preferences.italic_name);
   else
      italic_changed = TRUE;
   if(strlen(general_preferences.bold_name)>1)
      gnome_font_picker_set_font_name(GNOME_FONT_PICKER(bold), general_preferences.bold_name);
   else
      bold_changed = TRUE;
   if(strlen(general_preferences.boldi_name)>1)
      gnome_font_picker_set_font_name(GNOME_FONT_PICKER(boldi), general_preferences.boldi_name);
   else
      boldi_changed = TRUE;
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fg), source->fg.red, source->fg.green, source->fg.blue, 0);
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(bg), source->bg.red, source->bg.green, source->bg.blue, 0);
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(bm_bg), source->bm_bg.red, source->bm_bg.green, source->bm_bg.blue, 0);
   gnome_color_picker_set_i16(GNOME_COLOR_PICKER(s_bg), source->s_bg.red, source->s_bg.green, source->s_bg.blue, 0);

   entry = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(GNOME_PIXMAP_ENTRY(bg_pixmap)->fentry));
   gtk_entry_set_text(GTK_ENTRY(entry), source->pixmap_name);

   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(fullfilenamestitle), source->full_filenames_title);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(fullfilenames), source->full_filenames);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(closeall), source->close_all);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(untitled), source->untitled);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(drawnumbers), source->draw_numbers);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(drawpixmaps), source->draw_pixmaps);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cursorblink), source->cursor_blink);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(fullselection), source->full_selection);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bracketmatch), source->bracketmatch);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(select_line), source->select_line);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(syntax), source->syntax);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(auto_indent), source->auto_indent);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tab_stops), source->tab_stops);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(use_spaces), source->use_spaces);
   ifullfilenamestitle = source->full_filenames_title;
   ifullfilenames = source->full_filenames;
   icloseall = source->close_all;
   iuntitled = source->untitled;
   idrawnumbers = source->draw_numbers;
   idrawpixmaps = source->draw_pixmaps;
   icursorblink = source->cursor_blink;
   ifullselection = source->full_selection;
   ibracketmatch = source->bracketmatch;
   iselect_line = source->select_line;
   isyntax = source->syntax;
   iauto_indent = source->auto_indent;
   iuse_spaces = source->use_spaces;
   itab_stops = source->tab_stops;
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(spaces_spin), (gfloat)source->spaces);

   set_which_radio_active(GTK_RADIO_BUTTON(geometry2)->group, source->geometry);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_x_spin), (gfloat)source->x);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_y_spin), (gfloat)source->y);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_w_spin), (gfloat)source->w);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_h_spin), (gfloat)source->h);
}

static void copy_preferences(Preferences *source, Preferences *dest)
{
   memcpy(dest, source, sizeof(Preferences));
}

static void set_font_changed(GtkWidget *gfp, gchar *font_name, gpointer data)
{
   if(gfp == font) font_changed = TRUE;
   else if(gfp == italic) italic_changed = TRUE;
   else if(gfp == bold) bold_changed = TRUE;
   else if(gfp == boldi) boldi_changed = TRUE;
}

static void set_color_changed(GtkWidget *cp, guint r, guint g, guint b, guint a, gpointer data)
{
   if(cp == bg) bg_changed = TRUE;
   else if(cp == fg) fg_changed = TRUE;
   else if(cp == s_bg) s_bg_changed = TRUE;
   else if(cp == bm_bg) bm_bg_changed = TRUE;
}

static void toggle_button_switch(GtkWidget *widget, gint *value)
{
   *value =  *value ? 0 : 1;
}

static void gtk_theme_switch_cb(GtkWidget *widget, gint *value)
{
   *value  = *value ? 0 : 1;
   gtk_theme_changed = TRUE;
   if(*value == 0)
      gtk_widget_set_sensitive(color_frame, TRUE);
   else
      gtk_widget_set_sensitive(color_frame, FALSE);
   bg_changed = TRUE;
   fg_changed = TRUE;
   s_bg_changed = TRUE;
   bm_bg_changed = TRUE;
   font_changed = TRUE;
}

static void apply_settings_changes(void)
{
   GList *file = NULL;
   GdsFile *temp;
   GtkWidget *win;
   GtkWidget *text_widget;
   GtkStyle *new_style = NULL;
   GtkStyle *old_style = NULL;
  
   if(GTK_WIDGET(window)->window != NULL)
      gdk_window_set_cursor(GTK_WIDGET(window)->window, gdk_cursor_new(GDK_WATCH));

   if(general_preferences.notebook_tab_position >= 4)
   {
      gtk_notebook_set_show_tabs(GTK_NOTEBOOK(files_book), FALSE);
   }
   else
   {
      gtk_notebook_set_show_tabs(GTK_NOTEBOOK(files_book), TRUE);
      gtk_notebook_set_tab_pos(GTK_NOTEBOOK(files_book), (GtkPositionType) general_preferences.notebook_tab_position);
   }

   gds_file_set_global_props(general_preferences.undo_max, general_preferences.use_spaces ? general_preferences.spaces : 0, general_preferences.auto_indent, general_preferences.bracketmatch, general_preferences.tab_stops);

   old_style = extext_style;
   if(!general_preferences.use_gtk_theme)
   {
      extext_style->text[GTK_STATE_NORMAL] = general_preferences.fg;
      extext_style->bg[GTK_STATE_NORMAL] = general_preferences.bg;
      extext_style->bg[GTK_STATE_SELECTED] = general_preferences.s_bg;
      extext_style->bg[GTK_STATE_PRELIGHT] = general_preferences.bm_bg;
      extext_style->bg_pixmap[GTK_STATE_NORMAL] = NULL;
      if(strlen(general_preferences.pixmap_name))
      {
         if(general_preferences.bg_pixmap) gtk_widget_destroy(GTK_WIDGET(general_preferences.bg_pixmap));
         general_preferences.bg_pixmap = (GnomePixmap *)gnome_pixmap_new_from_file(general_preferences.pixmap_name);
         if(general_preferences.bg_pixmap) extext_style->bg_pixmap[GTK_STATE_NORMAL] = general_preferences.bg_pixmap->pixmap;
      }
      else if(general_preferences.bg_pixmap)
      {
         gtk_widget_destroy(GTK_WIDGET(general_preferences.bg_pixmap));
         general_preferences.bg_pixmap = NULL;
      }
      win = gtk_window_new(GTK_WINDOW_DIALOG);   
      text_widget = gtk_text_new(0, 0);
      gtk_container_add(GTK_CONTAINER(win), text_widget);
      gtk_widget_realize(text_widget);
      gtk_style_ref(extext_style);
      gtk_style_attach(extext_style, text_widget->window);
      gtk_widget_destroy(win);
   }
   else if(gtk_theme_changed && iuse_gtk_theme)
   {
      if(general_preferences.bg_pixmap) gtk_widget_destroy(GTK_WIDGET(general_preferences.bg_pixmap));
      win = gtk_window_new(GTK_WINDOW_DIALOG);   
      text_widget = gtk_text_new(0, 0);
      gtk_container_add(GTK_CONTAINER(win), text_widget);
      gtk_widget_realize(text_widget);
      new_style = gtk_style_copy(gtk_widget_get_style(text_widget));
      gtk_style_ref(new_style);
      gtk_widget_destroy(win);
      extext_style = new_style;
      font_changed = TRUE;
   }
   if(font_changed && general_preferences.font)
   {
      if(extext_style->font) gdk_font_unref(extext_style->font);
      extext_style->font = general_preferences.font;
      gdk_font_ref(extext_style->font);
      highlight_tables_font_change(extext_style->font, FONT_NORMAL);
   }
   if(italic_changed && general_preferences.italic)
   {
      highlight_tables_font_change(general_preferences.italic, FONT_ITALIC);
      font_changed = TRUE;
   }
   if(bold_changed && general_preferences.bold)
   {
      highlight_tables_font_change(general_preferences.bold, FONT_BOLD);
      font_changed = TRUE;
   }
   if(boldi_changed && general_preferences.boldi)
   {
      highlight_tables_font_change(general_preferences.boldi, FONT_BOLD_ITALIC);
      font_changed = TRUE;
   }
   if(fg_changed)
   {
      HighlightCache.colors[DEFAULT] = extext_style->text[GTK_STATE_NORMAL];
      font_changed = TRUE;
   }

   while(gtk_events_pending()) gtk_main_iteration();
   file = g_list_first(files_list);
   while(file)
   {
      temp = (GdsFile *)file->data;
      gds_editor_set_style(GDS_EDITOR(temp->text), extext_style);
      if(font_changed && temp->tables)
      {
         if(temp->tables->syntax) gds_editor_install_table(GDS_EDITOR(temp->text), temp->tables->syntax);
         if(temp->tables->pattern) gds_editor_install_table(GDS_EDITOR(temp->text), temp->tables->pattern);
         if(temp->tables->embedded) gds_editor_install_table(GDS_EDITOR(temp->text), temp->tables->embedded);
      }
      gtk_style_attach(extext_style, GTK_EXTEXT(temp->text)->text_area);
      if(general_preferences.undo_max != GTK_EXTEXT(temp->text)->undo_max)
         gtk_extext_undo_set_max(GTK_EXTEXT(temp->text), general_preferences.undo_max);
      gds_file_set_title(temp, temp->filename, general_preferences.full_filenames);
      if(general_preferences.draw_numbers != GTK_EXTEXT(temp->text)->draw_numbers)
         gtk_extext_set_draw_numbers(GTK_EXTEXT(temp->text), general_preferences.draw_numbers);
      if(general_preferences.draw_pixmaps != GTK_EXTEXT(temp->text)->draw_pixmaps)
         gtk_extext_set_draw_pixmaps(GTK_EXTEXT(temp->text), general_preferences.draw_pixmaps);
      if(general_preferences.cursor_blink != GTK_EXTEXT(temp->text)->cursor_blink)
         gtk_extext_set_cursor_blink(GTK_EXTEXT(temp->text), general_preferences.cursor_blink);
      if(general_preferences.full_selection != GTK_EXTEXT(temp->text)->full_selection)
         gtk_extext_set_full_selection(GTK_EXTEXT(temp->text), general_preferences.full_selection);
      if(general_preferences.tab_stops != GTK_EXTEXT(temp->text)->tab_stops)
         gtk_extext_set_use_tab_stops(GTK_EXTEXT(temp->text), general_preferences.tab_stops);
      if(!temp->props.over_ride)
      {
         if(GDS_EDITOR(temp->text)->highlight != general_preferences.syntax && temp->tables)
            gds_editor_set_highlight(GDS_EDITOR(temp->text), general_preferences.syntax);
         temp->props.bracketmatch = general_preferences.bracketmatch;
         temp->props.auto_indent = general_preferences.auto_indent;
         temp->props.use_spaces = general_preferences.use_spaces;
         temp->props.spaces = general_preferences.spaces;
         gtk_extext_set_tab_width(GTK_EXTEXT(temp->text), general_preferences.spaces);
      }
      gtk_extext_set_select_line(GTK_EXTEXT(temp->text), general_preferences.select_line);
      gtk_extext_set_position(GTK_EDITABLE(temp->text), GTK_EDITABLE(temp->text)->current_pos);
      file = file->next;
   }
   setup_recent_files_list(general_preferences.history);
   if(new_style)
   {
      old_style->attach_count = 0;
      while(old_style->ref_count > 0) gtk_style_unref(old_style);
   }
   if((total_files < 1) && general_preferences.untitled) new_file_cb(NULL, NULL);
	set_window_title();
   if(GTK_WIDGET(window)->window) gdk_window_set_cursor(GTK_WIDGET(window)->window, gdk_cursor_new(GDK_LEFT_PTR));
}

void kill_widget_ptr(GtkWidget *w, GtkWidget **widget)
{
   *widget = NULL;
}

GtkWidget *make_button(gchar *button_text, GtkWidget *which_box, gint *value)
{
   GtkWidget *button;
   button = gtk_check_button_new_with_label(button_text);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), *value);
   gtk_box_pack_start(GTK_BOX(which_box), button, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(toggle_button_switch), value);
   gtk_widget_show(button);
   return button;
}

void apply_window_settings_cb(GtkWidget *widget, gpointer data)
{
   gint x, y, w, h;
   x = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_x_spin));
   y = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_y_spin));
   w = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_w_spin));
   h = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(win_h_spin));
   gdk_window_move_resize(window->window, x, y, w, h);
}

void get_window_settings_cb(GtkWidget *widget, gpointer data)
{
   gint x, y, w, h;
   gdk_window_get_geometry(window->window, NULL, NULL, &w, &h, NULL);
   gdk_window_get_position(window->window, &x, &y);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_x_spin), (gfloat)x);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_y_spin), (gfloat)y);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_w_spin), (gfloat)w);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(win_h_spin), (gfloat)h);
}

static void select_ctree_row(GtkCTree *tree, gint row, gint col, GdkEvent *event, gpointer data)
{
   settings_selected_row = row;
}
