#include "declarations.h"
#include "session-management.h"

static gint session_manage_save(GnomeClient *client, gint phase, GnomeSaveStyle save_style, gint is_shutdown, GnomeInteractStyle interact_style, gint is_fast, gpointer client_data);

GnomeClient *client = NULL;
gchar *program_name = PACKAGE;

void init_session_management(void)
{
   client = gnome_master_client();
   gtk_signal_connect(GTK_OBJECT(client), "save_yourself", GTK_SIGNAL_FUNC(session_manage_save), (gpointer)program_name);
   gtk_signal_connect(GTK_OBJECT(client), "die", GTK_SIGNAL_FUNC(session_die), NULL);
}

void session_die(GnomeClient *client, gpointer data)
{
   gtk_main_quit();
}

static gint session_manage_save(GnomeClient *client, gint phase, GnomeSaveStyle save_style, gint is_shutdown, GnomeInteractStyle interact_style, gint is_fast, gpointer client_data)
{
   gchar **argv;
   guint argc;
   gchar rm[] = "rm";
   gchar *options[] = { "-s", "-f" };
   gchar buffer[384];

   g_snprintf(buffer, sizeof(buffer), "%s/." PACKAGE, getenv("HOME"));
   gnome_client_set_current_directory(client, buffer);
   strcat(buffer, "/");
   strcat(buffer, client->client_id);
   save_session_to_file(buffer);

   argv = (gchar **)g_malloc0(sizeof(gchar *) * 4);
   argc = 3;
   argv[0] = (gchar *)client_data;
   argv[1] = options[0];
   argv[2] = client->client_id;
   gnome_client_set_clone_command(client, argc, argv);
   gnome_client_set_restart_command(client, argc, argv);
   argv[0] = rm;
   argv[1] = options[1];
   argv[2] = client->client_id;
   gnome_client_set_discard_command(client, argc, argv);
   g_free(argv);
   return TRUE;
}
