/*  searches,h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SEARCHES_H_
#define SEARCHES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "widgets/gnomesearchdialog.h"
#include "widgets/gnomegotoline.h"
#include "widgets/gdsmanpage.h"

void match_bracket_cb(GtkWidget *widget, gpointer data);
void find_cb(GtkWidget *widget, gpointer data);
void find_text_cb(GtkWidget *widget, GnomeSearchDialog *search_dialog);
gboolean find_text(GtkExText *extext, gint start, gint end, gchar *search_string, gboolean case_sensitive, gboolean is_regex, gboolean select, GtkExTextMatch *match);

void replace_cb(GtkWidget *widget, gpointer data);
void replace_text_cb(GtkWidget *widget, GnomeSearchDialog *search_dialog);
void replace_all_text_cb(GtkWidget *widget, GnomeSearchDialog *search_dialog);
gint replace_all_text(GtkExText *extext, gchar *search_text, gchar *replace_text, gboolean iscase, gboolean regex, gint end);
gboolean replace_text(GtkExText *extext, gchar *text);

void gotoline_cb(GtkWidget *widget, gpointer data);
void find_line_cb(GtkWidget *widget, GnomeGotoLineDialog *gtl);

void manpage_cb(GtkWidget *widget, gpointer data);
void make_manpage_viewer(gchar *text);
void make_gnome_manpage_viewer(gchar *text);

void set_find_text_from_selection(GnomeSearchDialog *sd);

void last_bookmark_cb(GtkWidget *widget, gpointer data);
void next_bookmark_cb(GtkWidget *widget, gpointer data);

extern gboolean case_sensitive;
extern gboolean search_style;
extern gboolean search_start;
extern gboolean search_multi;
extern gboolean keep_open;

#ifdef __cplusplus
extern "C" {
#endif

#endif
