/*  misc.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MISC_H
#define MISC_H

#ifdef __cplusplus
extern "C" {
#endif

void make_file_reader(gchar *filename, gchar *windowname);
void write_file_to_gtktext(gchar *filename, GtkWidget *text, GdkColor *color);

gchar *g_str_replace(const gchar *input, const gchar *replace, const gchar *with);
gchar *g_str_replace_bad_chars(const gchar *input);

gchar *replace_percent_tokens(const gchar *string);
gchar *get_path_from_filename(gchar *filename);
gchar *get_file_from_filename(gchar *filename);
gchar *get_file_wo_extension(gchar *filename);

GList *build_glist_from_file(gchar *filename, guint max);
void add_string_to_file(gchar *filename, const gchar *string);
gint check_list_for_string(GList *list, gchar *string);

gint get_selection_length(GtkEditable *editable);
gchar *get_selection_text(GtkEditable *editable);
gint get_entry_length(GtkEntry *entry);
gchar *get_entry_text(GtkEntry *entry);

GdsFile *get_nth_file_proper(gint number);
gint get_nth_file_number(GdsFile *gds_file);
void display_message(const gchar *text, gint type);

gint get_which_radio_active(GSList *list);
void set_which_radio_active(GSList *list, gint which);

#ifdef __cplusplus
}
#endif

#endif
