#include "declarations.h"
#include "misc.h"

#ifdef USE_PYTHON
#include "Python.h"
#else
#include <guile/gh.h>
#include <libguile.h>
#endif


void make_file_reader(gchar *filename, gchar *windowname)
{
   GtkWidget *text_window;
   GtkWidget *main_box;
   GtkWidget *text_box;
   GtkWidget *text;
   GtkWidget *scroller;
   GtkWidget *buttons_box;
   GtkWidget *close_button;
   GtkWidget *hsep;   

   text_window = gtk_window_new(GTK_WINDOW_DIALOG);
   gtk_container_set_border_width(GTK_CONTAINER(text_window), 10);   
   gtk_window_set_title(GTK_WINDOW(text_window), windowname);

   main_box = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(text_window), main_box);
   gtk_widget_show(main_box);   

   text_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(main_box), text_box, TRUE, TRUE, 0);
   gtk_widget_show(text_box);
   
   text = gtk_text_new(0, 0);
   gtk_widget_set_usize(text, 600, 400);
   gtk_box_pack_start(GTK_BOX(text_box), text, TRUE, TRUE, 0);
   gtk_widget_show(text);

   scroller = gtk_vscrollbar_new(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj));
   gtk_box_pack_start(GTK_BOX(text_box), scroller, FALSE, FALSE, 0);
   gtk_widget_show(scroller);
   
   hsep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(main_box), hsep, FALSE, TRUE, 15);
   gtk_widget_show(hsep);
   
   buttons_box = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(main_box), buttons_box, FALSE, FALSE, 5);
   gtk_widget_show(buttons_box);
   close_button = gnome_stock_button(GNOME_STOCK_BUTTON_CLOSE);
   gtk_box_pack_end(GTK_BOX(buttons_box), close_button, FALSE, FALSE, 15);   
   gtk_signal_connect(GTK_OBJECT(close_button), "clicked", GTK_SIGNAL_FUNC(kill_widget), GTK_OBJECT(text_window));
   GTK_WIDGET_SET_FLAGS(close_button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(close_button);
   gtk_widget_show(close_button);

   gtk_widget_show(text_window);
   write_file_to_gtktext(filename, text, 0);
}

void write_file_to_gtktext(gchar *filename, GtkWidget *text, GdkColor *color)
{
   FILE *file;
   gchar buffer[256];

   if(!(file = fopen(filename, "r")))
   {
      g_print("%s does not exist.\n", filename);
      return;
   }
   gtk_text_freeze(GTK_TEXT(text));
   while(fgets(buffer, sizeof(buffer), file) != NULL)
   {
      gtk_text_insert(GTK_TEXT(text), 0, color, 0, buffer, -1);
   }
   gtk_text_thaw(GTK_TEXT(text));
   fclose(file);
   return;
}

gchar *replace_percent_tokens(const gchar *string)
{
   gchar *path;
   gchar *filename;
   gchar *file;
   gchar *new_string = NULL;
   gchar *ptr;
   path = get_path_from_filename(cur_file->filename);
   filename = get_file_from_filename(cur_file->filename);
   file = get_file_wo_extension(cur_file->filename);
   new_string = g_strdup(string);
   while(1)
   {
      ptr = g_str_replace(new_string, "%term%", general_preferences.terminal);
      if(ptr) { g_free(new_string); new_string = ptr; }
      else { break; }
   }
   while(1)
   {
      ptr = g_str_replace(new_string, "%make%", general_preferences.make);
      if(ptr) { g_free(new_string); new_string = ptr; }
      else { break; }
   }
   while(1)
   {
      ptr = g_str_replace(new_string, "%1", path);
      if(ptr) { g_free(new_string); new_string = ptr; }
      else { break; }
   }
   while(1)
   {
      ptr = g_str_replace(new_string, "%2", filename);
      if(ptr) { g_free(new_string); new_string = ptr; }
      else { break; }
   }
   while(1)
   {
      ptr = g_str_replace(new_string, "%3", file);
      if(ptr) { g_free(new_string); new_string = ptr; }
      else { break; }
   }
   return(new_string);
}

gchar *get_path_from_filename(gchar *filename)
{
   gchar *file = NULL;
   gchar *text = NULL;
   gchar *value = NULL;
   file = g_strdup(filename);
   text =  strrchr(file, '/');
   if(text)
   {
      *text = '\0';
      text = file;
      value = g_strdup(text);
   }
   g_free(file);
   return(value);
}

gchar *get_file_from_filename(gchar *filename)
{
   gchar *text = NULL;
   text =  strrchr(filename, '/');
   if(text) { text++; } else { text = filename; }
   return(g_strdup(text));
}

gchar *get_file_wo_extension(gchar *filename)
{
   gchar *file = NULL;
   gchar *text = NULL;
   gchar *extension = NULL;
   gchar *value = NULL;
   file = g_strdup(filename);
   text =  strrchr(file, '/');
   if(text) { text++; } else { text = file; }
   extension = strrchr(text, '.');
   if(extension) { *extension = '\0'; }
   value =  g_strdup(text);
   g_free(file);
   return(value);
}

gchar *g_str_replace(const gchar *input, const gchar *replace, const gchar *with)
{
   gchar *text = NULL;
   gchar *start = NULL;
   gchar *end = NULL;
   gchar *value = NULL;
   text = g_strdup(input);
   start = strstr(text, replace);
   if(!start) return(NULL);
   end = start + strlen(replace);
   *start = '\0';
   value = g_strconcat(text, with, end, NULL);
   g_free(text);
   return(value);
}

gchar *g_str_replace_bad_chars(const gchar *input)
{
   gchar *ptr;
   gchar *new_string;
   gint i, j;
   gchar last = 0;
   new_string = g_new0(char, strlen(input)+1);
   for(i = 0, j = 0; i < strlen(input); last = input[i], i++, j++)
   {
      if((last == '\\') && (input[i] == 't' || input[i] == 'n'))
      {
        j--;
        if(input[i] == 't') new_string[j] = '\t';
        else if(input[i] == 'n') new_string[j] = '\n';
        continue;
      }
      new_string[j] = input[i];
   }
   ptr = g_strdup(new_string);
   g_free(new_string);
   return(ptr);
}

GList *build_glist_from_file(gchar *filename, guint max)
{
   gchar full_path[256] = "";
   FILE *file;
   gchar buffer[256];
   gpointer temp;
   GList *list = NULL;
   guint iterations = 0;
   g_snprintf(full_path, sizeof(full_path), "%s/." PACKAGE "/%s", getenv("HOME"), filename);

   file = fopen(full_path, "r");
   if(!file) return(list);

   while(fgets(buffer, sizeof(buffer), file) && iterations < max)
   {
      if(!strcmp(buffer, "\n")) continue;
      buffer[strlen(buffer)-1] = '\0';
      if(check_list_for_string(list, buffer)) continue;
      temp = g_new(char, strlen(buffer)+1);
      strcpy((gchar *)temp, buffer);
      list = g_list_append(list, temp);
      iterations++;
   }
   return(list);
}


void add_string_to_file(gchar *filename, const gchar *string)
{
   gchar full_path[256] = "";
   gchar temp_file[256] = "";
   FILE *file;
   FILE *tmp_file;
   gchar buffer[256];
   
   g_snprintf(full_path, sizeof(full_path), "%s/." PACKAGE "/%s", getenv("HOME"), filename);
   g_snprintf(temp_file, sizeof(temp_file), "%s/." PACKAGE "/%s", getenv("HOME"), "yadda.tmp");

   file = fopen(full_path, "a");
   if(!file) return;
   fclose(file);

   rename(full_path, temp_file);
   
   file = fopen(full_path, "w");
   if(!file) return;

   fprintf(file, "%s\n", string);

   tmp_file = fopen(temp_file, "r");
   if(!tmp_file) { fclose(file); return; }

   while(fgets(buffer, sizeof(buffer), tmp_file) != NULL)
   {
      fprintf(file, "%s", buffer);
   }
   fclose(file);
   fclose(tmp_file);
   remove(temp_file);
}

/* 0 for none, + for it's position in the list - use position-1 to index*/
gint check_list_for_string(GList *list, gchar *string)
{
   GList *current = NULL;
   gint return_value = 0;
   gint iterations = 0;

   current = g_list_first(list);
   while(current)
   {
      iterations++;
      if(!strcmp(string, (gchar *)current->data))
      {
         return_value = iterations;
         break;
      }
      current = current->next;
   }
   return(return_value);
}

gint get_entry_length(GtkEntry *entry)
{
   gchar *text;
   text = gtk_entry_get_text(entry);
   return(strlen(text));
}

/* return g_new()'d text string...must be g_free()'d later */
gchar *get_entry_text(GtkEntry *entry)
{
   gchar *text;
   gint length;
   length = get_entry_length(entry);
   text = g_new(char, length+1);
   strcpy(text, gtk_entry_get_text(entry));
   return(text);
}

gint get_selection_length(GtkEditable *editable)
{
   gint length;
   g_return_val_if_fail(editable != NULL, -1);
   if(editable->has_selection)
   {
      length = GTK_EDITABLE(cur_file->text)->selection_end_pos - GTK_EDITABLE(cur_file->text)->selection_start_pos;
      return(length);
   }
   else
   {
      return(-1);
   }
}

gchar *get_selection_text(GtkEditable *editable)
{
   gchar *text;
   gint start;
   gint end;
   
   if(editable->has_selection)
   {
      start = editable->selection_start_pos;
      end = editable->selection_end_pos;
      text = g_new(char, (end-start)+1);
      strcpy(text, gtk_editable_get_chars(editable, start, end)); // might be a mem leak here.
      return(text);
   }
   else
   {
      return(NULL);
   }
}

GdsFile *get_nth_file_proper(gint number)
{
   GdsFile *set = NULL;
   gint iterations = 0;
   gint current = -1;
   if(number < 0) return(NULL);
   while(iterations < total_files)
   {
      set = (GdsFile *)g_list_nth_data(files_list, iterations);
      if(!set) break;
      if(!GDS_TEAR_AWAY(set->tear_away)->torn) current++;
      if(current == number) break;
      iterations++;
   }
   if(g_list_index(files_list, set) >= 0) return(set);
   return(NULL);
}

gint get_nth_file_number(GdsFile *gds_file)
{
   GdsFile *check = NULL;
   gint iterations = 0;
   gint current = 0;
   while(iterations < total_files)
   {
      check = (GdsFile *)g_list_nth_data(files_list, iterations);
      if(check == gds_file) break;
      if(!check) break;
      if(!GDS_TEAR_AWAY(check->tear_away)->torn) current++;
      iterations++;
   }
   return(current);
}

void display_message(const gchar *text, gint type)
{
   if(type == FLASH)
      gnome_app_flash(GNOME_APP(window), text);
   if(type == ERROR)
      gnome_app_error(GNOME_APP(window), text);
   if(type == WARNING)
      gnome_app_warning(GNOME_APP(window), text);
}

gint get_which_radio_active(GSList *list)
{
   GSList *first;
   GSList *current;
   gint iterations = 0;
   GtkToggleButton *toggle;
   first = g_slist_copy(list);
   first = current = g_slist_reverse(first);
   while(current)
   {
      toggle = (GtkToggleButton *)current->data;
      if(toggle->active) break;
      iterations++;
      current = current->next;
   }
   g_slist_free(first);
   return(iterations);
}

void set_which_radio_active(GSList *list, gint which)
{
   GSList *first;
   GtkToggleButton *toggle;

   first = g_slist_copy(list);
   first = g_slist_reverse(first);
   toggle = (GtkToggleButton *)g_slist_nth_data(first, which);
   gtk_toggle_button_set_active(toggle, TRUE);
   g_slist_free(first);
}
