#include "declarations.h"
#include "signals.h"

void gds_file_ask_focus(GtkWidget *widget, GdsFile *gds_file);
void undo_changed(GtkWidget *widget, GdsFile *gds_file);

GdsFile *create_file(gchar *name)
{
   GdsFile *new_file;
   GtkWidget *label;
   gchar cwd[256];
   gchar *path;
   gchar *file;
   gchar *full;
   GdsFile *back_file;

   if(!general_preferences.use_gtk_theme)
   {
      extext_style->text[GTK_STATE_NORMAL] = general_preferences.fg;
      extext_style->bg[GTK_STATE_NORMAL] = general_preferences.bg;
      extext_style->bg[GTK_STATE_PRELIGHT] = general_preferences.bm_bg;
      extext_style->bg[GTK_STATE_SELECTED] = general_preferences.s_bg;
      extext_style->bg_pixmap[GTK_STATE_NORMAL] = general_preferences.bg_pixmap ? general_preferences.bg_pixmap->pixmap : NULL;
   }
   getcwd(cwd, 256);
   path = get_path_from_filename(name);
   file = get_file_from_filename(name);
   if(!path) full = g_strconcat(cwd, "/", file, NULL);
   else full = g_strconcat(path, "/", file, NULL);
   new_file = (GdsFile *)gds_file_new(full, general_preferences.full_filenames);
   if(!path)
      new_file->props.dir = g_strdup(cwd);
   else
      new_file->props.dir = path;
   gtk_signal_connect(GTK_OBJECT(new_file->tear_away), "window_focused", GTK_SIGNAL_FUNC(file_change), new_file);
   gtk_signal_connect(GTK_OBJECT(new_file->tear_away), "attached", GTK_SIGNAL_FUNC(file_change), new_file);
   gtk_signal_connect(GTK_OBJECT(new_file->text), "undo_changed", GTK_SIGNAL_FUNC(undo_changed), new_file);
   gtk_signal_connect(GTK_OBJECT(new_file->text), "move_to_column", GTK_SIGNAL_FUNC(file_pos_changed), 0);
   gtk_widget_set_style(new_file->text, extext_style);
   gtk_extext_set_tab_width(GTK_EXTEXT(new_file->text), general_preferences.spaces);
   gtk_extext_set_use_tab_stops(GTK_EXTEXT(new_file->text), general_preferences.tab_stops);
   gtk_widget_show(GTK_WIDGET(new_file));
   files_list = g_list_append(files_list, (gpointer)new_file);
   if(general_preferences.full_filenames)
      label = gtk_label_new(full);
   else
      label = gtk_label_new(file);
   gtk_widget_show(label);
   g_free(full);
   total_files++;
   gtk_signal_connect(GTK_OBJECT(new_file->menu_item), "activate", GTK_SIGNAL_FUNC(gds_file_focus_with_raise), new_file);
   gtk_menu_append(GTK_MENU(docsmenu), new_file->menu_item);
   new_file->props.bracketmatch = general_preferences.bracketmatch;
   new_file->props.auto_indent = general_preferences.auto_indent;
   new_file->props.use_spaces = general_preferences.use_spaces;
   new_file->props.spaces = general_preferences.spaces;
   g_free(file);
   back_file = cur_file;
   cur_file = new_file;
   app_emit_scripting_signal("open-file");
   cur_file = back_file;
   gtk_notebook_append_page(GTK_NOTEBOOK(files_book), new_file->tear_away, label);
   gtk_widget_realize(new_file->text);
   gds_editor_set_style(GDS_EDITOR(new_file->text), extext_style);
   gtk_extext_set_draw_numbers(GTK_EXTEXT(new_file->text), general_preferences.draw_numbers);
   gtk_extext_set_draw_pixmaps(GTK_EXTEXT(new_file->text), general_preferences.draw_pixmaps);
   gtk_extext_set_cursor_blink(GTK_EXTEXT(new_file->text), general_preferences.cursor_blink);
   gtk_extext_set_full_selection(GTK_EXTEXT(new_file->text), general_preferences.full_selection);
   gtk_extext_set_select_line(GTK_EXTEXT(new_file->text), general_preferences.select_line);
   cur_page = g_list_length(GTK_NOTEBOOK(files_book)->children) - 1;
   if(total_files > 1) gtk_notebook_set_page(GTK_NOTEBOOK(files_book), cur_page);
   return(new_file);
}

void gds_file_ask_focus(GtkWidget *widget, GdsFile *gds_file)
{
   file_change(NULL, gds_file);
}

void gds_file_focus_with_raise(GtkWidget *widget, GdsFile *gds_file)
{
   if(GDS_TEAR_AWAY(gds_file->tear_away)->torn)
   {
      gdk_window_raise(GDS_TEAR_AWAY(gds_file->tear_away)->new_parent->window);
      gtk_widget_grab_focus(gds_file->text);
   }
   else file_change(NULL, gds_file);
}

void file_pos_changed(GtkWidget *widget, gint pos, gpointer data)
{
   GtkEditable *editable;
   GtkExText *text;
   GdsEditor *gds_editor;
   gchar line_string[128];
   gint length;
   gint line;
   gint lines;
   gint col;
   gchar cur_char;

   if(cur_file != NULL)
   {
      editable = GTK_EDITABLE(cur_file->text);
      text = GTK_EXTEXT(cur_file->text);
      gds_editor = GDS_EDITOR(cur_file->text);
      col = text->line_cursor_index;
      pos = editable->current_pos;
      length = text->length;
      line = text->line_pos_index+1;
      lines = GTK_EXTEXT(cur_file->text)->line_count + 1;
      if(pos >= 0 && pos <= text->length && text->length > 0)
         cur_char = GTK_EXTEXT_INDEX(text, pos);
      else
         cur_char = 0;
      g_snprintf(line_string, sizeof(line_string), _("Line: %d / %d Col: %d Byte: %d / %d Value: %d"), line, lines, col, pos, length, cur_char);
      gtk_entry_set_text(GTK_ENTRY(cur_file->file_data), line_string);

      if(pos > 0)
      {
         cur_char = GTK_EXTEXT_INDEX(text, pos-1);
         if(cur_char < 1 || !strchr("<{[()]}>", cur_char) || length < 1)
            gtk_widget_set_sensitive(search_menu_match, FALSE);
         else
            gtk_widget_set_sensitive(search_menu_match, TRUE);
      }
      else
         gtk_widget_set_sensitive(search_menu_match, FALSE);
      
      if(GDS_EDITOR(cur_file->text)->changed && !cur_file->changed_set)
      {
         gchar *str;
         gchar *changed;
         if((str = strrchr(cur_file->filename, '/')) != NULL) { str++; } else { str = cur_file->filename; }
         changed = g_strconcat(str, " *", NULL);
         cur_file->changed_set = TRUE;
         gds_file_set_title(cur_file, changed, general_preferences.full_filenames);
         gtk_signal_connect(GTK_OBJECT(cur_file->menu_item), "activate", GTK_SIGNAL_FUNC(gds_file_focus_with_raise), cur_file);
         g_free(changed);
      }
      else if(!GDS_EDITOR(cur_file->text)->changed && cur_file->changed_set)
      {
         cur_file->changed_set = FALSE;
         gds_file_set_title(cur_file, cur_file->filename, general_preferences.full_filenames);
         gtk_signal_connect(GTK_OBJECT(cur_file->menu_item), "activate", GTK_SIGNAL_FUNC(gds_file_focus_with_raise), cur_file);
      }
   }
}

void undo_changed(GtkWidget *widget, GdsFile *gds_file)
{
   if(gtk_extext_undo_is_empty(GTK_EXTEXT(gds_file->text)))
   {
      gtk_widget_set_sensitive(edit_menu_undo, FALSE);
      gtk_widget_set_sensitive(editbar_undo, FALSE);
   }
   else
   {
      gtk_widget_set_sensitive(edit_menu_undo, TRUE);
      gtk_widget_set_sensitive(editbar_undo, TRUE);
   }
   if(gtk_extext_redo_is_empty(GTK_EXTEXT(gds_file->text)))
   {
      gtk_widget_set_sensitive(edit_menu_redo, FALSE);
      gtk_widget_set_sensitive(editbar_redo, FALSE);
   }
   else
   {
      gtk_widget_set_sensitive(edit_menu_redo, TRUE);
      gtk_widget_set_sensitive(editbar_redo, TRUE);
   }
   gtk_signal_emit_by_name(GTK_OBJECT(gds_file->text), "move_to_column", 0);
}
