#include <gdk/gdkprivate.h>
#include "declarations.h"
#include "dragndrop.h"
#include "session-management.h"
#include "macro-language.h"
#include "commandbar.h"
#include "findbar.h"
#include "linebar.h"
#include "highlightbar.h"
#include "view.h"
#include "signals.h"
#include "xpm/bookmark.xpm"

GtkWidget *app;
GtkWidget *window;
GtkWidget *appbar;
GtkWidget *whole_window_box;
GtkWidget *main_window_box;
GtkWidget *box;
GtkWidget *switch_label;
GtkWidget *paned;
GtkWidget *edit_box;
GtkWidget *files_book;
GtkWidget *file_selector;
GtkStyle *extext_style = NULL;
GtkAccelGroup *accel_group;
GdkPixmap *bookmark_pixmap;
GdkBitmap *bookmark_bitmap;
GList *files_list = NULL;
GdsFile *cur_file = NULL;
gint cur_page = -1;
gint total_files = 0;
static gchar *input_file = NULL, *input_session = NULL;
gint line = 0;

poptContext pctx;
gchar** args;

struct poptOption options[] =
{
   { 
      "session", 's', POPT_ARG_STRING, &input_session,
       0, N_("Specify the session file to use."), NULL
   },
   {
      "file", 'f', POPT_ARG_STRING, &input_file,
      0, N_("Open a specific file."), NULL
   },
   {
      "line", 'l', POPT_ARG_INT, &line,
      0, N_("Jump to a line in the file specified by -f."),
      NULL
   },
   {
      NULL, '\0', 0, NULL, 0, NULL, NULL
   }
};

int main(int argc, char *argv[])
{
   GtkWidget *text_widget;
   GtkWidget *win;
   GtkWidget *menu;
   GdkFont *font;
   directory_check();

#ifdef ENABLE_NLS
   bindtextdomain(PACKAGE, GNOMELOCALEDIR);
   textdomain(PACKAGE);
#endif

   gnome_init_with_popt_table(PACKAGE, PACKAGE " v" VERSION, argc, argv, options, 0, &pctx);
   get_prefs();
   app = gnome_app_new(PACKAGE, VERSION);
   gtk_container_set_border_width(GTK_CONTAINER(app), 0);
   gtk_window_set_policy(GTK_WINDOW(app), TRUE, TRUE, FALSE);
   gtk_signal_connect(GTK_OBJECT(app), "focus_in_event", GTK_SIGNAL_FUNC(main_window_focused), NULL);
   gtk_signal_connect(GTK_OBJECT(app), "delete_event", GTK_SIGNAL_FUNC(pre_exit), NULL);
   window = app;
   
   appbar = gnome_appbar_new(FALSE, TRUE, GNOME_PREFERENCES_ALWAYS);
   gnome_appbar_set_default(GNOME_APPBAR(appbar), "Ready.");
   gnome_app_set_statusbar(GNOME_APP(app), appbar);
   gtk_widget_show(appbar);

   make_menus();
   make_toolbars();
   make_command_combo();
   make_find_toolbar();
   make_line_toolbar();
   init_session_management();
   init_dnd();

   menu = build_highlight_menu();
   make_highlight_bar(menu);

   whole_window_box = gtk_vbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(whole_window_box), 0);
   gnome_app_set_contents(GNOME_APP(window), whole_window_box);
   gtk_widget_show(whole_window_box);

   main_window_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(main_window_box), 0);
   gtk_box_pack_start(GTK_BOX(whole_window_box), main_window_box, TRUE, TRUE, 0);
   gtk_widget_show(main_window_box);

   edit_box = gtk_hbox_new(FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(edit_box), 0);
   gtk_container_add(GTK_CONTAINER(main_window_box), edit_box);
   gtk_widget_set_usize(GTK_WIDGET(edit_box), 610, 400);
   gtk_widget_show(edit_box);

   files_book = gtk_notebook_new();
   gtk_box_pack_end(GTK_BOX(edit_box), files_book, TRUE, TRUE, 0);
   gtk_notebook_set_scrollable(GTK_NOTEBOOK(files_book), TRUE);
   gtk_notebook_popup_enable(GTK_NOTEBOOK(files_book));
   gtk_signal_connect(GTK_OBJECT(files_book), "switch_page", GTK_SIGNAL_FUNC(set_notebook_page), NULL);  
   gtk_widget_show(files_book);
   if(general_preferences.notebook_tab_position >= 4)
   {
      gtk_notebook_set_show_tabs(GTK_NOTEBOOK(files_book), FALSE);
   }
   else
   {
      gtk_notebook_set_show_tabs(GTK_NOTEBOOK(files_book), TRUE);
      gtk_notebook_set_tab_pos(GTK_NOTEBOOK(files_book), (GtkPositionType) general_preferences.notebook_tab_position);
   }

   /* This is a way ugly hack */
   win = gtk_window_new(GTK_WINDOW_DIALOG);   
   text_widget = gtk_text_new(0, 0);
   gtk_container_add(GTK_CONTAINER(win), text_widget);
   gtk_widget_realize(text_widget);
   extext_style = gtk_style_copy(gtk_widget_get_style(text_widget));
   gtk_style_ref(extext_style);

   if(!general_preferences.use_gtk_theme)
   {
      extext_style->text[GTK_STATE_NORMAL] = general_preferences.fg;
      extext_style->bg[GTK_STATE_NORMAL] = general_preferences.bg;
      extext_style->bg[GTK_STATE_PRELIGHT] = general_preferences.bm_bg;
      extext_style->bg[GTK_STATE_SELECTED] = general_preferences.s_bg;
      HighlightCache.colors[DEFAULT] = general_preferences.fg;
      if(strlen(general_preferences.pixmap_name))
      {
         general_preferences.bg_pixmap = (GnomePixmap *)gnome_pixmap_new_from_file(general_preferences.pixmap_name);
         if(general_preferences.bg_pixmap) extext_style->bg_pixmap[GTK_STATE_NORMAL] = general_preferences.bg_pixmap->pixmap;
      }
      else
         extext_style->bg_pixmap[GTK_STATE_NORMAL] = NULL;
   }
   gtk_style_attach(extext_style, text_widget->window);
   gtk_widget_destroy(win);

   if((font = gdk_font_load(general_preferences.font_name)))
   {
      gdk_font_unref(extext_style->font);
      g_print("Loading font from preferences.\n");
      extext_style->font = font;
      general_preferences.font = font;
      gdk_font_ref(extext_style->font);
   }
   else if((font = gdk_font_load(default_preferences.font_name)))
   {
      gdk_font_unref(extext_style->font);
      g_print("Loading font from default style.\n");
      extext_style->font = font;
      general_preferences.font = font;
      gdk_font_ref(extext_style->font);
   }
   else
   {
      g_print("Loading font from Gtk+ style.\n");
      general_preferences.font = extext_style->font;
      strcpy(general_preferences.font_name, "");
   }
   if((font = gdk_font_load(general_preferences.italic_name)))
   {
      g_print("Loading font from preferences.\n");
      general_preferences.italic = font;
      gdk_font_ref(general_preferences.italic);
   }
   else if((font = gdk_font_load(default_preferences.italic_name)))
   {
      g_print("Loading font from default style.\n");
      general_preferences.italic = font;
      gdk_font_ref(general_preferences.italic);
   }
   else
   {
      g_print("Loading font from Gtk+ style.\n");
      general_preferences.italic = extext_style->font;
      strcpy(general_preferences.italic_name, general_preferences.font_name);
      gdk_font_ref(general_preferences.italic);
   }
   if((font = gdk_font_load(general_preferences.bold_name)))
   {
      g_print("Loading font from preferences.\n");
      general_preferences.bold = font;
      gdk_font_ref(general_preferences.bold);
   }
   else if((font = gdk_font_load(default_preferences.bold_name)))
   {
      g_print("Loading font from default style.\n");
      general_preferences.bold = font;
      gdk_font_ref(general_preferences.bold);
   }
   else
   {
      g_print("Loading font from Gtk+ style.\n");
      general_preferences.bold = extext_style->font;
      strcpy(general_preferences.bold_name, general_preferences.font_name);
      gdk_font_ref(general_preferences.bold);
   }
   if((font = gdk_font_load(general_preferences.boldi_name)))
   {
      g_print("Loading font from preferences.\n");
      general_preferences.boldi = font;
      gdk_font_ref(general_preferences.boldi);
   }
   else if((font = gdk_font_load(default_preferences.boldi_name)))
   {
      g_print("Loading font from default style.\n");
      general_preferences.boldi = font;
      gdk_font_ref(general_preferences.boldi);
   }
   else
   {
      g_print("Loading font from Gtk+ style.\n");
      general_preferences.boldi = extext_style->font;
      strcpy(general_preferences.boldi_name, general_preferences.font_name);
      gdk_font_ref(general_preferences.boldi);
   }
   get_saved_colors();
   gds_file_set_global_props(general_preferences.undo_max, general_preferences.use_spaces ? general_preferences.spaces : 0, general_preferences.auto_indent, general_preferences.bracketmatch, general_preferences.tab_stops);

   // we need to initialize python
   initialize_macro_language(argc, argv);
   return(0);
}

void main_finish(void *closure, int argc, char *argv[])
{
   gint files_opened;
   args = (gchar **)poptGetArgs(pctx);

   build_scripts_menu();
   autoexec_script();
   if(input_session)
   {
      if(check_if_file_exists(input_session))
      {
         files_opened = open_session_from_file(input_session);
         if(files_opened)
         {
            gchar *path, *file, *full, cwd[256];
            g_free(session_file);
            getcwd(cwd, sizeof(cwd));
            path = get_path_from_filename(input_session);
            file = get_file_from_filename(input_session);
            if(!path) full = g_strconcat(cwd, "/", file, NULL);
            else full = g_strconcat(path, "/", file, NULL);
            g_free(path);
            g_free(file);
            session_file = full;
         }
         else
         {
            g_error("Session file: %s could not be opened, or contained no session data.\n", input_session);
         }
      }
   }
   if(input_file)
   {
      if(check_if_file_exists(input_file))
      {
         open_file_real(input_file);
         if(line <= GTK_EXTEXT(cur_file->text)->line_count && line > 0)
            gtk_extext_set_line(GTK_EXTEXT(cur_file->text), line);
      }
      else
      {
         g_error("File: %s could not be opened, or does not exist.\n", input_file);
      }
   }
   if(!g_list_length(files_list) && args)
   {
      int i = 0;
      while(args[i])
      {
         if(check_if_file_exists((gchar *)args[i]))
            open_file_real((gchar *)args[i]);
         i++;
      }
   }
   if(!g_list_length(files_list))
   {
      if(!get_last_session() && general_preferences.untitled)
         new_file_cb(NULL, NULL);
   }
   poptFreeContext(pctx);
   setup_recent_files_list(general_preferences.history);
   adjust_sensitivity();
   gtk_widget_show(window);
   bookmark_pixmap = gdk_pixmap_create_from_xpm_d(app->window, &bookmark_bitmap, NULL, bookmark_xpm);
   init_view_settings();
   if(general_preferences.geometry)
   {
      gdk_window_move_resize(window->window, general_preferences.x, general_preferences.y, general_preferences.w, general_preferences.h);
   }
   gtk_main();
   return;
}

void file_change(GtkWidget *widget, GdsFile *new_file)
{
   if(new_file)
   {
      if(!GDS_TEAR_AWAY(new_file->tear_away)->torn)
      {
         gint index, old_page;
         old_page = cur_page;
         index = get_nth_file_number(new_file);
         if(index == cur_page && cur_file != new_file)
            file_emit_scripting_signal("focus-out", cur_file);
         gtk_notebook_set_page(GTK_NOTEBOOK(files_book), index);
         if(cur_file != new_file)
         {
            cur_file = new_file;
         }
      }
      else
      {
         if(cur_file && cur_file != new_file)
         {
            file_emit_scripting_signal("focus-out", cur_file);
         }
         if(cur_file != new_file)
         {
            cur_file = new_file;
            file_emit_scripting_signal("focus-in", cur_file);
            app_emit_scripting_signal("change-file");
         }
         gtk_widget_grab_focus(cur_file->text);
      }
      if(cur_file->modtime > 0 && cur_file->modtime < get_time(cur_file->filename))
      {
         file_externally_modified_reload(cur_file->filename, cur_file, GTK_SIGNAL_FUNC(reload_file_cb), NULL);
         cur_file->modtime = get_time(cur_file->filename);
      }
   }
   else
   {
      if(cur_file) file_emit_scripting_signal("focus-out", cur_file);
      cur_file = new_file;
      app_emit_scripting_signal("change-file");
   }
   set_window_title();
   adjust_sensitivity();
   adjust_popup_menu();
}

void set_notebook_page(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer data)
{
   file_emit_scripting_signal("focus-out", cur_file);
   cur_page = page_num;
   cur_file = get_nth_file_proper(page_num);
   if(cur_file)
   {
      gtk_widget_grab_focus(cur_file->text);
      file_emit_scripting_signal("focus-in", cur_file);
      if(cur_file->modtime > 0 && cur_file->modtime < get_time(cur_file->filename))
      {
         file_externally_modified_reload(cur_file->filename, cur_file, GTK_SIGNAL_FUNC(reload_file_cb), NULL);
         cur_file->modtime = get_time(cur_file->filename);
      }
   }
   app_emit_scripting_signal("change-file");
   file_pos_changed(NULL, 0, NULL);
   set_window_title();
   adjust_sensitivity();   
   adjust_popup_menu();
}

void set_window_title(void)
{
   gchar *string;
   char buffer[512] = PACKAGE " v" VERSION;

   if(cur_file)
   {
      strcat(buffer, " Session: ");
      string =  get_file_from_filename(session_file);
      strcat(buffer, string);
      g_free(string);
      strcat(buffer, " File: ");
      if(general_preferences.full_filenames_title) string = g_strdup(cur_file->filename);
      else string = get_file_from_filename(cur_file->filename);
      strcat(buffer, string);
      g_free(string);
   }
   gtk_window_set_title(&GNOME_APP(window)->parent_object, buffer);

}

void adjust_sensitivity(void)
{
   GtkExText *text;
   GtkEditable *editable;
   gchar cur_char;
   GSList *cur = NULL;
   GtkWidget *w;
   gchar *filename;
   gchar *compare;
   GSList *first;
   gint counter = 0;

   if(cur_file != NULL)
   {
      editable = GTK_EDITABLE(cur_file->text);
      text = GTK_EXTEXT(cur_file->text);
      cur_char = GTK_EXTEXT_INDEX(text, editable->current_pos);

      gtk_widget_set_sensitive(file_menu_revert, TRUE);
      gtk_widget_set_sensitive(file_menu_close, TRUE);
      gtk_widget_set_sensitive(filebar_close, TRUE);   
      gtk_widget_set_sensitive(file_menu_close_all, TRUE);
      gtk_widget_set_sensitive(file_menu_save, TRUE);
      gtk_widget_set_sensitive(filebar_save, TRUE);   
      gtk_widget_set_sensitive(file_menu_saveas, TRUE);
      gtk_widget_set_sensitive(filebar_saveas, TRUE);
      gtk_widget_set_sensitive(file_menu_save_all, TRUE);

      gtk_widget_set_sensitive(editmenu, TRUE);
      gtk_widget_set_sensitive(searchmenu, TRUE);
      if(!text->read_only)
         gtk_widget_set_sensitive(insertmenutitle, TRUE);
      else
         gtk_widget_set_sensitive(insertmenutitle, FALSE);
      gtk_widget_set_sensitive(buildmenutitle, TRUE);

      gtk_widget_set_sensitive(editbar_cut, TRUE);
      gtk_widget_set_sensitive(editbar_copy, TRUE);
      gtk_widget_set_sensitive(editbar_paste, TRUE);
      gtk_widget_set_sensitive(editbar_properties, TRUE);

      gtk_signal_emit_by_name(GTK_OBJECT(cur_file->text), "undo_changed", cur_file);

      if(g_list_length(GTK_NOTEBOOK(files_book)->children) > 1)
      {
         int torn = 0;
         GdsFile *current;
         GList *temp;
         gtk_widget_set_sensitive(windows_menu_prev, TRUE);
         gtk_widget_set_sensitive(windows_menu_next, TRUE);
         for(temp = g_list_first(files_list); temp; temp = temp->next)
         {
            current = (GdsFile *)temp->data;
            if(GDS_TEAR_AWAY(current->tear_away)->torn)
               torn++;
         }
         if(!torn)
         {
            gtk_widget_set_sensitive(windows_menu_moveprev, TRUE);
            gtk_widget_set_sensitive(windows_menu_movenext, TRUE);
         }
         else
         {
            gtk_widget_set_sensitive(windows_menu_moveprev, FALSE);
            gtk_widget_set_sensitive(windows_menu_movenext, FALSE);
         }
      }
      else
      {
         gtk_widget_set_sensitive(windows_menu_prev, FALSE);
         gtk_widget_set_sensitive(windows_menu_next, FALSE);
         gtk_widget_set_sensitive(windows_menu_moveprev, FALSE);
         gtk_widget_set_sensitive(windows_menu_movenext, FALSE);
      }
      gtk_widget_set_sensitive(findbar, TRUE);
      gtk_widget_set_sensitive(buildbar, TRUE);
      set_build_sensitivity();
      gtk_widget_set_sensitive(highlightbar, TRUE);
      if(cur_file->tables && cur_file->tables->filename)
      {
         gtk_widget_set_sensitive(rehighlight_button, TRUE);
         compare = cur_file->tables->filename;
      }
      else
      {
         gtk_widget_set_sensitive(rehighlight_button, FALSE);
         compare = "none";
      }
      first = g_slist_copy(highlight_options);
      first = cur = g_slist_reverse(first);
      for(counter = 0; cur; cur = cur->next, counter++)
      {
         w = GTK_WIDGET(cur->data);
         filename = (gchar *)gtk_object_get_data(GTK_OBJECT(w), "filename");
         if(!strcmp(compare, filename))
         {
            GTK_CHECK_MENU_ITEM(w)->active = TRUE;
            gtk_option_menu_set_history(GTK_OPTION_MENU(highlightbar_option), counter);
            gtk_widget_queue_draw(w);
         }
         else
         {
            GTK_CHECK_MENU_ITEM(w)->active = FALSE;
         }
      }
      g_slist_free(first);
   }
   else
   {
      gtk_widget_set_sensitive(file_menu_revert, FALSE);
      gtk_widget_set_sensitive(file_menu_close, FALSE);
      gtk_widget_set_sensitive(file_menu_close_all, FALSE);
      gtk_widget_set_sensitive(filebar_close, FALSE);   
      gtk_widget_set_sensitive(file_menu_save, FALSE);
      gtk_widget_set_sensitive(filebar_save, FALSE);   
      gtk_widget_set_sensitive(file_menu_saveas, FALSE);
      gtk_widget_set_sensitive(filebar_saveas, FALSE);   
      gtk_widget_set_sensitive(file_menu_save_all, FALSE);
      
      gtk_widget_set_sensitive(editmenu, FALSE);
      gtk_widget_set_sensitive(searchmenu, FALSE);
      gtk_widget_set_sensitive(insertmenutitle, FALSE);
      gtk_widget_set_sensitive(buildmenutitle, FALSE);

      gtk_widget_set_sensitive(editbar_undo, FALSE);
      gtk_widget_set_sensitive(editbar_redo, FALSE);
      gtk_widget_set_sensitive(editbar_cut, FALSE);
      gtk_widget_set_sensitive(editbar_copy, FALSE);
      gtk_widget_set_sensitive(editbar_paste, FALSE);
      gtk_widget_set_sensitive(editbar_properties, FALSE);
      gtk_widget_set_sensitive(windows_menu_prev, FALSE);
      gtk_widget_set_sensitive(windows_menu_next, FALSE);
      gtk_widget_set_sensitive(findbar, FALSE);
      gtk_widget_set_sensitive(buildbar, FALSE);

      gtk_option_menu_set_history(GTK_OPTION_MENU(highlightbar_option), 0);
      gtk_widget_set_sensitive(highlightbar, FALSE);
   }
}

void directory_check(void)
{
   gchar buffer[384];
   gboolean exists;

   g_snprintf(buffer, sizeof(buffer), "%s/." PACKAGE "/session.last", getenv("HOME"));
   session_file = g_strdup(buffer);
   exists = check_if_file_exists(buffer);
   if(exists) return;
   g_snprintf(buffer, sizeof(buffer), "mkdir %s/." PACKAGE, getenv("HOME"));
   g_print(_("Creating ~/" PACKAGE " directory.\n"));
   system(buffer);

   g_snprintf(buffer, sizeof(buffer), "%s/." PACKAGE "/session.last", getenv("HOME"));
   g_print(_("Creating ~/." PACKAGE "/session.last file.\n"));
   file_create(NULL, buffer);

   g_snprintf(buffer, sizeof(buffer), "mkdir %s/." PACKAGE "/languages", getenv("HOME"));
   g_print(_("Creating ~/." PACKAGE "/languages directory.\n"));
   system(buffer);
   return;
}

void kill_widget(GtkWidget *widget, GtkWidget *target)
{
   gtk_widget_destroy(GTK_WIDGET(target));
}

void destroy(GtkWidget *widget, gpointer data)
{
   gtk_main_quit();
}

void pre_exit(GtkWidget *widget, gpointer data)
{
   if(general_preferences.save_session)
   {
      save_session_pref();
      save_session_cb(NULL, NULL);
   }
   try_exit(NULL, NULL);
}

void try_exit(GtkWidget *widget, gpointer data)
{
   GdsFile *file;
   gint i = 0;
   
   for(i = total_files-1; i >= 0; i--)
   {
      file = (GdsFile *)g_list_nth_data(files_list, i);
      if(gds_editor_changed(GDS_EDITOR(file->text)) && strstr(file->filename, "Untitled"))
      {
         gint val = 0;
         file_change(widget, file);
         val = file_not_saved_save_as(file->filename, file, NULL, NULL);
         if(val == 2 || val == -1)
            return;
      }
      else if(gds_editor_changed(GDS_EDITOR(file->text)))
      {
         file_not_saved(file->filename, file, NULL, NULL);
      }
      else
      {
         close_file_real(file);
      }
   }
   gtk_style_unref(extext_style);
   if(general_preferences.font) gdk_font_unref(general_preferences.font);
   if(general_preferences.italic) gdk_font_unref(general_preferences.italic);
   if(general_preferences.bold) gdk_font_unref(general_preferences.bold);
   if(general_preferences.boldi) gdk_font_unref(general_preferences.boldi);
   if(general_preferences.bg_pixmap) gtk_widget_destroy(GTK_WIDGET(general_preferences.bg_pixmap));
   g_free(last_dir);
   g_free(session_file);
   kill_old_recent_menu();
   if(general_preferences.save_toolbars) save_view_settings();
   if(general_preferences.geometry == 1)
   {
      gint x, y, w, h;
      gdk_window_get_geometry(window->window, NULL, NULL, &w, &h, NULL);
      gdk_window_get_position(window->window, &x, &y);
      gnome_config_set_int("/" PACKAGE "/Geometry/x", x);
      gnome_config_set_int("/" PACKAGE "/Geometry/y", y);
      gnome_config_set_int("/" PACKAGE "/Geometry/w", w);
      gnome_config_set_int("/" PACKAGE "/Geometry/h", h);
   }
   gnome_config_set_int("/" PACKAGE "/Find-Replace/case_sensitive", case_sensitive);
   gnome_config_set_int("/" PACKAGE "/Find-Replace/search_style", search_style);
   gnome_config_set_int("/" PACKAGE "/Find-Replace/search_start", search_start);
   gnome_config_set_int("/" PACKAGE "/Find-Replace/search_multi", search_multi);
   gnome_config_set_int("/" PACKAGE "/Find-Replace/keep_open", keep_open);
   gnome_config_sync();
   gtk_main_quit();
}

void main_window_focused(GtkWidget *widget, gpointer data)
{
   gint total_pages;
   GdsFile *new_file = NULL;
   total_pages = (gint)g_list_length(GTK_NOTEBOOK(files_book)->children); // max page number
   if(cur_page >= 0 && cur_page < total_pages-1)
   {
      new_file = get_nth_file_proper(cur_page);
      file_change(widget, new_file);
   }  
   else if(total_pages > 0)
   {
      new_file = get_nth_file_proper(total_pages-1);
      file_change(widget, new_file);
   }
}
