#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "declarations.h"
#include "insert.h"
#include "time.h"

void insert_date_time(GtkWidget *widget, gpointer data)
{
   char buffer[128];
   time_t cur_time;
   struct tm *time_ptr;
   GtkEditable *editable;
   editable = GTK_EDITABLE(cur_file->text);
   time(&cur_time);
   time_ptr = localtime(&cur_time);
   strftime(buffer, sizeof(buffer), "%a %b %d %X %Z %Y", time_ptr);
   gds_editor_insert_text(GDS_EDITOR(editable), buffer, strlen(buffer), (gint *)&editable->current_pos);
}

void insert_username(GtkWidget *widget, gpointer data)
{
   gchar *text;
   GtkEditable *editable;
   editable = GTK_EDITABLE(cur_file->text);
   text = g_new(char, strlen(getenv("USER"))+1);
   strcpy(text, getenv("USER"));
   gds_editor_insert_text(GDS_EDITOR(editable), text, strlen(text), (gint *)&editable->current_pos);
   g_free(text);
}

void insert_name(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;
   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), general_preferences.name, strlen(general_preferences.name), (gint *)&editable->current_pos);
}

void insert_email(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;
   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), general_preferences.email, strlen(general_preferences.email), (gint *)&editable->current_pos);
}

// C/C++ related tags

void insert_gpl_notice(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;

   gchar *gpl_notice =
   {
      "/*\n"
      " *  This program is free software; you can redistribute it and/or modify\n"
      " *  it under the terms of the GNU General Public License as published by\n"
      " *  the Free Software Foundation; either version 2 of the License, or\n"
      " *  (at your option) any later version.\n"
      " *\n"
      " *  This program is distributed in the hope that it will be useful,\n"
      " *  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
      " *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
      " *  GNU Library General Public License for more details.\n"
      " *\n"
      " *  You should have received a copy of the GNU General Public License\n"
      " *  along with this program; if not, write to the Free Software\n"
      " *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n"
      " */\n"
   };

   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), gpl_notice, strlen(gpl_notice), (gint *)&editable->current_pos);
}

void insert_gpl_noticepp(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;

   gchar gpl_notice[] =
   {
      "// This program is free software; you can redistribute it and/or modify\n"
      "// it under the terms of the GNU General Public License as published by\n"
      "// the Free Software Foundation; either version 2 of the License, or\n"
      "// (at your option) any later version.\n"
      "//\n"
      "// This program is distributed in the hope that it will be useful,\n"
      "// but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
      "// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
      "// GNU Library General Public License for more details.\n"
      "//\n"
      "// You should have received a copy of the GNU General Public License\n"
      "// along with this program; if not, write to the Free Software\n"
      "// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n"
      "\n"
   };

   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), gpl_notice, strlen(gpl_notice), (gint *)&editable->current_pos);
}

void insert_gpl_noticepython(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;

   gchar *gpl_notice =
   {
      "#\n"
      "# This program is free software; you can redistribute it and/or modify\n"
      "# it under the terms of the GNU General Public License as published by\n"
      "# the Free Software Foundation; either version 2 of the License, or\n"
      "# (at your option) any later version.\n"
      "#\n"
      "# This program is distributed in the hope that it will be useful,\n"
      "# but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
      "# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
      "# GNU Library General Public License for more details.\n"
      "#\n"
      "# You should have received a copy of the GNU General Public License\n"
      "# along with this program; if not, write to the Free Software\n"
      "# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n"
      "\n"
   };

   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), gpl_notice, strlen(gpl_notice), (gint *)&editable->current_pos);
}

void insert_changelog_string(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;
   gchar buffer[128];
   gchar *full;
   time_t cur_time;
   struct tm *time_ptr;

   editable = GTK_EDITABLE(cur_file->text);
   time(&cur_time);
   time_ptr = localtime(&cur_time);
   strftime(buffer, sizeof(buffer), "%a %b %d %X %Z %Y", time_ptr);
   full = g_strconcat(buffer, " ", general_preferences.name, " <", general_preferences.email, ">", NULL);
   if(full && strlen(full))
     gds_editor_insert_text(GDS_EDITOR(editable), full, strlen(full), (gint *)&editable->current_pos);
   g_free(full);
}

void insert_comment(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;
   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), "/*\n *\n */", 9, (gint *)&editable->current_pos);
}

void insert_commentpp(GtkWidget *widget, gpointer data)
{
   GtkEditable *editable;
   editable = GTK_EDITABLE(cur_file->text);
   gds_editor_insert_text(GDS_EDITOR(editable), "//", 2, (gint *)&editable->current_pos);
}

void insert_ascii_char_cb(GtkWidget *widget, gpointer data)
{
   GnomeAsciiList *ascii;
   widget = gnome_ascii_list_new();
   ascii = GNOME_ASCII_LIST(widget);
   gtk_signal_connect(GTK_OBJECT(ascii->insert_button), "clicked", GTK_SIGNAL_FUNC(insert_ascii_char), ascii);
   gtk_signal_connect_object(GTK_OBJECT(ascii->close_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(ascii));
   gtk_widget_show(widget);
}

void insert_ascii_char(GtkWidget *widget, GnomeAsciiList *ascii)
{
   gchar *text;
   if(!cur_file) return;
   text = gtk_entry_get_text(GTK_ENTRY(ascii->entry));
   gtk_editable_insert_text(GTK_EDITABLE(cur_file->text), text, strlen(text), (gint *)&GTK_EDITABLE(cur_file->text)->current_pos);
}

void insert_file_cb(GtkWidget *widget, gpointer data)
{
   file_selector = last_dir ? gnome_filelist_new_with_path(last_dir) : gnome_filelist_new_with_path(general_preferences.default_dir);
   gnome_filelist_set_title(GNOME_FILELIST(file_selector), _("Insert File..."));
   gtk_signal_connect(GTK_OBJECT(GNOME_FILELIST(file_selector)->ok_button), "clicked", GTK_SIGNAL_FUNC(insert_file_cb_continue), file_selector);
   gtk_signal_connect_object(GTK_OBJECT(GNOME_FILELIST(file_selector)->ok_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(file_selector));
   gtk_signal_connect_object(GTK_OBJECT(GNOME_FILELIST(file_selector)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(file_selector));
   gtk_widget_show(file_selector);
}

void insert_file_cb_continue(GtkWidget *widget, GnomeFileList *file_list)
{
   gchar *string;
   string = gnome_filelist_get_filename(GNOME_FILELIST(file_list));
   if(check_if_file_exists(string))
   {
      insert_file_real(string);
   }
   else
   {
      read_error(string);
   }
   g_free(string);
}

void insert_file_real(gchar *filename)
{
   gchar *temp = NULL;
   if(!cur_file) return;
   temp = get_path_from_filename(filename);
   if(temp && strcmp(filename, temp) != 0)
   {
      g_free(last_dir);
      last_dir = g_new(char, strlen(temp)+1);
      strcpy(last_dir, temp);
   }
   g_free(temp);
   open_file_add_text(cur_file->text, filename);
   adjust_sensitivity();
   display_message("File Inserted.", FLASH);
}

void runcmd_cb(GtkWidget *widget, gpointer data)
{
   g_return_if_fail(cur_file != NULL);
   widget = gnome_run_cmd_new("Run Command...", "Command: ");
   gtk_signal_connect(GTK_OBJECT(GNOME_RUN_CMD(widget)->run_button), "clicked", GTK_SIGNAL_FUNC(exec_command_cb), widget);
   gtk_signal_connect_object(GTK_OBJECT(GNOME_RUN_CMD(widget)->run_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
   gtk_signal_connect_object(GTK_OBJECT(GNOME_RUN_CMD(widget)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
   gnome_run_cmd_set_history(GNOME_RUN_CMD(widget), build_glist_from_file("run.hist", general_preferences.history));
   gtk_widget_show(widget);
   gtk_widget_grab_focus(GNOME_RUN_CMD(widget)->entry);
}

void exec_command_cb(GtkWidget *widget, GnomeRunCmd *grc)
{
   gchar *string;
   FILE *exec;
   GtkEditable *editable;
   gchar output[384];

   g_return_if_fail(cur_file != NULL);
   if(g_list_index(files_list, (gpointer)cur_file)<0) return;
   editable = GTK_EDITABLE(cur_file->text);
   string = gtk_entry_get_text(GTK_ENTRY(grc->entry));
   add_string_to_file("run.hist", string);

   if(!(exec = popen(string, "r")))
   {
      perror("Error opening process!");
      generic_dialog_with_text("Process could not be opened.");
      g_print("\a");
      return;
   }
   gtk_extext_freeze(GTK_EXTEXT(cur_file->text));
   while(fgets(output, sizeof(output), exec))
   {
      gtk_editable_insert_text(editable, output, strlen(output), (gint *)&editable->current_pos);
      while(gtk_events_pending()) gtk_main_iteration();
   }
   gtk_extext_thaw(GTK_EXTEXT(cur_file->text));
   pclose(exec);
}

void indent_cb(GtkWidget *widget, gpointer data)
{
   g_return_if_fail(cur_file != NULL);
   widget = gnome_run_cmd_new("Indent...", "Indent: ");
   gtk_signal_connect(GTK_OBJECT(GNOME_RUN_CMD(widget)->run_button), "clicked", GTK_SIGNAL_FUNC(exec_indent_command_cb), widget);
   gtk_signal_connect_object(GTK_OBJECT(GNOME_RUN_CMD(widget)->run_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
   gtk_signal_connect_object(GTK_OBJECT(GNOME_RUN_CMD(widget)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(widget));
   gnome_run_cmd_set_history(GNOME_RUN_CMD(widget), build_glist_from_file("indent.hist", general_preferences.history));
   gtk_widget_show(widget);
   gtk_widget_grab_focus(GNOME_RUN_CMD(widget)->entry);
}

void exec_indent_command_cb(GtkWidget *widget, GnomeRunCmd *grc)
{
   gchar *string;
   FILE *exec;
   FILE *file;
   gchar temp_file[256];
   gchar *full_string;
   GtkEditable *editable;
   gint start;
   gint end;
   gchar *text;
   g_return_if_fail(cur_file != NULL);
   editable = GTK_EDITABLE(cur_file->text);
   string = gtk_entry_get_text(GTK_ENTRY(grc->entry));
   add_string_to_file("indent.hist", string);

   g_snprintf(temp_file, sizeof(temp_file), "%s/." PACKAGE "/%s", getenv("HOME"), "indent.x");
   file = fopen(temp_file, "w");
   if(!file) return;
   start = 0;
   end = GTK_EXTEXT(cur_file->text)->length;
   if(editable->has_selection)
   {
      start = editable->selection_start_pos;
      end = editable->selection_end_pos;
   }
   text = gtk_editable_get_chars(editable, start, end);
   if(text) fputs(text, file);
   fclose(file);
   g_free(text);
   full_string = g_strconcat("indent ", string, " ", temp_file, NULL);
   if(!(exec = popen(full_string, "r")))
   {
      perror("Error opening process!");
      generic_dialog_with_text("Indent process could not be opened.");
      g_print("\a");
      g_free(full_string);
      return;
   }
   g_free(full_string);
   pclose(exec);
   gtk_extext_freeze(GTK_EXTEXT(cur_file->text));
   gtk_editable_delete_text(editable, start, end);
   gtk_extext_set_position(editable, start);
   open_file_add_text(cur_file->text, temp_file);
   remove(temp_file);
   gtk_extext_thaw(GTK_EXTEXT(cur_file->text));
}
