#include "declarations.h"
#include "commandbar.h"

void reverse_bookmark_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GdkPixmap *pixmap;
   gint line;
   text = GTK_EXTEXT(cur_file->text);
   line = gtk_extext_get_line(text);
   pixmap = gtk_extext_get_line_pixmap(text, line);
   if(pixmap == NULL)
   {
      gtk_extext_set_line_pixmap(text, line, bookmark_pixmap, bookmark_bitmap);
      gtk_widget_queue_draw(cur_file->text);
   }
   else if(pixmap == bookmark_pixmap)
   {
      gtk_extext_set_line_pixmap(text, line, NULL, NULL);
      gtk_widget_queue_draw(cur_file->text);
   }
}

void undo_last_cb(GtkWidget *widget, gpointer data)
{
   undo_last_real(cur_file);
}

void undo_last_real(GdsFile *file)
{
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = (GtkEditable *)file->text;
   editable->has_selection = FALSE;
   (gint)editable->selection_start_pos = -1;
   (gint)editable->selection_end_pos = -1;
   gtk_extext_undo(GTK_EXTEXT(file->text));
   GDS_EDITOR(file->text)->changed -= 2;
   gtk_signal_emit_by_name(GTK_OBJECT(file->text), "move_to_column", 0, NULL);
}

void redo_last_cb(GtkWidget *widget, gpointer data)
{
   redo_last_real(cur_file);
}

void redo_last_real(GdsFile *file)
{
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = (GtkEditable *)file->text;
   editable->has_selection = FALSE;
   (gint)editable->selection_start_pos = -1;
   (gint)editable->selection_end_pos = -1;
   gtk_extext_redo(GTK_EXTEXT(file->text));
   gtk_signal_emit_by_name(GTK_OBJECT(file->text), "move_to_column", 0, NULL);
}

void cut_text_cb(GtkWidget *widget, gpointer data)
{
   cut_text_real(cur_file);
}

void cut_text_real(GdsFile *file)
{
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = (GtkEditable *)file->text;
   gtk_editable_cut_clipboard(editable);
   editable->has_selection = FALSE;
   (gint)editable->selection_start_pos = -1;
   (gint)editable->selection_end_pos = -1;
}

void copy_text_cb(GtkWidget *widget, gpointer data)
{
   copy_text_real(cur_file);
}

void copy_text_real(GdsFile *file)
{
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = (GtkEditable *)file->text;
   gtk_editable_copy_clipboard(editable);
}

void paste_text_cb(GtkWidget *widget, gpointer data)
{
   paste_text_real(cur_file);
}

void paste_text_real(GdsFile *file)
{
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = (GtkEditable *)file->text;
   gtk_editable_paste_clipboard(editable);
   editable->has_selection = FALSE;
   (gint)editable->selection_start_pos = -1;
   (gint)editable->selection_end_pos = -1;
}

void clear_text_cb(GtkWidget *widget, gpointer data)
{
   g_return_if_fail(cur_file);
   clear_text_real(cur_file);
}

void clear_text_real(GdsFile *file)
{
   gint start, end;
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = GTK_EDITABLE(file->text);
   if(editable->has_selection)
   {
      start = editable->selection_start_pos;
      end = editable->selection_end_pos;
      gtk_editable_delete_text(editable, start, end);
   }
   else
   {
      select_all_text_real(file);
      start = editable->selection_start_pos;
      end = editable->selection_end_pos;
      gtk_editable_delete_text(editable, start, end);
   }
}

void clear_line_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_pos_index, text->scroll_line_start);
   if(linedata)
   {
      gds_editor_delete_text(GDS_EDITOR(text), linedata->startpos, linedata->endpos);
   }
   g_free(linedata);
}

void clear_end_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_pos_index, text->scroll_line_start);
   if(linedata)
   {
      gds_editor_delete_text(GDS_EDITOR(text), GTK_EDITABLE(text)->current_pos, linedata->endpos);
   }
   g_free(linedata);
}

void clear_start_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_pos_index, text->scroll_line_start);
   if(linedata)
   {
      gds_editor_delete_text(GDS_EDITOR(text), linedata->startpos, GTK_EDITABLE(text)->current_pos);
   }
   g_free(linedata);
}

void clear_entry_real(void)
{
   GtkEntry *entry;
   entry = GTK_ENTRY(macro_entry);
   gtk_entry_set_text(entry, "");
}

void select_line_cb(GtkWidget *widget, gpointer data)
{
   GtkExText *text;
   GtkExTextLineData *linedata;
   g_return_if_fail(cur_file);
   text = GTK_EXTEXT(cur_file->text);
   linedata = gtk_extext_get_line_data(text, text->line_pos_index, text->scroll_line_start);
   if(linedata && linedata->startpos < linedata->endpos)
   {
      gtk_editable_select_region(GTK_EDITABLE(text), linedata->startpos, linedata->endpos);
   }
   g_free(linedata);
}

void select_current_cb(GtkWidget *widget, gpointer data)
{
   select_current_real(cur_file);
}

void select_current_real(GdsFile *file)
{
   gint start, end;
   GtkEditable *editable;
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));

   editable = GTK_EDITABLE(file->text);
   start = gtk_editable_get_position(editable);
   if(gtk_extext_get_current_word(GTK_EXTEXT(editable), &start, &end))
      gtk_editable_select_region(editable, start, end);
}

void select_all_text_cb(GtkWidget *widget, gpointer data)
{
   select_all_text_real(cur_file);
}

void select_all_text_real(GdsFile *file)
{
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));
   gtk_editable_select_region(GTK_EDITABLE(file->text), 0, gtk_extext_get_length(GTK_EXTEXT(file->text)));
}

void highlight_syntax_cb(GtkWidget *widget, gpointer data)
{
   highlight_syntax_real(cur_file);
}

void highlight_syntax_real(GdsFile *file)
{
   g_return_if_fail(file != NULL);
   g_return_if_fail(GDS_IS_FILE(file));
   gds_editor_highlight(GDS_EDITOR(file->text));
}

void reparse_highlight_table_cb(GtkWidget *widget, gpointer data)
{
   g_return_if_fail(cur_file != NULL);
   reparse_highlight_table(cur_file->tables);      
}
