#include "declarations.h"
#include "dragndrop.h"

static void dnd_drop(GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, gpointer data);

enum { TARGET_URI_LIST };
static GtkTargetEntry drop_types[] =
{
   { "text/uri-list", 0, TARGET_URI_LIST }
};
static gint n_drop_types = sizeof(drop_types) / sizeof(drop_types[0]);

void init_dnd(void)
{
   gtk_drag_dest_set(window, (GtkDestDefaults) (GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP), drop_types, n_drop_types, GDK_ACTION_COPY);
   gtk_signal_connect(GTK_OBJECT(window), "drag_data_received", GTK_SIGNAL_FUNC(dnd_drop), 0);
}

static void dnd_drop(GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *selection_data, guint info, guint time, gpointer data)
{
   GList *names, *list;
   gchar *string;
   if(info == TARGET_URI_LIST)
   {
      list = gnome_uri_list_extract_filenames((gchar *)selection_data->data);
      for(names = list; names; names = names->next)
      {
         string = (gchar *)names->data;
         if(check_if_file_exists(string))
         {
            open_file_real((gchar *)names->data);
         }
         else
         {
            read_error(string);
         }
      }
      gnome_uri_list_free_strings(list);
   }
}
